

app.controller('CadastroFunCtrl', function($rootScope, $location, $scope, $http, $window, $routeParams)
{


    /*-------INICIALIZAÇÃO-------*/
    var aj = $http;
    var ng = $scope;
    var wi = $window;
    var rp = $routeParams;
    var rs = $rootScope;
    var lo = $location;
    var arr_path = lo.path().split("/");
    ng.id_cliente = rp.id;
    rs.activetab = '/cadastro';
    ng.pagina = 'Funcionários';
    if(arr_path[3] == 'editar'){
        ng.titulo = "Edita Funcionário";
    }else if(arr_path[3] == 'novo'){
        ng.titulo = "Cadastro Funcionário";
    }


    var init = function(){
        if(ng.id_cliente >= 0){
            aj.get('core/obj/funcionario.php?id='+rp.id).success(function(data){
                ng.cadastro = data[0];
            });
        }else{
            ng.cadastro = {"id":0,
                "nome":"",
                "login":"",
                "senha":"",
                "cpf":"",
                "nascimento":"",
                "rg":"",
                "bairro":"",
                "logradouro":"",
                "cep":"",
                "uf":"",
                "localidade":"",
                "numero":"",
                "complemento":"",
                "fixo":"",
                "celular":"",
                "email":""
            };
        }
        ng.cpfvalido = true;
    };

    init();

    /*--------FIM INICIALIZAÇÃO--------*/







    /*---------CADASTRO-----------*/

    ng.validaCPF = function(cpf){
        if(cpf.length > 0) {
            exp = /\.|-/g;
            cpf = cpf.toString().replace(exp, "");
            var digitoDigitado = eval(cpf.charAt(9) + cpf.charAt(10));
            var soma1 = 0, soma2 = 0;
            var vlr = 11;
            for (i = 0; i < 9; i++) {
                soma1 += eval(cpf.charAt(i) * (vlr - 1));
                soma2 += eval(cpf.charAt(i) * vlr);
                vlr--;
            }
            soma1 = (((soma1 * 10) % 11) == 10 ? 0 : ((soma1 * 10) % 11));
            soma2 = (((soma2 + (2 * soma1)) * 10) % 11);

            if (cpf == "11111111111" || cpf == "22222222222" || cpf == "33333333333" || cpf == "44444444444" || cpf == "55555555555" || cpf == "66666666666" || cpf == "77777777777" || cpf == "88888888888" || cpf == "99999999999" || cpf == "00000000000") {
                var digitoGerado = null;
            } else {
                var digitoGerado = (soma1 * 10) + soma2;
            }

            if (digitoGerado != digitoDigitado) {
                msgErro("CPF Inválido!");
                return ng.cpfvalido = false;
            }
            msgSucesso("CPF Válido!");
            return ng.cpfvalido = true;
        }else{
            return ng.cpfvalido = true;
        }
    };



    ng.salvaCad = function(){
        if(ng.cpfvalido && ng.cnpjvalido){
            if(ng.cadastro.id > 0){
                aj.post('core/obj/'+rp.tipo+'.php', ng.cadastro).success(function(data){
                    if(data.erro == 0){
                        if(data.erro == 0){
                            msgSucesso("Cadastro Salvo com Sucessoa! ");
                        }else{
                            msgErro("Cadastro Não foi salvo!");
                        }
                    }
                });
            } else {
                if(rp.id){
                    ng.cadastro.id = rp.id;
                }else{
                    ng.cadastro.id = 0;
                }
                aj.post('core/obj/'+rp.tipo+'.php', ng.cadastro).success(function(data){
                    if(data.erro != 0){
                        msgSucesso("Cadastro Salvo com Sucesso! ");
                        lo.path('/cadastro/'+rp.tipo+'/editar/'+data.id);
                    }else{
                        msgErro("Cadastro Não foi salvo!");
                    }
                });
            }

        }else{
            msgErro("Cadastro Não foi salvo!");
            if(!ng.cpfvalido){
                msgErro("CPF Inválido!");
            }
            if(!ng.cnpjvalido){
                msgErro("CNPJ Inválido!");
            }
        }

    };


    $scope.open = function($event) {
        $event.preventDefault();
        $event.stopPropagation();

        $scope.opened = true;
    };


    /*--------FIM CADASTRO--------*/




    /*---------ENDERECO-----------*/


    ng.busca = function (cep) {
        if(cep.length == 8){
            aj.get('//cep.correiocontrol.com.br/'+cep+'.json').success(function(data){
                ng.endereco.cep = data.cep;
                ng.endereco.uf = data.uf;
                ng.endereco.bairro = data.bairro;
                ng.endereco.localidade = data.localidade;
                ng.endereco.logradouro = data.logradouro;
            });
        }
    };
});

