/**
 * jQuery.ScrollTo - Easy element scrolling using jQuery.
 * Copyright (c) 2007-2009 Ariel Flesler - aflesler(at)gmail(dot)com | http://flesler.blogspot.com
 * Dual licensed under MIT and GPL.
 * Date: 5/25/2009
 * @author Ariel Flesler
 * @version 1.4.2
 *
 * http://flesler.blogspot.com/2007/10/jqueryscrollto.html
 */
;(function(d){var k=d.scrollTo=function(a,i,e){d(window).scrollTo(a,i,e)};k.defaults={axis:'xy',duration:parseFloat(d.fn.jquery)>=1.3?0:1};k.window=function(a){return d(window)._scrollable()};d.fn._scrollable=function(){return this.map(function(){var a=this,i=!a.nodeName||d.inArray(a.nodeName.toLowerCase(),['iframe','#document','html','body'])!=-1;if(!i)return a;var e=(a.contentWindow||a).document||a.ownerDocument||a;return d.browser.safari||e.compatMode=='BackCompat'?e.body:e.documentElement})};d.fn.scrollTo=function(n,j,b){if(typeof j=='object'){b=j;j=0}if(typeof b=='function')b={onAfter:b};if(n=='max')n=9e9;b=d.extend({},k.defaults,b);j=j||b.speed||b.duration;b.queue=b.queue&&b.axis.length>1;if(b.queue)j/=2;b.offset=p(b.offset);b.over=p(b.over);return this._scrollable().each(function(){var q=this,r=d(q),f=n,s,g={},u=r.is('html,body');switch(typeof f){case'number':case'string':if(/^([+-]=)?\d+(\.\d+)?(px|%)?$/.test(f)){f=p(f);break}f=d(f,this);case'object':if(f.is||f.style)s=(f=d(f)).offset()}d.each(b.axis.split(''),function(a,i){var e=i=='x'?'Left':'Top',h=e.toLowerCase(),c='scroll'+e,l=q[c],m=k.max(q,i);if(s){g[c]=s[h]+(u?0:l-r.offset()[h]);if(b.margin){g[c]-=parseInt(f.css('margin'+e))||0;g[c]-=parseInt(f.css('border'+e+'Width'))||0}g[c]+=b.offset[h]||0;if(b.over[h])g[c]+=f[i=='x'?'width':'height']()*b.over[h]}else{var o=f[h];g[c]=o.slice&&o.slice(-1)=='%'?parseFloat(o)/100*m:o}if(/^\d+$/.test(g[c]))g[c]=g[c]<=0?0:Math.min(g[c],m);if(!a&&b.queue){if(l!=g[c])t(b.onAfterFirst);delete g[c]}});t(b.onAfter);function t(a){r.animate(g,j,b.easing,a&&function(){a.call(this,n,b)})}}).end()};k.max=function(a,i){var e=i=='x'?'Width':'Height',h='scroll'+e;if(!d(a).is('html,body'))return a[h]-d(a)[e.toLowerCase()]();var c='client'+e,l=a.ownerDocument.documentElement,m=a.ownerDocument.body;return Math.max(l[h],m[h])-Math.min(l[c],m[c])};function p(a){return typeof a=='object'?a:{top:a,left:a}}})(jQuery);;
/*	SWFObject v2.2 <http://code.google.com/p/swfobject/> 
	is released under the MIT License <http://www.opensource.org/licenses/mit-license.php> 
*/
var swfobject=function(){var D="undefined",r="object",S="Shockwave Flash",W="ShockwaveFlash.ShockwaveFlash",q="application/x-shockwave-flash",R="SWFObjectExprInst",x="onreadystatechange",O=window,j=document,t=navigator,T=false,U=[h],o=[],N=[],I=[],l,Q,E,B,J=false,a=false,n,G,m=true,M=function(){var aa=typeof j.getElementById!=D&&typeof j.getElementsByTagName!=D&&typeof j.createElement!=D,ah=t.userAgent.toLowerCase(),Y=t.platform.toLowerCase(),ae=Y?/win/.test(Y):/win/.test(ah),ac=Y?/mac/.test(Y):/mac/.test(ah),af=/webkit/.test(ah)?parseFloat(ah.replace(/^.*webkit\/(\d+(\.\d+)?).*$/,"$1")):false,X=!+"\v1",ag=[0,0,0],ab=null;if(typeof t.plugins!=D&&typeof t.plugins[S]==r){ab=t.plugins[S].description;if(ab&&!(typeof t.mimeTypes!=D&&t.mimeTypes[q]&&!t.mimeTypes[q].enabledPlugin)){T=true;X=false;ab=ab.replace(/^.*\s+(\S+\s+\S+$)/,"$1");ag[0]=parseInt(ab.replace(/^(.*)\..*$/,"$1"),10);ag[1]=parseInt(ab.replace(/^.*\.(.*)\s.*$/,"$1"),10);ag[2]=/[a-zA-Z]/.test(ab)?parseInt(ab.replace(/^.*[a-zA-Z]+(.*)$/,"$1"),10):0}}else{if(typeof O.ActiveXObject!=D){try{var ad=new ActiveXObject(W);if(ad){ab=ad.GetVariable("$version");if(ab){X=true;ab=ab.split(" ")[1].split(",");ag=[parseInt(ab[0],10),parseInt(ab[1],10),parseInt(ab[2],10)]}}}catch(Z){}}}return{w3:aa,pv:ag,wk:af,ie:X,win:ae,mac:ac}}(),k=function(){if(!M.w3){return}if((typeof j.readyState!=D&&j.readyState=="complete")||(typeof j.readyState==D&&(j.getElementsByTagName("body")[0]||j.body))){f()}if(!J){if(typeof j.addEventListener!=D){j.addEventListener("DOMContentLoaded",f,false)}if(M.ie&&M.win){j.attachEvent(x,function(){if(j.readyState=="complete"){j.detachEvent(x,arguments.callee);f()}});if(O==top){(function(){if(J){return}try{j.documentElement.doScroll("left")}catch(X){setTimeout(arguments.callee,0);return}f()})()}}if(M.wk){(function(){if(J){return}if(!/loaded|complete/.test(j.readyState)){setTimeout(arguments.callee,0);return}f()})()}s(f)}}();function f(){if(J){return}try{var Z=j.getElementsByTagName("body")[0].appendChild(C("span"));Z.parentNode.removeChild(Z)}catch(aa){return}J=true;var X=U.length;for(var Y=0;Y<X;Y++){U[Y]()}}function K(X){if(J){X()}else{U[U.length]=X}}function s(Y){if(typeof O.addEventListener!=D){O.addEventListener("load",Y,false)}else{if(typeof j.addEventListener!=D){j.addEventListener("load",Y,false)}else{if(typeof O.attachEvent!=D){i(O,"onload",Y)}else{if(typeof O.onload=="function"){var X=O.onload;O.onload=function(){X();Y()}}else{O.onload=Y}}}}}function h(){if(T){V()}else{H()}}function V(){var X=j.getElementsByTagName("body")[0];var aa=C(r);aa.setAttribute("type",q);var Z=X.appendChild(aa);if(Z){var Y=0;(function(){if(typeof Z.GetVariable!=D){var ab=Z.GetVariable("$version");if(ab){ab=ab.split(" ")[1].split(",");M.pv=[parseInt(ab[0],10),parseInt(ab[1],10),parseInt(ab[2],10)]}}else{if(Y<10){Y++;setTimeout(arguments.callee,10);return}}X.removeChild(aa);Z=null;H()})()}else{H()}}function H(){var ag=o.length;if(ag>0){for(var af=0;af<ag;af++){var Y=o[af].id;var ab=o[af].callbackFn;var aa={success:false,id:Y};if(M.pv[0]>0){var ae=c(Y);if(ae){if(F(o[af].swfVersion)&&!(M.wk&&M.wk<312)){w(Y,true);if(ab){aa.success=true;aa.ref=z(Y);ab(aa)}}else{if(o[af].expressInstall&&A()){var ai={};ai.data=o[af].expressInstall;ai.width=ae.getAttribute("width")||"0";ai.height=ae.getAttribute("height")||"0";if(ae.getAttribute("class")){ai.styleclass=ae.getAttribute("class")}if(ae.getAttribute("align")){ai.align=ae.getAttribute("align")}var ah={};var X=ae.getElementsByTagName("param");var ac=X.length;for(var ad=0;ad<ac;ad++){if(X[ad].getAttribute("name").toLowerCase()!="movie"){ah[X[ad].getAttribute("name")]=X[ad].getAttribute("value")}}P(ai,ah,Y,ab)}else{p(ae);if(ab){ab(aa)}}}}}else{w(Y,true);if(ab){var Z=z(Y);if(Z&&typeof Z.SetVariable!=D){aa.success=true;aa.ref=Z}ab(aa)}}}}}function z(aa){var X=null;var Y=c(aa);if(Y&&Y.nodeName=="OBJECT"){if(typeof Y.SetVariable!=D){X=Y}else{var Z=Y.getElementsByTagName(r)[0];if(Z){X=Z}}}return X}function A(){return !a&&F("6.0.65")&&(M.win||M.mac)&&!(M.wk&&M.wk<312)}function P(aa,ab,X,Z){a=true;E=Z||null;B={success:false,id:X};var ae=c(X);if(ae){if(ae.nodeName=="OBJECT"){l=g(ae);Q=null}else{l=ae;Q=X}aa.id=R;if(typeof aa.width==D||(!/%$/.test(aa.width)&&parseInt(aa.width,10)<310)){aa.width="310"}if(typeof aa.height==D||(!/%$/.test(aa.height)&&parseInt(aa.height,10)<137)){aa.height="137"}j.title=j.title.slice(0,47)+" - Flash Player Installation";var ad=M.ie&&M.win?"ActiveX":"PlugIn",ac="MMredirectURL="+O.location.toString().replace(/&/g,"%26")+"&MMplayerType="+ad+"&MMdoctitle="+j.title;if(typeof ab.flashvars!=D){ab.flashvars+="&"+ac}else{ab.flashvars=ac}if(M.ie&&M.win&&ae.readyState!=4){var Y=C("div");X+="SWFObjectNew";Y.setAttribute("id",X);ae.parentNode.insertBefore(Y,ae);ae.style.display="none";(function(){if(ae.readyState==4){ae.parentNode.removeChild(ae)}else{setTimeout(arguments.callee,10)}})()}u(aa,ab,X)}}function p(Y){if(M.ie&&M.win&&Y.readyState!=4){var X=C("div");Y.parentNode.insertBefore(X,Y);X.parentNode.replaceChild(g(Y),X);Y.style.display="none";(function(){if(Y.readyState==4){Y.parentNode.removeChild(Y)}else{setTimeout(arguments.callee,10)}})()}else{Y.parentNode.replaceChild(g(Y),Y)}}function g(ab){var aa=C("div");if(M.win&&M.ie){aa.innerHTML=ab.innerHTML}else{var Y=ab.getElementsByTagName(r)[0];if(Y){var ad=Y.childNodes;if(ad){var X=ad.length;for(var Z=0;Z<X;Z++){if(!(ad[Z].nodeType==1&&ad[Z].nodeName=="PARAM")&&!(ad[Z].nodeType==8)){aa.appendChild(ad[Z].cloneNode(true))}}}}}return aa}function u(ai,ag,Y){var X,aa=c(Y);if(M.wk&&M.wk<312){return X}if(aa){if(typeof ai.id==D){ai.id=Y}if(M.ie&&M.win){var ah="";for(var ae in ai){if(ai[ae]!=Object.prototype[ae]){if(ae.toLowerCase()=="data"){ag.movie=ai[ae]}else{if(ae.toLowerCase()=="styleclass"){ah+=' class="'+ai[ae]+'"'}else{if(ae.toLowerCase()!="classid"){ah+=" "+ae+'="'+ai[ae]+'"'}}}}}var af="";for(var ad in ag){if(ag[ad]!=Object.prototype[ad]){af+='<param name="'+ad+'" value="'+ag[ad]+'" />'}}aa.outerHTML='<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"'+ah+">"+af+"</object>";N[N.length]=ai.id;X=c(ai.id)}else{var Z=C(r);Z.setAttribute("type",q);for(var ac in ai){if(ai[ac]!=Object.prototype[ac]){if(ac.toLowerCase()=="styleclass"){Z.setAttribute("class",ai[ac])}else{if(ac.toLowerCase()!="classid"){Z.setAttribute(ac,ai[ac])}}}}for(var ab in ag){if(ag[ab]!=Object.prototype[ab]&&ab.toLowerCase()!="movie"){e(Z,ab,ag[ab])}}aa.parentNode.replaceChild(Z,aa);X=Z}}return X}function e(Z,X,Y){var aa=C("param");aa.setAttribute("name",X);aa.setAttribute("value",Y);Z.appendChild(aa)}function y(Y){var X=c(Y);if(X&&X.nodeName=="OBJECT"){if(M.ie&&M.win){X.style.display="none";(function(){if(X.readyState==4){b(Y)}else{setTimeout(arguments.callee,10)}})()}else{X.parentNode.removeChild(X)}}}function b(Z){var Y=c(Z);if(Y){for(var X in Y){if(typeof Y[X]=="function"){Y[X]=null}}Y.parentNode.removeChild(Y)}}function c(Z){var X=null;try{X=j.getElementById(Z)}catch(Y){}return X}function C(X){return j.createElement(X)}function i(Z,X,Y){Z.attachEvent(X,Y);I[I.length]=[Z,X,Y]}function F(Z){var Y=M.pv,X=Z.split(".");X[0]=parseInt(X[0],10);X[1]=parseInt(X[1],10)||0;X[2]=parseInt(X[2],10)||0;return(Y[0]>X[0]||(Y[0]==X[0]&&Y[1]>X[1])||(Y[0]==X[0]&&Y[1]==X[1]&&Y[2]>=X[2]))?true:false}function v(ac,Y,ad,ab){if(M.ie&&M.mac){return}var aa=j.getElementsByTagName("head")[0];if(!aa){return}var X=(ad&&typeof ad=="string")?ad:"screen";if(ab){n=null;G=null}if(!n||G!=X){var Z=C("style");Z.setAttribute("type","text/css");Z.setAttribute("media",X);n=aa.appendChild(Z);if(M.ie&&M.win&&typeof j.styleSheets!=D&&j.styleSheets.length>0){n=j.styleSheets[j.styleSheets.length-1]}G=X}if(M.ie&&M.win){if(n&&typeof n.addRule==r){n.addRule(ac,Y)}}else{if(n&&typeof j.createTextNode!=D){n.appendChild(j.createTextNode(ac+" {"+Y+"}"))}}}function w(Z,X){if(!m){return}var Y=X?"visible":"hidden";if(J&&c(Z)){c(Z).style.visibility=Y}else{v("#"+Z,"visibility:"+Y)}}function L(Y){var Z=/[\\\"<>\.;]/;var X=Z.exec(Y)!=null;return X&&typeof encodeURIComponent!=D?encodeURIComponent(Y):Y}var d=function(){if(M.ie&&M.win){window.attachEvent("onunload",function(){var ac=I.length;for(var ab=0;ab<ac;ab++){I[ab][0].detachEvent(I[ab][1],I[ab][2])}var Z=N.length;for(var aa=0;aa<Z;aa++){y(N[aa])}for(var Y in M){M[Y]=null}M=null;for(var X in swfobject){swfobject[X]=null}swfobject=null})}}();return{registerObject:function(ab,X,aa,Z){if(M.w3&&ab&&X){var Y={};Y.id=ab;Y.swfVersion=X;Y.expressInstall=aa;Y.callbackFn=Z;o[o.length]=Y;w(ab,false)}else{if(Z){Z({success:false,id:ab})}}},getObjectById:function(X){if(M.w3){return z(X)}},embedSWF:function(ab,ah,ae,ag,Y,aa,Z,ad,af,ac){var X={success:false,id:ah};if(M.w3&&!(M.wk&&M.wk<312)&&ab&&ah&&ae&&ag&&Y){w(ah,false);K(function(){ae+="";ag+="";var aj={};if(af&&typeof af===r){for(var al in af){aj[al]=af[al]}}aj.data=ab;aj.width=ae;aj.height=ag;var am={};if(ad&&typeof ad===r){for(var ak in ad){am[ak]=ad[ak]}}if(Z&&typeof Z===r){for(var ai in Z){if(typeof am.flashvars!=D){am.flashvars+="&"+ai+"="+Z[ai]}else{am.flashvars=ai+"="+Z[ai]}}}if(F(Y)){var an=u(aj,am,ah);if(aj.id==ah){w(ah,true)}X.success=true;X.ref=an}else{if(aa&&A()){aj.data=aa;P(aj,am,ah,ac);return}else{w(ah,true)}}if(ac){ac(X)}})}else{if(ac){ac(X)}}},switchOffAutoHideShow:function(){m=false},ua:M,getFlashPlayerVersion:function(){return{major:M.pv[0],minor:M.pv[1],release:M.pv[2]}},hasFlashPlayerVersion:F,createSWF:function(Z,Y,X){if(M.w3){return u(Z,Y,X)}else{return undefined}},showExpressInstall:function(Z,aa,X,Y){if(M.w3&&A()){P(Z,aa,X,Y)}},removeSWF:function(X){if(M.w3){y(X)}},createCSS:function(aa,Z,Y,X){if(M.w3){v(aa,Z,Y,X)}},addDomLoadEvent:K,addLoadEvent:s,getQueryParamValue:function(aa){var Z=j.location.search||j.location.hash;if(Z){if(/\?/.test(Z)){Z=Z.split("?")[1]}if(aa==null){return L(Z)}var Y=Z.split("&");for(var X=0;X<Y.length;X++){if(Y[X].substring(0,Y[X].indexOf("="))==aa){return L(Y[X].substring((Y[X].indexOf("=")+1)))}}}return""},expressInstallCallback:function(){if(a){var X=c(R);if(X&&l){X.parentNode.replaceChild(l,X);if(Q){w(Q,true);if(M.ie&&M.win){l.style.display="block"}}if(E){E(B)}}a=false}}}}();;
var orw = {};
(function($) {
	/**
	 * Slider constructor
	 * The slider is used to implement slideshows
	 * 
	 * @param DOMElement element
	 */
	var slider = function(element){
		//members init
		var _this = this;
		var element = $(element);
		var controlId = element.attr('id') + '-' + 'control';
		var arrowsId = element.attr('id') + '-' + 'arrow-';
		var subElements = element.find('li');
		var currentSubElement = subElements.first();
		subElements.filter(':not(:first-child)').hide();
		/*subElements.filter(':not(:first-child)').css({
			opacity: 0,
			display: "none"
		});*/
		/**
		 * Go to the next slide
		 * 
		 * @param DOMEvent event
		 */
		this.next = function(event){
			if(event){
				event.preventDefault();
				clearInterval(_this.interval);
			}
			var candidate = currentSubElement.next('li');
			if(candidate.length === 0){
				candidate = currentSubElement.parent('ul').find('li').first();
			}
			_this.swap(candidate);
		};
		/**
		 * Go the the previous slide
		 * 
		 * @param DOMEvent event
		 */
		this.prev = function(event){
			if(event){
				event.preventDefault();
				clearInterval(_this.interval);
			}
			var candidate = currentSubElement.prev('li');
			if(candidate.length === 0){
				candidate = currentSubElement.parent('ul').find('li').last();
			}
			_this.swap(candidate);
		};
		/**
		 * Go to a specified slide (determined by the provided event)
		 * 
		 * @param DOMEvent event
		 */
		this.scrollTo = function(event){
			if(event.preventDefault){
				event.preventDefault();
				clearInterval(_this.interval);
			}
			if(!$(this).parent('li').hasClass('active')){
				var offset = $(this).attr('href').split('-').pop();
				var targetSubElement = subElements.eq(offset);
				$('#' + controlId).find('li.active').removeClass('active');
				$(this).parent('li').addClass('active');
				_this.swap(targetSubElement);
			}
		};
		/**
		 * Swap the slide from the current one to the targeted one
		 * 
		 * @param DOMElement target
		 */
		this.swap = function(target){
			var currentSubElementId = currentSubElement.attr('id');
			target.fadeIn(2000,function(){
				$(this).addClass('active');
				$('li','#'+controlId).removeClass('active');
				$('li:eq('+$(this).index()+')','#'+controlId).addClass('active');
			});
			currentSubElement.fadeOut(2000,function(){
				$(this).removeClass('active');
			});
			target.animate({
				opacity: 1
			}, 1000);
			currentSubElement = target;
		};
		/**
		 * Initialize the slider
		 */
		this.init = function(){
			if(subElements.length > 1){
				var controlWrapper = $('<div>').attr('id', controlId);
				var control = $('<ul>');
				subElements.each(function(offset, subElement){
					var triggerLink = $('<a>').attr('href', '#slider-' + offset).html($('<span>').html(offset));
					triggerLink.click(_this.scrollTo);
					var trigger = $('<li>').append(triggerLink);
					control.append(trigger);
				});
				control.find('li').first().addClass('active');
				controlWrapper.append(control);
				element.after(controlWrapper);
				var leftArrow = $('<a>').attr('id', arrowsId + 'left').attr('href', '#previous').html($('<span>').html('prev'));
				leftArrow.click(_this.prev);
				var rightArrow = $('<a>').attr('id', arrowsId + 'right').attr('href', '#next').html($('<span>').html('next'));
				rightArrow.click(_this.next);
				element.before(leftArrow);
				element.before(rightArrow);
				setTimeout(function(){
					_this.interval = setInterval(function(){
						_this.next(null);
					}, 5000);
				}, 5000);
			}
		};
		this.init();
	};
	/**
	 * Namespace in jQuery
	 */
	$.fn.slider = function(){
       return this.each(function(){
           var sliderInstance = new slider(this);
       });
	};
	//MENU
	/**
	 * Menu constructor
	 * Main orw menu
	 * 
	 * @param DOMElement element
	 */
	var menu = function(element){
		//members init
		var _this = this;
		var element = $(element);
		/**
		 * Show submenu
		 * 
		 * @param DOMEvent event
		 */
		this.on = function(event){
			var subMenu = $(this).find('.sub-menu');
			subMenu.show();
		};
		/**
		 * Hide submenu
		 * 
		 * @param DOMEvent event
		 */
		this.off = function(event){
			var subMenu = $(this).find('.sub-menu');
			subMenu.hide();
		};
		/**
		 * Initialize the menu
		 */
		this.init = function(){
			element.find('li').hover(
				_this.on,
				_this.off
			);
		};
		this.init();
	};
	/**
	 * Namespace in jQuery
	 */
	$.fn.menu = function(){
       return this.each(function(){
           var menuInstance = new menu(this);
       });
	};
	//ACTIVITY FILTER
	/**
	 * Activity filter constructor
	 * Used to filter the activities view
	 * 
	 * @param DOMElement element
	 * @param DOMElement viewElement
	 */
	var activityFilter = function(element, viewElement){
		//members init
		var _this = this;
		var element = $(element);
		var viewElement = $(viewElement);
		/**
		 * Submit the form
		 */
		this.submit = function(){
			element.find('input[type=submit]').click();
		};
		/**
		 * Observe the form change and submit the form
		 */
		this.handleSubmit = function(){
			// @see http://docs.jquery.com/Ajax_Events
			$("#page-title").bind("ajaxSend", function(event){
				$(this).css({
					'background': 'url(' + Drupal.settings.basePath + 'sites/all/themes/torw/img/ajax-loader.gif) no-repeat right top'
				});
				$(this).bind("ajaxComplete", function(){
					$('#views-activities-pager-bottom a').click(function(event){
						$.scrollTo($("#breadcrumb"), 200, {easing: 'swing'});
					});
					$(this).css('background', 'none');
					$('.activity-sample-player').mp3Player();
				});
			});
            element.find('.views-submit-button').hide();
            element.change(function(event){
                _this.submit();
            });
		};
		/**
		 * Observe the sort controls
		 */
		this.handleSort = function(){
			var sortBy = element.find('select[name=sort_by]');
			var sortOrder = element.find('select[name=sort_order]');
			sortBy.parents('div.views-exposed-widget').hide();
			sortOrder.parents('div.views-exposed-widget').hide();
			viewElement.find('.result-sort li a').live('click', function(event){
				event.preventDefault();
				var currentValue = sortBy.val();
				var optionValue = $(this).attr('id').split('-').pop();
				var option = element.find('option[value=' + optionValue + ']');
				if(optionValue === currentValue){
					if(sortOrder.val() === 'ASC'){
						sortOrder.val('DESC');
					}
					else{
						sortOrder.val('ASC');
					}
				}
				else{
					option.parent('select').val(optionValue);
				}
				_this.submit();
			});
		};
		/**
		 * Handle date pickers
		 */
		this.handleDatePickers = function(){
			$('.form-type-date-popup').each(function(offset, container){
				var input = $(container).find('input');
				var trigger = $('<a>').attr('href', '#').attr('class', 'date-picker-trigger').append('Calendrier');
				input.after(trigger);
				trigger.click(function(event){
					event.preventDefault();
					input.focus();
				});
			});
		};
        this.handleSeasons = function() {
            $('#block-views-exp-activities-page .form-item-season input').change(function(event){
                event.preventDefault();
                event.stopPropagation();

                if (!$('#past-activities-checkbox').attr('checked')) {
                    $('#past-activities-checkbox').attr('checked', true);
                    $('#smart-past-activities-checkbox').toggleClass('smart-checkbox-on smart-checkbox-off');
                }
                $('#past-activities-checkbox').change();
            });
        };
        this.handlePastActivities = function() {
            if($('#edit-past-activities-value-datepicker-popup-1').val() == '') {
                $('#edit-past-activities-value-datepicker-popup-1').val($('#past-activities-checkbox').val());
                _this.submit();
            }
            $('#past-activities-checkbox').change(function(event){
                event.preventDefault();
                event.stopPropagation();
                 if ($(this).attr('checked')) {
                     $('#edit-past-activities-value-datepicker-popup-1').val('2010-01-01');
                 } else {
                     $('#edit-past-activities-value-datepicker-popup-1').val($(this).val());
                 }
                 _this.submit();
             });
         };
		/**
		 * Initialize the activity filter
		 */
        this.init = function(){
            _this.handleSubmit();
            _this.handleSort();
            _this.handleDatePickers();
            _this.handleSeasons();
            _this.handlePastActivities();
        };
		this.init();
	};
	/**
	 * Namespace in jQuery
	 */
	$.fn.activityFilter = function(viewElement){
		return this.each(function(){
			var activityFilterInstance = new activityFilter(this, viewElement);
		});
	};
	//SMART FORM
	/**
	 * Smart form constructor
	 * Custom-styled form
	 * 
	 * @param DOMElement element
	 */
	var smartForm = function(element){
		//members init
		var _this = this;
		var element = $(element);
		/**
		 * Handle click events for smart checkboxes
		 * 
		 * @param DOMEvent
		 */
		this.checkboxHandler = function(event){
			event.preventDefault();
			event.stopPropagation();
			var triggeredControl = $(this).next('input[type=checkbox]');
			triggeredControl.attr('checked', !triggeredControl.attr('checked'));
			$(this).toggleClass('smart-checkbox-on smart-checkbox-off');
			triggeredControl.change();
		};
		/**
		 * Handle click events for smart radios
		 * 
		 * @param DOMEvent
		 */
		this.radioHandler = function(event){
			event.preventDefault();
			event.stopPropagation();
			var triggeredControl = $(this).next('input[type=radio]');
			if(!triggeredControl.attr('checked')){
				var inputsTodisable = $('input[name=' + triggeredControl.attr('name') + ']');
				inputsTodisable.attr('checked', false);
				inputsTodisable.prev('a').removeClass('smart-radio-on').addClass('smart-radio-off');
				triggeredControl.attr('checked', true);
				$(this).toggleClass('smart-radio-on smart-radio-off');
				triggeredControl.change();
			}
		};
		/**
		 * Transform radio and checkbox controls into "smart" controls
		 * 
		 * @param string type
		 * @param function clickHandler
		 */
		this.transformControls = function(type, clickHandler){
			var controls = element.find('input[type=' + type + ']');
			controls.each(function(offset, control){
				var trigger = $('<a>').addClass('smart-control').addClass('smart-' + type).attr('id', 'smart-' + $(control).attr('id')).attr('href', '#');
				if($(control).attr('checked')){
					trigger.addClass('smart-' + type + '-on');
				}
				else{
					trigger.addClass('smart-' + type + '-off');
				}
				$(control).hide();
				$(control).before(trigger);
				trigger.click(clickHandler);
				trigger.siblings('label').click(function(event){
					event.preventDefault();
					trigger.click();
				});
			});
		};
		/**
		 * Style checkboxes
		 */
		this.transformCheckboxes = function(){
			_this.transformControls('checkbox', _this.checkboxHandler);
		};
		/**
		 * Style radios
		 */
		this.transformRadios = function(){
			_this.transformControls('radio', _this.radioHandler);
		};
		/**
		 * Multi checkbox dropdowns
		 */
		this.transformSmartdrops = function(){
			var smartdrops = element.find('div.smartdrop');
			smartdrops.each(function(offset, smartdrop){
				var checkboxes = $(smartdrop).find('div').first();
				checkboxes.hide();
				var control = $('<span>').addClass('smartdrop-control');
				var controlTrigger = $('<a>').attr('href', '#').html(Drupal.t('Choose'));
				controlTrigger.click(function(event){
					$(this).parent('span').toggleClass('smartdrop-control-on');
					event.preventDefault();
					checkboxes.toggle();
				});
				control.append(controlTrigger);
				$(smartdrop).prepend(control);
			});
		};
		/**
		 * Initialize the smart form
		 */
		this.init = function(){
			_this.transformCheckboxes();
			_this.transformRadios();
			_this.transformSmartdrops();
		};
		this.init();
	};
	/**
	 * Namespace in jQuery
	 */
	$.fn.smartForm = function(){
		return this.each(function(){
			var smartFormInstance = new smartForm(this);
		});
	};
	//BOOKING TABLE
	/**
	 * Handle the booking table
	 * 
	 * @param DOMElement element
	 */
	var bookingTable = function(element){
		//members init
		var _this = this;
		var element = $(element);
		var sections = element.find('div.rate');
		/**
		 * Generate and handle rate tabs
		 */
		this.tab = function(){
			var tabs = $('<ul>').addClass('tabs');
			sections.each(function(offset, section){
				var heading = $(section).find('h2');
				var trigger = $('<a>').attr('href', $(section).attr('id')).html(heading.html());
				heading.hide();
				trigger.click(function(event){
					event.preventDefault();
					_this.switchTo($(this).attr('href'));
				});
				var tab = $('<li>').attr('id', 'trigger-' + $(section).attr('id')).append(trigger);
				tabs.append(tab);
			});
			element.prepend(tabs);
		};
		/**
		 * Switch to default tab
		 */
		this.switchToDefault = function(){
			_this.switchTo($('ul.tabs li:first-child a').attr('href'));
		};
		/**
		 * Switch to the provided tab
		 * @param DOMElement tab
		 */
		this.switchTo = function(tab){
			sections.not('#' + tab).removeClass('rate-active').hide();
			$('#' + tab).addClass('rate-active').show();
			var parentControl = $('li a[href=' + tab + ']').parent('li');
			parentControl.addClass('active');
			parentControl.siblings().removeClass('active');
		};
		/**
		 * Observe cells (hover events)
		 */
		this.handleCells = function(){
			sections.find('td:not(.disabled)').hover(
				function(event){
					$(this).parent('tr').addClass('on');
					$(this).addClass('on');
					var benefits = $(this).parent('tr').find('th div');
					var top = $(this).position().top + $(this).height() / 2 - benefits.height() / 2;
					benefits.css('top', top + 'px').show();
				},
				function(event){
					$(this).parent('tr').removeClass('on');
					$(this).removeClass('on');
					$(this).parent('tr').find('th div').hide();
				}
			);
		};
		/**
		 * Resize the rate sections for more consistency
		 */
		this.resize = function(){
			var sectionMaxHeight = 0;
			sections.each(function(offset, section){
				var sectionHeight = $(section).height();
				if(sectionHeight > sectionMaxHeight){
					sectionMaxHeight = sectionHeight;
				}
			});
			sections.css('height', sectionMaxHeight + 'px');
		};
		/**
		 * Expand the provided table sections
		 * 
		 * @param jQuery triggers
		 */
		this.expand = function(triggers){
			triggers.each(function(offset, trigger){
				var target = $('#' + $(trigger).attr('href'));
				$(trigger).removeClass('collapsed');
				target.show();
			});
		};
		/**
		 * Collapse the provided table sections
		 * 
		 * @param jQuery triggers
		 */
		this.collapse = function(triggers){
			triggers.each(function(offset, trigger){
				var target = $('#' + $(trigger).attr('href'));
				$(trigger).addClass('collapsed');
				target.hide();
			});
		};
		/**
		 * Handle the expand / collapse behaviour for the table sections
		 */
		this.expandCollapse = function(){
			var triggers = element.find('thead th.type a');
			triggers.click(function(event){
				event.preventDefault();
				if($(this).hasClass('collapsed')){
					_this.expand($(this));
				}
				else{
					_this.collapse($(this));
				}
			});
		};
		/**
		 * Handle rate or type arguments in the url
		 */
		this.handleArguments = function(){
            var activeTables = $('table.booking-table.active');
            var activeType;
            if(activeTables.length === 0){
                activeType = 'booking-table-subscriptions';
            }
            else{
                activeType = $(activeTables[0]).attr('class').split(' ').pop();
            }
            _this.collapse($('table.booking-table th.type a:not(.' + activeType + ')'));
            _this.expand($('table.booking-table th.type a.' + activeType + ''));
            var activeRates = $('.rate.active');
            if(activeRates.length === 0){
                _this.switchToDefault();
            }
            else{
                var activeRateIdParts = $(activeRates[0]).attr('id').split('-');
                activeRateIdParts.shift();
                _this.switchTo('rate-' + activeRateIdParts.join('-'));
			}
		};
        this.handleSoldOuts = function() {
            $('td a.sold-out').click(function(event){
                event.preventDefault();
                alert(Drupal.t('This is sold out !'));
            });
        };
		/**
		 * Initialize the booking table
		 */
		this.init = function(){
			_this.handleCells();
			_this.tab();
			_this.expandCollapse();
			//_this.resize();
			_this.handleArguments();
            _this.handleSoldOuts();
		};
		this.init();
	};
	/**
	 * Namespace in jQuery
	 */
	$.fn.bookingTable = function(){
		return this.each(function(){
			var bookingTableInstance = new bookingTable(this);
		});
	};
	//MEDIA TABS
	/**
	 * Handle the activity media tabs
	 * 
	 * @param DOMElement tab1
	 * @param DOMElement tab2
	 */
	var mediaTabs = function(tab1, tab2){
		//members init
		var _this = this;
		var tab1 = $(tab1);
		var tab2 = $(tab2);
		var tabControl = $('<ul>').attr('id', 'media-thumbs-tab-control');
		if(tab1.length){
			tabControl.append($('<li>').attr('id', 'control-' + tab1.attr('id')).append($('<a>').attr('href', '#' + tab1.attr('id')).html(tab1.find('h3').html())));
		}
		if(tab2.length){
			tabControl.append($('<li>').attr('id', 'control-' + tab2.attr('id')).append($('<a>').attr('href', '#' + tab2.attr('id')).html(tab2.find('h3').html())));
		}
		
		tabControl.find('a').click(function(event){
			event.preventDefault();
			$(this).parent('li').siblings().find('a').each(function(offset, trigger){
				$($(trigger).attr('href')).hide(); 
				$(trigger).parent('li').addClass('off');
				$(trigger).addClass('off');
			});
			$($(this).attr('href')).show();
			$(this).parent('li').removeClass('off');
			$(this).removeClass('off');
		});
		tab1.find('h3').remove();
		tab2.find('h3').remove();
		var activeTab;
		if(tab1.length){
			tab2.hide();
			tab1.before(tabControl);
			$('#control-block-views-medias-current-videos').addClass('off').css('margin-left', '-1px');
			$('#control-block-views-medias-current-videos a').addClass('off');
		}
		else{
			tab2.before(tabControl);
		}
		
	};
	/**
	 * Namespace in jQuery
	 */
	$.fn.mediaTabs = function(tab1, tab2){
		return new mediaTabs(tab1, tab2);
	};
	//ACTIVITY CALENDAR
	/**
	 * Handle the activity calendar
	 * 
	 * @param DOMelement calendar
	 */
	var activityCalendar = function(element){
		//members init
		var element = $(element);
		var _this = this;
		this.switchTo = function(month){
			$('a[href=' + month + ']').parent('li').siblings().addClass('off').removeClass('on');
			$('a[href=' + month + ']').parent('li').removeClass('off').addClass('on');
			$('#' + month).addClass('on').removeClass('off').show();
			$('#' + month).siblings('div').addClass('off').removeClass('on').hide();
		};
		this.initTabs = function(){
			var firstMonth = element.find('ul.calendar-tabs li:first-child a');
			_this.switchTo(firstMonth.attr('href'));
			element.find('ul.calendar-tabs li a').click(function(event){
				event.preventDefault();
				_this.switchTo($(this).attr('href'));
			});
		};
		this.initForm = function(){
			var form = $('<form>').addClass('smartform');
			form.append($('<div>').addClass('views-exposed-widget').append($('<div>').addClass('views-widget')));
			//Places smart dropdown
			var placesList = element.find('#calendar-places');
			var placesSelect = $('<div>').addClass('smartdrop').append($('<div>').addClass('bef-checkboxes'));
			placesList.find('li').each(function(offset, placeItem){
				var code = $(placeItem).attr('id').split('-').pop();
				var input = $('<input>').attr('id', code).attr('type', 'checkbox').attr('value', code).attr('checked', true);
				var label = $('<label>').addClass('option').attr('for', code).html($(placeItem).html());
				placesSelect.find('.bef-checkboxes').append($('<div>').attr('id', 'form-item-' + code).addClass('form-item').append(input).append(label));
			});
			form.find('.views-widget').append(placesSelect);
			//Times radio button
			var timesList = element.find('#calendar-times');
			var timesSelect = $('<div>').append($('<div>').addClass('bef-checkboxes'));
			timesList.find('li').each(function(offset, timeItem){
				var code = $(timeItem).attr('id').split('-').pop();
				var input = $('<input>').attr('id', code).attr('type', 'checkbox').attr('value', code).attr('checked', true);
				var label = $('<label>').attr('for', code).html($(timeItem).html());
				timesSelect.find('.bef-checkboxes').append($('<div>').attr('id', 'form-item-' + code).addClass('form-item').append(input).append(label));
			});
			form.find('.views-widget').append(timesSelect);
			timesList.hide();
			placesList.hide();
			form.change(function(event){
				event.preventDefault();
				var containers = element.find('.bef-checkboxes');
				element.find('li.event').removeClass('event-filtered');
				containers.each(function(offset, container){
					var inputs = $(container).find('input');
					var classes = [];
					inputs.each(function(offset, input){
						if($(input).attr('checked')){
							classes.push('.event-' + $(input).attr('id'));
						}
					});
					if(classes.length > 0){
						element.find('li.event').not(classes.join(', ')).addClass('event-filtered');
					}
				});
				var unfiltered = element.find('div.on').find('.event').not('.event-filtered');
				if(unfiltered.length === 0){
					var alternateMonth = element.find('ul.calendar-tabs li.off a').first().attr('href');
					_this.switchTo(alternateMonth);
				}
			});
			form.smartForm();
			element.find('#calendar-performances').after(form);
		};
		this.init = function(){
			_this.initTabs();
			_this.initForm();
		};
		this.init();
	};
	/**
	 * Namespace in jQuery
	 */
	$.fn.activityCalendar = function(){
		return this.each(function(){
			new activityCalendar(this);
		});
	};
	//SUBSCRIBE FORM
	/**
	 * Handle the subscribe form
	 * 
	 * @param DOMElement element
	 */
	var subscribeForm = function(element){
		//members init
		var _this = this;
		var element = $(element);
		element.find('div.special-offers div.offer .trigger-quantity').keypress(function(event){
			var key = event.which;
			if(key !== 0 && key !== 8 && (key < 46 || key > 57)){
				event.preventDefault();
			}
		});
		element.find('div.special-offers div.offer .trigger').change(function(event){
			var offer = $(this).parents('.offer');
			var category = offer.find('.trigger-category');
			var categoryUnitPrice = parseFloat($('#' + category.attr('id') + '-' + category.val()).val()).toFixed(2);
			var quantity = parseFloat(offer.find('.trigger-quantity').val());
			var totalPrice = (categoryUnitPrice * quantity).toFixed(2);
			offer.find('.value-price').html(categoryUnitPrice);
			offer.find('.value-total').html(totalPrice);
		});
		element.find('.booking-choice-list li').click(function(event){
			event.preventDefault();
			event.stopPropagation();
			$(this).find('.smart-control').click();
		});
	};
	/**
	 * Namespace in jQuery
	 */
	$.fn.subscribeForm = function(){
		return this.each(function(){
			new subscribeForm(this);
		});
	};
	/**
	 * External links
	 * 
	 * Namespace in jQuery
	 */
	$.fn.externalLinks = function(){
		return this.each(function(){
			$(this).click(function(event){
				event.preventDefault();
				window.open($(this).attr('href'));
			});
		});
	};
	
	var mp3Player = function(element){
		//members init
		var _this = this;
		var element = $(element);
		
		this.init = function(){
			if(!window.playerStarted){
				window.playerStarted = function(playerId){
					var players = $('.mp3-player-started');
					players.each(function(offset, player){
						$(player).removeClass('mp3-player-started');
						player.stopPlayer();
					});
					$('#' + playerId).addClass('mp3-player-started');
				};
			}
			var playerId = element.attr('id');
			var playerPaths = element.attr('rel').split('|');
			var flashvars = {
				"listenLabel": element.attr('title'), 
				"mp3Source": playerPaths[0], 
				"playerId" : playerId
			};
			var params = {
				"menu": false, 
				"base": "swf", 
				"allowScriptAccess": "always", 
				"wmode": "transparent"
			};
			var attributes = {
				"id": playerId,
				"class": "mp3-player"
			};
			var playerPath = playerPaths[1];
			var expressPath = playerPaths[2];
			swfobject.embedSWF(playerPath, playerId, "355", "21", "9.0.0", expressPath, flashvars, params, attributes);
			
			
		};
		this.init();
	};
	/**
	 * Mp3 player
	 * 
	 * Namespace in jQuery
	 */	
	$.fn.mp3Player = function(){
		return this.each(function(){
			new mp3Player(this);
		});
	};
    $.fn.expandFaq = function(){
        return this.each(function(){
            $(this).click(function(event){
                event.preventDefault();
                $('dl.faq dd').slideUp();
                $(this).next('dd').slideToggle();
            });
        });
    };
    /**
     * Floor plan
     *
     * Namespace in jQuery
     */
    $.fn.floorPlan = function(){
        return this.each(function(){
            $('.floor-plan li a').live('click', function(event){
                event.preventDefault();
                if(!$(this).hasClass('active')){
                    $('.floor-plan li.active').removeClass('active');
                    $(this).parent('li').addClass('active');
                    $('.floor-plan img:not(' + $(this).attr('href') + ')').fadeOut(200);
                    $('.floor-plan img' + $(this).attr('href')).fadeIn(200);
                }
            });
        });
    };
    /**
     * External links
     *
     * Namespace in jQuery
     */
    $.fn.external = function(){
        return this.each(function(){
            this.click(function(event){
                event.preventDefault();
                window.open($(this).attr('href'));
            });
        });
    };
	//FIRE !
	$(document).ready(function(){
		var homeSlider = $('#focus-activities').slider();
		//slider.next();
		var homeMenu = $('#orw-menu').menu();
		var pageActivityFilter = $('#views-exposed-form-activities-page').activityFilter($('#view-activities-main'));
		$('.smartform').smartForm();
		$('.booking-tables').bookingTable();
		$().mediaTabs($('#block-views-medias-current-pictures'), $('#block-views-medias-current-videos'));
		$('#block-orw-orw-calendar-activity').activityCalendar();
		$('#orw-booking-subscribe').subscribeForm();
		$('a.external').externalLinks();
		$('.activity-sample-player').mp3Player();
        $('dl.faq dt').expandFaq();
        $('.floor-planned').floorPlan();
        $('.externak').external();
	});
})(jQuery);
;
