(function() {



    'use strict';

var app = angular.module("app", ['ngRoute', 'ui.utils','ui.bootstrap', 'ngEkathuwa','angularMoment']);





    app.run(function(amMoment) {

        amMoment.changeLocale('pt-br');

    });


    app.directive('focusInput', function($timeout) {

        return {

            link: function(scope, element, attrs) {

                element.bind('click', function() {

                    $timeout(function() {

                        element.parent().parent().find('input').focus();

                    });

                });

            }

        };

    });



    app.directive('ngEnter', function () {

        return function (scope, element, attrs) {

            element.bind("keydown keypress", function (event) {

                if(event.which === 13) {

                    scope.$apply(function (){

                        scope.$eval(attrs.ngEnter);

                    });

                    event.preventDefault();

                }

            });

        };

    });



    app.directive('uploader', [function() {



        return {

            restrict: 'E',

            scope: {

                    action: '@'

            },

            controller: ['$scope','$routeParams', function ($scope,$routeParams) {





                $scope.progress = 0;

                $scope.avatar = '';

                $scope.id_prod = $routeParams.id;

                $scope.sendFile = function(el) {



                    var $form = $(el).parents('form');



                    if ($(el).val() == '') {

                        return false;

                    }



                    $form.attr('action', $scope.action);



                    $scope.$apply(function() {

                        $scope.progress = 0;

                    });



                    $form.ajaxSubmit({

                        type: 'POST',

                        uploadProgress: function(event, position, total, percentComplete) {



                            $scope.$apply(function() {

                                // upload the progress bar during the upload

                                $scope.progress = percentComplete;

                            });



                        },

                        error: function(event, statusText, responseText, form) {



                            // remove the action attribute from the form

                            $form.removeAttr('action');



                            /*

                             handle the error ...

                             */



                        },

                        success: function(responseText, statusText, xhr, form) {



                            var ar = $(el).val().split('\\'),

                                filename =  ar[ar.length-1];



                            // remove the action attribute from the form

                            $form.removeAttr('action');



                            $scope.$apply(function() {

                                $scope.avatar = filename;

                            });



                        }

                    });



                }



            }],

            link: function(scope, elem, attrs, ctrl) {

                elem.find('.fake-uploader').click(function() {

                    elem.find('input[type="file"]').click();

                });

            },

            replace: false,

            templateUrl: 'assets/plugins/uploader.html'

        };



    }]);



    app.filter('range', function() {

        return function(input, total) {

            total = parseInt(total);

            for (var i=0; i<total; i++) {

                input.push(i);

            }

            return input;

        };

    });



    app.filter('rangeData', function() {

        return function( itens, dataMin, dataMax ) {

            var filtrado = [];

            angular.forEach(itens, function(item) {

                if(dataMin){dataMin=dataMin.substr(0,10);}
                if(dataMax){dataMax=dataMax.substr(0,10);}
                if(item.data){item.data=item.data.substr(0,10);}

                if(( !dataMax && item.data >= dataMin) || (!dataMin && item.data <= dataMax) || (!dataMin && !dataMax) || (item.data >= dataMin && item.data <= dataMax)) {

                    filtrado.push(item);

                }

            });

            return filtrado;

        };

    });

    app.filter('isoToStr', function($filter) {

        return function(itens, index) {

            var filtrado = [];

            angular.forEach(itens, function(item) {

                for(var i in index) {

                    item[index[i]] = $filter('date')(item[index[i]], "dd/MM/y HH:mm:ss");

                }

                filtrado.push(item);

            });

            return filtrado;

        };

    });





    /*app.filter('datarange', function () {

        return function(input, date){

            for(var x in input){

                if(input[x] <= date[0] || input[x] >= date[1]){

                        input.splice(x, 1);

                }

            }

            return input;

        }

    });*/



    /*app.directive("input", function($filter) {

        return {

            restrict: 'E',

            require: "?ngModel",

            link: function(scope, element, attrs, ngModel) {

                if (!ngModel || attrs["type"].toLowerCase() !== "date") {

                    return;

                }

                var date_formatter = function(value) {

                    return $filter("date")(value, "yyyy-MM-dd")

                };



                ngModel.$formatters.unshift(date_formatter)

                ngModel.$parsers.unshift(Date)

            }

        }

    });*/



    app.config(function ($routeProvider) {



    $routeProvider



        // para a rota '/', carregaremos o template home.html e o controller 'HomeCtrl'

        .when('/', {

            templateUrl: 'app/views/home.html',

            controller: 'HomeCtrl'

        })

        .when('/plano',{
      		templateUrl:'app/views/plano.html',
      		controller:'planoController'
      	})

        .when('/configs', {

            templateUrl: 'app/views/configs.html',

            controller: 'ConfigsCtrl'

        })



        .when('/configs/funcionario', {

            templateUrl: 'app/views/configsFuncionario.html',

            controller: 'ConfigsFunCtrl'

        })

        .when('/configs/produto', {

            templateUrl: 'app/views/configsProduto.html',

            controller: 'ConfigsProdCtrl'

        })

        .when('/configs/cliente', {

            templateUrl: 'app/views/configsCliente.html',

            controller: 'ConfigsCliCtrl'

        })

        .when('/configs/cliente/:op', {

            templateUrl: 'app/views/configsCliente.html',

            controller: 'ConfigsCliCtrl'

        })

        .when('/configs/faturamento', {

            templateUrl: 'app/views/configsFaturamento.html',

            controller: 'ConfigsFatCtrl'

        })

        .when('/configs/empresa', {

            templateUrl: 'app/views/configsEmpresa.html',

            controller: 'ConfigsEmpCtrl'

        })

        .when('/configs/backup', {

            templateUrl: 'app/views/configsBackup.html',

            controller: 'ConfigsBackCtrl'

        })



        .when('/cadastro/produto/lista', {

            templateUrl: 'app/views/cadastroProdLista.html',

            controller: 'CadastroProdListaCtrl'

        })

        .when('/cadastro/funcionario/lista', {

            templateUrl: 'app/views/cadastroFunLista.html',

            controller: 'CadastroFunListaCtrl'

        })

        .when('/cadastro/funcionario/lista/:op', {

            templateUrl: 'app/views/cadastroFunLista.html',

            controller: 'CadastroFunListaCtrl'

        })

        .when('/cadastro/usuario/lista', {

            templateUrl: 'app/views/cadastroUserLista.html',

            controller: 'CadastroFunListaCtrl'

        })

        .when('/cadastro/usuario/lista/:op', {

            templateUrl: 'app/views/cadastroFunLista.html',

            controller: 'CadastroFunListaCtrl'

        })

        .when('/cadastro/:tipo/lista', {

            templateUrl: 'app/views/cadastroLista.html',

            controller: 'CadastroListaCtrl'

        })

        .when('/cadastro/funcionario/novo', {

            templateUrl: 'app/views/cadastroFuncionario.html',

            controller: 'CadastroFunCtrl'

        })

        .when('/cadastro/usuario/novo', {

            templateUrl: 'app/views/cadastroUsuario.html',

            controller: 'CadastroFunCtrl'

        })

        .when('/cadastro/comissao/', {

            templateUrl: 'app/views/cadastroComissao.html',

            controller: 'CadastroComissaoCtrl'

        })

        .when('/cadastro/produto/novo', {

            templateUrl: 'app/views/cadastroProd.html',

            controller: 'CadastroProdCtrl'

        })

        .when('/cadastro/produto/editar/:id', {

            templateUrl: 'app/views/cadastroProd.html',

            controller: 'CadastroProdCtrl'

        })

        .when('/cadastro/funcionario/editar/:id', {

            templateUrl: 'app/views/cadastroFuncionario.html',

            controller: 'CadastroFunCtrl'

        })

        .when('/cadastro/usuario/editar/:id', {

            templateUrl: 'app/views/cadastroUsuario.html',

            controller: 'CadastroFunCtrl'

        })

        .when('/cadastro/:tipo/novo', {

            templateUrl: 'app/views/cadastro.html',

            controller: 'CadastroCtrl'

        })

        .when('/cadastro/:tipo/editar/:id', {

            templateUrl: 'app/views/cadastro.html',

            controller: 'CadastroCtrl'

        })



        .when('/faturamento/venda/novo', {

            templateUrl: 'app/views/faturamentoVenda.html',

            controller: 'VendaCtrl'

        })

        .when('/faturamento/venda/editar/:id', {

            templateUrl: 'app/views/faturamentoVenda.html',

            controller: 'VendaCtrl'

        })

        .when('/faturamento/venda/lista', {

            templateUrl: 'app/views/faturamentoVendaLista.html',

            controller: 'VendaListaCtrl'

        })

        .when('/faturamento/venda/lista/:op', {

            templateUrl: 'app/views/faturamentoVendaLista.html',

            controller: 'VendaListaCtrl'

        })



        .when('/financeiro/conta/pagar/novo', {

            templateUrl: 'app/views/financeiroContaPagar.html',

            controller: 'ContaPagarCtrl'

        })

        .when('/financeiro/conta/pagar/editar/:id', {

            templateUrl: 'app/views/financeiroContaPagar.html',

            controller: 'ContaPagarCtrl'

        })

        .when('/financeiro/conta/receber', {

            templateUrl: 'app/views/financeiroContaReceberLista.html',

            controller: 'ContaReceberListaCtrl'

        })

        .when('/financeiro/conta/pagar', {

            templateUrl: 'app/views/financeiroContaPagarLista.html',

            controller: 'ContaPagarListaCtrl'

        })

        .when('/financeiro/conta/receber/:op', {

            templateUrl: 'app/views/financeiroContaReceberLista.html',

            controller: 'ContaReceberListaCtrl'

        })

        .when('/financeiro/conta/pagar/:op', {

            templateUrl: 'app/views/financeiroContaPagarLista.html',

            controller: 'ContaPagarListaCtrl'

        })

        // caso não seja nenhum desses, redirecione para a rota '/'

        .otherwise({redirectTo: '/'});

});


    app.controller('planoController', function($http, $scope){
      $scope.pagina = "Planos";
      $scope.titulo = "Veja o plano que esta sendo utilizado";

      $scope.listaPlanos = function(){
        $http.get('core/obj/plano.php').success( function (data) {
          $scope.planos = data;
          console.log("planos:" , data);
        }).error(function(data, status) {
          console.log('deu erro');
          console.log(data);
          console.log(status);
        });
      }

      $scope.salvarPlano = function(plano){
        if(confirm("Deseja realmente trocar de plano?")){
          var idPlano = plano.id;
          $http.post(
            'core/obj/plano.php/',
            idPlano
          ).success(function(data){
            console.log(data);
            $scope.listaPlanos();
          }).error(function(data, status){
            console.log(data);
            console.log(status);
          })
        }
      }

      $scope.listaPlanos();
    })

    app.controller('ConfigsFatCtrl', function ($rootScope, $location, $scope, $http, $window, $modal, $routeParams,$ekathuwa,operacoes) {

        $rootScope.activetab = "/configs";

        var aj = $http;

        var ng = $scope;

        var wi = $window;

        var rp = $routeParams;

        var rs = $rootScope;

        var lo = $location;



        wi.scrollTo(0,0);

        if(rs.session.nivel == 'usuario')

            lo.path('#/');



        var initOp = function(){

            return {id:"",nome:"",cr:false,estoque:false,comissao:false,nota:false,faturamento:false};

        };

        var initPag = function(){

            return {id:"",nome:""};

        };





        operacoes.atualizar('operacao','lista').success(function (data) {

            ng.operacoes = data;

            for(var i in ng.operacoes){

                ng.operacoes[i].cr != 0 ? ng.operacoes[i].cr = true : false;

                ng.operacoes[i].faturamento != 0 ? ng.operacoes[i].faturamento = true : false;

                ng.operacoes[i].estoque != 0 ? ng.operacoes[i].estoque = true : false;

                ng.operacoes[i].comissao != 0 ? ng.operacoes[i].comissao = true : false;

                ng.operacoes[i].nota != 0 ? ng.operacoes[i].nota = true : false;

            }

        });

        operacoes.atualizar('pagamento','lista').success(function (data) {

            ng.pagamentos = data;

        });



        ng.operacao = initOp();

        ng.pagamento = initPag();







        ng.salvaOp = function () {

            if(ng.operacao.nome){

                operacoes.salvar({

                    lista:ng.operacoes,

                    dado:ng.operacao,

                    end:'operacao',

                    tipo:'operacao',

                    init:initOp()

                },function(err,data){

                    ng.operacao = data.dado;

                    ng.operacoes = data.lista;

                });

            }else{

                msgErro("Nome da Operação está em Branco");

            }

        };



        ng.editaOp = function(dado){

            ng.operacao = dado;

        };

        ng.editaPag = function(dado){

            ng.pagamento = dado;

        };





        ng.salvaPag = function () {

            if(ng.pagamento.nome){

                operacoes.salvar({

                    lista:ng.pagamentos,

                    dado:ng.pagamento,

                    end:'pagamento',

                    tipo:'pagamento',

                    init:initPag()

                },function(err,data){

                    ng.pagamento = data.dado;

                    ng.pagamentos = data.lista;

                });

            }else{

                msgErro("Nome da Operação está em Branco");

            }

        }





    });



    app.controller('ContaPagarListaCtrl', function ($rootScope, $location, $scope, $http, $window, $modal, $routeParams,$ekathuwa,operacoes,operacoessm, $filter)

    {

        $rootScope.activetab = "/financeiro";



        var aj = $http;

        var ng = $scope;

        var wi = $window;

        var rp = $routeParams;

        var rs = $rootScope;

        var lo = $location;

        var fi = $filter;



        if(rs.session.nivel == 'usuario'){

            lo.path('/')

        }

        wi.scrollTo(0,0);



        ng.relatorio = rp.op;

        if(ng.relatorio){

            ng.mostraLista = false

            if(rs.session.nivel == 'usuario'){

                ng.id_funcionario = rs.session.id;

            }else{

                ng.id_funcionario = "";

            }

        }else{

            ng.mostraLista = true;

        }



        var empresa;

        operacoes.atualizar('empresa',1).success(function (data) {

            empresa = data;

        });



        var initParc = function () {

            operacoes.atualizar('parcelasPagar','lista').success(function (data) {

                ng.contas = data;

                for(var i in ng.contas){

                    ng.contas[i].data = moment(ng.contas[i].data,"YYYY-MM-DD").toISOString();

                }

            });

        };

        ng.filter = "$";

        ng.busca = {data:[]};

        ng.buscaSel = { '$':'',id_conta:'',fornecedor:''};

        ng.buscaSelPlace = { '$':'Qualquer campo',id_conta:'Nº do documento',fornecedor:'Nome Fornecedor'};



        initParc();







        ng.trocaFiltro = function(pr) {

            ng.filter = pr;

        };





        ng.baixaParc = function (id, vetor, valor) {

            var vetorf = [];

            for(var i in vetor){

                if(vetor[i].pagar == true)

                    vetorf.push(vetor[i]);

            }

            operacoessm.salvar({

                lista:ng.resultados,

                dado:{id:id,parcelas:vetorf,valor:valor},

                end:'baixarParcelaPagar'

            },function(err,data){

                ng.resultados = data.lista;

                ng.addVal = 0;

            });

            ng.ModalBaixaParcelas(ng.modal);

            initParc();



        };



        ng.editaParc = function (parc) {

            ng.parcela_sel = parc;

        };







        ng.modalInfoContas = function (dado) {

            if(!ng.relatorio) {

                ng.modal = dado;

                $ekathuwa.modal({

                    id: "contas",

                    scope: $scope,

                    templateURL: "app/views/modals/modalInfoContasPagar.html"

                });

            }

        };



        ng.ModalBaixaParcelas = function (modal) {

            fechaModal();

            if(!ng.relatorio) {

                operacoes.atualizar('parcelasPagar', modal.id_conta).success(function (data) {

                    ng.resultados = data;

                    for (var i in ng.resultados) {

                        if (!ng.resultados[i].pago == 1)

                            ng.resultados[i].pagar = true;

                    }

                    modal = ng.resultados[0];

                    ng.parcela_sel = modal;

                    ng.addVal = 0;

                });

                $ekathuwa.modal({

                    id: "baixaParcela",

                    scope: $scope,

                    size: 'lg',

                    templateURL: "app/views/modals/modalBaixaParcelaPagar.html"

                });

            }

        };



        ng.parseInt = function (int) {

            if(int == "")

                return !"";

            else

                return parseInt(int);

        };



        ng.editaConta = function (dado) {

            lo.path('/financeiro/conta/pagar/editar/'+dado.id_conta);

        };



        ng.filtra = function(){

            if(!ng.id_funcionario)

                ng.id_funcionario = "";

            ng.filtrado = {valor_total:0,valor_pago:0,valor_pagar:0};

            ng.fRes = $filter('orderBy')($filter('filter')($filter('filter')($filter('rangeData')(ng.contas,ng.busca.data[0],ng.busca.data[1]),{'vencido':ng.busca.vencido,'id_funcionario':ng.id_funcionario.id}),ng.buscaSel),'data');

            for(var i in ng.fRes) {

                ng.filtrado.valor_total += ng.fRes[i].valor;

                ng.filtrado.valor_pago += ng.fRes[i].valor_pago;

                ng.filtrado.valor_pagar += ng.fRes[i].saldo;

            }

        };



        ng.imprime = function () {

            ng.filtra();

            var imprime =  {

                dados:$filter('isoToStr')(ng.fRes,["data_emissao","data"]),

                busca:ng.busca,data_i:$filter('date')(ng.busca.data[0],"dd/MM/y"),

                data_f:$filter('date')(ng.busca.data[1],"dd/MM/y"),

                buscaSel:ng.buscaSel,

                empresa:empresa,

                funcionario:ng.id_funcionario,

                data:

                {

                    dia:$filter('date')(new Date().toISOString(),"dd/MM/y"),

                    hora:$filter('date')(new Date().toISOString(),"HH:mm:ss")

                },

                nome:"Relatório - Contas Pagar",

                soma:ng.filtrado.valor_total,

                filtrado:ng.filtrado

            };

            aj.post("impressao/relatorios/save.php?tipo=pagar", imprime).then(function (retorno) {

                var verPOP = window.open('impressao/relatorios/relatorioContasPagar.php','_blank');

                if(!verPOP)

                    msgErro("O bloqueio de pop-up está ativo!")

            });

        };



        ng.open = function($event) {

            $event.preventDefault();

            $event.stopPropagation();



            $scope.opened = true;

        };



        $scope.dateOptions = {

            formatYear: 'yy'

        };



    });



    app.controller('ContaReceberListaCtrl', function ($rootScope, $location, $scope, $http, $window, $modal, $routeParams,$ekathuwa,operacoes,operacoessm, $filter) {

        $rootScope.activetab = "/financeiro";



        var aj = $http;

        var ng = $scope;

        var wi = $window;

        var rp = $routeParams;

        var rs = $rootScope;

        var lo = $location;

        var fi = $filter;



        wi.scrollTo(0,0);





        ng.relatorio = rp.op;

        if(ng.relatorio){

            ng.mostraLista = false

            if(rs.session.nivel == 'usuario'){

                ng.id_funcionario = rs.session.id;

            }else{

                ng.id_funcionario = "";

            }

        }else{

            ng.mostraLista = true;

        }



        var empresa;

        operacoes.atualizar('empresa',1).success(function (data) {

            empresa = data;

        });

        var initParc = function () {

            operacoes.atualizar('contasReceber', 'lista').success(function (data) {

                ng.contas = data;

                for (var i in ng.contas) {

                    ng.contas[i].data = moment(ng.contas[i].data, "YYYY-MM-DD").toISOString();

                    ng.contas[i].id_funcionario = ng.contas[i].pedido.id_funcionario;

                }

            });



            operacoes.atualizar('funcionario','listaSel').success(function (data) {

                ng.funcionarios = data;
                if(rs.session.nivel == 'usuario'){
                    for(var i in ng.funcionarios){
                        if(rs.session.id == ng.funcionarios[i].id){
                            ng.id_funcionario = ng.funcionarios[i];
                        }
                    }
                }

            });

        };



        ng.filter = "$";

        ng.busca = {data:[]};

        ng.buscaSel = { '$':'',id_pedido:'',nome:''};

        ng.buscaSelPlace = { '$':'Qualquer campo',id_pedido:'Nº do documento',nome:'Nome Cliente'};



        initParc();



        ng.trocaFiltro = function(pr) {

            ng.filter = pr;

        };



        ng.baixaParc = function (id, vetor, valor) {

            var vetorf = [];

            for(var i in vetor){

                if(vetor[i].pagar == true)

                    vetorf.push(vetor[i]);

            }

            operacoessm.salvar({

                lista:ng.resultados,

                dado:{id:id,parcelas:vetorf,valor:valor},

                end:'baixarParcelaReceber'

            },function(err,data){

                ng.resultados = data.lista;

                ng.addVal = 0;

            });

            ng.ModalBaixaParcelas(ng.modal);

            initParc();



        };



        ng.editaParc = function (parc) {

            ng.parcela_sel = parc;

            ng.attEstorno(parc.id);

        };



        ng.attEstorno = function (id) {

            operacoes.atualizar('baixarParcelaReceber', id+'&estorno=1').success(function (data) {

                ng.estornos = data;

                for(var i in ng.estornos){

                    ng.estornos[i].data = $filter('date')(new Date(ng.estornos[i].data.replace(/-/g, '/')),'dd/MM/yyyy HH:mm:ss');

                    ng.estornos[i].valor = $filter('currency')(ng.estornos[i].valor);

                }

            });

        };



        ng.estornarParc = function (est) {

            operacoessm.deleta({

                lista:[],

                dado:{id:est.id+'&estorno=1&parcela='+est.id_conta_receber},

                end:'baixarParcelaReceber'

            },function(err,data){

                ng.ModalBaixaParcelas(ng.modal)

                initParc();

            })

        };



        ng.parcelasValorTotal = function () {

            ng.vTotalParc = 0;

            for(var i  in ng.resultados){

                if(ng.resultados[i].pagar == true){

                    ng.vTotalParc += ng.resultados[i].saldo;

                }

            }

            ng.vTotalParc.toFixed(2);

        };



        ng.modalInfoContas = function (dado) {

            if(!ng.relatorio && ((rs.session.academia && rs.session.nivel != 'usuario') || (!rs.session.academia))) {

                ng.modal = dado;

                $ekathuwa.modal({

                    id: "contas",

                    scope: $scope,

                    templateURL: "app/views/modals/modalInfoContasReceber.html"

                });

            }

        };



        ng.ModalBaixaParcelas = function (modal) {

            fechaModal();

            operacoes.atualizar('contasReceber',modal.id_pedido).success(function (data) {

                ng.resultados = data;

                for(var i in ng.resultados){

                    if(!ng.resultados[i].pago == 1)

                        ng.resultados[i].pagar = true;

                }

                modal = ng.resultados[0];

                ng.parcela_sel = modal;

                ng.addVal = 0;

                ng.parcelasValorTotal();

                ng.attEstorno(ng.parcela_sel.id);

            });

            $ekathuwa.modal({

                id: "baixaParcela",

                scope: $scope,

                size:'lg',

                templateURL: "app/views/modals/modalBaixaParcelaReceber.html"

            });

        };



        ng.parseInt = function (int) {

            if(int == "")

                return !"";

            else

                return parseInt(int);

        };



        ng.editaPed = function (dado) {

            lo.path('/faturamento/venda/editar/'+dado.id_pedido);

        };



        ng.filtra = function(){

            if(!ng.id_funcionario)

                ng.id_funcionario = "";

            ng.filtrado = {valor_total:0,valor_recebido:0,valor_receber:0};

            ng.fRes = $filter('orderBy')($filter('filter')($filter('filter')($filter('rangeData')(ng.contas,ng.busca.data[0],ng.busca.data[1]),{'vencido':ng.busca.vencido,'id_funcionario':ng.id_funcionario.id}),ng.buscaSel),'data');

            for(var i in ng.fRes) {

                ng.filtrado.valor_total += ng.fRes[i].valor;

                ng.filtrado.valor_recebido += ng.fRes[i].valor_recebido;

                ng.filtrado.valor_receber += ng.fRes[i].saldo;

            }

            ng.filtrado.comissao = ng.filtrado.valor_total*(ng.id_funcionario.comissao/100);

        };



        ng.imprime = function () {

            ng.filtra();

            var imprime =  {

                dados:$filter('isoToStr')(ng.fRes,["data_emissao","data"]),

                busca:ng.busca,data_i:$filter('date')(ng.busca.data[0],"dd/MM/y"),

                data_f:$filter('date')(ng.busca.data[1],"dd/MM/y"),

                buscaSel:ng.buscaSel,

                empresa:empresa,

                funcionario:ng.id_funcionario,

                data:

                {

                    dia:$filter('date')(new Date().toISOString(),"dd/MM/y"),

                    hora:$filter('date')(new Date().toISOString(),"HH:mm:ss")

                },

                nome:"Relatório - Contas Receber",

                soma:ng.filtrado.valor_total,

                comissao:ng.filtrado.comissao,

                filtrado:ng.filtrado

            };

            aj.post("impressao/relatorios/save.php?tipo=receber", imprime).then(function (retorno) {

                var verPOP = window.open('impressao/relatorios/relatorioContasReceber.php','_blank');

                if(!verPOP)

                    msgErro("O bloqueio de pop-up está ativo!")

            });

        };



        ng.open = function($event) {

            $event.preventDefault();

            $event.stopPropagation();



            ng.opened = true;

        };



        ng.dateOptions = {

            formatYear: 'yy'

        };

        ng.baixarPorData = function(inicio,fim){
            var conf = confirm("Você está prestes a confimar todos os títulos da faixa de datas selecionadas. Você tem certeza?")
            if(conf){
                aj.post('core/obj/baixarParcelaReceber.php', {paga:1, datai:inicio.substr(0, 10), dataf:fim.substr(0, 10)}).then(function(res){
                    if(res.data.erro == 0){
                        initParc();
                    }
                })
            }
        }


    });



    app.controller('ContaPagarCtrl', function ($rootScope, $location, $scope, $http, $window, $modal, $routeParams,$ekathuwa,operacoes,operacoessm, $filter) {

        $rootScope.activetab = "/financeiro";



        var aj = $http;

        var ng = $scope;

        var wi = $window;

        var rp = $routeParams;

        var rs = $rootScope;

        var lo = $location;





        wi.scrollTo(0,0);



        var initConta = function () {

            return {id:0,id_fornecedor:null,nome:null,documento:null,tipo:null,serie:null,valor:null,parcelas:1};

        };



        ng.baixaParc = function (id, vetor, valor) {

            var vetorf = [];

            for(var i in vetor){

                if(vetor[i].pagar == true)

                    vetorf.push(vetor[i]);

            }

            operacoessm.salvar({

                lista:ng.resultados,

                dado:{id:id,parcelas:vetorf,valor:valor},

                end:'baixarParcela'

            },function(err,data){

                ng.resultados = data.lista;

                ng.addVal = 0;

            });

            ng.ModalBaixaParcelas(ng.modal);



        };



        ng.editaParc = function (parc) {

            ng.parcela_sel = parc;

        };



        operacoes.atualizar('tipoDocumento','lista').success(function (data) {

            ng.tipos_fatura = data;

        });



        if(!rp.id){

            ng.conta = initConta();

            ng.conta.tipo = 1;

            ng.salvaParc = true;

        }else{

            operacoes.atualizar('contasPagar',rp.id).success(function (data) {

                ng.conta = data;

                ng.buscaForn(ng.conta.id_fornecedor)

            });

            operacoes.atualizar('parcelasPagar',rp.id).success(function (data) {

                ng.parcelas = data;

                ng.parcelas.length > 0 ? ng.salvaParc = true:ng.salvaParc = false;

            });

            ng.editaForn = true;

        }



        ng.ModalCancelarConta = function () {

            ng.modalMsg = "Tem certeza que deseja excluir esta conta?"

            $ekathuwa.modal({

                id: "deleta",

                scope: $scope,

                templateURL: "app/views/modals/modalDel.html"

            });

        };



        ng.deletaItem = function () {

            operacoessm.deleta({

                lista:[],

                dado:{id:rp.id},

                end:'contasPagar'

            },function(err,data){

                lo.path('/financeiro/conta/pagar')

            })

        };



        ng.buscaForn = function (id) {

            if(id && id != 0){

                operacoes.atualizar('fornecedor',id).success(function (data) {

                    ng.conta.id_fornecedor = data[0].id;

                    if(data[0].pessoa == 'fisica'){
                        ng.conta.nome = data[0].nome;
                    }else{
                        if(!data[0].razao || data[0].razao == '')
                            ng.conta.nome = data[0].fantasia;
                        else
                            ng.conta.nome = data[0].razao;
                    }

                });

                fechaModal();

            }

        };



        ng.ModalBuscaForn = function () {

            if(ng.editaForn)

                return;

            operacoes.atualizar('fornecedor', 'lista').success(function (data) {

                ng.resultados = data;

            });

            fechaModal();

            $ekathuwa.modal({

                id: "fornecedores",

                scope: $scope,

                templateURL: "app/views/modals/modalForn.html"

            });

        };



        ng.parseInt = function (int) {

            if(int == "")

                return !"";

            else

                return parseInt(int);

        };



        ng.open = function($event) {

            $event.preventDefault();

            $event.stopPropagation();



            $scope.opened = true;

        };



        $scope.dateOptions = {

            formatYear: 'yy'

        };





        ng.salvaConta = function () {

            operacoes.salvar({

                lista:[],

                dado:ng.conta,

                end:'contasPagar',

                tipo:'contas'

            },function(err,data){

                if(!rp.id)

                    lo.path('/financeiro/conta/pagar/editar/'+data.lista[0].id);

            });

        };





        ng.ModalParcela = function () {
            $ekathuwa.modal({

                id: "parcela",

                scope: $scope,

                templateURL: "app/views/modals/modalParcelaPagar.html"

            });
        };



        ng.parcelasValor = function () {

            var valor = 0;

            var parcelas = 0;

            valor = ((ng.conta.valor - valor) / (ng.conta.parcelas - parcelas)).toFixed(2);

            var valorB = parseFloat(valor + 0);

            if (valor < 0)

                valor = 0;

            for (var i in ng.parcelas) {

                if (!ng.parcelas[i].valor_custom) {

                    if (i == ng.parcelas.length - 1) {

                        var valorF = 0

                        for (var k in ng.parcelas) {

                            valorF += ng.parcelas[k].valor

                        }

                        valor = ng.conta.valor - valorF;

                        ng.parcelas[i].valor = parseFloat(valor.toFixed(2));

                    } else {

                        ng.parcelas[i].valor = parseFloat(valor);

                        valorB += parseFloat(valor);

                    }

                }



            }

        };



        ng.parcelasCalc = function () {

            if(!ng.salvaParc){

                ng.parcelas = [];

                for(var x = 0; x < ng.conta.parcelas; x++){

                    ng.parcelas[x] = {data:new Date().toISOString(),valor:0,pago:0,id_conta:rp.id,parcela:x+1,data_emissao:ng.conta.data_emissao};

                }

                ng.salvaParc = false;

                ng.parcelasValor();

            }

            ng.ModalParcela();

        };



        ng.salvaParcelas = function () {

            operacoessm.deleta({

                lista:[],

                dado:{id:rp.id},

                end:'parcelasPagar'

            },function(err,data){

                for(var i in ng.parcelas) {

                    ng.parcelas[i].id = 0;

                    ng.parcelas[i].parcela = parseInt(i)+1;

                    operacoessm.salvar({

                        lista: [],

                        dado: ng.parcelas[i],

                        end: 'parcelasPagar'

                    }, function (err, data) {

                    });

                }

                msgSucesso('Parcelas Salvas com sucesso');

                ng.salvaParc = true;



            });



        };



    });



    app.controller('VendaListaCtrl', function ($rootScope, $location, $scope, $http, $window, $modal, $routeParams,$ekathuwa,operacoes,operacoessm,$filter) {


        $rootScope.activetab = "/faturamento";



        var aj = $http;

        var ng = $scope;

        var wi = $window;

        var rp = $routeParams;

        var rs = $rootScope;

        var lo = $location;

        var fi = $filter;



        wi.scrollTo(0,0);

        ng.relatorio = rp.op;

        ng.relatorio? ng.mostraLista = false: ng.mostraLista = true;

        if(rs.session.nivel == 'usuario'){

            ng.id_funcionario = rs.session.id;

        }else{

            ng.id_funcionario = "";

        }

        operacoes.atualizar('pedido','lista').success(function (data) {

            ng.pedidos = data;

            for(var i in ng.pedidos){

                ng.pedidos[i].id = String(ng.pedidos[i].id);

                ng.pedidos[i].id_cliente = String(ng.pedidos[i].id_cliente);

            }

        });

        var empresa;

        operacoes.atualizar('empresa',1).success(function (data) {

            empresa = data;

        });

        operacoes.atualizar('funcionario','listaSel').success(function (data) {

            ng.funcionarios = data;

        });



        ng.busca2 = {};

        ng.busca = {data:[]};

        ng.busca2 = {data:[]};

        ng.filter = "$";

        ng.filter2 = "id";

        ng.buscaSel = { '$':'',id:'', id_cliente:'',nome:''};

        ng.buscaSelPlace = { '$':'Qualquer campo',id:'Nº do documento',nome:'Nome Cliente'};



        ng.trocaFiltro = function(pr) {

            ng.filter = pr;

        };



        ng.mostraInfos = function(dado){

            if(!ng.relatorio){

                ng.modal = dado;

                fechaModal();

                $ekathuwa.modal({

                    scope: $scope,

                    templateURL: "app/views/modals/modalInfoPed.html"

                });

            }

        };



        ng.editaPed = function (dado) {

            lo.path('/faturamento/venda/editar/'+dado.id);

        };



        ng.cancelarPed = function(dado){

            ng.modal = dado;

            fechaModal();

            ng.modalMsg = "Tem certeza que deseja Cancelar Esse Pedido?";

            $ekathuwa.modal({

                scope: $scope,

                templateURL: "app/views/modals/modalDel.html"

            });

        };



        ng.deletaItem = function(){

            fechaModal();

            operacoes.deleta({

                lista:[],

                dado:ng.modal,

                end:'pedido',

                tipo:'pedido',

                modal:''

            },function(err,data){

                console.log(data)

                var index = ng.pedidos.indexOf(ng.modal);

                ng.pedidos[index].status = 2;

                ng.modal.status = 2;

            })

        };



        ng.filtra = function(){

            ng.filtrado = {valor_total:0};

            ng.fRes = $filter('filter')($filter('filter')($filter('rangeData')(ng.pedidos,ng.busca2.data[0],ng.busca2.data[1]),{'status':ng.busca.status,'id_funcionario':ng.id_funcionario.id}),ng.buscaSel);

            for(var i in ng.fRes)

                ng.filtrado.valor_total += ng.fRes[i].total;

            ng.filtrado.comissao = ng.filtrado.valor_total*(ng.id_funcionario.comissao/100);

        };

        ng.imprime = function () {

            ng.filtra();

             var imprime =  {

                 dados:$filter('isoToStr')(ng.fRes,["ultima_modificacao","data_criacao"]),

                 busca:ng.busca,data_i:$filter('date')(ng.busca2.data[0],"dd/MM/y"),

                 data_f:$filter('date')(ng.busca2.data[1],"dd/MM/y"),

                 buscaSel:ng.buscaSel,

                 empresa:empresa,

                 funcionario:ng.id_funcionario,

                 data:

                 {

                     dia:$filter('date')(new Date().toISOString(),"dd/MM/y"),

                    hora:$filter('date')(new Date().toISOString(),"HH:mm:ss")

                 },

                 nome:"Relatório - Vendas",

                 soma:ng.filtrado.valor_total,

                 comissao:ng.filtrado.comissao

             };

            aj.post("impressao/relatorios/save.php?tipo=venda", imprime).then(function (retorno) {

                var verPOP = window.open('impressao/relatorios/relatorioPedidos.php','_blank');

                if(!verPOP)

                    msgErro("O bloqueio de pop-up está ativo!")

            });

        };

    });



    app.controller('VendaCtrl', function ($rootScope, $location, $scope, $http, $window, $modal, $routeParams,$ekathuwa,operacoes,$filter,operacoessm) {



        $rootScope.activetab = "/faturamento";



        var aj = $http;

        var ng = $scope;

        var wi = $window;

        var rp = $routeParams;

        var rs = $rootScope;

        var lo = $location;



        wi.scrollTo(0,0);



        if(rs.session.venda == 0){

            lo.path("/");

        }



        ng.pagina = 'Faturamento / Venda';



        var initUnid = function(){

            return {"id":0,"descricao":"","id_embalagem":0,"id_unidade":0,"peso_brut":0,"peso_liq":0,"desconto":0,"largura":0,"altura":0,"profundidade":0,"quantidade":"1","padrao":"1","unid_abreviado":"unid.","emb_abreviado":"PADRAO"};



        };



        var initItem = function(){

            return {"id":"","nome":"", "preco":"", "quantidade": 1, "unid":initUnid(), "id_pedido":rp.id, "total":0};

        };



        var initPedido = function(){

            return {"id":0,"id_cliente":"","id_funcionario":"","nome":"","ativo":1, "id_operacao":"", "id_pagamento": "",  "total":0, "id_endereco":"", "id_contato":"","data_inicial":"", "finalizado":"", "tipo_pagamento":"vista", "parcelas":1,"dias":30};

        };



        ng.item = initItem();



        ng.pedido = initPedido();



        ng.resultados = [];



        ng.categorias = [];



        ng.itens = [];



        ng.itens = [];



        ng.editaCli = true;





        ng.trocaData = function (data) {

            return $filter('date')(data, 'yyyy-MM-dd');

        };



        operacoes.atualizar('categoriaCli','lista').success(function (data) {

            ng.categorias = data;

        });



        operacoes.atualizar('pagamento','lista').success(function (data) {

            ng.pagamentos = data;

        });



        operacoes.atualizar('operacao','lista').success(function (data) {

            ng.operacoes = data;

        });



        operacoes.atualizar('funcionario','lista').success(function (data) {

            ng.funcionarios = data;

        });



        if(rp.id){

            ng.editar = true;



            operacoes.atualizar("pedido", rp.id).success(function (data) {

                ng.pedido = data;

                ng.pedido.data_inicialb = new Date(data.data_inicial).toISOString();

                ng.pedido.data_inicial = ng.trocaData(data.data_inicial);

                data.id_cliente ? ng.editaCli = true : ng.editaCli = false;

                if((ng.pedido.finalizado == 1 && ng.pedido.operacao.faturamento == 1) || ng.pedido.status == 2)

                    ng.faturado = true;

                else

                    ng.faturado = false;



            });

            operacoes.atualizar("contasReceber", rp.id).success(function (data) {

                ng.parcelas = data;

                ng.parcelasb = [];

                for(var i in ng.parcelas)

                    ng.parcelasb[i] = {data:new Date(ng.parcelas[i].data).toISOString()};

                if(ng.parcelas.length == ng.pedido.parcelas)

                    ng.parcSalva = true;

            });

            operacoes.atualizar("item", rp.id+'&lista=inativo').success(function (data) {

                ng.itens = data;

                ng.attTotalPedido();

            });

        }else{

            ng.faturado = false;

            ng.editar = false;

            ng.editaCli = false;

            ng.pedido.id_categoria = 0;

            ng.pedido.id_funcionario = ng.session.id;

            ng.parcelas = [];

            ng.btnVisualiza = false;

        }



        //--------- Funções ------------



        ng.ifVista = function () {

            if(ng.pedido.tipo_pagamento == 'vista'){

                ng.pedido.parcelas = 1

            }

            ng.salvaParc = true;

        };



        ng.open = function($event) {

            $event.preventDefault();

            $event.stopPropagation();



            $scope.opened = true;

        };



        ng.alteraVb = function(){

            if(ng.item.vdesc == ('')){

                ng.item.pdesc = 0;

                ng.item.vdesc = 0;

            }else{

                ng.alteraV();

            }

        };



        ng.alteraV = function(){

            ng.item.pdesc = (100-(((ng.item.valorUn - ng.item.vdesc)/ng.item.valorUn))*(100)).toFixed(3);

            ng.item.totalUn = (ng.item.valorUn - ng.item.vdesc).toFixed(2);

            ng.attTotalItem();

        };



        ng.alteraPb = function(){

            if(ng.item.pdesc == ('')){

                ng.item.vdesc = 0;

                ng.item.pdesc = 0;

            }else {

                ng.alteraP();

            }

        };



        ng.alteraP = function(){

            ng.item.vdesc = (((ng.item.pdesc / 100)) * (ng.item.valorUn)).toFixed(2);

            ng.item.totalUn = (ng.item.valorUn - ng.item.vdesc).toFixed(2);

            ng.attTotalItem();

        };



        ng.attTotalItem = function () {

            ng.item.quantidade_total = ng.item.quantidade * ng.item.unid.quantidade;

            ng.item.total = (ng.item.totalUn * ng.item.quantidade).toFixed(2);

        };



        ng.alteraUnid = function () {

            if(ng.item.unid.desconto)

                ng.item.vdesc = ng.item.unid.desconto;

            if(ng.item.unid.padrao == 1)

                ng.item.vdesc = 0;

            ng.alteraVb();

            ng.item.valorUn = (ng.item.valor * ng.item.unid.quantidade).toFixed(2);

            ng.item.totalUn = (ng.item.valorUn - ng.item.vdesc).toFixed(2);

            ng.codBarras = ng.item.unid.cod_barras;

            ng.item.id_unidade = ng.item.unid.id;

            ng.alteraVb();

            ng.attTotalItem();

        };



        ng.verifEstoque = function () {

            if(ng.item.ps != 'servico'){

                var soma = 0;

                for(var x in ng.itens){

                    if(ng.item.id_produto == ng.itens[x].id_produto && ng.itens[x].ativo == 1){

                        soma += ng.itens[x].quantidade_total;

                    }

                }

                soma += ng.item.quantidade_total;

                if(soma > ng.item.estoque){

                    msgErro('Quantidade de Produto Indisponível no Estoque')

                }

            }

        };



        ng.attTotalPedido = function(){

            ng.pedido.total = 0;

            for(var x in ng.itens){

                if(ng.itens[x].ativo == 1){

                    ng.pedido.total = ng.pedido.total + parseFloat(ng.itens[x].total);

                }



            }

        };



        ng.catPreco = function () {

            if(ng.item.id){

                var i =0;

                for(var x in ng.item.precos){

                    if(ng.item.precos[x].id_categoria == ng.pedido.id_categoria){

                        ng.item.valor = ng.item.precos[x].preco;

                        i = 1;

                    }

                }

                if(i == 0)

                    ng.item.valor = ng.item.precos[0].preco;

                ng.item.valorUn = ng.item.valor;

                ng.attTotalItem();

                ng.alteraP();

            }

        };



        ng.buscaCli = function (id) {

            if(id && id != 0){

                operacoes.atualizar('endereco',id+'&tipo=cliente').success(function (data) {

                    if(data.length > 0){

                        ng.pedido.enderecos = data;

                        ng.pedido.endereco = data[0];

                        ng.pedido.id_endereco = data[0].id;

                    }

                });

                operacoes.atualizar('contato',id+'&tipo=cliente&mask=').success(function (data) {

                    if(data.length > 0){

                        ng.pedido.contatos = data;

                        ng.pedido.contato = data[0];

                        ng.pedido.id_contato = data[0].id;

                    }

                });

                operacoes.atualizar('cliente',id).success(function (data) {

                    if(data.length > 0){

                        if(data[0].pessoa == 'fisica'){
                            ng.pedido.nome = data[0].nome;
                        }else{
                            if(!data[0].razao || data[0].razao == '')
                                ng.pedido.nome = data[0].fantasia;
                            else
                                ng.pedido.nome = data[0].razao;
                        }

                        if(ng.itens.length == 0){

                            ng.pedido.id_categoria = data[0].id_categoria;

                        }

                        ng.pedido.id_cliente = data[0].id;

                        ng.btnVisualiza = true;

                    }else{

                        ng.btnVisualiza = false;

                    }

                });

                $('.modal').modal('hide');

            }

        };



        ng.buscaProd = function (id,tipo) {

            operacoes.atualizar('produto', id).success(function (data) {

                if (data != "null") {

                    ng.item = data;

                    ng.item.quantidade = 1;

                    ng.item.id_produto = data.id;

                    ng.item.id = 0;

                    ng.item.valor = ng.item.valorUn = data.valor;

                    ng.item.totalUn = ng.item.valorUn;

                    ng.item.pdesc = 0.00;

                    ng.item.vdesc = 0.00;

                    ng.item.ps = data.tipo;

                    ng.unidades = data.unidades;

                    ng.item.unid = ng.unid_sel;

                    if(rp.id)

                        ng.item.id_pedido = rp.id;

                    ng.verifEstoque();

                }

            });

            $('.modal').modal('hide');

            if (tipo == 1) {

                ng.item.unid = ng.unid_sel;

                ng.catPreco();

                ng.alteraUnid();

            }else if (tipo == 0) {

                operacoes.atualizar('embalagemProd', id + "&padrao=").success(function (data) {

                    ng.item.unid = data;

                    ng.catPreco();

                    ng.alteraUnid();

                });

            }

        };



        ng.catPrecoTroca = function(){

            if(ng.item)

                ng.catPreco();

            else

                n

        };



        ng.buscaP = function () {

            if(ng.busca){

                operacoes.atualizar('busca',  '&busca='+ng.busca).success(function (data) {

                    if(data.tipoB == "prod"){

                        ng.buscaProd(data.id,0)

                    }else if(data.tipoB == "barra"){

                        delete data.tipoB;

                        ng.unid_sel = ng.item.unid = data;

                        ng.buscaProd(data.id_produto,1)

                    }else if(data.tipoB == "modal" || data == "null"){

                        ng.ModalBuscaProd();

                    }

                });

            }

        };



        //--------------------- Modal ----------------------------------



        ng.ModalBuscaProd = function () {

            operacoes.atualizar('produto','lista').success(function (data) {

                ng.resultados = data;

            });

            $('.modal').modal('hide');

            $ekathuwa.modal({

                id: "produtos",

                scope: $scope,

                templateURL: "app/views/modals/modalProd.html"

            });

        };



        ng.ModalBuscaCli = function () {

            if(ng.editaCli)

                return;

            operacoes.atualizar('cliente', 'lista').success(function (data) {

                ng.resultados = data;

            });

            $('.modal').modal('hide');

            $ekathuwa.modal({

                id: "clientes",

                scope: $scope,

                templateURL: "app/views/modals/modalCli.html"

            });

        };



        ng.ModalInfoItem = function (dado) {

            ng.modal = dado;

            $ekathuwa.modal({

                id: "itens",

                scope: $scope,

                templateURL: "app/views/modals/modalInfoItem.html"

            });

        };



        ng.ModalDelItem = function (dado) {

            ng.modal = dado;

            $ekathuwa.modal({

                id: "itens",

                scope: $scope,

                templateURL: "app/views/modals/modalDel.html"

            });

        };



        ng.ModalParcela = function () {

            $ekathuwa.modal({

                id: "parcela",

                scope: $scope,

                templateURL: "app/views/modals/modalParcela.html"

            });

        };



        ng.delItem = function(dado){

            operacoes.deleta({

                lista:ng.itens,

                dado:dado,

                end:'item',

                tipo:'item',

                modal:'.modal'

            },function(err,data){

                ng.itens = data.lista;

                ng.attTotalPedido();

            })

        };



        //--------------------- Fim Modal ------------------------



        //--------------------- Operações ------------------------



        ng.agrupaItem = function () {

            for(var x in ng.itens){

                if(((ng.itens[x].ativo == 1)&&(ng.itens[x].unid.id == ng.item.unid.id))){

                    ng.itens[x].quantidade += ng.item.quantidade;

                    ng.itens[x].quantidade_total = ng.itens[x].quantidade * ng.itens[x].unid.quantidade;

                    ng.itens[x].totalUn = ng.itens[x].valorUn - ng.itens[x].vdesc;

                    ng.itens[x].total = ng.itens[x].quantidade * ng.itens[x].totalUn;

                    operacoes.salvar({

                        lista:ng.itens,

                        dado:ng.itens[x],

                        end:'item',

                        tipo:'item',

                        init:initItem()

                    },function(err,data){

                        ng.item = data.dado;

                        ng.itens = data.lista;

                        ng.attTotalPedido();

                    });

                    return true;

                }

            }

            return false;

        };



        ng.salvaItem = function () {

            if(!rp.id){

                operacoes.salvar({

                    lista:[],

                    dado:ng.pedido,

                    end:'pedido',

                    tipo:'pedido',

                    init: ng.pedido

                },function(err,data){

                    ng.pedido = data.dado;

                    ng.pedido.id = data.dado.id;

                    ng.item.id_pedido = data.dado.id;

                    operacoes.salvar({

                        lista:ng.itens,

                        dado:ng.item,

                        end:'item',

                        tipo:'item',

                        init:initItem()

                    },function(err,datab){

                        ng.item = datab.dado;

                        ng.itens = datab.lista;

                    });

                    lo.path('/faturamento/venda/editar/'+ng.item.id_pedido);

                });

            }else{

                if(!ng.agrupaItem()){

                    operacoes.salvar({

                        lista:ng.itens,

                        dado:ng.item,

                        end:'item',

                        tipo:'item',

                        init:initItem()

                    },function(err,data){

                        ng.item = data.dado;

                        ng.itens = data.lista;

                        ng.attTotalPedido();

                    });

                }

            }

            ng.salvaParc = true;

        };



        ng.salvaPed = function(){

            preventExit = 0;

            operacoes.salvar({

                lista:[],

                dado:ng.pedido,

                end:'pedido',

                tipo:'pedido',

                init:{}

            },function(err,data){

            });

        };



        ng.alteraEnd = function(){

            ng.pedido.id_endereco = ng.pedido.endereco.id;

            ng.pedido.endereco_entrega = ng.pedido.endereco.logradouro+', '+ng.pedido.endereco.numero+' - '+ng.pedido.endereco.localidade+'-'+ng.pedido.endereco.uf+' - '+ng.pedido.endereco.cep;

        };



        ng.alteraCont = function(){

            ng.pedido.id_contato = ng.pedido.contato.id;

        };



        ng.salvaParcelas = function (fatura) {

            operacoessm.deleta({

                lista:[],

                dado:{id:ng.pedido.id},

                end:'contasReceber'

            },function(err,data){

                if(data.data.erro == 0){

                    for(var i in ng.parcelas) {

                        ng.parcelas[i].id = 0;

                        operacoessm.salvar({

                            lista: ng.parcelas,

                            dado: ng.parcelas[i],

                            end: 'contasReceber'

                        }, function (err, data) {

                        });

                    }

                }

                ng.salvaParc = true;



            });



        };



        ng.parcelasValor = function () {

            var valor = 0;

            var parcelas = 0;

            for(var i in ng.parcelasb){

                if(ng.parcelas[i].valor_custom){

                    if((valor + ng.parcelas[i].valor) > ng.pedido.total){

                        ng.parcelas[i].valor = ng.pedido.total- valor;

                        valor = ng.pedido.total;

                        break;

                    }else{

                        valor += ng.parcelas[i].valor;

                        parcelas++;

                    }



                }else{

                    ng.parcelas[i].valor = 0

                }

            }

            valor = ((ng.pedido.total - valor)/(ng.pedido.parcelas - parcelas)).toFixed(2);

            var valorB = parseFloat(valor + 0);

            if(valor < 0)

                valor = 0;

            for(var i in ng.parcelasb){

                if(!ng.parcelas[i].valor_custom){

                    if(i == ng.parcelasb.length-1){

                        var valorF = 0

                        for(var k in ng.parcelas){

                            valorF += ng.parcelas[k].valor

                        }

                        valor = ng.pedido.total - valorF;

                        ng.parcelas[i].valor = parseFloat(valor.toFixed(2));

                        ng.parcelas[i].valor = ng.parcelas[i].valor;

                    }else{

                        ng.parcelas[i].valor = parseFloat(valor);

                        valorB += parseFloat(valor);

                    }

                }



            }





        };



        ng.parcelasCalc = function () {

            if(ng.parcelas.length != ng.pedido.parcelas || ng.pedido.data_inicial != ng.parcelas[0].data || ng.totalParcelas() != ng.pedido.total){

                ng.parcelasb = [];

                ng.parcelas = [];

                var dias = ng.pedido.dias;

                var dia_atual = 172800000;

                for(var i = 0; i < ng.pedido.parcelas; i++){

                    var data = $filter('date')(new Date(ng.pedido.data_inicial).getTime()+dia_atual, 'yyyy-MM-dd');

                    ng.parcelasb[i] = {data:new Date(data).toISOString()};

                    dia_atual += dias*89280000;

                }

                for(var x = 0; x < ng.pedido.parcelas; x++){

                    ng.parcelas[x] = {data:ng.trocaData(ng.parcelasb[x].data),valor:0,pago:0,faturado:0,id_pedido:rp.id,id_cliente:ng.pedido.id_cliente ? ng.pedido.id_cliente : 0,valor_custom:0,parcela:x+1};

                }

                ng.salvaParc = false;

                ng.parcelasValor();

            }

            ng.ModalParcela();

        };



        $scope.dateOptions = {

            formatYear: 'yy'

        };



        ng.faturaPed = function () {

            preventExit = 0;

            if(ng.parcelas.length != ng.pedido.parcelas || ng.totalParcelas() != ng.pedido.total){

                msgErro("Verifique as Parcelas e Salve!");

                ng.parcelasCalc();

            }else if(!ng.pedido.id_cliente){

                msgErro("Cliente nâo selecionado!");

            }else{

                for(var i in ng.operacoes){

                    if(ng.operacoes[i].id == ng.pedido.id_operacao){

                        if(ng.operacoes[i].cr == 1){

                            aj.get('core/obj/contasReceber.php?faturado='+rp.id).success(function (data) {

                            });

                        }else{

                            ng.salvaParcelas();

                        }

                        if(ng.operacoes[i].faturamento == 1)

                            ng.pedido.status = 4;

                        else

                            ng.pedido.status = 3;

                        if(ng.operacoes[i].estoque == 1){



                        }

                        ng.pedido.finalizado = 1;

                        operacoes.salvar({

                            lista:[],

                            dado:ng.pedido,

                            end:'pedido',

                            tipo:'pedido',

                            init:{}

                        },function(err,data){

                            if(data.dado.erro != 0)

                                operacoessm.salvar({

                                    lista:[],

                                    dado:{},

                                    end:'estoque',

                                    id:'?tipo=baixar&id='+ng.pedido.id

                                },function(err,datab){

                                    console.log(datab);

                                    lo.path('/faturamento/venda/lista');

                                });

                        });

                        break;

                    }

                }

            }

        };



        ng.totalParcelas = function () {

            var valor = 0;

            for(var i in ng.parcelas){

                valor += ng.parcelas[i].valor;

            }

            return valor;

        };


        /*
            Função que deixa a escolha do Tipo de Operação obrigatória
    
            Se pedido.id_operacao estiver vazio preventExit fica igual a 1
            Somente após escolher o tipo de operação e clicar em salvar, preventExit volta a ser 0
            (nas funções salvar e finalizar existe um preventExit=0)
        */
        var preventExit = 0;
        setTimeout(function(){
            if(rp.id && ng.pedido.id_operacao==''){
                preventExit = 1;
            }            
        }, 1000);
        $scope.$on('$locationChangeStart', function( event ) {
            if(preventExit==1){
                alert('Salve um tipo de operação!');
                event.preventDefault();
            }                
        });


    });



    app.controller('HomeCtrl', function ($rootScope, $location,$window) {

        $rootScope.activetab = $location.path();

        var wi = $window;

        wi.scrollTo(0,0);

    });



    app.controller('Login', function ($rootScope, $location, $scope, $http, $window, $routeParams, Login) {

        var aj = $http;

        var ng = $scope;

        var wi = $window;

        var rp = $routeParams;

        var rs = $rootScope;

        var lo = $location;



        ng.foologin = Login;

        ng.foologin.Autentica();



    });



    app.controller('ConfigsCliCtrl', function ($rootScope, $location, $scope, $http, $window, $routeParams, operacoes) {

        var aj = $http;

        var ng = $scope;

        var wi = $window;

        var rp = $routeParams;

        var rs = $rootScope;

        var lo = $location;



        if(rs.session.nivel == 'usuario')

            lo.path('#/');



        $rootScope.activetab = "/configs";



        var initCat = function(){

            return {"id": 0,"descricao":""};

        };


        ng.categoria =  {"id": 0,"descricao":""};

        aj.get('core/obj/categoriaCli.php').success(function (data) {

            ng.categorias = data;

        });



        ng.salvaCat = function () {

                operacoes.salvar({

                    lista:ng.categorias,

                    dado:ng.categoria,

                    end:'categoriaCli',

                    tipo:'categoria',

                    init: initCat()

                },function(err,data){

                    ng.categorias = data.lista;

                    ng.categoria = data.dado;

                })

        };



        ng.editaCat = function (data) {

            ng.categoria = data;

        };





        ng.delCatMod = function(data){

            ng.modal = data;

            $('#Cat').modal('show');

        };



        ng.delCat = function(dado){

            operacoes.deleta({

                lista:ng.categorias,

                dado:dado,

                end:'categoriaCli',

                tipo:'categoria',

                modal:'#Cat'

            },function(err,data){

                ng.categorias = data.lista;

            })

        };



    });



    app.controller('ConfigsFunCtrl', function ($rootScope, $location, $scope, $http, $window, $routeParams, operacoes) {

        var aj = $http;

        var ng = $scope;

        var wi = $window;

        var rp = $routeParams;

        var rs = $rootScope;

        var lo = $location;



        wi.scrollTo(0,0);

        if(rs.session.nivel == 'usuario')

            lo.path('#/');



        $rootScope.activetab = "/configs";



        ng.permissao = {"id": 0,"descricao":""};

        aj.get('core/obj/permissao.php').success(function (data) {

            ng.permissoes = data;

        });



        ng.salvaPerm = function () {

            operacoes.salvar({

                lista:ng.permissoes,

                dado:ng.permissao,

                end:'permissao',

                tipo:'permissao',

                init: {"id": 0,"descricao":""}

            },function(err,data){

                ng.permissoes = data.lista;

                ng.permissao = data.dado;

            })

        };



        ng.editaPerm = function (data) {

            ng.permissao = data;

        };



        ng.delPermMod = function(data){

            ng.modal = data;

            $('#Perm').modal('show');

        };



        ng.delPerm = function(dado){

            operacoes.deleta({

                lista:ng.permissoes,

                dado:dado,

                end:'permissao',

                tipo:'permissao',

                modal:'#Perm'

            },function(err,data){

                ng.permissoes = data.lista;

            })

        };

    });



    app.controller('ConfigsEmpCtrl', function ($rootScope, $location, $scope, $http, $window, $routeParams, operacoes,cadastro) {

        var aj = $http;

        var ng = $scope;

        var wi = $window;

        var rp = $routeParams;

        var rs = $rootScope;

        var lo = $location;



        wi.scrollTo(0,0);

        rs.activetab = "/configs";



        if(rs.session.nivel != "super")

            lo.path('#/');



        aj.get('core/obj/empresa.php').success(function (data) {

            ng.empresa = data;

        });



        ng.salvaEmpresa = function(){

                cadastro.add(ng.empresa, "empresa",0);

        };

    });



    app.controller('ConfigsBackCtrl', function ($rootScope, $location, $scope, $http, $window, $routeParams, operacoes,cadastro) {

        var aj = $http;

        var ng = $scope;

        var wi = $window;

        var rp = $routeParams;

        var rs = $rootScope;

        var lo = $location;



        wi.scrollTo(0,0);

        rs.activetab = "/configs";



        if(rs.session.nivel != "super")

            lo.path('#/');





        ng.backup = function(){

            aj.get('core/sistema/backup.php').success(function (data) {

                if(data.erro == 0){

                    msgSucesso('Backup efetuado com sucesso!, verifique seu email!');

                }else{

                    msgErro('Backup não foi efetuado com sucesso!');

                }

            });

        };

    });



    app.controller('ConfigsProdCtrl', function ($rootScope, $location, $scope, $http, $window, $routeParams, operacoes) {

        var aj = $http;

        var ng = $scope;

        var wi = $window;

        var rp = $routeParams;

        var rs = $rootScope;

        var lo = $location;



        wi.scrollTo(0,0);

        if(rs.session.nivel == 'usuario')

            lo.path('#/');



        $rootScope.activetab = "/configs";



        ng.categoria = {"id": 0,"descricao":"","abreviado":""};

        aj.get('core/obj/categoria.php').success(function (data) {

            ng.categorias = data;

        });

        ng.unidade = {"id": 0,"descricao":"","abreviado":""};

        aj.get('core/obj/unidade.php').success(function (data) {

            ng.unidades = data;

        });



        ng.embalagem = {"id": 0,"descricao":"","abreviado":""};

        aj.get('core/obj/embalagem.php').success(function (data) {

            ng.embalagens = data;

        });



        //--------------------------------------------------------



        ng.salvaUni = function () {

            operacoes.salvar({

                lista:ng.unidades,

                dado:ng.unidade,

                end:'unidade',

                tipo:'unidade',

                init: {"id": 0,"descricao":"","abreviado":""}

            },function(err,data){

                ng.unidades = data.lista;

                ng.unidade = data.dado;

            })

        };



        ng.editaUni = function (data) {

            ng.unidade = data;

        };



        ng.delUniMod = function(data){

            ng.modal = data;

            $('#Uni').modal('show');

        };



        ng.delUni = function(dado){

            operacoes.deleta({

                lista:ng.unidades,

                dado:dado,

                end:'unidade',

                tipo:'unidade',

                modal:'#Uni'

            },function(err,data){

                ng.unidades = data.lista;

            })

        };



        //--------------------------------------------------------------



        ng.salvaCat = function () {

            operacoes.salvar({

                lista:ng.categorias,

                dado:ng.categoria,

                end:'categoria',

                tipo:'categoria',

                init: {"id": 0,"descricao":""}

            },function(err,data){

                ng.categorias = data.lista;

                ng.categoria = data.dado;

            })

        };



        ng.editaCat = function (data) {

            ng.categoria = data;

        };



        ng.delCatMod = function(data){

            ng.modal = data;

            $('#Cat').modal('show');

        };



        ng.delCat = function(dado){

            operacoes.deleta({

                lista:ng.categorias,

                dado:dado,

                end:'categoria',

                tipo:'categoria',

                modal:'#Cat'

            },function(err,data){

                ng.categorias = data.lista;

            })

        };



        //---------------------------------------------------



        ng.salvaEmb = function () {

            operacoes.salvar({

                lista:ng.embalagens,

                dado:ng.embalagem,

                end:'embalagem',

                tipo:'embalagem',

                init: {"id": 0,"descricao":"","abreviado":""}

            },function(err,data){

                ng.embalagens = data.lista;

                ng.embalagem = data.dado;

            })

        };



        ng.editaEmb = function (data) {

            ng.embalagem = data;

        };



        ng.delEmbMod = function(data){

            ng.modal = data;

            $('#Emb').modal('show');

        };



        ng.delEmb = function(dado){

            operacoes.deleta({

                lista:ng.embalagens,

                dado:dado,

                end:'embalagem',

                tipo:'embalagem',

                modal:'#Emb'

            },function(err,data){

                ng.embalagens = data.lista;

            })

        };



    });



    app.controller('CadastroProdListaCtrl', function ($rootScope, $location, $scope, $http, $window, $routeParams,$ekathuwa) {

        var aj = $http;

        var ng = $scope;

        var wi = $window;

        var rp = $routeParams;

        var rs = $rootScope;

        var lo = $location;

        wi.scrollTo(0,0);

        rs.activetab = '/cadastro';

        ng.tipo = rp.tipo;

        ng.pagina = "Cadastro";

        ng.titulo = "Lista Produtos/Serviços";

        ng.mostrarTudo = false

        ng.cadastros = {};

        aj.get('core/obj/produto.php?id=lista').success(function (data) {

            ng.cadastros = data;

        });



        ng.editaProd = function(dado){

            $('.modal').modal('hide');

            ng.direciona(dado.id);

        };



        ng.direciona = function(dado){

            lo.path('cadastro/produto/editar/'+dado);

        };



        ng.mostraInfos = function(dado){

            ng.modal = dado;

            $('.modal').modal('hide');

            if(dado.tipo == 'servico'){

                ng.tituloModal = 'Serviço';

            }else{

                ng.tituloModal = 'Produto';

            }



            $ekathuwa.modal({

                scope: $scope,

                templateURL: "app/views/modals/modalInfoProd.html"

            });

        };



    });



    app.controller('CadastroListaCtrl', function ($rootScope, $location, $scope, $http, $window, $routeParams) {

        var aj = $http;

        var ng = $scope;

        var wi = $window;

        var rp = $routeParams;

        var rs = $rootScope;

        var lo = $location;



        wi.scrollTo(0,0);

        ng.pagina = "Cadastro";

        rs.activetab = '/cadastro';

        ng.tipo = rp.tipo;

        if (rp.tipo == 'fornecedor') {

            ng.titulo = "Lista Fornecedores";

        } else if (rp.tipo == 'cliente') {

            ng.titulo = "Lista Clientes";

        } else if (rp.tipo == 'funcionario') {

            ng.pessoa = 'fisica';

            if(rs.session.nivel == 'usuario'){

                lo.path('cadastro/funcionario/editar/'+rs.session.id);

            }

            ng.titulo = "Lista Funcionário";

        }

        ng.cadastros = {};



        aj.get('core/obj/' + rp.tipo + '.php?id=lista').success(function (data) {

            ng.cadastros = data;

        });



        ng.abremodal = function(cads) {

            ng.modal = cads;

            $('#myModal').modal('show');

        };

    });



    app.controller('CadastroFunListaCtrl', function ($rootScope, $location, $scope, $http, $window, $routeParams) {

        var aj = $http;

        var ng = $scope;

        var wi = $window;

        var rp = $routeParams;

        var rs = $rootScope;

        var lo = $location;



        wi.scrollTo(0,0);

        rs.activetab = '/cadastro';

        if(ng.session.nivel == 'usuario'){

            lo.path('/cadastro/funcionario/editar/'+ng.session.id);

        }

        ng.pagina = "Cadastro";
        //USANDO MESMA VIEW, MESMO MODEL PARA AS TELAS CADASTRO USUARIO, E FUNCIONARIO. VERIFICANDO A DIFERENCA SOMENTE NA URL
        var caminho = $location.path().split('/');
        if(caminho[2] == 'usuario'){
            ng.titulo = "Lista Usuários";
            ng.botao = "Novo Usuário";
            ng.hrefNovo = "#/cadastro/usuario/novo/"
        }else if(caminho[2] == 'funcionario'){
            ng.titulo = "Lista Funcionários";
            ng.botao = "Novo Funcionário";
            ng.hrefNovo = "#/cadastro/funcionario/novo/"
        }



        ng.cadastros = {};


        if(caminho[2] == 'usuario'){
          aj.get('core/obj/usuario.php?id=lista').success(function (data) {
              ng.cadastros = data;
          });
        }else if(caminho[2] == 'funcionario'){
          aj.get('core/obj/funcionario.php?id=lista').success(function (data) {
              ng.cadastros = data;
          });
        }




        ng.abremodal = function(cads) {

            ng.modal = cads;

            $('#myModal').modal('show');

        };

    });


    /*CADASTRO CONTROLLER*/
    app.controller('CadastroCtrl', function ($rootScope, $location, $scope, $http, $window, $routeParams, cpf_cnpj, cadastro, operacoes) {

        /*-------INICIALIZAÇÃO-------*/

        var aj = $http;

        var ng = $scope;

        var wi = $window;

        var rp = $routeParams;

        var rs = $rootScope;

        var lo = $location;

        wi.scrollTo(0,0);

        var arr_path = lo.path().split("/");

        // $scope.verificaQtdeUsuarios = function(){
        //   console.log('verificando usuarios...');
        //   var type = 'verificando';
        //   $http.post(
        //     'core/obj/plano.php',
        //     type
        //   ).success(function(data){
        //     var result = data.split("null");
        //     console.log(result);
        //     if(result[1] == "true" && rp.tipo != "cliente"){
        //       $scope.limiteUsuario = true;
        //       console.log('atingiu o limite');
        //     }
        //
        //   }).error(function(data){
        //     console.log(data);
        //   })
        // }
        //
        // $scope.verificaQtdeUsuarios();

        ng.tipocad = rp.tipo;

        if (rp.id)

            ng.id_cliente = rp.id;

        else

            ng.id_cliente = 0;

        rs.activetab = '/cadastro';

        ng.pagina = "Cadastro";

        if (rp.tipo == "fornecedor" || rp.tipo == "cliente") {

            if (arr_path[3] == 'editar') {

                ng.edita = true;

            } else if (arr_path[3] == 'novo') {

                ng.edita = false;



            }

            if (rp.tipo == 'fornecedor') {

                if (ng.edita) {

                    ng.titulo = "Edita Fornecedor";

                } else {

                    ng.titulo = "Cadastro Fornecedor";

                }

            } else if (rp.tipo == 'cliente') {

                if (ng.edita) {

                    ng.titulo = "Edita Cliente";

                } else {

                    ng.titulo = "Cadastro Cliente";

                }

            }

        } else {

            lo.path('/');

        }




        operacoes.atualizar('funcionario','listaB').success(function (data) {

            ng.funcionarios = data;

        });
        var initCont = function(){

            return {"id": 0,"id_cliente": rp.id,"falar": "","fixo": "","fax": "","celular": "","email": "","tipo": rp.tipo};

        };

        var initEnd = function(){

            return {"id": 0,"id_cliente": rp.id,"bairro": "","logradouro": "","cep": "","uf": "","localidade": "","numero": "","complemento": "","tipo": rp.tipo};

        };

        var initCad = function(){

            return {"id": 0,"pessoa": "fisica","cpf": "","cnpj": "","ie": "","nascimento": "","rg": "","fantasia": "","razao": "","nome": "","ativo": 1,"id_categoria": 0,"sel_id_categoria": 0};

        };



        var init = function () {

            if (ng.id_cliente > 0) {

                ng.contato = initCont();

                ng.endereco = initEnd();

                aj.get('core/obj/' + rp.tipo + '.php?id=' + rp.id).success(function (data) {

                    ng.cadastro = data[0];

                });

                aj.get('core/obj/endereco.php?id=' + rp.id + '&tipo=' + rp.tipo).success(function (data) {

                    ng.enderecos = data;

                });

                aj.get('core/obj/contato.php?id=' + rp.id + '&tipo=' + rp.tipo).success(function (data) {

                    ng.contatos = data;

                });

            } else {

                ng.cadastro = initCad();

            }

            ng.cnpjvalido = ng.cpfvalido = true;

            operacoes.atualizar("categoriaCli", "").success(function (data) {

                ng.categorias = data;

                for(var f in data){

                    if(data[f].id == ng.cadastro.id_categoria){

                        ng.cadastro.sel_id_categoria = data[f];

                    }



                }

            });

        };



        init();



        /*--------FIM INICIALIZAÇÃO--------*/



        /*---------CADASTRO-----------*/





        ng.validaCNPJ = function(cnpj){

            ng.cnpjvalido = cpf_cnpj.validaCNPJ(cnpj);

        };



        ng.validaCPF = function(cpf){

            ng.cnpjvalido = cpf_cnpj.validaCPF(cpf);

        };



        ng.salvaCad = function () {



            if (ng.cadastro.pessoa == 'fisica' && !ng.cpfvalido) {

                msgErro("CPF Inválido!");

                return;

            }

            if (ng.cadastro.pessoa == 'juridica' && !ng.cnpjvalido) {

                msgErro("CNPJ Inválido!");

                return;

            }

            if(ng.cadastro.pessoa == 'fisica' && ng.cadastro.nome == ''){

                msgErro("Digite um nome");

                return;

            }

            cadastro.add(ng.cadastro,rp.tipo);

        };



        /*--------FIM CADASTRO--------*/



        /*---------ENDERECO-----------*/





        ng.busca = function (cep) {

            if (cep.length == 8) {

                aj.get('//cep.republicavirtual.com.br/web_cep.php?cep='+cep+'&formato=json').success(function (data) {

                    ng.endereco.uf = data.uf;

                    ng.endereco.bairro = data.bairro;

                    ng.endereco.localidade = data.cidade;

                    ng.endereco.logradouro = data.tipo_logradouro +' '+ data.logradouro;

                });

            }

        };



        ng.salvaEnd = function(){

            operacoes.salvar({

                lista:ng.enderecos,

                dado:ng.endereco,

                end:'endereco',

                tipo:'endereco',

                init:initEnd()

            },function(err,data){

                ng.enderecos = data.lista;

                ng.endereco = data.dado;

            })

        };



        ng.editaEnd = function (data) {

            ng.endereco = data;

        };



        ng.delEndMod = function(End){

            ng.modal = End;

            $('#End').modal('show');

        };



        ng.delEnd = function(dado){

            operacoes.deleta({

                lista:ng.enderecos,

                dado:dado,

                end:'endereco',

                tipo:'endereco',

                modal:'#End'

            },function(err,data){

                ng.enderecos = data.lista;

                ng.endereco = data.dado;

            })

        };

        /*---------FIM ENDERECO-----------*/



        /*---------CONTATO-----------*/

        ng.salvaCont = function(){

            operacoes.salvar({

                lista:ng.contatos,

                dado:ng.contato,

                end:'contato',

                tipo:'contato',

                init:initCont()

            },function(err,data){

                ng.contatos = data.lista;

                ng.contato = data.dado;

            })

        };



        ng.editaCont = function (data) {

            ng.contato = data;

        };



        ng.delContMod = function(Cont){

            ng.modal = Cont;

            $('#Cont').modal('show');

        };





        ng.delCont = function(dado){

            operacoes.deleta({

                lista:ng.contatos,

                dado:dado,

                end:'contato',

                tipo:'contato',

                modal:'#Cont'

            },function(err,data){

                ng.contatos = data.lista;

                ng.contato = data.dado;

            })

        };



        /*---------FIM CONTATO-----------*/

    });
    /*CADASTRO CONTROLLER*/


    app.controller('CadastroProdCtrl', function ($rootScope, $location, $scope, $http, $window, $routeParams, cadastro, operacoes) {





        /*-------INICIALIZAÇÃO-------*/

        var aj = $http;

        var ng = $scope;

        var wi = $window;

        var rp = $routeParams;

        var rs = $rootScope;

        var lo = $location;

        wi.scrollTo(0,0);

        var arr_path = lo.path().split("/");

        if (rp.id)

            ng.id_produto = rp.id;

        else

            ng.id_produto = 0;

        rs.activetab = '/cadastro';

        if (arr_path[3] == 'editar') {

            ng.edita = true;

        } else if (arr_path[3] == 'novo') {

            ng.edita = false;

        }



        if(rs.session.nivel == 'usuario')

            lo.path('/cadastro/produto/lista');





        ng.pagina = "Cadastro";

        if (ng.edita) {

            ng.titulo = "Edita Produto";

        } else if (!ng.edita) {

            ng.titulo = "Cadastro Produto/Serviço";

        }



        var initEmb = function(){

            return {"id":0,"descricao":"","id_produto":rp.id,"id_embalagem":0,"id_unidade":0,"desconto":"","largura":"","altura":"","profundidade":"","cod_barras":"","quantidade":1,"peso_liq":"","peso_brut":""};

        };

        var initCad = function(){

            return {"id": 0,"descricao":"", "nome": "", "tipo": "produto","cod_barras": "","cod_fabrica": "","valor": 0,"estoque": 0,"foto": "","icms": "","ipie": "","ipis": "","kit": 0,"id_unidade": "", "id_categoria": "", "ativo": 1,"largura":"","altura":"","profundidade":"","peso_liq":"","peso_brut":""};

        };

        ng.categorias = [];

        var init = function () {

            if (rp.id > 0) {



                operacoes.atualizar("embalagem", "").success(function (data) {

                    ng.embalagens = data;

                });

                operacoes.atualizar("embalagemProd", rp.id+'&p=1').success(function (data) {

                    ng.embalagens_prod = data;

                });

                operacoes.atualizar("unidade", "").success(function (data) {

                    ng.unidades = data;

                });

                operacoes.atualizar("produto", rp.id).success(function (data) {

                    ng.cadastro = data;

                    if(ng.cadastro.tipo == 'servico'){

                        ng.titulo = "Edita Serviço";

                    }

                });

                operacoes.atualizar("embalagemProd", rp.id+'&padrao=0').success(function (data) {

                    data.id = rp.id;

                    ng.cadastro = angular.extend({}, ng.cadastro, data);

                });

                ng.embalagem = initEmb();

                aj.get('core/obj/categoriaCli.php?padrao=0').success(function (data) {

                    for(var l in data) {

                        data[l] = {

                            "id": data[l].id,

                            "preco": "",

                            "id_produto": rp.id,

                            "descricao": data[l].descricao,

                            "id_categoria": data[l].id

                        };

                    }

                    ng.categorias_cli = data;

                });

                aj.get('core/obj/precos.php?id='+rp.id).success(function (data) {

                    for(var i in ng.categorias_cli){

                        for(var j in data){

                            if(data[j].id_categoria == ng.categorias_cli[i].id){

                                ng.categorias_cli[i] = {"id":data[j].id,"preco":data[j].preco,"id_produto":rp.id,"descricao":ng.categorias_cli[i].descricao,"id_categoria":ng.categorias_cli[i].id};

                                break;

                            }

                        }

                    }

                    ng.precos = ng.categorias_cli;



                });

                ng.tab_p = {"id":0,"id_produto":rp.id,"id_categoria":0};

                operacoes.atualizar("precos", rp.id+'&padrao=1').success(function (data) {

                   // ng.cadastro.valor = data.preco;

                });

            } else {

                ng.cadastro = initCad()

            }

            operacoes.atualizar("categoria", "").success(function (data) {

                ng.categorias = data;

            });

        };



        init();



        /*--------FIM INICIALIZAÇÃO--------*/



        ng.abreInfo = function(dado){

            ng.modal = dado;

            $('#Infos').modal('show');

        };



        ng.editaEmb = function(dado){

            ng.embalagem = dado;

            $('#Infos').modal('hide');

        };



        ng.salvaEmb = function(){

            operacoes.salvar({

                lista:ng.embalagens_prod,

                dado:ng.embalagem,

                end:'embalagemProd',

                tipo:'embalagem',

                init: initEmb()

            },function(err,data){

                ng.embalagens_prod = data.lista;

                ng.embalagem = data.dado;

            })

        };



        ng.attEmb = function(dado){

            for(var x in ng.embalagens){

                if(ng.embalagens[x].id == dado){

                    ng.embalagem.emb_abreviado = ng.embalagens[x].abreviado;

                    break;

                }

            }

        };



        ng.attUnid = function(dado){

            for(var x in ng.unidades){

                if(ng.unidades[x].id == dado){

                    ng.embalagem.unid_abreviado = ng.unidades[x].abreviado;

                    break;

                }

            }

        };





        /*---------CADASTRO-----------*/



        ng.salvaCad = function(){

            cadastro.add(ng.cadastro, "produto");

        };





        ng.salvaP = function (dado) {

                aj.post('core/obj/precos.php', dado).success(function (data) {

                    if (data.erro == 0) {

                        msgSucesso("Preço Salvo com Sucesso!");

                    } else {

                        msgErro("Preço Não foi salvo!");

                    }

                });



        };



        /*--------FIM CADASTRO--------*/

    });



    app.controller('CadastroFunCtrl', function ($rootScope, $location, $scope, $http, $window, $routeParams, cpf_cnpj,cadastro) {



        /*-------INICIALIZAÇÃO-------*/

        var aj = $http;

        var ng = $scope;

        var wi = $window;

        var rp = $routeParams;

        var rs = $rootScope;

        var lo = $location;

        wi.scrollTo(0,0);

        var arr_path = lo.path().split("/");
        $scope.tipoUsuarioAtual = arr_path[2];
        //console.log($scope.tipoUsuarioAtual);
        if($scope.tipoUsuarioAtual=='usuario'){
          $scope.verificaQtdeUsuarios = function(){
            var caminho = $location.path().split("/");
            if(caminho[3] != 'editar'){
              var type = 'verificando';
              $http.post(
                'core/obj/plano.php',
                type
              ).success(function(data){
                var result = data.split("null");
                console.log(result)
                if(result[1] == "true"){
                  $scope.limiteUsuario = true;
                  console.log('atingiu o limite');
                }
              }).error(function(data){
                console.log(data);
              })
            }
          }
          $scope.verificaQtdeUsuarios();
        }

        ng.id_cliente = rp.id;

        rs.activetab = '/cadastro';



        if(rs.session.nivel == 'usuario' && rp.id != rs.session.id){
            if($scope.tipoUsuarioAtual == "usuario"){
                lo.path('/cadastro/usuario/editar/'+rs.session.id);
            }else {
              lo.path('/cadastro/funcionario/editar/'+rs.session.id);
            }
        }

        if (arr_path[3] == 'editar') {
          if($scope.tipoUsuarioAtual=='usuario'){
            ng.titulo = "Edita Usuário";
            ng.hideField = true;
          }else if($scope.tipoUsuarioAtual=='funcionario'){
            ng.titulo = "Edita Funcionário";
            ng.hideField = false;
          }
        } else if (arr_path[3] == 'novo') {
          if($scope.tipoUsuarioAtual=='usuario'){
            ng.titulo = "Cadastro Usuário";
            ng.pagina = 'Usuários';
            ng.hideField = true;
          }else if($scope.tipoUsuarioAtual=='funcionario'){
            ng.titulo = "Cadastro Funcionário";
            ng.pagina = 'Funcionários';
            ng.hideField = false;
          }
        }



        aj.get('core/obj/permissao.php').success(function (data) {

            ng.permissoes = data;

        });



        var initCad = function(){

            return {"id": 0,"nome": "" ,"login": "","senha": "","csenha": "","comissao": "0","cpf": "","nascimento": "","rg": "","bairro": "","logradouro": "","cep": "","uf": "","localidade": "","numero": "","complemento": "","fixo": "","celular": "","email": "","ativo": 1};

        };



        var init = function () {

            if (ng.id_cliente >= 0) {

              if($scope.tipoUsuarioAtual=="usuario"){
                aj.get('core/obj/usuario.php?id=' + rp.id).success(function (data) {
                    ng.cadastro = data[0];
                });
              }else {
                aj.get('core/obj/funcionario.php?id=' + rp.id).success(function (data) {
                    ng.cadastro = data[0];
                });
              }


            } else {

                ng.cadastro = initCad();

            }

            ng.cpfvalido = true;

        };



        init();



        /*--------FIM INICIALIZAÇÃO--------*/



        /*---------CADASTRO-----------*/



        ng.validaCPF = function(cpf){

            ng.cnpjvalido = cpf_cnpj.validaCPF(cpf);

        };



        ng.salvaCad = function () {

            if (!ng.cpfvalido) {

                msgErro("CPF Inválido!");

                return;

            }

            if (ng.cadastro.senha != ng.cadastro.csenha) {

                msgErro("A senha de confirmação não corresponde!");

                return;

            }


            if($scope.tipoUsuarioAtual=="usuario"){
              cadastro.add(ng.cadastro,"usuario");
            }else if($scope.tipoUsuarioAtual=="funcionario"){
              cadastro.add(ng.cadastro,"funcionario");
            }


        };



        /*--------FIM CADASTRO--------*/



        /*---------ENDERECO-----------*/



        ng.busca = function (cep) {

            if (cep.length == 8) {

                aj.get('//cep.correiocontrol.com.br/' + cep + '.json').success(function (data) {

                    ng.cadastro.cep = data.cep;

                    ng.cadastro.uf = data.uf;

                    ng.cadastro.bairro = data.bairro;

                    ng.cadastro.localidade = data.localidade;

                    ng.cadastro.logradouro = data.logradouro;

                });

            }

        };

    });


    app.controller('CadastroComissaoCtrl', function ($rootScope, $location, $scope, $http, $window, $ekathuwa, operacoes, $q) {

        /*-------INICIALIZAÇÃO-------*/

        var aj = $http;

        var ng = $scope;

        var wi = $window;

        var rs = $rootScope;

        var lo = $location;





        wi.scrollTo(0,0);

        if(rs.session.nivel == 'usuario')
            lo.path('/');

        ng.pagina = "Cadastro de Comissão";

        ng.titulo = "Comissão";

        ng.meses = [];

        ng.anos = [];

        ng.alunos = [];

        ng.valeUsado = [];

        ng.total = 0;

        ng.comissao = 0;

        ng.recebido = 0;

        ng.imprimir = [];

        var datai = "";

        var dataf = "";

        for(var i = 2014; i <= moment().year()+1; i++){
            ng.anos[i-2014] = i;
        }

        for(var i = 0; i < 12; i++){
            ng.meses[i] = {id:i+1, mes:moment().months(i).format('MMMM')};
        }

        ng.data = {mes:moment().months()+1, ano: moment().year()};


        function init(){
            operacoes.atualizar('funcionario','listaB').success(function (data) {

                ng.funcionarios = data;

            });
        }
        init();



        ng.deletaComissao = function(dado){
            if(dado.ativo){
                ng.modalMsg = "Tem certeza que deseja cancelar este pagamento? O pagamento será estornado.";

                ng.modalCancelar = dado.id;

                fechaModal();

                $ekathuwa.modal({

                    scope: $scope,

                    templateURL: "app/views/modals/modalDelComissao.html"

                });
            }
        };

        ng.cancelaComissao = function(){
            operacoes.deleta({
                lista:[],
                dado:{
                    id: ng.modalCancelar
                },

                end:'comissao',

                tipo:'comissao',

                init:{}

            },function(err,data){
                ng.attFunc();
                ng.buscaComData();
                init();
                ng.modalCancelar = null;

            });


        }


        var verificaPagamento = function(){
            aj.post('core/obj/comissao.php?id=verificaPagamento', {mes:datai, mesf:dataf, id_funcionario: ng.funcionario.id, comissao: ng.comissao}).then(function(res){
                if(!res.data.erro)
                    msgSucesso('Comissão Atualizada');
            });
        }

        ng.buscaComData = function(){

            datai = moment().month(ng.data.mes-1).year(ng.data.ano).date(1).format('YYYY-MM-DD');

            dataf = moment().month(ng.data.mes).year(ng.data.ano).date(0).format('YYYY-MM-DD');

            operacoes.atualizar('contasReceber','lista&datai='+datai+'&dataf='+dataf+'&funcionario='+ng.funcionario.id).success(function (data) {

                ng.contasReceber = data;
                ng.total = 0;
                ng.comissao = 0;

                for(var i = 0; i < data.length; i++){
                    if(data[i].vencido != 4)
                        ng.total += data[i].valor;
                }
                ng.comissao = ng.total*(ng.funcionario.comissao/100);
                if(!ng.tabela){
                    verificaPagamento();
                    ng.attFunc();
                }
                ng.tabela = true;

                operacoes.atualizar('comissao',ng.funcionario.id).success(function (data) {
                    ng.valeMes = 0;
                    ng.consumoMes = 0;
                    ng.recebido = 0;
                    ng.recebidoR = false;
                    ng.valeUsado = [];
                    ng.comissoes = data;
                    for(var i =  0; i < ng.comissoes.length; i++){
                        ng.comissoes[i].data = moment(data[i].data).format();
                        ng.comissoes[i].mes = moment(data[i].mes).format();
                        var datam = moment(data[i].mes).format('YYYY-MM-DD');
                        if(datam >= datai && datam <= dataf && data[i].ativo)
                            if(data[i].vale){
                                ng.valeMes += data[i].valor;
                                ng.valeUsado.push(data[i].vale);
                            }
                            else if(data[i].consumo)
                                ng.consumoMes += data[i].valor;
                            else{
                                ng.recebido += data[i].valor;
                                ng.recebidoR = true;
                            }
                        if(!ng.verificaVales(1))
                            ng.valeR = 1;
                        else if(!ng.verificaVales(2))
                            ng.valeR = 2;
                    }

                });

            });

            operacoes.atualizar('cliente','lista&funcionario='+ng.funcionario.id).success(function (data) {

                ng.clientes = data;

            });

            ng.tipo = 'vale';
            if(ng.valeUsado.length == 2)
                ng.tipo = 'consumo';
            ng.creditoFunc();
        }



        ng.enviaComissao = function(){

            if (ng.tipo == 'vale'){
                ng.vale = ng.valeR;
                ng.consumo = 0;
            }
            else if(ng.tipo == 'consumo'){
                ng.consumo = 1;
                ng.vale = 0;
            }
            else if(ng.tipo == 'comissao'){
                ng.consumo = 0;
                ng.vale = 0;
            }
            if(!ng.valor_comissao)
                ng.valor_comissao = 0;

            operacoes.salvar({

                lista:[],
                dado:{
                    id_funcionario: ng.funcionario.id,
                    valor: ng.valor_comissao,
                    valor_comissao: ng.vale || ng.consumo? 0 : ng.comissao,
                    mes: moment().month(ng.data.mes-1).year(ng.data.ano).date(1).format('YYYY-MM-DD'),
                    vale: ng.vale,
                    consumo: ng.consumo,
                    obs: ng.obs
                },

                end:'comissao',

                tipo:'comissao',

                init:{}

            },function(err,data){

                ng.valor_comissao = 0;
                ng.attFunc();
                ng.buscaComData();
                init();

            });
        }

        ng.creditoFunc = function(){
            if(ng.funcionario && ng.tabela){
                return parseFloat(ng.funcionario.credito);
            }
        }

        ng.attFunc = function(){
            operacoes.atualizar('funcionario',ng.funcionario.id).success(function (data) {

                ng.funcionario = data[0];

            });
        }

        ng.verificaVales = function(vale){
            if(ng.tabela)
                for(var i = 0; i < ng.valeUsado.length; i++){
                    if(ng.valeUsado[i] == vale)
                        return true;
                }
                return false;
        }


        ng.relatorioAnual = function(){
            aj.post('impressao/funcionario/save.php',{id_funcionario:ng.funcionario.id, ano:ng.data.ano}).then(function(dado){
                if(!dado.data.erro){


                    var verPOP = window.open('impressao/funcionario/funcionarioComissao.php','_blank');

                    if(!verPOP)

                        msgErro("O bloqueio de pop-up está ativo!")
                }

            })
        }
    });


    app.factory('operacoessm', function($http,$routeParams){

        var aj = $http;

        var rp = $routeParams;

        return{

            atualizar:function(end,id){

                return aj.get('core/obj/'+end+'.php?id='+id);

            },

            salvar:function(opts,done){

                if(opts.id)

                    var id = opts.id

                else

                    var id = ""

                aj.post('core/obj/'+opts.end+'.php'+id, opts.dado)

                    .then(function(data){

                        opts.erro = data.data.erro;

                        if (data.data.erro == 0) {

                            if(opts.dado.id == 0){

                                opts.dado.id = data.data.id;

                                opts.lista = [];

                                opts.lista.unshift(opts.dado);

                            }

                        }

                        data = opts;

                        done(null,data)

                    },function(err){

                        done(err)

                    })

            },

            deleta:function (opts,done) {

                aj.delete('core/obj/'+opts.end+'.php?id='+opts.dado.id)

                    .then(function(data){

                        opts.erro = data.data.erro;

                        if (data.data.erro == 0) {

                            opts.lista = [];

                        }

                        done(null,data)

                    },function(err){

                        done(err)

                });

            }

        };

    });



    app.factory('operacoes', function($http){

        var aj = $http;

        return{

            atualizar:function(end,id){

                return aj.get('core/obj/'+end+'.php?id='+id);

            },

            salvar:function(opts,done){

                $http.post('core/obj/'+opts.end+'.php', opts.dado)

                    .then(function(data){

                        if (data.data.erro == 0) {

                            msgSucesso(sistema[opts.tipo].erro.salva[data.data.erro]);

                            if(opts.dado.id == 0){

                                opts.dado.id = data.data.id;

                                opts.lista.unshift(opts.dado);

                            }

                            opts.dado = opts.init;

                        } else {

                            if(sistema[opts.tipo].erro.salva[data.data.erro] != undefined)

                                msgErro(sistema[opts.tipo].erro.salva[data.data.erro]);

                            else

                                msgErro("Erro ao salvar!");

                        }

                        data = opts;

                        done(null,data)

                    },function(err){

                        done(err)

                    })

            },

            deleta:function (opts,done) {

                var index = opts.lista.indexOf(opts.dado);

                $http.delete('core/obj/'+opts.end+'.php?id='+opts.dado.id)

                    .then(function(data){

                        if (data.data.erro == 0) {

                            msgSucesso(sistema[opts.tipo].erro.del[data.data.erro]);

                            opts.lista.splice(index, 1);

                            $(opts.modal).modal('hide');

                        } else {

                            if(sistema[opts.tipo].erro.del[data.data.erro] != undefined)

                                msgErro(sistema[opts.tipo].erro.del[data.data.erro]);

                            else

                                msgErro("Erro ao Excluir!");

                        }

                        data = opts;

                        done(null,data)

                    },function(err){

                        done(err)

                });

            }

        };

    });



    app.factory('cadastro', function($rootScope,$http,$location){

        var aj = $http;

        var rs = $rootScope;

        var lo = $location;

        return{

            add : function (unid,end,red) {

                if (red === undefined) {

                    red = 1;

                }

                aj.post('core/obj/'+end+'.php', unid).success(function (data) {

                    if (data.erro == 0) {

                        msgSucesso(sistema.cadastro.erro.salva[data.erro]);

                        if (unid.id == 0) {

                            if(red == 1)

                                lo.path('/cadastro/'+end+'/editar/' + data.id);

                        }

                    } else {

                        if(sistema.cadastro.erro.salva[data.erro] != undefined)

                            msgErro(sistema.cadastro.erro.salva[data.erro]);

                        else

                            msgErro("Erro ao salvar!");

                    }

                });

            }

        };

    });

    var fechaModal = function(){

        $('.modal').modal('hide');

        $( "div" ).remove( ".modal-backdrop" );

    };



    app.factory('Login', function($rootScope,$http){

        var aj = $http;

        var rs = $rootScope;

        return{

            Login : function(login){

                login.msg = false;

                aj.post('core/obj/login.php', login).success(function (data) {

                    if(data.erro == false){

                        rs.session = data;

                        $("#Login").modal('hide');

                        return {'login':'', 'senha':''};

                    }else{

                        return {'login':'', 'senha':''};

                    }

                })

            },

            Logout : function(){

                aj.delete('core/obj/login.php').success(function (data) {

                    if(data == false){

                        rs.session = {};

                        $("#Login").modal('show');

                    }

                })

            },

            Autentica : function(){

                aj.post('core/obj/autentica.php').success(function (data) {

                    if(data.erro == false){

                        rs.session  = data;

                    }else{

                        rs.session  = {imagem:data.imagem};

                        $("#Login").modal({

                            'show':true,

                            'backdrop':'static'

                        });

                    }

                })

            }

        };

    });


    app.factory('cpf_cnpj', function(){

        return{

            validaCPF : function (cpf) {

                if (cpf.length > 0) {

                    var exp = /\.|-/g;

                    cpf = cpf.toString().replace(exp, "");

                    var digitoDigitado = eval(cpf.charAt(9) + cpf.charAt(10));

                    var soma1 = 0, soma2 = 0;

                    var vlr = 11;

                    for (i = 0; i < 9; i++) {

                        soma1 += eval(cpf.charAt(i) * (vlr - 1));

                        soma2 += eval(cpf.charAt(i) * vlr);

                        vlr--;

                    }

                    soma1 = (((soma1 * 10) % 11) == 10 ? 0 : ((soma1 * 10) % 11));

                    soma2 = (((soma2 + (2 * soma1)) * 10) % 11);



                    if (cpf == "11111111111" || cpf == "22222222222" || cpf == "33333333333" || cpf == "44444444444" || cpf == "55555555555" || cpf == "66666666666" || cpf == "77777777777" || cpf == "88888888888" || cpf == "99999999999" || cpf == "00000000000") {

                        var digitoGerado = null;

                    } else {

                        var digitoGerado = (soma1 * 10) + soma2;

                    }



                    if (digitoGerado != digitoDigitado) {

                        msgErro("CPF Inválido!");

                        return false;

                    }

                    msgSucesso("CPF Válido!");

                    return  true;

                } else {

                    return  true;

                }

            },

            validaCNPJ : function (cnpj) {

                if (cnpj.length > 0) {

                    var numeros, digitos, soma, i, resultado, pos, tamanho, digitos_iguais;



                    cnpj = cnpj.replace(/\D+/g, '');

                    digitos_iguais = 1;



                    for (i = 0; i < cnpj.length - 1; i++)

                        if (cnpj.charAt(i) != cnpj.charAt(i + 1)) {

                            digitos_iguais = 0;

                            break;

                        }

                    if (digitos_iguais) {

                        msgErro("CNPJ Inválido!");

                        return false;

                    }



                    tamanho = cnpj.length - 2;

                    numeros = cnpj.substring(0, tamanho);

                    digitos = cnpj.substring(tamanho);

                    soma = 0;

                    pos = tamanho - 7;

                    for (i = tamanho; i >= 1; i--) {

                        soma += numeros.charAt(tamanho - i) * pos--;

                        if (pos < 2)

                            pos = 9;

                    }

                    resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;

                    if (resultado != digitos.charAt(0)) {

                        msgErro("CNPJ Inválido!");

                        return false;

                    }

                    tamanho = tamanho + 1;

                    numeros = cnpj.substring(0, tamanho);

                    soma = 0;

                    pos = tamanho - 7;

                    for (i = tamanho; i >= 1; i--) {

                        soma += numeros.charAt(tamanho - i) * pos--;

                        if (pos < 2)

                            pos = 9;

                    }



                    resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;

                    if (resultado == digitos.charAt(1))

                        msgSucesso("CNPJ Válido!");

                    else {

                        msgErro("CNPJ Inválido!");

                    }

                    return (resultado == digitos.charAt(1));

                } else {

                    return  true;

                }

            }

        };

    });

})();
