

CREATE TABLE `categoria_cliente` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `descricao` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO categoria_cliente VALUES("1","Consumidor");
INSERT INTO categoria_cliente VALUES("2","Revendedor");
INSERT INTO categoria_cliente VALUES("3","Distribuidor");
INSERT INTO categoria_cliente VALUES("5","Padrao");





CREATE TABLE `categoria_produto` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `descricao` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO categoria_produto VALUES("1","TELAS");
INSERT INTO categoria_produto VALUES("2","QUADROS");





CREATE TABLE `cliente` (
  `id` int(1) NOT NULL AUTO_INCREMENT,
  `pessoa` enum('juridica','fisica') CHARACTER SET latin1 NOT NULL,
  `nome` varchar(80) CHARACTER SET latin1 DEFAULT NULL,
  `nascimento` date DEFAULT NULL,
  `cpf` varchar(14) CHARACTER SET latin1 DEFAULT NULL,
  `rg` varchar(15) CHARACTER SET latin1 DEFAULT NULL,
  `razao` varchar(80) CHARACTER SET latin1 DEFAULT NULL,
  `fantasia` varchar(80) CHARACTER SET latin1 DEFAULT NULL,
  `cnpj` varchar(18) CHARACTER SET latin1 DEFAULT NULL,
  `ie` varchar(30) CHARACTER SET latin1 DEFAULT NULL,
  `ativo` tinyint(1) DEFAULT 1,
  `id_categoria` int(11) DEFAULT 0,
  `id_funcionario` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=970 DEFAULT CHARSET=utf8;

INSERT INTO cliente VALUES("1","juridica","INOVA SILK","0000-00-00","","","INOVA SILK SUPRIMENTOS LTDA","INOVA SILK","17220291000126","637.196.145-114","1","2","0");
INSERT INTO cliente VALUES("2","fisica","ANDERSON E CARLOS GARCIA","1978-08-13","00638481988","6909786-3","","","","","1","1","2");
INSERT INTO cliente VALUES("3","juridica","MOLD. CERRO AZUL","0000-00-00","","","COMERCIO MOLDURAS CERRA AZUL LTDA","MOLD. CERRO AZUL","01219394000136","901.04358-27","1","1","2");
INSERT INTO cliente VALUES("4","juridica","FIXALOGO","0000-00-00","","","FIXALOGO COMERCIO CONFECÇÃO E ESTAMPARIA LTDA","FIXALOGO","20354448000110","143.573.494-110","1","2","2");
INSERT INTO cliente VALUES("5","juridica","E.A SERIGRAFIA","0000-00-00","","","PAULO SERGIO DOS REIS EIRELI-ME","E.A SERIGRAFIA","07719033000135","117169723110","1","2","3");
INSERT INTO cliente VALUES("6","juridica","","0000-00-00","","","D.J. TRÊS SILK-SCREEN LTDA ME","D.J TRÊS","65958563000132","113.136.529-114","1","2","0");
INSERT INTO cliente VALUES("7","fisica","MÁRCIO HENRIQUE DE ARAUJO BARBOSA","0000-00-00","04284864955","5.303.128-5","","","","","1","1","0");
INSERT INTO cliente VALUES("8","juridica","MASTER INK","0000-00-00","","","MASTER INK IND. E COMERCIO E SERVIÇOS LTDA","MASTER INK","03406466000180","901.93922-50","1","2","0");
INSERT INTO cliente VALUES("9","juridica","TIGRÃO","0000-00-00","","","TIGRÃO COMERCIO DE TINTAS LTDA","TIGRÃO","12909060000100","906.29913-53","1","2","0");
INSERT INTO cliente VALUES("10","juridica","","0000-00-00","","","CESUMAR CENTRO DE ENSINO SUPERIOR DE MARINGÁ LTDA","CESUMAR","79265617000199","ISENTO","1","1","0");
INSERT INTO cliente VALUES("11","fisica","MICHELE BRANBILA KOZUKI","0000-00-00","73087211915","","","","","","1","0","0");
INSERT INTO cliente VALUES("12","juridica","TELAPRINT","0000-00-00","","","TELAPRINT SERVIÇOS DE SERIGRAFIA LTDA - ME","TELAPRINT","05470907000138","336.704.419-115","1","2","0");
INSERT INTO cliente VALUES("13","fisica","SANDRA CERANTO","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("14","juridica","TELAPRINT","0000-00-00","","","","","05470907000138","336.704.419-115","1","2","0");
INSERT INTO cliente VALUES("15","fisica","RAFAEL HIDEKI","0000-00-00","09606515940","","","","","","1","1","0");
INSERT INTO cliente VALUES("16","juridica","UNNA - SILK& SIGN SUPRIMENTOS","0000-00-00","","","UNNA COMERCIO E SERV. DE COMUNIC. VISUAL E SERIGRAFIA LTDA - ME","UNNA - SILK& SIGN SUPRIMENTOS","24919774000189","27.153.423-0","1","2","0");
INSERT INTO cliente VALUES("17","juridica","TRAR SCREEN - TS FINANCEIRO","0000-00-00","","","TRAR SCREEN FOTOS ESTAMPA LTDA","TRAR SCREEN - TS FINANCEIRO","44896801000152","110.393.432-111","1","1","0");
INSERT INTO cliente VALUES("18","juridica","","0000-00-00","","","TORINO FOTOS ESTAMPARIA LTDA","TORINO FOTOS","71808745000120","113.966.629-117","1","2","0");
INSERT INTO cliente VALUES("19","juridica","PAINEL","0000-00-00","","","PAINEL COMERCIO E SERVIÇOS LTDA ME","PAINEL","54936737000140","112.860.135-114","1","2","0");
INSERT INTO cliente VALUES("20","juridica","ANDRÉ - A ATELIE SILK","0000-00-00","","","ANDRÉ LUIZ NOGUEIRA DE OLIVEIRA","ANDRÉ - ATELIE SILK SCREEN","12390749000171","795.082.229-110","1","2","0");
INSERT INTO cliente VALUES("21","juridica","KALY-TEX","0000-00-00","","","KALY-TEX COM. DE MATERIAIS SERIGR. SERV. LTDA","KALY-TEX","66041203000134","113.213.347-110","1","2","0");
INSERT INTO cliente VALUES("22","juridica","POLY SCREEN","0000-00-00","","","POLY SCREEN SIGNS COM. DE PRODUTOS SERIGRAFICOS LTDA","POLY SCREEN","04379369000108","336.665.361-115","1","2","0");
INSERT INTO cliente VALUES("23","juridica","JOSÉ WILSON","0000-00-00","","","W. COLLOR TINTAS SERIGRAFICAS E MATERIAIS PARA ESTAMPARIA LTDA","W. COLLOR TINTAS - JOSE WILSON","11565430000177","147.020.978-113","1","2","0");
INSERT INTO cliente VALUES("24","juridica","JOSÉ WILSON","0000-00-00","","","ANARIÊ BRASIL LTDA - EPP","ANARIÊ BRASIL","66564980000163","113.207.737-115","1","2","0");
INSERT INTO cliente VALUES("25","juridica","TELASILK - GUARULHOS","0000-00-00","","","TELASILK COMERCIO DE MATERIAIS SERIGR. LTDA","TELASILK - GUARULHOS","05470899000120","336.704.400-118","1","2","0");
INSERT INTO cliente VALUES("26","fisica","RODRIGO PERRELLA","0000-00-00","22009595831","","","","","","1","1","0");
INSERT INTO cliente VALUES("27","fisica","ADRIANO","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("28","juridica","ROSA ATELIER","0000-00-00","","","ROSA ARMARINHOS E ATELIER","ROSA ATELIER","29142852000103","907.67148-83","1","2","0");
INSERT INTO cliente VALUES("29","juridica","PAPELARIA DEPEL","0000-00-00","","","PAPELARIA DEPEL LTDA","PAPELARIA DEPEL","80834328000142","701.03281-06","1","2","0");
INSERT INTO cliente VALUES("30","juridica","LUCIA G. DE SOUZA - INDIE STUDIO","0000-00-00","","","LUCIA G. DE SOUZA TINTAS - ME","LUCIA G. DE SOUZA - INDIE STUDIO","15657751000152","145.344.456-116","1","2","0");
INSERT INTO cliente VALUES("31","juridica","SB SHEMICAL - TINTAS SUL BRASIL","0000-00-00","","","SB SHEMICAL IND. E COM. DE PROD. SEDRIGRAFICOS","SB SHEMICAL - TINTAS SUL BRASIL","21819296000147","907.05779-81","1","3","0");
INSERT INTO cliente VALUES("32","fisica","DIOGO MAZZER DE ROSSI - ESTILOS QUADROS","0000-00-00","05262459994","","","","","","1","2","0");
INSERT INTO cliente VALUES("33","juridica","ROBI SCREEN","0000-00-00","","","ROBI SCREEN COM. DE PROD. E MAT. SERIGR. LTDA","ROBI SCREEN","07871281000105","635.526.342-118","1","2","0");
INSERT INTO cliente VALUES("34","juridica","","0000-00-00","","","AQUARELA SILK E SIGN COMERCIO E IMPORTAÇÃO LTDA","AQUARELA SILK E SIGN","04150050000106","082.069.08-5","1","2","0");
INSERT INTO cliente VALUES("35","fisica","MARILDA TOLEDO - MARIARTE","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("36","juridica","CHARLES DOUGLAS - NEW COLOR","0000-00-00","","","CHARLES DOUGLAS DE SOUZA COM. DE PAPEIS E FACÇÃO - ME","CHARLES DOUGLAS - NEW COLOR","19170445000148","142.963.856-118","1","2","0");
INSERT INTO cliente VALUES("37","juridica","ICON - ANDREIA MATIAS","0000-00-00","","","ANDREIA MATIAS DE SOUZA - ME","ICON - ANDREIA MATIAS","18445027000153","257.0838-12","1","2","0");
INSERT INTO cliente VALUES("38","fisica","DEISE","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("39","juridica","","0000-00-00","","","F.S GUARU INDUSTRIA DE TINTAS SERIGRAFIA LTDA","F.S GUARU","02167712000206","147.354.022-111","1","2","0");
INSERT INTO cliente VALUES("40","fisica","SANDRA REGINA BENICIO","0000-00-00","19050399215","","","","","","1","1","0");
INSERT INTO cliente VALUES("41","juridica","","0000-00-00","","","N.P. DE AMORIM EPP","N.P DE AMORIM - TOK DE ARTE","11781168000106","127.119.493","1","2","0");
INSERT INTO cliente VALUES("42","fisica","RANIERI MAGNUIS DUTRA","0000-00-00","93753179434","","RANIERI MAGNUS","","","","1","1","0");
INSERT INTO cliente VALUES("43","juridica","ROBERTA KELLI PAZ RAMOS - VALDEMIR","0000-00-00","","","ROBERTA KELLI PAZ RAMOS - ME","ROBERTA KELLI PAZ RAMOS - VALDEMIR","13683112000136","906.22612-07","1","2","0");
INSERT INTO cliente VALUES("44","juridica","LN MATRIZES","0000-00-00","","","LN MATRIZES SERIGRAFICAS E FOTOLITOS LTDA - ME","LN MATRIZES","11637289000170","147.045.758-110","1","2","0");
INSERT INTO cliente VALUES("45","juridica","AUGUSTO JOSÉ BELETATTI","0000-00-00","","","MINISCREEN MAT. SERIGRAFICOS LTDA","MINISCREEN","68465038000173","113.588.865-116","1","2","0");
INSERT INTO cliente VALUES("46","juridica","PONTO FINNAL","0000-00-00","","","PONTO FINNAL COM. DE PROD. GRAFICOS E SERIGRAFIA LTDA","PONTO FINNAL","80064421000115","251.5186-63","1","2","0");
INSERT INTO cliente VALUES("47","juridica","AMPLISILK - EDITH","0000-00-00","","","EDITH DOMINGUES DE CARVALHO DE SOUZA ME","AMPLISILK - EDITH","60818119000106","112.322.277-118","1","2","0");
INSERT INTO cliente VALUES("48","fisica","ANTONIO GONZAGA","0000-00-00","08841893842","","","","","","1","0","0");
INSERT INTO cliente VALUES("49","juridica","NOVAPLAST COMERCIAL LTDA","0000-00-00","","","NOVAPLAST COMERCIAL LTDA","NOVAPLAST","22060776000130","518.472.804.00-91","1","2","0");
INSERT INTO cliente VALUES("50","juridica","CARDOSO","0000-00-00","","","TINTAS CHROMA TEX & BUREAU GRAFICO CARDOSO LTDA- ME","CARDOSO","22244435000114","140.274.956-111","1","2","0");
INSERT INTO cliente VALUES("51","juridica","","0000-00-00","","","SOUZA SUPRIMENTOS P/COMUNICAÇÃO VISUAL LTDA","SOUZA SUPRIMENTOS","02718944000124","633.388.866-110","1","2","0");
INSERT INTO cliente VALUES("52","juridica","MATEUSPUMA SIGN COMERCIO ESPUMAS E PLASTICO EIRELI","0000-00-00","","","MATEUSPUMA SIGN COMERCIO ESPUMAS E PLASTICO EIRELI","MATEUSPUMA","05990975000128","776.406-57","1","2","0");
INSERT INTO cliente VALUES("53","juridica","","0000-00-00","","","TORINO FOTOS ESTAMPARIA LTDA","TORINO FOTOS","71808745000120","113.966.629-117","1","2","0");
INSERT INTO cliente VALUES("54","fisica","ODETE","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("55","juridica","","0000-00-00","","","CONFECÇÔES DE ROUPAS ESTILO LTDA","CONFECÇÕES DE ROUPAS ESTILO","05122919000171","116.407.505-117","1","2","0");
INSERT INTO cliente VALUES("56","fisica","LEANDRO MOL","0000-00-00","32297523840","","","","","","1","1","0");
INSERT INTO cliente VALUES("57","juridica","","0000-00-00","","","CASA DO SIGN COMERCIO DE PLÁSTICO E ESPUMAS LTDA-ME","CASA DO SING - MATEUSPUMA","10386086000196","78.614.510","1","2","0");
INSERT INTO cliente VALUES("58","fisica","RONISE MANETTI CEDARO","0000-00-00","62775855172","","","","","","1","1","0");
INSERT INTO cliente VALUES("59","juridica","","0000-00-00","","","DERVANIA ROMANI NASCIMENTO ME","SILK BRASIL - DERVANIA","07874067000102","244.733.487-116","1","2","0");
INSERT INTO cliente VALUES("60","juridica","FERRA - SILKPRESS","0000-00-00","","","FERRA INDUSTRIA E COMERCIO LTDA ME","FERRA - SILKPRESS","39357819000146","081.537.05-0","1","2","0");
INSERT INTO cliente VALUES("61","fisica","JANDER ANTONIO DE SOUZA SANTOS","0000-00-00","39844752841","","","","","","1","1","0");
INSERT INTO cliente VALUES("62","juridica","TINTAS MARECHAL RONDON","0000-00-00","","","TINTAS MARECHAL RONDON LTDA","TINTAS MARECHAL RONDON","82201724000168","41.702.975-34","1","2","0");
INSERT INTO cliente VALUES("63","juridica","","0000-00-00","","","ANTONIO CARLOS PAVANELLO JR. PEDREIRA ME","ANTONIO CARLOS PAVANELLO","04743876000189","519.092.883-111","1","2","0");
INSERT INTO cliente VALUES("64","juridica","C.V DOS REIS PAPELARIA ME","0000-00-00","","","C V DOS REIS PAPELARIA ME","C V DOS REIS - BRISK","05568420000192","116.561.425-114","1","2","0");
INSERT INTO cliente VALUES("65","juridica","","0000-00-00","","","D.STAMP LTDA ME","D.STAMP","15736491000100","558.157.867-116","1","2","0");
INSERT INTO cliente VALUES("66","fisica","RODRIGO PERRELLA","0000-00-00","22009595831","27.885020-0","","","","","1","1","0");
INSERT INTO cliente VALUES("67","juridica","","0000-00-00","","","L.E.F ARAUJO","L.E.F ARAUJO","04509175000180","19.447.904-8","1","2","0");
INSERT INTO cliente VALUES("68","juridica","","0000-00-00","","","TATIANA GOMES DA SILVA SOUZA SERIGRAFIA EPP","TATIANA GOMES - SCREEN COLOR TINTAS","09532357000195","148.113.543-119","1","2","0");
INSERT INTO cliente VALUES("69","juridica","","0000-00-00","","","JR COMERCIO DE TECIDOS E CONFECÇÕES LTDA","JR COMERCIO DE TECIDOS","10735832000100","13.369.322-8","1","2","0");
INSERT INTO cliente VALUES("70","juridica","WIMAQUINAS","0000-00-00","","","WIMAQUINAS INDUSTRIA E COMERCIO LTDA ME","WIMAQUINAS","37513959000130","131.41753-3","1","2","0");
INSERT INTO cliente VALUES("71","juridica","","0000-00-00","","","MONICA SILVEIRA PAIZINHO ME","MONICA SILVEIRA - NEW TEX","40996118000136","20.038.039-7","1","2","0");
INSERT INTO cliente VALUES("72","fisica","RAFAELA ADORNO OLIVEIRA","0000-00-00","04022759932","","","","","","1","1","0");
INSERT INTO cliente VALUES("73","juridica","","0000-00-00","","","CHRISTO COMERCIO E SERVIÇOS LTDA - ME","CHRISTO","27066588000132","080.504.99-0","1","2","0");
INSERT INTO cliente VALUES("74","juridica","SILKSMIG","0000-00-00","","","SILKSMIG INDUSTRIA E COMERCIO LTDA EPP","SILKSMIG","17216409000142","062.002.413.008-6","1","2","0");
INSERT INTO cliente VALUES("75","fisica","MÁRCIO HENRIQUE DE ARAUJO BARBOSA","0000-00-00","04284864955","5.303.128-5","","","","","1","1","0");
INSERT INTO cliente VALUES("76","juridica","LIMBERGER E SCHWEIG LTDA","0000-00-00","","","LIMBERGER E SCHWEIG LTDA","LIMBERGER E SCHWEIG","11265707000146","294.1916-31","1","2","0");
INSERT INTO cliente VALUES("77","fisica","ADRIANO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("78","fisica","BÓ","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("79","fisica","MARCOS ALVES DOS SANTOS","0000-00-00","27890059825","","","","","","1","1","0");
INSERT INTO cliente VALUES("80","juridica","","0000-00-00","","","NEY GALHARDO AMADEU ME","MADEIREIRA NEY","07728113000157","903.57771-10","1","0","0");
INSERT INTO cliente VALUES("81","juridica","ROBERTA KELLI","0000-00-00","","","ROBERTA KELLI PAZ RAMOS - ME","ROBERTA KELLI - VALDEMIR RAMOS","13683112000136","906.226.12-07","1","1","0");
INSERT INTO cliente VALUES("82","fisica","CLEBER","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("83","fisica","SILVANIA CARMEM VENDRAME DA SILVA","0000-00-00","48835960959","","","","","","1","1","0");
INSERT INTO cliente VALUES("84","juridica","TINTASCREEN","0000-00-00","","","TINTASCREEN COMÉRCIO DE PRODUTOS SERIGRÁFICOS LTDA ME","TINTASCREEN","97349443000124","84.896.799","1","2","0");
INSERT INTO cliente VALUES("85","fisica","SANDRA REJANE TURCATO MAFFISSONI","0000-00-00","80894666134","","","","","","1","1","0");
INSERT INTO cliente VALUES("86","juridica","","0000-00-00","","","VERA LUCIA DE OLIVEIRA SANTOS ME","VERA LUCIA","64150196000183","336.291.150-110","1","2","0");
INSERT INTO cliente VALUES("87","juridica","REGGIANI & REGGIANI","0000-00-00","","","REGGIANI & REGGIANI - COMUNICAÇÃO VISUAL LTDA","TEK-SILK SERIGR. - REGGIANI & REGGIANI","18501772000172","906.36221-06","1","2","0");
INSERT INTO cliente VALUES("88","fisica","TANIA REGINA CAVASSANI","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("89","fisica","MARCELA CARO PERRES","0000-00-00","08128754947","30396212","","","","","1","1","0");
INSERT INTO cliente VALUES("90","fisica","NEY - ENANDA UNIFORMES","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("91","fisica","DANILO ESQUIERDO RAMOS - NILO BRINDES","0000-00-00","18554957830","","","","","","1","1","0");
INSERT INTO cliente VALUES("92","juridica","","0000-00-00","","","GLOBAL COMERCIO E IMP. DE PROD. SERIGRAFICOS","GLOBAL COMERCIO","09598065000155","9044205065","1","2","0");
INSERT INTO cliente VALUES("93","fisica","VALDECIR JOSÉ TORRES","0000-00-00","50274503972","","","","","","1","1","0");
INSERT INTO cliente VALUES("94","juridica","ADESIVO E ARTE - KASA DO ARTESANTO","0000-00-00","","","ADESIVO E ARTE DISTR. DE MAT. P/ARTESANATO E PAPELARIA","ADESIVO E ARTE - KASA DO ARTESANTO","11659230000183","905.12981-33","1","2","0");
INSERT INTO cliente VALUES("95","fisica","FAGNER APARECIDO SANTOS OLIVEIRA","0000-00-00","22922420876","","","","","","1","1","0");
INSERT INTO cliente VALUES("96","juridica","CASA E PAREDE","0000-00-00","","","BRANCO VASQUES E CIA LTDA","CASA E PAREDE - BRANCO VASQUES","17555569000116","9062178482","1","2","0");
INSERT INTO cliente VALUES("97","fisica","LESSI KORLING","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("98","fisica","CICERA MARIA MOREIRA","0000-00-00","29915122888","","","","","","1","1","0");
INSERT INTO cliente VALUES("99","fisica","GERSON PEREIRA PINTO","0000-00-00","20632991968","","","","","","1","1","0");
INSERT INTO cliente VALUES("100","fisica","SANDRO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("101","juridica","ABEL FERNANDES DE NOBREGA - ME","0000-00-00","01161786805","9.010.278-2","ABEL FERNANDES DE NOBREGA - ME","SJ SILK & SIGN - ABEL","27272422000172","645.830.425.110","1","2","0");
INSERT INTO cliente VALUES("102","fisica","ROSELI APARECIDA JARDIM","0000-00-00","57187312920","","","","","","1","1","0");
INSERT INTO cliente VALUES("103","juridica","","0000-00-00","","","PAULO HENRIQUE MARIANO LOPES DA SILVA","PAULO - ZANDO CONFECÇÃO","19182594000127","358.094.508-78","1","2","0");
INSERT INTO cliente VALUES("104","fisica","JOSUÉ","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("105","fisica","JOSUÉ","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("106","juridica","RL COMERCIO","0000-00-00","","","RL COMERCIO SERVIÇO SERIGRAFICOS LTDA","RL COMERCIO","03540884000165","522.858-00","1","2","0");
INSERT INTO cliente VALUES("107","fisica","JESSICA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("108","juridica","IDEAL STUDIO","0000-00-00","","","IDEAL STUDIO E SERIGRAFIA LTDA","IDEAL STUDIO","05364884000187","116.499.827-118","1","2","0");
INSERT INTO cliente VALUES("109","juridica","","0000-00-00","","","SILMARA A.S. DA ROCHA REPRESENTAÇÕES LTDA","SILMARA A.S - BEST SIGN","06212165000103","145.836.084-117","1","2","0");
INSERT INTO cliente VALUES("110","fisica","GILMAR","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("111","fisica","ELEN","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("112","fisica","DOROTEIA TURQUINA DONASAN","0000-00-00","71529470900","","","","","","1","1","0");
INSERT INTO cliente VALUES("113","juridica","LESTEPLASTIC","0000-00-00","","","LESTEPLASTIC COM. DE ARTIGOS P/TAPEÇARIA LTDA-ME","LESTEPLASTIC","02326443000100","115.123.275-118","1","2","0");
INSERT INTO cliente VALUES("114","fisica","ELIAS","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("115","juridica","SUELI - YZZA PAPELARIA","0000-00-00","","","SUELI APARECIDA MAYER - ME","SUELI - YZZA PAPELARIA","00734615000141","131.01382-54","1","1","0");
INSERT INTO cliente VALUES("116","fisica","JULIO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("117","fisica","JEANE FERREIRA SANTOS","0000-00-00","32835203800","09859204-16","","","","","1","1","3");
INSERT INTO cliente VALUES("118","juridica","","0000-00-00","","","CARU MATERIAIS SERIGRAFICOS E SINALIZAÇÕES EIRELI","CARU IMPERATRIZ","07077551000100","12.216051-7","1","2","0");
INSERT INTO cliente VALUES("119","fisica","CRISTINA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("120","fisica","NILCEIA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("121","fisica","MARCOS","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("122","fisica","GESSY FAUSTINO BARBOSA","0000-00-00","52516938853","6.191.235","","","","","1","1","0");
INSERT INTO cliente VALUES("123","juridica","","0000-00-00","","","LOUZADA & CARVALHO COM. VAR. DE SUPR. P/COM. VISUAL E TOLDOS LTDA","SUPERFILME - LOUZADA & CARVALHO","13193840000240","688.354.192-119","1","1","0");
INSERT INTO cliente VALUES("124","juridica","","0000-00-00","","","LOUZADA & CARVALHO COM. VAR. DE SUPR. P/COM. VISUAL E TOLDOS LTDA","SUPERFILME - LOUZADA & CARVALHO","13193840000240","688.354.192-119","1","1","0");
INSERT INTO cliente VALUES("125","juridica","","0000-00-00","","","STICK COM. DE PROD. P/COMUNIC. VISUAL LTDA","STICK - HN TINTAS","09156674000154","104.187.085","1","2","0");
INSERT INTO cliente VALUES("126","fisica","EDNA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("127","juridica","","0000-00-00","","","KLEBER INES DA SILVA","KLEBER INES","23926719000153","00268345100-79","1","2","0");
INSERT INTO cliente VALUES("128","fisica","LUCAS GABRIEL FARIA SILVA - LOJAS GOLFINHO","0000-00-00","46171891819","","","","","","1","1","0");
INSERT INTO cliente VALUES("129","juridica","ABELON - FERNANDA DE MOURA","0000-00-00","","","FERNANDA DE MOURA ORLANDO - ARTEFATOS DE LONA E VINIL","ADELON - FERNANDA DE MOURA","10207126000195","904.78953-48","1","2","0");
INSERT INTO cliente VALUES("130","juridica","TRINDADE COM. MAT. SERIGRAFICO LTDA","0000-00-00","","","TRINDADE COM. MAT. SERIGRAFICO LTDA","TRINDADE","86814308000196","10.199797-99","1","2","0");
INSERT INTO cliente VALUES("131","fisica","RODRIGO DA SILVA PEREIRA - STAMP ARTS","0000-00-00","08308604790","","RODRIGO","STAMP ARTS - RODRIGO PEREIRA","","","1","1","0");
INSERT INTO cliente VALUES("132","fisica","SILVANIA GATTI","0000-00-00","44928343972","","","","","","1","1","0");
INSERT INTO cliente VALUES("133","juridica","","0000-00-00","","","HALLEY STAMPARIA LTDA","HALLEY","02648888000107","901.64238-98","1","2","0");
INSERT INTO cliente VALUES("134","fisica","LUZIMAR APARECIDO SONCINI","0000-00-00","02360286854","13026332-1","","","","","1","1","0");
INSERT INTO cliente VALUES("135","fisica","FABIANO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("136","juridica","PUC","0000-00-00","","","ASSOCIAÇÃO PARANAENSE DE CULTURA","PUC","76659820001476","ISENTO","1","1","0");
INSERT INTO cliente VALUES("137","juridica","SG DECORA COMUNICAÇÃO VISUAL","0000-00-00","","","SG DECORA COMUNICAÇÃO VISUAL LTDA - EPP","SG DECORA COMUNICAÇÃO VISUAL","23715231000187","140.272.280-112","1","2","0");
INSERT INTO cliente VALUES("138","juridica","","0000-00-00","","","SILK & PLASTICOS LTDA","SILK & PLASTICO","20627303000146","277.043423.0091","1","2","0");
INSERT INTO cliente VALUES("139","juridica","","0000-00-00","","","COMERCIAL NOVO SILK LTDA","CONE - COMERCIAL NOVO SILK","05404117000154","433.210.152.002-1","1","2","0");
INSERT INTO cliente VALUES("140","juridica","PARANÁ SIGN","0000-00-00","","","PARANÁ SIGN SERIGRAFIA LTDA","PARANÁ SIGN","06300972000188","903.07994-00","1","2","0");
INSERT INTO cliente VALUES("141","juridica","ADESIVAZ - ANDERSON DE SOUZA","0000-00-00","","","A. DE SOUZA VAZ - SERIGRAFIA E SUBLIMAÇÃO - ME","ADESIVAZ - A. DE SOUZA VAZ","17125116000150","907.43427-33","1","2","0");
INSERT INTO cliente VALUES("142","fisica","JULIA RIBEIRO DE CASTRO","0000-00-00","62425609920","","","","","","1","1","0");
INSERT INTO cliente VALUES("143","fisica","ELIZABETH CRISTINA CASTRO COUTO - CASA DA ESTAMPA","0000-00-00","12381487786","","ELIZABETH CRISTINA CASTRO COUTO","CASA DA ESTAMPA - ELIZABETH CRISTINA","","","1","1","0");
INSERT INTO cliente VALUES("144","juridica","STAR SILK IND. COM","0000-00-00","","","STAR SILK IND. COM. DE PROD. SERIGRAFICOS LTDA-ME","ESTUDIO 214 - STAR SILK","10712342000198","78733098","1","2","0");
INSERT INTO cliente VALUES("145","fisica","JANE","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("146","juridica","V","0000-00-00","","","VALTER FATTORI ME","VALTER FATTORI","53784732000186","626.167.097-112","1","2","0");
INSERT INTO cliente VALUES("147","fisica","TARCISIO - MARCENARIA JORGE","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("148","juridica","MARIA LUZIA DECORAÇÕES LTDA","0000-00-00","","","MARIA LUZIA DECORAÇÕES LTDA","MALU - MARIA LUIZA DECORAÇÕES","80312200000119","414.00367-28","1","2","0");
INSERT INTO cliente VALUES("149","juridica","PAVANELLO & ALBIERI","0000-00-00","","","PAVANELLO & ALBIERI TECIDOS LTDA ME","PAVANELLO & ALBIERI","22793951000106","168.073.928.119","1","2","0");
INSERT INTO cliente VALUES("150","fisica","DIRCE","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("151","fisica","PASTOR EDSON","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("152","juridica","GERSO - IND. COM CINTOS JC","0000-00-00","","","GERSON MOREIRA PINTO FILHO - ME","GERSO - IND. COM CINTOS JC","64206386000175","277.677.578-0038","1","2","0");
INSERT INTO cliente VALUES("153","juridica","BARREIRÃO COUROS LTDA","0000-00-00","","","BARREIRÃO COUROS LTDA","BARREIRÃO COUROS","41826132000154","062.794.750-0052","1","2","0");
INSERT INTO cliente VALUES("154","juridica","F.K SILK","0000-00-00","","","F.K COMERCIO DE MAT. SERIGRAFICOS ME","F.K SILK","02686992000188","902.50402-84","1","1","0");
INSERT INTO cliente VALUES("155","juridica","ASSOCIAÇÃO EDUCACIONAL IMUB DE MARINGÁ","0000-00-00","","","ASSOCIAÇÃO EDUCACIONAL IMUB DE MARINGÁ","ASSOC. EDUC. IMUB","12837053000140","ISENTO","1","1","0");
INSERT INTO cliente VALUES("156","juridica","COPY SCREEN","0000-00-00","","","COPY SCREEN MATERIAIS SERIGRÁFICOS LTDA","COPY SCREEN","01482690000125","114.796.569-114","1","2","0");
INSERT INTO cliente VALUES("157","juridica","PRO SILK","0000-00-00","","","PRO SILKSCREEN COMERCIO LTDA","PRO SILK","12558213000112","795.091.584-116","1","2","0");
INSERT INTO cliente VALUES("158","fisica","ROSANA B. GONÇALVES","0000-00-00","03772355986","","","","","","1","1","0");
INSERT INTO cliente VALUES("159","fisica","ROBERTA PANARO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("160","fisica","MARIA ROSA FRANCO CORREA","0000-00-00","43381073915","","","","","","1","1","0");
INSERT INTO cliente VALUES("161","juridica","PS DIGITAL COMERCIO LTDA - EPP","0000-00-00","","","PS DIGITAL COMERCIO LTDA - EPP","PRO SILK - PS DIGITAL","05726972000181","244.940.162-117","1","2","0");
INSERT INTO cliente VALUES("162","juridica","TRÃNGULO","0000-00-00","","","TRIANGULO SCREEN LTADA","TRIANGULO","59699827000188","112157657118","1","1","3");
INSERT INTO cliente VALUES("163","fisica","SOLANGE","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("164","fisica","LUZIANA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("165","fisica","TAISA RUIZ PALOMA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("166","fisica","RODRIGO DA SILVA PEREIRA","0000-00-00","08308604790","","","","","","1","1","0");
INSERT INTO cliente VALUES("167","juridica","MARCOS AURELIO DE SOUZA SUPRIMENTOS","0000-00-00","","","MARCOS AURELIO DE SOUZA SUPRIMENTOS","VINIL COMPANY - MARCOS AURELIO","07425949000182","903.47140-93","1","2","0");
INSERT INTO cliente VALUES("168","juridica","","0000-00-00","","","RECCO RECCO & CIA LTDA","RECCO","76795418000102","70.112.672-67","1","2","0");
INSERT INTO cliente VALUES("169","juridica","ERICA RIBAS - PERFECT PRINT","0000-00-00","","","ERICA RIBAS DA COSTA","ERICA RIBAS - PERFECT PRINT","34911647000197","ISENTO","1","2","0");
INSERT INTO cliente VALUES("170","fisica","ILDA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("171","fisica","VILMA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("172","fisica","ROSELI GARCIA DA SILVA","0000-00-00","03213713996","","","","","","1","1","0");
INSERT INTO cliente VALUES("173","fisica","ADRIANA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("174","fisica","VALDEMAR DE OLIVEIRA GODOI","0000-00-00","56018959887","","","","","","1","2","0");
INSERT INTO cliente VALUES("175","fisica","IRAIDE","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("176","fisica","ANDRE LUIZ MARTINS","0000-00-00","11896777848","19799608","","","","","1","1","0");
INSERT INTO cliente VALUES("177","fisica","KIMURA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("178","fisica","GABRIEL FIORE","0000-00-00","08498686962","","","","","","1","1","0");
INSERT INTO cliente VALUES("179","fisica","JULIO CEZAR FEIJO GUINTEIRO","0000-00-00","28612574072","61.030.48-37","","","","","1","1","0");
INSERT INTO cliente VALUES("180","juridica","","0000-00-00","","","SILKS COR COMERCIO DE TINTAS LTDA ME","SILKS COR","00766391000150","401.074.794-115","1","2","0");
INSERT INTO cliente VALUES("181","fisica","GRAZIELA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("182","fisica","KALISSA DOS SANTOS","0000-00-00","31136475842","","","","","","1","1","0");
INSERT INTO cliente VALUES("183","fisica","JOÃO LUIS ANTONELLI RIBEIRO","0000-00-00","05779078912","","","","","","1","0","0");
INSERT INTO cliente VALUES("184","fisica","RONIS FURQUIM","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("185","fisica","ANGELA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("186","juridica","","0000-00-00","","","THIAGO RODRIGUES ANDRADE - EPP","THIAGO RODRIGUES - CASAS GLOBO","06083660000160","313.272.397.003-5","1","2","0");
INSERT INTO cliente VALUES("187","juridica","DECOR - L.R DA SILVA","0000-00-00","","","DECOR GRAFICA COMUNICAÇÃO VISUAL E PROPAGANDA EIRELI ME","DECOR","12680105000118","11010148","1","2","0");
INSERT INTO cliente VALUES("188","fisica","PADRE RODRIGO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("189","fisica","ATAIDES KIST","0000-00-00","51618974904","","","","","","1","1","0");
INSERT INTO cliente VALUES("190","fisica","KIMI","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("191","juridica","","0000-00-00","","","VIA SUL SUPRIMENTOS LTDA","VIA SUL","10169314000176","109.03341-73","1","2","0");
INSERT INTO cliente VALUES("192","juridica","SILK GERAL","0000-00-00","","","SILK GERAL COMERCIO DE PRODUTOS SERIGRAFICOS EIRELI ME","SILK GERAL","13951674000113","582.559.730-118","1","1","0");
INSERT INTO cliente VALUES("193","fisica","ANGELA - MANDAGUAÇU","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("194","juridica","ESTILLUS SERIGRAFIA","0000-00-00","","","CLAUDEMAR GONÇALVES","ESTILLUS SERIGRAFIA","19543431000122","ISENTO","1","2","0");
INSERT INTO cliente VALUES("195","juridica","KADU - CARLOS EDUARDO","0000-00-00","","","CARLOS EDUARDO SINIGALLI FERRAZ","KADU - CARLOS EDUARDO","17413552000124","142.023.427-113","1","1","0");
INSERT INTO cliente VALUES("196","fisica","WENDEL DE SOUZA","0000-00-00","03571852931","","","","","","1","1","0");
INSERT INTO cliente VALUES("197","juridica","","0000-00-00","","","FINE PRESS SERVIÇOS GRAFICOS E SERIGRAFICOS LTDA - ME","FINE PRESS","23143579000147","442.307.214-110","1","2","0");
INSERT INTO cliente VALUES("198","fisica","ANDERSON CARVALHO RODRIGUES - GALERATIVA","0000-00-00","03692062907","","","","","","1","1","0");
INSERT INTO cliente VALUES("199","fisica","SUSI MEIRE FRABI REBERTI","0000-00-00","00482616962","","","","","","1","1","0");
INSERT INTO cliente VALUES("200","juridica","","0000-00-00","","","M.A CALIZOTTI & CIA LTDA","M.A CALIZOTTI - NEIDE CALIZOTTI","07544597000184","903.47978-78","1","2","0");
INSERT INTO cliente VALUES("201","juridica","RUNAS DESIGNER","0000-00-00","","","RUNAS DESIGNER","RUNAS DESIGNER","06261124000107","903.318262-81","1","2","0");
INSERT INTO cliente VALUES("202","fisica","NAILON CEM COMERCIO SERIGRAFICO LTDA - EPP","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("203","juridica","","0000-00-00","","","NAILON CEM COMERCIO SERIGRAFICO LTDA - EPP","NYLON 100 - NAILON CEM","58517905000113","626.145.846-112","1","1","0");
INSERT INTO cliente VALUES("204","fisica","ANDREIA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("205","juridica","ELIANE REGINA SOARES","0000-00-00","","","ELIANE REGINA SOARES ME","ELIANE REGINA - MOGI VISUAL","08849092000190","454.325.899-110","1","2","0");
INSERT INTO cliente VALUES("206","fisica","LUIZ CARLOS LOPES DE MORAIS - PROF.","0000-00-00","04097723995","","","","","","1","1","0");
INSERT INTO cliente VALUES("207","fisica","FATIMA ZANOTIM - ESCOLA ESPANÇÃO","0000-00-00","52950093949","","","","","","1","1","0");
INSERT INTO cliente VALUES("208","fisica","VITOR FERNANDES MARTINS","0000-00-00","49073937841","53.321.943-7","","","","","1","2","0");
INSERT INTO cliente VALUES("209","fisica","EDSON ROBERTO BARBAM","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("210","juridica","V.F.G - G2 SERIGRAFIA","0000-00-00","","","V.J.G DE OLIVEIRA E CIA LTDA","V.F.G - G2 SERIGRAFIA","09546423000186","ISENTO","1","1","0");
INSERT INTO cliente VALUES("211","juridica","","0000-00-00","","","MD SILK DIGITAL E SIGN EIRELI - ME","MD SILK","14818515000108","083.110.038","1","2","0");
INSERT INTO cliente VALUES("212","juridica","DISK SILK","0000-00-00","","","DISK SILK SERIGRAFIA RIO PRETO LTDA - EPP","DISK SILK","05506376000196","647.421.596-116","1","2","0");
INSERT INTO cliente VALUES("213","fisica","ESTER BORGES","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("214","fisica","VALDIR FERNANDO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("215","juridica","TFC CONFECÇÕES - VITOR FERNANDO","0000-00-00","","","TFC CONFECÇÕES EIRELI - ME","TFC CONFECÇÕES - VALDIR FERNANDO","18553622000102","142.621.500-110","1","2","0");
INSERT INTO cliente VALUES("216","fisica","ISABELA AGULHON VENTURA","0000-00-00","05195917981","","","","","","1","1","0");
INSERT INTO cliente VALUES("217","juridica","SILK MIX DESIGN","0000-00-00","","","A. AGUIA CRIAÇÕES E EVENTOS LTDA-ME","SILK MIX DESIGN - A. AGUIA","10965295000194","148.678.141-116","1","2","0");
INSERT INTO cliente VALUES("218","juridica","","0000-00-00","","","CRIATIVA COMERCIO DE BRINDES LTDA","CRIATIVA BRINDES","13289112000156","13.415.562-9","1","2","0");
INSERT INTO cliente VALUES("219","juridica","","0000-00-00","","","C.V DOS REIS PAPELARIA ME","C.V DOS REIS - BRISK","05568420000192","116.561.425-114","1","2","0");
INSERT INTO cliente VALUES("220","juridica","","0000-00-00","","","DECOLORES PRODUTOS SERIGRAFICOS LTDA EPP","SERITELAS - DECOLORES","08057155000176","903.74788-97","1","2","0");
INSERT INTO cliente VALUES("221","juridica","SERRA SILK","0000-00-00","","","SERRA SILK CONFECÇÕES E COMÉRCIO DE ROUPAS E SERV. SERIGRÁFICOS LTDA","SERRA SILK","11917829000170","79.046.175","1","2","0");
INSERT INTO cliente VALUES("222","juridica","TINTAS UNIÃO","0000-00-00","","","TINTAS E ADESIVOS UNIÃO UBERLÂNDIA LTDA","TINTAS UNIÃO","05301082000128","702.200.630.0033","1","2","0");
INSERT INTO cliente VALUES("223","juridica","","0000-00-00","","","F.N. DA SILVA CONFECÇÕES - ME","NITRO FIT VEST - F.N. DA SILVA","23856157000119","796.411.918-114","1","2","0");
INSERT INTO cliente VALUES("224","juridica","","0000-00-00","","","RODRIGO RIBEIRO CONFECÇÕES - ME","RODRIGO RIBEIRO","17800296000128","906.88872-64","1","2","0");
INSERT INTO cliente VALUES("225","fisica","DOUGLAS RUJANSKI","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("226","fisica","OLIVER","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("227","juridica","","0000-00-00","","","RODRIGO RIBEIRO CONFECÇÕES- ME","RODRIGO RIBEIRO","17800296000128","906.88872-64","1","2","0");
INSERT INTO cliente VALUES("228","fisica","THIAGO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("229","juridica","COOPER SCREEN - MOV CRIAÇÕES","0000-00-00","","","MOV CRIAÇÕES INTELIGENTES ART. METAIS E MADEIRAS","COOPER SCREEN - MOV CRIAÇÕES","08437514000200","626.756.599-112","1","2","0");
INSERT INTO cliente VALUES("230","juridica","BEL ESTAMPARIA","0000-00-00","","","BEL ESTAMPARIA E CONFECÇÕES LTDA - ME","BEL ESTAMPARIA","03389633000121","115.472.571-114","1","2","0");
INSERT INTO cliente VALUES("231","juridica","TELASILK RIO PRETO","0000-00-00","","","","","","","1","2","0");
INSERT INTO cliente VALUES("232","juridica","MATRIX - AUTRIX","0000-00-00","","","AUTRIX PRODUTOS SERIGRAFICOS LTDA","MATRIX - AUTRIX","","","1","2","0");
INSERT INTO cliente VALUES("233","fisica","DAMIÃO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("234","fisica","VALDEMAR OLIVEIRA GODOY","0000-00-00","56018959887","95836234","","","","","1","1","0");
INSERT INTO cliente VALUES("235","juridica","","0000-00-00","","","RENATO EISEMBERG ME","RENATO EISEMBERG","16539606000130","581.065.005-116","1","2","0");
INSERT INTO cliente VALUES("236","fisica","GABRIELA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("237","fisica","RICARDO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("238","fisica","RITA DA CINSA VIEIRA BERTAGGIA","0000-00-00","03557241971","","RITA DA CINSA VIEIRA BERTAGGIA","","","","1","1","0");
INSERT INTO cliente VALUES("239","juridica","PERFIL","0000-00-00","","","PERFIL COMERCIO DE PRODUTOS SERIGRAFICOS EIRELI - ME","PERFIL","26117665000173","796.500.780-110","1","2","0");
INSERT INTO cliente VALUES("240","juridica","","0000-00-00","","","IZAEL LOPES DE OLIVEIRA ME","MALHARIA CAMPO VERDE - IZAEL","01680124000128","131731920","1","2","0");
INSERT INTO cliente VALUES("241","juridica","MULTICOLOR SILK & SIGN","0000-00-00","","","MULTICOLO EIRELLI","MULTICOLOR","04012578000119","116.013.180-112","1","2","0");
INSERT INTO cliente VALUES("242","juridica","CJ","0000-00-00","","","CJ REPRESENTAÇÕES LTDA","CJ","","","1","2","0");
INSERT INTO cliente VALUES("243","juridica","DONY - DONIZETI","0000-00-00","","","DONIZETI CAMPREGHER - ME","DONY - DONIZETI","13623022000150","265.023.920-119","1","2","0");
INSERT INTO cliente VALUES("244","juridica","DEGRADE ESTAMPARIA TEXTIL LTDA","0000-00-00","","","DEGRADE ESTAMPARIA TEXTIL LTDA","DEGRADE ESTAMPARIA","84948447000187","701.18001-19","1","1","0");
INSERT INTO cliente VALUES("245","fisica","DEUZANGELA URUZUELI","0000-00-00","78077974104","","","","","","1","1","0");
INSERT INTO cliente VALUES("246","juridica","MORENA ROSA INDUSTRIA E COMERCIO DE CONFECÇÕES S/A","0000-00-00","","","MORENA ROSA INDUSTRIA E COMÉRCIO DE CONFECÇÕES S/A","MORENA ROSA","15095271000579","905.88278-32","1","1","0");
INSERT INTO cliente VALUES("247","juridica","CHRISTO - SILKRIS SILK & SIGN","0000-00-00","","","CHRISTO COMERCIO E SERVIÇOS LTDA - ME","CHRISTO - SILKRIS SILK & SIGN","27066588000132","080.504.99-0","1","2","0");
INSERT INTO cliente VALUES("248","juridica","GALERIA DOS ESPORTES","0000-00-00","","","GALERIA DOS ESPORTES - EIRELI EPP","GALERIA DOS ESPORTES","03159962000186","901.85933-75","1","2","0");
INSERT INTO cliente VALUES("249","juridica","SILVA INDUSTRIA - GENIUS UNIFORMES","0000-00-00","","","SILVA INDUSTRIA E COMERCIO DO VESTUARIO LTDA","SILVA INDUSTRIA - GENIUS UNIFORMES","05378149000122","433.210.399.0092","1","1","0");
INSERT INTO cliente VALUES("250","juridica","","0000-00-00","","","LIMA E LOPES","LIMA E LOPES","28090274000138","ISENTO","1","1","0");
INSERT INTO cliente VALUES("251","juridica","VES","0000-00-00","","","VESTEER - CLAUDIO DA SILVA","VESTEER","","","1","1","0");
INSERT INTO cliente VALUES("252","juridica","FEIRA SILK","0000-00-00","","","FEIRA SILK PRODUTOS SERIGRÁFICOS LTDA","FEIRA SILK","01881405000149","46.486.066","1","2","0");
INSERT INTO cliente VALUES("253","juridica","CAMILA PAPELARIA","0000-00-00","","","CHAMPONALLI LIVRARIA E PAPELARIA LTDA","CHAMPONALLI LIVRARIA - CAMILA","26559880000124","13.121.474-8","1","2","0");
INSERT INTO cliente VALUES("254","fisica","JOAQUIM ANDRIAN","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("255","juridica","TECNOMOLD","0000-00-00","","","TECNOMOLD ART. PARA LETRISTAS E SERIGRAFIA LTDA","TECNOMOLD","00247408000162","100.01977-90","1","2","0");
INSERT INTO cliente VALUES("256","juridica","","0000-00-00","","","UPC COMUNICAÇÃO E IMAGENS EIRELI ME","UPC COMUNICAÇÃO E IMAGEM","23201806000143","086/0512002","1","2","0");
INSERT INTO cliente VALUES("257","fisica","CLEUZA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("258","fisica","ADIRSON","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("259","fisica","EVA CELESTINO TAMAGIO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("260","fisica","OSMAR FERNANDO MEDEIROS","0000-00-00","62480286991","","","","","","1","1","0");
INSERT INTO cliente VALUES("261","juridica","","0000-00-00","","","MS COMERCIO E SERVIÇOS SERIGRAFICOS LTDA ME","MS - COMERCIAL MIX SILK E SING","18509491000166","105724750","1","2","0");
INSERT INTO cliente VALUES("262","fisica","PATRICIA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("263","juridica","MAITE - M.QUATRO (M4)","0000-00-00","","","M J LARA SERIGRAFIA COMPANY LTDA","M.QUADRO - TURCÃO","06217641000189","669523903119","1","2","0");
INSERT INTO cliente VALUES("264","fisica","PAULO MORICONE TRINDADE","0000-00-00","09074937187","","","","","","1","1","0");
INSERT INTO cliente VALUES("265","juridica","","0000-00-00","","","UNIÃO SUL BRASILEIRA DA IASD","UNIÃO SUL BRASILEIRA","79080602001632","701.18161-12","1","2","0");
INSERT INTO cliente VALUES("266","juridica","ALESSANDRA RAFAEL","0000-00-00","","","ALESSANDRA RAFAEL LOURENÇO - IND. E COM. DO VESTUÁRIO INFANTIL","ALESSANDRA RAFAEL","28754247000112","907.62167-78","1","1","0");
INSERT INTO cliente VALUES("267","fisica","PAROQUIA SANTA ROSA DE LIMA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("268","fisica","CARLOS","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("269","fisica","ANDRESSA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("270","fisica","FABIO FERNANDES DA SILVA","0000-00-00","18308361889","","","","","","1","1","0");
INSERT INTO cliente VALUES("271","fisica","ELTON SILVA","0000-00-00","01867542994","","","","","","1","1","0");
INSERT INTO cliente VALUES("272","juridica","","0000-00-00","","","N.F.B IND. COM. E SERVIÇOS DE SERIGRAFIA LTDA","N.F.B IND. - ESTAÇÃO 792","08238867000191","20.036.307-7.","1","2","0");
INSERT INTO cliente VALUES("273","fisica","RICARDO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("274","fisica","ELZA MARIA FORMIGARI","0000-00-00","32502826934","11649602","","","","","1","1","0");
INSERT INTO cliente VALUES("275","juridica","CARTOGRAFT","0000-00-00","","","CARTOKRAFT EMBALAGENS LTDA ME","CARTOGRAFT","28196073000110","9075545468","1","1","0");
INSERT INTO cliente VALUES("276","fisica","DÉBORA THAIS GLOOR","0000-00-00","06711694910","","","","","","1","1","0");
INSERT INTO cliente VALUES("277","juridica","","0000-00-00","","","INSTITUTO TEENSTREETBRASIL DE APOIO E DESENVOLVIMENTO DO JOVEM E DO ADOLESCENTE","INSTITUTO TEENSTREETBRASIL","09304134000170","ISENTO","1","1","0");
INSERT INTO cliente VALUES("278","juridica","M S MATOS - EPP","0000-00-00","","","M S MATOS - EPP","M S MATOS","11071103000169","20.222.532-1","1","2","0");
INSERT INTO cliente VALUES("279","fisica","CARLOS EDUARDO R. DE BARROS","0000-00-00","05474894805","","","","","","1","1","0");
INSERT INTO cliente VALUES("280","fisica","ANA MARIA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("281","fisica","DEBORA PERIN","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("282","juridica","","0000-00-00","","","GILBERTO CAMPOS DA SILVA JUNIOR - ME","GILBERTO - COMGIL","09609972000152","639.258.635-117","1","2","0");
INSERT INTO cliente VALUES("283","juridica","","0000-00-00","","","COMPACTA ESTAMPARIA SILK & SCREEN","COMPACTA","","","1","2","0");
INSERT INTO cliente VALUES("284","juridica","QUADRO PLUS","0000-00-00","","","QUADRO PLUS LTDA - ME","QUADRO PLUS","09231578000123","255517483","1","2","0");
INSERT INTO cliente VALUES("285","fisica","RAVENA GALVÃO DE ALMEIDA","0000-00-00","03249642347","","","","","","1","1","0");
INSERT INTO cliente VALUES("286","juridica","SILK SIGN","0000-00-00","","","SILK SIGN","SILK SIGN","","","1","0","0");
INSERT INTO cliente VALUES("287","juridica","SILK SIGN","0000-00-00","","","SILK SIGN","SILK SIGN","","","1","0","0");
INSERT INTO cliente VALUES("288","juridica","SILK SIGN","0000-00-00","","","SILK SIGN","SILK SIGN","","","1","0","0");
INSERT INTO cliente VALUES("289","juridica","SILK","0000-00-00","","","SILK SIGN","SILK SIGN","","","1","0","0");
INSERT INTO cliente VALUES("290","juridica","SILK","0000-00-00","","","SILK SIGN","SILK SIGN","","","1","0","0");
INSERT INTO cliente VALUES("291","juridica","SILK SIGN","0000-00-00","","","SERGIO PAULILLO JR. ME","SILK SIGN - SERGIO","04600575000104","535.337.121-119","1","2","0");
INSERT INTO cliente VALUES("292","juridica","GRAFI QUADROS","0000-00-00","","","GRAFI QUADROS - FABRICAÇÃO E GRAVAÇÃO DE QUADROS LTDA - ME","GRAFI QUADROS","06369247000166","254801129","1","2","0");
INSERT INTO cliente VALUES("293","fisica","LILIAN BULA GARCIA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("294","fisica","VANISE FATIMA GARLET BARBIERI","0000-00-00","56158734004","","","","","","1","1","0");
INSERT INTO cliente VALUES("295","juridica","","0000-00-00","","","DUDAS SILK COMERCIO DE MAT. SERIGRAFICOS LTDA","DUDAS SILK","07709774000135","117.194.392.117","1","2","0");
INSERT INTO cliente VALUES("296","juridica","","0000-00-00","05272517000","","ESALTINA ROMÃO","ESALTINA - ARTESILK","05272517000153","905.35327-61","1","2","0");
INSERT INTO cliente VALUES("297","juridica","SIKL E SIGN SHEKINAH","0000-00-00","","","SILK E SIGN COM. DE TINTAS LTDA - ME","SIKL E SIGN SHEKINAH","07017771000130","65.259.368","1","2","0");
INSERT INTO cliente VALUES("298","fisica","ALISSON","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("299","juridica","","0000-00-00","","","LUIS ANTONIO MULTINI BELCHIOR","MARIA BONITA LAMPIÃO - LUIS ANTONIO","04739724000102","587.255.214-111","1","2","0");
INSERT INTO cliente VALUES("300","fisica","CRISTIANO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("301","fisica","FATIMA CRISTINA LUCAS","0000-00-00","04011298964","","","","","","1","1","0");
INSERT INTO cliente VALUES("302","fisica","JOSÉ ALBERTO VIEITAS PRATIS","0000-00-00","69860300887","4262991","","","","","1","1","0");
INSERT INTO cliente VALUES("303","fisica","ALYNE CRISTINA DE ALMEIDA","0000-00-00","06754843918","100069245","","","","","1","2","0");
INSERT INTO cliente VALUES("304","fisica","CRISTIANO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("305","fisica","ANDRESSA CASTRO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("306","fisica","LUIS PLACIO DE ANDRADE","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("307","juridica","","0000-00-00","","","EMPORIUM MARQUES MOVEIS E DECORAÇÕES LTDA","EMPORIUM MARQUES","80569627000105","903710872-91","1","1","0");
INSERT INTO cliente VALUES("308","juridica","VINIL - SILVA E FREIRE","0000-00-00","","","SILVA E FREIRE PAPELARIA LTDA","LOJA DO VINIL - SILVA E FREIRE","08197262000108","0747785001-78","1","2","0");
INSERT INTO cliente VALUES("309","fisica","VALDEMIR RAMOS","0000-00-00","95781374949","6204846-8","","","","","1","1","0");
INSERT INTO cliente VALUES("310","juridica","","0000-00-00","","","K e F MALHAS TECIDOS E ARMARINHOS LTDA","K e F MALHAS - LIMA TEXTIL","05927886000137","12.211.556-2","1","1","0");
INSERT INTO cliente VALUES("311","juridica","FABIO HENRIQUE - MULTICOR","0000-00-00","","","FABIO HENRIQUE FRACO DE GODOI ME","FABIO HENRIQUE - MULTICOR","01805884000114","441037000-119","1","2","0");
INSERT INTO cliente VALUES("312","juridica","","0000-00-00","","","MARY DESIGN, FACÇÃO E CONFECÇÕES LTDA","PONTO DO UNIFORME E CAMISETAS - MARY DESIGN","07701856000133","903.56737-65","1","2","0");
INSERT INTO cliente VALUES("313","juridica","STAR SCREEN","0000-00-00","","","STAR SCREEN SUPRIMENTOS LTDA","STAR SCREEN","03398899000130","062.046.191.00.89","1","2","0");
INSERT INTO cliente VALUES("314","fisica","ANA PAULA DE FREITAS","0000-00-00","03778700995","","","","","","1","1","0");
INSERT INTO cliente VALUES("315","juridica","","0000-00-00","","","FABIANA APARECIDA RODRIGUES SCHIMIDT EIRELI-ME","FABIANA - SILK CETER DIGITAL","20728286000133","637.238.335-118","1","2","0");
INSERT INTO cliente VALUES("316","juridica","TELASILK PRUDENTE","0000-00-00","","","TELASILK PRUDENTE LTDA - ME","TELASILK PRUDENTE","12791862000169","562.009.283-113","1","2","0");
INSERT INTO cliente VALUES("317","juridica","COLEGIO MATER DEI","0000-00-00","","","CENTRO EDUCACIONAL E CULTURAL MARINGAENSE LTDA - ME","COLEGIO MATER DEI","77935724000232","ISENTO","1","1","0");
INSERT INTO cliente VALUES("318","juridica","","0000-00-00","","","A.M DOS SANTOS RIO CLARO ME","A.M DOS SANTOS - CAMISETAS SO MALHAS","04494675000195","587.255.687-116","1","2","0");
INSERT INTO cliente VALUES("319","juridica","","0000-00-00","","","GRUPO ESPÍRITA  ALLAN KARDEC","ALLAN KARDEC","78197795000167","ISENTO","1","1","0");
INSERT INTO cliente VALUES("320","fisica","JOSE RIBEIRO RODRIGUES JUNIOR","0000-00-00","52747255620","","JOSE RIBEIRO RODRIGUES","JOSE RIBEIRO","","","1","1","0");
INSERT INTO cliente VALUES("321","juridica","TELASILK FRANCA - E. A. FAUSTINO","0000-00-00","","","","","","","1","2","0");
INSERT INTO cliente VALUES("322","juridica","TELASILK FRANCA - E. A. FAUSTINO","0000-00-00","","","E. A. FAUSTINO - ME","E. A FAUSTINO - TELASILK FRANCA","23013509000174","310.586.924-115","1","1","0");
INSERT INTO cliente VALUES("323","juridica","","0000-00-00","","","TELASILK - RIO PRETO LTDA - ME","TELASILK - RIO PRETO","07750447000127","647.470.081-116","1","2","0");
INSERT INTO cliente VALUES("324","juridica","","0000-00-00","","","SC QUADROS LTDA - ME","SC QUADROS","13360155000180","256.352.062","1","2","0");
INSERT INTO cliente VALUES("325","fisica","LEANDRO CALIXTO","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("326","juridica","OVERDRIVE A GRAFICA","0000-00-00","","","OVERDRIVE A GRAFICA EIRELI","OVERDRIVE A GRAFICA","02480361000299","86.584.271","1","1","0");
INSERT INTO cliente VALUES("327","fisica","ADRIANA TRAMONTE ARANTES CORREIA","0000-00-00","02355089930","","","","","","1","1","0");
INSERT INTO cliente VALUES("328","fisica","JOÃO FERNANDO MACIEL","0000-00-00","28028074987","","","","","","1","1","0");
INSERT INTO cliente VALUES("329","juridica","VALDEMIR RAMOS - NB SILK - SIGNS","0000-00-00","","","VALDEMIR RAMOS - CONFECÇÕES","VALDEMIR RAMOS - NB SILK - SIGNS","30068764000180","907.82627-93","1","2","0");
INSERT INTO cliente VALUES("330","juridica","","0000-00-00","","","LUCANEL COM. E REPRESENTÇÕES DE BRINDES E FOLHINHAS LTDA - ME","LUCANEL","00556404000166","41.729.674","1","2","0");
INSERT INTO cliente VALUES("331","juridica","CAROL DISTRIBUIDORA","0000-00-00","","","CAROL DISTRIBUIDORA EIRELLI ME","CAROL DISTRIBUIDORA","07654231000168","906.92128-64","1","2","0");
INSERT INTO cliente VALUES("332","juridica","FRISILK","0000-00-00","","","FRISILK COMERCIO E SERIGRAFIA LTDA","FRISILK","06345885000147","77.763.724","1","2","0");
INSERT INTO cliente VALUES("333","juridica","","0000-00-00","","","NOVA UNIDA COMERCIO DE TINTAS EIRELLI - ME","NOVA UNIDA","11638818000150","42278236","1","2","0");
INSERT INTO cliente VALUES("334","fisica","ISMAEL","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("335","juridica","","0000-00-00","","","FINKLER & LOPES LTDA - ME","FINKLER & LOPES","04002799000106","9078012410","1","2","0");
INSERT INTO cliente VALUES("336","juridica","ARTE CORES DISTRIBUIÇÃO LTDA","0000-00-00","","","ARTE CORES DISTRIBUIÇÃO LTDA","ARTE CORES","13569870000128","001.765.666.00-20","1","2","0");
INSERT INTO cliente VALUES("337","juridica","","0000-00-00","","","TRINDADE SCREEN IND. COM. IMP. E EXP. LTDA - ME","TRINDADE - VALINHOS","28867727000190","708.140.953-117","1","2","0");
INSERT INTO cliente VALUES("338","juridica","","0000-00-00","","","BETOS BOLÃO","BETOS BOLÃO","","","1","2","0");
INSERT INTO cliente VALUES("339","juridica","","0000-00-00","","","CLARA INES SOARES DE AVILA ME","CLARA INES - FATTO CONFECÇÕES","95269114000148","109.01905-03","1","2","0");
INSERT INTO cliente VALUES("340","fisica","ANDRESSA ANTONELLI","0000-00-00","03304101993","","","","","","1","1","0");
INSERT INTO cliente VALUES("341","fisica","JOÃO VIANA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("342","fisica","JONNATHAS R. M. TOFANETO","0000-00-00","04003452933","","","","","","1","1","0");
INSERT INTO cliente VALUES("343","fisica","ANGELA MARIA GALBERO COSTA - PAPELARIA GLOBO","0000-00-00","57757968968","","","","","","1","1","0");
INSERT INTO cliente VALUES("344","fisica","GETULIO CICERO MAGALHÃES DE SANTANA","0000-00-00","99487039520","","","","","","1","1","0");
INSERT INTO cliente VALUES("345","juridica","","0000-00-00","","","MOREIRA COMERCIO VAREJ. DE PLASTICO E REPRES. LTDA - ME","MOREIRA COM. - POTISIGNS","18947995000168","16.220.958-5","1","2","0");
INSERT INTO cliente VALUES("346","juridica","RV CAMISETAS ESPORTIVAS E UNIFORMES - LTDA","0000-00-00","","","RV CAMISETAS ESPORTIVAS E UNIFORMES - LTDA","RV CAMISETAS","26674338000112","795.785.726-112","1","2","0");
INSERT INTO cliente VALUES("347","juridica","WELLINGTON RABELO","0000-00-00","12280721000","","WRI COMERCIO E CONFECÇÃO TEXTIL EIRELI","WRI - WELLINGTON RABELO","12280721000181","105.370.427-50","1","2","0");
INSERT INTO cliente VALUES("348","juridica","WELLINGTON RABELO","0000-00-00","","","","","","","1","2","0");
INSERT INTO cliente VALUES("349","juridica","LUCIA YOKO","0000-00-00","","","LUCIA YOKO B. RODRIGUES","LUCIA YOKO","05231152000119","492.453.056.113","1","2","0");
INSERT INTO cliente VALUES("350","fisica","HENRIQUE MOURA DA SILVA","0000-00-00","06494606938","","","","","","1","1","0");
INSERT INTO cliente VALUES("351","fisica","HENRIQUE MOURA DA SILVA","0000-00-00","06494606938","","","","","","1","1","0");
INSERT INTO cliente VALUES("352","juridica","EJC COM. DE PROD. SERIGRAFICOS E COM. VISUAL LTDA EPP","0000-00-00","","","EJC COM. DE PROD. SERIGRAFICOS E COM. VISUAL LTDA EPP","EJC - INOVA SILK","29330694000107","118.874.003-115","1","2","0");
INSERT INTO cliente VALUES("353","fisica","EDI CARLOS DIAS JUNIOR","0000-00-00","40299349861","","","","","","1","1","0");
INSERT INTO cliente VALUES("354","juridica","","0000-00-00","","","INK PRINTER DO BRASIL - COM. IMP. E EXP. LTDA - ME","INK PRINTER DO BRASIL","09232291000118","455.180.110-117","1","2","0");
INSERT INTO cliente VALUES("355","juridica","D. BARROS CASA DOS ADESIVOS","0000-00-00","","","D. BARROS DE LIMA E CIA LTDA - ME","D. BARROS CASA DOS ADESIVOS","41164542000187","24841255-8","1","2","0");
INSERT INTO cliente VALUES("356","juridica","","0000-00-00","","","GEFERSON QUEIROZ COSTA","GEFERSON Q. COSTA","23700061000167","79620040","1","2","0");
INSERT INTO cliente VALUES("357","juridica","","0000-00-00","","","ADRIANA DE LIMA MESTRES ARAUJO ME","ADRIANA DE LIMA - KROMADECKA","12424367000111","310.272.103.111","1","2","0");
INSERT INTO cliente VALUES("358","juridica","","0000-00-00","","","LUIS FERNANDO CHAGAS PESSIN","LUIS FERNANDO","24451887000100","174.101.993.112","1","2","0");
INSERT INTO cliente VALUES("359","juridica","","0000-00-00","","","CAMARGO NOGUEIRA & ALBUQUERQUE - SIGN E SERIGR. LTDA","DYNACHRON - CAMARGO NOGUEIRA","07993096000185","903.83365-30","1","2","0");
INSERT INTO cliente VALUES("360","juridica","","0000-00-00","","","ROSA MARIA DE MEDEIROS BEZERRA","RANIERI - ROSA MARIA","29306989000148","16.307.134-9","1","2","0");
INSERT INTO cliente VALUES("361","fisica","NATANIA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("362","fisica","CLAUDEMIR","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("363","juridica","L","0000-00-00","","","LEONARDO HARRY UMBELINO JACOBSEN","LEONARDO - CARLOS JACOBSEN","23356610000128","257.793.844","1","2","0");
INSERT INTO cliente VALUES("364","fisica","JOKSLAN APARECIDO DOS SANTOS","0000-00-00","04581463904","","","","","","1","1","0");
INSERT INTO cliente VALUES("365","fisica","LUCAS FERNANDO WILLENS","0000-00-00","01756359008","","","","","","1","1","0");
INSERT INTO cliente VALUES("366","fisica","ROSE","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("367","fisica","CIDO MORAIS","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("368","fisica","SUELI APARECIDA BATISTA PALMA","0000-00-00","95924434915","","","","","","1","2","0");
INSERT INTO cliente VALUES("369","fisica","RAFAEL CASSEMIRO DOS REIS","0000-00-00","06837513605","14059191","","","","","1","2","0");
INSERT INTO cliente VALUES("370","fisica","BRUNO HENRIQUE PIERRE DA SILVEIRA","0000-00-00","06971251652","","","","","","1","2","0");
INSERT INTO cliente VALUES("371","fisica","ADEMIR","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("372","juridica","","0000-00-00","","","GSILK COMERCIO DE TINTAS LTDA","GSILK MATERIAIS SERIGRAFICOS","21702925000154","209.569.754-54","1","2","0");
INSERT INTO cliente VALUES("373","fisica","VERA LUCIA ALEXANDRE","0000-00-00","76361411915","","","","","","1","1","0");
INSERT INTO cliente VALUES("374","juridica","","0000-00-00","","","LTA ROSSETTO COSMÉTICOS ME","LTA ROSSETTO - BIO BLESS COSMETICOS","04267425000112","906.47809-96","1","2","0");
INSERT INTO cliente VALUES("375","fisica","SERGIO - ANIMAQUITOS EVENTOS","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("376","juridica","","0000-00-00","","","PREFEITURA MUNICIPAL DE KALORÉ","PREFEITURA KALORÉ","75771238000110","ISENTO","1","1","0");
INSERT INTO cliente VALUES("377","juridica","","0000-00-00","","","TREVIS TINTAS SERIGRAFICAS","TREVIS TINTAS - WIDE ASSESSORIA","23569259000153","907.37933-75","1","2","0");
INSERT INTO cliente VALUES("378","juridica","","0000-00-00","","","FLAVIO TADEU DA SILVA NERES","FLAVIO TADEU - FG CAMISAS","26762746000126","141.575.685-115","1","2","0");
INSERT INTO cliente VALUES("379","juridica","","0000-00-00","","","ESTUDIO ELASTICO LTDA ME","ESTUDIO ELASTICO","17514924000109","142.072.809-113","1","2","0");
INSERT INTO cliente VALUES("380","juridica","","0000-00-00","","","WIDE MIX INDUSTRIA E COMERCIO LTDA","WIDE MIX","23569259000153","907.37933-75","1","2","0");
INSERT INTO cliente VALUES("381","juridica","","0000-00-00","","","SERILANDIA PRODUTOS SERIGRAFICOS LTDA","SERILANDIA","71071807000163","702.836.701.004","1","2","0");
INSERT INTO cliente VALUES("382","juridica","SS QUADROS","0000-00-00","","","SS QUADROS IND. E COM. LTDA - ME","SS QUADROS","13402111000176","256.359.474","1","2","0");
INSERT INTO cliente VALUES("383","fisica","LUIS CLAUDIO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("384","juridica","","0000-00-00","","","ISAC ANDRADE MACEDO ME","ISAC ANDRADE - ART BRASIL","02237511000157","305.038.018-115","1","2","0");
INSERT INTO cliente VALUES("385","juridica","","0000-00-00","","","F. ARABELA G. DE OLIVEIRA COM. E SERVIÇOS ME","F. ARABELA - INKSIGNSTORE","28036561000160","066614473","1","2","0");
INSERT INTO cliente VALUES("386","juridica","","0000-00-00","","","ZEFFS CRIAÇÕES E COMERCIO DE ROUPAS LTDA","ZEFFS CRIAÇÕES","22384184000173","317.368.592.0006","1","1","0");
INSERT INTO cliente VALUES("387","fisica","CRIS","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("388","juridica","","0000-00-00","","","PAULO FERNANDO DE TOMMASO","PAULO FERNANDO","","","1","2","0");
INSERT INTO cliente VALUES("389","juridica","CESAR ANTONIO","0000-00-00","","","CESAR ANTONIO FIRMO DE JESUS","CESAR - CONTRAMÃO WEB","12862600000148","672105045119","1","2","0");
INSERT INTO cliente VALUES("390","juridica","SERINGAL EQUIPAMENTOS DE SEGURANÇPA E PRODUTOS IND. EIRELI ME","0000-00-00","","","SERINGAL EQUIP. DE SEGURANÇA E PRODUTOS INDUSTRIAL EIRELI ME","SERINGAL","10928203000104","148.662.166.118","1","1","0");
INSERT INTO cliente VALUES("391","juridica","","0000-00-00","","","LIERRE TEXTIL LTDA","LIERRE","02377713000102","047158026","1","2","0");
INSERT INTO cliente VALUES("392","fisica","MARILENE","0000-00-00","","","MARILENE","","","","1","1","0");
INSERT INTO cliente VALUES("393","fisica","LUCINEIA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("394","fisica","EMERSON DA SILVA BRANCO - LANCA","0000-00-00","18697114837","","","","","","1","1","0");
INSERT INTO cliente VALUES("395","juridica","","0000-00-00","","","A.P.B EISENBERG TINTAS ME","A.P.B EISENBERG","30392832000161","336.775.609-119","1","2","0");
INSERT INTO cliente VALUES("396","fisica","FABIO FERNANDES DA SILVA","0000-00-00","18308361889","","","","","","1","0","0");
INSERT INTO cliente VALUES("397","juridica","","0000-00-00","","","LUIZ CLAUDIO ANTICO-ME","LUIZ CLAUDIO","68308030000101","582.334.738.114","1","2","0");
INSERT INTO cliente VALUES("398","juridica","","0000-00-00","","","GABRIEL BELLUSSI DE SOUZA","GABBRIEL BELLUSSI","29877710000186","214.239.698-117","1","2","0");
INSERT INTO cliente VALUES("399","fisica","ANTONIO SERAPIÃO FERREIRA","0000-00-00","84252901804","","","","","","1","1","0");
INSERT INTO cliente VALUES("400","fisica","JEFFERSON CANTAGALLI","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("401","fisica","MARIA TEREZA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("402","juridica","","0000-00-00","","","SOEDMAR SOCIEDADE EDUCACIONAL DE MARINGÁ LTDA","SOEDMAR - COLEGIO OBJETIVO","80888357000197","ISENTO","1","1","0");
INSERT INTO cliente VALUES("403","fisica","FLÁVIA ALVES KLASSEN","0000-00-00","02057945995","","","","","","1","1","0");
INSERT INTO cliente VALUES("404","fisica","DANILO NEVES DE OLIVEIRA","0000-00-00","88739058115","","","","","","1","1","0");
INSERT INTO cliente VALUES("405","fisica","MARIA TEREZA","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("406","fisica","ROSANE","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("407","juridica","","0000-00-00","","","PROPENSA COMUNICAÇAO LTDA - ME","PROPENSA","07566770000145","255.763.735","1","2","0");
INSERT INTO cliente VALUES("408","fisica","MADELAINE","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("409","fisica","VITOR","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("410","fisica","LETICIA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("411","fisica","DENILSON VIOLIN","0000-00-00","77137264972","","","","","","1","0","0");
INSERT INTO cliente VALUES("412","juridica","","0000-00-00","","","G.R.B","","","","1","2","0");
INSERT INTO cliente VALUES("413","juridica","RANIERI - ADRIANA","0000-00-00","","","ADRIANA FERNANDE DE BRITO","RANIERI - ADRIANA","17705892000129","20.283.435-2","1","2","0");
INSERT INTO cliente VALUES("414","juridica","ANA RODRIGUES - DFABRIKA CONF.","0000-00-00","","","ANA LETICIA  RODRIGUES BARBOSA","ANA LETICIA  RODRIGUES - DFABRIKA CONF.","30811658000144","428.044.921-44","1","1","0");
INSERT INTO cliente VALUES("415","juridica","","0000-00-00","","","TOCA DO SILK COMERCIO E SERVIÇOS LTDA","TOCA DO SILK","31635602000149","11.275.770","1","2","0");
INSERT INTO cliente VALUES("416","juridica","FJ COMERCIO","0000-00-00","","","FJ COMERCIO E DIST. DE PRODUTOS SERIGRAFICOS LTDA","FJ COMERCIO","09580596000110","077296805","1","2","0");
INSERT INTO cliente VALUES("417","fisica","MARIA GUIDA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("418","fisica","MARCELO RODRIGO DE SOUZA","0000-00-00","31738946851","","","","","","1","1","0");
INSERT INTO cliente VALUES("419","juridica","G R GONÇALVES - G R S COMERCIO","0000-00-00","","","G R GONÇALVES ME","G R GONÇALVES - G R S COMERCIO","12184164000103","192126199","1","2","0");
INSERT INTO cliente VALUES("420","fisica","LAKO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("421","fisica","GUSTAVO DE SOUZA LIMA","0000-00-00","00572852924","7.336.867-7","","","","","1","1","0");
INSERT INTO cliente VALUES("422","juridica","","0000-00-00","","","CHRYSTIAN GOMES DA COSTA","CHRYSTIAN GOMES - ZULLA ESTAMPARIA","28354424000173","198.121.091.116","1","2","0");
INSERT INTO cliente VALUES("423","fisica","MARIA LUCIA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("424","fisica","MARINA T. LOPES","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("425","juridica","GILSA","0000-00-00","","","GISLENE CRISTINA DE OLIVEIRA SOUZA","GISLENE CRISTINA - MANOLUMI","03436647000582","442.285.327.119","1","2","0");
INSERT INTO cliente VALUES("426","fisica","RAFAEL","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("427","fisica","RODOLFO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("428","juridica","MACUCO","0000-00-00","","","MACUCO - MARINGÁ CULTURAL COOPERATIVISMO","MACUCO","24776781000179","ISENTO","1","1","0");
INSERT INTO cliente VALUES("429","juridica","HJM DISTRIBUIÇÃO DE FRIOS LTDA","0000-00-00","","","HJM DISTRIBUIÇÃO DE FRIOS LTDA","HJM DISTRIBUIÇÃO - HERNANI","15491554000106","905.94657-99","1","2","0");
INSERT INTO cliente VALUES("430","fisica","MARIA JOANA DE CALDAS SILVA","0000-00-00","80188664904","","","","","","1","1","0");
INSERT INTO cliente VALUES("431","fisica","ALEX SANDO DA CONCEIÇÃO","0000-00-00","05224317711","","","","","","1","1","0");
INSERT INTO cliente VALUES("432","fisica","EDIMAR FERREIRA DA SILVA","0000-00-00","31350061824","","","","","","1","1","0");
INSERT INTO cliente VALUES("433","fisica","MARCIO ROGERIO DOMINGUOS DE SOUZA","0000-00-00","07363220433","","","","","","1","1","0");
INSERT INTO cliente VALUES("434","juridica","","0000-00-00","","","ADRIANA CRISTINA BONANI BOVO - ME","ADRIANA - CONF. BONANI","74245317000124","587.108.346.112","1","2","0");
INSERT INTO cliente VALUES("435","juridica","","0000-00-00","","","ELIZANGELA LEITE RODRIGUES","ELIZANGELA LEITE","20122829000174","302019796117","1","1","0");
INSERT INTO cliente VALUES("436","juridica","C N QUEIROZ - POTISIGNS","0000-00-00","","","C N QUEIROZ EIRELI","C N QUEIROZ - POTISIGNS","23699056000181","16.264.460-4","1","2","0");
INSERT INTO cliente VALUES("437","juridica","GLOBAL MALHARIA","0000-00-00","","","","","","","1","2","0");
INSERT INTO cliente VALUES("438","juridica","","0000-00-00","","","GLOBAL MALHARIA E CONFECÇÕES LTDA ME","GLOBAL MALHARIA","05048163000168","076.395.5900-193","1","2","0");
INSERT INTO cliente VALUES("439","fisica","CELSO KOEKE","0000-00-00","92342752849","","","","","","1","1","0");
INSERT INTO cliente VALUES("440","fisica","JOSÉ CARLOS PEREIRA","0000-00-00","10629529876","","","","","","1","1","0");
INSERT INTO cliente VALUES("441","fisica","MARIA ALINE","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("442","juridica","","0000-00-00","","","PAULO AFONSO DUARTE ALVES","PAULO AFONSO","15127790000148","0019231530003","1","2","0");
INSERT INTO cliente VALUES("443","juridica","GG TELAS","0000-00-00","","","GG IND. E COM. DE  TELAS SERIGRAFICAS LTDA","GG TELAS","06119290000173","0190089504","1","2","0");
INSERT INTO cliente VALUES("444","fisica","ANA BEATRYZ NUNES BRITO DA SILVA","0000-00-00","45536083830","38048381-6","","","","","1","1","0");
INSERT INTO cliente VALUES("445","juridica","","0000-00-00","","","SILVIA REGINA SOUTO DOS SANTOS - ME","SILVIA REGINA - DAY NEWS","15656290000101","141.670.206.117","1","2","0");
INSERT INTO cliente VALUES("446","fisica","WALDEMIR ANTONIO DE SOUZA","0000-00-00","07509631823","","","","","","1","1","0");
INSERT INTO cliente VALUES("447","fisica","GERSON PEREIRA PINTO","0000-00-00","20632991968","","","","","","1","1","0");
INSERT INTO cliente VALUES("448","juridica","ZENOR PANSIERE","0000-00-00","","","ZENOR PANSIERE FILHO","ZENOR PANSIERE","30266800000110","ISENTO","1","2","0");
INSERT INTO cliente VALUES("449","fisica","LEONILDA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("450","fisica","ALEXEI SANTANA DELGADO","0000-00-00","06783234100","","","","","","1","1","0");
INSERT INTO cliente VALUES("451","juridica","","0000-00-00","","","MATERIA PRIMA COMERCIO DE MATERIAIS, PEÇAS E MAQUINAS EIRELI - EPP","MATERIA PRIMA","27304231000145","16.291.410-5","1","2","0");
INSERT INTO cliente VALUES("452","fisica","MARTA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("453","fisica","LUZINETE","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("454","juridica","","0000-00-00","","","MARIA JOSÉ PENDEK ZOEGA","MARIA JOSE","28788556000103","278.311.655.118","1","2","0");
INSERT INTO cliente VALUES("455","juridica","ALYNE CRISTINA DE ALMEIDA","0000-00-00","","","ALYNE CRISTINA DE ALMEIDA","ALYNE - SERIGRAFE","31230670000128","4180685838-2","1","2","0");
INSERT INTO cliente VALUES("456","juridica","","0000-00-00","","","C.A. RUIZ P. PRUDENTE - ME","C.A. RUIZ - LITEC","00316462000112","562.262.314.116","1","1","0");
INSERT INTO cliente VALUES("457","juridica","LUCAS SCURIATTI MARTINS","0000-00-00","","","LUCAS SCURIATTI MARTINS","LUCAS SCURIATTI - SILK CENTER DIGITAL","33304930000198","181.420.691.116","1","2","0");
INSERT INTO cliente VALUES("458","fisica","GILMARA CRISTINA DUARTE DE ALMEIDA - ZEFFS","0000-00-00","88939871634","","","","","","1","2","0");
INSERT INTO cliente VALUES("459","juridica","","0000-00-00","","","ASSOCIAÇÃO CULTURAL SANTO INACIO","ASSOCIAÇÃO - SANTO INACIO","79140620000186","ISENTO","1","1","0");
INSERT INTO cliente VALUES("460","juridica","","0000-00-00","","","PRIMEIRA IGREJA PRESBITERIANA INDEPENDENTE DE MARINGÁ","PRIMEIRA IGREJA PRESBITERIANA","79152153000104","ISENTO","1","1","0");
INSERT INTO cliente VALUES("461","fisica","GILBERTO RUY BAZZO","0000-00-00","01299720889","","","","","","1","2","0");
INSERT INTO cliente VALUES("462","fisica","MIRIAN TOLEDO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("463","fisica","RENATO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("464","juridica","JOÃO ANTONIO UNIFORMES","0000-00-00","","","","","02446109000182","454.259.265-118","1","2","0");
INSERT INTO cliente VALUES("465","juridica","","0000-00-00","","","JOÃO ANTONIO DE CARVALHO UNIFORMES","JOÃO ANTONIO UNIFORMES","02446109000182","454.259.265-118","1","2","0");
INSERT INTO cliente VALUES("466","fisica","PAULO VITOR ALVES E SANTOS - CENTER SILK","0000-00-00","08681881663","","","","","","1","2","0");
INSERT INTO cliente VALUES("467","juridica","CARIOCA SILK SERVIÇOS SERIGRAFICOS EIRELI","0000-00-00","","","CARIOCA SILK SERVIÇOS SERIGRAFICOS EIRELI","CARIOCA SILK","31445029000100","33.60070083-3","1","2","0");
INSERT INTO cliente VALUES("468","juridica","POTIGUAR - POTISIGNS","0000-00-00","","","POTIGUAR ATACADISTA IMPORTAÇÃO E COMERCIO DE PLASTICOS EIRELI","POTIGUAR - POTISIGNS","22575574000120","20.429956-0","1","2","0");
INSERT INTO cliente VALUES("469","fisica","LUIS GUSTAVO BUCHI PAULILLO","0000-00-00","16080796864","","","","","","1","2","0");
INSERT INTO cliente VALUES("470","juridica","","0000-00-00","","","MARIA ELISABETE DA HORA - ME","ARIAL - MARIA ELISABETE","25683468000159","278.278.904.118","1","2","0");
INSERT INTO cliente VALUES("471","fisica","AYMEE PALUDETTO","0000-00-00","08818001981","","","","","","1","1","0");
INSERT INTO cliente VALUES("472","fisica","MARCO BRAZ","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("473","fisica","KARINE CANDIDO DE MACEDO CERDEIRA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("474","fisica","EDSON IRENO ALVES","0000-00-00","07113524966","","","","","","1","1","0");
INSERT INTO cliente VALUES("475","juridica","","0000-00-00","","","P.C DE OLIVEIRA SOUZA","P.C DE OLIVEIRA - MANOLUMI","32744866000101","657.413.736.117","1","2","0");
INSERT INTO cliente VALUES("476","juridica","MANOLUMI COMERCIO VAREJISTA DE MATERIAIS P/COM. VISUAL LTDA","0000-00-00","","","MANOLUMI COMERCIO VAREJISTA DE MATERIAIS P/COMUN. VISUAL LTDA","MANOLUMI","66624198000192","442.072.519.110","1","2","0");
INSERT INTO cliente VALUES("477","juridica","ROTA 34 SHOP LTDA - ME","0000-00-00","","","ROTA 34 SHOP LTDA - ME","ROTA 34 SHOP","10810987000163","0011613110057","1","2","0");
INSERT INTO cliente VALUES("478","juridica","","0000-00-00","","","WILLIAM GOMES VILAR RODRIGUES","WILLIAN - ZIRZOV","26849468000149","ISENTO","1","0","0");
INSERT INTO cliente VALUES("479","juridica","","0000-00-00","","","QUALICOR REVESTIMENTO E EMBALAGENS EPP","QUALICOR","21014284000145","688.334.067-113","1","1","0");
INSERT INTO cliente VALUES("480","fisica","ANDRE AUGUSTO RODRIGUES RESTA","0000-00-00","08041809979","","","","","","1","1","0");
INSERT INTO cliente VALUES("481","juridica","","0000-00-00","","","MEGA GLOBAL COMERCIO, IMPORTAÇÃO E EXPORTAÇÃO LTDAS","GLOBAL TECIDOS","11440767000158","336.915.660-116","1","2","0");
INSERT INTO cliente VALUES("482","fisica","ADEMIR","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("483","fisica","TIMÓTIO GOMES SERRA JUNIOR","0000-00-00","05388615928","","","","","","1","0","0");
INSERT INTO cliente VALUES("484","fisica","PAULA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("485","juridica","","0000-00-00","","","DAMASIO STUDIUS LTDA","DAMASIO STUDIUS","08416082000161","149.492.120-112","1","2","0");
INSERT INTO cliente VALUES("486","fisica","SUSANA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("487","juridica","","0000-00-00","","","PREFEITURA MUNICIPAL DE JARU","PREFEITURA DE JARU","","","1","2","0");
INSERT INTO cliente VALUES("488","fisica","PATRICIA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("489","fisica","PAULO CESAR RECCHIA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("490","fisica","DEBORA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("491","juridica","","0000-00-00","","","IMAGEM IMPORTAÇÃO E COMERCIO LTDA","IMAGEM IMPORTAÇÃO","08674661000104","28.341.826-5","1","2","0");
INSERT INTO cliente VALUES("492","juridica","","0000-00-00","","","PREFEITURA MUNICIPAL DE PAIÇANDU","PREFEITURA PAIÇANDU","","","1","1","0");
INSERT INTO cliente VALUES("493","fisica","DANILO GUALBERTO DOS SANTOS OLIVEIRA","0000-00-00","36995600827","","","","","","1","1","0");
INSERT INTO cliente VALUES("494","fisica","ELIZA PROFETA","1985-06-30","07897304990","","","","","","1","1","0");
INSERT INTO cliente VALUES("495","juridica","","0000-00-00","","","J R DOS SANTOS ESTAMPARIA ME","J R DOS SANTOS","29035386000159","083365605","1","2","0");
INSERT INTO cliente VALUES("496","juridica","M. ALMEIDA","0000-00-00","","","M. ALMEIDA DA SILVA ME","M. ALMEIDA - POINT DO SILK","06966142000194","","1","2","0");
INSERT INTO cliente VALUES("497","fisica","RAFAEL HENRIQUE DENARDIN CECATO","0000-00-00","00798005998","","","","","","1","1","0");
INSERT INTO cliente VALUES("498","juridica","","0000-00-00","","","S TELAS PRODUTOS SERIGRAFICOS LTDA","SERITELAS","34128337000109","908.19475-60","1","1","0");
INSERT INTO cliente VALUES("499","fisica","SOPHIA EGOFF FOGOLIN","0000-00-00","05194600909","78714875","","","","","1","1","0");
INSERT INTO cliente VALUES("500","juridica","","0000-00-00","","","PEDRO FERREIRA DE ARAUJO ME","PEDRO FERREIRA - ALIDAY COMERCIO","02277211000100","0738000800122","1","2","0");
INSERT INTO cliente VALUES("501","fisica","GUSTAVO DE MENEZES LIMA","0000-00-00","09936046765","1679701","","","","","1","1","0");
INSERT INTO cliente VALUES("502","juridica","S","0000-00-00","","","SANTOS E PERINI COMERCIO DE CONFECÇÕES LTDA","SANTOS E PERINI","06345889000125","93.10373-68","1","1","0");
INSERT INTO cliente VALUES("503","fisica","ISONIR SEBOLD","0000-00-00","02014206945","","","","","","1","1","0");
INSERT INTO cliente VALUES("504","fisica","ROSA MARIA PORIFICAÇÃO VALENTE LUZ","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("505","fisica","SULIVAN","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("506","juridica","","0000-00-00","","","RADINS & CIA LTDA","RADINS - CRAVO & CANELA","12439982000100","13.399.253-5","1","2","0");
INSERT INTO cliente VALUES("507","fisica","CLEIDE REGINA DOS SANTOS SEBIN","0000-00-00","","4.230.447-6","","","","","1","1","0");
INSERT INTO cliente VALUES("508","fisica","VERONICA MULLER","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("509","juridica","BRIGIDO COM. DE PROD. E MAT. PARA COM. VISUAL","0000-00-00","","","BRIGIDO COM. DE PROD. E MAT. PARA COMUNIC. VISUAL LTDA","BRIGIDO","32950964000197","675.357.755-114","1","2","0");
INSERT INTO cliente VALUES("510","fisica","DEBORA THAIS GLOOR","0000-00-00","06711694910","","","","","","1","1","0");
INSERT INTO cliente VALUES("511","juridica","","0000-00-00","","","JARDEL UNIFORMES LTDA - ME","JARDEL UNIFORMES","13822449000187","79.431.397","1","2","0");
INSERT INTO cliente VALUES("512","fisica","ANDERSON OLIVEIRA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("513","fisica","LEANDRO","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("514","juridica","","0000-00-00","","","MEGA SCREEN COMERCIO E SERVIÇOS GRAFICOS LTDA ME","MEGA SCREEN","67552240000170","113.393.433.112","1","2","0");
INSERT INTO cliente VALUES("515","juridica","L.F. VIEIRA - POINT DO SILK","0000-00-00","","","L.F. VIEIRA CARNEIRO ME","L.F. VIEIRA - POINT DO SILK","34575577000143","160.574.370","1","2","0");
INSERT INTO cliente VALUES("516","fisica","LUIZ CARLOS BARIAN","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("517","fisica","RODRIGO JOSÉ PINTO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("518","juridica","","0000-00-00","","","CRV PRISMA LTDA","PRISMA","17527038000110","90620129-16","1","2","0");
INSERT INTO cliente VALUES("519","juridica","DEVAN","0000-00-00","","","DEVAN INDUSTRIA E COMERCIO DE CONFECÇÕES LTDA","DEVAN","03612010000176","029237009","1","2","0");
INSERT INTO cliente VALUES("520","fisica","PAULO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("521","juridica","","0000-00-00","","","RICARDO ANTONIO MORABITO - ME","RICARDO - R SILK","27179764000223","06195621-0","1","2","0");
INSERT INTO cliente VALUES("522","juridica","","0000-00-00","","","THEODORICO COM. E  IND. DE ARTIGOS TEXTIL LTDA","THEODORICO","05053361000110","902.58236-37","1","2","0");
INSERT INTO cliente VALUES("523","fisica","CLAUDEMIR","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("524","juridica","c","0000-00-00","","","C N QUEIROZ SALVADOR COMERCIO E REPRES. COMERCIAL LTDA","C N QUEIROZ SALVADOR - POTISIGNS","35087359000122","162.019.940","1","2","0");
INSERT INTO cliente VALUES("525","fisica","KARLA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("526","juridica","","0000-00-00","","","CRISTIANO RAFAEL CORAL","CRISTIANO RAFAEL","27345717000121","ISENTO","1","1","0");
INSERT INTO cliente VALUES("527","juridica","INST. FED. DO PARANÁ/CAMPUS PALMAS","0000-00-00","","","INSTITUTO FEDERAL DO PARANÁ / CAMPUS PALMAS","INST. FED. DO PARANÁ/CAMPUS PALMAS","10652179001006","ISENTO","1","1","0");
INSERT INTO cliente VALUES("528","fisica","RAFAELE PARMA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("529","juridica","","0000-00-00","","","JC MIX VARIEDADES LTDA","JC MIX","34999471000177","908.28119-55","1","2","0");
INSERT INTO cliente VALUES("530","fisica","CRISTIANE","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("531","juridica","IN","0000-00-00","","","INSTITUTO FEDERAL DO PARANÁ / CAMPUS IVAIPORA","INST. FED. PARANÁ / CAMPUS IVAIPORA","10652179001278","ISENTO","1","1","0");
INSERT INTO cliente VALUES("532","juridica","PRIME","0000-00-00","","","PRIME EXPRESS LOG E TRANSP. LTDA","PRIME EXPRESS","10642884000131","407691401116","1","2","0");
INSERT INTO cliente VALUES("533","fisica","MARIA APARECIDA DA SILVA ALVES","0000-00-00","02883055904","","","","","","1","0","0");
INSERT INTO cliente VALUES("534","juridica","","0000-00-00","","","CTG RINCÃO VERDE DE MARINGÁ","CTG","76718493000161","ISENTO","1","1","0");
INSERT INTO cliente VALUES("535","juridica","","0000-00-00","","","INSTITUTO FEDERAL DO PARANÁ / CAMPUS CASCAVEL","INST. FED. PR / CAMPUS CASCAVEL","10652179001430","ISENTO","1","1","0");
INSERT INTO cliente VALUES("536","fisica","DAIANA RAMOS","0000-00-00","00953844994","","","","","","1","1","0");
INSERT INTO cliente VALUES("537","fisica","JUCELINO CORDEIRO","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("538","fisica","ALEXANDRE AGUIAR","0000-00-00","13548711898","","","","","","1","1","0");
INSERT INTO cliente VALUES("539","fisica","BRUNO HENRIQUE MARCIANO DE MORAIS","0000-00-00","01057425974","","","","","","1","1","0");
INSERT INTO cliente VALUES("540","fisica","WILLIAN RICARDO KAVAGUTI","0000-00-00","02822703965","","","","","","1","1","0");
INSERT INTO cliente VALUES("541","juridica","FACSTAMP FACÇÃO DE CONFECÇÕES LTDA - ME","0000-00-00","","","FACSTAMP FACÇÃO DE CONFECÇÕES LTDA - ME","FACSTAMP","08796932000102","907.50795-56","1","2","0");
INSERT INTO cliente VALUES("542","juridica","S M DE BRITO - ME","0000-00-00","","","S M DE BRITO - ME","S M DE BRITO - POTISGNS - MACEIO","28676399000144","247.40642-2","1","2","0");
INSERT INTO cliente VALUES("543","juridica","","0000-00-00","","","E DE OLIVEIRA FANÇA EIRELI","E DE OLIVEIRA - POTISIGNS - ARAPIRACA","33563265000157","243.01722-7","1","2","0");
INSERT INTO cliente VALUES("544","fisica","FRANCIELE","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("545","juridica","","0000-00-00","","","COCAMAR COOPERATIVA AGROINDUSTRIAL","COCAMAR","79114450000165","701.02859-70","1","1","0");
INSERT INTO cliente VALUES("546","juridica","","0000-00-00","","","INSTITUTO BENJAMIM CONSTANT - RJ","INST. BENJAMIM CONSTANT-RJ","00394445027212","ISENTO","1","1","0");
INSERT INTO cliente VALUES("547","juridica","INSTITUTO FEDERAL DO PARANÁ / CAMPUS PARANAVAÍ","0000-00-00","","","INSTITUTO FEDEERAL DO PARANÁ / CAMPUS PARANAVAÍ","INST. FED. PR / CAMPUS PARANAVAÍ","10652179000620","ISENTO","1","1","0");
INSERT INTO cliente VALUES("548","fisica","EDILBERTO GILBERTO DE GODOY","0000-00-00","23934077900","","","","","","1","1","0");
INSERT INTO cliente VALUES("549","juridica","","0000-00-00","","","SEJUF - SECRETARIA DE ESTADO DA JUSTIÇA, FAMILIA E TRABALHO","SEJUF","40245920000194","ISENTO","1","1","0");
INSERT INTO cliente VALUES("550","juridica","","0000-00-00","","","SAMMANTHA MARILAQUE DULTRA","SAMMANTHA","27297268000193","908.02188-66","1","2","0");
INSERT INTO cliente VALUES("551","juridica","LUCILENE","0000-00-00","","","LUCILENE MAGALHÃES VIANA BARBOSA - ME","LUCILENE - LUNI","08359040000136","072.254.724","1","2","0");
INSERT INTO cliente VALUES("552","juridica","","0000-00-00","","","MARINGA EPI EQUIPAMENTOS DE PROTEÇÃO LTDA","MARINGA EPI","32044946000146","","1","2","0");
INSERT INTO cliente VALUES("553","juridica","","0000-00-00","","","ELUIZA BACLAN CRISTALINO","ELUIZA","22883583000189","649.045.208-111","1","1","0");
INSERT INTO cliente VALUES("554","fisica","ROBERTO GARCIA NEVES","0000-00-00","20470959991","","","","","","1","1","0");
INSERT INTO cliente VALUES("555","juridica","C.P. BARBOSA - REPRESENTAÇÕES COMERCIAL - EIRELI","0000-00-00","","","C.P. BARBOSA - REPRESENTAÇÕES COMERCIAIS - ERELI","C.P. BARBOSA","28321523000159","3560191879-6","1","2","0");
INSERT INTO cliente VALUES("556","fisica","ANA CHAVES","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("557","juridica","","0000-00-00","","","INSTITUTO FEDERAL TRIANGULO MINEIRO / CAMPUS PATOS DE MINAS","INST. FED. TRIG. MINEIRO / CAMPUS PATOS DE MINAS","10695891000878","ISENTO","1","1","0");
INSERT INTO cliente VALUES("558","fisica","RAFAEL LIPINSKI","0000-00-00","08626380976","","","","","","1","1","0");
INSERT INTO cliente VALUES("559","fisica","JAILSON DE CASTRO CRUZ","0000-00-00","27273452831","","","","","","1","1","0");
INSERT INTO cliente VALUES("560","fisica","MARCIA CAMPOS TEIXEIRA","0000-00-00","70000425915","","","","","","1","0","0");
INSERT INTO cliente VALUES("561","fisica","GABRIELA LAVIU CAMPOS","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("562","juridica","SONIVAN - ARTESANATO ANA MARIA","0000-00-00","","","SONIVAM ARTESANATOS E ARMARINHOS LTDA","SONIVAN - ARTESANATO ANA MARIA","80797913000110","701.03225-07","1","2","0");
INSERT INTO cliente VALUES("563","fisica","ALEX SANDRO DA CONCEIÇÃO","0000-00-00","05224317711","","","","","","1","1","0");
INSERT INTO cliente VALUES("564","fisica","RAFAEL BORTOLOZO PROENÇA ROSA","0000-00-00","14188606703","","","","","","1","1","0");
INSERT INTO cliente VALUES("565","fisica","ALEXANDRE - MGA","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("566","juridica","","0000-00-00","","","MARIA JULLIETTH DOS SANTOS","MARIA JULLIETTH - JJ CAMISETAS","27647372000160","071.8514-61","1","2","0");
INSERT INTO cliente VALUES("567","juridica","TELA","0000-00-00","","","TELASILK COMERCIO DE MATERIAIS SERIGRAFICOS LTDA","TELASILK - SÃO JOSE","05470899000200","645.470.882.115","1","2","0");
INSERT INTO cliente VALUES("568","fisica","THANY CORREIA OLIVEIRA PONTES","0000-00-00","00899091946","","","","","","1","1","0");
INSERT INTO cliente VALUES("569","fisica","MARIA TEREZA - PERTO POLICIA FEDERAL","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("570","fisica","JUCIMARA - COLEGIO STO INACIO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("571","fisica","REGINA CELI DE FREITAS GARCIA FREITAS","0000-00-00","51186772972","3986857-8","","","","","1","1","0");
INSERT INTO cliente VALUES("572","juridica","AMSIGN","0000-00-00","","","AM SIGN COMERCIO DE EQUIPAMENTOS E SUPRIMENTOS LTDA","AMSIGN","32804063000197","123.638.216.118","1","2","0");
INSERT INTO cliente VALUES("573","juridica","","0000-00-00","","","PREFEITURA MUNICIPAL DE RIBEIRÃO PRETO","PREFEITURA RIBEIRÃO PRETO","56024581000156","ISENTO","1","1","0");
INSERT INTO cliente VALUES("574","fisica","JULIANA","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("575","fisica","ADRIANA - COLEGIO STA CRUZ","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("576","fisica","ANA PAULA","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("577","fisica","RAQUEL","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("578","fisica","MARISABEL DALSEGIO","0000-00-00","00809779951","","","","","","1","0","0");
INSERT INTO cliente VALUES("579","juridica","PREF. MUNICIPAL VARZEA GRANDE","0000-00-00","","","PREFEITURA MUNICIPAL DE VÁRZEA GRANDE","PREF. MUNICIPAL VARZEA GRANDE","03507548000110","ISENTO","1","1","0");
INSERT INTO cliente VALUES("580","juridica","","0000-00-00","","","MUNICIPIO DE ARROIO TRINTA","MUNICIPIO DE ARROI TRINTA","82826462000127","ISENTO","1","1","0");
INSERT INTO cliente VALUES("581","juridica","","0000-00-00","","","MUNICIPIO DE BRUNOPOLIS","MUNICIPIO DE BRUNOPOLIS","01613853000161","ISENTO","1","1","0");
INSERT INTO cliente VALUES("582","juridica","","0000-00-00","","","FUNDO MUNICIPAL DE SAUDE DE FRAIBURGO","FUNDO MUNIC. FRAIBURGO","10496741000169","ISENTO","1","1","0");
INSERT INTO cliente VALUES("583","juridica","","0000-00-00","","","FUNDO MUNICIPAL DE SAUDE DE RIO NEGRINHO","FUNDO MUNICIPAL DE SAUDE DE RIO NEGRINHO","10377912000130","ISENTO","1","1","0");
INSERT INTO cliente VALUES("584","juridica","PREFEITURA MUNICIPAL DE PARANAGUA","0000-00-00","","","PREFEITURA MUNICIPAL DE PARANAGUA","PREFEITURA MUNICIPAL DE PARANAGUA","76017458000115","ISENTO","1","1","0");
INSERT INTO cliente VALUES("585","juridica","MUNICIPIO DE CURITIBANOS","0000-00-00","","","MUNICIPIO DE CURITIBANOS","MUNICIPIO DE CURITIBANOS","83754044000134","ISENTO","1","1","0");
INSERT INTO cliente VALUES("586","juridica","","0000-00-00","","","CLEBER MAGALHÃES RIBEIRO","CLEBER MAGALHÃES","18251663000144","ISENTO","1","1","0");
INSERT INTO cliente VALUES("587","fisica","JOSE RICARDO DA SILVA - CARIOCA SILK","0000-00-00","82186260778","","","","","","1","2","0");
INSERT INTO cliente VALUES("588","fisica","FABIO RIGON","0000-00-00","88497402987","","","","","","1","1","0");
INSERT INTO cliente VALUES("589","fisica","JANE - JD CANADÁ","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("590","fisica","RAYSSA ALMEIDA GASPAR","0000-00-00","08588274922","","","","","","1","0","0");
INSERT INTO cliente VALUES("591","juridica","","0000-00-00","","","MUNICIPIO DE TIMBO GRANDE","MUNICIPIO DE TIMBO GRANDE","78497492000160","ISENTO","1","1","0");
INSERT INTO cliente VALUES("592","fisica","ANNA CAROLINA EGOROFF","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("593","fisica","ANNA CAROLINA EGOROFF","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("594","juridica","","0000-00-00","","","DEJANINE NARA PANTOJA","DEJANINE NARA","19709115000188","00000004018851","1","1","0");
INSERT INTO cliente VALUES("595","juridica","","0000-00-00","","","SECRETARIA DE ESTADO DA SEGURANÇA PUBLICA","SECRETARIA -DEPEN","76416932000181","ISENTO","1","0","0");
INSERT INTO cliente VALUES("596","fisica","FABIANO LEMOS TOME","0000-00-00","04145904907","","","","","","1","1","0");
INSERT INTO cliente VALUES("597","fisica","FABIANO LEMOS TOME","0000-00-00","04145904907","","","","","","1","1","0");
INSERT INTO cliente VALUES("598","fisica","FABIANO LEMOS TOME","0000-00-00","04145904907","","","","","","1","1","0");
INSERT INTO cliente VALUES("599","fisica","RENAN MORAIS","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("600","juridica","","0000-00-00","","","PREFEITURA MUNICIPAL DE MARILIA","PREFEITURA MUNICIPAL DE MARILIA","44477909000100","ISENTO","1","1","0");
INSERT INTO cliente VALUES("601","fisica","CINTIA CRISITNA SANTANA TAKEMOTO","0000-00-00","02114952983","","","","","","1","1","0");
INSERT INTO cliente VALUES("602","fisica","RONY BULLA GARCIA","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("603","fisica","ADRIANA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("604","fisica","ANNE CAROLINE RODRIGUES DORTA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("605","juridica","","0000-00-00","","","RICARDO ANTONIO MORABITO","RICARDO ANTONIO","27179764000223","061956210","1","2","0");
INSERT INTO cliente VALUES("606","fisica","JB TELAS","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("607","fisica","ANDREIA -","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("608","fisica","ANDREIA -","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("609","fisica","ANDREIA -","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("610","fisica","ANDREIA -","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("611","fisica","MARIA PAULA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("612","fisica","MARIA PAULA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("613","juridica","","0000-00-00","","","N.R.M LEMES COM. DE TINTAS E REPRESENTAÇÕES ME","N.R.M LEMES - TUNING BRASIL","21687945000101","154735353","1","2","0");
INSERT INTO cliente VALUES("614","fisica","KAREN","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("615","juridica","","0000-00-00","","","ESTANCIA MARINGA","ESTANCIA MARINGA","","","1","1","0");
INSERT INTO cliente VALUES("616","fisica","CLEONICE","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("617","fisica","HUMBERTO DE ANDRADE AMADO NETTO","0000-00-00","12462998799","","","","","","1","0","0");
INSERT INTO cliente VALUES("618","juridica","","0000-00-00","","","G FARIA GUARATINGUETA ME","G FARIA","04775044000144","332.140.273.118","1","2","0");
INSERT INTO cliente VALUES("619","fisica","ALEXANDRA JUST","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("620","fisica","GUILHERME","0000-00-00","09292521950","","","","","","1","1","0");
INSERT INTO cliente VALUES("621","juridica","","0000-00-00","","","LOTUS SUPR. P/COM. VISUAL E TOLOS LTDA","LOTUS SUPR.","06322776000104","28.331.683-7","1","2","0");
INSERT INTO cliente VALUES("622","fisica","MARIA FERNANDA RIBEIRO","0000-00-00","12959046404","","","","","","1","1","0");
INSERT INTO cliente VALUES("623","juridica","E. AMOREZI - SUP. AMOREZI","0000-00-00","","","E. AMOREZI SUPERMERCAD0 EIRELI","E. AMOREZI - SUP. AMOREZI","03163462000118","901.84603-08","1","1","0");
INSERT INTO cliente VALUES("624","fisica","GEYSA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("625","juridica","","0000-00-00","","","FUNDO MUNICIPAL DE ASSISTÊNCIA SOCIAL DE ABDON BATISTA / SC","FUNDO MUNIC. DE ASSIST SOCIAL ABDON BATAISTA","10359074000172","ISENTO","1","1","0");
INSERT INTO cliente VALUES("626","juridica","","0000-00-00","","","S DOMINGO DE OLIVERIA","S DOMINGOS","10705762000147","20.072.906-3","1","2","0");
INSERT INTO cliente VALUES("627","juridica","CID GONÇALVES DE FIGUEIREDO  - ME","0000-00-00","","","CID GONÇALVES DE FIGUEIREDO - ME","CID GONÇALVES","01785554000104","46.364.467","1","2","0");
INSERT INTO cliente VALUES("628","fisica","CINTIA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("629","fisica","DENILSON - SP","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("630","juridica","","0000-00-00","","","PREFEITURA DE SÃO JOSÉ DOS CAMPOS","PREFEITURA DE SÃO JOSÉ DOS CAMPOS","46643466000106","ISENTO","1","1","0");
INSERT INTO cliente VALUES("631","juridica","","0000-00-00","","","REI DO ABADA COMERCIO DE ARTIGOS P/IMPRESSÃO EIRELI","REI DO ABADA","31977297000173","123.219.506.119","1","2","0");
INSERT INTO cliente VALUES("632","fisica","MAICON RODRIGO DE SOUZA","0000-00-00","31906236860","","","","","","1","1","0");
INSERT INTO cliente VALUES("633","juridica","NELSON BRITTES MARTINS","0000-00-00","","","NELSON BRITTES MARTINS","NELSON BRITTES","68447390000186","","1","2","0");
INSERT INTO cliente VALUES("634","juridica","DOUGLAS CORDEIRO EIRELI","0000-00-00","","","DOUGLAS CORDEIRO EIRELI","DOUGLAS CORDEIRO EIRELI","27176482000191","258254890","1","2","0");
INSERT INTO cliente VALUES("635","fisica","PEDRO RICARDO PICOLO GARCIA","0000-00-00","03191147918","","","","","","1","1","0");
INSERT INTO cliente VALUES("636","fisica","FRANK PARIS","0000-00-00","07748151911","","","","","","1","1","0");
INSERT INTO cliente VALUES("637","juridica","","0000-00-00","","","BR BRIM UNIFORMES PROFISSIONAIS E CONFECÇÕES LTDA","BR BRIM","31392705000125","11.234.330","1","2","0");
INSERT INTO cliente VALUES("638","fisica","TEREZA CRISTINA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("639","juridica","","0000-00-00","","","CARIMBOS DECCO LTDA - ME","CARIMBOS DECCO","05075020000145","336695386114","1","2","0");
INSERT INTO cliente VALUES("640","fisica","CLAUDIA  LOBATO DA COSTA","0000-00-00","78733928991","","","","","","1","2","0");
INSERT INTO cliente VALUES("641","juridica","PREFEITURA MUNICIPAL DE IRATI","0000-00-00","","","FUNDO MUNICIPAL DE ASSISTÊNCIA SOCIAL DE IRATI-PR","FUNDO MUNICIPAL IRATI","15553309000186","ISENTO","1","1","0");
INSERT INTO cliente VALUES("642","juridica","","0000-00-00","","","D G DOS SANTOS OLIVEIRA CONFECÇÕES","D G DOS SANTOS - LOJAS DAS CAMISETAS","13996693000166","562189802112","1","1","0");
INSERT INTO cliente VALUES("643","fisica","VITOR RODRIGUES DE SOUZA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("644","fisica","MICHAEL KENZO KARAKI","0000-00-00","03339162980","","","","","","1","1","0");
INSERT INTO cliente VALUES("645","juridica","","0000-00-00","","","INSTITUTO FEDERAL DO PARANÁ / CAMPUS CAPANEMA","INSTITUTO - CAMPUS CAPANEMA","10652179000115","ISENTO","1","1","0");
INSERT INTO cliente VALUES("646","fisica","MICHAEL","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("647","juridica","","0000-00-00","","","COOP. DE CREDITO POUP. E INVEST. UNIÃO PARANÁ /SÃO PAULO - SICREDI","SICREDI","79342069000153","","1","1","0");
INSERT INTO cliente VALUES("648","juridica","SANDRO ROBERTO","0000-00-00","","","SANDRO ROBERTO MOREIRA","SANDRO ROBERTO - SERITRANSFER","21951513000158","2680191291-3","1","2","0");
INSERT INTO cliente VALUES("649","juridica","ADRIANA CARLA","0000-00-00","","","ADRIANA CARLA DA SILVA LTDA","ADRIANA CARLA","04077998000183","131969790","1","1","0");
INSERT INTO cliente VALUES("650","fisica","CARLA GUIZELINI","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("651","juridica","","0000-00-00","","","PREFEITURA MUNICIPAL DE IBIPORÃ - PR","PREFEITURA IBIPORÃ","76244961000103","ISENTO","1","1","0");
INSERT INTO cliente VALUES("652","juridica","TEXPORTES","0000-00-00","","","TEXPORTS COM. E ESTAMPARIAS DE CAMISETAS LTDA - ME","TEXPORTS","59316240000142","116.327.557.113","1","1","0");
INSERT INTO cliente VALUES("653","fisica","ROSELI","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("654","juridica","KATIA","0000-00-00","","","KATIA GAGLIASSO","KATIA GAGLIASSO","14827906000199","216009760110","1","1","0");
INSERT INTO cliente VALUES("655","fisica","LUCIANE","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("656","fisica","LUCIANE","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("657","fisica","JOSE PEDRO SOUZA MARTINS","0000-00-00","31621979881","42691919-1","","","","","1","1","0");
INSERT INTO cliente VALUES("658","juridica","A C BECHARA REGO EPP","0000-00-00","","","A C BECHARA REGO EPP","A C BECHARA","05261892000106","15226610-0","1","2","0");
INSERT INTO cliente VALUES("659","fisica","JAMILE ELIAS","0000-00-00","02200135947","","","","","","1","1","0");
INSERT INTO cliente VALUES("660","fisica","EDSON FRANCISCO DA SILVA","0000-00-00","95256911872","","","","","","1","1","0");
INSERT INTO cliente VALUES("661","fisica","JANAINA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("662","fisica","TIMOTEO JUNIOR","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("663","fisica","ANTONIO VALDENETO GOMES DE OLIVERIA","0000-00-00","45528268320","","","","","","1","2","0");
INSERT INTO cliente VALUES("664","fisica","ANDREIA PIATTI","0000-00-00","87999188972","","","","","","1","0","0");
INSERT INTO cliente VALUES("665","juridica","","0000-00-00","","","RICARDO ANTONIO MORABITO ME","RICARDO - R SILK SOBRAL","27179764000304","0631455103","1","1","0");
INSERT INTO cliente VALUES("666","juridica","RICARDO - TR SUPRIMENTOS","0000-00-00","","","RICARDO ANTONIO MORABITO ME","RICARDO - TR SUPRIMENTOS","27179764000142","066455030","1","2","0");
INSERT INTO cliente VALUES("667","fisica","RODRIGO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("668","fisica","JOSÉ ALVES DOS SANTOS","0000-00-00","23947136900","","","","","","1","1","0");
INSERT INTO cliente VALUES("669","fisica","CARLOS - COLORADO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("670","juridica","M","0000-00-00","","","MEGA SUPRIMENTOS EIRELI","MEGA SUPRIMETOS","15023494000105","796.663.509.117","1","2","0");
INSERT INTO cliente VALUES("671","juridica","SILK CENTER DIGITAL SÃO CARLOS COM. DE MAT. P/PINTURA LTDA","0000-00-00","","","SILK CENTER DIGITAL SÃO CARLOS COM. DE MAT. P/PINTURA LTDA","SILK CENTER","38119322000127","637.531.158.117","1","2","0");
INSERT INTO cliente VALUES("672","juridica","CONSORCIO INTERMUNICIPAL DE SAÚDE","0000-00-00","","","CONSORCIO INTERMUNICIPAL DE SAÚDE","CONSORCIO INTERMUNICIPAL","00136858000188","ISENTO","1","1","0");
INSERT INTO cliente VALUES("673","fisica","JAIR ENOQUE MOREIRA","0000-00-00","19849971819","","","","","","1","0","0");
INSERT INTO cliente VALUES("674","fisica","PRISCILA - TELAS","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("675","fisica","ROSIMARA PERAR","0000-00-00","60203277953","","","","","","1","1","0");
INSERT INTO cliente VALUES("676","fisica","LAURA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("677","juridica","","0000-00-00","","","AUREA LUCIA CRISPIM","AUREA LUCIA","25989041000183","002.816.539.00-90","1","1","0");
INSERT INTO cliente VALUES("678","juridica","","0000-00-00","","","RAFAEL DE ARAUJO SILVA","RAFAEL DE ARAUJO SILVA","31953971000180","ISENTO","1","1","0");
INSERT INTO cliente VALUES("679","juridica","","0000-00-00","","","PREFEITURA MUNICIPAL DE FARTURA","PREFEITURA MUNICIPAL DE FARTURA","46223707000168","ISENTO","1","1","0");
INSERT INTO cliente VALUES("680","juridica","","0000-00-00","","","UNIVERSIDADE FEDERAL DA PARAIBA","UNIVERSIDADE FEDERAL DA PARAIBA","24098477000110","ISENTO","1","1","0");
INSERT INTO cliente VALUES("681","juridica","","0000-00-00","","","SAMUEL MANOEL DE LIMA","SAMUEL MANOEL","34206647000196","126.392.982.111","1","1","0");
INSERT INTO cliente VALUES("682","fisica","MÁRCIO - TELAS DE PINTURA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("683","fisica","VERONICE LOPE SILVA SANTOS","0000-00-00","91672902991","","","","","","1","1","0");
INSERT INTO cliente VALUES("684","fisica","FABIO RIGON","0000-00-00","88497402987","","","","","","1","1","0");
INSERT INTO cliente VALUES("685","fisica","JOANA AUGUSTA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("686","juridica","","0000-00-00","","","GCDO SOUZA GOBBO COM. DE  ARTIGOS P/COMUN. VISUAL LTDA","GCDO SOUZA - MANOLUMI","39501928000195","129.932.064.113","1","1","0");
INSERT INTO cliente VALUES("687","fisica","OLGA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("688","juridica","","0000-00-00","","","MARIA APARCIDA FARIA DA SILVA","MARIA APARECIDA - GRUPO SERINGAL","29724332000109","119.062.332/0001-09","1","1","0");
INSERT INTO cliente VALUES("689","fisica","FABIANA RICHARDE","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("690","juridica","","0000-00-00","","","AMELIA STEPHANIE BARRETO PEREIRA BOMBONIERE EIRELI","AMELIA STEPHANIE - BOMBONIERE","32183452000142","24789390-0","1","2","0");
INSERT INTO cliente VALUES("691","fisica","ROBERTO - FOTOS MANDAGUAÇU","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("692","juridica","","0000-00-00","","","JANDIRA BERGAMO DE SOUZA","JANDIRA BERGAMO","11011955000160","677.060.021.114","1","2","0");
INSERT INTO cliente VALUES("693","juridica","","0000-00-00","","","RAISLAN GOMES DUTRA","RAISLAN - RANIERI","39296699000114","20.555.235-8","1","2","0");
INSERT INTO cliente VALUES("694","fisica","REGINA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("695","juridica","","0000-00-00","","","SILVANA DOS SANTOS COSTA","SILVANA DOS SANTOS","17892536000161","369.069.378.114","1","2","0");
INSERT INTO cliente VALUES("696","juridica","NETO - OPEN COLOR","0000-00-00","","","ERICO TORMENA NETO","ERICO TORMENA NETO - OPEN COLOR","38120868000106","4181105219-6","1","1","0");
INSERT INTO cliente VALUES("697","fisica","BEATRIZ BEQUER","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("698","fisica","MARIANA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("699","fisica","FRANCISLAINE CAMPOS GARCIA","0000-00-00","82858640904","","","","","","1","1","0");
INSERT INTO cliente VALUES("700","fisica","EVELIN KARLA COELHO","0000-00-00","04313745971","","","","","","1","0","0");
INSERT INTO cliente VALUES("701","juridica","","0000-00-00","","","M H DOS ANJOS DA SILVA - CONFECÇÕES ME","M H DOS ANJOS","22723278000120","906.98475-09","1","2","0");
INSERT INTO cliente VALUES("702","fisica","NEUZA CARLOS DE MOURA","0000-00-00","36575860915","","","","","","1","1","0");
INSERT INTO cliente VALUES("703","fisica","NEUZA CARLOS DE MOURA - ADELON","0000-00-00","36575860915","","","","","","1","1","0");
INSERT INTO cliente VALUES("704","fisica","AMANDA PRATTI","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("705","juridica","ALEX RODIGUES ALVES","0000-00-00","","","ALEX RODRIGUES ALVES","ALEX RODRIGUES","36196995000155","003.657.432.00-89","1","1","0");
INSERT INTO cliente VALUES("706","fisica","ANELISE","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("707","fisica","SAULO ROBERTO DE SOUZA","0000-00-00","01004380917","","","","","","1","1","0");
INSERT INTO cliente VALUES("708","fisica","MATEUS","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("709","fisica","LECI","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("710","fisica","LEVI DE MATOS CABRAL","0000-00-00","82723389987","","","","","","1","1","0");
INSERT INTO cliente VALUES("711","fisica","CRISTINE GOEDERT FOLDA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("712","fisica","GLAUCIA CRISTINA PEREIRA DA SILVA","0000-00-00","05361299910","","","","","","1","1","0");
INSERT INTO cliente VALUES("713","juridica","","0000-00-00","","","STILLO SILK COMERCIO DE MAT. DE SERIGR. E BRINDES EIRELI - ME","STILLO SILK","24336723000124","131080269","1","1","0");
INSERT INTO cliente VALUES("714","juridica","","0000-00-00","","","INSTITUTO FED. DO PARANÁ / CAMPUS TELEMACO BORBA","INSTITTUTO FED. DO PARANÁ","10652179000204","ISENTO","1","1","0");
INSERT INTO cliente VALUES("715","juridica","","0000-00-00","","","FUNDO MUNICIPAL DE SAUDE DE TRES BARRAS","FUNDO MUNICIPAL DE SAUDE DE TRES BARRAS","11491075000139","ISENTO","1","1","0");
INSERT INTO cliente VALUES("716","juridica","INSTITUTO FED. DO TOCANTINS/CAMPUS ARAGUATINS","0000-00-00","","","INSTITUTO FED. DO TOCANTINS / CAMPUS ARAGUATINS","INST. FED. DO TOCANTINS","10742006000279","ISENTO","1","1","0");
INSERT INTO cliente VALUES("717","fisica","REGINA DE FATIMA REZENZE FASSIN","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("718","juridica","INSTITUTO FED. DO PARANÁ","0000-00-00","","","INSTITUTO FED. DO PARANÁ / CAMPUS UMUARAMA","INSTITUTO FED. DO PARANÁ / CAMPUS UMUARAMA","10652179000700","ISENTO","1","1","0");
INSERT INTO cliente VALUES("719","juridica","","0000-00-00","","","FUNDO MUNICIPAL DE ASSISTENCIA SOCIAL DE IRATI-PR","FUNDO MUNICIPAL DE ASSISTENCIA SOCIAL DE IRATI-PR","15553309000186","ISENTO","1","1","0");
INSERT INTO cliente VALUES("720","juridica","","0000-00-00","","","CRHISTIANE DE CASTRO SANTANA SILVA","CRHISTIANE DE CASTRO","28425020000123","142.657.483","1","2","0");
INSERT INTO cliente VALUES("721","juridica","","0000-00-00","","","INSTITUTO NACIONAL DE EDUCAÇÃO DE SURDOS - RJ","INSTITUTO NACIONAL DE EDUCAÇÃO DE SURDOS - RJ","00394445027301","ISENTO","1","1","0");
INSERT INTO cliente VALUES("722","juridica","","0000-00-00","","","CASA DO SILK COMERCIO DE MATERIAIS PARA SERIGRAFIA LTDA","CASA DO SILK - SILKSIGN","04600575000104","535.337.121.119","1","2","0");
INSERT INTO cliente VALUES("723","juridica","","0000-00-00","","","A A BELETATTI NETO ME","A A BELETATTI","05358492000105","04.155.322-5","1","2","0");
INSERT INTO cliente VALUES("724","juridica","","0000-00-00","","","P.C DE OLIVEIRA SOUZA","P.C DE OLIVEIRA SOUZA","32744866000284","657.413.736.117","1","2","0");
INSERT INTO cliente VALUES("725","fisica","ELSON HENRIQUE DA SILVA","0000-00-00","08252773966","","","","","","1","1","0");
INSERT INTO cliente VALUES("726","fisica","RODRIGO BERTANHA FRANCO","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("727","fisica","WESLEN MENEZES FONSECA","0000-00-00","05933393983","","","","","","1","0","0");
INSERT INTO cliente VALUES("728","fisica","PAULO SERGIO L DA SILVA","0000-00-00","92472028334","","","","","","1","1","0");
INSERT INTO cliente VALUES("729","juridica","DELTA SCREEN COM. DE MAT. P/PINTURA LTDA","0000-00-00","","","DELTA SCREEN COM. DE MAT. P/PINTURA LTDA","DELTA SCREEN","11714296000129","13.385.348-9","1","2","0");
INSERT INTO cliente VALUES("730","fisica","DEBORA KEMER","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("731","fisica","LUIS PAULO","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("732","fisica","THIAGO DELFIM DA SILVA","0000-00-00","06522413957","","","","","","1","1","0");
INSERT INTO cliente VALUES("733","juridica","","0000-00-00","","","INSTITUTO FED. DE EDUC. CIE. TEC. DO TOCANTINS","INSTITUTO FED. DE EDUC. CIE. TEC. DO TOCANTINS","10742006000198","ISENTO","1","1","0");
INSERT INTO cliente VALUES("734","juridica","","0000-00-00","","","PREFEITURA MUNICIPAL RONDONOPOLIS","PREFEITURA MUNICIPAL RONDONOPOLIS","03347101000121","ISENTO","1","0","0");
INSERT INTO cliente VALUES("735","juridica","RONNIE VAGNER DA SIL","0000-00-00","","","RONNIE VAGNER DA SILVA","RONNIE VAGNER","18694251000189","908.73770-99","1","1","0");
INSERT INTO cliente VALUES("736","fisica","EDSON ROBERTO BARBAN","0000-00-00","02940131805","","","","","","1","1","0");
INSERT INTO cliente VALUES("737","fisica","HILDA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("738","fisica","FRANCISLAINE","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("739","fisica","VANDA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("740","juridica","PARA UNIFORME EPI","0000-00-00","","","PARA EPI CONFECÇÕES FERRAMENTA E SOLDAS","PARA UNIFORME EPI","24198740000142","155152963","1","1","0");
INSERT INTO cliente VALUES("741","fisica","ROSELI SOARES ALVES SILVA","0000-00-00","08679897850","","","","","","1","0","0");
INSERT INTO cliente VALUES("742","juridica","","0000-00-00","","","ELIDIO FRANCISCO ROSA NETO","ELIDIO FRANCISCO - NETO SPORTS","35002804000104","","1","1","0");
INSERT INTO cliente VALUES("743","juridica","R O NICOLETE","0000-00-00","","","R O NICOLETE EIRELI","R O NICOLETE","37551739000100","908.51993-04","1","1","0");
INSERT INTO cliente VALUES("744","fisica","JAIR","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("745","juridica","","0000-00-00","","","PREFEITURA MUNICIPAL DE ITAGUAI","PREFEITURA MUNICIPAL DE ITAGUAI","29138302000102","ISENTO","1","1","0");
INSERT INTO cliente VALUES("746","juridica","","0000-00-00","","","CAMBURI PRINT E TEXTURIZAÇÃO LTDA","CAMBURI PRINT - VINICIOS\'","36504941000100","083.641.10-6","1","1","0");
INSERT INTO cliente VALUES("747","juridica","","0000-00-00","","","CAMBURI PRINT E TEXTURIZAÇÃO LTDA","CAMBURI PRINT - VINICIOS\'","36504941000100","083.641.10-6","1","1","0");
INSERT INTO cliente VALUES("748","fisica","MÁRCIA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("749","juridica","","0000-00-00","","","PREFEITURA DO MUNICIPIO DE LONDRINA - PR","PREFEITURA DO MUNICIPIO DE LONDRINA","75771477000170","ISENTO","1","1","0");
INSERT INTO cliente VALUES("750","fisica","LUAN","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("751","juridica","","0000-00-00","","","PREFEITURA MUNICIPAL DE QUADRO BARRAS","PREFEITURA MUNICIPAL DE QUATRO BARRAS","76105568000139","ISENTO","1","1","0");
INSERT INTO cliente VALUES("752","juridica","PREFEITURA MUNICIPAL DE QUATRO BARRAS","0000-00-00","","","PREFEITURA MUNICIPAL DE QUATRO BARRAS","PREFEITURA MUNICIPAL DE QUATRO BARRAS","76105568000139","ISENTO","1","1","0");
INSERT INTO cliente VALUES("753","fisica","RITA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("754","fisica","JAQUELINE","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("755","fisica","ALEX CANTAGALLI","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("756","juridica","","0000-00-00","","","INSTITUIÇÃO ADVENT. SUL BRASILEIRA DE EDUC. ASS SOCIAL","INSTITUIÇÃO ADVENT. SUL BRASILEIRA","76726884000390","ISENTO","1","1","0");
INSERT INTO cliente VALUES("757","fisica","GISELDA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("758","fisica","CARLOS DELAZARI","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("759","fisica","ANICIA ALEXANDRE JUSTI","0000-00-00","03221141955","","","","","","1","1","0");
INSERT INTO cliente VALUES("760","fisica","CRISTIAN","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("761","fisica","LUIZ MIGUEL MONTANARI DA SILVA","0000-00-00","10984544992","","","","","","1","1","0");
INSERT INTO cliente VALUES("762","juridica","","0000-00-00","","","VASQUES E VASQUES CONFECÇÕES LTDA","VASQUES E VASQUES","17502820000184","906.19497-01","1","1","0");
INSERT INTO cliente VALUES("763","juridica","","0000-00-00","","","PREVIDENCIA JEANS LTDA ME","PREVIDENCIA JEANS","09342265000738","905.47323-90","1","1","0");
INSERT INTO cliente VALUES("764","fisica","THIAGO - TELAS","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("765","juridica","","0000-00-00","","","BRUNO HENRIQUE MARCIANO DE MORAES","BRUNO HENRIQUE","21622486000170","418.029446-83","1","0","0");
INSERT INTO cliente VALUES("766","fisica","CLELMA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("767","juridica","SOCIEDADE EDUCACIONAL PRIMEIRO PASSO","0000-00-00","","","SOCIEDADE EDUCACIONAL PRIMEIRO PASSO SC LTDA - ME","SOCIEDADE EDUCACIONAL PRIMEIRO PASSO","01026941000167","ISENTO","1","1","0");
INSERT INTO cliente VALUES("768","juridica","","0000-00-00","","","TICKETMONSTER ECOMMERCE LTDA","TICKETMONSTER","34168389000109","908.88804-95","1","1","0");
INSERT INTO cliente VALUES("769","juridica","","0000-00-00","","","FERREIRA & OLIVEIRA VELOZ BEBIDAS LTDA","FERREIRA & OLIVEIRA","40525293000145","24386229-6","1","1","0");
INSERT INTO cliente VALUES("770","juridica","FABIO ANDRÉ DA SILVA","0000-00-00","","","FABIO ANDRÉ DA SILVA","FABIO ANDRÉ","13506744000124","","1","2","0");
INSERT INTO cliente VALUES("771","fisica","JULIA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("772","juridica","","0000-00-00","","","MUNICIPIO DE MARIÓPOLIS","MUNICIPIO DE MARIOPOLIS","76995323000124","ISENTO","1","1","0");
INSERT INTO cliente VALUES("773","juridica","M.H.A DOS ANJOS DA SILVA - CNFECÇÕES","0000-00-00","","","M.H.A DOS ANJOS DA SILVA - CONFECÇÕES","M.H.A DOS ANJOS","22723278000120","906.9847509","1","2","0");
INSERT INTO cliente VALUES("774","fisica","ROSIMARI","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("775","fisica","GABRIELA - MGA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("776","fisica","CAMILLY","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("777","fisica","JULIA FRÓES DA MATTA","0000-00-00","","","JULIA FRÓRES DA MOTTA","","","","1","1","0");
INSERT INTO cliente VALUES("778","juridica","DLT LOGISTICA E TRANSPORTES","0000-00-00","","","DLT LOGISTICA E TRANSPORTES LTDA","DLT LOGISTICA","05813363000160","254621619","1","0","0");
INSERT INTO cliente VALUES("779","fisica","CLAUDINEI JOSÉ DA SILVA","0000-00-00","11633616827","","","","","","1","1","0");
INSERT INTO cliente VALUES("780","juridica","","0000-00-00","","","FUNDO MUNICIPAL DE ASSISTENCIA SOCIAL","FUNDO MUNICIPAL DE ASSISTENCIA SOCIAL","14201609000133","ISENTO","1","1","0");
INSERT INTO cliente VALUES("781","juridica","ESTAMPARIA LARANJEIRAS","0000-00-00","","","LUCIANA PEREIRA CAMPIN BASSERT","LUCIANA - ESTAMPARIA LARANJENSE","28514899000180","","1","1","0");
INSERT INTO cliente VALUES("782","fisica","DANIELE PENHA ANTONIASSI","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("783","juridica","","0000-00-00","","","CLINICA ESTANCIA MARINGA CENTRO DE REABILITAÇÃO PSICOSSOCIAL LTDA","CLINICA ESTANCIA MARINGA","34263094000103","ISENTO","1","1","0");
INSERT INTO cliente VALUES("784","fisica","PAULO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("785","fisica","WILIAN","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("786","juridica","","0000-00-00","","","SOFT FARDAMENTOS LTDA","SOFT FARDAMENTOS","12495225000145","080165000","1","1","0");
INSERT INTO cliente VALUES("787","fisica","JOSÉ LUIZ DA SILVA RODIRGUES - DELUCA ESTAMPARIA","0000-00-00","92074103700","","","","","","1","1","0");
INSERT INTO cliente VALUES("788","juridica","","0000-00-00","","","FUNDO MUNICIPAL DE ASSISTENCIA SOCIAL DE CAMPO ALEGRE","FUNDO MUNICIPAL DE ASSIST. SOCIAL DE CAMPO ALEGRE","15038019000102","ISENTO","1","1","0");
INSERT INTO cliente VALUES("789","fisica","FRANCIELE","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("790","fisica","MÁRCIO - FOTOS","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("791","juridica","","0000-00-00","","","J.C.A CONFECÇÕES EIRELI","J.C.A CONFECÇÕES","29510156000102","907.70991-47","1","1","0");
INSERT INTO cliente VALUES("792","fisica","KELMA","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("793","juridica","","0000-00-00","","","VAN GOGH INDUSTRIA E COMERCIO LTDA","VAN GOGH","25076100000122","102522633-5","1","0","0");
INSERT INTO cliente VALUES("794","juridica","REI DO ABADA","0000-00-00","","","","","31977297000173","123.219.506.119","1","1","0");
INSERT INTO cliente VALUES("795","juridica","","0000-00-00","","","INSTITUTO FED. DO TOCANTINS / CAMPUS COLINAS DO TOCANTIS","INST. FED. DO TOCANTINS / CAMPUS COLINAS DO TOCANTIS","10742006000945","294782036","1","1","0");
INSERT INTO cliente VALUES("796","fisica","ALYNE ADAMI","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("797","juridica","","0000-00-00","","","PREFEITURA MUNICIPAL DE PIRATININGA","PREFEITURA MUNICIPAL DE PIRATININGA","46137451000176","","1","1","0");
INSERT INTO cliente VALUES("798","juridica","","0000-00-00","","","BORDADOS BRESSER LTDA EPP","BORDADOS BRESSER LTDA EPP","27532408000160","141.959.075.111","1","1","0");
INSERT INTO cliente VALUES("799","juridica","","0000-00-00","","","HARDD INDUSTRIA E COM. DE CONFECÇÕES LTDA","HARDD","41400924000162","908.89566-53","1","1","0");
INSERT INTO cliente VALUES("800","juridica","","0000-00-00","","","MICHELE MARIA NARDI","MICHELE MARIA NARDI","15988544000180","714.045.550.113","1","1","0");
INSERT INTO cliente VALUES("801","juridica","","0000-00-00","","","FUNDO MUNICIPAL DE SAÚDE FMS","FUNDO MUNICIPAL DE SAUDE FMS","37623352000103","ISENTO","1","1","0");
INSERT INTO cliente VALUES("802","juridica","","0000-00-00","","","VANDINES","VANDINES","","","1","1","0");
INSERT INTO cliente VALUES("803","juridica","TEXTIL BRASIL LTDA","0000-00-00","","","TEXTIL BRAS LTDA","TEXTIL BRAS LTDA","41129553000126","130.772.73.113","1","1","0");
INSERT INTO cliente VALUES("804","juridica","GERALDO LUIS -","0000-00-00","","","GERALDO LUIZ MARTINS","GERALDO LUIS - STAMP COR","14186438000110","082.827.62-1","1","1","0");
INSERT INTO cliente VALUES("805","juridica","","0000-00-00","","","ANGELICA MARTINS GARCIA FERREIRA CONFECÇÕES - ME","ANGELICA MARTINS","21285039000172","145.985.860-115","1","1","0");
INSERT INTO cliente VALUES("806","juridica","","0000-00-00","","","TEXTIL GROUP LTDA","TEXTIL GROUP LTDA","36716542000102","","1","1","0");
INSERT INTO cliente VALUES("807","fisica","DENIS LEANDRO DE FREITAS","0000-00-00","85074888972","","","","","","1","1","0");
INSERT INTO cliente VALUES("808","juridica","","0000-00-00","","","FUNDO MUNICIPAL DE SAUDE DE ITAGUAI","FUNDO MUNICIPAL DE SAUDE DE ITAGUAI","11855524000180","ISENTO","1","1","0");
INSERT INTO cliente VALUES("809","juridica","","0000-00-00","","","FUNDO MUNICIPAL DE SAUDE - PARANAVAI","FUNDO MUNICIPAL DE SAUDE - PARANAVAI","08518587000137","ISENTO","1","1","0");
INSERT INTO cliente VALUES("810","juridica","","0000-00-00","","","LUIS PRINCIVAL","LUIS PRINCIVAL","82241753000153","809.00618-29","1","2","0");
INSERT INTO cliente VALUES("811","juridica","R.H COMERCIO DE TECIDOS FERRAGENS LTDA","0000-00-00","","","R.H COMERCIO DE TECIDOS, FERRAGENS LTDA","R.H COMERCIO","33897914000156","158.776.312","1","2","0");
INSERT INTO cliente VALUES("812","juridica","","0000-00-00","","","BETO BOLSAS ARACAJU LTDA","BETO BOLSAS ARACAJU","34073865000108","27.165.451-1","1","2","0");
INSERT INTO cliente VALUES("813","juridica","","0000-00-00","","","CLAUDIO CARDOSO","CLAUDIO CARDOSO","29384877000105","06743166-6","1","2","0");
INSERT INTO cliente VALUES("814","fisica","RAMIRES CRUZ DE SOUZA - ICON","0000-00-00","03689144965","","","","","","1","1","0");
INSERT INTO cliente VALUES("815","fisica","MARIA DO CARMO PEDROZO DO NASCIMENTO PORFIRIO - ATELIE MARIA DO CARMO","0000-00-00","68921136991","","MARIA DO CARMO PEDROZO DO NASCIMENTO PORFIRIO","MARIA DO CARMO - ATELIE MARIA DO CARMO","","","1","1","0");
INSERT INTO cliente VALUES("816","juridica","","0000-00-00","","","CARUARU COMERCIO DE PLASTICOS LTDA","CARUARU COMERCIO","42692694000115","097619698","1","0","0");
INSERT INTO cliente VALUES("817","juridica","","0000-00-00","","","APAE DE ASTORGA","APAE DE ASTORGA","75349837000140","ISENTO","1","1","0");
INSERT INTO cliente VALUES("818","juridica","","0000-00-00","","","VIA MAIS MOBILIDADE E SINALIZAÇÃO EIRELI","VIA MAIS","02390731000116","908.55245-82","1","1","0");
INSERT INTO cliente VALUES("819","fisica","ANNA LARA FLAUSINO","0000-00-00","08648767938","","","","","","1","1","0");
INSERT INTO cliente VALUES("820","juridica","","0000-00-00","","","PREFEITURA DO MUNICIPIO DE ITAPOLIS","PREFEITURA DO MUNICIPIO DE ITAPOLIS","49979255000137","ISENTO","1","1","0");
INSERT INTO cliente VALUES("821","juridica","","0000-00-00","","","FUNDO MUNICIPAL DE ASSISTENCIA SOCIAL DE CAMPO ALEGRE","FUNDO MUNICIPAL DE ASSISTENCIA SOCIAL DE CAMPO ALEGRE","15038019000102","ISENTO","1","1","0");
INSERT INTO cliente VALUES("822","juridica","","0000-00-00","","","ART TELAS DESIGN E SISTEMAS DE IMPRESSÃO LTDA","ART TELAS","67469395000228","254.008.062","1","2","0");
INSERT INTO cliente VALUES("823","juridica","","0000-00-00","","","PREFEITURA MUNICIPAL DE SANTANA DA BOA VISTA","PREFEITURA MUNICIPAL DE SANTANA DA BOA VISTA","88141460000180","ISENTO","1","1","0");
INSERT INTO cliente VALUES("824","juridica","","0000-00-00","","","MUNICIPIO DE ARAUCARIA - PREFEITURA","MUNICIPIO DE ARAUCARIA - PREFEITURA","76105535000199","ISENTO","1","1","0");
INSERT INTO cliente VALUES("825","fisica","ROSIANE","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("826","fisica","VERÔNICA LOPES DA SILVA SANTOS","0000-00-00","91672902991","","","","","","1","1","0");
INSERT INTO cliente VALUES("827","fisica","NEIDE","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("828","juridica","","0000-00-00","","","F DE A A DE LIMA","F DE A A DE LIMA - LIMA TEXTIL","08305573000135","12.230.313-0","1","2","0");
INSERT INTO cliente VALUES("829","juridica","","0000-00-00","","","PREFEITURA MUNICIPAL DE MARTINOPOLIS","PREFEITURA MUNICIPAL DE MARTINOPOLIS","44855443000130","440068996110","1","1","0");
INSERT INTO cliente VALUES("830","juridica","","0000-00-00","","","MARCIA ANDREIA MOZOLI","MARCIA ANDREIA MOZOLI","36329504000105","","1","1","0");
INSERT INTO cliente VALUES("831","juridica","SM DE BRITO - ME","0000-00-00","","","SM DE BRITO - ME","SM DE BRITO - ME","28676399000144","247406422","1","2","0");
INSERT INTO cliente VALUES("832","juridica","","0000-00-00","","","SIG IMPRESSÕES EIRELI","SIG IMPRESSÕES","13530301000179","19740784","1","2","0");
INSERT INTO cliente VALUES("833","fisica","MARIA TEREZA CUNHA GUIMARÃES","0000-00-00","61739995600","","","","","","1","0","0");
INSERT INTO cliente VALUES("834","juridica","","0000-00-00","","","DS SCREEN SERIGRAFIA LTDA","DS SCREEN","00843791000111","114.415.069.118","1","2","0");
INSERT INTO cliente VALUES("835","fisica","SHIRLEY","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("836","juridica","","0000-00-00","","","COLEGIO SANTO INACIO","COLEGIO SANTO INACIO","","","1","0","0");
INSERT INTO cliente VALUES("837","juridica","","0000-00-00","","","SERIGRAFIA GAUCHA LTDA","SERIGRAFIA GAUCHA LTDA","91320028000161","0960920234","1","2","0");
INSERT INTO cliente VALUES("838","juridica","FUNDO MUNICIPAL DE EDUCAÇÃO DE VOLTA REDONDA","0000-00-00","","","FUNDO MUNICIPAL DE EDUCAÇÃO DE VOLTA REDONDA","FUNDO MUNIC. DE VOLTA REDONDA","30664911000184","","1","1","0");
INSERT INTO cliente VALUES("839","fisica","PEDRO BIANCO","0000-00-00","31607080800","","","","","","1","0","0");
INSERT INTO cliente VALUES("840","fisica","DORA ROSA DA SILVA","0000-00-00","81067062904","","","","","","1","1","0");
INSERT INTO cliente VALUES("841","fisica","NICOLAS","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("842","juridica","","0000-00-00","","","HERNANDES & CIA LTDA","HERNANDES & CIA","20798806000184","9067156355","1","1","0");
INSERT INTO cliente VALUES("843","juridica","","0000-00-00","","","LUCAS SAMPAIO FARIAS","LUCAS SAMPAIO - SUPERARTEL","26499057000170","065494911","1","1","0");
INSERT INTO cliente VALUES("844","fisica","RICARDO ZNACHETTI","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("845","juridica","","0000-00-00","","","PREFEITURA DE SÃO JOSÉ DOS CAMPOS","PREFEITURA DE SÃO JOSÉ DOS CAMPOS","46643466000106","ISENTO","1","1","0");
INSERT INTO cliente VALUES("846","juridica","","0000-00-00","","","FUNDO MUNICIPAL DE SAÚDE DE NOVA ESPERANÇA","FUNDO MUNICIPAL DE SAUDE NOVA ESPERENÇA","08570778000148","ISENTO","1","1","0");
INSERT INTO cliente VALUES("847","fisica","MARCELA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("848","fisica","LUCIANO REIS DOS SANTOS","0000-00-00","02077692901","","","","","","1","1","0");
INSERT INTO cliente VALUES("849","juridica","","0000-00-00","","","SECRETARIA DE ESTADO DE SEGURANÇA PUBLICA DO DISTRITO FEDERAL","SECRETARIA DE ESTADO DE SEGURANÇA PUBLICA DO DISTRITO FEDERAL","00394718000100","07.329.511.001-09","1","1","0");
INSERT INTO cliente VALUES("850","juridica","","0000-00-00","","","A4 TECIDOS - DISTRIBUIDOR TRICOLINES E MALHAS LTDA","A4 TECIDOS","40587175000161","35235783016","1","2","0");
INSERT INTO cliente VALUES("851","juridica","","0000-00-00","","","VITT JAE CONFECÇÕES E PRESENTES LTDA","VITT JAE - JAMILE","31087813000194","9078795260","1","0","0");
INSERT INTO cliente VALUES("852","fisica","MARIA ISABEL PEDROSA CUSTODIO","0000-00-00","37448454862","","","","","","1","1","0");
INSERT INTO cliente VALUES("853","fisica","MARIA ISABEL PEDROSA CUSTODIO","0000-00-00","37448454862","","","","","","1","1","0");
INSERT INTO cliente VALUES("854","juridica","","0000-00-00","","","PREFEITURA MUNICIPAL DE COLORADO","PREFEITURA MUNICIPAL DE COLORADO","76970326000103","ISENTO","1","1","0");
INSERT INTO cliente VALUES("855","fisica","MARCOS - TELAS PINTURA","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("856","juridica","","0000-00-00","","","PREFEITURA MUNICIPAL DE UBERABA","PREFEITURA MUNICIPAL DE UBERABA","18428839000190","ISENTO","1","1","0");
INSERT INTO cliente VALUES("857","fisica","ANTONIO MARCIO GONÇALVES PESSOA","0000-00-00","39043142115","","","","","","1","1","0");
INSERT INTO cliente VALUES("858","juridica","","0000-00-00","","","NOELSON DIAS DA SILVA SERIGRAFIA","NOELSON DIAS","08627943000150","149.577.701.115","1","2","0");
INSERT INTO cliente VALUES("859","juridica","SERISUL COMERCIO DE TINTAS LTDA","0000-00-00","","","SERISUL COM. DE TINTAS LTDA","SERISUL COM. DE TINTAS","43582085000176","07.018555-7","1","0","0");
INSERT INTO cliente VALUES("860","juridica","","0000-00-00","","","NICELMA ANDRESSA GONÇALVES - ATELIE DE PÍNTURA E BORDADOS","NICELMA ANDRESSA","16655895000132","","1","1","0");
INSERT INTO cliente VALUES("861","juridica","","0000-00-00","","","MICHELE MARIA NARDI - MIXPITS","MICHELE MARIA - MIXPITS","15988544000180","71404550113","1","2","0");
INSERT INTO cliente VALUES("862","fisica","MARCELA PEREIRA XAVIER","0000-00-00","04562672986","","","","","","1","1","0");
INSERT INTO cliente VALUES("863","fisica","ADRIANO LIMA","0000-00-00","88963683249","","","","","","1","1","0");
INSERT INTO cliente VALUES("864","juridica","","0000-00-00","","","FUNDO MUNICIPAL DE ASSISTENCIA SOCIAL - FMAS","FUNDO MUNCIPAL DE ASSISTENCIA SOCIAL - FMAS","14804921000111","ISENTO","1","1","0");
INSERT INTO cliente VALUES("865","juridica","","0000-00-00","","","INSTITUTO FEDERAL DO PARANÁ / CAMPUS UNIÃO DA VITORIA","INST. FEDERAL DO PARANÁ / CAMPUS UNICÃO DA VITORIA","10652179002088","ISENTO","1","1","0");
INSERT INTO cliente VALUES("866","juridica","LUCIANA ZANIN BAGGIO","0000-00-00","","","LUCIANA ZANIN BAGGIO","LUCIANA ZANIN BAGGIO","41794809000110","MEI","1","1","0");
INSERT INTO cliente VALUES("867","fisica","MAURICIO RICCARDI - MATTRIX","0000-00-00","15364081826","","","","","","1","2","0");
INSERT INTO cliente VALUES("868","fisica","WAGNER LUIZ TRETO","0000-00-00","47515988991","","","","","","1","1","0");
INSERT INTO cliente VALUES("869","juridica","","0000-00-00","","","PREFEITURA MUNICIPAL DE MOGI MIRIM","PREFEITURA MUNICIPAL DE MOGI MIRIM","45332095000189","","1","1","0");
INSERT INTO cliente VALUES("870","fisica","JOÃO PAULO SILVERIO","0000-00-00","07035919910","","","","","","1","1","0");
INSERT INTO cliente VALUES("871","juridica","","0000-00-00","","","TRINDADE SCREEN COMERCIO E SERVIÇOS LTDA","TRINDADE SCREEN - MG","09489701000100","10674410050","1","2","0");
INSERT INTO cliente VALUES("872","fisica","GEORGE OLIVEIRA","0000-00-00","91388767104","","GEORGE OLIVERIA","GEORGE OLIVEIRA","","","1","1","0");
INSERT INTO cliente VALUES("873","fisica","CARES","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("874","fisica","MAFER","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("875","fisica","MAFER","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("876","juridica","","0000-00-00","","","ALLYSSON GABRIEL SINFUENTE - MARCOS ALVES","ALLYSSON GABRIEL - MARCOS ALVES","44455554000159","","1","1","0");
INSERT INTO cliente VALUES("877","fisica","LUCILENE CRISTINA RIBEIRO","0000-00-00","25842945835","","","","","","1","0","0");
INSERT INTO cliente VALUES("878","fisica","DANIEL MENDES","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("879","juridica","MUNICIPIO DE CONTENDA","0000-00-00","","","PREFEITURA MUNICIPAL DE CONTENDA","MUNICIPIO DE CONTENDA","76105519000104","ISENTO","1","1","0");
INSERT INTO cliente VALUES("880","fisica","MICHAEL APRARECIDO DA SILVA","0000-00-00","03487344920","","","","","","1","0","0");
INSERT INTO cliente VALUES("881","fisica","AILTON DE OLIVEIRA","0000-00-00","05144294960","","","","","","1","0","0");
INSERT INTO cliente VALUES("882","fisica","KELDER SOLOMÃO SOUZA DA SILVA","0000-00-00","08816251913","","","","","","1","1","0");
INSERT INTO cliente VALUES("883","juridica","","0000-00-00","","","INSTITUTO FEDERAL PARANÁ/CAMPUS PINHAIS","INST. FED. PARANÁ/CAMPUS PINHAIS","10652179001863","ISENTO","1","1","0");
INSERT INTO cliente VALUES("884","fisica","JHENIFER PRENZLER MACHADO","0000-00-00","10849798965","12801027-0","","","","","1","0","0");
INSERT INTO cliente VALUES("885","fisica","JHENIFER PRENZLER MACHADO","0000-00-00","10849798965","128/01027-0","","","","","1","0","0");
INSERT INTO cliente VALUES("886","juridica","","0000-00-00","","","MANJS INDUSTRIA DE PLASTICO E OUTROS DERIV. LTDA","MANJS INDUSTRIA DE PLASTICO","10795199000145","082761394","1","2","0");
INSERT INTO cliente VALUES("887","juridica","BRADESCO AUTO RE","0000-00-00","92682038000","","BRADESCO AUTO RE","BRADESCO AUTO RE","92682038000100","","1","0","0");
INSERT INTO cliente VALUES("888","juridica","","0000-00-00","","","TECPUR IND. E COM. DE POLIURETANO LTDA","TECPUR","61179305000105","","1","0","0");
INSERT INTO cliente VALUES("889","fisica","ROBINHO","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("890","juridica","","0000-00-00","","","BETO BOLSAS BAIXA DOS SAPATEIROS LTDA","BETO BOLSAS - SALVADOR","43666198000150","185612232","1","2","0");
INSERT INTO cliente VALUES("891","juridica","","0000-00-00","","","GRAFICA E EMBALAGEM SANTO ANTONIO LTDA","GRAFICA E EMBALAGEM SANTO ANTONIO - SO CAIXAS","37601698000100","0028777800-7","1","1","0");
INSERT INTO cliente VALUES("892","juridica","","0000-00-00","","","MKTTRIX SCREEN COMERCIAL LTDA","MKTTRIX SCREEN - MAURICIO","05169128000105","116419442119","1","1","0");
INSERT INTO cliente VALUES("893","juridica","","0000-00-00","","","SILKSIM COMERCIO DE TINTAS E EMBALAGNES SERIGRAFICOS LTDA","SILKSIM COMERCIO","44297566000100","070354138","1","2","0");
INSERT INTO cliente VALUES("894","juridica","PREFEITURA MUNICIPAL DE NOVA ESPERANÇA","0000-00-00","","","PREFEITURA MUNICIPAL DE NOVA ESPERANÇA","PREFEITURA MUNICIPAL DE NOVA ESPERANÇA","75730994000109","ISENTO","1","1","0");
INSERT INTO cliente VALUES("895","juridica","","0000-00-00","","","M. R. BASTOS DO NASCIMENTO","M. R. BASTOS","04032021000140","121777430","1","2","0");
INSERT INTO cliente VALUES("896","fisica","LUCIANA CARNIATTO DE OLIVEIRA VIANA","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("897","fisica","KSENIA MATSIUTA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("898","fisica","SUELI INAGAKI","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("899","fisica","WESLEI BINATTI","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("900","fisica","CAMILA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("901","fisica","FRANCIELLIPERASSOLI FREITAS PAULA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("902","fisica","PRISCILA THON FERREIRA SANTANA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("903","juridica","P","0000-00-00","","","PREFEITURA MUNICIPAL DE PARANAVAÍ","PREFEITURA MUNICIPAL DE PARANAVAÍ","76977768000181","","1","1","0");
INSERT INTO cliente VALUES("904","juridica","P","0000-00-00","","","PREFEITURA MUNICIPAL DE PARANAVAÍ","PREFEITURA MUNICIPAL DE PARANAVAÍ","76977768000181","","1","1","0");
INSERT INTO cliente VALUES("905","fisica","CARLOS YOSHIHIRO SAKIYAMA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("906","fisica","ISABELA MARTINS - ARQUITETURA PAULA MARTINS","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("907","juridica","INST. FED. DO PARANÁ /","0000-00-00","","","INST. FED. DO PARANÁ / CAMPUS PARANAGUÁ","INST. FED. DO PARANÁ / CAMPUS PARANAGUA","10652179000549","","1","1","0");
INSERT INTO cliente VALUES("908","fisica","DAIANE DE OLIVEIRA FERREIA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("909","fisica","EDNEIA ELIANA AZAROTI","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("910","fisica","CLAUDIA PONTES VICENTE","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("911","fisica","FABIANE APARECIDA GONÇALVES","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("912","fisica","CAROLINA BERNABÉ ZAGO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("913","fisica","CAROLINA BERNABÉ ZAGO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("914","fisica","MARINA ANDRADE BATISTA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("915","juridica","CELI","0000-00-00","","","CELI APARECIDA PENTEADO CARVALHO","CELI APARECIDA PENTEANDO","14272619000160","","1","1","0");
INSERT INTO cliente VALUES("916","fisica","CAROLINA DE OLIVEIRA TAKEDA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("917","fisica","MATHEUS LEITE  ROLIM","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("918","juridica","","0000-00-00","","","FUNDO MUNICIPAL DE SAÚDE DO MUNICIPIO DE TERESÓPOLIS","FUNDO MUNICIPAL DE SAÚDE DO MUNICIPIO DE TERESÓPOLIS","11274201000101","","1","1","0");
INSERT INTO cliente VALUES("919","fisica","TATIANE RODRIGUES F. P. PEDROSO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("920","fisica","GISLAINE DE SOUZA SARRI","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("921","fisica","JAQUELINE BECCARI MELHEIROS NASCIMENTO","0000-00-00","31005141819","","","","","","1","1","0");
INSERT INTO cliente VALUES("922","fisica","CEZAR ALGUSTO DE SOUZA","0000-00-00","08645292440","","","","","","1","1","0");
INSERT INTO cliente VALUES("923","juridica","FLAVIA ARAUJO DE ALMEIDA - ME","0000-00-00","","","FLAVIANA  ARAUJO DE ALMEIDA - ME","FLAVIANA  ARAUJO DE ALMEIDA - ME","26612295000140","162840179","1","2","0");
INSERT INTO cliente VALUES("924","fisica","MARIA FERNANDA PAULINO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("925","fisica","RAFAELLE LUCIANE RIBEIRO FERREIRA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("926","fisica","EDUARDO BATISTA DA VEIGA NETO","0000-00-00","","","EDUARDO BATISTA DA VEIGA NETO","","","","1","1","0");
INSERT INTO cliente VALUES("927","fisica","TIAGO LAGO COSTA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("928","juridica","","0000-00-00","","","ASSOCIAÇÃO NOVAS POSSIBILIDADE A.G (ANPAG)","ASSOCIAÇÃO (ANPAG)","43713790000165","ISENTO","1","1","0");
INSERT INTO cliente VALUES("929","fisica","BETTY CATUYAMA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("930","fisica","MARIANA CARNIATTO DE OLIVEIRA MARQUI","0000-00-00","05819426983","","","","","","1","1","0");
INSERT INTO cliente VALUES("931","fisica","ZENILDA ALVES ZANATTA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("932","fisica","RAQUEL CRISTINA DA ROCHA RUBIO NOEL","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("933","fisica","BRUNA PEDROSO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("934","fisica","ROSE OLIVEIRA","0000-00-00","","","","","","","1","0","0");
INSERT INTO cliente VALUES("935","fisica","THAYENE CREPALDI","0000-00-00","03537207980","","","","","","1","1","0");
INSERT INTO cliente VALUES("936","juridica","","0000-00-00","","","MUNICIPIO DE AGUAS FRIAS","MUNICIPIO DE AGUAS FRIAS","95990180000102","","1","1","0");
INSERT INTO cliente VALUES("937","juridica","","0000-00-00","","","THAISE YUMI MATSUDA LIMA","THAISE YUMI MATSUDA  LIMA","","","1","1","0");
INSERT INTO cliente VALUES("938","fisica","CAROLINA ALBINO MIYABAYASHI","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("939","fisica","KATIA ALMEIDA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("940","fisica","EGIANE JOSEFA ARROYO","0000-00-00","90370708920","","","","","","1","1","0");
INSERT INTO cliente VALUES("941","fisica","JULIANA CAMPANERUTTI CALEGARI","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("942","juridica","CLAUCIA MENDES  DO RIO - ME","0000-00-00","","","GLAUCIA MENDES DO RIO - ME","GLAUCIA MENDES DO RIO","34130600000196","126.358.854.119","1","2","0");
INSERT INTO cliente VALUES("943","juridica","","0000-00-00","","","MUNICIPIO DE TEUTONIA","MUNICIPIO DE TEUTONIA","88661400000199","ISENTO","1","1","0");
INSERT INTO cliente VALUES("944","fisica","ZULEIDE DA CUNHA RAMOS","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("945","juridica","","0000-00-00","","","POLINJET IND. E COMERCIO DE PROD. PLASTICOS INJETADO","POLINJET IND. E COMERCIO","37577602000116","908.52259-17","1","1","0");
INSERT INTO cliente VALUES("946","juridica","","0000-00-00","","","ELIVIL MOUREIRA XAVIER","ELIVIL MOUREIRA","43802920000136","","1","1","0");
INSERT INTO cliente VALUES("947","juridica","","0000-00-00","","","MUNICIPIO DE DOIS VIZINHOS","MUNICIPIO DE DOIS VIZINHOS","76205640000108","ISENTO","1","1","0");
INSERT INTO cliente VALUES("948","fisica","JOSE EDUARDO CROCETA BATSITELA","0000-00-00","04452826903","","","","","","1","1","0");
INSERT INTO cliente VALUES("949","fisica","FABIANE AP. GONÇALVES","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("950","fisica","RENATA CRSTINA MARQUES BOLONHEIS RAMOS","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("951","fisica","FABIANA DE SOUZA LINARES","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("952","juridica","PREFEITURA MUNICIPAL DE COLATINA","0000-00-00","","","PREFEITURA MUNICIPAL DE COLATINA","PREFEITURA MUNICIPAL DE COLATINA","27165729000174","ISENTO","1","1","0");
INSERT INTO cliente VALUES("953","fisica","VANDERLI","0000-00-00","75685620934","","","","","","1","1","0");
INSERT INTO cliente VALUES("954","fisica","LIVIAN FURUTA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("955","fisica","CEZAR AGUSTO RIBEIRO","0000-00-00","08536142960","","","","","","1","1","0");
INSERT INTO cliente VALUES("956","fisica","GEYSA REGILIO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("957","juridica","","0000-00-00","","","PREFEITURA MUNICIPAL DE CAMPINAS","PREFEITURA MUNICIPAL DE CAMPINAS","51885242000140","ISENTO","1","1","0");
INSERT INTO cliente VALUES("958","fisica","REINALDO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("959","fisica","THAMYLLYS KARINE DE ARAUJO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("960","fisica","THAYANNI MARIANO","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("961","fisica","LAIS RANGEL","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("962","fisica","REGINALDO NUNES DIAS","0000-00-00","14898428886","","","","","","1","1","0");
INSERT INTO cliente VALUES("963","fisica","RAISA SELHORST","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("964","juridica","","0000-00-00","","","RUBENS DA SILVA PROTELA EIRELI","RUBENS DA SILVA","05494936000130","15.775.941-5","1","1","0");
INSERT INTO cliente VALUES("965","juridica","","0000-00-00","","","PREFEITURA MUNICIPAL DE COLIDER","PREFEITURA MUNICIPAL DE COLIDER","15023930000138","","1","0","0");
INSERT INTO cliente VALUES("966","fisica","MARCIA - TELAS","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("967","fisica","FERNANDA - AMIGA ROBERTA","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("968","fisica","TALITA ANDRADE","0000-00-00","","","","","","","1","1","0");
INSERT INTO cliente VALUES("969","juridica","INSTITUTO FEDERAL DO PARANA / CAMPUS PALMAS","0000-00-00","","","INSTITUTO FEDERAL DO PARANA / CAMPUS PALMAS","INST. FED. DO PARANA / CAMPUS PALMAS","10652179001006","ISENTO","1","1","0");





CREATE TABLE `comissao` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_funcionario` int(11) DEFAULT NULL,
  `valor` float DEFAULT NULL,
  `valor_comissao` float DEFAULT NULL,
  `id_func_pagou` int(11) DEFAULT NULL,
  `data` datetime DEFAULT NULL,
  `id_func_canc` int(11) DEFAULT NULL,
  `ativo` tinyint(1) DEFAULT 1,
  `mes` date DEFAULT NULL,
  `vale` tinyint(1) DEFAULT 0,
  `obs` varchar(255) DEFAULT NULL,
  `consumo` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;






CREATE TABLE `contas_pagar` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_fornecedor` int(11) DEFAULT NULL,
  `documento` varchar(255) DEFAULT NULL,
  `serie` int(11) DEFAULT NULL,
  `data_emissao` date DEFAULT NULL,
  `valor` float DEFAULT NULL,
  `tipo` varchar(255) DEFAULT NULL,
  `parcelas` int(11) DEFAULT NULL,
  `cancelado` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1719 DEFAULT CHARSET=utf8;

INSERT INTO contas_pagar VALUES("2","2","1394548","0","2016-09-02","106.46","1","1","0");
INSERT INTO contas_pagar VALUES("3","3","MGA-0858781","0","2016-09-07","61.6","1","1","0");
INSERT INTO contas_pagar VALUES("4","1","74129058","0","2016-08-27","511.33","5","1","0");
INSERT INTO contas_pagar VALUES("5","1","13894960","0","2016-08-27","536.75","5","1","0");
INSERT INTO contas_pagar VALUES("6","6","","0","2016-09-01","180.54","5","1","0");
INSERT INTO contas_pagar VALUES("7","5","","0","2016-08-27","133.89","5","1","0");
INSERT INTO contas_pagar VALUES("8","5","","0","2016-08-27","140.09","5","1","0");
INSERT INTO contas_pagar VALUES("9","7","0020059-0","0","2016-09-13","280","1","1","0");
INSERT INTO contas_pagar VALUES("10","3","MGA-0861341","0","2016-09-14","60.4","1","1","0");
INSERT INTO contas_pagar VALUES("11","8","0075334-3","0","2016-09-14","298.97","1","1","0");
INSERT INTO contas_pagar VALUES("12","9","892","0","2016-09-15","160","1","1","0");
INSERT INTO contas_pagar VALUES("13","10","00001598","0","2016-09-15","35.9","1","1","0");
INSERT INTO contas_pagar VALUES("14","11","000013935","0","2016-09-15","0","1","1","0");
INSERT INTO contas_pagar VALUES("15","2","1396054","0","2016-09-15","284.91","1","1","0");
INSERT INTO contas_pagar VALUES("16","12","9374-11611","0","2016-09-16","95","1","1","0");
INSERT INTO contas_pagar VALUES("17","13","5232462","0","0000-00-00","61.52","1","1","0");
INSERT INTO contas_pagar VALUES("18","14","2765952","0","2016-09-18","390","1","1","0");
INSERT INTO contas_pagar VALUES("19","18","08/2016","0","2016-09-20","802.88","4","1","0");
INSERT INTO contas_pagar VALUES("20","15","2208/02","0","2016-09-21","4413.88","1","1","0");
INSERT INTO contas_pagar VALUES("21","16","5012112","0","2016-09-22","260","1","1","0");
INSERT INTO contas_pagar VALUES("23","7","0020059-0","1","2016-09-13","280","1","1","0");
INSERT INTO contas_pagar VALUES("24","1","74129058","1","2016-08-27","511.33","1","1","0");
INSERT INTO contas_pagar VALUES("25","1","13894960","1","2016-09-12","536.75","1","1","0");
INSERT INTO contas_pagar VALUES("26","5","","1","2016-09-12","180.54","5","1","0");
INSERT INTO contas_pagar VALUES("27","5","","1","2016-09-12","273.98","1","1","0");
INSERT INTO contas_pagar VALUES("28","2","","1","2016-08-08","106.46","1","1","0");
INSERT INTO contas_pagar VALUES("29","3","MGA-0858781","1","2016-08-28","61.6","1","1","0");
INSERT INTO contas_pagar VALUES("30","3","MGA-0861341","1","2016-09-04","60.4","1","1","0");
INSERT INTO contas_pagar VALUES("31","8","0075334-3","1","2016-08-31","298.97","1","1","0");
INSERT INTO contas_pagar VALUES("32","9","892","1","2016-08-23","160","1","1","0");
INSERT INTO contas_pagar VALUES("33","10","1598","1","2016-09-05","35.9","1","1","0");
INSERT INTO contas_pagar VALUES("34","11","13935","1","2016-09-15","1540","1","1","0");
INSERT INTO contas_pagar VALUES("35","2","1396054","1","2016-08-18","284.91","1","1","0");
INSERT INTO contas_pagar VALUES("36","12","9374-11611","1","2016-08-30","95","1","1","0");
INSERT INTO contas_pagar VALUES("37","13","5232462","1","2016-09-01","61.52","1","1","0");
INSERT INTO contas_pagar VALUES("38","14","2765952","1","2016-09-01","390","1","1","0");
INSERT INTO contas_pagar VALUES("39","18","08/2016","1","2016-09-12","802.88","1","1","0");
INSERT INTO contas_pagar VALUES("40","15","2208/02","1","2016-08-22","4413.88","1","1","0");
INSERT INTO contas_pagar VALUES("41","16","5012112","1","2016-09-01","260","1","1","0");
INSERT INTO contas_pagar VALUES("42","2","1397519","1","2016-08-30","139.02","1","1","0");
INSERT INTO contas_pagar VALUES("43","2","1397173","1","2016-08-29","312.73","1","1","0");
INSERT INTO contas_pagar VALUES("44","11","13935","1","2016-09-01","1540","1","1","0");
INSERT INTO contas_pagar VALUES("45","20","08/2016","1","2016-09-16","1111.78","1","1","0");
INSERT INTO contas_pagar VALUES("46","2","1399678","1","2016-09-13","185.55","1","1","0");
INSERT INTO contas_pagar VALUES("47","2","1398802","1","2016-09-06","116.14","1","1","0");
INSERT INTO contas_pagar VALUES("48","2","1400436","1","2016-09-19","77.61","1","1","0");
INSERT INTO contas_pagar VALUES("49","17","1128/1","1","2016-09-08","1200","1","1","0");
INSERT INTO contas_pagar VALUES("50","17","1128/2","1","2016-09-08","1200","1","1","0");
INSERT INTO contas_pagar VALUES("51","17","1128/3","1","2016-09-08","1200","1","1","0");
INSERT INTO contas_pagar VALUES("52","17","1128/4","1","2016-09-08","1200","1","1","0");
INSERT INTO contas_pagar VALUES("53","22","17000390","1","2016-09-01","36","1","1","0");
INSERT INTO contas_pagar VALUES("54","1","74129058","1","2016-09-01","533.3","1","1","0");
INSERT INTO contas_pagar VALUES("55","1","13894960","1","2016-09-01","532.32","1","1","0");
INSERT INTO contas_pagar VALUES("56","5","32411322","1","2016-09-01","137.92","1","1","0");
INSERT INTO contas_pagar VALUES("57","6","","1","2016-09-01","141.11","1","1","0");
INSERT INTO contas_pagar VALUES("58","2","1398802","1","2016-10-06","116.14","1","1","0");
INSERT INTO contas_pagar VALUES("59","2","1399678","1","2016-09-14","185.55","1","1","0");
INSERT INTO contas_pagar VALUES("60","10","1665","1","2016-10-03","100","1","1","0");
INSERT INTO contas_pagar VALUES("61","8","76253-9","1","2016-09-30","100","1","1","0");
INSERT INTO contas_pagar VALUES("62","9","907","1","2016-09-19","160","1","1","0");
INSERT INTO contas_pagar VALUES("63","15","1602/01","1","2016-10-03","4718.45","1","1","0");
INSERT INTO contas_pagar VALUES("64","15","1602/02","1","2016-10-03","4718.45","1","1","0");
INSERT INTO contas_pagar VALUES("65","15","1602/03","1","2016-10-03","4718.46","1","1","0");
INSERT INTO contas_pagar VALUES("66","11","19917","1","2016-10-10","1065","1","1","0");
INSERT INTO contas_pagar VALUES("67","10","1671","1","2016-10-05","35.9","1","1","0");
INSERT INTO contas_pagar VALUES("68","18","09/2016","1","2016-10-05","694.4","1","1","0");
INSERT INTO contas_pagar VALUES("69","23","17980-9","1","2016-10-05","597.6","1","1","0");
INSERT INTO contas_pagar VALUES("70","24","147/1","1","2016-10-06","205.9","1","1","0");
INSERT INTO contas_pagar VALUES("71","24","147/02","1","2016-10-06","205.9","1","1","0");
INSERT INTO contas_pagar VALUES("72","13","","1","2016-10-06","115.45","1","1","0");
INSERT INTO contas_pagar VALUES("73","17","1128f","1","2016-10-06","0","1","1","0");
INSERT INTO contas_pagar VALUES("74","1","13894960","1","2016-10-01","593.49","1","1","0");
INSERT INTO contas_pagar VALUES("75","1","74129058","1","2016-10-01","719.88","1","1","0");
INSERT INTO contas_pagar VALUES("76","20","09/2016","1","2016-09-01","1189.79","1","1","0");
INSERT INTO contas_pagar VALUES("77","2","1403340","1","2016-10-18","157.76","1","1","0");
INSERT INTO contas_pagar VALUES("78","10","1732","1","2016-11-03","100","1","1","0");
INSERT INTO contas_pagar VALUES("79","11","25836","1","2016-10-31","1527","1","1","0");
INSERT INTO contas_pagar VALUES("80","13","","1","2016-11-07","39.71","1","1","0");
INSERT INTO contas_pagar VALUES("81","2","1403879","1","2016-10-20","265.24","1","1","0");
INSERT INTO contas_pagar VALUES("82","18","10/2016","1","2016-11-01","787.57","1","1","0");
INSERT INTO contas_pagar VALUES("83","15","1043","1","2016-11-05","5122.42","1","1","0");
INSERT INTO contas_pagar VALUES("84","25","3099-B","1","2016-10-25","500","1","1","0");
INSERT INTO contas_pagar VALUES("85","26","29067","1","2016-10-28","80","1","1","0");
INSERT INTO contas_pagar VALUES("86","22","","0","0000-00-00","347.17","1","1","0");
INSERT INTO contas_pagar VALUES("87","28","11388978","0","2019-08-02","216.03","1","1","0");
INSERT INTO contas_pagar VALUES("88","22","","0","2019-07-19","347.17","1","1","0");
INSERT INTO contas_pagar VALUES("89","29","190800067501","0","2019-08-15","230.38","1","1","0");
INSERT INTO contas_pagar VALUES("90","2","4366843","0","2019-08-16","444.83","1","1","0");
INSERT INTO contas_pagar VALUES("91","1","teste-2019","1","2019-08-10","120","1","2","0");
INSERT INTO contas_pagar VALUES("92","2","4366843","0","2019-08-16","444.83","1","1","0");
INSERT INTO contas_pagar VALUES("93","2","4366843","0","2019-08-16","444.83","1","1","0");
INSERT INTO contas_pagar VALUES("94","2","4366843","0","2019-08-16","444.83","1","1","0");
INSERT INTO contas_pagar VALUES("95","10","176244278","0","2019-08-20","150","1","1","0");
INSERT INTO contas_pagar VALUES("96","28","11388978","0","2019-08-15","216.03","1","1","0");
INSERT INTO contas_pagar VALUES("97","14","6309197","0","2019-08-18","645","1","1","0");
INSERT INTO contas_pagar VALUES("98","14","6309197","0","2019-08-18","645","1","1","0");
INSERT INTO contas_pagar VALUES("99","14","6309197","0","2019-08-18","645","1","1","0");
INSERT INTO contas_pagar VALUES("100","2","4366843","0","2019-08-21","444.83","1","1","0");
INSERT INTO contas_pagar VALUES("101","10","176244278","0","2019-08-12","150","1","1","0");
INSERT INTO contas_pagar VALUES("102","28","11388978","0","2019-08-02","216.03","1","1","0");
INSERT INTO contas_pagar VALUES("103","2","7097/01-01","227","2019-08-19","227.4","1","1","0");
INSERT INTO contas_pagar VALUES("104","34","435872","0","2019-08-16","53.64","1","1","0");
INSERT INTO contas_pagar VALUES("105","34","435864","0","2019-08-16","3530","1","1","0");
INSERT INTO contas_pagar VALUES("106","2","4364458","0","2019-06-29","328.5","1","1","0");
INSERT INTO contas_pagar VALUES("107","31","26312/U","0","2019-07-30","134.4","1","1","0");
INSERT INTO contas_pagar VALUES("108","32","001959/1-3","0","2019-07-24","613.76","1","1","0");
INSERT INTO contas_pagar VALUES("109","2","4368024","0","2019-07-30","196.92","1","1","0");
INSERT INTO contas_pagar VALUES("110","35","805191-4","0","2019-08-21","199.9","1","1","0");
INSERT INTO contas_pagar VALUES("111","31","25687/2","0","2019-07-30","166","1","1","0");
INSERT INTO contas_pagar VALUES("112","7","0031090-5","0","2019-08-14","120","1","1","0");
INSERT INTO contas_pagar VALUES("113","36","0932812-2","0","2019-08-19","230.9","1","1","0");
INSERT INTO contas_pagar VALUES("114","29","190800306401","0","2019-08-16","456.17","1","1","0");
INSERT INTO contas_pagar VALUES("115","20","JULHO/2019","0","2019-08-20","3132.45","1","1","0");
INSERT INTO contas_pagar VALUES("116","23","05/2019","0","2019-08-01","1426.46","1","1","0");
INSERT INTO contas_pagar VALUES("117","23","07/2019","0","2019-08-01","1430.7","1","1","0");
INSERT INTO contas_pagar VALUES("118","20","DIVERSOS","0","2019-08-20","321.18","1","1","0");
INSERT INTO contas_pagar VALUES("119","38","4945918819","0","2019-08-07","73.76","1","1","0");
INSERT INTO contas_pagar VALUES("120","5","32411322","0","2019-08-26","148.8","1","1","0");
INSERT INTO contas_pagar VALUES("121","6","984140480","0","2019-08-26","73.82","1","1","0");
INSERT INTO contas_pagar VALUES("122","39","74129058","0","2019-08-26","172.72","1","1","0");
INSERT INTO contas_pagar VALUES("123","1","13894960","0","2019-08-26","3105.87","1","1","0");
INSERT INTO contas_pagar VALUES("124","2","4369068","0","2019-08-07","240.55","1","1","0");
INSERT INTO contas_pagar VALUES("125","31","25050/37/3","0","2019-06-03","551","1","1","0");
INSERT INTO contas_pagar VALUES("126","22","17000390","0","2019-08-26","470.75","1","1","0");
INSERT INTO contas_pagar VALUES("127","2","4366014","0","2019-07-12","214.53","1","1","0");
INSERT INTO contas_pagar VALUES("128","2","4369632","0","2019-08-09","235.5","1","1","0");
INSERT INTO contas_pagar VALUES("129","40","062201-01","0","2019-08-09","689.54","1","1","0");
INSERT INTO contas_pagar VALUES("130","32","001959/2-3","0","2019-07-24","611","1","1","0");
INSERT INTO contas_pagar VALUES("131","2","4370348","0","2019-08-16","110.41","1","1","0");
INSERT INTO contas_pagar VALUES("132","2","00204372-2","0","2019-07-17","92","1","1","0");
INSERT INTO contas_pagar VALUES("133","30","00204372-2","0","2019-07-17","92","1","1","0");
INSERT INTO contas_pagar VALUES("134","41","11900000003510991","0","2019-06-28","196.46","1","1","0");
INSERT INTO contas_pagar VALUES("135","41","11900000003510281","0","2019-06-28","385.34","1","1","0");
INSERT INTO contas_pagar VALUES("136","41","11900000003511062","0","2019-06-28","28.42","1","1","0");
INSERT INTO contas_pagar VALUES("137","32","001959/3-3","0","2019-07-24","611","1","1","0");
INSERT INTO contas_pagar VALUES("138","2","160122","0","2019-08-22","196.92","1","1","0");
INSERT INTO contas_pagar VALUES("139","42","325945","0","2019-07-08","194","1","0","0");
INSERT INTO contas_pagar VALUES("140","42","325945","0","2019-07-07","194","1","1","0");
INSERT INTO contas_pagar VALUES("141","42","325946","0","2019-07-07","194","1","1","0");
INSERT INTO contas_pagar VALUES("142","42","325947","0","2019-07-07","194","1","1","0");
INSERT INTO contas_pagar VALUES("143","42","325948","0","2019-07-07","194","1","1","0");
INSERT INTO contas_pagar VALUES("144","42","325949","0","2019-07-07","194","1","1","0");
INSERT INTO contas_pagar VALUES("145","2","3213","0","2019-08-29","100.74","1","1","0");
INSERT INTO contas_pagar VALUES("146","2","160544","0","2019-08-29","520.84","1","2","0");
INSERT INTO contas_pagar VALUES("147","43","54163337","0","2019-08-30","125","1","1","0");
INSERT INTO contas_pagar VALUES("148","31","027071","0","2019-08-27","198","1","1","0");
INSERT INTO contas_pagar VALUES("149","2","159715","0","2019-08-16","280.15","1","1","0");
INSERT INTO contas_pagar VALUES("150","34","44937-7","0","2019-09-03","2775","1","1","0");
INSERT INTO contas_pagar VALUES("151","29","19.09.000675.01","0","2019-09-02","699.87","1","1","0");
INSERT INTO contas_pagar VALUES("152","36","09425659","0","2019-09-03","255","1","1","0");
INSERT INTO contas_pagar VALUES("153","44","F - 016/2019","0","2019-09-04","82.25","1","1","0");
INSERT INTO contas_pagar VALUES("154","7","0031361-1","0","2019-09-04","125","1","1","0");
INSERT INTO contas_pagar VALUES("155","45","1","0","2019-08-30","665.06","1","1","0");
INSERT INTO contas_pagar VALUES("156","14","6375009","0","2019-08-16","470","1","1","0");
INSERT INTO contas_pagar VALUES("157","2","161167","0","2019-09-10","308.18","1","1","0");
INSERT INTO contas_pagar VALUES("158","46","00052486/1","0","2019-09-12","248.7","1","1","0");
INSERT INTO contas_pagar VALUES("159","20","08.2019","0","2019-09-16","2780.01","1","1","0");
INSERT INTO contas_pagar VALUES("160","20","PARC. 09.2019","0","2019-09-16","322.72","1","1","0");
INSERT INTO contas_pagar VALUES("161","34","0046437-6","0","2019-09-16","3905","1","1","0");
INSERT INTO contas_pagar VALUES("162","14","6439821","0","2019-09-02","95","1","1","0");
INSERT INTO contas_pagar VALUES("163","29","19.09.003050.01","0","2019-09-16","771.22","1","1","0");
INSERT INTO contas_pagar VALUES("164","36","09521805-3","0","2019-09-17","230.72","1","1","0");
INSERT INTO contas_pagar VALUES("165","14","6504383","0","2019-09-16","330","1","1","0");
INSERT INTO contas_pagar VALUES("166","18","08/2019","0","2019-09-17","1828.11","1","1","0");
INSERT INTO contas_pagar VALUES("167","5","3241-1300","0","2019-08-01","148","1","1","0");
INSERT INTO contas_pagar VALUES("168","10","182197234","0","2019-09-23","153","1","1","0");
INSERT INTO contas_pagar VALUES("169","28","089703880","0","2019-09-20","129.57","1","1","0");
INSERT INTO contas_pagar VALUES("170","46","00052724/1","0","2019-09-24","135.48","1","1","0");
INSERT INTO contas_pagar VALUES("171","7","00316547","0","2019-09-24","130","1","1","0");
INSERT INTO contas_pagar VALUES("172","5","3241-1322","0","2019-09-25","155.52","1","1","0");
INSERT INTO contas_pagar VALUES("173","6","set/2019","0","2019-09-25","72.35","1","1","0");
INSERT INTO contas_pagar VALUES("174","18","09/2019","0","2019-09-25","564.46","1","1","0");
INSERT INTO contas_pagar VALUES("175","2","161935","0","2019-09-25","0","1","2","0");
INSERT INTO contas_pagar VALUES("176","2","161935","0","2019-09-25","0","1","2","0");
INSERT INTO contas_pagar VALUES("177","2","161935","0","2019-09-25","0","1","2","0");
INSERT INTO contas_pagar VALUES("178","31","27825/U","0","2019-09-25","86","1","1","0");
INSERT INTO contas_pagar VALUES("179","31","27071/573","0","2019-09-25","235","1","1","0");
INSERT INTO contas_pagar VALUES("180","47","IB_PF","0","2019-09-30","200","1","1","0");
INSERT INTO contas_pagar VALUES("181","45","1","0","2019-10-01","1074.62","1","1","0");
INSERT INTO contas_pagar VALUES("182","48","ENTRADA PARCELAMENTO","0","2019-10-01","1434.45","1","1","0");
INSERT INTO contas_pagar VALUES("183","48","OUTUBRO/2019","0","2019-10-01","1608.33","1","1","0");
INSERT INTO contas_pagar VALUES("184","43","14551637","0","2019-10-02","125","1","1","0");
INSERT INTO contas_pagar VALUES("185","49","31058085","0","2019-10-30","40","1","1","0");
INSERT INTO contas_pagar VALUES("186","31","27945","0","2019-09-30","263","1","3","0");
INSERT INTO contas_pagar VALUES("187","34","0047777-0","0","2019-10-02","4150","1","1","0");
INSERT INTO contas_pagar VALUES("188","29","191000078801","0","2019-10-02","386.12","1","1","0");
INSERT INTO contas_pagar VALUES("189","39","SETEMBRO/2019","0","2019-09-01","213.09","1","1","0");
INSERT INTO contas_pagar VALUES("190","5","3241-1300","0","2019-09-01","163.94","1","1","0");
INSERT INTO contas_pagar VALUES("191","1","SETEMBRO/2019","0","2019-09-01","3475.22","1","1","0");
INSERT INTO contas_pagar VALUES("192","31","25050/37/4","0","2019-06-03","551","1","1","0");
INSERT INTO contas_pagar VALUES("193","43","14551637","0","2019-10-01","125","1","1","0");
INSERT INTO contas_pagar VALUES("194","22","09/2019","0","2019-09-19","479.81","1","1","0");
INSERT INTO contas_pagar VALUES("195","30","00204372-3","0","2019-07-17","92","1","1","0");
INSERT INTO contas_pagar VALUES("196","41","IMPOSTO A.C","0","2019-10-02","28.42","1","1","0");
INSERT INTO contas_pagar VALUES("197","41","IMPOSTO A.C","0","2019-10-02","196.46","1","1","0");
INSERT INTO contas_pagar VALUES("198","41","IMPOSTO A.C","0","2019-10-02","385.34","1","1","0");
INSERT INTO contas_pagar VALUES("199","5","SETEMBRO/2019","0","2019-09-01","155.52","1","1","0");
INSERT INTO contas_pagar VALUES("200","49","31058085","0","2019-10-01","40","1","1","0");
INSERT INTO contas_pagar VALUES("201","44","F-018/2019","0","2019-09-27","82.25","1","1","0");
INSERT INTO contas_pagar VALUES("202","18","09/2019","0","2019-10-03","1762.07","1","1","0");
INSERT INTO contas_pagar VALUES("203","23","09/2019","0","2019-10-03","1652.32","1","1","0");
INSERT INTO contas_pagar VALUES("204","28","11625791","0","2019-10-02","131.1","1","1","0");
INSERT INTO contas_pagar VALUES("205","29","191000168801","0","2019-10-03","119.89","1","1","0");
INSERT INTO contas_pagar VALUES("206","44","167621","0","2019-10-09","360","1","3","0");
INSERT INTO contas_pagar VALUES("207","20","SETEMBRO/2019","0","2019-10-21","3315.92","1","1","0");
INSERT INTO contas_pagar VALUES("208","1","OUTUBRO/2019","0","2019-10-16","3837.62","1","1","0");
INSERT INTO contas_pagar VALUES("209","39","OUTUBRO/2019","0","2019-10-16","462.12","1","1","0");
INSERT INTO contas_pagar VALUES("210","7","0031958-9","0","2019-10-16","113.6","1","1","0");
INSERT INTO contas_pagar VALUES("211","6","OUT/2019","0","2019-10-16","75.26","1","1","0");
INSERT INTO contas_pagar VALUES("212","34","0049289-2","0","2019-10-17","2746.56","1","1","0");
INSERT INTO contas_pagar VALUES("213","14","6637590","0","2019-10-17","396.5","1","1","0");
INSERT INTO contas_pagar VALUES("214","29","19.10.003115.01","0","2019-10-17","385.76","1","1","0");
INSERT INTO contas_pagar VALUES("215","46","00053269/1","0","2019-10-18","221.22","1","1","0");
INSERT INTO contas_pagar VALUES("216","43","63772529","0","2019-10-18","125","1","1","0");
INSERT INTO contas_pagar VALUES("217","2","163296","0","2019-10-18","640.67","1","2","0");
INSERT INTO contas_pagar VALUES("218","31","028417","0","2019-10-18","780","1","3","0");
INSERT INTO contas_pagar VALUES("219","10","186602168","0","2019-10-21","150","1","0","0");
INSERT INTO contas_pagar VALUES("220","10","186602168","0","2019-10-21","150","1","1","0");
INSERT INTO contas_pagar VALUES("221","10","186602168","0","2019-10-20","150","1","1","0");
INSERT INTO contas_pagar VALUES("222","2","4376894","0","2019-10-09","278.47","1","1","0");
INSERT INTO contas_pagar VALUES("223","2","4376895","0","2019-10-09","278.47","1","1","0");
INSERT INTO contas_pagar VALUES("224","18","10/2019","0","2019-10-23","566.93","1","1","0");
INSERT INTO contas_pagar VALUES("225","50","2352","0","2019-10-24","45099.2","1","6","0");
INSERT INTO contas_pagar VALUES("226","35","INTERNET","0","2019-10-24","204.4","1","1","0");
INSERT INTO contas_pagar VALUES("227","31","28581/U","0","2019-10-25","216","1","1","0");
INSERT INTO contas_pagar VALUES("228","31","28581/U","0","2019-10-25","216","1","1","0");
INSERT INTO contas_pagar VALUES("229","3","MGA-1166379","0","2019-10-28","48","1","1","0");
INSERT INTO contas_pagar VALUES("230","46","00053420/1","0","2019-10-24","530","1","1","0");
INSERT INTO contas_pagar VALUES("231","41","1683/2019","0","2019-10-30","196.46","1","1","0");
INSERT INTO contas_pagar VALUES("232","41","8315/2019","0","2019-10-30","28.42","1","1","0");
INSERT INTO contas_pagar VALUES("233","41","","0","2019-10-30","385.34","1","1","0");
INSERT INTO contas_pagar VALUES("234","31","25050/37/5","0","2019-06-03","551","1","1","0");
INSERT INTO contas_pagar VALUES("235","2","4378740","0","2019-10-22","640.67","1","2","0");
INSERT INTO contas_pagar VALUES("236","5","3241-1322","0","2019-10-29","163.08","1","1","0");
INSERT INTO contas_pagar VALUES("237","38","4949223619","0","2019-10-16","56.51","1","1","0");
INSERT INTO contas_pagar VALUES("238","44","F - 020/2019","0","2019-10-31","84.93","1","1","0");
INSERT INTO contas_pagar VALUES("239","45","1","0","2019-11-01","837.62","1","1","0");
INSERT INTO contas_pagar VALUES("240","29","19.11.000835.01","0","2019-11-01","677.79","1","1","0");
INSERT INTO contas_pagar VALUES("241","34","0050715-6","0","2019-11-04","4430","1","1","0");
INSERT INTO contas_pagar VALUES("242","18","10/2019","0","2019-11-04","1815.52","1","1","0");
INSERT INTO contas_pagar VALUES("243","23","10/2019","0","2019-11-04","1705.78","1","1","0");
INSERT INTO contas_pagar VALUES("244","24","000565/01","0","2019-11-04","69","1","1","0");
INSERT INTO contas_pagar VALUES("245","33","7683/01-01","0","2019-11-06","237.1","1","1","0");
INSERT INTO contas_pagar VALUES("246","46","00053724/1","0","2019-11-06","79.1","1","1","0");
INSERT INTO contas_pagar VALUES("247","51","0031862-1","0","2019-11-06","70","1","1","0");
INSERT INTO contas_pagar VALUES("248","28","11819529","0","2019-11-04","49.09","1","1","0");
INSERT INTO contas_pagar VALUES("249","35","21502311","0","2019-11-11","204.2","1","1","0");
INSERT INTO contas_pagar VALUES("250","52","13902","0","2019-11-11","178.8","1","1","0");
INSERT INTO contas_pagar VALUES("251","20","OUTUBRO/2019","0","2019-11-12","3319.16","1","1","0");
INSERT INTO contas_pagar VALUES("252","5","3241-1300","0","2019-11-13","159.14","1","1","0");
INSERT INTO contas_pagar VALUES("253","22","10/2019","0","2019-10-13","548.65","1","1","0");
INSERT INTO contas_pagar VALUES("254","10","191851100","0","2019-11-18","150","1","1","0");
INSERT INTO contas_pagar VALUES("255","36","09904590","0","2019-11-18","303.59","1","1","0");
INSERT INTO contas_pagar VALUES("256","34","00523593","0","2019-11-18","4370","1","1","0");
INSERT INTO contas_pagar VALUES("257","48","novembro/2019","0","2019-11-18","325.6","1","1","0");
INSERT INTO contas_pagar VALUES("258","29","19.11.003185.01","0","2019-11-18","220.32","1","1","0");
INSERT INTO contas_pagar VALUES("259","3","MGA-1168428","0","2019-11-19","59.91","1","1","0");
INSERT INTO contas_pagar VALUES("260","22","11/2019","0","2019-11-20","449.27","1","1","0");
INSERT INTO contas_pagar VALUES("261","43","92083946","0","2019-11-20","125","1","1","0");
INSERT INTO contas_pagar VALUES("262","2","165191","0","2019-11-20","659.75","1","2","0");
INSERT INTO contas_pagar VALUES("263","39","NOVEMBRO/2019","0","2019-11-27","587.9","1","1","0");
INSERT INTO contas_pagar VALUES("264","1","NOVEMBRO/2019","0","2019-11-08","3860.08","1","1","0");
INSERT INTO contas_pagar VALUES("265","5","3241-1322","0","2019-11-25","155.52","1","1","0");
INSERT INTO contas_pagar VALUES("266","2","4380566","0","2019-11-08","399.29","1","1","0");
INSERT INTO contas_pagar VALUES("267","2","4380567","0","2019-11-08","399.28","1","1","0");
INSERT INTO contas_pagar VALUES("268","18","PARC. 11/2019","0","2019-11-25","569.5","1","1","0");
INSERT INTO contas_pagar VALUES("269","53","3/FE-34630/0","0","2019-11-25","300","1","1","0");
INSERT INTO contas_pagar VALUES("270","3","MGA-1169017","0","2019-11-26","38.19","1","1","0");
INSERT INTO contas_pagar VALUES("271","31","029359/01","0","2019-11-26","63","1","1","0");
INSERT INTO contas_pagar VALUES("272","54","55001828-1/2","0","2019-11-27","837","1","2","0");
INSERT INTO contas_pagar VALUES("273","44","F-022/2019","0","2019-11-28","84.93","1","1","0");
INSERT INTO contas_pagar VALUES("274","24","000564/1","0","2019-11-28","79.38","1","1","0");
INSERT INTO contas_pagar VALUES("275","48","29/11/2019","0","2019-11-28","1615.64","1","1","0");
INSERT INTO contas_pagar VALUES("276","48","29/11/2019","0","2019-11-28","521.55","1","1","0");
INSERT INTO contas_pagar VALUES("277","5","3241-1300","0","2019-11-28","151.68","1","1","0");
INSERT INTO contas_pagar VALUES("278","43","92083946","0","2019-11-29","125","1","1","0");
INSERT INTO contas_pagar VALUES("279","52","14039","0","2019-11-29","129.8","1","1","0");
INSERT INTO contas_pagar VALUES("280","51","1","0","2019-12-05","733.86","1","1","0");
INSERT INTO contas_pagar VALUES("281","45","1","0","2019-12-02","733.86","1","1","0");
INSERT INTO contas_pagar VALUES("282","41","","0","2019-12-02","196.46","1","1","0");
INSERT INTO contas_pagar VALUES("283","41","","0","2019-12-02","28.42","1","1","0");
INSERT INTO contas_pagar VALUES("284","41","","0","2019-12-02","385.34","1","1","0");
INSERT INTO contas_pagar VALUES("285","34","0053721-7","0","2019-12-02","53.64","1","1","0");
INSERT INTO contas_pagar VALUES("286","34","0053720-9","0","2019-12-02","3270","1","1","0");
INSERT INTO contas_pagar VALUES("287","2","165841","0","2019-12-02","1231.52","1","3","0");
INSERT INTO contas_pagar VALUES("288","55","11857","0","2019-12-02","109.44","1","1","0");
INSERT INTO contas_pagar VALUES("289","18","11/2019","0","2019-12-03","1832.05","1","1","0");
INSERT INTO contas_pagar VALUES("290","31","29359/47/U","0","2019-12-03","265.5","1","1","0");
INSERT INTO contas_pagar VALUES("291","14","6834791","0","2019-12-02","139","1","1","0");
INSERT INTO contas_pagar VALUES("292","3","MGA-1169637","0","2019-12-03","83.88","1","1","0");
INSERT INTO contas_pagar VALUES("293","29","19.12.000724.01","0","2019-12-02","266.9","1","1","0");
INSERT INTO contas_pagar VALUES("294","57","17698","0","2019-12-03","440","1","2","0");
INSERT INTO contas_pagar VALUES("295","7","0032802-2","0","2019-12-11","291.77","1","1","0");
INSERT INTO contas_pagar VALUES("296","38","521090","0","2019-12-11","337.3","1","1","0");
INSERT INTO contas_pagar VALUES("297","10","199283886","0","2019-12-16","150","1","1","0");
INSERT INTO contas_pagar VALUES("298","38","4951777119","0","2019-12-16","159","1","1","0");
INSERT INTO contas_pagar VALUES("299","58","551828","0","2019-12-09","837","1","2","0");
INSERT INTO contas_pagar VALUES("300","34","3002","0","2019-12-16","90","1","1","0");
INSERT INTO contas_pagar VALUES("301","34","005197-0","0","2019-12-16","2390","1","1","0");
INSERT INTO contas_pagar VALUES("302","6","CELULAR","0","2019-12-16","73.11","1","1","0");
INSERT INTO contas_pagar VALUES("303","2","4384286","0","2019-12-05","410.5","1","1","0");
INSERT INTO contas_pagar VALUES("304","2","4384285","0","2019-12-05","410.51","1","1","0");
INSERT INTO contas_pagar VALUES("305","2","4384284","0","2019-12-05","410.51","1","1","0");
INSERT INTO contas_pagar VALUES("306","1","DEZEMBRO/2019","0","2019-12-16","3602.97","1","1","0");
INSERT INTO contas_pagar VALUES("307","1","DEZEMBRO/2019","0","2019-12-16","483.21","1","1","0");
INSERT INTO contas_pagar VALUES("308","45","","0","2019-12-17","1090.78","1","1","0");
INSERT INTO contas_pagar VALUES("309","5","DEZEMBRO/2019","0","2019-12-10","163.32","1","1","0");
INSERT INTO contas_pagar VALUES("310","34","0056479-6","0","2020-01-06","1160","1","1","0");
INSERT INTO contas_pagar VALUES("311","7","0032975-4","0","2020-01-06","280","1","1","0");
INSERT INTO contas_pagar VALUES("312","44","F - 024/2019","0","2019-12-30","84.93","1","1","0");
INSERT INTO contas_pagar VALUES("313","31","29856/57/U","0","2019-12-18","195","1","1","0");
INSERT INTO contas_pagar VALUES("314","18","12/2019","0","2020-01-01","2429.55","1","1","0");
INSERT INTO contas_pagar VALUES("315","28","12071390","0","2020-01-06","74.95","1","1","0");
INSERT INTO contas_pagar VALUES("316","35","805191-4","0","2020-01-10","162.81","1","1","0");
INSERT INTO contas_pagar VALUES("317","2","4386333","0","2019-12-20","81.6","1","1","0");
INSERT INTO contas_pagar VALUES("318","2","4386322","0","2019-12-20","761.96","1","1","0");
INSERT INTO contas_pagar VALUES("319","2","4386327","0","2019-12-20","761.95","1","1","0");
INSERT INTO contas_pagar VALUES("320","2","4386326","0","2019-12-20","761.96","1","1","0");
INSERT INTO contas_pagar VALUES("321","2","4386325","0","2019-12-20","761.95","1","1","0");
INSERT INTO contas_pagar VALUES("322","2","4386324","0","2019-12-20","761.96","1","1","0");
INSERT INTO contas_pagar VALUES("323","2","4386323","0","2019-12-20","761.95","1","1","0");
INSERT INTO contas_pagar VALUES("324","10","207357316","0","2020-01-15","152","1","1","0");
INSERT INTO contas_pagar VALUES("325","22","12/2019","0","2019-12-31","449.68","1","1","0");
INSERT INTO contas_pagar VALUES("326","34","00574392","0","2020-01-16","1820","1","1","0");
INSERT INTO contas_pagar VALUES("327","47","186549512","0","2020-01-17","80","1","1","0");
INSERT INTO contas_pagar VALUES("328","14","7006885","0","2020-01-16","615.5","1","1","0");
INSERT INTO contas_pagar VALUES("329","37","20.01.001948.01","0","2020-01-16","92.38","1","1","0");
INSERT INTO contas_pagar VALUES("330","20","DEZEMBRO/2019","0","2020-01-17","1540.12","1","1","0");
INSERT INTO contas_pagar VALUES("331","5","3241-1300","0","2019-12-02","159.28","1","1","0");
INSERT INTO contas_pagar VALUES("332","45","1","0","2020-01-21","278.73","1","1","0");
INSERT INTO contas_pagar VALUES("333","59","SAVEIRO PRETA","0","2020-01-21","94.16","1","1","0");
INSERT INTO contas_pagar VALUES("334","59","SAVEIRO BRANCA","0","2020-01-21","45.18","1","1","0");
INSERT INTO contas_pagar VALUES("335","59","SAVEIRO BRANCA","0","2020-01-21","45.18","1","1","0");
INSERT INTO contas_pagar VALUES("336","59","HB-20","0","2020-01-21","358.61","1","1","0");
INSERT INTO contas_pagar VALUES("337","59","SIENA","0","2020-01-21","327.67","1","1","0");
INSERT INTO contas_pagar VALUES("338","54","551847-1/2","0","2019-12-23","553.5","1","1","0");
INSERT INTO contas_pagar VALUES("339","54","551847-2/2","0","2019-12-23","553.5","1","1","0");
INSERT INTO contas_pagar VALUES("340","51","0040951-1","0","2020-01-22","50.28","1","1","0");
INSERT INTO contas_pagar VALUES("341","1","janeiro/2020","0","2019-12-01","2499.26","1","1","0");
INSERT INTO contas_pagar VALUES("342","39","JANEIRO/2020","0","2020-01-01","333.77","1","1","0");
INSERT INTO contas_pagar VALUES("343","6","JANEIRO/2020","0","2020-01-01","73.87","1","1","0");
INSERT INTO contas_pagar VALUES("344","43","","0","2020-01-23","125","1","1","0");
INSERT INTO contas_pagar VALUES("345","44","F - 001/2020","0","2020-01-24","84.93","1","1","0");
INSERT INTO contas_pagar VALUES("346","50","2396/1","0","2019-12-23","1457.3","1","1","0");
INSERT INTO contas_pagar VALUES("347","50","2396/A","0","2019-12-23","1762.74","1","1","0");
INSERT INTO contas_pagar VALUES("348","60","641036309","0","2020-01-01","115.36","1","1","0");
INSERT INTO contas_pagar VALUES("349","60","641036309","0","2020-01-01","115.36","1","1","0");
INSERT INTO contas_pagar VALUES("350","60","641036309","0","2020-01-01","115.36","1","1","0");
INSERT INTO contas_pagar VALUES("351","31","319/U","0","2020-01-28","240.8","1","1","0");
INSERT INTO contas_pagar VALUES("352","32","003238/1-1","0","2020-01-29","329.6","1","1","0");
INSERT INTO contas_pagar VALUES("353","33","EL-000008157/01-01","0","2020-01-30","105","1","1","0");
INSERT INTO contas_pagar VALUES("354","43","","0","2020-01-31","125","1","1","0");
INSERT INTO contas_pagar VALUES("355","34","0058543-2","0","2020-02-03","3305","1","1","0");
INSERT INTO contas_pagar VALUES("356","34","0058544-1","0","2020-02-03","50.79","1","1","0");
INSERT INTO contas_pagar VALUES("357","14","7065284","0","2020-02-03","846.5","1","1","0");
INSERT INTO contas_pagar VALUES("358","45","1","0","2020-02-03","1225.82","1","0","0");
INSERT INTO contas_pagar VALUES("359","45","1","0","2020-02-03","1225.82","1","1","0");
INSERT INTO contas_pagar VALUES("360","24","000597/01","0","2020-02-04","305.71","1","1","0");
INSERT INTO contas_pagar VALUES("361","37","","0","0000-00-00","0","1","1","0");
INSERT INTO contas_pagar VALUES("362","37","20.02.000802.01","0","2020-02-03","8772.58","1","1","0");
INSERT INTO contas_pagar VALUES("363","28","000012243043","0","2020-02-05","82","1","1","0");
INSERT INTO contas_pagar VALUES("364","18","01/2020","0","2020-02-06","1936.98","1","1","0");
INSERT INTO contas_pagar VALUES("365","32","003238/1-1","0","2020-01-28","329.6","1","1","0");
INSERT INTO contas_pagar VALUES("366","41","TAXA M.A","0","2020-02-06","232.85","1","5","0");
INSERT INTO contas_pagar VALUES("367","41","TAXA M.A","0","2020-02-06","232.85","1","1","0");
INSERT INTO contas_pagar VALUES("368","41","TAXA M.A","0","2020-02-06","232.85","1","5","0");
INSERT INTO contas_pagar VALUES("369","41","TAXA A.C","0","2020-02-06","293.3","1","1","0");
INSERT INTO contas_pagar VALUES("370","41","TAXA A.C","0","2020-02-06","295.3","1","5","0");
INSERT INTO contas_pagar VALUES("371","61","0001108","0","2020-02-06","841.5","1","3","0");
INSERT INTO contas_pagar VALUES("372","48","02/2020","0","2020-02-10","527.41","1","1","0");
INSERT INTO contas_pagar VALUES("373","48","02/2020","0","2020-02-10","1632.99","1","1","0");
INSERT INTO contas_pagar VALUES("374","35","02/2020","0","2020-02-10","149.9","1","1","0");
INSERT INTO contas_pagar VALUES("375","51","0042760-8","0","2020-02-11","40.23","1","1","0");
INSERT INTO contas_pagar VALUES("376","31","963","0","2020-02-11","426","1","3","0");
INSERT INTO contas_pagar VALUES("377","2","14721","0","2020-02-12","111.92","1","1","0");
INSERT INTO contas_pagar VALUES("378","29","20.02.000802.01","0","2020-02-13","872.58","1","1","0");
INSERT INTO contas_pagar VALUES("379","2","4390485","0","2020-02-07","354.64","1","1","0");
INSERT INTO contas_pagar VALUES("380","2","4389268","0","2020-02-07","296.19","1","1","0");
INSERT INTO contas_pagar VALUES("381","2","439046","0","2020-02-07","354.64","1","1","0");
INSERT INTO contas_pagar VALUES("382","2","4390487","0","2020-02-07","354.64","1","1","0");
INSERT INTO contas_pagar VALUES("383","62","3261","0","2020-02-17","500","1","2","0");
INSERT INTO contas_pagar VALUES("384","14","7130451","0","2020-02-15","509.5","1","1","0");
INSERT INTO contas_pagar VALUES("385","39","FEVEREIRO/2020","0","2020-02-18","505.33","1","1","0");
INSERT INTO contas_pagar VALUES("386","1","FEVEREIRO/2020","0","2020-02-18","3792.2","1","1","0");
INSERT INTO contas_pagar VALUES("387","29","20.02.002968.01","0","2020-02-17","878.63","1","1","0");
INSERT INTO contas_pagar VALUES("388","22","JANEIRO/2020","0","2020-01-01","443.42","1","1","0");
INSERT INTO contas_pagar VALUES("389","22","FEVEREIRO/2020","0","2020-02-01","309.96","1","1","0");
INSERT INTO contas_pagar VALUES("390","20","JANEIRO/2020","0","2020-02-01","4370.74","1","1","0");
INSERT INTO contas_pagar VALUES("391","2","6059","0","2020-02-12","111.92","1","1","0");
INSERT INTO contas_pagar VALUES("392","2","169097","0","2020-02-12","740.64","1","2","0");
INSERT INTO contas_pagar VALUES("393","2","169754","0","2020-02-24","730.41","1","2","0");
INSERT INTO contas_pagar VALUES("394","31","1243","0","2020-02-27","1237.25","1","3","0");
INSERT INTO contas_pagar VALUES("395","43","","0","2020-02-28","125","1","1","0");
INSERT INTO contas_pagar VALUES("396","24","000607/01","0","2020-02-28","190.1","1","1","0");
INSERT INTO contas_pagar VALUES("397","63","109/00031228-1","0","2020-02-28","105.52","1","1","0");
INSERT INTO contas_pagar VALUES("398","2","169972","0","2020-02-28","346.53","1","1","0");
INSERT INTO contas_pagar VALUES("399","61","0001138","0","2020-02-28","875.5","1","1","0");
INSERT INTO contas_pagar VALUES("400","61","0001138-01","0","2020-02-28","875.5","1","3","0");
INSERT INTO contas_pagar VALUES("401","14","7190431","0","2020-02-29","496.5","1","1","0");
INSERT INTO contas_pagar VALUES("402","24","000615/01","0","2020-03-05","173.95","1","1","0");
INSERT INTO contas_pagar VALUES("403","18","02/2020","0","2020-03-05","2133.91","1","1","0");
INSERT INTO contas_pagar VALUES("404","10","216969803","0","2020-03-05","152","1","1","0");
INSERT INTO contas_pagar VALUES("405","45","1","0","2020-03-05","976.54","1","1","0");
INSERT INTO contas_pagar VALUES("406","29","20.03.000756.01","0","2020-03-02","231.3","1","1","0");
INSERT INTO contas_pagar VALUES("407","36","1055612-1","0","2020-03-03","199.99","1","1","0");
INSERT INTO contas_pagar VALUES("408","28","00637743","0","2020-03-04","46.71","1","1","0");
INSERT INTO contas_pagar VALUES("409","2","8387690","0","2020-01-17","177.94","1","1","0");
INSERT INTO contas_pagar VALUES("410","50","2396/B","0","2019-12-23","1762.74","1","1","0");
INSERT INTO contas_pagar VALUES("411","50","2396/2","0","2019-12-23","1457.3","1","1","0");
INSERT INTO contas_pagar VALUES("412","60","641036309","0","2019-10-18","115.36","1","1","0");
INSERT INTO contas_pagar VALUES("413","34","0061281-2","0","2020-03-10","2960","1","1","0");
INSERT INTO contas_pagar VALUES("414","5","3241-1300","0","2020-02-01","156.01","1","1","0");
INSERT INTO contas_pagar VALUES("415","5","3241-1322","0","2020-02-01","159.75","1","1","0");
INSERT INTO contas_pagar VALUES("416","0","","0","0000-00-00","0","1","1","0");
INSERT INTO contas_pagar VALUES("417","2","4393751","0","2020-03-05","81.6","1","1","0");
INSERT INTO contas_pagar VALUES("418","2","4393751","0","2020-03-05","81.6","1","1","0");
INSERT INTO contas_pagar VALUES("419","2","4394113","0","2020-03-09","383.37","1","1","0");
INSERT INTO contas_pagar VALUES("420","2","4394114","0","2020-03-09","383.37","1","1","0");
INSERT INTO contas_pagar VALUES("421","2","4394114","0","2020-03-09","383.37","1","1","0");
INSERT INTO contas_pagar VALUES("422","1","MARÇO/2020","0","2020-03-02","3923.84","1","1","0");
INSERT INTO contas_pagar VALUES("423","39","MARÇO/2020","0","2020-03-27","501.8","1","1","0");
INSERT INTO contas_pagar VALUES("424","20","FEVEREIRO/2020","0","2020-03-18","2466.54","1","1","0");
INSERT INTO contas_pagar VALUES("425","52","14795","0","2020-03-18","106.2","1","1","0");
INSERT INTO contas_pagar VALUES("426","38","560687","0","2020-03-18","201.18","1","1","0");
INSERT INTO contas_pagar VALUES("427","29","20.03.002663.01","0","2020-03-16","102.42","1","1","0");
INSERT INTO contas_pagar VALUES("428","34","0062694-5","0","2020-03-17","3565.51","1","1","0");
INSERT INTO contas_pagar VALUES("429","34","0062695-3","0","2020-03-17","53.64","1","1","0");
INSERT INTO contas_pagar VALUES("430","22","03/2020","0","2020-04-01","429.1","1","1","0");
INSERT INTO contas_pagar VALUES("431","6","03/2020","0","2020-04-01","73.81","1","1","0");
INSERT INTO contas_pagar VALUES("432","43","","0","2020-03-23","125","1","1","0");
INSERT INTO contas_pagar VALUES("433","14","7249479","0","2020-03-14","466","1","1","0");
INSERT INTO contas_pagar VALUES("434","51","46645-0","0","2020-03-23","422.39","1","1","0");
INSERT INTO contas_pagar VALUES("435","51","0047506-8","0","2020-03-30","60","1","1","0");
INSERT INTO contas_pagar VALUES("436","50","2396/3","0","2019-12-23","1457.3","1","1","0");
INSERT INTO contas_pagar VALUES("437","50","2396/C","0","2019-12-23","1762.76","1","1","0");
INSERT INTO contas_pagar VALUES("438","34","0062694-5","0","2020-04-01","3565.51","1","1","0");
INSERT INTO contas_pagar VALUES("439","28","000802578","0","2020-04-03","99.41","1","1","0");
INSERT INTO contas_pagar VALUES("440","44","F-005/2020","0","2020-04-03","84.93","1","1","0");
INSERT INTO contas_pagar VALUES("441","14","7306404","0","2020-04-01","481","1","1","0");
INSERT INTO contas_pagar VALUES("442","34","0064048-4","0","2020-04-03","1880","1","1","0");
INSERT INTO contas_pagar VALUES("443","29","20.04.000527.01","0","2020-04-01","495.14","1","1","0");
INSERT INTO contas_pagar VALUES("444","31","253630266U","0","2020-04-03","83","1","1","0");
INSERT INTO contas_pagar VALUES("445","18","03/2020","0","2020-04-01","1650.68","1","1","0");
INSERT INTO contas_pagar VALUES("446","10","","0","2020-03-04","155.4","1","1","0");
INSERT INTO contas_pagar VALUES("447","1","abril/2020","0","2020-04-01","2843.59","1","1","0");
INSERT INTO contas_pagar VALUES("448","39","abril/2020","0","2020-04-01","383.93","1","1","0");
INSERT INTO contas_pagar VALUES("449","64","FAT NRO 109736","0","2020-04-15","68.4","1","1","0");
INSERT INTO contas_pagar VALUES("450","33","EL-00008576-01-01","0","2020-04-16","206.4","1","1","0");
INSERT INTO contas_pagar VALUES("451","14","7349381","0","2020-04-16","358.5","1","1","0");
INSERT INTO contas_pagar VALUES("452","20","MARÇO/2020","0","2020-04-20","6386.42","1","1","0");
INSERT INTO contas_pagar VALUES("453","10","224809792","0","2020-04-20","155.04","1","1","0");
INSERT INTO contas_pagar VALUES("454","43","","0","2020-04-23","125","1","1","0");
INSERT INTO contas_pagar VALUES("455","35","22473246","0","2020-04-24","153","1","1","0");
INSERT INTO contas_pagar VALUES("456","2","4396088","0","2020-04-14","355.7","1","1","0");
INSERT INTO contas_pagar VALUES("457","2","4394955","0","2020-03-16","457.98","1","1","0");
INSERT INTO contas_pagar VALUES("458","2","4395796","0","2020-03-23","293.78","1","1","0");
INSERT INTO contas_pagar VALUES("459","2","4386327","0","2019-12-19","761.95","1","1","0");
INSERT INTO contas_pagar VALUES("460","66","14921","0","2020-04-07","472.2","1","1","0");
INSERT INTO contas_pagar VALUES("461","5","abril/2020","0","2020-04-01","159.29","1","1","0");
INSERT INTO contas_pagar VALUES("462","5","abril/2020","0","2020-04-01","155.35","1","1","0");
INSERT INTO contas_pagar VALUES("463","5","abril/2020","0","2020-04-01","155.35","1","1","0");
INSERT INTO contas_pagar VALUES("464","34","0066012-4","0","2020-05-04","220","1","1","0");
INSERT INTO contas_pagar VALUES("465","66","14922","0","2020-04-07","472.2","1","1","0");
INSERT INTO contas_pagar VALUES("466","18","04/2020","0","2020-05-06","1129.71","1","1","0");
INSERT INTO contas_pagar VALUES("467","44","F-007/2020","0","2020-05-06","84.93","1","1","0");
INSERT INTO contas_pagar VALUES("468","44","F-007/2020","0","2020-05-06","84.93","1","1","0");
INSERT INTO contas_pagar VALUES("469","22","04/2020","0","2020-05-01","301.11","1","1","0");
INSERT INTO contas_pagar VALUES("470","10","229769175","0","2020-05-14","152","1","1","0");
INSERT INTO contas_pagar VALUES("471","34","0067015-4","0","2020-05-18","805","1","1","0");
INSERT INTO contas_pagar VALUES("472","51","0051490-0","0","2020-05-18","64.84","1","1","0");
INSERT INTO contas_pagar VALUES("473","29","20.05.002256.01","0","2020-05-18","264.88","1","1","0");
INSERT INTO contas_pagar VALUES("474","29","20.05.002256.01","0","2020-05-18","264.88","1","1","0");
INSERT INTO contas_pagar VALUES("475","36","1106069-2","0","2020-05-19","210.99","1","1","0");
INSERT INTO contas_pagar VALUES("476","36","1106069-2","0","2020-05-19","210.99","1","1","0");
INSERT INTO contas_pagar VALUES("477","45","comisão","0","2020-05-20","491.49","1","1","0");
INSERT INTO contas_pagar VALUES("478","44","F-009/2020","0","2020-05-26","84.93","1","1","0");
INSERT INTO contas_pagar VALUES("479","43","57156709","0","2020-05-26","125","1","1","0");
INSERT INTO contas_pagar VALUES("480","20","ABRIL/2020","0","2020-05-06","1044.16","1","1","0");
INSERT INTO contas_pagar VALUES("481","6","MAIO/2020","0","2020-05-26","74.15","1","1","0");
INSERT INTO contas_pagar VALUES("482","1","MAIO/2020","0","2020-06-07","2055.45","1","1","0");
INSERT INTO contas_pagar VALUES("483","1","MAIO/2020","0","2020-05-26","2055.45","1","1","0");
INSERT INTO contas_pagar VALUES("484","39","MAIO/2020","0","2020-05-26","288.28","1","1","0");
INSERT INTO contas_pagar VALUES("485","5","3241-1322","0","2020-05-27","160.36","1","1","0");
INSERT INTO contas_pagar VALUES("486","22","05/2020","0","2020-06-01","313.92","1","1","0");
INSERT INTO contas_pagar VALUES("487","67","77204","0","2020-06-01","1776.23","1","2","0");
INSERT INTO contas_pagar VALUES("488","45","","0","2020-06-01","1098","1","1","0");
INSERT INTO contas_pagar VALUES("489","14","7529313","0","2020-06-01","160","1","1","0");
INSERT INTO contas_pagar VALUES("490","29","20.06.000477.01","0","2020-06-01","116.42","1","1","0");
INSERT INTO contas_pagar VALUES("491","34","0068073-7","0","2020-06-02","1130.2","1","1","0");
INSERT INTO contas_pagar VALUES("492","18","05/2020","0","2020-06-05","551.94","1","1","0");
INSERT INTO contas_pagar VALUES("493","28","001151314","0","2020-06-05","86.25","1","1","0");
INSERT INTO contas_pagar VALUES("494","7","0034955-1","0","2020-06-05","80","1","1","0");
INSERT INTO contas_pagar VALUES("495","24","000657/01","0","2020-06-08","84.12","1","1","0");
INSERT INTO contas_pagar VALUES("496","7","0035124-5","0","2020-06-10","338.63","1","1","0");
INSERT INTO contas_pagar VALUES("497","35","06/2020","0","2020-06-10","149.9","1","1","0");
INSERT INTO contas_pagar VALUES("498","10","235272149","0","2020-06-15","152","1","1","0");
INSERT INTO contas_pagar VALUES("499","34","0069414-2","0","2020-06-17","1712.05","1","1","0");
INSERT INTO contas_pagar VALUES("500","14","7597983","0","2020-06-17","286.5","1","1","0");
INSERT INTO contas_pagar VALUES("501","29","20.06.002469.01","0","2020-06-17","436.55","1","1","0");
INSERT INTO contas_pagar VALUES("502","36","1128885-5","0","2020-06-17","150.21","1","1","0");
INSERT INTO contas_pagar VALUES("503","63","19457","0","2020-06-17","78.48","1","1","0");
INSERT INTO contas_pagar VALUES("504","2","4402672","0","2020-06-17","340.15","1","1","0");
INSERT INTO contas_pagar VALUES("505","2","4402673","0","2020-06-17","340.14","1","1","0");
INSERT INTO contas_pagar VALUES("506","5","MAIO/2020","0","2020-05-01","158.38","1","1","0");
INSERT INTO contas_pagar VALUES("507","5","JUNHO/2020","0","2020-06-19","149.91","1","1","0");
INSERT INTO contas_pagar VALUES("508","16","0009357114","0","2020-06-22","90.11","1","1","0");
INSERT INTO contas_pagar VALUES("509","20","MAIO/2020","0","2020-06-22","1188.79","1","1","0");
INSERT INTO contas_pagar VALUES("510","31","PD005699-A","0","2020-07-18","196","1","1","0");
INSERT INTO contas_pagar VALUES("511","31","PD005699-A","0","2020-06-22","196","1","1","0");
INSERT INTO contas_pagar VALUES("512","51","0054778-6","0","2020-06-22","65","1","1","0");
INSERT INTO contas_pagar VALUES("513","51","0054778-6","0","2020-06-22","65","1","1","0");
INSERT INTO contas_pagar VALUES("514","22","06/2020","0","2020-06-25","294.74","1","1","0");
INSERT INTO contas_pagar VALUES("515","43","","0","2020-07-02","133.13","1","1","0");
INSERT INTO contas_pagar VALUES("516","43","","0","2020-06-25","133.13","1","1","0");
INSERT INTO contas_pagar VALUES("517","44","F-011/2020","0","2020-06-26","84.93","1","1","0");
INSERT INTO contas_pagar VALUES("518","64","114942","0","2020-06-30","16.5","1","1","0");
INSERT INTO contas_pagar VALUES("519","2","4400735","0","2020-06-30","256.17","1","1","0");
INSERT INTO contas_pagar VALUES("520","6","junho/2020","0","2020-06-30","72.35","1","1","0");
INSERT INTO contas_pagar VALUES("521","5","junho/2020","0","2020-05-01","156.08","1","1","0");
INSERT INTO contas_pagar VALUES("522","45","COMISSÃO","0","2020-06-30","114.68","1","1","0");
INSERT INTO contas_pagar VALUES("523","45","MENSALIDADE","0","2020-06-30","728.85","1","1","0");
INSERT INTO contas_pagar VALUES("524","39","JUNHO/2020","0","2020-07-01","252.59","1","1","0");
INSERT INTO contas_pagar VALUES("525","1","JUNHO/2020","0","2020-07-01","2693.95","1","1","0");
INSERT INTO contas_pagar VALUES("526","52","15446","0","2020-07-01","153.75","1","1","0");
INSERT INTO contas_pagar VALUES("527","34","0070757-1","0","2020-07-02","53.64","1","1","0");
INSERT INTO contas_pagar VALUES("528","29","20.07.000714.01","0","2020-07-02","179.83","1","1","0");
INSERT INTO contas_pagar VALUES("529","34","0070756-2","0","2020-07-02","4950.4","1","1","0");
INSERT INTO contas_pagar VALUES("530","14","7748630","0","2020-07-03","118","1","1","0");
INSERT INTO contas_pagar VALUES("531","18","06/2020","0","2020-07-06","1055.56","1","1","0");
INSERT INTO contas_pagar VALUES("532","69","68678/001-1","0","2020-07-07","190","1","1","0");
INSERT INTO contas_pagar VALUES("533","28","001338820","0","2020-07-07","56.58","1","1","0");
INSERT INTO contas_pagar VALUES("534","70","0002244801","0","2020-07-08","758.43","1","1","0");
INSERT INTO contas_pagar VALUES("535","35","07/2020","0","2020-07-10","149.9","1","1","0");
INSERT INTO contas_pagar VALUES("536","68","78434","0","2020-07-13","1362.5","1","2","0");
INSERT INTO contas_pagar VALUES("537","34","0072332-1","0","0000-00-00","3613.2","1","3613","0");
INSERT INTO contas_pagar VALUES("538","34","0072332-1","0","2020-07-17","3613.2","1","1","0");
INSERT INTO contas_pagar VALUES("539","34","0072332-1","0","2020-07-17","3613.2","1","1","0");
INSERT INTO contas_pagar VALUES("540","29","20.07.002762.01","0","2020-07-17","797.18","1","1","0");
INSERT INTO contas_pagar VALUES("541","14","7792500","0","2020-07-17","309.5","1","1","0");
INSERT INTO contas_pagar VALUES("542","36","11548491","0","2020-07-17","139","1","1","0");
INSERT INTO contas_pagar VALUES("543","5","JULHO/2020","0","2020-07-20","73.88","1","1","0");
INSERT INTO contas_pagar VALUES("544","5","3241-1300","0","2020-07-20","136.18","1","1","0");
INSERT INTO contas_pagar VALUES("545","5","3241-1322","0","2020-07-20","135.03","1","1","0");
INSERT INTO contas_pagar VALUES("546","2","4407210","0","2020-07-24","307.57","1","1","0");
INSERT INTO contas_pagar VALUES("547","2","4407211","0","2020-07-24","307.57","1","1","0");
INSERT INTO contas_pagar VALUES("548","45","","0","2020-07-27","120.67","1","1","0");
INSERT INTO contas_pagar VALUES("549","31","PD005003-A","0","2020-07-27","55","1","1","0");
INSERT INTO contas_pagar VALUES("550","72","0562454-1","0","2020-07-28","153.43","1","1","0");
INSERT INTO contas_pagar VALUES("551","23","03/2020","0","2020-07-28","1738.98","1","1","0");
INSERT INTO contas_pagar VALUES("552","20","06/2020","0","2020-07-28","333.25","1","1","0");
INSERT INTO contas_pagar VALUES("553","39","07/2020","0","2020-07-30","181.39","1","1","0");
INSERT INTO contas_pagar VALUES("554","39","07/2020","0","2020-07-30","181.39","1","1","0");
INSERT INTO contas_pagar VALUES("555","39","07/2020","0","2020-07-30","181.39","1","1","0");
INSERT INTO contas_pagar VALUES("556","1","07/2020","0","2020-07-30","2733.55","1","1","0");
INSERT INTO contas_pagar VALUES("557","48","07/2020","0","0000-00-00","1653.82","1","1","0");
INSERT INTO contas_pagar VALUES("558","48","07/2020","0","2020-07-30","1653.82","1","1","0");
INSERT INTO contas_pagar VALUES("559","48","07/2020","0","2020-07-30","534.44","1","1","0");
INSERT INTO contas_pagar VALUES("560","73","24-19730-2","0","2020-07-30","69.2","1","1","0");
INSERT INTO contas_pagar VALUES("561","73","24-19730-2","0","2020-07-30","745.3","1","1","0");
INSERT INTO contas_pagar VALUES("562","73","24-19730-3","0","2020-07-30","745.3","1","1","0");
INSERT INTO contas_pagar VALUES("563","73","24-19730-4","0","2020-07-30","745.3","1","1","0");
INSERT INTO contas_pagar VALUES("564","34","0073913-8","0","2020-08-03","3961","1","1","0");
INSERT INTO contas_pagar VALUES("565","43","","0","2020-08-03","133.13","1","1","0");
INSERT INTO contas_pagar VALUES("566","45","","0","2020-08-03","828.8","1","1","0");
INSERT INTO contas_pagar VALUES("567","31","PD8240-A","0","2020-08-03","215.07","1","1","0");
INSERT INTO contas_pagar VALUES("568","31","PD8240-A","0","2020-08-03","215.07","1","1","0");
INSERT INTO contas_pagar VALUES("569","29","20.08.000596.01","0","2020-08-04","360.18","1","1","0");
INSERT INTO contas_pagar VALUES("570","18","07/2020","0","2020-08-04","1287.63","1","1","0");
INSERT INTO contas_pagar VALUES("571","14","7866538","0","2020-08-04","575.5","1","1","0");
INSERT INTO contas_pagar VALUES("572","74","000.000.119.401.839-14","0","2020-08-06","512.9","1","1","0");
INSERT INTO contas_pagar VALUES("573","74","000.000.119.401.660-76","0","2020-08-06","566.75","1","1","0");
INSERT INTO contas_pagar VALUES("574","28","001526671","0","2020-08-07","143.64","1","1","0");
INSERT INTO contas_pagar VALUES("575","31","PD008613-A","0","2020-08-08","64","3","1","0");
INSERT INTO contas_pagar VALUES("576","73","16-19769-1","0","2020-08-08","126","1","1","0");
INSERT INTO contas_pagar VALUES("577","73","24-19769-1","0","2020-08-08","1357.86","1","1","0");
INSERT INTO contas_pagar VALUES("578","73","24-19769-2","0","2020-08-08","1358.07","1","1","0");
INSERT INTO contas_pagar VALUES("579","73","24-19769-3","0","2020-08-08","1358.07","1","1","0");
INSERT INTO contas_pagar VALUES("580","23","07/2020","0","2020-08-08","1192.21","1","1","0");
INSERT INTO contas_pagar VALUES("581","2","4409139","0","2020-08-08","545.22","1","1","0");
INSERT INTO contas_pagar VALUES("582","2","4409140","0","2020-08-08","545.21","1","1","0");
INSERT INTO contas_pagar VALUES("583","35","","0","2020-08-10","149.9","1","1","0");
INSERT INTO contas_pagar VALUES("584","2","22155","0","2020-08-13","130.8","1","1","0");
INSERT INTO contas_pagar VALUES("585","2","4409727","0","2020-08-13","238.98","1","1","0");
INSERT INTO contas_pagar VALUES("586","20","07/2020","0","2020-08-13","3484.68","1","1","0");
INSERT INTO contas_pagar VALUES("587","64","120283","0","2020-08-13","33.37","1","1","0");
INSERT INTO contas_pagar VALUES("588","32","004306/1-1","0","2020-08-13","377.2","1","1","0");
INSERT INTO contas_pagar VALUES("589","44","227824 - 07/2020","0","2020-08-14","84.93","1","1","0");
INSERT INTO contas_pagar VALUES("590","34","0076161-3","0","2020-08-18","107.28","1","1","0");
INSERT INTO contas_pagar VALUES("591","34","0076160-5","0","2020-08-18","3757.42","1","1","0");
INSERT INTO contas_pagar VALUES("592","29","20.08.002880.01","0","2020-08-18","607.11","1","1","0");
INSERT INTO contas_pagar VALUES("593","14","7940578","0","2020-08-18","663","1","1","0");
INSERT INTO contas_pagar VALUES("594","69","6973/001-1","0","2020-08-18","190","1","1","0");
INSERT INTO contas_pagar VALUES("595","10","391","0","2020-08-12","155.04","1","1","0");
INSERT INTO contas_pagar VALUES("596","38","4961326820","0","2020-08-20","96.15","1","1","0");
INSERT INTO contas_pagar VALUES("597","31","PD008830-A","0","2020-08-24","40","1","1","0");
INSERT INTO contas_pagar VALUES("598","33","EL-000009230/01-01","0","2020-08-24","120","1","1","0");
INSERT INTO contas_pagar VALUES("599","43","","0","2020-08-25","133.13","1","1","0");
INSERT INTO contas_pagar VALUES("600","44","F-003/2020","0","2020-08-25","84.93","1","1","0");
INSERT INTO contas_pagar VALUES("601","7","0036308-1","0","2020-08-26","170","1","1","0");
INSERT INTO contas_pagar VALUES("602","44","232151","0","2020-08-26","84.93","1","1","0");
INSERT INTO contas_pagar VALUES("603","2","4411270","0","2020-08-26","103","1","1","0");
INSERT INTO contas_pagar VALUES("604","64","FAT NRO 120111","0","2020-08-27","80.1","1","1","0");
INSERT INTO contas_pagar VALUES("605","6","agosto/2020","0","2020-08-28","72.35","1","1","0");
INSERT INTO contas_pagar VALUES("606","48","agosto/2020","0","2020-08-28","333.83","1","1","0");
INSERT INTO contas_pagar VALUES("607","48","agosto/2020","0","2020-08-28","1656.71","1","1","0");
INSERT INTO contas_pagar VALUES("608","48","agosto/2020","0","2020-08-28","535.37","1","1","0");
INSERT INTO contas_pagar VALUES("609","39","agosto/2020","0","2020-08-31","185.95","1","1","0");
INSERT INTO contas_pagar VALUES("610","1","agosto/2020","0","2020-08-31","3107.32","1","1","0");
INSERT INTO contas_pagar VALUES("611","45","agosto/2020","0","2020-08-31","881.26","1","1","0");
INSERT INTO contas_pagar VALUES("612","75","40310194-2","0","2020-08-31","34.25","1","1","0");
INSERT INTO contas_pagar VALUES("613","76","13458262","0","2020-08-31","30.65","1","1","0");
INSERT INTO contas_pagar VALUES("614","63","23204","0","2020-08-31","115","1","1","0");
INSERT INTO contas_pagar VALUES("615","2","4411850","0","2020-08-31","184.64","1","1","0");
INSERT INTO contas_pagar VALUES("616","34","0077978-4","0","2020-09-02","4865","1","1","0");
INSERT INTO contas_pagar VALUES("617","7","0036432-1","0","2020-09-02","150","1","1","0");
INSERT INTO contas_pagar VALUES("618","36","1196782-5","0","2020-09-02","474.88","1","1","0");
INSERT INTO contas_pagar VALUES("619","29","20.09.000574.01","0","2020-09-02","500.33","1","1","0");
INSERT INTO contas_pagar VALUES("620","5","agosto/2020","0","2020-09-02","132.74","1","1","0");
INSERT INTO contas_pagar VALUES("621","5","agosto/2020","0","2020-09-02","133.07","1","1","0");
INSERT INTO contas_pagar VALUES("622","18","08/2020","0","2020-09-03","1460.84","1","1","0");
INSERT INTO contas_pagar VALUES("623","23","08/2020","0","2020-09-03","1368.14","1","1","0");
INSERT INTO contas_pagar VALUES("624","24","000705/01","0","2020-09-03","318.07","1","1","0");
INSERT INTO contas_pagar VALUES("625","2","4412300","0","2020-09-03","395.08","1","1","0");
INSERT INTO contas_pagar VALUES("626","32","4586","0","2020-09-03","1883.5","1","2","0");
INSERT INTO contas_pagar VALUES("627","28","001720019","0","2020-09-04","76.78","1","1","0");
INSERT INTO contas_pagar VALUES("628","73","16-20018-1","0","2020-09-08","88.35","1","1","0");
INSERT INTO contas_pagar VALUES("629","73","24-20018-1","0","2020-09-08","952.3","1","1","0");
INSERT INTO contas_pagar VALUES("630","73","24-2001-2","0","2020-09-08","952.45","1","1","0");
INSERT INTO contas_pagar VALUES("631","73","24-20018-3","0","2020-09-08","952.45","1","1","0");
INSERT INTO contas_pagar VALUES("632","22","08/2020","0","2020-09-09","48.2","1","1","0");
INSERT INTO contas_pagar VALUES("633","7","0036537-8","0","2020-09-09","148","1","1","0");
INSERT INTO contas_pagar VALUES("634","52","15953","0","2020-09-09","146","1","1","0");
INSERT INTO contas_pagar VALUES("635","35","","0","2020-09-10","149.9","1","1","0");
INSERT INTO contas_pagar VALUES("636","78","12106-1/4","0","2020-09-14","7862.18","1","1","0");
INSERT INTO contas_pagar VALUES("637","78","12106-2/4","0","2020-09-14","7862.18","1","1","0");
INSERT INTO contas_pagar VALUES("638","78","12106-3/4","0","2020-09-14","7862.18","1","1","0");
INSERT INTO contas_pagar VALUES("639","78","12106-4/4","0","2020-09-14","7862.16","1","1","0");
INSERT INTO contas_pagar VALUES("640","10","745","0","2020-09-14","152","1","1","0");
INSERT INTO contas_pagar VALUES("641","14","8017717","0","2020-09-14","326.5","1","1","0");
INSERT INTO contas_pagar VALUES("642","7","0036634-0","0","2020-09-16","70","1","1","0");
INSERT INTO contas_pagar VALUES("643","34","0079774-0","0","2020-09-17","4740.3","1","1","0");
INSERT INTO contas_pagar VALUES("644","79","394833460","0","2020-09-17","500","1","1","0");
INSERT INTO contas_pagar VALUES("645","20","AGOSTO/2020","0","2020-09-17","3532.58","1","1","0");
INSERT INTO contas_pagar VALUES("646","14","8094669","0","2020-09-17","332.5","1","1","0");
INSERT INTO contas_pagar VALUES("647","29","20.09.003072.01","0","2020-09-17","376.75","1","1","0");
INSERT INTO contas_pagar VALUES("648","34","0079775-8","0","2020-09-17","53.64","1","1","0");
INSERT INTO contas_pagar VALUES("649","63","2156","0","2020-09-17","230.25","1","1","0");
INSERT INTO contas_pagar VALUES("650","63","24157","0","2020-09-17","230.25","1","1","0");
INSERT INTO contas_pagar VALUES("651","2","4413918","0","2020-09-17","819.45","1","1","0");
INSERT INTO contas_pagar VALUES("652","2","4413918","0","2020-09-17","819.45","1","1","0");
INSERT INTO contas_pagar VALUES("653","2","4413919","0","2020-09-17","819.45","1","1","0");
INSERT INTO contas_pagar VALUES("654","2","4413920","0","2020-09-17","819.44","1","1","0");
INSERT INTO contas_pagar VALUES("655","31","PD010635-A","0","2020-09-17","354.4","1","1","0");
INSERT INTO contas_pagar VALUES("656","31","PD010635-B","0","2020-09-17","354.4","1","1","0");
INSERT INTO contas_pagar VALUES("657","31","PD010635-C","0","2020-09-17","354.4","1","1","0");
INSERT INTO contas_pagar VALUES("658","31","PD010635-D","0","2020-09-17","354.4","1","1","0");
INSERT INTO contas_pagar VALUES("659","31","PD010635-E","0","2020-09-17","354.4","1","1","0");
INSERT INTO contas_pagar VALUES("660","53","0001945498/01-01","0","2020-09-18","222","1","1","0");
INSERT INTO contas_pagar VALUES("661","52","16061","0","2020-09-18","169.5","1","1","0");
INSERT INTO contas_pagar VALUES("662","7","0036707-9","0","2020-09-24","210.06","1","1","0");
INSERT INTO contas_pagar VALUES("663","67","81109-A","0","2020-09-28","861.65","1","1","0");
INSERT INTO contas_pagar VALUES("664","67","81109-B","0","2020-09-28","718","1","1","0");
INSERT INTO contas_pagar VALUES("665","43","","0","2020-09-28","133.13","1","1","0");
INSERT INTO contas_pagar VALUES("666","45","COMISSÃO","0","2020-09-30","57.85","1","1","0");
INSERT INTO contas_pagar VALUES("667","1","SETEMBRO/2020","0","2020-09-30","3111.01","1","1","0");
INSERT INTO contas_pagar VALUES("668","39","SETEMBRO/2020","0","2020-09-30","266.9","1","1","0");
INSERT INTO contas_pagar VALUES("669","22","","0","2020-09-30","849.36","1","1","0");
INSERT INTO contas_pagar VALUES("670","20","PARC. SETEMBRO/2020","0","0000-00-00","334.32","1","1","0");
INSERT INTO contas_pagar VALUES("671","48","SETEMBRO/2020","0","2020-09-30","1659.18","1","1","0");
INSERT INTO contas_pagar VALUES("672","48","SETEMBRO/2020","0","2020-09-30","536.23","1","1","0");
INSERT INTO contas_pagar VALUES("673","49","33354732","0","2020-09-30","40","1","1","0");
INSERT INTO contas_pagar VALUES("674","45","MENSALIDADE E DESP. 09/2020","0","2020-10-01","689.2","1","1","0");
INSERT INTO contas_pagar VALUES("675","5","SETEMBRO - 3241-1322","0","2020-10-02","135.47","1","1","0");
INSERT INTO contas_pagar VALUES("676","6","SETEMBRO/2020","0","2020-10-02","72.35","1","1","0");
INSERT INTO contas_pagar VALUES("677","34","0081709-1","0","2020-10-02","4870","1","1","0");
INSERT INTO contas_pagar VALUES("678","14","8170416","0","2020-10-02","381","1","1","0");
INSERT INTO contas_pagar VALUES("679","29","20.10.000783.01","0","2020-10-02","1054.73","1","1","0");
INSERT INTO contas_pagar VALUES("680","80","107/1","0","2020-10-02","135.7","1","1","0");
INSERT INTO contas_pagar VALUES("681","6","setembro/2020","0","2020-10-02","134.47","1","1","0");
INSERT INTO contas_pagar VALUES("682","69","71318/001-2","0","0000-00-00","680","1","1","0");
INSERT INTO contas_pagar VALUES("683","69","71318/001-2","0","2020-10-05","680","1","1","0");
INSERT INTO contas_pagar VALUES("684","69","71318/002-2","0","2020-10-05","680","1","1","0");
INSERT INTO contas_pagar VALUES("685","2","4412591","0","2020-10-05","46.6","1","1","0");
INSERT INTO contas_pagar VALUES("686","24","000728/01","0","2020-10-05","146.2","1","1","0");
INSERT INTO contas_pagar VALUES("687","18","09/2020","0","2020-10-06","1664.77","1","1","0");
INSERT INTO contas_pagar VALUES("688","18","09/2020","0","2020-10-06","1664.77","1","1","0");
INSERT INTO contas_pagar VALUES("689","74","pac. 04","0","2020-10-06","498.97","1","1","0");
INSERT INTO contas_pagar VALUES("690","23","09/2020","0","2020-10-06","1497.08","1","1","0");
INSERT INTO contas_pagar VALUES("691","7","00369551","0","2020-10-07","55","1","1","0");
INSERT INTO contas_pagar VALUES("692","28","001912533","0","2020-10-07","113.16","1","1","0");
INSERT INTO contas_pagar VALUES("693","2","4416424","0","2020-10-09","69.17","1","1","0");
INSERT INTO contas_pagar VALUES("694","63","25174","0","2020-10-09","138.45","1","1","0");
INSERT INTO contas_pagar VALUES("695","63","25124","0","2020-10-09","303.75","1","1","0");
INSERT INTO contas_pagar VALUES("696","63","25125","0","2020-10-09","303.75","1","1","0");
INSERT INTO contas_pagar VALUES("697","35","10/2020","0","2020-10-13","149.9","1","1","0");
INSERT INTO contas_pagar VALUES("698","10","1176","0","2020-10-14","485","1","152","0");
INSERT INTO contas_pagar VALUES("699","10","1176","0","2020-10-14","152","1","1","0");
INSERT INTO contas_pagar VALUES("700","7","0037074-6","0","2020-10-14","113.09","1","1","0");
INSERT INTO contas_pagar VALUES("701","73","16-20279-1","0","2020-10-14","40.7","1","1","0");
INSERT INTO contas_pagar VALUES("702","73","24-20279-1","0","2020-10-14","438.38","1","1","0");
INSERT INTO contas_pagar VALUES("703","73","24-20279-2","0","2020-10-14","438.46","1","1","0");
INSERT INTO contas_pagar VALUES("704","73","24-20279-3","0","2020-10-14","438.46","1","1","0");
INSERT INTO contas_pagar VALUES("705","73","16-20275-1","0","2020-10-14","124.66","1","1","0");
INSERT INTO contas_pagar VALUES("706","73","16-20275-2","0","2020-10-14","124.67","1","1","0");
INSERT INTO contas_pagar VALUES("707","73","16-20275-3","0","2020-10-14","124.67","1","1","0");
INSERT INTO contas_pagar VALUES("708","73","24-20275-1","0","2020-10-14","4032.92","1","1","0");
INSERT INTO contas_pagar VALUES("709","73","24-20275-2","0","2020-10-14","4033.54","1","1","0");
INSERT INTO contas_pagar VALUES("710","73","24-20275-3","0","2020-10-14","4033.54","1","1","0");
INSERT INTO contas_pagar VALUES("711","24","000728/01","0","2020-10-14","146.2","1","1","0");
INSERT INTO contas_pagar VALUES("712","80","107/1","0","2020-10-14","135.7","1","1","0");
INSERT INTO contas_pagar VALUES("713","66","17581","0","2020-10-14","919.3","1","1","0");
INSERT INTO contas_pagar VALUES("714","66","17582","0","2020-10-14","919.3","1","1","0");
INSERT INTO contas_pagar VALUES("715","44","236584","0","2020-10-14","84.93","1","1","0");
INSERT INTO contas_pagar VALUES("716","63","23881","0","2020-10-16","103","1","1","0");
INSERT INTO contas_pagar VALUES("717","16","0009785396","0","2020-10-19","261","1","1","0");
INSERT INTO contas_pagar VALUES("718","29","20.10.003140.01","0","2020-10-19","440.78","1","1","0");
INSERT INTO contas_pagar VALUES("719","14","8243971","0","2020-10-19","317.5","1","1","0");
INSERT INTO contas_pagar VALUES("720","36","1238937-0","0","2020-10-19","268.36","1","1","0");
INSERT INTO contas_pagar VALUES("721","34","0083393-2","0","2020-10-19","2951.57","1","1","0");
INSERT INTO contas_pagar VALUES("722","20","setembro/2020","0","2020-10-19","5543.27","1","1","0");
INSERT INTO contas_pagar VALUES("723","6","outubro/2020","0","2020-10-19","73.8","1","1","0");
INSERT INTO contas_pagar VALUES("724","24","00737/01","0","2020-10-20","398.52","1","1","0");
INSERT INTO contas_pagar VALUES("725","47","429599226","0","2020-10-22","150","1","1","0");
INSERT INTO contas_pagar VALUES("726","16","0009822216","0","2020-10-28","95.35","1","1","0");
INSERT INTO contas_pagar VALUES("727","7","0037220-0","0","2020-10-28","85","1","1","0");
INSERT INTO contas_pagar VALUES("728","73","16-220399-1","0","2020-10-28","170","1","1","0");
INSERT INTO contas_pagar VALUES("729","73","2420399-1","0","2020-10-28","1833.14","1","1","0");
INSERT INTO contas_pagar VALUES("730","73","24-20399-2","0","2020-10-28","1833.43","1","1","0");
INSERT INTO contas_pagar VALUES("731","73","24-20399-3","0","2020-10-28","1833.43","1","1","0");
INSERT INTO contas_pagar VALUES("732","60","P027095629 - 21-12","0","2020-10-28","115.39","1","1","0");
INSERT INTO contas_pagar VALUES("733","60","P027095629","0","2020-10-28","115.38","1","1","0");
INSERT INTO contas_pagar VALUES("734","60","P02705629 20-02","0","2020-10-28","115.38","1","1","0");
INSERT INTO contas_pagar VALUES("735","60","P027095629 23-3","0","2020-10-28","115.38","1","1","0");
INSERT INTO contas_pagar VALUES("736","60","P027095629 20-04","0","2020-10-28","115.38","1","1","0");
INSERT INTO contas_pagar VALUES("737","45","COMISSÃO","0","2020-10-28","1048.63","1","1","0");
INSERT INTO contas_pagar VALUES("738","5","3241-1300","0","2020-10-22","137.29","1","1","0");
INSERT INTO contas_pagar VALUES("739","5","3241-1322","0","2020-10-22","141.13","1","1","0");
INSERT INTO contas_pagar VALUES("740","20","PARC. 23","0","2020-10-30","334.81","1","1","0");
INSERT INTO contas_pagar VALUES("741","48","OUTUBRO/2020","0","2020-10-30","1661.62","1","1","0");
INSERT INTO contas_pagar VALUES("742","74","OUTUBRO/2020","0","2020-10-30","537.06","1","1","0");
INSERT INTO contas_pagar VALUES("743","14","8316227","0","2020-11-03","1077","1","1","0");
INSERT INTO contas_pagar VALUES("744","39","outubro/2020","0","2020-11-03","355.96","1","1","0");
INSERT INTO contas_pagar VALUES("745","1","outubro/2020","0","2020-11-03","33653.2","1","1","0");
INSERT INTO contas_pagar VALUES("746","80","234/1","0","2020-11-03","72","1","1","0");
INSERT INTO contas_pagar VALUES("747","70","0002375501","0","2020-11-03","1213.48","1","1","0");
INSERT INTO contas_pagar VALUES("748","70","0002375501","0","2020-11-03","1213.48","1","1","0");
INSERT INTO contas_pagar VALUES("749","82","55005497-1/1","0","2020-11-03","513.76","1","1","0");
INSERT INTO contas_pagar VALUES("750","2","4419145","0","2020-11-03","171.39","1","1","0");
INSERT INTO contas_pagar VALUES("751","63","26317","0","2020-11-03","100","1","1","0");
INSERT INTO contas_pagar VALUES("752","31","PD013032-A","0","2020-11-03","203.7","1","1","0");
INSERT INTO contas_pagar VALUES("753","43","","0","2020-11-03","133.13","1","1","0");
INSERT INTO contas_pagar VALUES("754","45","","0","2020-11-03","782.85","1","1","0");
INSERT INTO contas_pagar VALUES("755","23","PARC.","0","2020-11-03","512.9","1","1","0");
INSERT INTO contas_pagar VALUES("756","44","240844","0","2020-11-03","84.93","1","1","0");
INSERT INTO contas_pagar VALUES("757","23","10/2020","0","2020-11-05","1597.03","1","1","0");
INSERT INTO contas_pagar VALUES("758","18","10/2020","0","2020-11-05","1907.93","1","1","0");
INSERT INTO contas_pagar VALUES("759","34","0085354-2","0","2020-11-05","4326","1","1","0");
INSERT INTO contas_pagar VALUES("760","36","1253344-6","0","2020-11-05","185.56","1","1","0");
INSERT INTO contas_pagar VALUES("761","7","0037342-7","0","2020-11-05","140","1","1","0");
INSERT INTO contas_pagar VALUES("762","22","10/2020","0","2020-11-01","512.65","1","1","0");
INSERT INTO contas_pagar VALUES("763","28","002103579","0","2020-11-06","105.58","1","1","0");
INSERT INTO contas_pagar VALUES("764","2","4420030","0","2020-11-09","321.7","1","1","0");
INSERT INTO contas_pagar VALUES("765","2","4420031","0","2020-11-09","321.69","1","1","0");
INSERT INTO contas_pagar VALUES("766","35","","0","2020-11-11","149.9","1","1","0");
INSERT INTO contas_pagar VALUES("767","2","4420802","0","2020-11-13","390.87","1","1","0");
INSERT INTO contas_pagar VALUES("768","2","4420803","0","2020-11-13","390.86","1","1","0");
INSERT INTO contas_pagar VALUES("769","2","4420804","0","2020-11-13","377","1","1","0");
INSERT INTO contas_pagar VALUES("770","32","5204","0","2020-11-13","377.2","1","1","0");
INSERT INTO contas_pagar VALUES("771","10","1837","0","2020-11-16","152","1","1","0");
INSERT INTO contas_pagar VALUES("772","28","002103579","0","2020-11-16","105.58","1","1","0");
INSERT INTO contas_pagar VALUES("773","20","OUTUBRO/2020","0","2020-11-16","4399.84","1","1","0");
INSERT INTO contas_pagar VALUES("774","36","1265265-8","0","2020-11-18","286","1","1","0");
INSERT INTO contas_pagar VALUES("775","34","00871041-4","0","2020-11-17","4539.2","1","1","0");
INSERT INTO contas_pagar VALUES("776","34","0087105-2","0","2020-11-18","53.64","1","1","0");
INSERT INTO contas_pagar VALUES("777","29","20.11.002777.01","0","2020-11-17","340.07","1","1","0");
INSERT INTO contas_pagar VALUES("778","7","0037675-2","0","2020-11-25","298.81","1","1","0");
INSERT INTO contas_pagar VALUES("779","64","VD135512FAT","0","2020-11-26","41.53","1","1","0");
INSERT INTO contas_pagar VALUES("780","80","374/1","0","2020-11-27","133.7","1","1","0");
INSERT INTO contas_pagar VALUES("781","44","244880","0","2020-11-27","84.93","1","1","0");
INSERT INTO contas_pagar VALUES("782","66","18721","0","2020-11-27","856.35","1","1","0");
INSERT INTO contas_pagar VALUES("783","66","18722","0","2020-11-27","856.35","1","1","0");
INSERT INTO contas_pagar VALUES("784","6","NOV/2020","0","2020-11-30","78.9","1","1","0");
INSERT INTO contas_pagar VALUES("785","6","NOV/2020","0","2020-11-30","47.88","1","1","0");
INSERT INTO contas_pagar VALUES("786","22","","0","2020-12-01","351.37","1","1","0");
INSERT INTO contas_pagar VALUES("787","22","","0","2020-12-01","129.91","1","1","0");
INSERT INTO contas_pagar VALUES("788","5","11/2020 - 3241-1300","0","2020-11-01","138.44","1","1","0");
INSERT INTO contas_pagar VALUES("789","5","11/*2020 - 3241-1322","0","2020-11-01","138.22","1","1","0");
INSERT INTO contas_pagar VALUES("790","43","","0","2020-12-02","133.13","1","1","0");
INSERT INTO contas_pagar VALUES("791","45","COMISSÃO","0","2020-12-02","80.78","1","1","0");
INSERT INTO contas_pagar VALUES("792","14","8460518","0","2020-12-02","429","1","1","0");
INSERT INTO contas_pagar VALUES("793","34","0088825-7","0","2020-12-02","60.64","1","1","0");
INSERT INTO contas_pagar VALUES("794","34","0088824-9","0","2020-12-02","4838","1","1","0");
INSERT INTO contas_pagar VALUES("795","1","NOVEMBRO/2020","0","2020-12-02","3868.46","1","1","0");
INSERT INTO contas_pagar VALUES("796","39","NOVEMBRO/2020","0","2020-12-02","319.78","1","1","0");
INSERT INTO contas_pagar VALUES("797","83","1745894","0","2020-12-02","83.93","1","1","0");
INSERT INTO contas_pagar VALUES("798","67","83402","0","2020-12-02","838.04","1","1","0");
INSERT INTO contas_pagar VALUES("799","23","11/2020","0","2020-12-02","2117.25","1","1","0");
INSERT INTO contas_pagar VALUES("800","18","11/2020","0","2020-12-02","1722.99","1","1","0");
INSERT INTO contas_pagar VALUES("801","29","20.12.000668.01","0","2020-12-03","364.51","1","1","0");
INSERT INTO contas_pagar VALUES("802","28","002296571","0","2020-12-03","85.89","1","1","0");
INSERT INTO contas_pagar VALUES("803","84","03122020","0","2020-12-03","556","1","1","0");
INSERT INTO contas_pagar VALUES("804","63","28115","0","2020-12-07","72.6","1","1","0");
INSERT INTO contas_pagar VALUES("805","2","4423488","0","2020-12-07","535.68","1","1","0");
INSERT INTO contas_pagar VALUES("806","2","4423482","0","2020-12-07","108.28","1","1","0");
INSERT INTO contas_pagar VALUES("807","63","27614","0","2020-12-07","96.8","1","1","0");
INSERT INTO contas_pagar VALUES("808","74","parc.","0","2020-12-07","512.9","1","1","0");
INSERT INTO contas_pagar VALUES("809","67","83629","0","2020-12-07","495.55","1","1","0");
INSERT INTO contas_pagar VALUES("810","83","1748703","0","2020-12-08","143.25","1","1","0");
INSERT INTO contas_pagar VALUES("811","45","1","0","2020-12-08","1156.25","1","1","0");
INSERT INTO contas_pagar VALUES("812","45","1","0","2020-12-08","1156.25","1","1","0");
INSERT INTO contas_pagar VALUES("813","18","13/2020","0","2020-12-09","1500.89","1","1","0");
INSERT INTO contas_pagar VALUES("814","7","00379069","0","2020-12-09","170","1","1","0");
INSERT INTO contas_pagar VALUES("815","67","83629","0","2020-12-10","495.55","1","1","0");
INSERT INTO contas_pagar VALUES("816","45","comissão","0","2020-12-11","1389.49","1","1","0");
INSERT INTO contas_pagar VALUES("817","35","","0","2020-12-11","14.9","1","1","0");
INSERT INTO contas_pagar VALUES("818","10","2356","0","2020-12-15","152","1","1","0");
INSERT INTO contas_pagar VALUES("819","29","20.12.001777.01","0","2020-12-15","170.08","1","1","0");
INSERT INTO contas_pagar VALUES("820","29","´20.12.001679.01","0","2020-12-15","81.61","1","1","0");
INSERT INTO contas_pagar VALUES("821","85","144788","0","2020-12-15","2713.84","1","1","0");
INSERT INTO contas_pagar VALUES("822","79","487083124","0","2020-12-15","650","1","1","0");
INSERT INTO contas_pagar VALUES("823","24","00770","0","2020-12-16","73.6","1","1","0");
INSERT INTO contas_pagar VALUES("824","7","0038015-6","0","2020-12-16","674.08","1","1","0");
INSERT INTO contas_pagar VALUES("825","20","NOVEMBRO/2020","0","2020-12-16","7141.6","1","1","0");
INSERT INTO contas_pagar VALUES("826","34","0090603-4","0","2020-12-17","67","1","1","0");
INSERT INTO contas_pagar VALUES("827","34","8559359","0","2020-12-17","409","1","1","0");
INSERT INTO contas_pagar VALUES("828","34","0090602-6","0","2020-12-17","3921","1","1","0");
INSERT INTO contas_pagar VALUES("829","14","8559359","0","2020-12-17","409","1","1","0");
INSERT INTO contas_pagar VALUES("830","79","493809607","0","2020-12-21","500","1","1","0");
INSERT INTO contas_pagar VALUES("831","31","PD015562-A","0","2020-12-21","70","1","1","0");
INSERT INTO contas_pagar VALUES("832","86","814-1/1","0","2020-12-22","609","1","1","0");
INSERT INTO contas_pagar VALUES("833","64","VD 139773 FAT","0","2020-12-29","77.55","1","1","0");
INSERT INTO contas_pagar VALUES("834","48","30/12/2020","0","2020-12-29","1666.38","1","1","0");
INSERT INTO contas_pagar VALUES("835","48","30/12/2020","0","2020-12-30","538.67","1","1","0");
INSERT INTO contas_pagar VALUES("836","20","DEZEMBRO/2020","0","2020-12-29","335.77","1","1","0");
INSERT INTO contas_pagar VALUES("837","43","","0","2020-12-29","133.13","1","1","0");
INSERT INTO contas_pagar VALUES("838","22","M.A BRENSAN","0","2021-01-04","260.46","1","1","0");
INSERT INTO contas_pagar VALUES("839","1","DEZEMBRO/2020","0","2021-01-04","3293.8","1","1","0");
INSERT INTO contas_pagar VALUES("840","1","DEZEMBRO/2020","0","2021-01-04","3293.8","1","1","0");
INSERT INTO contas_pagar VALUES("841","39","DEZEMBRO/2020","0","2021-01-04","375.15","1","1","0");
INSERT INTO contas_pagar VALUES("842","22","DEZEMBRO/2020","0","2021-01-04","132.08","1","1","0");
INSERT INTO contas_pagar VALUES("843","6","DEZEMBRO/2020","0","2021-01-04","135","1","1","0");
INSERT INTO contas_pagar VALUES("844","5","DEZEMBRO/2020","0","2021-01-04","135.47","1","1","0");
INSERT INTO contas_pagar VALUES("845","45","comissão","0","2021-01-04","944.84","1","1","0");
INSERT INTO contas_pagar VALUES("846","14","8599404","0","2021-01-04","50","1","1","0");
INSERT INTO contas_pagar VALUES("847","34","0091995-1","0","2021-01-05","695","1","1","0");
INSERT INTO contas_pagar VALUES("848","29","21.01.000521.01","0","2021-01-05","72.83","1","1","0");
INSERT INTO contas_pagar VALUES("849","44","248860","0","2021-01-05","84.93","1","1","0");
INSERT INTO contas_pagar VALUES("850","63","29133","0","2021-01-06","206.6","1","1","0");
INSERT INTO contas_pagar VALUES("851","2","4425831","0","2021-01-06","203.67","1","1","0");
INSERT INTO contas_pagar VALUES("852","73","16/20773-1","0","2021-01-06","11.34","1","1","0");
INSERT INTO contas_pagar VALUES("853","73","16-20773-2","0","2021-01-06","11.33","1","1","0");
INSERT INTO contas_pagar VALUES("854","73","16-20773-2","0","2021-01-06","11.33","1","1","0");
INSERT INTO contas_pagar VALUES("855","73","16/20773-3","0","2021-01-06","11.33","1","1","0");
INSERT INTO contas_pagar VALUES("856","73","24/20773-1","0","2021-01-06","366.62","1","1","0");
INSERT INTO contas_pagar VALUES("857","73","24-20773-2","0","2021-01-06","366.69","1","1","0");
INSERT INTO contas_pagar VALUES("858","73","24/20773-3","0","2021-01-06","366.69","1","1","0");
INSERT INTO contas_pagar VALUES("859","73","16-20789-1","0","2021-01-06","34","1","1","0");
INSERT INTO contas_pagar VALUES("860","73","24/20789-1","0","2021-01-06","366.62","1","1","0");
INSERT INTO contas_pagar VALUES("861","73","24/20789-2","0","2021-01-06","366.69","1","1","0");
INSERT INTO contas_pagar VALUES("862","73","24/20789-3","0","2021-01-06","366.69","1","1","0");
INSERT INTO contas_pagar VALUES("863","29","2012003282","0","2021-01-06","587.04","1","1","0");
INSERT INTO contas_pagar VALUES("864","28","002487592","0","2021-01-06","41.86","1","1","0");
INSERT INTO contas_pagar VALUES("865","23","12/2020","0","2021-01-01","3145.1","1","1","0");
INSERT INTO contas_pagar VALUES("866","48","","0","0000-00-00","0","1","1","0");
INSERT INTO contas_pagar VALUES("867","48","","0","0000-00-00","0","1","1","0");
INSERT INTO contas_pagar VALUES("868","48","DARF - IRRF","0","2021-01-01","11.51","1","1","0");
INSERT INTO contas_pagar VALUES("869","18","12/2020","0","2021-01-07","2354.49","1","1","0");
INSERT INTO contas_pagar VALUES("870","16","0010071151","0","2021-01-11","107.96","1","1","0");
INSERT INTO contas_pagar VALUES("871","83","1758799","0","2021-01-12","200.25","1","1","0");
INSERT INTO contas_pagar VALUES("872","35","24251951","0","2021-01-12","153.76","1","1","0");
INSERT INTO contas_pagar VALUES("873","10","3014","0","2021-01-14","180","1","1","0");
INSERT INTO contas_pagar VALUES("874","73","16-20867-1","0","2021-01-14","40.7","1","1","0");
INSERT INTO contas_pagar VALUES("875","73","24-20867-1","0","2021-01-14","438.38","1","1","0");
INSERT INTO contas_pagar VALUES("876","73","24-20867-2","0","2021-01-14","438.46","1","1","0");
INSERT INTO contas_pagar VALUES("877","73","24-20867-3","0","2021-01-14","438.46","1","1","0");
INSERT INTO contas_pagar VALUES("878","6","jan/2021","0","2021-01-14","135","1","1","0");
INSERT INTO contas_pagar VALUES("879","20","DEZEMBRO/2020","0","2021-01-14","4308.85","1","1","0");
INSERT INTO contas_pagar VALUES("880","2","4427037","0","2021-01-14","864.19","1","1","0");
INSERT INTO contas_pagar VALUES("881","2","4427038","0","2021-01-14","864.2","1","1","0");
INSERT INTO contas_pagar VALUES("882","2","4427039","0","2021-01-14","864.19","1","1","0");
INSERT INTO contas_pagar VALUES("883","34","0093331-7","0","2021-01-19","2695","1","1","0");
INSERT INTO contas_pagar VALUES("884","34","0093332-5","0","2021-01-19","57","1","1","0");
INSERT INTO contas_pagar VALUES("885","29","21.01.002033.01","0","2021-01-19","578.03","1","1","0");
INSERT INTO contas_pagar VALUES("886","22","EMPRESA","0","2021-01-19","155.88","1","1","0");
INSERT INTO contas_pagar VALUES("887","83","1760913","0","2021-01-19","73.25","1","1","0");
INSERT INTO contas_pagar VALUES("888","5","3241-1322","0","2021-01-20","138.44","1","1","0");
INSERT INTO contas_pagar VALUES("889","5","3241-1300","0","2021-01-20","134.47","1","1","0");
INSERT INTO contas_pagar VALUES("890","22","CASA","0","2021-01-20","190.93","1","1","0");
INSERT INTO contas_pagar VALUES("891","52","17125","0","2021-01-20","97","1","1","0");
INSERT INTO contas_pagar VALUES("892","31","PD016775-A","0","2021-01-20","152","1","1","0");
INSERT INTO contas_pagar VALUES("893","44","252714","0","2021-01-25","87.93","1","1","0");
INSERT INTO contas_pagar VALUES("894","80","614/1","0","2021-01-25","51.4","1","1","0");
INSERT INTO contas_pagar VALUES("895","82","55006607-1/1","0","2021-01-25","597","1","1","0");
INSERT INTO contas_pagar VALUES("896","79","520113561","0","2021-01-26","500","1","1","0");
INSERT INTO contas_pagar VALUES("897","7","0038530-1","0","2021-01-27","160","1","1","0");
INSERT INTO contas_pagar VALUES("898","16","0010127700","0","2021-01-27","151.17","1","1","0");
INSERT INTO contas_pagar VALUES("899","87","NL-000103538/01-01","0","2021-01-27","64.45","1","1","0");
INSERT INTO contas_pagar VALUES("900","31","PD017076-A","0","2021-01-27","212.5","1","1","0");
INSERT INTO contas_pagar VALUES("901","16","0010133483","0","2021-01-28","412.33","1","1","0");
INSERT INTO contas_pagar VALUES("902","31","PD016776-A","0","2021-01-29","89","1","1","0");
INSERT INTO contas_pagar VALUES("903","1","JANEIRO/2021","0","2021-02-01","2779.99","1","1","0");
INSERT INTO contas_pagar VALUES("904","39","JANEIRO/2021","0","2021-02-01","237.65","1","1","0");
INSERT INTO contas_pagar VALUES("905","16","0010139775","0","2021-02-01","297.15","1","1","0");
INSERT INTO contas_pagar VALUES("906","24","039164/01","0","2021-02-01","432.58","1","1","0");
INSERT INTO contas_pagar VALUES("907","14","8649608","0","2021-02-01","290","1","1","0");
INSERT INTO contas_pagar VALUES("908","14","8710292","0","2021-02-01","339","1","1","0");
INSERT INTO contas_pagar VALUES("909","45","","0","2021-02-01","1022.8","1","1","0");
INSERT INTO contas_pagar VALUES("910","43","","0","2021-02-01","133.13","1","1","0");
INSERT INTO contas_pagar VALUES("911","29","21.02.00516.01","0","2021-02-02","144.84","1","1","0");
INSERT INTO contas_pagar VALUES("912","34","00941951-5","0","2021-02-02","4106","1","1","0");
INSERT INTO contas_pagar VALUES("914","2","4429121","0","2021-02-02","71.18","1","1","0");
INSERT INTO contas_pagar VALUES("915","63","30659","0","2021-02-02","123.6","1","1","0");
INSERT INTO contas_pagar VALUES("916","7","0038639-1","0","2021-02-03","75","1","1","0");
INSERT INTO contas_pagar VALUES("917","16","10155398","0","2021-02-03","119.99","1","1","0");
INSERT INTO contas_pagar VALUES("918","64","VD 143390 FAT NRO","0","2021-02-05","69.6","1","1","0");
INSERT INTO contas_pagar VALUES("919","18","01/2021","0","2021-02-05","2164.22","1","1","0");
INSERT INTO contas_pagar VALUES("920","23","01/2021","0","2021-02-05","1947.25","1","1","0");
INSERT INTO contas_pagar VALUES("921","73","16-20836-1","0","2021-02-05","34","1","1","0");
INSERT INTO contas_pagar VALUES("922","73","24-20836-1","0","2021-02-05","366.62","1","1","0");
INSERT INTO contas_pagar VALUES("923","73","24-20836-2","0","2021-02-05","366.69","1","1","0");
INSERT INTO contas_pagar VALUES("924","73","24-20836-3","0","2021-02-05","366.69","1","1","0");
INSERT INTO contas_pagar VALUES("925","48","IRRF 31/01/2021","0","2021-02-08","19.25","1","1","0");
INSERT INTO contas_pagar VALUES("926","73","16/21049-1","0","2021-02-09","40.7","1","1","0");
INSERT INTO contas_pagar VALUES("927","73","24-21049-1","0","2021-02-09","438.38","1","1","0");
INSERT INTO contas_pagar VALUES("928","73","24-21049-2","0","2021-02-09","438.46","1","1","0");
INSERT INTO contas_pagar VALUES("929","73","24-21049-3","0","2021-02-09","438.46","1","1","0");
INSERT INTO contas_pagar VALUES("930","7","0038741-0","0","2021-02-10","270","1","1","0");
INSERT INTO contas_pagar VALUES("931","35","805191-4","0","2021-02-10","149.9","1","1","0");
INSERT INTO contas_pagar VALUES("932","64","VD 144788","0","2021-02-12","71.34","1","1","0");
INSERT INTO contas_pagar VALUES("933","64","VD144788","0","2021-02-12","71.34","1","1","0");
INSERT INTO contas_pagar VALUES("934","45","COMISSÃO","0","2021-02-12","139.08","1","1","0");
INSERT INTO contas_pagar VALUES("935","2","4430603","0","2021-02-12","671.27","1","1","0");
INSERT INTO contas_pagar VALUES("936","2","4430604","0","2021-02-12","671.26","1","1","0");
INSERT INTO contas_pagar VALUES("937","22","EMPRESA","0","2021-02-17","203.45","1","1","0");
INSERT INTO contas_pagar VALUES("938","29","21.02.002608.01","0","2021-02-17","102.31","1","1","0");
INSERT INTO contas_pagar VALUES("939","29","21.02.002805.01","0","2021-02-17","419.25","1","1","0");
INSERT INTO contas_pagar VALUES("940","36","1340136-5","0","2021-02-17","656.21","1","1","0");
INSERT INTO contas_pagar VALUES("941","34","0096702-5","0","2021-02-17","2229","1","1","0");
INSERT INTO contas_pagar VALUES("942","10","3850","0","2021-02-17","183.6","1","1","0");
INSERT INTO contas_pagar VALUES("943","14","8781734","0","2021-02-17","62","1","1","0");
INSERT INTO contas_pagar VALUES("944","20","JANEIRO/2021","0","2021-02-17","4326.76","1","1","0");
INSERT INTO contas_pagar VALUES("945","6","FEV/2021","0","2021-02-18","135","1","1","0");
INSERT INTO contas_pagar VALUES("946","41","M.A BRENSAN","0","2021-02-18","290.43","1","1","0");
INSERT INTO contas_pagar VALUES("947","41","A. C GARCIA","0","2021-02-18","290.43","1","1","0");
INSERT INTO contas_pagar VALUES("948","5","3241-1322","0","2021-02-22","138.22","1","1","0");
INSERT INTO contas_pagar VALUES("949","5","3241-1322","0","2021-02-22","138.22","1","1","0");
INSERT INTO contas_pagar VALUES("950","5","3241-1300","0","2021-02-22","140.45","1","1","0");
INSERT INTO contas_pagar VALUES("951","43","","0","2021-02-23","133.13","1","1","0");
INSERT INTO contas_pagar VALUES("952","44","256982","0","2021-02-24","87.93","1","1","0");
INSERT INTO contas_pagar VALUES("953","2","4427039","0","2021-01-14","864.19","1","1","0");
INSERT INTO contas_pagar VALUES("954","79","539873050","0","2021-02-25","600","1","1","0");
INSERT INTO contas_pagar VALUES("955","14","8841437","0","2021-03-01","450","1","1","0");
INSERT INTO contas_pagar VALUES("956","45","","0","2021-03-01","1171.12","1","1","0");
INSERT INTO contas_pagar VALUES("957","34","0098207-5","0","2021-03-02","68.47","1","1","0");
INSERT INTO contas_pagar VALUES("958","29","21.03.000635.01","0","2021-03-02","607.95","1","1","0");
INSERT INTO contas_pagar VALUES("959","34","0098206-7","0","2021-03-02","2070","1","1","0");
INSERT INTO contas_pagar VALUES("960","1","FEVEREIRO/2021","0","2021-03-02","2774.83","1","1","0");
INSERT INTO contas_pagar VALUES("961","48","FEVEREIRO/2021","0","2021-02-28","337.12","1","1","0");
INSERT INTO contas_pagar VALUES("962","48","FEVEREIRO/2021","0","2021-02-28","540.94","1","1","0");
INSERT INTO contas_pagar VALUES("963","48","FEVEREIRO/2021","0","2021-02-28","1673.11","1","1","0");
INSERT INTO contas_pagar VALUES("964","48","MARÇO/2021","0","2021-03-02","540.94","1","1","0");
INSERT INTO contas_pagar VALUES("965","48","MARÇO/2021","0","2021-03-02","1673.11","1","1","0");
INSERT INTO contas_pagar VALUES("966","22","CASA","0","2021-03-03","148.88","1","1","0");
INSERT INTO contas_pagar VALUES("967","39","FEVEREIRO/2021","0","2021-03-03","267.48","1","1","0");
INSERT INTO contas_pagar VALUES("968","28","002873072","0","2021-03-03","58.61","1","1","0");
INSERT INTO contas_pagar VALUES("969","23","02/2021","0","2021-03-04","2129.45","1","1","0");
INSERT INTO contas_pagar VALUES("970","18","02/2021","0","2021-03-04","2219.82","1","1","0");
INSERT INTO contas_pagar VALUES("971","7","0039141-7","0","2021-03-10","130","1","1","0");
INSERT INTO contas_pagar VALUES("972","88","MARÇO/2021","0","2021-03-11","222.38","1","1","0");
INSERT INTO contas_pagar VALUES("973","28","93731554","0","2021-02-01","64.4","1","1","0");
INSERT INTO contas_pagar VALUES("974","89","144788","0","2020-12-01","2713.84","1","1","0");
INSERT INTO contas_pagar VALUES("975","89","144788","0","2021-03-15","2870.88","1","1","0");
INSERT INTO contas_pagar VALUES("976","20","fevereiro/2021","0","2021-03-15","3306.82","1","1","0");
INSERT INTO contas_pagar VALUES("977","53","961413/01-01","0","2021-03-15","195.8","1","1","0");
INSERT INTO contas_pagar VALUES("978","73","16-21269-1","0","2021-03-16","367.31","1","1","0");
INSERT INTO contas_pagar VALUES("979","73","16-21269-1","0","2021-03-16","367.31","1","1","0");
INSERT INTO contas_pagar VALUES("980","73","24-21269-1","0","2021-03-16","2372.69","1","1","0");
INSERT INTO contas_pagar VALUES("981","73","24-21269-2","0","2021-03-16","2372.7","1","1","0");
INSERT INTO contas_pagar VALUES("982","73","24-21269-3","0","2021-03-16","2372.7","1","1","0");
INSERT INTO contas_pagar VALUES("983","73","24-21269-4","0","2021-03-16","2372.7","1","1","0");
INSERT INTO contas_pagar VALUES("984","73","24-21269-5","0","2021-03-16","2372.7","1","1","0");
INSERT INTO contas_pagar VALUES("985","23","MULTA RESCISÃO MATEUS","0","2021-03-16","1008.94","1","1","0");
INSERT INTO contas_pagar VALUES("986","90","88595","0","2021-03-03","1186.08","1","1","0");
INSERT INTO contas_pagar VALUES("987","34","0100079-9","0","2021-03-17","3426","1","1","0");
INSERT INTO contas_pagar VALUES("988","29","21.03.002605.01","0","2021-03-17","581.37","1","1","0");
INSERT INTO contas_pagar VALUES("989","7","0039259-6","0","2021-03-17","271.03","1","1","0");
INSERT INTO contas_pagar VALUES("990","63","32584","0","2021-03-17","76.85","1","1","0");
INSERT INTO contas_pagar VALUES("991","2","4433496","0","2021-03-17","546.98","1","1","0");
INSERT INTO contas_pagar VALUES("992","2","4433497","0","2021-03-17","546.98","1","1","0");
INSERT INTO contas_pagar VALUES("993","2","4433498","0","2021-03-17","546.98","1","1","0");
INSERT INTO contas_pagar VALUES("994","5","3241-1322","0","2021-03-18","135.47","1","1","0");
INSERT INTO contas_pagar VALUES("995","5","3241-1300","0","2021-03-18","134.47","1","1","0");
INSERT INTO contas_pagar VALUES("996","14","8909485","0","2021-03-18","560","1","1","0");
INSERT INTO contas_pagar VALUES("997","10","4570","0","2021-03-22","183.6","1","1","0");
INSERT INTO contas_pagar VALUES("998","2","4434218","0","2021-03-23","137.17","1","1","0");
INSERT INTO contas_pagar VALUES("999","35","10/02/2021 a 09/03/2021","0","2021-03-24","149.9","1","1","0");
INSERT INTO contas_pagar VALUES("1000","43","","0","2021-03-25","133.13","1","1","0");
INSERT INTO contas_pagar VALUES("1001","91","507118","0","2021-03-25","119.9","1","1","0");
INSERT INTO contas_pagar VALUES("1002","91","507119","0","2021-03-25","119.9","1","1","0");
INSERT INTO contas_pagar VALUES("1003","91","507117","0","2021-03-25","119.9","1","1","0");
INSERT INTO contas_pagar VALUES("1004","91","507120","0","2021-03-25","119.9","1","1","0");
INSERT INTO contas_pagar VALUES("1005","91","507121","0","2021-03-25","119.9","1","1","0");
INSERT INTO contas_pagar VALUES("1006","91","507122","0","2021-03-25","119.9","1","1","0");
INSERT INTO contas_pagar VALUES("1007","91","507123","0","2021-03-25","119.9","1","1","0");
INSERT INTO contas_pagar VALUES("1008","6","03/2021","0","2021-03-25","135","1","1","0");
INSERT INTO contas_pagar VALUES("1009","2","4434785","0","2021-03-29","317.58","1","1","0");
INSERT INTO contas_pagar VALUES("1010","2","4434786","0","2021-03-29","317.58","1","1","0");
INSERT INTO contas_pagar VALUES("1011","22","EMPRESA","0","2021-03-31","277.02","1","1","0");
INSERT INTO contas_pagar VALUES("1012","48","03,/2021","0","2021-03-31","337.12","1","1","0");
INSERT INTO contas_pagar VALUES("1013","79","03/2021","0","2021-03-31","500","1","1","0");
INSERT INTO contas_pagar VALUES("1014","45","03/2021","0","2021-03-31","933.57","1","1","0");
INSERT INTO contas_pagar VALUES("1015","1","03/2021","0","2021-04-01","3189.13","1","1","0");
INSERT INTO contas_pagar VALUES("1016","39","03/2021","0","2021-04-01","381.09","1","1","0");
INSERT INTO contas_pagar VALUES("1017","14","8979769","0","2021-04-05","50","1","1","0");
INSERT INTO contas_pagar VALUES("1018","29","21.04.000699.01","0","2021-04-05","226.86","1","1","0");
INSERT INTO contas_pagar VALUES("1019","34","0101926-1","0","2021-04-05","1025","1","1","0");
INSERT INTO contas_pagar VALUES("1020","36","1374442-4","0","2021-04-05","255","1","1","0");
INSERT INTO contas_pagar VALUES("1021","44","261359","0","2021-04-05","87.93","1","1","0");
INSERT INTO contas_pagar VALUES("1022","23","03/2021","0","2021-04-06","1922.42","1","1","0");
INSERT INTO contas_pagar VALUES("1023","18","03/2021","0","2021-04-06","2136.41","1","1","0");
INSERT INTO contas_pagar VALUES("1024","64","VD 152994","0","2021-04-06","73.58","1","1","0");
INSERT INTO contas_pagar VALUES("1025","45","COMISSÃO","0","2021-04-07","307.01","1","1","0");
INSERT INTO contas_pagar VALUES("1026","35","24856004","0","2021-04-12","149.9","1","1","0");
INSERT INTO contas_pagar VALUES("1027","91","5607118","0","2021-04-12","119.9","1","1","0");
INSERT INTO contas_pagar VALUES("1028","64","VD 153674","0","2021-04-13","142.2","1","1","0");
INSERT INTO contas_pagar VALUES("1029","52","17910","0","2021-04-14","149.25","1","1","0");
INSERT INTO contas_pagar VALUES("1030","7","0039738-5","0","2021-04-14","170","1","1","0");
INSERT INTO contas_pagar VALUES("1031","10","4862","0","2021-04-14","180","1","1","0");
INSERT INTO contas_pagar VALUES("1032","90","2493340","0","2021-04-01","1186.08","1","1","0");
INSERT INTO contas_pagar VALUES("1033","28","003066239","0","2021-04-15","46","1","1","0");
INSERT INTO contas_pagar VALUES("1034","20","03/2021","0","2021-04-19","4171.35","1","1","0");
INSERT INTO contas_pagar VALUES("1035","57","20142A","0","2021-04-19","208.2","1","1","0");
INSERT INTO contas_pagar VALUES("1036","34","0103658-1","0","2021-04-19","2945","1","1","0");
INSERT INTO contas_pagar VALUES("1037","14","9049727","0","2021-04-19","485","1","1","0");
INSERT INTO contas_pagar VALUES("1038","29","21.04.002724.01","0","2021-04-19","754.67","1","1","0");
INSERT INTO contas_pagar VALUES("1039","6","04/2021","0","2021-04-19","135","1","1","0");
INSERT INTO contas_pagar VALUES("1040","5","3241-1300","0","2021-04-20","137.28","1","1","0");
INSERT INTO contas_pagar VALUES("1041","5","3241-1322","0","2021-04-20","135.47","1","1","0");
INSERT INTO contas_pagar VALUES("1042","63","34324","0","2021-04-22","124.13","1","1","0");
INSERT INTO contas_pagar VALUES("1043","2","4437173","0","2021-04-22","486.52","1","1","0");
INSERT INTO contas_pagar VALUES("1044","2","4437174","0","2021-04-22","486.51","1","1","0");
INSERT INTO contas_pagar VALUES("1045","43","","0","2021-04-23","133.13","1","1","0");
INSERT INTO contas_pagar VALUES("1046","79","04/2021","0","2021-04-28","500","1","1","0");
INSERT INTO contas_pagar VALUES("1047","90","3443","0","2021-04-29","1186.08","1","1","0");
INSERT INTO contas_pagar VALUES("1048","43","","0","2021-04-30","133.13","1","1","0");
INSERT INTO contas_pagar VALUES("1049","48","04/2021","0","2021-04-30","337.73","1","1","0");
INSERT INTO contas_pagar VALUES("1050","22","CASA","0","2021-04-30","103.34","1","1","0");
INSERT INTO contas_pagar VALUES("1051","22","EMPRESA","0","2021-04-30","300.52","1","1","0");
INSERT INTO contas_pagar VALUES("1052","48","04/2021","0","2021-04-30","1676.18","1","1","0");
INSERT INTO contas_pagar VALUES("1053","48","04/2021","0","2021-04-30","541.98","1","1","0");
INSERT INTO contas_pagar VALUES("1054","45","mensalidade e despesas","0","2021-04-30","968.82","1","1","0");
INSERT INTO contas_pagar VALUES("1055","79","04/2021","0","2021-04-30","500","1","1","0");
INSERT INTO contas_pagar VALUES("1056","1","04/2021","0","2021-05-03","2528.51","1","1","0");
INSERT INTO contas_pagar VALUES("1057","39","04/2021","0","2021-05-03","328","1","1","0");
INSERT INTO contas_pagar VALUES("1058","14","9115860","0","2021-05-04","791","1","1","0");
INSERT INTO contas_pagar VALUES("1059","29","21.05.000513.01","0","2021-05-04","500.03","1","1","0");
INSERT INTO contas_pagar VALUES("1060","34","0105728-6","0","2021-05-04","2450","1","1","0");
INSERT INTO contas_pagar VALUES("1061","31","PD021427-A","0","2021-05-04","160","1","1","0");
INSERT INTO contas_pagar VALUES("1062","63","34978","0","2021-05-04","74","1","1","0");
INSERT INTO contas_pagar VALUES("1063","2","4438741","0","2021-05-04","458.14","1","1","0");
INSERT INTO contas_pagar VALUES("1064","18","04/2021","0","2021-05-04","1924.55","1","1","0");
INSERT INTO contas_pagar VALUES("1065","7","0040101-3","0","2021-05-05","110.89","1","1","0");
INSERT INTO contas_pagar VALUES("1066","22","04/2021 - EMPRESA","0","2021-05-01","300.52","1","1","0");
INSERT INTO contas_pagar VALUES("1067","44","265932","0","2021-05-05","87.93","1","1","0");
INSERT INTO contas_pagar VALUES("1068","28","003261319","0","2021-05-05","114.37","1","1","0");
INSERT INTO contas_pagar VALUES("1069","23","04/2021","0","2021-05-06","1774.43","1","1","0");
INSERT INTO contas_pagar VALUES("1070","92","0224934-1","0","2021-05-11","45","1","1","0");
INSERT INTO contas_pagar VALUES("1071","35","25087955","0","2021-05-11","149.9","1","1","0");
INSERT INTO contas_pagar VALUES("1072","91","5017119","0","2021-05-11","119.9","1","1","0");
INSERT INTO contas_pagar VALUES("1073","63","35395","0","2021-05-13","62","1","1","0");
INSERT INTO contas_pagar VALUES("1074","10","5345","0","2021-05-14","180","1","1","0");
INSERT INTO contas_pagar VALUES("1075","2","4440065","0","2021-05-14","209.48","1","1","0");
INSERT INTO contas_pagar VALUES("1076","6","05/2021","0","2021-05-17","134.88","1","1","0");
INSERT INTO contas_pagar VALUES("1077","14","9223801","0","2021-05-17","47.5","1","1","0");
INSERT INTO contas_pagar VALUES("1078","20","04/2021","0","2021-05-18","3858.36","1","1","0");
INSERT INTO contas_pagar VALUES("1079","34","0107447-4","0","2021-05-18","2401.01","1","1","0");
INSERT INTO contas_pagar VALUES("1080","29","21.05.002642.01","0","2021-05-18","246.26","1","1","0");
INSERT INTO contas_pagar VALUES("1081","5","maio/2021 - 3241-1322","0","2021-05-19","135.47","1","1","0");
INSERT INTO contas_pagar VALUES("1082","5","maio/2021 - 3241-1300","0","2021-05-19","134.47","1","1","0");
INSERT INTO contas_pagar VALUES("1083","22","EMPRESA","0","2021-05-19","246.69","1","1","0");
INSERT INTO contas_pagar VALUES("1084","45","COMISSÃO","0","2021-05-20","1260.86","1","1","0");
INSERT INTO contas_pagar VALUES("1085","73","16-21658-1","0","2021-05-21","57.22","1","1","0");
INSERT INTO contas_pagar VALUES("1086","73","24-21658-1","0","2021-05-21","616.46","1","1","0");
INSERT INTO contas_pagar VALUES("1087","73","24-21658-2","0","2021-05-21","616.56","1","1","0");
INSERT INTO contas_pagar VALUES("1088","73","24-21658-3","0","2021-05-21","616.56","1","1","0");
INSERT INTO contas_pagar VALUES("1089","90","3443","0","2021-05-24","1186.08","1","1","0");
INSERT INTO contas_pagar VALUES("1090","93","968/84164/01-02\'","0","2021-05-25","495","1","1","0");
INSERT INTO contas_pagar VALUES("1091","93","968/84164/02-02","0","2021-05-25","495","1","1","0");
INSERT INTO contas_pagar VALUES("1092","94","2565522/001","0","2021-05-26","187.35","1","1","0");
INSERT INTO contas_pagar VALUES("1093","94","256522/002","0","2021-05-26","186","1","1","0");
INSERT INTO contas_pagar VALUES("1094","48","05/2021","0","2021-05-28","1679.39","1","1","0");
INSERT INTO contas_pagar VALUES("1095","48","05/2021","0","2021-05-28","543.06","1","1","0");
INSERT INTO contas_pagar VALUES("1096","80","1282/1","0","2021-05-28","49","1","1","0");
INSERT INTO contas_pagar VALUES("1097","64","VD160151","0","2021-05-28","129.87","1","1","0");
INSERT INTO contas_pagar VALUES("1098","45","MENSALIDADE E CUSTA","0","2021-05-31","1084.81","1","1","0");
INSERT INTO contas_pagar VALUES("1099","63","36370","0","2021-05-31","148.5","1","1","0");
INSERT INTO contas_pagar VALUES("1100","2","444199","0","2021-07-05","2209.88","1","1","0");
INSERT INTO contas_pagar VALUES("1101","2","4441909","0","2021-05-31","2209.88","1","1","0");
INSERT INTO contas_pagar VALUES("1102","2","4441909","0","2021-05-31","2209.88","1","1","0");
INSERT INTO contas_pagar VALUES("1103","2","4441910","0","2021-05-31","2209.87","1","1","0");
INSERT INTO contas_pagar VALUES("1104","16","0010561477","0","2021-05-31","124.99","1","1","0");
INSERT INTO contas_pagar VALUES("1105","1","MAIO/2021","0","2021-06-01","2610","1","1","0");
INSERT INTO contas_pagar VALUES("1106","39","MAIO/2021","0","2021-06-01","174.42","1","1","0");
INSERT INTO contas_pagar VALUES("1107","43","","0","2021-06-01","133.13","1","1","0");
INSERT INTO contas_pagar VALUES("1108","23","05/2021","0","2021-06-01","1465.95","1","1","0");
INSERT INTO contas_pagar VALUES("1109","18","05/2021","0","2021-06-01","1559.7","1","1","0");
INSERT INTO contas_pagar VALUES("1110","73","16-21743-1","0","2021-06-01","37.66","1","1","0");
INSERT INTO contas_pagar VALUES("1111","73","24-21743-1","0","2021-06-24","406.08","1","1","0");
INSERT INTO contas_pagar VALUES("1112","73","24-21743-2","0","2021-06-01","406.13","1","1","0");
INSERT INTO contas_pagar VALUES("1113","73","24-21743-3","0","2021-06-01","406.13","1","1","0");
INSERT INTO contas_pagar VALUES("1114","14","9272710","0","2021-06-02","380","1","1","0");
INSERT INTO contas_pagar VALUES("1115","29","21.06.000683.01","0","2021-06-02","275.99","1","1","0");
INSERT INTO contas_pagar VALUES("1116","34","0109197-2","0","2021-06-02","2431.7","1","1","0");
INSERT INTO contas_pagar VALUES("1117","34","0109198-1","0","2021-06-02","390","1","1","0");
INSERT INTO contas_pagar VALUES("1118","36","1425808-6","0","2021-06-02","385.01","1","1","0");
INSERT INTO contas_pagar VALUES("1119","95","169","0","2021-06-02","1000","1","1","0");
INSERT INTO contas_pagar VALUES("1120","95","169B0001","0","2021-06-02","1000","1","1","0");
INSERT INTO contas_pagar VALUES("1121","95","169B0002","0","2021-06-02","1000","1","1","0");
INSERT INTO contas_pagar VALUES("1122","95","169B0002","0","2021-06-02","1000","1","1","0");
INSERT INTO contas_pagar VALUES("1123","95","169B0003","0","2021-06-02","1000","1","1","0");
INSERT INTO contas_pagar VALUES("1124","95","169B0004","0","2021-06-02","1000","1","1","0");
INSERT INTO contas_pagar VALUES("1125","95","169B0005","0","2021-06-02","1000","1","1","0");
INSERT INTO contas_pagar VALUES("1126","28","003455705","0","2021-06-02","62.18","1","1","0");
INSERT INTO contas_pagar VALUES("1127","38","4972699721","0","2021-06-02","77.94","1","1","0");
INSERT INTO contas_pagar VALUES("1128","96","546549","0","2021-06-07","845.5","1","1","0");
INSERT INTO contas_pagar VALUES("1129","44","270461","0","2021-06-08","84.93","1","1","0");
INSERT INTO contas_pagar VALUES("1130","28","003455705","0","2021-06-08","62.18","1","1","0");
INSERT INTO contas_pagar VALUES("1131","7","0040431-4","0","2021-06-09","150","1","1","0");
INSERT INTO contas_pagar VALUES("1132","7","0040648-1","0","2021-06-09","190","1","1","0");
INSERT INTO contas_pagar VALUES("1133","10","5865","0","2021-06-09","875","1","1","0");
INSERT INTO contas_pagar VALUES("1134","1","25284048","0","2021-06-10","149.9","1","1","0");
INSERT INTO contas_pagar VALUES("1135","66","91381","0","2021-06-11","619.5","1","1","0");
INSERT INTO contas_pagar VALUES("1136","66","91382","0","2021-06-11","619.5","1","1","0");
INSERT INTO contas_pagar VALUES("1137","10","5924","0","2021-06-14","180","1","1","0");
INSERT INTO contas_pagar VALUES("1138","10","5947","0","2021-06-14","875","1","1","0");
INSERT INTO contas_pagar VALUES("1139","10","5948","0","2021-06-14","875","1","1","0");
INSERT INTO contas_pagar VALUES("1140","10","5949","0","2021-06-14","875","1","1","0");
INSERT INTO contas_pagar VALUES("1141","6","06/2021","0","2021-06-14","135","1","1","0");
INSERT INTO contas_pagar VALUES("1142","38","4972951921","0","2021-06-14","51.64","1","1","0");
INSERT INTO contas_pagar VALUES("1143","20","maio/2021","0","2021-06-14","3512.85","1","1","0");
INSERT INTO contas_pagar VALUES("1144","69","77523/001-1","0","2021-06-15","300","1","1","0");
INSERT INTO contas_pagar VALUES("1145","87","000108484/01-01","0","2021-06-16","110","1","1","0");
INSERT INTO contas_pagar VALUES("1146","7","0040744-5","0","2021-06-16","130","1","1","0");
INSERT INTO contas_pagar VALUES("1147","24","000859-01","0","2021-06-16","309.21","1","1","0");
INSERT INTO contas_pagar VALUES("1148","24","000859-02","0","2021-06-16","309.21","1","1","0");
INSERT INTO contas_pagar VALUES("1149","29","21.06.002561.01","0","2021-06-17","442.41","1","1","0");
INSERT INTO contas_pagar VALUES("1150","34","0111122-1","0","2021-06-17","3132","1","1","0");
INSERT INTO contas_pagar VALUES("1151","34","0111123-0","0","2021-06-17","55","1","1","0");
INSERT INTO contas_pagar VALUES("1152","14","9342556","0","2021-06-17","550","1","1","0");
INSERT INTO contas_pagar VALUES("1153","43","26","0","2021-06-18","146.44","1","1","0");
INSERT INTO contas_pagar VALUES("1154","5","306/2021 - 3241-1322","0","2021-06-21","135.47","1","1","0");
INSERT INTO contas_pagar VALUES("1155","5","06/2021 - 3241-1300","0","2021-06-21","134.47","1","1","0");
INSERT INTO contas_pagar VALUES("1156","22","06/2021 - SETOR BORRACHA","0","2021-06-21","79.24","1","1","0");
INSERT INTO contas_pagar VALUES("1157","69","77523/001-1","0","2021-06-22","300","1","1","0");
INSERT INTO contas_pagar VALUES("1158","63","37363","0","2021-06-22","158","1","1","0");
INSERT INTO contas_pagar VALUES("1159","52","18514","0","2021-06-22","321.3","1","1","0");
INSERT INTO contas_pagar VALUES("1160","7","0040867-1","0","2021-06-23","241.32","1","1","0");
INSERT INTO contas_pagar VALUES("1161","2","4444496","0","2021-06-23","793.03","1","1","0");
INSERT INTO contas_pagar VALUES("1162","2","4444497","0","2021-06-23","793.03","1","1","0");
INSERT INTO contas_pagar VALUES("1163","2","4444498","0","2021-06-23","793.02","1","1","0");
INSERT INTO contas_pagar VALUES("1164","22","06/2021","0","2021-06-24","79.48","1","1","0");
INSERT INTO contas_pagar VALUES("1165","45","COMISSÃO","0","2021-06-25","52.92","1","1","0");
INSERT INTO contas_pagar VALUES("1166","20","PARC. 06/2021","0","2021-06-29","339.2","1","1","0");
INSERT INTO contas_pagar VALUES("1167","18","PARC. 06/2021","0","2021-06-29","544.46","1","1","0");
INSERT INTO contas_pagar VALUES("1168","20","PARC. 06/2021","0","2021-06-29","1683.53","1","1","0");
INSERT INTO contas_pagar VALUES("1169","79","06/2021","0","2021-06-29","500","1","1","0");
INSERT INTO contas_pagar VALUES("1170","16","0010664811","0","2021-06-30","350","1","1","0");
INSERT INTO contas_pagar VALUES("1171","22","FAB. QUALDROS","0","2021-06-30","239.18","1","1","0");
INSERT INTO contas_pagar VALUES("1172","90","3443","0","2021-06-30","1194.64","1","1","0");
INSERT INTO contas_pagar VALUES("1173","73","16-21945-1","0","2021-06-30","116.18","1","1","0");
INSERT INTO contas_pagar VALUES("1174","73","16-21945-2","0","2021-06-30","116.21","1","1","0");
INSERT INTO contas_pagar VALUES("1175","73","16-21945-3","0","2021-06-30","116.21","1","1","0");
INSERT INTO contas_pagar VALUES("1176","73","24-21945-1","0","2021-06-30","3760.2","1","1","0");
INSERT INTO contas_pagar VALUES("1177","73","24-21945-2","0","2021-06-30","3760.75","1","1","0");
INSERT INTO contas_pagar VALUES("1178","73","24-21945-3","0","2021-06-30","3760.75","1","1","0");
INSERT INTO contas_pagar VALUES("1179","34","0112996-1","0","2021-07-02","2149.55","1","1","0");
INSERT INTO contas_pagar VALUES("1180","37","21.07.000710.01","0","2021-07-02","463.63","1","1","0");
INSERT INTO contas_pagar VALUES("1181","45","MENSALIDADE E DESP.","0","2021-07-02","925","1","1","0");
INSERT INTO contas_pagar VALUES("1182","1","06/2021","0","2021-07-02","2684.3","1","1","0");
INSERT INTO contas_pagar VALUES("1183","39","06/2021","0","2021-07-02","203.67","1","1","0");
INSERT INTO contas_pagar VALUES("1184","14","9412112","0","2021-07-05","320","1","1","0");
INSERT INTO contas_pagar VALUES("1185","2","4445698","0","2021-07-05","415","1","1","0");
INSERT INTO contas_pagar VALUES("1186","63","38140","0","2021-07-05","99.9","1","1","0");
INSERT INTO contas_pagar VALUES("1187","23","06/2021","0","2021-07-06","1429.44","1","1","0");
INSERT INTO contas_pagar VALUES("1188","18","06/2021","0","2021-07-06","1527.59","1","1","0");
INSERT INTO contas_pagar VALUES("1189","31","PD022897-A","0","2021-07-06","220.08","1","1","0");
INSERT INTO contas_pagar VALUES("1190","64","VD166718","0","2021-07-12","112.61","1","1","0");
INSERT INTO contas_pagar VALUES("1191","64","VD166718","0","2021-07-12","112.61","1","1","0");
INSERT INTO contas_pagar VALUES("1192","35","07/2021","0","2021-07-12","149.9","1","1","0");
INSERT INTO contas_pagar VALUES("1193","2","4446511","0","2021-07-12","553.78","1","1","0");
INSERT INTO contas_pagar VALUES("1194","24","000875/01","0","2021-07-13","262.85","1","1","0");
INSERT INTO contas_pagar VALUES("1195","24","000875/02","0","2021-07-13","262.85","1","1","0");
INSERT INTO contas_pagar VALUES("1196","24","000875/03","0","2021-07-13","262.85","1","1","0");
INSERT INTO contas_pagar VALUES("1197","24","000875/03","0","2021-07-13","262.85","1","1","0");
INSERT INTO contas_pagar VALUES("1198","24","000875/04","0","2021-07-13","262.85","1","1","0");
INSERT INTO contas_pagar VALUES("1199","6","07/2021","0","2021-07-13","135","1","1","0");
INSERT INTO contas_pagar VALUES("1200","28","003648630","0","2021-07-14","148.8","1","1","0");
INSERT INTO contas_pagar VALUES("1201","10","6478","0","2021-07-14","180","1","1","0");
INSERT INTO contas_pagar VALUES("1202","44","F-012/2021","0","2021-07-14","87.93","1","1","0");
INSERT INTO contas_pagar VALUES("1203","36","1461276-9","0","2021-07-19","158.29","1","1","0");
INSERT INTO contas_pagar VALUES("1204","29","21.07.002763.01","0","2021-07-19","189.09","1","1","0");
INSERT INTO contas_pagar VALUES("1205","34","0114861-3","0","2021-07-19","4030","1","1","0");
INSERT INTO contas_pagar VALUES("1206","34","0114862-1","0","2021-07-19","848.25","1","1","0");
INSERT INTO contas_pagar VALUES("1207","66","22171","0","2021-07-19","345.3","1","1","0");
INSERT INTO contas_pagar VALUES("1208","66","22172","0","2021-07-19","345.3","1","1","0");
INSERT INTO contas_pagar VALUES("1209","73","16-22077-1","0","2021-07-19","171","1","1","0");
INSERT INTO contas_pagar VALUES("1210","73","24-22077-1","0","2021-07-19","1842.88","1","1","0");
INSERT INTO contas_pagar VALUES("1211","73","24-22077-2","0","2021-07-19","1843.16","1","1","0");
INSERT INTO contas_pagar VALUES("1212","73","24-22077-3","0","2021-07-19","1843.16","1","1","0");
INSERT INTO contas_pagar VALUES("1213","14","9483844","0","2021-07-19","290","1","1","0");
INSERT INTO contas_pagar VALUES("1214","43","","0","2021-07-19","146.44","1","1","0");
INSERT INTO contas_pagar VALUES("1215","87","109806/01-01","0","2021-07-19","155.5","1","1","0");
INSERT INTO contas_pagar VALUES("1216","87","109806/01-01","0","2021-07-19","155.5","1","1","0");
INSERT INTO contas_pagar VALUES("1217","20","JUNHO/2021","0","2021-07-19","4143.2","1","1","0");
INSERT INTO contas_pagar VALUES("1219","32","7246-02","0","2021-07-20","997.17","1","1","0");
INSERT INTO contas_pagar VALUES("1220","32","7246-03","0","2021-07-20","997.17","1","1","0");
INSERT INTO contas_pagar VALUES("1221","7","0041125-6","0","2021-07-21","388.29","1","1","0");
INSERT INTO contas_pagar VALUES("1222","7","0041370-4","0","2021-07-21","681.39","1","1","0");
INSERT INTO contas_pagar VALUES("1223","52","1876","0","2021-07-21","292.6","1","1","0");
INSERT INTO contas_pagar VALUES("1224","22","EMPRESA","0","2021-07-21","219.78","1","1","0");
INSERT INTO contas_pagar VALUES("1225","22","SETOR BORRACHA","0","2021-07-21","79.67","1","1","0");
INSERT INTO contas_pagar VALUES("1226","32","7246-01","0","2021-07-21","997.16","1","1","0");
INSERT INTO contas_pagar VALUES("1227","32","7246-02","0","2021-07-21","997.17","1","1","0");
INSERT INTO contas_pagar VALUES("1228","32","7246-03","0","2021-07-21","997.17","1","1","0");
INSERT INTO contas_pagar VALUES("1229","5","06/2021 - 3241-1300","0","2021-07-22","134.47","1","1","0");
INSERT INTO contas_pagar VALUES("1230","5","06/2021 - 3241-1322","0","2021-07-22","135.47","1","1","0");
INSERT INTO contas_pagar VALUES("1231","22","CASA","0","2021-07-22","72.06","1","1","0");
INSERT INTO contas_pagar VALUES("1233","2","4447851","0","2021-07-22","506.01","1","1","0");
INSERT INTO contas_pagar VALUES("1234","2","4447852","0","2021-07-22","506.01","1","1","0");
INSERT INTO contas_pagar VALUES("1235","2","4447853","0","2021-07-22","506.01","1","1","0");
INSERT INTO contas_pagar VALUES("1236","31","PD26346-A","0","2021-07-23","506.38","1","1","0");
INSERT INTO contas_pagar VALUES("1237","87","110084/01-01","0","2021-07-26","82","1","1","0");
INSERT INTO contas_pagar VALUES("1238","90","2534461","0","2021-07-26","1250.64","1","1","0");
INSERT INTO contas_pagar VALUES("1239","90","2534461","0","2021-07-26","1250.64","1","1","0");
INSERT INTO contas_pagar VALUES("1240","98","RC-001172","0","2021-07-26","176","1","1","0");
INSERT INTO contas_pagar VALUES("1241","99","622","0","2021-07-27","3400","1","1","0");
INSERT INTO contas_pagar VALUES("1242","45","COMISSÃO","0","2021-07-28","34.21","1","1","0");
INSERT INTO contas_pagar VALUES("1243","45","MENSALIDADE E DESPESAS","0","2021-07-29","1109.52","1","1","0");
INSERT INTO contas_pagar VALUES("1244","80","1575/1","0","2021-07-29","87.75","1","1","0");
INSERT INTO contas_pagar VALUES("1245","43","","0","2021-07-30","146.44","1","1","0");
INSERT INTO contas_pagar VALUES("1246","43","","0","2021-07-30","146.44","1","1","0");
INSERT INTO contas_pagar VALUES("1247","24","881/01","0","2021-07-30","68.64","1","1","0");
INSERT INTO contas_pagar VALUES("1248","1","07/2021","0","2021-07-30","3114.94","1","1","0");
INSERT INTO contas_pagar VALUES("1249","39","07/2021","0","2021-07-30","325.4","1","1","0");
INSERT INTO contas_pagar VALUES("1250","64","VD 170279","0","2021-07-30","69.75","1","1","0");
INSERT INTO contas_pagar VALUES("1251","53","973843/01","0","2021-08-02","152.9","1","1","0");
INSERT INTO contas_pagar VALUES("1252","52","18695","0","2021-08-02","284.35","1","1","0");
INSERT INTO contas_pagar VALUES("1253","52","18695","0","2021-08-02","284.35","1","1","0");
INSERT INTO contas_pagar VALUES("1254","29","21.08.000528.01","0","2021-08-03","500.38","1","1","0");
INSERT INTO contas_pagar VALUES("1255","92","0002414805","0","2021-08-03","55","1","1","0");
INSERT INTO contas_pagar VALUES("1256","36","1468994-0","0","2021-08-03","214.82","1","1","0");
INSERT INTO contas_pagar VALUES("1257","34","0117032-5","0","2021-08-03","3191.1","1","0","0");
INSERT INTO contas_pagar VALUES("1258","34","0117032-5","0","2021-08-03","3191.1","1","1","0");
INSERT INTO contas_pagar VALUES("1259","24","000881/01","0","2021-08-04","68.64","1","1","0");
INSERT INTO contas_pagar VALUES("1261","23","07/2021","0","2021-08-05","1875.28","1","1","0");
INSERT INTO contas_pagar VALUES("1262","18","07/2021","0","2021-08-05","1967.02","1","1","0");
INSERT INTO contas_pagar VALUES("1263","28","003841128","0","2021-08-05","209.86","1","1","0");
INSERT INTO contas_pagar VALUES("1264","44","F-014/2021","0","2021-08-05","87.93","1","1","0");
INSERT INTO contas_pagar VALUES("1265","7","0041466-2","0","2021-08-09","61.66","1","1","0");
INSERT INTO contas_pagar VALUES("1266","100","047","0","2021-08-10","323.4","1","1","0");
INSERT INTO contas_pagar VALUES("1268","7","041705-0","0","2021-08-11","130","1","1","0");
INSERT INTO contas_pagar VALUES("1269","16","0010809479","0","2021-08-11","128.87","1","1","0");
INSERT INTO contas_pagar VALUES("1270","2","4450593","0","2021-08-13","294.47","1","1","0");
INSERT INTO contas_pagar VALUES("1271","14","9556081","0","2021-08-13","350","1","1","0");
INSERT INTO contas_pagar VALUES("1272","6","08/2001","0","2021-08-13","135","1","1","0");
INSERT INTO contas_pagar VALUES("1273","2","4449817","0","2021-08-13","843.09","1","1","0");
INSERT INTO contas_pagar VALUES("1274","2","449818","0","2021-08-13","843.09","1","1","0");
INSERT INTO contas_pagar VALUES("1275","63","39919","0","2021-08-16","56.1","1","1","0");
INSERT INTO contas_pagar VALUES("1276","10","7244","0","2021-08-16","180","1","1","0");
INSERT INTO contas_pagar VALUES("1277","14","9627486","0","2021-08-16","370","1","1","0");
INSERT INTO contas_pagar VALUES("1278","52","520529","0","2021-08-16","300.3","1","1","0");
INSERT INTO contas_pagar VALUES("1279","29","21.08.002779.01","0","2021-08-17","576.06","1","1","0");
INSERT INTO contas_pagar VALUES("1280","92","0002444101","0","2021-08-17","190.14","1","0","0");
INSERT INTO contas_pagar VALUES("1281","92","0002444101","0","2021-08-17","190.14","1","1","0");
INSERT INTO contas_pagar VALUES("1282","34","0119031-8","0","2021-08-17","2971.5","1","1","0");
INSERT INTO contas_pagar VALUES("1283","20","07/2021","0","2021-08-17","7424.5","1","1","0");
INSERT INTO contas_pagar VALUES("1284","5","agosto/2021","0","2021-08-18","141.93","1","1","0");
INSERT INTO contas_pagar VALUES("1285","5","agosto/2021","0","2021-08-18","139.14","1","1","0");
INSERT INTO contas_pagar VALUES("1286","87","17/019","0","2021-08-18","82","1","1","0");
INSERT INTO contas_pagar VALUES("1288","22","setor borracha","0","2021-08-20","77.6","1","1","0");
INSERT INTO contas_pagar VALUES("1289","63","39091","0","2021-08-11","109.75","1","1","0");
INSERT INTO contas_pagar VALUES("1290","22","EMPRESA","0","2021-08-23","268.28","1","1","0");
INSERT INTO contas_pagar VALUES("1291","64","VD171240 1/12 FAT","0","2021-08-11","13.05","1","1","0");
INSERT INTO contas_pagar VALUES("1292","35","25689358","0","2021-08-25","149.28","1","1","0");
INSERT INTO contas_pagar VALUES("1293","64","VD 171240","0","2021-08-25","143.55","1","11","0");
INSERT INTO contas_pagar VALUES("1294","48","08/2021","0","2021-08-25","1693.79","1","1","0");
INSERT INTO contas_pagar VALUES("1295","48","08/2021","0","2021-08-25","547.92","1","1","0");
INSERT INTO contas_pagar VALUES("1297","2","4452043","0","2021-08-26","1973.79","1","1","0");
INSERT INTO contas_pagar VALUES("1298","2","4452043","0","2021-08-26","1973.79","1","3","0");
INSERT INTO contas_pagar VALUES("1299","22","CASA","0","2021-08-27","288.74","1","1","0");
INSERT INTO contas_pagar VALUES("1300","101","1118","0","2021-08-27","720","1","2","0");
INSERT INTO contas_pagar VALUES("1301","1","1","1","2021-09-01","122","1","1","0");
INSERT INTO contas_pagar VALUES("1303","64","23257","0","2021-09-01","98.1","1","1","0");
INSERT INTO contas_pagar VALUES("1304","45","MENSALIDADE E DESPESAS","0","2021-09-02","971","1","1","0");
INSERT INTO contas_pagar VALUES("1305","63","41062","0","2021-09-02","125.32","1","1","0");
INSERT INTO contas_pagar VALUES("1306","2","4452485","0","2021-09-02","608.81","1","1","0");
INSERT INTO contas_pagar VALUES("1307","2","4452486","0","2021-09-02","608.8","1","1","0");
INSERT INTO contas_pagar VALUES("1308","80","1728/1","0","2021-09-02","220.5","1","1","0");
INSERT INTO contas_pagar VALUES("1309","90","3343","0","2021-09-02","1503.11","1","1","0");
INSERT INTO contas_pagar VALUES("1310","1","08/2021","0","2021-09-02","3613.93","1","1","0");
INSERT INTO contas_pagar VALUES("1311","39","08/2021","0","2021-09-02","256.47","1","1","0");
INSERT INTO contas_pagar VALUES("1312","73","16-22407-1","0","2021-09-02","92.5","1","1","0");
INSERT INTO contas_pagar VALUES("1313","73","24-22407-1","0","2021-09-02","996.1","1","1","0");
INSERT INTO contas_pagar VALUES("1314","73","24-22407-2","0","2021-09-02","996.25","1","1","0");
INSERT INTO contas_pagar VALUES("1315","73","24-22407-3","0","2021-09-02","996.25","1","1","0");
INSERT INTO contas_pagar VALUES("1316","34","0121158-7","0","2021-09-02","4296.87","1","1","0");
INSERT INTO contas_pagar VALUES("1317","29","21.09.000561.01","0","2021-09-02","860.42","1","1","0");
INSERT INTO contas_pagar VALUES("1318","45","comissão","0","2021-09-01","1739.01","1","1","0");
INSERT INTO contas_pagar VALUES("1319","43","","0","2021-08-31","146.44","1","1","0");
INSERT INTO contas_pagar VALUES("1320","41","5712/2021","0","2021-09-02","517.63","1","1","0");
INSERT INTO contas_pagar VALUES("1321","41","5712/2021","0","2021-09-02","517.63","1","2","0");
INSERT INTO contas_pagar VALUES("1322","41","5718/2021","0","2021-09-02","1947.47","1","12","0");
INSERT INTO contas_pagar VALUES("1323","41","5715/2021","0","2021-09-02","1399.45","1","12","0");
INSERT INTO contas_pagar VALUES("1324","41","5714/2021","0","2021-09-02","1817.01","1","12","0");
INSERT INTO contas_pagar VALUES("1325","41","5711/2021","0","2021-09-02","2156.36","1","12","0");
INSERT INTO contas_pagar VALUES("1326","41","5717/2021","0","2021-09-02","2519.83","1","12","0");
INSERT INTO contas_pagar VALUES("1327","23","08/2021","0","2021-09-03","1900.43","1","1","0");
INSERT INTO contas_pagar VALUES("1328","18","08/2021","0","2021-09-03","1995.18","1","1","0");
INSERT INTO contas_pagar VALUES("1329","28","4031729","0","2021-09-06","93.83","1","1","0");
INSERT INTO contas_pagar VALUES("1330","94","264143","0","2021-09-06","830","1","1","0");
INSERT INTO contas_pagar VALUES("1331","94","264143","0","2021-09-06","830","1","3","0");
INSERT INTO contas_pagar VALUES("1332","102","2210","0","2021-09-08","809.5","1","2","0");
INSERT INTO contas_pagar VALUES("1333","7","0042160-0","0","2021-09-09","199.7","1","1","0");
INSERT INTO contas_pagar VALUES("1334","63","41561","0","2021-09-10","58","1","1","0");
INSERT INTO contas_pagar VALUES("1335","2","4453595","0","2021-09-10","32.67","1","1","0");
INSERT INTO contas_pagar VALUES("1336","10","7689","0","2021-09-14","180","1","1","0");
INSERT INTO contas_pagar VALUES("1337","44","f-016/2021","0","2021-09-14","87.93","1","1","0");
INSERT INTO contas_pagar VALUES("1338","7","0042261-4","0","2021-09-15","598.05","1","1","0");
INSERT INTO contas_pagar VALUES("1339","24","000908/01","0","2021-09-16","247.19","1","1","0");
INSERT INTO contas_pagar VALUES("1340","34","0123236-3","0","2021-09-17","2817.44","1","1","0");
INSERT INTO contas_pagar VALUES("1341","29","21.09.002720.01","0","2021-09-17","395","1","1","0");
INSERT INTO contas_pagar VALUES("1343","14","9779391","0","2021-09-17","694.81","1","1","0");
INSERT INTO contas_pagar VALUES("1344","43","","0","2021-09-17","146.44","1","1","0");
INSERT INTO contas_pagar VALUES("1345","20","08/2021","0","2021-09-20","6654.74","1","1","0");
INSERT INTO contas_pagar VALUES("1346","5","09/2021 - 3241-1300","0","2021-09-20","146.9","1","1","0");
INSERT INTO contas_pagar VALUES("1347","5","09/2021 - 3241-1322","0","2021-09-20","146.9","1","1","0");
INSERT INTO contas_pagar VALUES("1348","22","09/2021 - BORRACHA","0","2021-09-21","77.6","1","1","0");
INSERT INTO contas_pagar VALUES("1349","22","09/2021 - QUADROS","0","2021-09-21","307.12","1","1","0");
INSERT INTO contas_pagar VALUES("1350","22","09/2021 - casa","0","2021-09-22","124.26","1","1","0");
INSERT INTO contas_pagar VALUES("1351","35","25891908","0","2021-09-14","149.9","1","1","0");
INSERT INTO contas_pagar VALUES("1352","90","3443","0","2021-09-27","1194.64","1","1","0");
INSERT INTO contas_pagar VALUES("1353","63","42235","0","2021-09-27","74.8","1","1","0");
INSERT INTO contas_pagar VALUES("1354","2","445544","0","2021-09-27","1885.55","1","3","0");
INSERT INTO contas_pagar VALUES("1355","31","PD030224","0","2021-09-27","206","1","2","0");
INSERT INTO contas_pagar VALUES("1356","48","09/2021","0","2021-09-27","1700.37","1","1","0");
INSERT INTO contas_pagar VALUES("1357","48","09/2021","0","2021-09-27","550.14","1","1","0");
INSERT INTO contas_pagar VALUES("1358","79","688957195","0","2021-09-28","500","1","1","0");
INSERT INTO contas_pagar VALUES("1359","45","comissão","0","2021-09-28","401.33","1","1","0");
INSERT INTO contas_pagar VALUES("1360","39","09/2021","0","2021-09-30","212.77","1","1","0");
INSERT INTO contas_pagar VALUES("1361","1","09/2021","0","2021-09-30","3839.25","1","1","0");
INSERT INTO contas_pagar VALUES("1362","45","desp. mensalidade","0","2021-09-30","966.6","1","1","0");
INSERT INTO contas_pagar VALUES("1363","31","PD030574-A","0","2021-10-04","53","1","1","0");
INSERT INTO contas_pagar VALUES("1364","29","21.10.000524.01","0","2021-10-04","223.09","1","1","0");
INSERT INTO contas_pagar VALUES("1365","34","0125282-8","0","2021-10-04","270","1","1","0");
INSERT INTO contas_pagar VALUES("1366","34","0125281-0","0","2021-10-04","3687.1","1","1","0");
INSERT INTO contas_pagar VALUES("1367","36","1505139-6","0","2021-10-04","353","1","1","0");
INSERT INTO contas_pagar VALUES("1368","44","F-018/2021","0","2021-10-05","87.93","1","1","0");
INSERT INTO contas_pagar VALUES("1369","18","09/2021","0","2021-10-06","2014.68","1","1","0");
INSERT INTO contas_pagar VALUES("1370","7","0042613-0","0","2021-10-06","150","1","1","0");
INSERT INTO contas_pagar VALUES("1371","74","09/2021","0","2021-10-07","1917.78","1","1","0");
INSERT INTO contas_pagar VALUES("1372","28","004211701","0","2021-10-11","102.7","1","1","0");
INSERT INTO contas_pagar VALUES("1373","35","6087231","0","2021-10-11","149.9","1","1","0");
INSERT INTO contas_pagar VALUES("1375","7","0042729-2","0","2021-10-18","90","1","1","0");
INSERT INTO contas_pagar VALUES("1376","16","0011036287","0","2021-10-18","693.6","1","1","0");
INSERT INTO contas_pagar VALUES("1377","24","000925/01","0","2021-10-18","336.46","1","1","0");
INSERT INTO contas_pagar VALUES("1378","14","9924744","0","2021-10-18","200","1","1","0");
INSERT INTO contas_pagar VALUES("1379","20","09/2021","0","2021-10-18","4973.71","1","1","0");
INSERT INTO contas_pagar VALUES("1380","2","4457715","0","2021-10-18","843.36","1","2","0");
INSERT INTO contas_pagar VALUES("1381","6","10/2021","0","2021-10-18","135","1","1","0");
INSERT INTO contas_pagar VALUES("1382","34","0127641-7","0","2021-10-19","3118.17","1","1","0");
INSERT INTO contas_pagar VALUES("1383","60","426006","0","2021-10-20","555.53","1","4","0");
INSERT INTO contas_pagar VALUES("1384","22","SETOR BORRACHA","0","2021-10-20","79.17","1","1","0");
INSERT INTO contas_pagar VALUES("1385","22","FABRICA","0","2021-10-20","245.41","1","1","0");
INSERT INTO contas_pagar VALUES("1386","7","0042960-1","0","2021-10-27","335","1","1","0");
INSERT INTO contas_pagar VALUES("1387","2","4458809","0","2021-10-27","453.87","1","1","0");
INSERT INTO contas_pagar VALUES("1388","63","43577","0","2021-10-27","81","1","1","0");
INSERT INTO contas_pagar VALUES("1389","91","102015","0","2021-10-13","119.9","1","1","0");
INSERT INTO contas_pagar VALUES("1390","91","","0","2021-10-27","119.9","1","1","0");
INSERT INTO contas_pagar VALUES("1391","48","10/2021","0","2021-10-28","1707.11","1","1","0");
INSERT INTO contas_pagar VALUES("1392","48","10/2021","0","2021-10-28","1707.11","1","1","0");
INSERT INTO contas_pagar VALUES("1393","48","10/2021","0","2021-10-28","552.41","1","1","0");
INSERT INTO contas_pagar VALUES("1394","45","MENSALIDADE E DESPESAS","0","2021-10-29","803.24","1","1","0");
INSERT INTO contas_pagar VALUES("1395","45","COMISSÃO","0","2021-10-29","205","1","1","0");
INSERT INTO contas_pagar VALUES("1396","43","","0","2021-10-29","146.44","1","1","0");
INSERT INTO contas_pagar VALUES("1397","22","CASA","0","2021-10-29","367.7","1","1","0");
INSERT INTO contas_pagar VALUES("1398","1","10/2021","0","2021-11-01","3677.3","1","1","0");
INSERT INTO contas_pagar VALUES("1399","39","10/2021","0","2021-11-01","238.93","1","1","0");
INSERT INTO contas_pagar VALUES("1400","14","9995485","0","2021-11-01","617","1","1","0");
INSERT INTO contas_pagar VALUES("1401","29","21.11.000705.01","0","2021-11-03","308.27","1","1","0");
INSERT INTO contas_pagar VALUES("1402","18","10/2021","0","2021-11-03","2682.82","1","1","0");
INSERT INTO contas_pagar VALUES("1403","34","0129233-1","0","2021-11-03","3574.17","1","1","0");
INSERT INTO contas_pagar VALUES("1404","24","934/01","0","2021-11-03","278.91","1","1","0");
INSERT INTO contas_pagar VALUES("1405","90","3443","0","2021-11-03","1223.64","1","1","0");
INSERT INTO contas_pagar VALUES("1406","28","4381835","0","2021-11-04","134.35","1","1","0");
INSERT INTO contas_pagar VALUES("1407","28","4381835","0","2021-11-04","134.35","1","1","0");
INSERT INTO contas_pagar VALUES("1408","23","10/2021","0","2021-11-05","2511.88","1","1","0");
INSERT INTO contas_pagar VALUES("1409","52","19796","0","2021-11-08","161.5","1","1","0");
INSERT INTO contas_pagar VALUES("1410","2","4459594","0","2021-11-08","263.87","1","1","0");
INSERT INTO contas_pagar VALUES("1411","24","934/01","0","2021-11-08","278.91","1","1","0");
INSERT INTO contas_pagar VALUES("1412","44","F-020/2021","0","2021-11-08","87.93","1","1","0");
INSERT INTO contas_pagar VALUES("1413","29","2110002847","0","2021-11-01","449.76","1","1","0");
INSERT INTO contas_pagar VALUES("1414","7","43187-7","0","2021-11-10","170","1","1","0");
INSERT INTO contas_pagar VALUES("1415","35","26281004","0","2021-11-10","141.16","1","1","0");
INSERT INTO contas_pagar VALUES("1416","103","221946767-4","0","2021-11-10","411.12","1","1","0");
INSERT INTO contas_pagar VALUES("1417","104","2802604","0","2021-11-10","32.24","1","1","0");
INSERT INTO contas_pagar VALUES("1418","5","10/2021 - 3241-1300","0","2021-10-20","146.9","1","1","0");
INSERT INTO contas_pagar VALUES("1419","5","10/2021 - 3241-1322","0","2021-10-20","146.9","1","1","0");
INSERT INTO contas_pagar VALUES("1420","105","1/5244","0","2021-11-11","1251.6","1","1","0");
INSERT INTO contas_pagar VALUES("1421","14","10067170","0","2021-11-16","481.5","1","1","0");
INSERT INTO contas_pagar VALUES("1422","6","celular","0","2021-11-16","133.56","1","1","0");
INSERT INTO contas_pagar VALUES("1423","64","30152","0","2021-11-17","98.1","1","1","0");
INSERT INTO contas_pagar VALUES("1424","16","11161031","0","2021-11-17","301.69","1","1","0");
INSERT INTO contas_pagar VALUES("1425","29","21.11.002577.01","0","2021-11-17","524.77","1","1","0");
INSERT INTO contas_pagar VALUES("1426","34","0131499-8","0","2021-11-17","2495.97","1","1","0");
INSERT INTO contas_pagar VALUES("1427","34","0131500-5","0","2021-11-17","75","1","1","0");
INSERT INTO contas_pagar VALUES("1428","7","0043301-2","0","2021-11-17","60","1","1","0");
INSERT INTO contas_pagar VALUES("1429","36","1534425-3","0","2021-11-17","175","1","1","0");
INSERT INTO contas_pagar VALUES("1430","92","0002631954","0","2021-11-17","70","1","1","0");
INSERT INTO contas_pagar VALUES("1431","73","16-22951-1","0","2021-11-18","49","1","1","0");
INSERT INTO contas_pagar VALUES("1432","73","24-22951-1","0","2021-11-18","527.79","1","1","0");
INSERT INTO contas_pagar VALUES("1433","73","24-22951-2","0","2021-11-18","527.88","1","1","0");
INSERT INTO contas_pagar VALUES("1434","73","24-22951-3","0","2021-11-18","527.88","1","1","0");
INSERT INTO contas_pagar VALUES("1435","5","11/2021 - 3241-1300","0","2021-11-18","146.9","1","1","0");
INSERT INTO contas_pagar VALUES("1436","5","11/2021 - 3241-1322","0","2021-11-18","146.9","1","1","0");
INSERT INTO contas_pagar VALUES("1437","20","10/2021","0","2021-11-18","4906.98","1","1","0");
INSERT INTO contas_pagar VALUES("1438","43","","0","2021-11-18","146.44","1","1","0");
INSERT INTO contas_pagar VALUES("1439","22","SETOR BORRACHA","0","2021-11-19","77.6","1","1","0");
INSERT INTO contas_pagar VALUES("1440","2","4461470","0","2021-11-22","70.43","1","1","0");
INSERT INTO contas_pagar VALUES("1441","2","4461682","0","2021-11-23","371.51","1","1","0");
INSERT INTO contas_pagar VALUES("1442","2","4461683","0","2021-11-23","371.51","1","1","0");
INSERT INTO contas_pagar VALUES("1443","63","44697","0","2021-11-23","50","1","1","0");
INSERT INTO contas_pagar VALUES("1444","64","VD196688","0","2021-11-23","101.52","1","1","0");
INSERT INTO contas_pagar VALUES("1445","31","PD33405","0","2021-11-23","4986.31","1","4","0");
INSERT INTO contas_pagar VALUES("1446","52","19855","0","2021-11-23","262.5","1","1","0");
INSERT INTO contas_pagar VALUES("1447","22","SANEPAR CASA","0","2021-11-30","326.96","1","1","0");
INSERT INTO contas_pagar VALUES("1448","64","VD 198386","0","2021-11-30","7.42","1","1","0");
INSERT INTO contas_pagar VALUES("1449","45","comissão","0","2021-11-30","515.6","1","1","0");
INSERT INTO contas_pagar VALUES("1450","48","11/2021","0","2021-11-30","1714.62","1","1","0");
INSERT INTO contas_pagar VALUES("1451","48","11/2021","0","2021-11-30","554.94","1","1","0");
INSERT INTO contas_pagar VALUES("1452","24","000948/01","0","2021-11-30","501.88","1","1","0");
INSERT INTO contas_pagar VALUES("1453","39","11/2021","0","2021-12-01","329.73","1","1","0");
INSERT INTO contas_pagar VALUES("1454","1","11/2021","0","2021-12-01","4042.57","1","1","0");
INSERT INTO contas_pagar VALUES("1455","31","PD033401-A","0","2021-12-01","182.15","1","1","0");
INSERT INTO contas_pagar VALUES("1456","14","10147208","0","2021-12-02","744.5","1","1","0");
INSERT INTO contas_pagar VALUES("1457","29","21.12.000545.01","0","2021-12-02","795.33","1","1","0");
INSERT INTO contas_pagar VALUES("1458","36","1544920-9","0","2021-12-02","349.98","1","1","0");
INSERT INTO contas_pagar VALUES("1459","34","0133375-5","0","2021-12-02","3391.02","1","1","0");
INSERT INTO contas_pagar VALUES("1460","28","004545959","0","2021-12-02","103.82","1","1","0");
INSERT INTO contas_pagar VALUES("1461","100","0056","0","2021-12-03","540.95","1","1","0");
INSERT INTO contas_pagar VALUES("1462","44","f-022/2021","0","2021-12-03","87.93","1","1","0");
INSERT INTO contas_pagar VALUES("1463","90","3443","0","2021-12-03","1194.64","1","1","0");
INSERT INTO contas_pagar VALUES("1464","2","4462799","0","2021-12-06","487.24","1","1","0");
INSERT INTO contas_pagar VALUES("1465","103","221986858-9","0","2021-12-06","411.12","1","1","0");
INSERT INTO contas_pagar VALUES("1466","2","4463296","0","2021-12-06","493.27","1","1","0");
INSERT INTO contas_pagar VALUES("1467","22","EMPRESA","0","2021-12-07","222.3","1","1","0");
INSERT INTO contas_pagar VALUES("1468","45","DESP. MENSALIDADE","0","2021-12-07","831.65","1","1","0");
INSERT INTO contas_pagar VALUES("1469","80","2225/1","0","2021-12-07","29.4","1","1","0");
INSERT INTO contas_pagar VALUES("1470","73","16-23115-1","0","2021-12-07","26.35","1","1","0");
INSERT INTO contas_pagar VALUES("1471","73","24-23115-1","0","2021-12-07","425.6","1","1","0");
INSERT INTO contas_pagar VALUES("1472","73","24-23115-2","0","2021-12-07","425.6","1","1","0");
INSERT INTO contas_pagar VALUES("1473","23","11/2021","0","2021-12-07","3304.75","1","1","0");
INSERT INTO contas_pagar VALUES("1474","23","11/2021","0","2021-12-07","3304.75","1","1","0");
INSERT INTO contas_pagar VALUES("1475","7","0043640-2","0","2021-12-08","120","1","1","0");
INSERT INTO contas_pagar VALUES("1476","18","11/2021","0","2021-12-08","2748.18","1","1","0");
INSERT INTO contas_pagar VALUES("1477","35","26471386","0","2021-12-10","149.69","1","1","0");
INSERT INTO contas_pagar VALUES("1478","18","13 salario","0","2021-12-13","1756.44","1","1","0");
INSERT INTO contas_pagar VALUES("1479","87","115666/01-01","0","2021-12-13","135","1","1","0");
INSERT INTO contas_pagar VALUES("1480","102","2287","0","2021-12-14","421.6","1","1","0");
INSERT INTO contas_pagar VALUES("1481","102","2287","0","2021-11-12","400","1","1","0");
INSERT INTO contas_pagar VALUES("1482","10","10687","0","2021-12-14","180","1","1","0");
INSERT INTO contas_pagar VALUES("1483","20","11/2021","0","2021-12-14","3971.49","1","1","0");
INSERT INTO contas_pagar VALUES("1484","85","144788","0","2021-12-15","5234.91","1","1","0");
INSERT INTO contas_pagar VALUES("1485","7","0043765-4","0","2021-12-15","196.72","1","1","0");
INSERT INTO contas_pagar VALUES("1486","24","000957/01","0","2021-12-16","82.54","1","1","0");
INSERT INTO contas_pagar VALUES("1487","48","12/2021","0","2021-12-30","1723.65","1","1","0");
INSERT INTO contas_pagar VALUES("1488","106","764243204","0","2021-12-21","469.97","1","1","0");
INSERT INTO contas_pagar VALUES("1489","5","3241-1322","0","2021-12-01","146.9","1","1","0");
INSERT INTO contas_pagar VALUES("1490","5","3241-1300","0","2021-12-01","153.63","1","1","0");
INSERT INTO contas_pagar VALUES("1491","36","1557765-7","0","2021-12-30","250","1","1","0");
INSERT INTO contas_pagar VALUES("1492","34","0135780-8","0","2021-12-30","2504.28","1","1","0");
INSERT INTO contas_pagar VALUES("1493","29","21.12.003815.01","0","2021-12-30","361.64","1","1","0");
INSERT INTO contas_pagar VALUES("1494","45","","0","2021-12-30","981.45","1","1","0");
INSERT INTO contas_pagar VALUES("1495","7","0043874-0","0","2021-12-30","130","1","1","0");
INSERT INTO contas_pagar VALUES("1496","43","","0","2022-01-03","146.44","1","1","0");
INSERT INTO contas_pagar VALUES("1497","22","12/2021","0","2022-01-03","423.17","1","1","0");
INSERT INTO contas_pagar VALUES("1498","90","3443","0","2022-01-01","1297.63","1","1","0");
INSERT INTO contas_pagar VALUES("1499","22","BORRACHA","0","2022-01-03","79.26","1","1","0");
INSERT INTO contas_pagar VALUES("1500","14","10292325","0","2022-01-04","246","1","1","0");
INSERT INTO contas_pagar VALUES("1501","103","222027037-4","0","2022-01-04","411.12","1","1","0");
INSERT INTO contas_pagar VALUES("1502","6","DEZ/2021","0","2022-01-04","135","1","1","0");
INSERT INTO contas_pagar VALUES("1503","2","4465539","0","2022-01-05","1032.86","1","1","0");
INSERT INTO contas_pagar VALUES("1504","2","4465539","0","2022-01-04","1032.86","1","1","0");
INSERT INTO contas_pagar VALUES("1505","2","4465540","0","2022-01-04","1032.86","1","1","0");
INSERT INTO contas_pagar VALUES("1506","2","4465541","0","2022-01-04","1032.86","1","1","0");
INSERT INTO contas_pagar VALUES("1507","2","4465546","0","2022-01-04","253.06","1","1","0");
INSERT INTO contas_pagar VALUES("1508","31","PD033994-A","0","2022-01-04","108.5","1","1","0");
INSERT INTO contas_pagar VALUES("1509","39","12/2021","0","2022-01-05","470.63","1","1","0");
INSERT INTO contas_pagar VALUES("1510","1","12/2021","0","2022-01-05","2586.03","1","1","0");
INSERT INTO contas_pagar VALUES("1511","63","46290","0","2022-01-05","151.6","1","1","0");
INSERT INTO contas_pagar VALUES("1512","44","F-001/2021","0","2022-01-05","93.88","1","1","0");
INSERT INTO contas_pagar VALUES("1513","45","COMISSÃO","0","2022-01-03","160.29","1","1","0");
INSERT INTO contas_pagar VALUES("1514","23","12/2021","0","2022-01-05","3130.06","1","1","0");
INSERT INTO contas_pagar VALUES("1515","18","12/2021","0","2022-01-05","2395.03","1","1","0");
INSERT INTO contas_pagar VALUES("1516","28","6304","0","2022-01-06","46","1","1","0");
INSERT INTO contas_pagar VALUES("1517","80","2378/1","0","2022-01-07","214.3","1","1","0");
INSERT INTO contas_pagar VALUES("1518","73","16-23244-1","0","2022-01-10","119.25","1","1","0");
INSERT INTO contas_pagar VALUES("1519","73","16-23244-2","0","2022-01-10","119.25","1","1","0");
INSERT INTO contas_pagar VALUES("1520","73","24-23244-1","0","2022-01-10","2570.24","1","1","0");
INSERT INTO contas_pagar VALUES("1521","73","24-23244-2","0","2022-01-10","2570.63","1","1","0");
INSERT INTO contas_pagar VALUES("1522","73","24-23244-3","0","2022-01-10","2570.63","1","1","0");
INSERT INTO contas_pagar VALUES("1523","73","16-23256-1","0","2022-01-10","52.7","1","1","0");
INSERT INTO contas_pagar VALUES("1524","73","24-23256-1","0","2022-01-10","567.4","1","1","0");
INSERT INTO contas_pagar VALUES("1525","73","24-23256-2","0","2022-01-10","567.5","1","1","0");
INSERT INTO contas_pagar VALUES("1526","73","24-23256-3","0","2022-01-10","567.5","1","1","0");
INSERT INTO contas_pagar VALUES("1527","2","4466003","0","2022-01-10","522.1","1","1","0");
INSERT INTO contas_pagar VALUES("1528","10","","0","2022-01-13","190","1","1","0");
INSERT INTO contas_pagar VALUES("1529","14","10350140","0","2022-01-17","62.5","1","1","0");
INSERT INTO contas_pagar VALUES("1530","6","","0","2022-01-17","135","1","1","0");
INSERT INTO contas_pagar VALUES("1531","29","21.00.000983.01","0","2022-01-18","375.47","1","1","0");
INSERT INTO contas_pagar VALUES("1532","34","0138480-5","0","2022-01-18","172.5","1","1","0");
INSERT INTO contas_pagar VALUES("1533","107","A1 168 1","0","2021-11-19","334.9","1","1","0");
INSERT INTO contas_pagar VALUES("1534","31","PD035702-A","0","2022-01-18","71","1","1","0");
INSERT INTO contas_pagar VALUES("1535","20","12/2021","0","2022-01-19","1802.18","1","1","0");
INSERT INTO contas_pagar VALUES("1536","22","01/2022","0","2022-01-19","288.74","1","1","0");
INSERT INTO contas_pagar VALUES("1537","5","01/2022 - 3241-1300","0","2022-01-19","146.9","1","1","0");
INSERT INTO contas_pagar VALUES("1538","5","01/2022 - 3241-1322","0","2022-01-19","146.9","1","1","0");
INSERT INTO contas_pagar VALUES("1539","43","","0","2022-01-19","146.44","1","1","0");
INSERT INTO contas_pagar VALUES("1540","22","01/2022 - BORRACHA","0","2022-01-19","77.6","1","1","0");
INSERT INTO contas_pagar VALUES("1541","24","000974/01","0","2022-01-20","206.48","1","0","0");
INSERT INTO contas_pagar VALUES("1542","24","000974/01","0","2022-01-20","206.48","1","1","0");
INSERT INTO contas_pagar VALUES("1543","108","641096353","0","2021-12-01","2003.5","1","10","0");
INSERT INTO contas_pagar VALUES("1544","108","480795","0","2022-01-21","1414.35","1","9","0");
INSERT INTO contas_pagar VALUES("1545","7","0044116-3","0","2022-01-12","353.72","1","1","0");
INSERT INTO contas_pagar VALUES("1546","34","0138479-1","0","2022-01-01","1702.86","1","1","0");
INSERT INTO contas_pagar VALUES("1547","31","PD036498-A","0","2022-01-25","179.22","1","1","0");
INSERT INTO contas_pagar VALUES("1548","109","12651-B","0","2022-01-25","1649.86","1","1","0");
INSERT INTO contas_pagar VALUES("1549","2","4467856","0","2022-01-26","423.81","1","1","0");
INSERT INTO contas_pagar VALUES("1550","2","4467857","0","2022-01-26","423.81","1","1","0");
INSERT INTO contas_pagar VALUES("1551","2","4467858","0","2022-01-26","423.81","1","1","0");
INSERT INTO contas_pagar VALUES("1552","107","UN 2935 1","0","2022-01-26","110.3","1","1","0");
INSERT INTO contas_pagar VALUES("1553","45","COMISSÃO","0","2022-01-28","194.05","1","1","0");
INSERT INTO contas_pagar VALUES("1554","66","25181","0","2022-01-28","925.95","1","0","0");
INSERT INTO contas_pagar VALUES("1557","31","PD036760-C","0","2022-01-28","96.98","1","1","0");
INSERT INTO contas_pagar VALUES("1558","31","PD036760-B","0","2022-01-28","96.98","1","1","0");
INSERT INTO contas_pagar VALUES("1559","31","PD036760-A","0","2022-01-28","96.99","1","1","0");
INSERT INTO contas_pagar VALUES("1560","52","20538","0","2022-01-28","377.25","1","1","0");
INSERT INTO contas_pagar VALUES("1561","52","20538","0","2022-01-28","377.25","1","1","0");
INSERT INTO contas_pagar VALUES("1562","111","028564","0","2022-01-28","121.05","1","1","0");
INSERT INTO contas_pagar VALUES("1563","45","DESPESA MENSALIDADE","0","2022-01-28","999.75","1","1","0");
INSERT INTO contas_pagar VALUES("1564","48","01/2022","0","2022-01-28","1735.44","1","1","0");
INSERT INTO contas_pagar VALUES("1565","22","01/2022","0","2022-01-28","106.59","1","1","0");
INSERT INTO contas_pagar VALUES("1566","41","TAXA MOBIL. 2022","0","2022-01-31","250.32","1","1","0");
INSERT INTO contas_pagar VALUES("1567","1","01/2022","0","2022-02-01","1709.37","1","1","0");
INSERT INTO contas_pagar VALUES("1568","39","01/2022","0","2022-02-01","313.84","1","1","0");
INSERT INTO contas_pagar VALUES("1569","80","2580/1","0","2022-02-01","59.7","1","1","0");
INSERT INTO contas_pagar VALUES("1570","34","0140241-2","0","2022-02-02","58","1","1","0");
INSERT INTO contas_pagar VALUES("1571","14","10421494","0","2022-02-02","739","1","1","0");
INSERT INTO contas_pagar VALUES("1572","36","1589159-9","0","2022-02-02","200","1","1","0");
INSERT INTO contas_pagar VALUES("1573","7","0044412-0","0","2022-02-02","85","1","1","0");
INSERT INTO contas_pagar VALUES("1574","34","0140240-4","0","2022-02-02","4471.97","1","1","0");
INSERT INTO contas_pagar VALUES("1575","18","01/2022","0","2022-02-03","2073.58","1","1","0");
INSERT INTO contas_pagar VALUES("1576","23","01/2022","0","2022-02-03","1950.98","1","1","0");
INSERT INTO contas_pagar VALUES("1577","90","3443 - 2612012","0","2022-02-03","1358.01","1","1","0");
INSERT INTO contas_pagar VALUES("1578","103","222073752-8","0","2022-02-03","526.53","1","1","0");
INSERT INTO contas_pagar VALUES("1579","67","95976","0","2022-02-07","3661.1","1","3","0");
INSERT INTO contas_pagar VALUES("1580","28","110954","0","2022-02-07","124.15","1","1","0");
INSERT INTO contas_pagar VALUES("1581","24","980/01","0","2022-02-07","314.93","1","1","0");
INSERT INTO contas_pagar VALUES("1582","44","f-001/2022","0","2022-02-07","93.88","1","1","0");
INSERT INTO contas_pagar VALUES("1583","91","12/2022","0","2021-12-01","109.9","1","1","0");
INSERT INTO contas_pagar VALUES("1584","91","01/2022","0","2022-01-01","109.9","1","1","0");
INSERT INTO contas_pagar VALUES("1585","35","01/2022","0","2022-01-01","149.9","1","1","0");
INSERT INTO contas_pagar VALUES("1586","35","02/2022","0","2022-02-11","149.9","1","1","0");
INSERT INTO contas_pagar VALUES("1587","91","02/2022","0","2022-02-11","109.9","1","1","0");
INSERT INTO contas_pagar VALUES("1588","43","","0","2022-02-11","146.44","1","1","0");
INSERT INTO contas_pagar VALUES("1589","16","0011445543","0","2022-02-14","328.52","1","1","0");
INSERT INTO contas_pagar VALUES("1590","41","TAXA MOBILIARAI A.C GARCIA","0","2022-02-14","317.46","1","1","0");
INSERT INTO contas_pagar VALUES("1591","41","TAXA MOBILIARIA M.A BRENSAN","0","2022-02-14","250.32","1","1","0");
INSERT INTO contas_pagar VALUES("1592","112","004932/101","0","2022-02-14","611.89","1","1","0");
INSERT INTO contas_pagar VALUES("1594","66","25181","0","2021-12-25","925.95","1","1","0");
INSERT INTO contas_pagar VALUES("1595","66","25181","0","2022-01-14","925.95","1","1","0");
INSERT INTO contas_pagar VALUES("1596","66","25181","0","2022-01-14","925.95","1","1","0");
INSERT INTO contas_pagar VALUES("1598","53","989444/01-01","0","2022-02-15","152","1","1","0");
INSERT INTO contas_pagar VALUES("1599","2","4470255","0","2022-02-15","287.86","1","1","0");
INSERT INTO contas_pagar VALUES("1600","63","48492","0","2022-02-15","129.9","1","1","0");
INSERT INTO contas_pagar VALUES("1601","29","210000300601","0","2022-02-17","385","1","1","0");
INSERT INTO contas_pagar VALUES("1602","14","10492523","0","2022-02-17","490","1","1","0");
INSERT INTO contas_pagar VALUES("1603","29","210000515801","0","2022-02-17","900.65","1","1","0");
INSERT INTO contas_pagar VALUES("1604","34","0141915-3","0","2022-02-17","3699.37","1","1","0");
INSERT INTO contas_pagar VALUES("1605","47","804953110","0","2022-02-17","100","1","1","0");
INSERT INTO contas_pagar VALUES("1606","85","02/2022","0","2022-02-17","5367.97","1","1","0");
INSERT INTO contas_pagar VALUES("1607","20","01/2022","0","2022-02-21","5946.73","1","1","0");
INSERT INTO contas_pagar VALUES("1608","31","PD37960","0","2022-02-21","1623.65","1","1","0");
INSERT INTO contas_pagar VALUES("1609","31","PD37960","0","2022-02-21","1623.65","1","4","0");
INSERT INTO contas_pagar VALUES("1610","31","PD37960","0","2022-02-21","1623.65","1","5","0");
INSERT INTO contas_pagar VALUES("1611","22","02/2022","0","2022-02-21","352.44","1","1","0");
INSERT INTO contas_pagar VALUES("1612","22","02/2022","0","2022-02-21","202.9","1","1","0");
INSERT INTO contas_pagar VALUES("1614","22","02/2022","0","2022-02-21","77.6","1","1","0");
INSERT INTO contas_pagar VALUES("1615","5","02/2022 - 3241-13222","0","2022-02-22","146.9","1","1","0");
INSERT INTO contas_pagar VALUES("1616","5","02/2022 - 3241-1300","0","2022-02-22","146.9","1","1","0");
INSERT INTO contas_pagar VALUES("1617","24","000991/01","0","2022-03-02","189.91","1","1","0");
INSERT INTO contas_pagar VALUES("1618","14","10563763","0","2022-03-02","533.5","1","1","0");
INSERT INTO contas_pagar VALUES("1619","14","10563763","0","2022-03-02","533.5","1","1","0");
INSERT INTO contas_pagar VALUES("1620","48","02/2022","0","2022-03-02","1758.26","1","1","0");
INSERT INTO contas_pagar VALUES("1621","48","03/2022","0","2022-03-02","1758.26","1","1","0");
INSERT INTO contas_pagar VALUES("1622","45","COMISSÃO","0","2022-03-03","535.48","1","1","0");
INSERT INTO contas_pagar VALUES("1623","45","MENSALIDADE E DESPESAS","0","2022-03-03","1017.1","1","1","0");
INSERT INTO contas_pagar VALUES("1624","52","20769","0","2022-03-03","289.7","1","1","0");
INSERT INTO contas_pagar VALUES("1625","90","3443","0","2022-03-03","1552.73","1","1","0");
INSERT INTO contas_pagar VALUES("1626","9","808131972","0","2022-03-03","100","1","1","0");
INSERT INTO contas_pagar VALUES("1627","6","02/2022","0","2022-03-03","137.74","1","1","0");
INSERT INTO contas_pagar VALUES("1628","73","16-23529-1","0","2022-03-03","140.35","1","1","0");
INSERT INTO contas_pagar VALUES("1629","73","24-23529-1","0","2022-03-03","1512.07","1","1","0");
INSERT INTO contas_pagar VALUES("1630","73","24-23529-2","0","2022-03-03","1512.29","1","1","0");
INSERT INTO contas_pagar VALUES("1631","73","24-23529-3","0","2022-03-03","1512.29","1","1","0");
INSERT INTO contas_pagar VALUES("1632","29","21.00.007196.01","0","2022-03-03","415.39","1","1","0");
INSERT INTO contas_pagar VALUES("1633","34","0143637-6","0","2022-03-03","2167.54","1","1","0");
INSERT INTO contas_pagar VALUES("1634","1","02/2022","0","2022-03-03","4088.77","1","1","0");
INSERT INTO contas_pagar VALUES("1635","39","02/2022","0","2022-03-03","524.77","1","1","0");
INSERT INTO contas_pagar VALUES("1636","2","4471861","0","2022-03-04","216.92","1","1","0");
INSERT INTO contas_pagar VALUES("1637","2","4471862","0","2022-03-04","216.91","1","1","0");
INSERT INTO contas_pagar VALUES("1638","35","27065121","0","2022-03-10","153.78","1","1","0");
INSERT INTO contas_pagar VALUES("1639","63","49196","0","2022-03-10","74","1","1","0");
INSERT INTO contas_pagar VALUES("1640","44","F-003/2022","0","2022-03-10","93.88","1","1","0");
INSERT INTO contas_pagar VALUES("1641","103","222114680-1","0","2022-03-10","468.79","1","1","0");
INSERT INTO contas_pagar VALUES("1642","18","02/2022","0","2022-03-10","2063.54","1","1","0");
INSERT INTO contas_pagar VALUES("1643","10","13834","0","2022-03-15","190","1","1","0");
INSERT INTO contas_pagar VALUES("1644","6","03/2022","0","2022-03-16","135","1","1","0");
INSERT INTO contas_pagar VALUES("1645","7","0045004-9","0","2022-03-16","710","1","1","0");
INSERT INTO contas_pagar VALUES("1646","85","144788","0","2022-03-16","5241.96","1","1","0");
INSERT INTO contas_pagar VALUES("1647","28","03/2022","0","2022-03-15","93.27","1","1","0");
INSERT INTO contas_pagar VALUES("1648","107","UN 3259 1","0","2022-03-17","108.6","1","1","0");
INSERT INTO contas_pagar VALUES("1649","14","10630137","0","2022-03-17","266.5","1","1","0");
INSERT INTO contas_pagar VALUES("1650","36","1620795-1","0","2022-03-17","200","1","1","0");
INSERT INTO contas_pagar VALUES("1651","34","0145291-6","0","2022-03-17","3493.09","1","1","0");
INSERT INTO contas_pagar VALUES("1652","20","02/2022","0","2022-03-18","3717.45","1","1","0");
INSERT INTO contas_pagar VALUES("1653","43","","0","2022-03-18","146.44","1","1","0");
INSERT INTO contas_pagar VALUES("1654","5","03/2022 - 3241-1300","0","2022-03-21","146.9","1","1","0");
INSERT INTO contas_pagar VALUES("1655","5","03/2022 - 3241-1322","0","2022-03-21","146.9","1","1","0");
INSERT INTO contas_pagar VALUES("1656","22","03/2022 - M.A","0","2022-03-22","207.36","1","1","0");
INSERT INTO contas_pagar VALUES("1657","22","03/2022 - CASA","0","2022-03-22","309.24","1","1","0");
INSERT INTO contas_pagar VALUES("1658","22","03/2022 - BORRACHA","0","2022-03-22","79.3","1","1","0");
INSERT INTO contas_pagar VALUES("1659","31","PD036043-A","0","2022-03-22","158","1","1","0");
INSERT INTO contas_pagar VALUES("1660","2","4474734","0","2022-03-28","735.96","1","1","0");
INSERT INTO contas_pagar VALUES("1661","2","4474735","0","2022-03-28","735.95","1","1","0");
INSERT INTO contas_pagar VALUES("1662","63","50462","0","2022-03-28","106.75","1","1","0");
INSERT INTO contas_pagar VALUES("1663","90","3443","0","2022-03-29","2004.58","1","1","0");
INSERT INTO contas_pagar VALUES("1664","73","16-23662-1","0","2022-03-29","59.5","1","1","0");
INSERT INTO contas_pagar VALUES("1665","73","24-23662-1","0","2022-03-29","641.1","1","1","0");
INSERT INTO contas_pagar VALUES("1666","73","24-23662-2","0","2022-03-29","641.2","1","1","0");
INSERT INTO contas_pagar VALUES("1667","73","24-23662-3","0","2022-03-29","641.2","1","1","0");
INSERT INTO contas_pagar VALUES("1668","7","0045236-0","0","2022-03-30","220","1","1","0");
INSERT INTO contas_pagar VALUES("1669","45","COMISSÃO","0","2022-03-30","129.18","1","1","0");
INSERT INTO contas_pagar VALUES("1671","29","2100009267","0","2022-03-31","800.82","1","1","0");
INSERT INTO contas_pagar VALUES("1672","45","DESP. MENSALIDADE","0","2022-03-31","1034.51","1","1","0");
INSERT INTO contas_pagar VALUES("1673","6","03/2022","0","2022-03-31","135","1","1","0");
INSERT INTO contas_pagar VALUES("1674","114","39/1","0","2022-04-01","449.4","1","1","0");
INSERT INTO contas_pagar VALUES("1676","88","","0","2022-04-01","242.36","1","1","0");
INSERT INTO contas_pagar VALUES("1677","88","","0","2022-04-01","242.36","1","1","0");
INSERT INTO contas_pagar VALUES("1678","1","03/2022","0","2022-04-01","3841.97","1","1","0");
INSERT INTO contas_pagar VALUES("1679","39","03/2022","0","2022-04-01","451.82","1","1","0");
INSERT INTO contas_pagar VALUES("1680","52","21046","0","2022-04-04","257.15","1","1","0");
INSERT INTO contas_pagar VALUES("1681","29","21.00.011967.01","0","2022-04-04","851.97","1","1","0");
INSERT INTO contas_pagar VALUES("1682","34","0147269","0","2022-04-04","2976.34","1","1","0");
INSERT INTO contas_pagar VALUES("1683","67","98012-A","0","2022-04-04","1542.06","1","1","0");
INSERT INTO contas_pagar VALUES("1684","67","98012-B","0","2022-04-04","1258","1","1","0");
INSERT INTO contas_pagar VALUES("1685","67","98012-C","0","2022-04-04","1258","1","1","0");
INSERT INTO contas_pagar VALUES("1686","60","","0","2022-04-05","468.79","1","1","0");
INSERT INTO contas_pagar VALUES("1687","2","4475669","0","2022-04-05","292.52","1","1","0");
INSERT INTO contas_pagar VALUES("1688","2","4475670","0","2022-04-05","292.52","1","1","0");
INSERT INTO contas_pagar VALUES("1689","2","4475671","0","2022-04-05","292.51","1","1","0");
INSERT INTO contas_pagar VALUES("1690","31","PD40278-A","0","2022-04-05","274","1","1","0");
INSERT INTO contas_pagar VALUES("1691","18","03/2022","0","2022-04-05","2045.27","1","1","0");
INSERT INTO contas_pagar VALUES("1692","23","03/2022","0","2022-04-05","1877.28","1","1","0");
INSERT INTO contas_pagar VALUES("1693","28","26209","0","2022-04-07","103.32","1","1","0");
INSERT INTO contas_pagar VALUES("1694","73","16-23705-1","0","2022-04-07","269.5","1","1","0");
INSERT INTO contas_pagar VALUES("1695","73","16-23705-2","0","2022-04-07","269.5","1","1","0");
INSERT INTO contas_pagar VALUES("1696","73","23705","0","2022-04-07","17421","1","3","0");
INSERT INTO contas_pagar VALUES("1697","67","98012","0","2022-04-07","4058.06","1","3","0");
INSERT INTO contas_pagar VALUES("1698","113","821614567","0","2022-04-12","100","1","1","0");
INSERT INTO contas_pagar VALUES("1699","7","0045448-6","0","2022-04-13","260","1","1","0");
INSERT INTO contas_pagar VALUES("1700","10","14901","0","2022-04-14","190","1","1","0");
INSERT INTO contas_pagar VALUES("1701","43","","0","2022-04-14","146.44","1","1","0");
INSERT INTO contas_pagar VALUES("1702","22","04/2022","0","2022-04-19","77.6","1","1","0");
INSERT INTO contas_pagar VALUES("1703","22","EMPRESA","0","2022-04-19","173.93","1","1","0");
INSERT INTO contas_pagar VALUES("1704","20","03/2022","0","2022-04-19","5737.47","1","1","0");
INSERT INTO contas_pagar VALUES("1705","14","10782040","0","2022-04-19","122","1","1","0");
INSERT INTO contas_pagar VALUES("1706","34","0149470-8","0","2022-04-19","140","1","1","0");
INSERT INTO contas_pagar VALUES("1707","34","0149471-6","0","2022-04-19","3770","1","1","0");
INSERT INTO contas_pagar VALUES("1708","5","3241-1322","0","2022-04-19","146.9","1","1","0");
INSERT INTO contas_pagar VALUES("1709","5","3241-1300","0","2022-04-19","146.9","1","1","0");
INSERT INTO contas_pagar VALUES("1710","31","PD036043-A","0","2022-03-30","158","1","1","0");
INSERT INTO contas_pagar VALUES("1711","14","10704962","0","2022-04-01","372","1","1","0");
INSERT INTO contas_pagar VALUES("1712","85","144788 04/2022","0","2022-04-01","5490.33","1","1","0");
INSERT INTO contas_pagar VALUES("1713","7","0045563-6","0","2022-04-22","240","1","1","0");
INSERT INTO contas_pagar VALUES("1714","22","casa","0","2022-04-22","176.97","1","1","0");
INSERT INTO contas_pagar VALUES("1715","52","21179","0","2022-04-25","143","1","1","0");
INSERT INTO contas_pagar VALUES("1716","91","04/2022","0","2022-04-25","109.9","1","1","0");
INSERT INTO contas_pagar VALUES("1717","35","04/2022","0","2022-04-25","149.9","1","1","0");
INSERT INTO contas_pagar VALUES("1718","113","05/2022","0","2022-04-26","100","1","1","0");





CREATE TABLE `contas_receber` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_cliente` int(11) DEFAULT NULL,
  `id_pedido` int(11) DEFAULT NULL,
  `parcela` int(11) DEFAULT NULL,
  `valor_custom` tinyint(1) DEFAULT NULL,
  `valor` float DEFAULT NULL,
  `saldo` float DEFAULT NULL,
  `valor_recebido` float DEFAULT 0,
  `data_emissao` date DEFAULT NULL,
  `data` date DEFAULT NULL,
  `obs` varchar(255) DEFAULT NULL,
  `pago` tinyint(1) DEFAULT NULL,
  `faturado` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=48759 DEFAULT CHARSET=utf8;

INSERT INTO contas_receber VALUES("16","1","1","1","0","27.5","27.5","0","2016-09-06","2016-09-05","","0","0");
INSERT INTO contas_receber VALUES("17","1","1","2","0","27.5","27.5","0","2016-09-06","2016-10-06","","0","0");
INSERT INTO contas_receber VALUES("18","4","2","1","0","63.67","63.67","0","2016-09-06","2016-09-08","","0","0");
INSERT INTO contas_receber VALUES("19","4","2","2","0","63.67","63.67","0","2016-09-06","2016-10-23","","0","0");
INSERT INTO contas_receber VALUES("20","4","2","3","0","63.66","63.66","0","2016-09-06","2016-11-08","","0","0");
INSERT INTO contas_receber VALUES("25","1","4","1","0","734.85","0","734.85","2016-09-12","2016-10-11","","1","1");
INSERT INTO contas_receber VALUES("26","1","4","2","0","734.85","0","734.85","2016-09-12","2016-10-18","","1","1");
INSERT INTO contas_receber VALUES("27","6","5","1","1","423.1","423.1","0","2016-09-12","2016-10-14","","0","0");
INSERT INTO contas_receber VALUES("28","6","5","2","1","423.1","423.1","0","2016-09-12","2016-10-29","","0","0");
INSERT INTO contas_receber VALUES("29","6","5","3","1","423.1","423.1","0","2016-09-12","2016-11-14","","0","0");
INSERT INTO contas_receber VALUES("30","7","6","1","1","149.07","0","149.07","2016-09-15","2016-09-16","","1","1");
INSERT INTO contas_receber VALUES("31","8","7","1","1","42.6","0","42.6","2016-09-15","2016-09-16","","1","1");
INSERT INTO contas_receber VALUES("43","13","9","1","1","191","0","191","2016-09-16","2016-09-18","","1","1");
INSERT INTO contas_receber VALUES("44","14","10","1","1","363.8","0","363.8","2016-09-16","2016-10-16","","1","1");
INSERT INTO contas_receber VALUES("45","14","10","2","1","363.8","0","363.8","2016-09-16","2016-11-16","","1","1");
INSERT INTO contas_receber VALUES("50","5","3","1","0","257.65","0","257.65","2016-09-16","2016-10-14","","1","1");
INSERT INTO contas_receber VALUES("51","5","3","2","0","257.65","0","257.65","2016-09-16","2016-10-28","","1","1");
INSERT INTO contas_receber VALUES("54","15","11","1","0","96.2","0","96.2","2016-09-20","2016-09-23","","1","1");
INSERT INTO contas_receber VALUES("70","7","15","1","0","296","296","0","2016-09-22","2016-10-07","","0","0");
INSERT INTO contas_receber VALUES("71","9","8","1","1","878.3","0","878.3","2016-09-22","2016-10-27","","1","1");
INSERT INTO contas_receber VALUES("72","9","8","2","1","878.3","0","878.3","2016-09-22","2016-11-11","","1","1");
INSERT INTO contas_receber VALUES("73","9","8","3","1","878.3","0","878.3","2016-09-22","2016-11-26","","1","1");
INSERT INTO contas_receber VALUES("74","9","8","4","1","878.3","0","878.3","2016-09-22","2017-03-11","","1","1");
INSERT INTO contas_receber VALUES("99","16","12","1","1","409.83","0","409.83","2016-09-27","2016-10-28","","1","1");
INSERT INTO contas_receber VALUES("100","16","12","2","0","409.83","0","409.83","2016-09-27","2016-11-12","","1","1");
INSERT INTO contas_receber VALUES("101","16","12","3","0","409.84","0","409.84","2016-09-27","2016-11-28","","1","1");
INSERT INTO contas_receber VALUES("102","7","14","1","1","328.4","0","328.4","2016-09-27","2016-10-14","","1","1");
INSERT INTO contas_receber VALUES("103","7","14","2","1","328.4","0","328.4","2016-09-27","2016-10-29","","1","1");
INSERT INTO contas_receber VALUES("104","14","13","1","1","202.5","0","202.5","2016-09-27","2016-10-29","","1","1");
INSERT INTO contas_receber VALUES("105","14","13","2","1","202.5","0","202.5","2016-09-27","2016-11-29","","1","1");
INSERT INTO contas_receber VALUES("106","4","17","1","1","1291.83","0","1291.83","2016-09-27","2016-11-03","","1","1");
INSERT INTO contas_receber VALUES("107","4","17","3","1","1291.84","0","1291.84","2016-09-27","2016-12-03","","1","1");
INSERT INTO contas_receber VALUES("108","4","17","2","1","1291.83","0","1291.83","2016-09-27","2016-11-18","","1","1");
INSERT INTO contas_receber VALUES("169","22","21","1","0","725.87","725.87","0","2016-09-29","2016-09-30","","0","0");
INSERT INTO contas_receber VALUES("170","22","21","2","0","725.87","725.87","0","2016-09-29","2016-10-31","","0","0");
INSERT INTO contas_receber VALUES("171","22","21","3","0","725.86","725.86","0","2016-09-29","2016-12-01","","0","0");
INSERT INTO contas_receber VALUES("205","20","19","1","0","401.5","0","401.5","2016-09-30","2016-11-04","","1","1");
INSERT INTO contas_receber VALUES("206","20","19","2","0","401.5","0","401.5","2016-09-30","2016-11-19","","1","1");
INSERT INTO contas_receber VALUES("207","20","19","3","0","401.51","0","401.51","2016-09-30","2016-12-04","","1","1");
INSERT INTO contas_receber VALUES("208","21","20","1","0","800.5","0","800.5","2016-09-30","2016-11-06","","1","1");
INSERT INTO contas_receber VALUES("209","21","20","2","0","800.5","0","800.5","2016-09-30","2016-11-21","","1","1");
INSERT INTO contas_receber VALUES("210","21","20","3","0","800.5","0","800.5","2016-09-30","2016-12-06","","1","1");
INSERT INTO contas_receber VALUES("211","23","23","1","0","322","0","322","2016-09-30","2016-11-05","","1","1");
INSERT INTO contas_receber VALUES("212","23","23","2","0","322","0","322","2016-09-30","2016-12-05","","1","1");
INSERT INTO contas_receber VALUES("214","26","28","1","0","562.6","562.6","0","2016-10-03","2016-10-04","","0","0");
INSERT INTO contas_receber VALUES("215","29","29","1","0","235.95","0","235.95","2016-10-03","2016-10-04","","1","1");
INSERT INTO contas_receber VALUES("216","27","30","1","0","28.32","0","28.32","2016-10-03","2016-10-04","","1","1");
INSERT INTO contas_receber VALUES("217","28","31","1","0","328.56","0","328.56","2016-10-03","2016-10-04","","1","1");
INSERT INTO contas_receber VALUES("218","31","33","1","0","174.3","0","174.3","2016-10-04","2016-10-05","","1","1");
INSERT INTO contas_receber VALUES("220","26","34","1","0","562.6","0","562.6","2016-10-04","2016-10-05","","1","1");
INSERT INTO contas_receber VALUES("256","32","35","1","1","257.39","0","257.39","2016-10-07","2016-11-10","","1","1");
INSERT INTO contas_receber VALUES("257","33","36","1","1","544.75","0","544.75","2016-10-07","2016-11-14","","1","1");
INSERT INTO contas_receber VALUES("258","33","36","2","1","544.75","0","544.75","2016-10-07","2016-12-14","","1","1");
INSERT INTO contas_receber VALUES("259","33","36","3","1","544.75","0","544.75","2016-10-07","2017-01-14","","1","1");
INSERT INTO contas_receber VALUES("307","35","44","1","1","234.02","234.02","0","2016-10-18","2016-10-15","","0","0");
INSERT INTO contas_receber VALUES("322","38","49","1","1","50.52","0","50.52","2016-10-18","2016-10-19","","1","1");
INSERT INTO contas_receber VALUES("323","34","38","1","1","397.87","0","397.87","2016-10-19","2016-11-18","","1","1");
INSERT INTO contas_receber VALUES("324","34","38","2","1","397.86","0","397.86","2016-10-19","2016-12-03","","1","1");
INSERT INTO contas_receber VALUES("325","34","38","3","1","397.87","0","397.87","2016-10-19","2016-12-18","","1","1");
INSERT INTO contas_receber VALUES("330","36","40","2","1","1270.43","0","1270.43","2016-10-19","2016-12-06","","1","1");
INSERT INTO contas_receber VALUES("331","36","40","3","1","1270.43","0","1270.43","2016-10-19","2016-12-21","","1","1");
INSERT INTO contas_receber VALUES("332","36","40","4","1","1270.42","0","1270.42","2016-10-19","2017-01-03","","1","1");
INSERT INTO contas_receber VALUES("333","36","40","1","1","1270.42","0","1270.42","2016-10-19","2016-11-21","","1","1");
INSERT INTO contas_receber VALUES("338","8","51","1","0","30.4","0","30.4","2016-10-19","2016-10-20","","1","1");
INSERT INTO contas_receber VALUES("345","40","53","1","0","110.25","0","110.25","2016-10-19","2016-10-20","","1","1");
INSERT INTO contas_receber VALUES("346","25","27","1","0","1064.87","1064.87","0","2016-10-20","2016-10-07","","0","0");
INSERT INTO contas_receber VALUES("347","25","27","2","0","1064.87","1064.87","0","2016-10-20","2016-11-07","","0","0");
INSERT INTO contas_receber VALUES("348","25","27","3","0","1064.87","1064.87","0","2016-10-20","2016-12-08","","0","0");
INSERT INTO contas_receber VALUES("349","25","27","5","0","1064.87","1064.87","0","2016-10-20","2017-02-08","","0","0");
INSERT INTO contas_receber VALUES("350","25","27","4","0","1064.87","1064.87","0","2016-10-20","2017-01-08","","0","0");
INSERT INTO contas_receber VALUES("351","25","27","6","0","1064.85","1064.85","0","2016-10-20","2017-03-11","","0","0");
INSERT INTO contas_receber VALUES("352","30","32","1","1","399.45","0","399.45","2016-10-20","2016-11-20","","1","1");
INSERT INTO contas_receber VALUES("353","30","32","2","1","399.45","0","399.45","2016-10-20","2016-12-05","","1","1");
INSERT INTO contas_receber VALUES("354","30","32","4","1","399.45","0","399.45","2016-10-20","2017-01-09","","1","1");
INSERT INTO contas_receber VALUES("355","30","32","3","1","399.45","0","399.45","2016-10-20","2016-12-20","","1","1");
INSERT INTO contas_receber VALUES("356","30","37","1","1","1466.45","1466.45","0","2016-10-20","2016-11-20","","0","0");
INSERT INTO contas_receber VALUES("357","30","37","3","1","1466.45","1466.45","0","2016-10-20","2016-12-20","","0","0");
INSERT INTO contas_receber VALUES("358","30","37","2","1","1466.45","1466.45","0","2016-10-20","2016-12-05","","0","0");
INSERT INTO contas_receber VALUES("359","30","37","4","1","1466.45","1466.45","0","2016-10-20","2017-01-09","","0","0");
INSERT INTO contas_receber VALUES("360","4","42","1","1","1342.67","0","1342.67","2016-10-20","2016-12-01","","1","1");
INSERT INTO contas_receber VALUES("361","4","42","2","1","1342.66","0","1342.66","2016-10-20","2016-12-16","","1","1");
INSERT INTO contas_receber VALUES("362","4","42","3","1","1342.67","0","1342.67","2016-10-20","2017-01-02","","1","1");
INSERT INTO contas_receber VALUES("365","31","48","1","1","290.5","0","290.5","2016-10-21","2016-11-25","","1","1");
INSERT INTO contas_receber VALUES("366","31","48","2","1","290.5","0","290.5","2016-10-21","2016-12-25","","1","1");
INSERT INTO contas_receber VALUES("367","31","41","1","1","133.55","0","133.55","2016-10-21","2016-11-25","","1","1");
INSERT INTO contas_receber VALUES("368","31","41","2","1","133.55","0","133.55","2016-10-21","2016-12-25","","1","1");
INSERT INTO contas_receber VALUES("369","37","45","1","1","347.88","0","347.88","2016-10-21","2016-11-25","","1","1");
INSERT INTO contas_receber VALUES("370","37","45","2","1","347.87","0","347.87","2016-10-21","2016-12-25","","1","1");
INSERT INTO contas_receber VALUES("371","23","43","1","1","288.25","0","288.25","2016-10-21","2016-11-26","","1","1");
INSERT INTO contas_receber VALUES("372","23","43","2","1","288.25","0","288.25","2016-10-21","2016-12-26","","1","1");
INSERT INTO contas_receber VALUES("373","19","46","1","1","355.85","0","355.85","2016-10-21","2016-11-27","","1","1");
INSERT INTO contas_receber VALUES("374","19","46","2","1","355.85","0","355.85","2016-10-21","2016-12-27","","1","1");
INSERT INTO contas_receber VALUES("375","24","50","1","1","1248.5","0","1248.5","2016-10-21","2016-11-14","","1","1");
INSERT INTO contas_receber VALUES("376","24","50","2","1","1248.5","0","1248.5","2016-10-21","2016-11-14","","1","1");
INSERT INTO contas_receber VALUES("481","28","54","1","1","233.53","0","233.53","2016-10-25","2016-10-23","","1","1");
INSERT INTO contas_receber VALUES("482","43","57","1","1","295.95","295.95","0","2016-10-25","2016-10-27","","0","0");
INSERT INTO contas_receber VALUES("483","43","57","2","1","295.95","295.95","0","2016-10-25","2016-11-27","","0","0");
INSERT INTO contas_receber VALUES("507","42","56","1","1","743.33","0","743.33","2016-10-25","2016-12-03","","1","1");
INSERT INTO contas_receber VALUES("508","42","56","2","1","743.33","0","743.33","2016-10-25","2016-12-19","","1","1");
INSERT INTO contas_receber VALUES("509","42","56","3","1","743.34","0","743.34","2016-10-25","2017-01-03","","1","1");
INSERT INTO contas_receber VALUES("510","39","52","1","1","641.77","0","641.77","2016-10-25","2016-12-02","","1","1");
INSERT INTO contas_receber VALUES("511","39","52","2","1","641.77","0","641.77","2016-10-25","2016-12-17","","1","1");
INSERT INTO contas_receber VALUES("512","39","52","3","1","641.76","0","641.76","2016-10-25","2017-01-03","","1","1");
INSERT INTO contas_receber VALUES("513","43","61","1","1","277.8","0","277.8","2016-10-25","2016-12-03","","1","1");
INSERT INTO contas_receber VALUES("514","43","61","2","1","277.8","0","277.8","2016-10-25","2017-01-03","","1","1");
INSERT INTO contas_receber VALUES("525","44","58","1","1","471.9","471.9","0","2016-10-27","2016-12-04","","0","0");
INSERT INTO contas_receber VALUES("526","44","58","3","1","471.9","471.9","0","2016-10-27","2017-01-04","","0","0");
INSERT INTO contas_receber VALUES("527","44","58","2","1","471.9","471.9","0","2016-10-27","2016-12-19","","0","0");
INSERT INTO contas_receber VALUES("528","45","59","1","1","421.8","0","421.8","2016-10-27","2016-12-03","","1","1");
INSERT INTO contas_receber VALUES("529","45","59","2","1","421.8","0","421.8","2016-10-27","2016-12-19","","1","1");
INSERT INTO contas_receber VALUES("530","45","59","3","1","421.8","0","421.8","2016-10-27","2017-01-03","","1","1");
INSERT INTO contas_receber VALUES("531","33","63","1","1","218","0","218","2016-10-27","2016-12-03","","1","1");
INSERT INTO contas_receber VALUES("544","24","26","1","0","1402.8","1402.8","0","2016-10-27","2016-10-06","","0","0");
INSERT INTO contas_receber VALUES("545","24","26","2","0","1402.8","1402.8","0","2016-10-27","2016-10-22","","0","0");
INSERT INTO contas_receber VALUES("549","48","65","1","0","284.38","284.38","0","2016-10-27","2016-10-29","","0","0");
INSERT INTO contas_receber VALUES("599","52","72","1","0","3363","3363","0","2016-11-01","2016-11-02","","0","0");
INSERT INTO contas_receber VALUES("600","52","72","2","0","3363","3363","0","2016-11-01","2016-12-03","","0","0");
INSERT INTO contas_receber VALUES("609","46","60","1","1","371.7","371.7","0","2016-11-01","2016-12-03","","0","0");
INSERT INTO contas_receber VALUES("610","35","47","1","1","234.02","0","234.02","2016-11-01","2016-10-21","","1","1");
INSERT INTO contas_receber VALUES("635","18","75","1","1","267.47","267.47","0","2016-11-03","2016-11-07","","0","0");
INSERT INTO contas_receber VALUES("636","18","75","2","1","267.47","267.47","0","2016-11-03","2016-12-08","","0","0");
INSERT INTO contas_receber VALUES("637","18","75","3","1","267.46","267.46","0","2016-11-03","2017-01-08","","0","0");
INSERT INTO contas_receber VALUES("655","47","62","1","1","517.75","0","517.75","2016-11-08","2016-12-04","","1","1");
INSERT INTO contas_receber VALUES("656","47","62","3","1","517.75","0","517.75","2016-11-08","2016-12-19","","1","1");
INSERT INTO contas_receber VALUES("657","47","62","2","1","517.75","0","517.75","2016-11-08","2016-12-12","","1","1");
INSERT INTO contas_receber VALUES("658","41","55","1","1","971.73","0","971.73","2016-11-08","2016-12-07","","1","1");
INSERT INTO contas_receber VALUES("659","41","55","2","1","971.73","0","971.73","2016-11-08","2016-12-27","","1","1");
INSERT INTO contas_receber VALUES("660","41","55","4","1","971.71","0","971.71","2016-11-08","2017-02-05","","1","1");
INSERT INTO contas_receber VALUES("661","41","55","3","1","971.73","0","971.73","2016-11-08","2017-01-16","","1","1");
INSERT INTO contas_receber VALUES("662","46","64","1","1","189.42","0","189.42","2016-11-08","2016-12-04","","1","1");
INSERT INTO contas_receber VALUES("663","46","64","2","1","189.42","0","189.42","2016-11-08","2017-01-04","","1","1");
INSERT INTO contas_receber VALUES("668","50","67","2","1","561.33","0","561.33","2016-11-08","2017-01-08","","1","1");
INSERT INTO contas_receber VALUES("669","50","67","3","1","561.34","0","561.34","2016-11-08","2017-02-08","","1","1");
INSERT INTO contas_receber VALUES("670","50","67","1","1","561.33","0","561.33","2016-11-08","2016-12-08","","1","1");
INSERT INTO contas_receber VALUES("677","54","77","1","1","174.92","174.92","0","2016-11-09","2016-11-08","","0","0");
INSERT INTO contas_receber VALUES("693","54","81","1","1","174.92","174.92","0","2016-11-11","2016-11-11","","0","0");
INSERT INTO contas_receber VALUES("697","57","80","1","1","3363","0","3363","2016-11-11","2016-11-28","","1","1");
INSERT INTO contas_receber VALUES("698","57","80","2","1","3363","0","3363","2016-11-11","2016-12-05","","1","1");
INSERT INTO contas_receber VALUES("699","28","76","1","1","202.08","0","202.08","2016-11-11","2016-11-05","","1","1");
INSERT INTO contas_receber VALUES("701","59","86","1","1","114.5","114.5","0","2016-11-11","2016-11-12","","0","0");
INSERT INTO contas_receber VALUES("704","49","66","1","1","716.43","0","716.43","2016-11-12","2016-12-08","","1","1");
INSERT INTO contas_receber VALUES("705","49","66","2","1","716.43","0","716.43","2016-11-12","2017-01-08","","1","1");
INSERT INTO contas_receber VALUES("706","49","66","3","1","716.43","0","716.43","2016-11-12","2017-02-08","","1","1");
INSERT INTO contas_receber VALUES("707","5","68","1","1","276.7","0","276.7","2016-11-12","2016-12-14","","1","1");
INSERT INTO contas_receber VALUES("708","5","68","2","1","276.7","0","276.7","2016-11-12","2017-01-14","","1","1");
INSERT INTO contas_receber VALUES("709","51","70","1","1","589","0","589","2016-11-12","2016-12-14","","1","1");
INSERT INTO contas_receber VALUES("710","51","70","2","1","589","0","589","2016-11-12","2016-12-29","","1","1");
INSERT INTO contas_receber VALUES("711","4","69","1","1","412.67","0","412.67","2016-11-12","2016-12-16","","1","1");
INSERT INTO contas_receber VALUES("712","4","69","2","1","412.67","0","412.67","2016-11-12","2017-01-02","","1","1");
INSERT INTO contas_receber VALUES("713","4","69","3","1","412.66","0","412.66","2016-11-12","2017-01-16","","1","1");
INSERT INTO contas_receber VALUES("714","55","78","1","1","649","0","649","2016-11-12","2016-11-09","","1","1");
INSERT INTO contas_receber VALUES("715","56","79","1","1","115.4","0","115.4","2016-11-12","2016-11-10","","1","1");
INSERT INTO contas_receber VALUES("716","19","73","1","1","326.35","0","326.35","2016-11-12","2016-12-16","","1","1");
INSERT INTO contas_receber VALUES("717","19","73","2","1","326.35","0","326.35","2016-11-12","2017-01-16","","1","1");
INSERT INTO contas_receber VALUES("718","17","71","1","1","1590.3","0","1590.3","2016-11-12","2016-12-16","","1","1");
INSERT INTO contas_receber VALUES("719","17","71","2","1","1590.3","0","1590.3","2016-11-12","2016-12-31","","1","1");
INSERT INTO contas_receber VALUES("720","17","71","3","1","1590.3","0","1590.3","2016-11-12","2017-01-16","","1","1");
INSERT INTO contas_receber VALUES("721","3","83","1","1","141","0","141","2016-11-12","2016-11-11","","1","1");
INSERT INTO contas_receber VALUES("724","31","74","1","1","199.5","0","199.5","2016-11-12","2016-12-04","","1","1");
INSERT INTO contas_receber VALUES("725","31","74","2","1","199.5","0","199.5","2016-11-12","2017-01-04","","1","1");
INSERT INTO contas_receber VALUES("742","54","85","1","1","179.07","0","179.07","2016-11-17","2016-11-14","","1","1");
INSERT INTO contas_receber VALUES("787","62","91","1","0","263.07","263.07","0","2016-11-21","2016-11-23","","0","0");
INSERT INTO contas_receber VALUES("788","62","91","2","0","263.07","263.07","0","2016-11-21","2016-12-24","","0","0");
INSERT INTO contas_receber VALUES("789","62","91","3","0","263.08","263.08","0","2016-11-21","2017-01-24","","0","0");
INSERT INTO contas_receber VALUES("841","35","89","1","1","118.86","0","118.86","2016-11-23","2016-12-21","","1","1");
INSERT INTO contas_receber VALUES("842","35","89","2","1","118.86","0","118.86","2016-11-23","2017-01-21","","1","1");
INSERT INTO contas_receber VALUES("843","61","90","1","1","216.5","0","216.5","2016-11-23","2016-12-23","","1","1");
INSERT INTO contas_receber VALUES("844","60","88","1","1","458.07","0","458.07","2016-11-23","2016-12-23","","1","1");
INSERT INTO contas_receber VALUES("845","60","88","2","1","458.07","0","458.07","2016-11-23","2017-01-07","","1","1");
INSERT INTO contas_receber VALUES("846","60","88","3","1","458.06","0","458.06","2016-11-23","2017-01-23","","1","1");
INSERT INTO contas_receber VALUES("847","58","84","1","1","182.49","0","182.49","2016-11-23","2016-11-16","","1","1");
INSERT INTO contas_receber VALUES("848","24","82","1","1","975.5","0","975.5","2016-11-23","2016-12-07","","1","1");
INSERT INTO contas_receber VALUES("849","24","82","2","1","975.5","0","975.5","2016-11-23","2016-12-07","","1","1");
INSERT INTO contas_receber VALUES("874","66","100","1","1","594.4","594.4","0","2016-11-25","2016-11-25","","0","0");
INSERT INTO contas_receber VALUES("875","66","100","1","1","594.4","594.4","0","2016-11-25","2016-11-25","","0","0");
INSERT INTO contas_receber VALUES("894","28","92","1","1","465.94","0","465.94","2016-11-28","2016-11-23","","1","1");
INSERT INTO contas_receber VALUES("895","45","96","1","1","911.33","0","911.33","2016-11-28","2016-12-28","","1","1");
INSERT INTO contas_receber VALUES("896","45","96","2","1","911.33","0","911.33","2016-11-28","2017-01-12","","1","1");
INSERT INTO contas_receber VALUES("897","45","96","3","1","911.34","0","911.34","2016-11-28","2017-01-28","","1","1");
INSERT INTO contas_receber VALUES("910","68","104","1","0","462.37","462.37","0","2016-11-30","2016-11-30","","0","0");
INSERT INTO contas_receber VALUES("911","68","104","2","0","462.37","462.37","0","2016-11-30","2016-12-31","","0","0");
INSERT INTO contas_receber VALUES("912","68","104","3","0","462.36","462.36","0","2016-11-30","2017-01-31","","0","0");
INSERT INTO contas_receber VALUES("950","63","93","1","1","581.8","0","581.8","2016-12-05","2017-01-31","","1","1");
INSERT INTO contas_receber VALUES("951","63","93","2","1","581.8","0","581.8","2016-12-05","2017-02-15","","1","1");
INSERT INTO contas_receber VALUES("952","64","94","1","1","468.53","0","468.53","2016-12-05","2017-01-23","","1","1");
INSERT INTO contas_receber VALUES("953","64","94","2","1","468.53","0","468.53","2016-12-05","2017-02-07","","1","1");
INSERT INTO contas_receber VALUES("954","64","94","3","1","468.54","0","468.54","2016-12-05","2017-02-22","","1","1");
INSERT INTO contas_receber VALUES("955","4","95","1","1","999.33","0","999.33","2016-12-05","2016-12-30","","1","1");
INSERT INTO contas_receber VALUES("956","4","95","2","1","999.33","0","999.33","2016-12-05","2017-01-14","","1","1");
INSERT INTO contas_receber VALUES("957","4","95","3","1","999.34","0","999.34","2016-12-05","2017-01-30","","1","1");
INSERT INTO contas_receber VALUES("958","12","97","1","1","211","0","211","2016-12-05","2016-12-30","","1","1");
INSERT INTO contas_receber VALUES("959","8","98","1","1","450.5","0","450.5","2016-12-05","2017-01-01","","1","1");
INSERT INTO contas_receber VALUES("960","8","98","2","1","450.5","0","450.5","2016-12-05","2017-02-01","","1","1");
INSERT INTO contas_receber VALUES("961","65","99","1","1","586.5","0","586.5","2016-12-05","2017-01-02","","1","1");
INSERT INTO contas_receber VALUES("962","65","99","2","1","586.5","0","586.5","2016-12-05","2017-01-17","","1","1");
INSERT INTO contas_receber VALUES("963","65","99","3","1","586.5","0","586.5","2016-12-05","2017-02-02","","1","1");
INSERT INTO contas_receber VALUES("964","22","101","1","1","526.47","0","526.47","2016-12-05","2017-01-05","","1","1");
INSERT INTO contas_receber VALUES("965","22","101","2","1","526.47","0","526.47","2016-12-05","2017-01-20","","1","1");
INSERT INTO contas_receber VALUES("966","22","101","3","1","526.46","0","526.46","2016-12-05","2017-02-05","","1","1");
INSERT INTO contas_receber VALUES("967","3","107","1","1","267.87","0","267.87","2016-12-05","2016-12-04","","1","1");
INSERT INTO contas_receber VALUES("968","32","108","1","1","45.52","0","45.52","2016-12-05","2016-12-03","","1","1");
INSERT INTO contas_receber VALUES("969","31","87","1","1","129.3","0","129.3","2016-12-05","2016-12-18","","1","1");
INSERT INTO contas_receber VALUES("986","33","102","1","1","412.07","0","412.07","2016-12-08","2017-01-07","","1","1");
INSERT INTO contas_receber VALUES("987","33","102","2","1","412.07","0","412.07","2016-12-08","2017-01-22","","1","1");
INSERT INTO contas_receber VALUES("988","33","102","3","1","412.06","0","412.06","2016-12-08","2017-02-07","","1","1");
INSERT INTO contas_receber VALUES("995","67","103","1","1","415","0","415","2016-12-08","2017-01-07","","1","1");
INSERT INTO contas_receber VALUES("996","67","103","2","1","415","0","415","2016-12-08","2017-01-22","","1","1");
INSERT INTO contas_receber VALUES("997","67","103","3","1","415","0","415","2016-12-08","2017-02-07","","1","1");
INSERT INTO contas_receber VALUES("998","68","105","1","1","462.37","0","462.37","2016-12-08","2017-01-08","","1","1");
INSERT INTO contas_receber VALUES("999","68","105","2","1","462.37","0","462.37","2016-12-08","2017-01-23","","1","1");
INSERT INTO contas_receber VALUES("1000","68","105","3","1","462.36","0","462.36","2016-12-08","2017-02-08","","1","1");
INSERT INTO contas_receber VALUES("1001","30","106","1","1","288.5","0","288.5","2016-12-08","2017-01-09","","1","1");
INSERT INTO contas_receber VALUES("1002","30","106","2","1","288.5","0","288.5","2016-12-08","2017-02-09","","1","1");
INSERT INTO contas_receber VALUES("1003","19","109","1","1","266","0","266","2016-12-08","2017-01-08","","1","1");
INSERT INTO contas_receber VALUES("1004","19","109","2","1","266","0","266","2016-12-08","2017-02-08","","1","1");
INSERT INTO contas_receber VALUES("1005","43","111","1","1","226.75","0","226.75","2016-12-08","2017-01-08","","1","1");
INSERT INTO contas_receber VALUES("1006","43","111","2","1","226.75","0","226.75","2016-12-08","2017-02-08","","1","1");
INSERT INTO contas_receber VALUES("1007","46","112","1","1","48.94","0","48.94","2016-12-08","2017-01-08","","1","1");
INSERT INTO contas_receber VALUES("1018","42","110","1","1","743.33","0","743.33","2016-12-09","2017-01-09","","1","1");
INSERT INTO contas_receber VALUES("1019","42","110","2","1","743.33","0","743.33","2016-12-09","2017-01-24","","1","1");
INSERT INTO contas_receber VALUES("1020","42","110","3","1","743.34","0","743.34","2016-12-09","2017-02-09","","1","1");
INSERT INTO contas_receber VALUES("1023","72","118","1","1","400","0","400","2016-12-09","2016-12-11","","1","1");
INSERT INTO contas_receber VALUES("1072","69","113","2","1","599.4","0","599.4","2016-12-13","2016-12-28","","1","1");
INSERT INTO contas_receber VALUES("1073","69","113","1","1","599.4","0","599.4","2016-12-13","2016-12-28","","1","1");
INSERT INTO contas_receber VALUES("1074","31","116","1","1","224.72","0","224.72","2016-12-13","2017-01-13","","1","1");
INSERT INTO contas_receber VALUES("1075","31","116","2","1","224.73","0","224.73","2016-12-13","2017-02-13","","1","1");
INSERT INTO contas_receber VALUES("1076","70","114","1","1","696.53","0","696.53","2016-12-13","2016-12-27","","1","1");
INSERT INTO contas_receber VALUES("1077","70","114","2","1","696.53","0","696.53","2016-12-13","2016-12-27","","1","1");
INSERT INTO contas_receber VALUES("1099","73","119","1","1","412.38","412.38","0","2016-12-14","2016-12-20","","0","0");
INSERT INTO contas_receber VALUES("1100","73","119","2","1","412.38","412.38","0","2016-12-14","2017-01-20","","0","0");
INSERT INTO contas_receber VALUES("1101","73","119","3","1","412.39","412.39","0","2016-12-14","2017-02-20","","0","0");
INSERT INTO contas_receber VALUES("1135","7","121","1","1","257.2","0","257.2","2016-12-14","2016-12-16","","1","1");
INSERT INTO contas_receber VALUES("1136","7","121","2","1","257.2","0","257.2","2016-12-14","2016-12-23","","1","1");
INSERT INTO contas_receber VALUES("1143","4","115","1","1","922.67","0","922.67","2016-12-14","2017-01-14","","1","1");
INSERT INTO contas_receber VALUES("1144","4","115","3","1","922.66","0","922.66","2016-12-14","2017-02-14","","1","1");
INSERT INTO contas_receber VALUES("1145","4","115","2","1","922.67","0","922.67","2016-12-14","2017-01-30","","1","1");
INSERT INTO contas_receber VALUES("1146","71","117","1","1","566.95","0","566.95","2016-12-15","2017-01-15","","1","1");
INSERT INTO contas_receber VALUES("1147","71","117","2","1","566.95","0","566.95","2016-12-15","2017-02-15","","1","1");
INSERT INTO contas_receber VALUES("1148","42","122","1","1","329.5","0","329.5","2016-12-15","2016-12-14","","1","1");
INSERT INTO contas_receber VALUES("1149","3","123","1","1","46.2","0","46.2","2016-12-15","2016-12-16","","1","1");
INSERT INTO contas_receber VALUES("1174","73","124","1","1","415.88","0","415.88","2016-12-21","2017-01-19","","1","1");
INSERT INTO contas_receber VALUES("1175","73","124","2","1","415.88","0","415.88","2016-12-21","2017-02-03","","1","1");
INSERT INTO contas_receber VALUES("1176","73","124","3","1","415.89","0","415.89","2016-12-21","2017-02-19","","1","1");
INSERT INTO contas_receber VALUES("1177","74","120","1","1","2609.97","0","2609.97","2016-12-21","2017-01-22","","1","1");
INSERT INTO contas_receber VALUES("1178","74","120","2","1","2609.97","0","2609.97","2016-12-21","2017-02-22","","1","1");
INSERT INTO contas_receber VALUES("1179","74","120","3","1","2609.96","0","2609.96","2016-12-21","2017-03-22","","1","1");
INSERT INTO contas_receber VALUES("1180","76","125","1","1","495.47","0","495.47","2016-12-21","2017-01-21","","1","1");
INSERT INTO contas_receber VALUES("1181","76","125","2","1","495.47","0","495.47","2016-12-21","2017-02-05","","1","1");
INSERT INTO contas_receber VALUES("1182","76","125","3","1","495.46","0","495.46","2016-12-21","2017-02-21","","1","1");
INSERT INTO contas_receber VALUES("1183","28","126","1","1","176.75","0","176.75","2016-12-21","2016-12-17","","1","1");
INSERT INTO contas_receber VALUES("1184","77","127","1","1","35.46","0","35.46","2016-12-21","2016-12-16","","1","1");
INSERT INTO contas_receber VALUES("1185","78","128","1","1","110","0","110","2016-12-21","2016-12-17","","1","1");
INSERT INTO contas_receber VALUES("1186","3","129","1","1","25.38","0","25.38","2016-12-21","2016-12-18","","1","1");
INSERT INTO contas_receber VALUES("1204","43","135","1","1","523.5","523.5","0","2017-01-03","2017-02-10","","0","0");
INSERT INTO contas_receber VALUES("1219","80","131","1","1","400","0","400","2017-01-05","2016-12-21","","1","1");
INSERT INTO contas_receber VALUES("1220","80","133","1","1","383.2","0","383.2","2017-01-05","2016-12-24","","1","1");
INSERT INTO contas_receber VALUES("1221","79","130","1","1","1613.5","0","1613.5","2017-01-05","2016-12-25","","1","1");
INSERT INTO contas_receber VALUES("1224","24","132","1","1","934","0","934","2017-01-05","2017-01-20","","1","1");
INSERT INTO contas_receber VALUES("1225","24","132","2","1","934","0","934","2017-01-05","2017-01-20","","1","1");
INSERT INTO contas_receber VALUES("1226","43","136","1","1","487","0","487","2017-01-05","2017-02-06","","1","1");
INSERT INTO contas_receber VALUES("1237","31","134","1","1","410.42","0","410.42","2017-01-06","2017-02-09","","1","1");
INSERT INTO contas_receber VALUES("1238","31","134","2","1","410.42","0","410.42","2017-01-06","2017-02-24","","1","1");
INSERT INTO contas_receber VALUES("1239","31","134","3","1","410.41","0","410.41","2017-01-06","2017-03-09","","1","1");
INSERT INTO contas_receber VALUES("1271","19","138","1","1","325.25","0","325.25","2017-01-10","2017-01-10","","1","1");
INSERT INTO contas_receber VALUES("1272","19","138","2","1","325.25","0","325.25","2017-01-10","2017-02-10","","1","1");
INSERT INTO contas_receber VALUES("1303","82","137","1","1","49.8","0","49.8","2017-01-12","2017-01-07","","1","1");
INSERT INTO contas_receber VALUES("1305","83","139","1","1","167.04","167.04","0","2017-01-12","2017-01-08","","0","0");
INSERT INTO contas_receber VALUES("1341","27","140","1","1","41.35","0","41.35","2017-01-13","2017-01-11","","1","1");
INSERT INTO contas_receber VALUES("1342","35","141","1","1","92.75","0","92.75","2017-01-13","2017-02-12","","1","1");
INSERT INTO contas_receber VALUES("1343","35","141","2","1","92.74","0","92.74","2017-01-13","2017-03-12","","1","1");
INSERT INTO contas_receber VALUES("1347","9","142","1","1","578.83","0","578.83","2017-01-13","2017-02-11","","1","1");
INSERT INTO contas_receber VALUES("1348","9","142","3","1","578.84","0","578.84","2017-01-13","2017-03-11","","1","1");
INSERT INTO contas_receber VALUES("1349","9","142","2","1","578.83","0","578.83","2017-01-13","2017-02-26","","1","1");
INSERT INTO contas_receber VALUES("1350","60","143","1","1","510.7","0","510.7","2017-01-13","2017-02-13","","1","1");
INSERT INTO contas_receber VALUES("1351","60","143","2","1","510.7","0","510.7","2017-01-13","2017-02-28","","1","1");
INSERT INTO contas_receber VALUES("1352","60","143","3","1","510.7","0","510.7","2017-01-13","2017-03-13","","1","1");
INSERT INTO contas_receber VALUES("1353","62","149","1","1","212.99","0","212.99","2017-01-13","2017-02-13","","1","1");
INSERT INTO contas_receber VALUES("1354","46","152","1","1","121.54","0","121.54","2017-01-13","2017-02-13","","1","1");
INSERT INTO contas_receber VALUES("1360","31","154","1","1","517.2","517.2","0","2017-01-13","2017-01-14","","0","0");
INSERT INTO contas_receber VALUES("1361","31","154","2","1","517.2","517.2","0","2017-01-13","2017-02-14","","0","0");
INSERT INTO contas_receber VALUES("1362","31","154","3","1","517.2","517.2","0","2017-01-13","2017-03-17","","0","0");
INSERT INTO contas_receber VALUES("1382","90","158","1","1","58.1","58.1","0","2017-01-17","2017-01-18","","0","0");
INSERT INTO contas_receber VALUES("1383","47","144","1","1","519.09","0","519.09","2017-01-17","2017-02-13","","1","1");
INSERT INTO contas_receber VALUES("1384","47","144","3","1","519.1","0","519.1","2017-01-17","2017-03-01","","1","1");
INSERT INTO contas_receber VALUES("1385","47","144","2","1","519.09","0","519.09","2017-01-17","2017-02-20","","1","1");
INSERT INTO contas_receber VALUES("1386","84","145","1","1","741.93","0","741.93","2017-01-17","2017-02-16","","1","1");
INSERT INTO contas_receber VALUES("1387","84","145","2","1","741.93","0","741.93","2017-01-17","2017-03-03","","1","1");
INSERT INTO contas_receber VALUES("1388","84","145","3","1","741.94","0","741.94","2017-01-17","2017-03-16","","1","1");
INSERT INTO contas_receber VALUES("1389","85","146","1","1","614.88","0","614.88","2017-01-17","2017-02-17","","1","1");
INSERT INTO contas_receber VALUES("1390","85","146","3","1","614.88","0","614.88","2017-01-17","2017-04-17","","1","1");
INSERT INTO contas_receber VALUES("1391","85","146","4","1","614.86","0","614.86","2017-01-17","2017-05-08","","1","1");
INSERT INTO contas_receber VALUES("1392","85","146","2","1","614.88","0","614.88","2017-01-17","2017-03-17","","1","1");
INSERT INTO contas_receber VALUES("1393","86","147","1","1","378.2","0","378.2","2017-01-17","2017-02-17","","1","1");
INSERT INTO contas_receber VALUES("1394","86","147","2","1","378.2","0","378.2","2017-01-17","2017-03-17","","1","1");
INSERT INTO contas_receber VALUES("1395","87","148","1","1","637.63","0","637.63","2017-01-17","2017-02-18","","1","1");
INSERT INTO contas_receber VALUES("1396","87","148","2","1","637.63","0","637.63","2017-01-17","2017-03-06","","1","1");
INSERT INTO contas_receber VALUES("1397","87","148","3","1","637.64","0","637.64","2017-01-17","2017-03-18","","1","1");
INSERT INTO contas_receber VALUES("1462","17","161","1","1","1070.03","1070.03","0","2017-01-18","2017-01-19","","0","0");
INSERT INTO contas_receber VALUES("1463","17","161","2","1","1070.03","1070.03","0","2017-01-18","2017-02-19","","0","0");
INSERT INTO contas_receber VALUES("1464","17","161","3","1","1070.04","1070.04","0","2017-01-18","2017-03-22","","0","0");
INSERT INTO contas_receber VALUES("1500","59","150","1","1","403.13","0","403.13","2017-01-19","2017-02-19","","1","1");
INSERT INTO contas_receber VALUES("1501","59","150","2","1","403.13","0","403.13","2017-01-19","2017-03-06","","1","1");
INSERT INTO contas_receber VALUES("1502","59","150","3","1","403.14","0","403.14","2017-01-19","2017-03-19","","1","1");
INSERT INTO contas_receber VALUES("1503","3","153","1","1","53.67","0","53.67","2017-01-19","2017-01-15","","1","1");
INSERT INTO contas_receber VALUES("1504","28","155","1","1","133.02","0","133.02","2017-01-19","2017-01-19","","1","1");
INSERT INTO contas_receber VALUES("1505","89","157","1","1","106","0","106","2017-01-19","2017-01-19","","1","1");
INSERT INTO contas_receber VALUES("1506","37","151","1","1","508.32","0","508.32","2017-01-19","2017-02-19","","1","1");
INSERT INTO contas_receber VALUES("1507","37","151","2","1","508.33","0","508.33","2017-01-19","2017-03-19","","1","1");
INSERT INTO contas_receber VALUES("1508","67","159","1","1","404.85","0","404.85","2017-01-19","2017-02-20","","1","1");
INSERT INTO contas_receber VALUES("1509","67","159","2","1","404.85","0","404.85","2017-01-19","2017-03-20","","1","1");
INSERT INTO contas_receber VALUES("1534","42","160","1","1","743.33","0","743.33","2017-01-23","2017-02-23","","1","1");
INSERT INTO contas_receber VALUES("1535","42","160","2","1","743.33","0","743.33","2017-01-23","2017-03-10","","1","1");
INSERT INTO contas_receber VALUES("1536","42","160","3","1","743.34","0","743.34","2017-01-23","2017-03-23","","1","1");
INSERT INTO contas_receber VALUES("1545","17","162","1","1","1070.7","0","1070.7","2017-01-24","2017-02-24","","1","1");
INSERT INTO contas_receber VALUES("1546","17","162","3","1","1070.7","0","1070.7","2017-01-24","2017-03-24","","1","1");
INSERT INTO contas_receber VALUES("1547","17","162","2","1","1070.7","0","1070.7","2017-01-24","2017-03-11","","1","1");
INSERT INTO contas_receber VALUES("1552","28","164","1","1","53","0","53","2017-01-24","2017-01-21","","1","1");
INSERT INTO contas_receber VALUES("1575","5","165","1","1","250.45","0","250.45","2017-01-25","2017-02-26","","1","1");
INSERT INTO contas_receber VALUES("1576","5","165","2","1","250.45","0","250.45","2017-01-25","2017-03-26","","1","1");
INSERT INTO contas_receber VALUES("1577","91","163","1","1","1413.2","0","1413.2","2017-01-25","2017-02-10","","1","1");
INSERT INTO contas_receber VALUES("1578","23","166","1","1","444.83","0","444.83","2017-01-25","2017-02-25","","1","1");
INSERT INTO contas_receber VALUES("1579","23","166","2","1","444.83","0","444.83","2017-01-25","2017-03-12","","1","1");
INSERT INTO contas_receber VALUES("1580","23","166","3","1","444.84","0","444.84","2017-01-25","2017-03-25","","1","1");
INSERT INTO contas_receber VALUES("1599","88","156","1","1","60","0","60","2017-01-26","2017-01-19","","1","1");
INSERT INTO contas_receber VALUES("1600","3","169","1","1","41.86","0","41.86","2017-01-26","2017-01-22","","1","1");
INSERT INTO contas_receber VALUES("1601","89","171","1","1","106","0","106","2017-01-26","2017-01-22","","1","1");
INSERT INTO contas_receber VALUES("1606","77","180","1","1","47.16","0","47.16","2017-01-27","2017-01-28","","1","1");
INSERT INTO contas_receber VALUES("1607","92","168","1","1","346.83","0","346.83","2017-01-27","2017-02-27","","1","1");
INSERT INTO contas_receber VALUES("1608","92","168","2","1","346.83","0","346.83","2017-01-27","2017-03-14","","1","1");
INSERT INTO contas_receber VALUES("1609","92","168","3","1","346.84","0","346.84","2017-01-27","2017-03-27","","1","1");
INSERT INTO contas_receber VALUES("1610","32","170","1","1","37.89","0","37.89","2017-01-27","2017-01-22","","1","1");
INSERT INTO contas_receber VALUES("1611","24","167","1","1","968.75","0","968.75","2017-01-27","2017-02-15","","1","1");
INSERT INTO contas_receber VALUES("1612","24","167","2","1","968.75","0","968.75","2017-01-27","2017-02-15","","1","1");
INSERT INTO contas_receber VALUES("1621","97","181","1","1","145","0","145","2017-01-27","2017-03-05","","1","1");
INSERT INTO contas_receber VALUES("1622","97","181","2","1","145","0","145","2017-01-27","2017-04-05","","1","1");
INSERT INTO contas_receber VALUES("1632","99","184","1","1","3323","3323","0","2017-01-31","2017-02-01","","0","0");
INSERT INTO contas_receber VALUES("1639","96","179","1","1","462.6","0","462.6","2017-01-31","2017-01-28","","1","1");
INSERT INTO contas_receber VALUES("1640","3","178","1","1","97.79","0","97.79","2017-01-31","2017-01-28","","1","1");
INSERT INTO contas_receber VALUES("1674","4","172","1","1","1050.67","0","1050.67","2017-02-01","2017-03-02","","1","1");
INSERT INTO contas_receber VALUES("1675","4","172","2","1","1050.67","0","1050.67","2017-02-01","2017-03-17","","1","1");
INSERT INTO contas_receber VALUES("1676","4","172","3","1","1050.66","0","1050.66","2017-02-01","2017-04-02","","1","1");
INSERT INTO contas_receber VALUES("1677","8","175","1","1","388","0","388","2017-02-01","2017-03-02","","1","1");
INSERT INTO contas_receber VALUES("1678","8","175","2","1","388","0","388","2017-02-01","2017-03-17","","1","1");
INSERT INTO contas_receber VALUES("1679","8","175","3","1","388","0","388","2017-02-01","2017-04-02","","1","1");
INSERT INTO contas_receber VALUES("1680","94","176","1","1","471.99","0","471.99","2017-02-01","2017-03-03","","1","1");
INSERT INTO contas_receber VALUES("1681","94","176","2","1","471.99","0","471.99","2017-02-01","2017-04-03","","1","1");
INSERT INTO contas_receber VALUES("1692","100","190","1","1","84.8","84.8","0","2017-02-02","2017-02-04","","0","0");
INSERT INTO contas_receber VALUES("1710","100","195","1","1","84.8","84.8","0","2017-02-03","2017-02-07","","0","0");
INSERT INTO contas_receber VALUES("1711","25","173","1","1","405.07","0","405.07","2017-02-03","2017-03-03","","1","1");
INSERT INTO contas_receber VALUES("1712","25","173","2","1","405.07","0","405.07","2017-02-03","2017-03-18","","1","1");
INSERT INTO contas_receber VALUES("1713","25","173","3","1","405.06","0","405.06","2017-02-03","2017-04-03","","1","1");
INSERT INTO contas_receber VALUES("1714","93","174","1","1","311.4","0","311.4","2017-02-03","2017-03-03","","1","1");
INSERT INTO contas_receber VALUES("1715","93","174","2","1","311.4","0","311.4","2017-02-03","2017-04-03","","1","1");
INSERT INTO contas_receber VALUES("1716","95","177","1","1","216.68","216.68","0","2017-02-03","2017-03-03","","0","0");
INSERT INTO contas_receber VALUES("1717","28","183","1","1","270.14","0","270.14","2017-02-03","2017-02-01","","1","1");
INSERT INTO contas_receber VALUES("1725","98","182","1","1","609.67","0","609.67","2017-02-07","2017-03-06","","1","1");
INSERT INTO contas_receber VALUES("1726","98","182","2","1","609.67","0","609.67","2017-02-07","2017-04-06","","1","1");
INSERT INTO contas_receber VALUES("1727","98","182","3","1","609.66","0","609.66","2017-02-07","2017-05-06","","1","1");
INSERT INTO contas_receber VALUES("1728","35","185","1","1","118.9","0","118.9","2017-02-07","2017-02-02","","1","1");
INSERT INTO contas_receber VALUES("1729","31","189","1","1","330.8","0","330.8","2017-02-07","2017-03-06","","1","1");
INSERT INTO contas_receber VALUES("1730","31","189","3","1","330.8","0","330.8","2017-02-07","2017-04-06","","1","1");
INSERT INTO contas_receber VALUES("1731","31","189","2","1","330.8","0","330.8","2017-02-07","2017-03-21","","1","1");
INSERT INTO contas_receber VALUES("1734","81","186","1","1","209.85","209.85","0","2017-02-07","2017-03-03","","0","0");
INSERT INTO contas_receber VALUES("1735","81","186","2","1","209.85","209.85","0","2017-02-07","2017-04-03","","0","0");
INSERT INTO contas_receber VALUES("1736","44","187","3","1","544.86","544.86","0","2017-02-07","2017-04-08","","0","0");
INSERT INTO contas_receber VALUES("1737","44","187","2","1","544.87","544.87","0","2017-02-07","2017-03-23","","0","0");
INSERT INTO contas_receber VALUES("1738","44","187","1","1","544.87","544.87","0","2017-02-07","2017-03-08","","0","0");
INSERT INTO contas_receber VALUES("1739","89","192","1","1","354.3","0","354.3","2017-02-07","2017-02-04","","1","1");
INSERT INTO contas_receber VALUES("1740","94","191","1","1","204.32","0","204.32","2017-02-07","2017-03-06","","1","1");
INSERT INTO contas_receber VALUES("1741","22","188","1","1","442.9","442.9","0","2017-02-07","2017-03-09","","0","0");
INSERT INTO contas_receber VALUES("1742","22","188","2","1","442.9","442.9","0","2017-02-07","2017-03-24","","0","0");
INSERT INTO contas_receber VALUES("1743","22","188","3","1","442.9","442.9","0","2017-02-07","2017-04-09","","0","0");
INSERT INTO contas_receber VALUES("1744","3","193","1","1","165.25","0","165.25","2017-02-07","2017-02-04","","1","1");
INSERT INTO contas_receber VALUES("1931","30","201","1","1","890.73","890.73","0","2017-02-08","2017-02-14","","0","0");
INSERT INTO contas_receber VALUES("1932","30","201","2","1","890.73","890.73","0","2017-02-08","2017-03-17","","0","0");
INSERT INTO contas_receber VALUES("1933","30","201","3","1","890.74","890.74","0","2017-02-08","2017-04-17","","0","0");
INSERT INTO contas_receber VALUES("1966","19","196","1","1","450.15","450.15","0","2017-02-09","2017-03-10","","0","0");
INSERT INTO contas_receber VALUES("1967","19","196","2","1","450.15","450.15","0","2017-02-09","2017-04-10","","0","0");
INSERT INTO contas_receber VALUES("1968","103","199","1","1","415.83","0","415.83","2017-02-09","2017-03-10","","1","1");
INSERT INTO contas_receber VALUES("1969","103","199","2","1","415.83","0","415.83","2017-02-09","2017-03-30","","1","1");
INSERT INTO contas_receber VALUES("1970","103","199","3","1","415.84","0","415.84","2017-02-09","2017-04-09","","1","1");
INSERT INTO contas_receber VALUES("1971","43","205","1","1","238","0","238","2017-02-09","2017-03-10","","1","1");
INSERT INTO contas_receber VALUES("1972","105","200","1","1","100","0","100","2017-02-09","2017-02-09","","1","1");
INSERT INTO contas_receber VALUES("1974","101","194","1","1","5882","5882","0","2017-02-09","2017-02-06","","0","0");
INSERT INTO contas_receber VALUES("1989","33","207","1","1","410.9","410.9","0","2017-02-10","2017-02-12","","0","0");
INSERT INTO contas_receber VALUES("1990","33","207","2","1","410.9","410.9","0","2017-02-10","2017-03-15","","0","0");
INSERT INTO contas_receber VALUES("1991","33","207","3","1","410.9","410.9","0","2017-02-10","2017-04-15","","0","0");
INSERT INTO contas_receber VALUES("2137","105","210","1","1","200","0","200","2017-02-14","2017-02-16","","1","1");
INSERT INTO contas_receber VALUES("2155","30","202","1","1","687.7","0","687.7","2017-02-17","2017-03-15","","1","1");
INSERT INTO contas_receber VALUES("2156","30","202","2","1","687.7","0","687.7","2017-02-17","2017-03-30","","1","1");
INSERT INTO contas_receber VALUES("2157","30","202","3","1","687.7","0","687.7","2017-02-17","2017-04-10","","1","1");
INSERT INTO contas_receber VALUES("2158","30","202","4","1","687.7","0","687.7","2017-02-17","2017-05-19","","1","1");
INSERT INTO contas_receber VALUES("2159","108","206","1","1","851.2","0","851.2","2017-02-17","2017-03-16","","1","1");
INSERT INTO contas_receber VALUES("2160","108","206","2","1","851.2","0","851.2","2017-02-17","2017-03-31","","1","1");
INSERT INTO contas_receber VALUES("2161","108","206","3","1","851.2","0","851.2","2017-02-17","2017-04-15","","1","1");
INSERT INTO contas_receber VALUES("2162","108","206","4","1","851.2","0","851.2","2017-02-17","2017-04-30","","1","1");
INSERT INTO contas_receber VALUES("2163","108","206","5","1","851.2","0","851.2","2017-02-17","2017-05-15","","1","1");
INSERT INTO contas_receber VALUES("2164","106","203","1","1","414.5","0","414.5","2017-02-17","2017-03-14","","1","1");
INSERT INTO contas_receber VALUES("2165","106","203","2","1","414.5","0","414.5","2017-02-17","2017-03-29","","1","1");
INSERT INTO contas_receber VALUES("2166","106","203","3","1","414.5","0","414.5","2017-02-17","2017-04-14","","1","1");
INSERT INTO contas_receber VALUES("2174","33","208","1","1","410.9","410.9","0","2017-02-17","2017-02-15","","0","0");
INSERT INTO contas_receber VALUES("2175","33","208","2","1","410.9","410.9","0","2017-02-17","2017-03-18","","0","0");
INSERT INTO contas_receber VALUES("2176","33","208","3","1","410.9","410.9","0","2017-02-17","2017-04-18","","0","0");
INSERT INTO contas_receber VALUES("2177","109","211","1","1","184.9","0","184.9","2017-02-17","2017-03-20","","1","1");
INSERT INTO contas_receber VALUES("2178","4","209","1","1","1061.33","0","1061.33","2017-02-17","2017-03-22","","1","1");
INSERT INTO contas_receber VALUES("2179","4","209","2","1","1061.33","0","1061.33","2017-02-17","2017-04-06","","1","1");
INSERT INTO contas_receber VALUES("2180","4","209","3","1","1061.34","0","1061.34","2017-02-17","2017-04-22","","1","1");
INSERT INTO contas_receber VALUES("2181","88","212","1","1","31.91","0","31.91","2017-02-17","2017-02-16","","1","1");
INSERT INTO contas_receber VALUES("2208","8","217","1","1","52.7","0","52.7","2017-02-21","2017-02-18","","1","1");
INSERT INTO contas_receber VALUES("2209","110","213","1","1","100.35","0","100.35","2017-02-21","2017-02-16","","1","1");
INSERT INTO contas_receber VALUES("2210","111","214","1","1","173.99","0","173.99","2017-02-21","2017-02-16","","1","1");
INSERT INTO contas_receber VALUES("2211","3","220","1","1","316.22","0","316.22","2017-02-21","2017-02-22","","1","1");
INSERT INTO contas_receber VALUES("2212","114","221","1","1","120.39","0","120.39","2017-02-21","2017-02-22","","1","1");
INSERT INTO contas_receber VALUES("2222","117","225","1","1","619.44","619.44","0","2017-02-23","2017-02-24","","0","0");
INSERT INTO contas_receber VALUES("2244","120","230","1","1","31.91","31.91","0","2017-02-24","2017-02-25","","0","0");
INSERT INTO contas_receber VALUES("2250","88","233","1","1","65.66","65.66","0","2017-02-24","2017-02-25","","0","0");
INSERT INTO contas_receber VALUES("2267","122","235","1","1","408.9","408.9","0","2017-03-02","2017-03-05","","0","0");
INSERT INTO contas_receber VALUES("2268","122","235","2","1","408.9","408.9","0","2017-03-02","2017-04-05","","0","0");
INSERT INTO contas_receber VALUES("2269","122","235","3","1","408.9","408.9","0","2017-03-02","2017-05-06","","0","0");
INSERT INTO contas_receber VALUES("2270","112","215","1","1","121.88","0","121.88","2017-03-02","2017-02-18","","1","1");
INSERT INTO contas_receber VALUES("2271","113","216","1","1","400.07","0","400.07","2017-03-02","2017-03-23","","1","1");
INSERT INTO contas_receber VALUES("2272","113","216","2","1","400.07","0","400.07","2017-03-02","2017-04-06","","1","1");
INSERT INTO contas_receber VALUES("2273","113","216","3","1","400.06","0","400.06","2017-03-02","2017-04-23","","1","1");
INSERT INTO contas_receber VALUES("2274","60","218","1","1","494.17","0","494.17","2017-03-02","2017-03-24","","1","1");
INSERT INTO contas_receber VALUES("2275","60","218","2","1","494.17","0","494.17","2017-03-02","2017-04-08","","1","1");
INSERT INTO contas_receber VALUES("2276","60","218","3","1","494.16","0","494.16","2017-03-02","2017-04-24","","1","1");
INSERT INTO contas_receber VALUES("2277","31","219","1","1","330.8","0","330.8","2017-03-02","2017-03-24","","1","1");
INSERT INTO contas_receber VALUES("2278","31","219","2","1","330.8","0","330.8","2017-03-02","2017-04-08","","1","1");
INSERT INTO contas_receber VALUES("2279","31","219","3","1","330.8","0","330.8","2017-03-02","2017-04-24","","1","1");
INSERT INTO contas_receber VALUES("2280","107","204","1","1","144.4","0","144.4","2017-03-02","2017-02-10","","1","1");
INSERT INTO contas_receber VALUES("2281","43","226","1","1","284.1","0","284.1","2017-03-02","2017-03-24","","1","1");
INSERT INTO contas_receber VALUES("2284","5","227","1","1","339.2","339.2","0","2017-03-02","2017-04-01","","0","0");
INSERT INTO contas_receber VALUES("2323","115","222","1","1","275.82","0","275.82","2017-03-06","2017-04-02","","1","1");
INSERT INTO contas_receber VALUES("2324","115","222","2","1","275.82","0","275.82","2017-03-06","2017-03-17","","1","1");
INSERT INTO contas_receber VALUES("2325","115","222","3","1","275.81","0","275.81","2017-03-06","2017-05-02","","1","1");
INSERT INTO contas_receber VALUES("2326","62","223","1","1","394.62","0","394.62","2017-03-06","2017-04-03","","1","1");
INSERT INTO contas_receber VALUES("2327","62","223","2","1","394.62","0","394.62","2017-03-06","2017-04-18","","1","1");
INSERT INTO contas_receber VALUES("2328","62","223","3","1","394.62","0","394.62","2017-03-06","2017-05-03","","1","1");
INSERT INTO contas_receber VALUES("2329","121","232","1","1","34","0","34","2017-03-06","2017-02-26","","1","1");
INSERT INTO contas_receber VALUES("2330","19","234","1","1","322.25","0","322.25","2017-03-06","2017-04-03","","1","1");
INSERT INTO contas_receber VALUES("2331","19","234","2","1","322.25","0","322.25","2017-03-06","2017-05-03","","1","1");
INSERT INTO contas_receber VALUES("2332","3","231","1","1","67.65","0","67.65","2017-03-06","2017-02-26","","1","1");
INSERT INTO contas_receber VALUES("2333","89","236","1","1","296.34","0","296.34","2017-03-06","2017-03-05","","1","1");
INSERT INTO contas_receber VALUES("2334","3","238","1","1","13.52","0","13.52","2017-03-06","2017-03-05","","1","1");
INSERT INTO contas_receber VALUES("2335","116","224","1","1","75","0","75","2017-03-06","2017-02-24","","1","1");
INSERT INTO contas_receber VALUES("2350","4","237","1","1","1030.67","0","1030.67","2017-03-08","2017-04-08","","1","1");
INSERT INTO contas_receber VALUES("2351","4","237","3","1","1030.66","0","1030.66","2017-03-08","2017-05-08","","1","1");
INSERT INTO contas_receber VALUES("2352","4","237","2","1","1030.67","0","1030.67","2017-03-08","2017-04-23","","1","1");
INSERT INTO contas_receber VALUES("2375","119","229","1","1","53.19","0","53.19","2017-03-09","2017-02-26","","1","1");
INSERT INTO contas_receber VALUES("2380","41","239","1","1","832.18","832.18","0","2017-03-09","2017-04-09","","0","0");
INSERT INTO contas_receber VALUES("2381","41","239","2","1","832.18","832.18","0","2017-03-09","2017-04-29","","0","0");
INSERT INTO contas_receber VALUES("2382","41","239","3","1","832.18","832.18","0","2017-03-09","2017-05-19","","0","0");
INSERT INTO contas_receber VALUES("2383","41","239","4","1","832.16","832.16","0","2017-03-09","2017-06-08","","0","0");
INSERT INTO contas_receber VALUES("2384","31","240","1","1","330.8","0","330.8","2017-03-09","2017-04-10","","1","1");
INSERT INTO contas_receber VALUES("2385","31","240","2","1","330.8","0","330.8","2017-03-09","2017-04-25","","1","1");
INSERT INTO contas_receber VALUES("2386","31","240","3","1","330.8","0","330.8","2017-03-09","2017-05-10","","1","1");
INSERT INTO contas_receber VALUES("2387","46","244","1","1","310","0","310","2017-03-09","2017-04-10","","1","1");
INSERT INTO contas_receber VALUES("2388","7","243","1","1","131.1","0","131.1","2017-03-09","2017-04-10","","1","1");
INSERT INTO contas_receber VALUES("2389","7","243","2","1","131.1","0","131.1","2017-03-09","2017-05-10","","1","1");
INSERT INTO contas_receber VALUES("2407","32","246","1","1","100.16","0","100.16","2017-03-13","2017-04-10","","1","1");
INSERT INTO contas_receber VALUES("2408","6","241","1","1","529.23","0","529.23","2017-03-13","2017-04-13","","1","1");
INSERT INTO contas_receber VALUES("2409","6","241","2","1","529.23","0","529.23","2017-03-13","2017-04-20","","1","1");
INSERT INTO contas_receber VALUES("2410","6","241","3","1","529.24","0","529.24","2017-03-13","2017-04-27","","1","1");
INSERT INTO contas_receber VALUES("2411","125","248","1","1","380.5","0","380.5","2017-03-13","2017-04-14","","1","1");
INSERT INTO contas_receber VALUES("2412","125","248","2","1","380.5","0","380.5","2017-03-13","2017-04-29","","1","1");
INSERT INTO contas_receber VALUES("2413","125","248","3","1","380.5","0","380.5","2017-03-13","2017-05-14","","1","1");
INSERT INTO contas_receber VALUES("2418","9","245","1","1","502.18","502.18","0","2017-03-13","2017-04-14","","0","0");
INSERT INTO contas_receber VALUES("2419","9","245","2","1","502.18","502.18","0","2017-03-13","2017-04-29","","0","0");
INSERT INTO contas_receber VALUES("2420","9","245","3","1","502.18","502.18","0","2017-03-13","2017-05-14","","0","0");
INSERT INTO contas_receber VALUES("2421","9","245","4","1","291.6","291.6","0","2017-03-13","2017-05-20","","0","0");
INSERT INTO contas_receber VALUES("2422","124","242","1","1","1596.6","0","1596.6","2017-03-13","2017-04-21","","1","1");
INSERT INTO contas_receber VALUES("2435","17","254","1","1","3043.02","3043.02","0","2017-03-13","2017-03-16","","0","0");
INSERT INTO contas_receber VALUES("2436","17","254","2","1","3043.02","3043.02","0","2017-03-13","2017-04-16","","0","0");
INSERT INTO contas_receber VALUES("2437","17","254","3","1","3043.01","3043.01","0","2017-03-13","2017-05-17","","0","0");
INSERT INTO contas_receber VALUES("2517","3","247","1","1","159.87","0","159.87","2017-03-16","2017-03-10","","1","1");
INSERT INTO contas_receber VALUES("2518","130","257","1","1","331.5","0","331.5","2017-03-16","2017-03-16","","1","1");
INSERT INTO contas_receber VALUES("2529","131","264","1","1","383.9","383.9","0","2017-03-17","2017-03-21","","0","0");
INSERT INTO contas_receber VALUES("2530","131","264","2","1","383.9","383.9","0","2017-03-17","2017-04-21","","0","0");
INSERT INTO contas_receber VALUES("2533","131","265","2","1","393.55","393.55","0","2017-03-17","2017-04-18","","0","0");
INSERT INTO contas_receber VALUES("2534","131","265","1","1","393.55","393.55","0","2017-03-17","2017-03-18","","0","0");
INSERT INTO contas_receber VALUES("2550","132","267","1","1","90.96","90.96","0","2017-03-20","2017-03-21","","0","0");
INSERT INTO contas_receber VALUES("2561","3","269","1","1","99.1","99.1","0","2017-03-21","2017-03-23","","0","0");
INSERT INTO contas_receber VALUES("2566","127","250","1","1","451.2","0","451.2","2017-03-21","2017-03-31","","1","1");
INSERT INTO contas_receber VALUES("2567","128","251","1","1","246.9","0","246.9","2017-03-21","2017-04-21","","1","1");
INSERT INTO contas_receber VALUES("2568","129","252","1","1","454.5","0","454.5","2017-03-21","2017-04-17","","1","1");
INSERT INTO contas_receber VALUES("2569","129","252","2","1","454.5","0","454.5","2017-03-21","2017-05-02","","1","1");
INSERT INTO contas_receber VALUES("2570","129","252","3","1","454.5","0","454.5","2017-03-21","2017-05-17","","1","1");
INSERT INTO contas_receber VALUES("2571","115","253","1","1","378","0","378","2017-03-21","2017-04-17","","1","1");
INSERT INTO contas_receber VALUES("2572","46","263","1","1","56.3","0","56.3","2017-03-21","2017-04-20","","1","1");
INSERT INTO contas_receber VALUES("2573","83","260","1","1","205.34","0","205.34","2017-03-21","2017-04-20","","1","1");
INSERT INTO contas_receber VALUES("2574","83","260","2","1","205.34","0","205.34","2017-03-21","2017-05-20","","1","1");
INSERT INTO contas_receber VALUES("2575","28","261","1","1","222.28","0","222.28","2017-03-21","2017-03-19","","1","1");
INSERT INTO contas_receber VALUES("2579","132","273","1","1","90.96","90.96","0","2017-03-21","2017-03-22","","0","0");
INSERT INTO contas_receber VALUES("2580","132","268","1","1","90.96","90.96","0","2017-03-21","2017-03-22","","0","0");
INSERT INTO contas_receber VALUES("2595","132","274","1","1","90.96","90.96","0","2017-03-24","2017-03-25","","0","0");
INSERT INTO contas_receber VALUES("2596","132","278","1","1","90.96","90.96","0","2017-03-24","2017-03-25","","0","0");
INSERT INTO contas_receber VALUES("2599","17","255","1","1","1853.02","0","1853.02","2017-03-28","2017-04-21","","1","1");
INSERT INTO contas_receber VALUES("2600","17","255","2","1","1853.02","0","1853.02","2017-03-28","2017-05-08","","1","1");
INSERT INTO contas_receber VALUES("2601","17","255","3","1","1853.01","0","1853.01","2017-03-28","2017-05-21","","1","1");
INSERT INTO contas_receber VALUES("2602","98","256","1","1","680.67","0","680.67","2017-03-28","2017-04-23","","1","1");
INSERT INTO contas_receber VALUES("2603","98","256","2","1","680.67","0","680.67","2017-03-28","2017-05-23","","1","1");
INSERT INTO contas_receber VALUES("2604","98","256","3","1","680.66","0","680.66","2017-03-28","2017-05-23","","1","1");
INSERT INTO contas_receber VALUES("2608","84","258","1","1","915.6","0","915.6","2017-03-28","2017-04-22","","1","1");
INSERT INTO contas_receber VALUES("2609","84","258","2","1","915.6","0","915.6","2017-03-28","2017-05-08","","1","1");
INSERT INTO contas_receber VALUES("2610","84","258","3","1","915.6","0","915.6","2017-03-28","2017-05-22","","1","1");
INSERT INTO contas_receber VALUES("2611","86","259","1","1","449.67","0","449.67","2017-03-28","2017-04-22","","1","1");
INSERT INTO contas_receber VALUES("2612","86","259","2","1","449.67","0","449.67","2017-03-28","2017-05-22","","1","1");
INSERT INTO contas_receber VALUES("2613","86","259","3","1","449.66","0","449.66","2017-03-28","2017-06-22","","1","1");
INSERT INTO contas_receber VALUES("2614","22","262","1","1","743.97","0","743.97","2017-03-28","2017-04-24","","1","1");
INSERT INTO contas_receber VALUES("2615","22","262","2","1","743.97","0","743.97","2017-03-28","2017-05-09","","1","1");
INSERT INTO contas_receber VALUES("2616","22","262","3","1","743.96","0","743.96","2017-03-28","2017-05-24","","1","1");
INSERT INTO contas_receber VALUES("2617","44","266","1","1","510.9","0","510.9","2017-03-28","2017-04-28","","1","1");
INSERT INTO contas_receber VALUES("2618","44","266","2","1","510.9","0","510.9","2017-03-28","2017-05-13","","1","1");
INSERT INTO contas_receber VALUES("2619","44","266","3","1","510.9","0","510.9","2017-03-28","2017-05-28","","1","1");
INSERT INTO contas_receber VALUES("2620","133","270","1","1","144.6","0","144.6","2017-03-28","2017-03-23","","1","1");
INSERT INTO contas_receber VALUES("2621","3","271","1","1","94.17","0","94.17","2017-03-28","2017-03-23","","1","1");
INSERT INTO contas_receber VALUES("2624","24","272","1","1","700.15","700.15","0","2017-03-28","2017-04-13","","0","0");
INSERT INTO contas_receber VALUES("2625","24","272","2","1","700.15","700.15","0","2017-03-28","2017-04-13","","0","0");
INSERT INTO contas_receber VALUES("2626","96","275","1","1","158.79","0","158.79","2017-03-28","2017-03-23","","1","1");
INSERT INTO contas_receber VALUES("2627","31","276","1","1","163.2","0","163.2","2017-03-28","2017-04-28","","1","1");
INSERT INTO contas_receber VALUES("2628","135","277","1","1","295","0","295","2017-03-28","2017-03-26","","1","1");
INSERT INTO contas_receber VALUES("2629","136","279","1","1","78.6","0","78.6","2017-03-28","2017-03-29","","1","1");
INSERT INTO contas_receber VALUES("2666","139","283","1","1","402.37","402.37","0","2017-03-28","2017-03-30","","0","0");
INSERT INTO contas_receber VALUES("2667","139","283","2","1","402.37","402.37","0","2017-03-28","2017-04-30","","0","0");
INSERT INTO contas_receber VALUES("2668","139","283","3","1","402.36","402.36","0","2017-03-28","2017-05-31","","0","0");
INSERT INTO contas_receber VALUES("2709","138","281","1","1","462.73","0","462.73","2017-03-31","2017-04-30","","1","1");
INSERT INTO contas_receber VALUES("2710","138","281","2","1","462.73","0","462.73","2017-03-31","2017-05-15","","1","1");
INSERT INTO contas_receber VALUES("2711","138","281","3","1","462.74","0","462.74","2017-03-31","2017-05-30","","1","1");
INSERT INTO contas_receber VALUES("2712","4","282","1","1","948.67","0","948.67","2017-03-31","2017-05-06","","1","1");
INSERT INTO contas_receber VALUES("2713","4","282","2","1","948.67","0","948.67","2017-03-31","2017-05-21","","1","1");
INSERT INTO contas_receber VALUES("2714","4","282","3","1","948.66","0","948.66","2017-03-31","2017-06-06","","1","1");
INSERT INTO contas_receber VALUES("2718","139","284","1","1","402.37","402.37","0","2017-03-31","2017-05-04","","0","0");
INSERT INTO contas_receber VALUES("2719","139","284","2","1","402.37","402.37","0","2017-03-31","2017-05-19","","0","0");
INSERT INTO contas_receber VALUES("2720","139","284","3","1","402.36","402.36","0","2017-03-31","2017-06-04","","0","0");
INSERT INTO contas_receber VALUES("2721","140","285","1","1","373.6","0","373.6","2017-03-31","2017-05-05","","1","1");
INSERT INTO contas_receber VALUES("2749","25","297","2","1","1207.65","1207.65","0","2017-04-03","2017-05-06","","0","0");
INSERT INTO contas_receber VALUES("2750","25","297","1","1","1207.65","1207.65","0","2017-04-03","2017-04-05","","0","0");
INSERT INTO contas_receber VALUES("2751","25","297","3","1","1207.65","1207.65","0","2017-04-03","2017-06-06","","0","0");
INSERT INTO contas_receber VALUES("2752","83","286","1","1","75.65","0","75.65","2017-04-04","2017-05-30","","1","1");
INSERT INTO contas_receber VALUES("2753","141","288","1","1","225.78","0","225.78","2017-04-04","2017-05-05","","1","1");
INSERT INTO contas_receber VALUES("2754","141","288","2","1","225.77","0","225.77","2017-04-04","2017-06-05","","1","1");
INSERT INTO contas_receber VALUES("2755","23","289","1","1","406.83","406.83","0","2017-04-04","2017-05-06","","0","0");
INSERT INTO contas_receber VALUES("2756","23","289","2","1","406.83","406.83","0","2017-04-04","2017-05-21","","0","0");
INSERT INTO contas_receber VALUES("2757","23","289","3","1","406.84","406.84","0","2017-04-04","2017-06-06","","0","0");
INSERT INTO contas_receber VALUES("2760","70","290","1","1","692.43","692.43","0","2017-04-04","2017-04-24","","0","0");
INSERT INTO contas_receber VALUES("2761","70","290","2","1","692.43","692.43","0","2017-04-04","2017-04-24","","0","0");
INSERT INTO contas_receber VALUES("2762","142","291","1","1","203.78","0","203.78","2017-04-04","2017-05-05","","1","1");
INSERT INTO contas_receber VALUES("2763","96","292","1","1","135.57","0","135.57","2017-04-04","2017-04-02","","1","1");
INSERT INTO contas_receber VALUES("2767","19","293","1","1","286.25","286.25","0","2017-04-04","2017-05-06","","0","0");
INSERT INTO contas_receber VALUES("2768","19","293","3","1","286.26","286.26","0","2017-04-04","2017-06-06","","0","0");
INSERT INTO contas_receber VALUES("2769","19","293","2","1","286.25","286.25","0","2017-04-04","2017-05-20","","0","0");
INSERT INTO contas_receber VALUES("2770","67","294","1","1","337.67","0","337.67","2017-04-04","2017-05-07","","1","1");
INSERT INTO contas_receber VALUES("2771","67","294","2","1","337.67","0","337.67","2017-04-04","2017-05-22","","1","1");
INSERT INTO contas_receber VALUES("2772","67","294","3","1","337.66","0","337.66","2017-04-04","2017-06-07","","1","1");
INSERT INTO contas_receber VALUES("2773","32","295","1","1","38.66","0","38.66","2017-04-04","2017-04-02","","1","1");
INSERT INTO contas_receber VALUES("2774","54","287","1","1","126.86","0","126.86","2017-04-04","2017-03-31","","1","1");
INSERT INTO contas_receber VALUES("2793","9","300","1","1","213.07","0","213.07","2017-04-07","2017-04-06","","1","1");
INSERT INTO contas_receber VALUES("2794","9","300","2","1","213.07","0","213.07","2017-04-07","2017-05-07","","1","1");
INSERT INTO contas_receber VALUES("2795","9","300","3","1","213.06","0","213.06","2017-04-07","2017-06-07","","1","1");
INSERT INTO contas_receber VALUES("2809","3","306","1","1","147.81","0","147.81","2017-04-11","2017-04-12","","1","1");
INSERT INTO contas_receber VALUES("2822","30","303","1","1","714.75","0","714.75","2017-04-12","2017-05-12","","1","1");
INSERT INTO contas_receber VALUES("2823","30","303","4","1","714.75","0","714.75","2017-04-12","2017-06-16","","1","1");
INSERT INTO contas_receber VALUES("2824","30","303","3","1","714.75","0","714.75","2017-04-12","2017-06-06","","1","1");
INSERT INTO contas_receber VALUES("2825","30","303","2","1","714.75","0","714.75","2017-04-12","2017-05-27","","1","1");
INSERT INTO contas_receber VALUES("2850","146","304","1","1","636.67","0","636.67","2017-04-17","2017-05-13","","1","1");
INSERT INTO contas_receber VALUES("2851","146","304","2","1","636.67","0","636.67","2017-04-17","2017-05-29","","1","1");
INSERT INTO contas_receber VALUES("2852","146","304","3","1","636.66","0","636.66","2017-04-17","2017-06-13","","1","1");
INSERT INTO contas_receber VALUES("2853","147","305","1","1","311.96","0","311.96","2017-04-17","2017-05-04","","1","1");
INSERT INTO contas_receber VALUES("2860","42","308","1","1","1090.33","0","1090.33","2017-04-17","2017-05-18","","1","1");
INSERT INTO contas_receber VALUES("2861","42","308","3","1","1090.34","0","1090.34","2017-04-17","2017-06-18","","1","1");
INSERT INTO contas_receber VALUES("2862","42","308","2","1","1090.33","0","1090.33","2017-04-17","2017-06-02","","1","1");
INSERT INTO contas_receber VALUES("2883","59","316","1","1","306.43","306.43","0","2017-04-18","2017-04-20","","0","0");
INSERT INTO contas_receber VALUES("2884","59","316","2","1","306.43","306.43","0","2017-04-18","2017-05-21","","0","0");
INSERT INTO contas_receber VALUES("2885","59","316","3","1","306.44","306.44","0","2017-04-18","2017-06-21","","0","0");
INSERT INTO contas_receber VALUES("2910","144","301","1","1","1213","0","1213","2017-04-19","2017-04-06","","1","1");
INSERT INTO contas_receber VALUES("2911","4","307","1","1","928","0","928","2017-04-19","2017-05-19","","1","1");
INSERT INTO contas_receber VALUES("2912","4","307","2","1","928","0","928","2017-04-19","2017-06-03","","1","1");
INSERT INTO contas_receber VALUES("2913","4","307","3","1","928","0","928","2017-04-19","2017-06-19","","1","1");
INSERT INTO contas_receber VALUES("2914","148","309","1","1","254.88","0","254.88","2017-04-19","2017-05-19","","1","1");
INSERT INTO contas_receber VALUES("2915","148","309","2","1","254.87","0","254.87","2017-04-19","2017-06-19","","1","1");
INSERT INTO contas_receber VALUES("2916","126","249","1","1","64","0","64","2017-04-19","2017-03-10","","1","1");
INSERT INTO contas_receber VALUES("2917","3","311","1","1","20.74","0","20.74","2017-04-19","2017-04-15","","1","1");
INSERT INTO contas_receber VALUES("2926","150","314","1","1","62.07","0","62.07","2017-04-20","2017-04-20","","1","1");
INSERT INTO contas_receber VALUES("2927","151","315","1","1","174.02","0","174.02","2017-04-20","2017-04-20","","1","1");
INSERT INTO contas_receber VALUES("2929","130","318","1","1","564.3","564.3","0","2017-04-20","2017-04-22","","0","0");
INSERT INTO contas_receber VALUES("2932","145","302","1","1","129.88","0","129.88","2017-04-24","2017-04-07","","1","1");
INSERT INTO contas_receber VALUES("2933","149","310","1","1","548.77","0","548.77","2017-04-24","2017-05-20","","1","1");
INSERT INTO contas_receber VALUES("2934","149","310","3","1","548.76","0","548.76","2017-04-24","2017-06-20","","1","1");
INSERT INTO contas_receber VALUES("2935","149","310","2","1","548.77","0","548.77","2017-04-24","2017-06-05","","1","1");
INSERT INTO contas_receber VALUES("2936","37","313","1","1","348.25","0","348.25","2017-04-24","2017-05-20","","1","1");
INSERT INTO contas_receber VALUES("2937","37","313","2","1","348.25","0","348.25","2017-04-24","2017-06-05","","1","1");
INSERT INTO contas_receber VALUES("2938","37","313","3","1","348.24","0","348.24","2017-04-24","2017-06-20","","1","1");
INSERT INTO contas_receber VALUES("2939","3","320","1","1","40.41","0","40.41","2017-04-24","2017-04-22","","1","1");
INSERT INTO contas_receber VALUES("2940","143","296","1","1","1077.4","0","1077.4","2017-04-24","2017-04-03","","1","1");
INSERT INTO contas_receber VALUES("2965","60","312","1","1","520.27","0","520.27","2017-04-25","2017-05-24","","1","1");
INSERT INTO contas_receber VALUES("2966","60","312","2","1","520.27","0","520.27","2017-04-25","2017-06-06","","1","1");
INSERT INTO contas_receber VALUES("2967","60","312","3","1","520.26","0","520.26","2017-04-25","2017-06-24","","1","1");
INSERT INTO contas_receber VALUES("3022","152","319","1","1","670","0","670","2017-04-27","2017-04-21","","1","1");
INSERT INTO contas_receber VALUES("3023","152","319","2","1","337.25","0","337.25","2017-04-27","2017-05-28","","1","1");
INSERT INTO contas_receber VALUES("3024","152","319","3","1","337.25","0","337.25","2017-04-27","2017-06-28","","1","1");
INSERT INTO contas_receber VALUES("3025","28","321","1","1","430.22","0","430.22","2017-04-27","2017-04-26","","1","1");
INSERT INTO contas_receber VALUES("3085","157","336","3","1","287.14","287.14","0","2017-05-03","2017-07-05","","0","0");
INSERT INTO contas_receber VALUES("3086","157","336","2","1","287.13","287.13","0","2017-05-03","2017-06-04","","0","0");
INSERT INTO contas_receber VALUES("3087","157","336","1","1","287.13","287.13","0","2017-05-03","2017-05-04","","0","0");
INSERT INTO contas_receber VALUES("3100","59","317","1","1","397.4","397.4","0","2017-05-03","2017-06-02","","0","0");
INSERT INTO contas_receber VALUES("3101","59","317","2","1","397.4","397.4","0","2017-05-03","2017-07-02","","0","0");
INSERT INTO contas_receber VALUES("3102","59","317","3","1","397.4","397.4","0","2017-05-03","2017-08-02","","0","0");
INSERT INTO contas_receber VALUES("3103","153","323","1","1","370","0","370","2017-05-03","2017-06-03","","1","1");
INSERT INTO contas_receber VALUES("3104","153","323","2","1","370","0","370","2017-05-03","2017-06-19","","1","1");
INSERT INTO contas_receber VALUES("3105","153","323","3","1","370","0","370","2017-05-03","2017-07-03","","1","1");
INSERT INTO contas_receber VALUES("3106","147","326","1","1","44","0","44","2017-05-03","2017-04-27","","1","1");
INSERT INTO contas_receber VALUES("3109","154","327","1","1","244.85","0","244.85","2017-05-03","2017-04-29","","1","1");
INSERT INTO contas_receber VALUES("3110","154","327","2","1","244.85","0","244.85","2017-05-03","2017-05-30","","1","1");
INSERT INTO contas_receber VALUES("3113","155","328","1","1","819.87","0","819.87","2017-05-04","2017-06-02","","1","1");
INSERT INTO contas_receber VALUES("3114","155","328","2","1","819.87","0","819.87","2017-05-04","2017-06-17","","1","1");
INSERT INTO contas_receber VALUES("3115","155","328","3","1","819.86","0","819.86","2017-05-04","2017-07-02","","1","1");
INSERT INTO contas_receber VALUES("3152","160","344","1","0","124.08","124.08","0","2017-05-04","2017-05-07","","0","0");
INSERT INTO contas_receber VALUES("3153","160","344","2","0","124.07","124.07","0","2017-05-04","2017-06-07","","0","0");
INSERT INTO contas_receber VALUES("3170","160","345","1","1","124.08","124.08","0","2017-05-04","2017-05-08","","0","0");
INSERT INTO contas_receber VALUES("3171","160","345","2","1","124.07","124.07","0","2017-05-04","2017-06-08","","0","0");
INSERT INTO contas_receber VALUES("3190","156","329","1","1","755.6","0","755.6","2017-05-05","2017-06-09","","1","1");
INSERT INTO contas_receber VALUES("3191","74","322","1","1","1077.2","0","1077.2","2017-05-05","2017-06-06","","1","1");
INSERT INTO contas_receber VALUES("3192","74","322","2","1","1077.2","0","1077.2","2017-05-05","2017-07-05","","1","1");
INSERT INTO contas_receber VALUES("3193","74","322","3","1","1077.2","0","1077.2","2017-05-05","2017-08-05","","1","1");
INSERT INTO contas_receber VALUES("3194","47","325","1","1","529.79","0","529.79","2017-05-05","2017-06-05","","1","1");
INSERT INTO contas_receber VALUES("3195","47","325","2","1","529.79","0","529.79","2017-05-05","2017-06-20","","1","1");
INSERT INTO contas_receber VALUES("3196","47","325","3","1","529.78","0","529.78","2017-05-05","2017-07-05","","1","1");
INSERT INTO contas_receber VALUES("3203","60","347","1","1","339.4","339.4","0","2017-05-06","2017-05-09","","0","0");
INSERT INTO contas_receber VALUES("3204","60","347","3","1","339.4","339.4","0","2017-05-06","2017-07-10","","0","0");
INSERT INTO contas_receber VALUES("3205","60","347","2","1","339.4","339.4","0","2017-05-06","2017-06-09","","0","0");
INSERT INTO contas_receber VALUES("3242","3","332","1","1","191.27","0","191.27","2017-05-09","2017-05-05","","1","1");
INSERT INTO contas_receber VALUES("3243","3","351","1","1","116.96","116.96","0","2017-05-09","2017-05-12","","0","0");
INSERT INTO contas_receber VALUES("3249","135","354","1","1","270","270","0","2017-05-09","2017-05-10","","0","0");
INSERT INTO contas_receber VALUES("3250","49","330","1","1","490.79","0","490.79","2017-05-10","2017-06-08","","1","1");
INSERT INTO contas_receber VALUES("3251","49","330","2","1","490.79","0","490.79","2017-05-10","2017-07-08","","1","1");
INSERT INTO contas_receber VALUES("3252","49","330","3","1","490.79","0","490.79","2017-05-10","2017-08-08","","1","1");
INSERT INTO contas_receber VALUES("3253","98","331","1","1","713.13","0","713.13","2017-05-10","2017-06-05","","1","1");
INSERT INTO contas_receber VALUES("3254","98","331","2","1","713.13","0","713.13","2017-05-10","2017-07-05","","1","1");
INSERT INTO contas_receber VALUES("3255","98","331","3","1","713.12","0","713.12","2017-05-10","2017-08-05","","1","1");
INSERT INTO contas_receber VALUES("3256","129","333","1","1","420.5","0","420.5","2017-05-10","2017-06-15","","1","1");
INSERT INTO contas_receber VALUES("3257","31","324","1","1","163.2","0","163.2","2017-05-10","2017-05-28","","1","1");
INSERT INTO contas_receber VALUES("3274","7","338","1","1","195.3","0","195.3","2017-05-10","2017-06-12","","1","1");
INSERT INTO contas_receber VALUES("3277","159","341","1","1","95.5","0","95.5","2017-05-11","2017-05-06","","1","1");
INSERT INTO contas_receber VALUES("3284","31","358","1","1","215.42","215.42","0","2017-05-11","2017-05-13","","0","0");
INSERT INTO contas_receber VALUES("3285","31","358","2","1","215.42","215.42","0","2017-05-11","2017-06-13","","0","0");
INSERT INTO contas_receber VALUES("3328","33","342","1","1","503.8","0","503.8","2017-05-11","2017-06-12","","1","1");
INSERT INTO contas_receber VALUES("3329","33","342","2","1","503.8","0","503.8","2017-05-11","2017-06-27","","1","1");
INSERT INTO contas_receber VALUES("3330","33","342","3","1","503.8","0","503.8","2017-05-11","2017-07-12","","1","1");
INSERT INTO contas_receber VALUES("3343","84","334","1","1","1110.23","1110.23","0","2017-05-11","2017-05-07","","0","0");
INSERT INTO contas_receber VALUES("3344","84","334","2","1","1110.23","1110.23","0","2017-05-11","2017-06-07","","0","0");
INSERT INTO contas_receber VALUES("3345","84","334","3","1","1110.24","1110.24","0","2017-05-11","2017-07-08","","0","0");
INSERT INTO contas_receber VALUES("3364","27","198","1","1","33.11","0","33.11","2017-05-12","2017-02-09","","1","1");
INSERT INTO contas_receber VALUES("3365","158","340","1","1","50","50","0","2017-05-12","2017-05-05","","0","0");
INSERT INTO contas_receber VALUES("3367","163","350","1","1","64.55","0","64.55","2017-05-12","2017-05-12","","1","1");
INSERT INTO contas_receber VALUES("3372","46","353","1","1","385.59","0","385.59","2017-05-12","2017-06-15","","1","1");
INSERT INTO contas_receber VALUES("3397","19","339","1","1","336.65","336.65","0","2017-05-15","2017-06-12","","0","0");
INSERT INTO contas_receber VALUES("3398","19","339","2","1","336.65","336.65","0","2017-05-15","2017-07-12","","0","0");
INSERT INTO contas_receber VALUES("3411","161","346","1","1","408.26","0","408.26","2017-05-16","2017-06-15","","1","1");
INSERT INTO contas_receber VALUES("3412","161","346","3","1","408.27","0","408.27","2017-05-16","2017-07-15","","1","1");
INSERT INTO contas_receber VALUES("3413","161","346","2","1","408.26","0","408.26","2017-05-16","2017-06-30","","1","1");
INSERT INTO contas_receber VALUES("3414","44","335","2","1","764.58","0","764.58","2017-05-16","2017-06-30","","1","1");
INSERT INTO contas_receber VALUES("3415","44","335","3","1","764.59","0","764.59","2017-05-16","2017-07-15","","1","1");
INSERT INTO contas_receber VALUES("3416","44","335","1","1","764.58","0","764.58","2017-05-16","2017-06-15","","1","1");
INSERT INTO contas_receber VALUES("3425","17","337","1","1","1188.23","0","1188.23","2017-05-17","2017-06-12","","1","1");
INSERT INTO contas_receber VALUES("3426","17","337","3","1","1188.24","0","1188.24","2017-05-17","2017-07-12","","1","1");
INSERT INTO contas_receber VALUES("3427","17","337","2","1","1188.23","0","1188.23","2017-05-17","2017-06-27","","1","1");
INSERT INTO contas_receber VALUES("3428","164","352","1","1","113.44","0","113.44","2017-05-17","2017-05-11","","1","1");
INSERT INTO contas_receber VALUES("3429","3","357","1","1","58.92","0","58.92","2017-05-17","2017-05-13","","1","1");
INSERT INTO contas_receber VALUES("3497","31","359","1","1","215.42","0","215.42","2017-05-18","2017-06-19","","1","1");
INSERT INTO contas_receber VALUES("3498","31","359","2","1","215.42","0","215.42","2017-05-18","2017-07-19","","1","1");
INSERT INTO contas_receber VALUES("3499","4","343","2","1","934.67","0","934.67","2017-05-18","2017-07-01","","1","1");
INSERT INTO contas_receber VALUES("3500","4","343","1","1","934.67","0","934.67","2017-05-18","2017-06-16","","1","1");
INSERT INTO contas_receber VALUES("3501","4","343","3","1","934.66","0","934.66","2017-05-18","2017-07-16","","1","1");
INSERT INTO contas_receber VALUES("3508","129","366","2","1","306.18","0","306.18","2017-05-19","2017-07-04","","1","1");
INSERT INTO contas_receber VALUES("3509","129","366","3","1","306.18","0","306.18","2017-05-19","2017-07-19","","1","1");
INSERT INTO contas_receber VALUES("3510","129","366","1","1","306.18","0","306.18","2017-05-19","2017-06-19","","1","1");
INSERT INTO contas_receber VALUES("3511","24","355","1","1","680.8","0","680.8","2017-05-19","2017-06-02","","1","1");
INSERT INTO contas_receber VALUES("3512","24","355","2","1","680.8","0","680.8","2017-05-19","2017-06-02","","1","1");
INSERT INTO contas_receber VALUES("3520","168","368","1","1","224","0","224","2017-05-22","2017-06-19","","1","1");
INSERT INTO contas_receber VALUES("3521","8","362","1","1","408","0","408","2017-05-22","2017-06-19","","1","1");
INSERT INTO contas_receber VALUES("3522","8","362","3","1","408","0","408","2017-05-22","2017-07-19","","1","1");
INSERT INTO contas_receber VALUES("3523","8","362","2","1","408","0","408","2017-05-22","2017-07-04","","1","1");
INSERT INTO contas_receber VALUES("3554","71","371","1","1","415","0","415","2017-05-25","2017-06-26","","1","1");
INSERT INTO contas_receber VALUES("3555","71","371","2","1","415","0","415","2017-05-25","2017-07-11","","1","1");
INSERT INTO contas_receber VALUES("3556","71","371","3","1","415","0","415","2017-05-25","2017-07-26","","1","1");
INSERT INTO contas_receber VALUES("3557","169","373","1","1","125.5","0","125.5","2017-05-25","2017-06-24","","1","1");
INSERT INTO contas_receber VALUES("3558","169","373","2","1","125.5","0","125.5","2017-05-25","2017-07-24","","1","1");
INSERT INTO contas_receber VALUES("3559","22","369","1","1","713.1","0","713.1","2017-05-25","2017-06-24","","1","1");
INSERT INTO contas_receber VALUES("3560","22","369","2","1","713.1","0","713.1","2017-05-25","2017-07-09","","1","1");
INSERT INTO contas_receber VALUES("3561","22","369","3","1","713.1","0","713.1","2017-05-25","2017-07-24","","1","1");
INSERT INTO contas_receber VALUES("3562","65","364","1","1","748","0","748","2017-05-25","2017-06-23","","1","1");
INSERT INTO contas_receber VALUES("3563","65","364","2","1","748","0","748","2017-05-25","2017-07-08","","1","1");
INSERT INTO contas_receber VALUES("3564","65","364","3","1","748","0","748","2017-05-25","2017-07-23","","1","1");
INSERT INTO contas_receber VALUES("3565","118","228","1","1","454","0","454","2017-05-25","2017-06-26","","1","1");
INSERT INTO contas_receber VALUES("3566","118","228","2","1","454","0","454","2017-05-25","2017-07-11","","1","1");
INSERT INTO contas_receber VALUES("3567","118","228","3","1","454","0","454","2017-05-25","2017-07-26","","1","1");
INSERT INTO contas_receber VALUES("3568","165","356","1","1","109.95","0","109.95","2017-05-25","2017-05-13","","1","1");
INSERT INTO contas_receber VALUES("3569","3","374","1","1","32.1","0","32.1","2017-05-25","2017-05-20","","1","1");
INSERT INTO contas_receber VALUES("3570","96","382","1","1","232.3","0","232.3","2017-05-25","2017-05-27","","1","1");
INSERT INTO contas_receber VALUES("3572","171","381","1","1","35.43","35.43","0","2017-05-25","2017-05-26","","0","0");
INSERT INTO contas_receber VALUES("3573","28","380","1","1","59.18","0","59.18","2017-05-25","2017-05-26","","1","1");
INSERT INTO contas_receber VALUES("3574","170","379","1","1","101.07","0","101.07","2017-05-25","2017-05-25","","1","1");
INSERT INTO contas_receber VALUES("3575","79","360","1","1","874.67","0","874.67","2017-05-29","2017-05-12","","1","1");
INSERT INTO contas_receber VALUES("3576","79","360","2","1","874.67","0","874.67","2017-05-29","2017-06-05","","1","1");
INSERT INTO contas_receber VALUES("3577","79","360","3","1","874.66","0","874.66","2017-05-29","2017-06-05","","1","1");
INSERT INTO contas_receber VALUES("3578","130","361","1","1","395.83","0","395.83","2017-05-29","2017-05-14","","1","1");
INSERT INTO contas_receber VALUES("3583","162","349","1","1","336.9","336.9","0","2017-05-29","2017-06-29","","0","0");
INSERT INTO contas_receber VALUES("3584","162","349","2","1","336.9","336.9","0","2017-05-29","2017-07-29","","0","0");
INSERT INTO contas_receber VALUES("3585","68","372","1","1","978.02","0","978.02","2017-05-29","2017-05-21","","1","1");
INSERT INTO contas_receber VALUES("3586","68","372","2","1","978.03","0","978.03","2017-05-29","2017-05-31","","1","1");
INSERT INTO contas_receber VALUES("3587","167","367","1","1","213.5","0","213.5","2017-05-29","2017-06-30","","1","1");
INSERT INTO contas_receber VALUES("3588","167","367","2","1","213.5","0","213.5","2017-05-29","2017-07-30","","1","1");
INSERT INTO contas_receber VALUES("3589","86","375","1","1","251.67","0","251.67","2017-05-29","2017-06-26","","1","1");
INSERT INTO contas_receber VALUES("3590","86","375","3","1","251.66","0","251.66","2017-05-29","2017-08-26","","1","1");
INSERT INTO contas_receber VALUES("3591","86","375","2","1","251.67","0","251.67","2017-05-29","2017-07-26","","1","1");
INSERT INTO contas_receber VALUES("3595","30","376","1","1","736","736","0","2017-05-29","2017-06-29","","0","0");
INSERT INTO contas_receber VALUES("3596","30","376","2","1","736","736","0","2017-05-29","2017-07-15","","0","0");
INSERT INTO contas_receber VALUES("3597","30","376","3","1","736","736","0","2017-05-29","2017-07-29","","0","0");
INSERT INTO contas_receber VALUES("3598","76","377","1","1","595.17","0","595.17","2017-05-29","2017-06-30","","1","1");
INSERT INTO contas_receber VALUES("3599","76","377","2","1","595.17","0","595.17","2017-05-29","2017-07-15","","1","1");
INSERT INTO contas_receber VALUES("3600","76","377","3","1","595.16","0","595.16","2017-05-29","2017-07-30","","1","1");
INSERT INTO contas_receber VALUES("3601","4","378","1","1","1179.67","0","1179.67","2017-05-29","2017-06-30","","1","1");
INSERT INTO contas_receber VALUES("3602","4","378","2","1","1179.67","0","1179.67","2017-05-29","2017-07-15","","1","1");
INSERT INTO contas_receber VALUES("3603","4","378","3","1","1179.66","0","1179.66","2017-05-29","2017-07-30","","1","1");
INSERT INTO contas_receber VALUES("3658","28","363","1","1","184","0","184","2017-05-31","2017-05-17","","1","1");
INSERT INTO contas_receber VALUES("3692","60","348","1","1","339.4","339.4","0","2017-06-01","2017-05-12","","0","0");
INSERT INTO contas_receber VALUES("3693","60","348","2","1","339.4","339.4","0","2017-06-01","2017-06-12","","0","0");
INSERT INTO contas_receber VALUES("3694","60","348","3","1","339.4","339.4","0","2017-06-01","2017-07-13","","0","0");
INSERT INTO contas_receber VALUES("3739","31","397","1","1","322.09","0","322.09","2017-06-06","2017-07-02","","1","1");
INSERT INTO contas_receber VALUES("3740","31","397","3","1","322.08","0","322.08","2017-06-06","2017-08-02","","1","1");
INSERT INTO contas_receber VALUES("3741","31","397","2","1","322.09","0","322.09","2017-06-06","2017-07-17","","1","1");
INSERT INTO contas_receber VALUES("3742","43","385","1","1","207.63","207.63","0","2017-06-06","2017-07-02","","0","0");
INSERT INTO contas_receber VALUES("3743","43","385","2","1","207.63","207.63","0","2017-06-06","2017-07-14","","0","0");
INSERT INTO contas_receber VALUES("3744","111","386","1","1","98.36","0","98.36","2017-06-06","2017-05-31","","1","1");
INSERT INTO contas_receber VALUES("3745","172","384","1","1","68.6","0","68.6","2017-06-06","2017-07-02","","1","1");
INSERT INTO contas_receber VALUES("3746","40","392","1","1","149.59","0","149.59","2017-06-06","2017-06-02","","1","1");
INSERT INTO contas_receber VALUES("3747","175","395","1","1","314.85","0","314.85","2017-06-06","2017-06-04","","1","1");
INSERT INTO contas_receber VALUES("3748","4","383","1","1","1216","0","1216","2017-06-06","2017-07-06","","1","1");
INSERT INTO contas_receber VALUES("3749","4","383","2","1","1216","0","1216","2017-06-06","2017-07-21","","1","1");
INSERT INTO contas_receber VALUES("3750","4","383","3","1","1216","0","1216","2017-06-06","2017-08-06","","1","1");
INSERT INTO contas_receber VALUES("3751","98","388","1","1","848.33","0","848.33","2017-06-06","2017-07-10","","1","1");
INSERT INTO contas_receber VALUES("3752","98","388","2","1","848.33","0","848.33","2017-06-06","2017-08-10","","1","1");
INSERT INTO contas_receber VALUES("3753","98","388","3","1","848.34","0","848.34","2017-06-06","2017-09-10","","1","1");
INSERT INTO contas_receber VALUES("3754","62","390","1","1","391.93","0","391.93","2017-06-06","2017-07-07","","1","1");
INSERT INTO contas_receber VALUES("3755","62","390","2","1","391.93","0","391.93","2017-06-06","2017-07-22","","1","1");
INSERT INTO contas_receber VALUES("3756","62","390","3","1","391.94","0","391.94","2017-06-06","2017-08-07","","1","1");
INSERT INTO contas_receber VALUES("3760","19","393","1","1","232.33","232.33","0","2017-06-06","2017-07-07","","0","0");
INSERT INTO contas_receber VALUES("3761","19","393","3","1","232.34","232.34","0","2017-06-06","2017-08-07","","0","0");
INSERT INTO contas_receber VALUES("3762","19","393","2","1","232.33","232.33","0","2017-06-06","2017-07-22","","0","0");
INSERT INTO contas_receber VALUES("3763","174","394","1","1","266","0","266","2017-06-06","2017-06-03","","1","1");
INSERT INTO contas_receber VALUES("3764","176","396","1","1","768","0","768","2017-06-06","2017-07-06","","1","1");
INSERT INTO contas_receber VALUES("3765","176","396","2","1","768","0","768","2017-06-06","2017-08-06","","1","1");
INSERT INTO contas_receber VALUES("3766","176","396","3","1","768","0","768","2017-06-06","2017-09-06","","1","1");
INSERT INTO contas_receber VALUES("3767","3","399","1","1","117.76","0","117.76","2017-06-06","2017-06-04","","1","1");
INSERT INTO contas_receber VALUES("3768","177","400","1","1","150","0","150","2017-06-06","2017-06-04","","1","1");
INSERT INTO contas_receber VALUES("3785","178","403","1","1","32.4","0","32.4","2017-06-08","2017-06-09","","1","1");
INSERT INTO contas_receber VALUES("3786","147","389","2","1","517.5","0","517.5","2017-06-08","2017-07-05","","1","1");
INSERT INTO contas_receber VALUES("3787","147","389","3","1","517.5","0","517.5","2017-06-08","2017-07-20","","1","1");
INSERT INTO contas_receber VALUES("3788","147","389","1","1","517.5","0","517.5","2017-06-08","2017-06-20","","1","1");
INSERT INTO contas_receber VALUES("3789","130","407","1","1","521.6","0","521.6","2017-06-08","2017-06-08","","1","1");
INSERT INTO contas_receber VALUES("3867","27","418","1","1","28.36","28.36","0","2017-06-13","2017-06-14","","0","0");
INSERT INTO contas_receber VALUES("3881","181","420","1","1","45.52","45.52","0","2017-06-14","2017-06-15","","0","0");
INSERT INTO contas_receber VALUES("3902","94","391","1","1","343.23","0","343.23","2017-06-16","2017-07-12","","1","1");
INSERT INTO contas_receber VALUES("3903","94","391","2","1","343.24","0","343.24","2017-06-16","2017-08-12","","1","1");
INSERT INTO contas_receber VALUES("3904","137","280","1","1","410.5","0","410.5","2017-06-16","2017-07-13","","1","1");
INSERT INTO contas_receber VALUES("3905","137","280","2","1","410.5","0","410.5","2017-06-16","2017-07-28","","1","1");
INSERT INTO contas_receber VALUES("3906","137","280","3","1","410.5","0","410.5","2017-06-16","2017-08-13","","1","1");
INSERT INTO contas_receber VALUES("3907","70","398","1","1","1145.5","0","1145.5","2017-06-16","2017-06-04","","1","1");
INSERT INTO contas_receber VALUES("3908","25","401","1","1","410","0","410","2017-06-16","2017-07-09","","1","1");
INSERT INTO contas_receber VALUES("3909","25","401","2","1","410","0","410","2017-06-16","2017-07-24","","1","1");
INSERT INTO contas_receber VALUES("3910","25","401","3","1","410","0","410","2017-06-16","2017-08-09","","1","1");
INSERT INTO contas_receber VALUES("3911","33","402","1","1","389.27","0","389.27","2017-06-16","2017-07-13","","1","1");
INSERT INTO contas_receber VALUES("3912","33","402","2","1","389.27","0","389.27","2017-06-16","2017-08-13","","1","1");
INSERT INTO contas_receber VALUES("3913","33","402","3","1","389.26","0","389.26","2017-06-16","2017-09-13","","1","1");
INSERT INTO contas_receber VALUES("3914","179","405","1","1","213.45","0","213.45","2017-06-16","2017-07-09","","1","1");
INSERT INTO contas_receber VALUES("3915","179","405","2","1","213.45","0","213.45","2017-06-16","2017-07-24","","1","1");
INSERT INTO contas_receber VALUES("3916","30","406","1","1","444.5","0","444.5","2017-06-16","2017-07-09","","1","1");
INSERT INTO contas_receber VALUES("3917","30","406","2","1","444.5","0","444.5","2017-06-16","2017-07-24","","1","1");
INSERT INTO contas_receber VALUES("3918","30","406","3","1","444.5","0","444.5","2017-06-16","2017-08-09","","1","1");
INSERT INTO contas_receber VALUES("3919","28","411","1","1","23.65","0","23.65","2017-06-16","2017-06-10","","1","1");
INSERT INTO contas_receber VALUES("3920","113","412","1","1","410","0","410","2017-06-16","2017-07-12","","1","1");
INSERT INTO contas_receber VALUES("3921","113","412","2","1","410","0","410","2017-06-16","2017-08-12","","1","1");
INSERT INTO contas_receber VALUES("3922","113","412","3","1","410","0","410","2017-06-16","2017-09-12","","1","1");
INSERT INTO contas_receber VALUES("3923","112","416","1","1","48.38","0","48.38","2017-06-16","2017-06-14","","1","1");
INSERT INTO contas_receber VALUES("3952","32","409","1","1","267.34","267.34","0","2017-06-16","2017-07-16","","0","0");
INSERT INTO contas_receber VALUES("3975","4","404","2","1","979.67","0","979.67","2017-06-19","2017-07-31","","1","1");
INSERT INTO contas_receber VALUES("3976","4","404","3","1","979.66","0","979.66","2017-06-19","2017-08-16","","1","1");
INSERT INTO contas_receber VALUES("3977","4","404","1","1","979.67","0","979.67","2017-06-19","2017-07-16","","1","1");
INSERT INTO contas_receber VALUES("3992","101","414","1","1","1729.24","0","1729.24","2017-06-20","2017-07-21","","1","1");
INSERT INTO contas_receber VALUES("3993","101","414","3","1","1729.24","0","1729.24","2017-06-20","2017-08-21","","1","1");
INSERT INTO contas_receber VALUES("3994","101","414","2","1","1729.24","0","1729.24","2017-06-20","2017-08-05","","1","1");
INSERT INTO contas_receber VALUES("3999","182","423","1","1","202.37","0","202.37","2017-06-20","2017-06-18","","1","1");
INSERT INTO contas_receber VALUES("4000","182","429","1","1","174.74","0","174.74","2017-06-20","2017-06-21","","1","1");
INSERT INTO contas_receber VALUES("4001","184","427","1","1","45.38","0","45.38","2017-06-20","2017-06-21","","1","1");
INSERT INTO contas_receber VALUES("4022","183","424","1","1","172","0","172","2017-06-20","2017-07-19","","1","1");
INSERT INTO contas_receber VALUES("4023","9","422","3","1","503.34","0","503.34","2017-06-21","2017-08-22","","1","1");
INSERT INTO contas_receber VALUES("4024","9","422","2","1","503.33","0","503.33","2017-06-21","2017-08-06","","1","1");
INSERT INTO contas_receber VALUES("4025","9","422","1","1","503.33","0","503.33","2017-06-21","2017-07-22","","1","1");
INSERT INTO contas_receber VALUES("4026","180","419","1","1","408.05","0","408.05","2017-06-21","2017-07-21","","1","1");
INSERT INTO contas_receber VALUES("4027","180","419","2","1","408.05","0","408.05","2017-06-21","2017-08-05","","1","1");
INSERT INTO contas_receber VALUES("4028","180","419","3","1","408.05","0","408.05","2017-06-21","2017-08-21","","1","1");
INSERT INTO contas_receber VALUES("4051","7","415","1","1","154.2","0","154.2","2017-06-22","2017-07-21","","1","1");
INSERT INTO contas_receber VALUES("4052","185","428","1","1","158.67","0","158.67","2017-06-22","2017-07-01","","1","1");
INSERT INTO contas_receber VALUES("4053","3","434","1","1","44.39","0","44.39","2017-06-22","2017-06-22","","1","1");
INSERT INTO contas_receber VALUES("4054","42","426","1","1","743.33","0","743.33","2017-06-22","2017-07-23","","1","1");
INSERT INTO contas_receber VALUES("4055","42","426","2","1","743.33","0","743.33","2017-06-22","2017-08-07","","1","1");
INSERT INTO contas_receber VALUES("4056","42","426","3","1","743.34","0","743.34","2017-06-22","2017-08-23","","1","1");
INSERT INTO contas_receber VALUES("4068","62","421","1","1","311.39","311.39","0","2017-06-23","2017-07-26","","0","0");
INSERT INTO contas_receber VALUES("4069","62","421","2","1","311.39","311.39","0","2017-06-23","2017-08-10","","0","0");
INSERT INTO contas_receber VALUES("4070","62","421","3","1","311.39","311.39","0","2017-06-23","2017-08-26","","0","0");
INSERT INTO contas_receber VALUES("4071","118","425","1","1","450.83","0","450.83","2017-06-23","2017-07-26","","1","1");
INSERT INTO contas_receber VALUES("4072","118","425","2","1","450.83","0","450.83","2017-06-23","2017-08-10","","1","1");
INSERT INTO contas_receber VALUES("4073","118","425","3","1","450.84","0","450.84","2017-06-23","2017-08-26","","1","1");
INSERT INTO contas_receber VALUES("4074","44","430","2","1","455.61","0","455.61","2017-06-23","2017-08-10","","1","1");
INSERT INTO contas_receber VALUES("4075","44","430","1","1","455.61","0","455.61","2017-06-23","2017-07-26","","1","1");
INSERT INTO contas_receber VALUES("4076","44","430","3","1","455.6","0","455.6","2017-06-23","2017-08-26","","1","1");
INSERT INTO contas_receber VALUES("4079","3","439","1","1","71.56","0","71.56","2017-06-23","2017-06-25","","1","1");
INSERT INTO contas_receber VALUES("4091","186","432","1","1","298.15","298.15","0","2017-06-26","2017-07-28","","0","0");
INSERT INTO contas_receber VALUES("4092","186","432","2","1","298.15","298.15","0","2017-06-26","2017-08-28","","0","0");
INSERT INTO contas_receber VALUES("4095","187","437","1","1","478.67","0","478.67","2017-06-27","2017-07-28","","1","1");
INSERT INTO contas_receber VALUES("4096","187","437","2","1","478.67","0","478.67","2017-06-27","2017-08-12","","1","1");
INSERT INTO contas_receber VALUES("4097","187","437","3","1","478.66","0","478.66","2017-06-27","2017-08-28","","1","1");
INSERT INTO contas_receber VALUES("4098","154","438","2","1","138.8","0","138.8","2017-06-27","2017-07-28","","1","1");
INSERT INTO contas_receber VALUES("4099","154","438","1","1","250","0","250","2017-06-27","2017-06-25","","1","1");
INSERT INTO contas_receber VALUES("4100","35","431","1","1","161.66","0","161.66","2017-06-27","2017-07-26","","1","1");
INSERT INTO contas_receber VALUES("4101","47","436","1","1","566.6","0","566.6","2017-06-27","2017-07-27","","1","1");
INSERT INTO contas_receber VALUES("4102","47","436","2","1","566.6","0","566.6","2017-06-27","2017-08-11","","1","1");
INSERT INTO contas_receber VALUES("4103","47","436","3","1","566.6","0","566.6","2017-06-27","2017-08-27","","1","1");
INSERT INTO contas_receber VALUES("4104","159","410","1","1","114.6","0","114.6","2017-06-27","2017-06-10","","1","1");
INSERT INTO contas_receber VALUES("4122","54","441","1","1","45.52","0","45.52","2017-06-29","2017-06-28","","1","1");
INSERT INTO contas_receber VALUES("4123","127","433","1","1","457.65","0","457.65","2017-06-29","2017-07-28","","1","1");
INSERT INTO contas_receber VALUES("4124","127","433","2","1","457.65","0","457.65","2017-06-29","2017-08-28","","1","1");
INSERT INTO contas_receber VALUES("4125","27","408","1","1","23.62","0","23.62","2017-06-29","2017-06-08","","1","1");
INSERT INTO contas_receber VALUES("4127","190","446","1","1","385.17","385.17","0","2017-06-29","2017-06-30","","0","0");
INSERT INTO contas_receber VALUES("4129","189","442","1","1","199.42","199.42","0","2017-06-30","2017-09-03","","0","0");
INSERT INTO contas_receber VALUES("4130","43","444","1","1","282.1","0","282.1","2017-06-30","2017-08-03","","1","1");
INSERT INTO contas_receber VALUES("4131","43","444","2","1","282.1","0","282.1","2017-06-30","2017-09-03","","1","1");
INSERT INTO contas_receber VALUES("4153","20","417","1","1","436.45","0","436.45","2017-06-30","2017-08-03","","1","1");
INSERT INTO contas_receber VALUES("4154","20","417","2","1","436.45","0","436.45","2017-06-30","2017-09-03","","1","1");
INSERT INTO contas_receber VALUES("4208","129","455","2","1","308.62","308.62","0","2017-07-04","2017-08-05","","0","0");
INSERT INTO contas_receber VALUES("4209","129","455","1","1","308.62","308.62","0","2017-07-04","2017-07-05","","0","0");
INSERT INTO contas_receber VALUES("4210","129","455","3","1","308.61","308.61","0","2017-07-04","2017-09-05","","0","0");
INSERT INTO contas_receber VALUES("4233","74","435","1","1","1037.33","0","1037.33","2017-07-04","2017-07-30","","1","1");
INSERT INTO contas_receber VALUES("4234","74","435","2","1","1037.33","0","1037.33","2017-07-04","2017-08-30","","1","1");
INSERT INTO contas_receber VALUES("4235","74","435","3","1","1037.34","0","1037.34","2017-07-04","2017-09-30","","1","1");
INSERT INTO contas_receber VALUES("4239","22","443","2","1","1044.15","1044.15","0","2017-07-04","2017-08-20","","0","0");
INSERT INTO contas_receber VALUES("4240","22","443","1","1","1044.15","1044.15","0","2017-07-04","2017-08-04","","0","0");
INSERT INTO contas_receber VALUES("4241","22","443","3","1","1044.15","1044.15","0","2017-07-04","2017-09-04","","0","0");
INSERT INTO contas_receber VALUES("4242","3","445","1","1","149.13","0","149.13","2017-07-04","2017-06-30","","1","1");
INSERT INTO contas_receber VALUES("4243","154","449","1","1","387","0","387","2017-07-04","2017-07-02","","1","1");
INSERT INTO contas_receber VALUES("4264","191","447","1","1","518.43","0","518.43","2017-07-05","2017-08-06","","1","1");
INSERT INTO contas_receber VALUES("4265","191","447","2","1","518.43","0","518.43","2017-07-05","2017-08-22","","1","1");
INSERT INTO contas_receber VALUES("4266","191","447","3","1","518.44","0","518.44","2017-07-05","2017-09-06","","1","1");
INSERT INTO contas_receber VALUES("4267","60","448","1","1","502.57","0","502.57","2017-07-05","2017-08-07","","1","1");
INSERT INTO contas_receber VALUES("4268","60","448","3","1","502.56","0","502.56","2017-07-05","2017-09-07","","1","1");
INSERT INTO contas_receber VALUES("4269","60","448","2","1","502.57","0","502.57","2017-07-05","2017-08-22","","1","1");
INSERT INTO contas_receber VALUES("4270","118","450","1","1","564.37","564.37","0","2017-07-05","2017-08-05","","0","0");
INSERT INTO contas_receber VALUES("4271","118","450","2","1","564.37","564.37","0","2017-07-05","2017-08-21","","0","0");
INSERT INTO contas_receber VALUES("4272","118","450","3","1","564.36","564.36","0","2017-07-05","2017-09-05","","0","0");
INSERT INTO contas_receber VALUES("4273","19","451","1","1","341.35","0","341.35","2017-07-05","2017-08-05","","1","1");
INSERT INTO contas_receber VALUES("4274","19","451","2","1","341.35","0","341.35","2017-07-05","2017-09-05","","1","1");
INSERT INTO contas_receber VALUES("4294","27","468","1","1","28.36","28.36","0","2017-07-10","2017-07-11","","0","0");
INSERT INTO contas_receber VALUES("4320","30","452","2","1","947.15","0","947.15","2017-07-11","2017-08-22","","1","1");
INSERT INTO contas_receber VALUES("4321","30","452","1","1","947.15","0","947.15","2017-07-11","2017-08-07","","1","1");
INSERT INTO contas_receber VALUES("4322","30","452","3","1","947.16","0","947.16","2017-07-11","2017-09-07","","1","1");
INSERT INTO contas_receber VALUES("4332","43","473","1","1","346.5","346.5","0","2017-07-11","2017-07-13","","0","0");
INSERT INTO contas_receber VALUES("4333","43","473","2","1","346.5","346.5","0","2017-07-11","2017-08-13","","0","0");
INSERT INTO contas_receber VALUES("4334","43","473","3","1","346.5","346.5","0","2017-07-11","2017-09-13","","0","0");
INSERT INTO contas_receber VALUES("4335","32","465","1","1","169.9","0","169.9","2017-07-11","2017-08-07","","1","1");
INSERT INTO contas_receber VALUES("4353","84","453","1","1","707.8","707.8","0","2017-07-11","2017-08-12","","0","0");
INSERT INTO contas_receber VALUES("4354","84","453","3","1","707.8","707.8","0","2017-07-11","2017-09-12","","0","0");
INSERT INTO contas_receber VALUES("4355","84","453","2","1","707.8","707.8","0","2017-07-11","2017-08-28","","0","0");
INSERT INTO contas_receber VALUES("4356","129","454","1","1","455.83","0","455.83","2017-07-11","2017-08-10","","1","1");
INSERT INTO contas_receber VALUES("4357","129","454","2","1","455.83","0","455.83","2017-07-11","2017-08-25","","1","1");
INSERT INTO contas_receber VALUES("4358","129","454","3","1","455.84","0","455.84","2017-07-11","2017-09-10","","1","1");
INSERT INTO contas_receber VALUES("4359","101","456","1","1","912.02","0","912.02","2017-07-12","2017-08-12","","1","1");
INSERT INTO contas_receber VALUES("4360","101","456","2","1","912.02","0","912.02","2017-07-12","2017-09-12","","1","1");
INSERT INTO contas_receber VALUES("4361","67","457","1","1","251","0","251","2017-07-12","2017-08-13","","1","1");
INSERT INTO contas_receber VALUES("4362","67","457","2","1","251","0","251","2017-07-12","2017-09-13","","1","1");
INSERT INTO contas_receber VALUES("4363","3","458","1","1","41.49","0","41.49","2017-07-12","2017-07-06","","1","1");
INSERT INTO contas_receber VALUES("4364","192","459","1","1","404.67","0","404.67","2017-07-12","2017-08-14","","1","1");
INSERT INTO contas_receber VALUES("4365","192","459","3","1","404.66","0","404.66","2017-07-12","2017-09-14","","1","1");
INSERT INTO contas_receber VALUES("4366","192","459","2","1","404.67","0","404.67","2017-07-12","2017-08-29","","1","1");
INSERT INTO contas_receber VALUES("4367","31","461","1","1","240.2","0","240.2","2017-07-12","2017-08-14","","1","1");
INSERT INTO contas_receber VALUES("4368","31","461","2","1","240.2","0","240.2","2017-07-12","2017-09-14","","1","1");
INSERT INTO contas_receber VALUES("4369","69","462","1","1","405.45","0","405.45","2017-07-12","2017-07-31","","1","1");
INSERT INTO contas_receber VALUES("4370","69","462","2","1","405.45","0","405.45","2017-07-12","2017-07-31","","1","1");
INSERT INTO contas_receber VALUES("4375","3","467","1","1","283.88","0","283.88","2017-07-12","2017-07-13","","1","1");
INSERT INTO contas_receber VALUES("4378","114","475","1","1","70","0","70","2017-07-12","2017-07-15","","1","1");
INSERT INTO contas_receber VALUES("4385","174","460","1","1","228.6","0","228.6","2017-07-13","2017-07-07","","1","1");
INSERT INTO contas_receber VALUES("4415","17","480","2","1","1593.87","1593.87","0","2017-07-14","2017-08-17","","0","0");
INSERT INTO contas_receber VALUES("4416","17","480","3","1","1593.86","1593.86","0","2017-07-14","2017-09-17","","0","0");
INSERT INTO contas_receber VALUES("4417","17","480","1","1","1593.87","1593.87","0","2017-07-14","2017-07-17","","0","0");
INSERT INTO contas_receber VALUES("4463","17","481","1","0","1593.87","1593.87","0","2017-07-14","2017-07-16","","0","0");
INSERT INTO contas_receber VALUES("4464","17","481","2","0","1593.87","1593.87","0","2017-07-14","2017-08-16","","0","0");
INSERT INTO contas_receber VALUES("4465","17","481","3","0","1593.86","1593.86","0","2017-07-14","2017-09-16","","0","0");
INSERT INTO contas_receber VALUES("4525","25","469","1","1","411.67","0","411.67","2017-07-17","2017-08-18","","1","1");
INSERT INTO contas_receber VALUES("4526","25","469","2","1","411.67","0","411.67","2017-07-17","2017-09-02","","1","1");
INSERT INTO contas_receber VALUES("4527","25","469","3","1","411.66","0","411.66","2017-07-17","2017-09-18","","1","1");
INSERT INTO contas_receber VALUES("4528","195","471","1","1","211.4","0","211.4","2017-07-17","2017-08-18","","1","1");
INSERT INTO contas_receber VALUES("4529","23","472","1","1","282.63","0","282.63","2017-07-17","2017-08-19","","1","1");
INSERT INTO contas_receber VALUES("4530","23","472","2","1","282.63","0","282.63","2017-07-17","2017-09-03","","1","1");
INSERT INTO contas_receber VALUES("4531","23","472","3","1","282.64","0","282.64","2017-07-17","2017-09-19","","1","1");
INSERT INTO contas_receber VALUES("4532","196","474","1","1","54.8","54.8","0","2017-07-17","2017-07-14","","0","0");
INSERT INTO contas_receber VALUES("4533","4","463","1","1","776","0","776","2017-07-17","2017-08-17","","1","1");
INSERT INTO contas_receber VALUES("4534","4","463","3","1","776","0","776","2017-07-17","2017-09-17","","1","1");
INSERT INTO contas_receber VALUES("4535","4","463","2","1","776","0","776","2017-07-17","2017-09-01","","1","1");
INSERT INTO contas_receber VALUES("4560","197","476","1","1","2530.4","0","2530.4","2017-07-19","2017-08-04","","1","1");
INSERT INTO contas_receber VALUES("4561","198","478","1","1","161","161","0","2017-07-19","2017-08-19","","0","1");
INSERT INTO contas_receber VALUES("4562","198","478","2","1","161","161","0","2017-07-19","2017-09-19","","0","1");
INSERT INTO contas_receber VALUES("4563","8","479","1","1","408","0","408","2017-07-19","2017-08-21","","1","1");
INSERT INTO contas_receber VALUES("4564","8","479","2","1","408","0","408","2017-07-19","2017-09-05","","1","1");
INSERT INTO contas_receber VALUES("4565","8","479","3","1","408","0","408","2017-07-19","2017-09-21","","1","1");
INSERT INTO contas_receber VALUES("4569","17","482","3","1","1593.86","1593.86","0","2017-07-19","2017-09-25","","0","0");
INSERT INTO contas_receber VALUES("4570","17","482","1","1","1593.87","1593.87","0","2017-07-19","2017-08-25","","0","0");
INSERT INTO contas_receber VALUES("4571","17","482","2","1","1593.87","1593.87","0","2017-07-19","2017-09-09","","0","0");
INSERT INTO contas_receber VALUES("4572","86","485","1","1","506.83","0","506.83","2017-07-19","2017-08-21","","1","1");
INSERT INTO contas_receber VALUES("4573","86","485","2","1","506.83","0","506.83","2017-07-19","2017-09-21","","1","1");
INSERT INTO contas_receber VALUES("4574","86","485","3","1","506.84","0","506.84","2017-07-19","2017-10-21","","1","1");
INSERT INTO contas_receber VALUES("4575","33","486","2","1","443.35","0","443.35","2017-07-19","2017-09-05","","1","1");
INSERT INTO contas_receber VALUES("4576","33","486","1","1","443.35","0","443.35","2017-07-19","2017-08-21","","1","1");
INSERT INTO contas_receber VALUES("4577","33","486","3","1","443.35","0","443.35","2017-07-19","2017-09-21","","1","1");
INSERT INTO contas_receber VALUES("4578","160","484","2","1","162.5","0","162.5","2017-07-19","2017-09-20","","1","1");
INSERT INTO contas_receber VALUES("4579","160","484","1","1","162.5","0","162.5","2017-07-19","2017-08-20","","1","1");
INSERT INTO contas_receber VALUES("4592","194","470","1","1","420.67","0","420.67","2017-07-19","2017-08-19","","1","1");
INSERT INTO contas_receber VALUES("4593","194","470","2","1","420.67","0","420.67","2017-07-19","2017-09-19","","1","1");
INSERT INTO contas_receber VALUES("4594","194","470","3","1","420.66","0","420.66","2017-07-19","2017-10-19","","1","1");
INSERT INTO contas_receber VALUES("4633","161","493","1","1","645.52","0","645.52","2017-07-20","2017-08-26","","1","1");
INSERT INTO contas_receber VALUES("4634","161","493","2","1","645.53","0","645.53","2017-07-20","2017-09-07","","1","1");
INSERT INTO contas_receber VALUES("4673","7","498","1","1","122.05","122.05","0","2017-07-24","2017-07-26","","0","0");
INSERT INTO contas_receber VALUES("4674","7","498","2","1","122.05","122.05","0","2017-07-24","2017-08-26","","0","0");
INSERT INTO contas_receber VALUES("4683","75","499","2","1","122.05","122.05","0","2017-07-24","2017-08-24","","0","0");
INSERT INTO contas_receber VALUES("4684","75","499","1","1","122.05","122.05","0","2017-07-24","2017-07-24","","0","0");
INSERT INTO contas_receber VALUES("4689","28","477","1","1","248.22","0","248.22","2017-07-24","2017-07-15","","1","1");
INSERT INTO contas_receber VALUES("4690","149","489","1","1","513.12","0","513.12","2017-07-24","2017-08-25","","1","1");
INSERT INTO contas_receber VALUES("4691","149","489","2","1","513.12","0","513.12","2017-07-24","2017-09-09","","1","1");
INSERT INTO contas_receber VALUES("4692","149","489","3","1","513.12","0","513.12","2017-07-24","2017-09-25","","1","1");
INSERT INTO contas_receber VALUES("4698","9","502","1","1","334.03","334.03","0","2017-07-25","2017-07-26","","0","0");
INSERT INTO contas_receber VALUES("4699","9","502","2","1","334.03","334.03","0","2017-07-25","2017-08-26","","0","0");
INSERT INTO contas_receber VALUES("4700","9","502","3","1","334.04","334.04","0","2017-07-25","2017-09-26","","0","0");
INSERT INTO contas_receber VALUES("4726","196","505","1","1","19.02","19.02","0","2017-07-25","2017-07-26","","0","0");
INSERT INTO contas_receber VALUES("4737","24","507","1","1","564.3","564.3","0","2017-07-25","2017-07-27","","0","0");
INSERT INTO contas_receber VALUES("4738","24","507","2","1","564.3","564.3","0","2017-07-25","2017-08-27","","0","0");
INSERT INTO contas_receber VALUES("4739","24","507","3","1","564.3","564.3","0","2017-07-25","2017-09-27","","0","0");
INSERT INTO contas_receber VALUES("4752","199","483","1","1","748.38","0","748.38","2017-07-26","2017-09-10","","1","1");
INSERT INTO contas_receber VALUES("4753","199","483","2","1","748.38","0","748.38","2017-07-26","2017-10-10","","1","1");
INSERT INTO contas_receber VALUES("4754","199","483","3","1","748.38","0","748.38","2017-07-26","2017-11-10","","1","1");
INSERT INTO contas_receber VALUES("4758","200","488","1","1","434.75","434.75","0","2017-07-26","2017-07-21","","0","0");
INSERT INTO contas_receber VALUES("4759","200","488","2","1","434.75","434.75","0","2017-07-26","2017-08-21","","0","0");
INSERT INTO contas_receber VALUES("4760","200","488","3","1","434.74","434.74","0","2017-07-26","2017-09-21","","0","0");
INSERT INTO contas_receber VALUES("4764","30","494","1","1","441.83","0","441.83","2017-07-26","2017-08-28","","1","1");
INSERT INTO contas_receber VALUES("4765","30","494","2","1","441.83","0","441.83","2017-07-26","2017-09-12","","1","1");
INSERT INTO contas_receber VALUES("4766","30","494","3","1","441.84","0","441.84","2017-07-26","2017-09-29","","1","1");
INSERT INTO contas_receber VALUES("4767","201","490","1","1","147.9","0","147.9","2017-07-26","2017-07-21","","1","1");
INSERT INTO contas_receber VALUES("4768","60","491","1","1","715.5","0","715.5","2017-07-26","2017-08-27","","1","1");
INSERT INTO contas_receber VALUES("4769","60","491","2","1","715.5","0","715.5","2017-07-26","2017-09-11","","1","1");
INSERT INTO contas_receber VALUES("4770","60","491","3","1","715.5","0","715.5","2017-07-26","2017-09-27","","1","1");
INSERT INTO contas_receber VALUES("4771","195","492","1","1","113.5","0","113.5","2017-07-26","2017-08-18","","1","1");
INSERT INTO contas_receber VALUES("4801","68","495","1","1","306.6","0","306.6","2017-07-27","2017-07-27","","1","1");
INSERT INTO contas_receber VALUES("4818","202","496","1","1","1270.15","0","1270.15","2017-07-28","2017-08-04","","1","1");
INSERT INTO contas_receber VALUES("4819","202","496","2","1","1270.15","0","1270.15","2017-07-28","2017-08-04","","1","1");
INSERT INTO contas_receber VALUES("4820","47","497","2","1","602.5","0","602.5","2017-07-28","2017-09-17","","1","1");
INSERT INTO contas_receber VALUES("4821","47","497","1","1","602.5","0","602.5","2017-07-28","2017-09-02","","1","1");
INSERT INTO contas_receber VALUES("4822","47","497","3","1","602.5","0","602.5","2017-07-28","2017-10-02","","1","1");
INSERT INTO contas_receber VALUES("4823","198","509","1","1","215.63","215.63","0","2017-07-28","2017-09-01","","0","1");
INSERT INTO contas_receber VALUES("4824","198","509","2","1","215.62","215.62","0","2017-07-28","2017-10-01","","0","1");
INSERT INTO contas_receber VALUES("4825","44","504","3","1","750.6","0","750.6","2017-07-28","2017-10-04","","1","1");
INSERT INTO contas_receber VALUES("4826","44","504","1","1","750.59","0","750.59","2017-07-28","2017-09-04","","1","1");
INSERT INTO contas_receber VALUES("4827","44","504","2","1","750.59","0","750.59","2017-07-28","2017-09-19","","1","1");
INSERT INTO contas_receber VALUES("4883","193","466","1","1","47.59","0","47.59","2017-08-01","2017-07-09","","1","1");
INSERT INTO contas_receber VALUES("4884","204","501","1","1","36","0","36","2017-08-01","2017-07-27","","1","1");
INSERT INTO contas_receber VALUES("4885","83","506","1","1","260.53","260.53","0","2017-08-01","2017-09-02","","0","0");
INSERT INTO contas_receber VALUES("4886","83","506","2","1","260.53","260.53","0","2017-08-01","2017-10-02","","0","0");
INSERT INTO contas_receber VALUES("4887","24","508","1","1","1321.98","0","1321.98","2017-08-01","2017-08-18","","1","1");
INSERT INTO contas_receber VALUES("4888","24","508","2","1","1321.98","0","1321.98","2017-08-01","2017-08-18","","1","1");
INSERT INTO contas_receber VALUES("4905","19","518","1","1","215.5","215.5","0","2017-08-01","2017-08-04","","0","0");
INSERT INTO contas_receber VALUES("4906","19","518","2","1","215.5","215.5","0","2017-08-01","2017-09-04","","0","0");
INSERT INTO contas_receber VALUES("4907","19","518","3","1","215.5","215.5","0","2017-08-01","2017-10-05","","0","0");
INSERT INTO contas_receber VALUES("4932","94","500","1","1","354.68","0","354.68","2017-08-03","2017-09-01","","1","1");
INSERT INTO contas_receber VALUES("4933","94","500","2","1","354.68","0","354.68","2017-08-03","2017-10-01","","1","1");
INSERT INTO contas_receber VALUES("4941","3","510","1","1","232.45","0","232.45","2017-08-03","2017-07-30","","1","1");
INSERT INTO contas_receber VALUES("4970","41","512","1","1","708.04","0","708.04","2017-08-04","2017-09-09","","1","1");
INSERT INTO contas_receber VALUES("4971","41","512","4","1","708.03","0","708.03","2017-08-04","2017-11-08","","1","1");
INSERT INTO contas_receber VALUES("4972","41","512","3","1","708.04","0","708.04","2017-08-04","2017-10-24","","1","1");
INSERT INTO contas_receber VALUES("4973","41","512","2","1","708.04","0","708.04","2017-08-04","2017-09-25","","1","1");
INSERT INTO contas_receber VALUES("4974","205","511","1","1","451.65","0","451.65","2017-08-04","2017-09-04","","1","1");
INSERT INTO contas_receber VALUES("4975","205","511","2","1","451.65","0","451.65","2017-08-04","2017-09-19","","1","1");
INSERT INTO contas_receber VALUES("4976","205","511","3","1","451.66","0","451.66","2017-08-04","2017-10-04","","1","1");
INSERT INTO contas_receber VALUES("4977","51","514","1","1","618.5","0","618.5","2017-08-04","2017-09-04","","1","1");
INSERT INTO contas_receber VALUES("4978","51","514","2","1","618.5","0","618.5","2017-08-04","2017-09-19","","1","1");
INSERT INTO contas_receber VALUES("4979","51","514","3","1","618.5","0","618.5","2017-08-04","2017-10-04","","1","1");
INSERT INTO contas_receber VALUES("4980","4","513","1","1","812","0","812","2017-08-04","2017-09-07","","1","1");
INSERT INTO contas_receber VALUES("4981","4","513","2","1","812","0","812","2017-08-04","2017-09-22","","1","1");
INSERT INTO contas_receber VALUES("4982","4","513","3","1","812","0","812","2017-08-04","2017-10-07","","1","1");
INSERT INTO contas_receber VALUES("4983","74","525","1","1","1450.82","1450.82","0","2017-08-04","2017-09-11","","0","0");
INSERT INTO contas_receber VALUES("4984","74","525","3","1","1450.81","1450.81","0","2017-08-04","2017-11-11","","0","0");
INSERT INTO contas_receber VALUES("4985","74","525","2","1","1450.82","1450.82","0","2017-08-04","2017-10-11","","0","0");
INSERT INTO contas_receber VALUES("4986","46","521","1","1","388.75","0","388.75","2017-08-04","2017-09-04","","1","1");
INSERT INTO contas_receber VALUES("4987","19","519","2","1","214.3","0","214.3","2017-08-04","2017-09-23","","1","1");
INSERT INTO contas_receber VALUES("4988","19","519","1","1","214.3","0","214.3","2017-08-04","2017-09-08","","1","1");
INSERT INTO contas_receber VALUES("4989","19","519","3","1","214.3","0","214.3","2017-08-04","2017-10-08","","1","1");
INSERT INTO contas_receber VALUES("4990","31","487","1","1","278.3","0","278.3","2017-08-04","2017-09-07","","1","1");
INSERT INTO contas_receber VALUES("4991","31","487","2","1","278.3","0","278.3","2017-08-04","2017-10-07","","1","1");
INSERT INTO contas_receber VALUES("4993","172","520","1","1","56.48","56.48","0","2017-08-04","2017-09-07","","0","0");
INSERT INTO contas_receber VALUES("4994","140","515","1","1","261.4","0","261.4","2017-08-04","2017-09-08","","1","1");
INSERT INTO contas_receber VALUES("4995","140","515","2","1","261.4","0","261.4","2017-08-04","2017-09-23","","1","1");
INSERT INTO contas_receber VALUES("4996","140","515","3","1","261.4","0","261.4","2017-08-04","2017-10-08","","1","1");
INSERT INTO contas_receber VALUES("5051","3","528","1","1","12","0","12","2017-08-10","2017-08-06","","1","1");
INSERT INTO contas_receber VALUES("5052","62","522","1","1","764.79","0","764.79","2017-08-10","2017-09-16","","1","1");
INSERT INTO contas_receber VALUES("5053","62","522","2","1","764.79","0","764.79","2017-08-10","2017-10-02","","1","1");
INSERT INTO contas_receber VALUES("5054","62","522","3","1","764.8","0","764.8","2017-08-10","2017-10-16","","1","1");
INSERT INTO contas_receber VALUES("5060","25","529","1","1","288","0","288","2017-08-10","2017-09-11","","1","1");
INSERT INTO contas_receber VALUES("5061","25","529","2","1","288","0","288","2017-08-10","2017-09-26","","1","1");
INSERT INTO contas_receber VALUES("5062","25","529","3","1","288","0","288","2017-08-10","2017-10-11","","1","1");
INSERT INTO contas_receber VALUES("5063","25","529","4","1","288","0","288","2017-08-10","2017-09-11","","1","1");
INSERT INTO contas_receber VALUES("5064","25","529","5","1","288","0","288","2017-08-10","2017-10-11","","1","1");
INSERT INTO contas_receber VALUES("5065","9","526","1","1","419.5","0","419.5","2017-08-10","2017-09-11","","1","1");
INSERT INTO contas_receber VALUES("5066","9","526","2","1","419.5","0","419.5","2017-08-10","2017-10-11","","1","1");
INSERT INTO contas_receber VALUES("5067","208","533","1","1","400.18","0","400.18","2017-08-10","2017-09-16","","1","1");
INSERT INTO contas_receber VALUES("5068","208","533","2","1","400.18","0","400.18","2017-08-10","2017-10-02","","1","1");
INSERT INTO contas_receber VALUES("5069","208","533","3","1","400.17","0","400.17","2017-08-10","2017-10-16","","1","1");
INSERT INTO contas_receber VALUES("5070","47","530","1","1","420.97","0","420.97","2017-08-10","2017-09-17","","1","1");
INSERT INTO contas_receber VALUES("5071","47","530","3","1","420.96","0","420.96","2017-08-10","2017-10-17","","1","1");
INSERT INTO contas_receber VALUES("5072","47","530","2","1","420.97","0","420.97","2017-08-10","2017-10-02","","1","1");
INSERT INTO contas_receber VALUES("5073","3","539","1","1","44","0","44","2017-08-10","2017-08-12","","1","1");
INSERT INTO contas_receber VALUES("5074","28","531","1","1","128.15","0","128.15","2017-08-10","2017-08-09","","1","1");
INSERT INTO contas_receber VALUES("5075","32","532","1","1","118.96","0","118.96","2017-08-10","2017-09-10","","1","1");
INSERT INTO contas_receber VALUES("5076","31","536","1","1","162.1","162.1","0","2017-08-10","2017-09-09","","0","0");
INSERT INTO contas_receber VALUES("5077","206","516","1","1","106.35","0","106.35","2017-08-10","2017-08-03","","1","1");
INSERT INTO contas_receber VALUES("5078","113","523","1","1","350","0","350","2017-08-10","2017-09-10","","1","1");
INSERT INTO contas_receber VALUES("5079","113","523","2","1","350","0","350","2017-08-10","2017-09-25","","1","1");
INSERT INTO contas_receber VALUES("5080","113","523","3","1","350","0","350","2017-08-10","2017-10-10","","1","1");
INSERT INTO contas_receber VALUES("5191","201","535","1","1","133.95","0","133.95","2017-08-16","2017-09-14","","1","1");
INSERT INTO contas_receber VALUES("5192","31","540","1","1","253.5","0","253.5","2017-08-16","2017-09-14","","1","1");
INSERT INTO contas_receber VALUES("5193","31","540","2","1","253.5","0","253.5","2017-08-16","2017-10-14","","1","1");
INSERT INTO contas_receber VALUES("5194","207","527","1","1","444.03","0","444.03","2017-08-16","2017-08-06","","1","1");
INSERT INTO contas_receber VALUES("5195","209","534","1","1","107.56","0","107.56","2017-08-16","2017-08-10","","1","1");
INSERT INTO contas_receber VALUES("5238","214","562","1","1","1236.88","1236.88","0","2017-08-18","2017-08-21","","0","0");
INSERT INTO contas_receber VALUES("5244","70","543","1","1","637.7","0","637.7","2017-08-21","2017-09-08","","1","1");
INSERT INTO contas_receber VALUES("5245","70","543","2","1","637.7","0","637.7","2017-08-21","2017-09-08","","1","1");
INSERT INTO contas_receber VALUES("5246","24","544","1","1","315","0","315","2017-08-21","2017-09-05","","1","1");
INSERT INTO contas_receber VALUES("5247","24","544","2","1","315","0","315","2017-08-21","2017-09-05","","1","1");
INSERT INTO contas_receber VALUES("5248","22","538","1","1","921.07","0","921.07","2017-08-21","2017-09-21","","1","1");
INSERT INTO contas_receber VALUES("5249","22","538","2","1","921.07","0","921.07","2017-08-21","2017-10-06","","1","1");
INSERT INTO contas_receber VALUES("5250","22","538","3","1","921.06","0","921.06","2017-08-21","2017-10-21","","1","1");
INSERT INTO contas_receber VALUES("5255","31","542","1","1","231.41","0","231.41","2017-08-21","2017-09-18","","1","1");
INSERT INTO contas_receber VALUES("5256","31","542","2","1","231.41","0","231.41","2017-08-21","2017-10-18","","1","1");
INSERT INTO contas_receber VALUES("5257","31","542","3","1","231.42","0","231.42","2017-08-21","2017-10-03","","1","1");
INSERT INTO contas_receber VALUES("5293","106","568","2","1","325.53","325.53","0","2017-08-23","2017-09-26","","0","0");
INSERT INTO contas_receber VALUES("5294","106","568","1","1","325.53","325.53","0","2017-08-23","2017-08-26","","0","0");
INSERT INTO contas_receber VALUES("5295","106","568","3","1","325.54","325.54","0","2017-08-23","2017-10-27","","0","0");
INSERT INTO contas_receber VALUES("5312","106","569","1","1","395.27","395.27","0","2017-08-23","2017-08-26","","0","0");
INSERT INTO contas_receber VALUES("5313","106","569","2","1","395.27","395.27","0","2017-08-23","2017-09-26","","0","0");
INSERT INTO contas_receber VALUES("5314","106","569","3","1","395.26","395.26","0","2017-08-23","2017-10-27","","0","0");
INSERT INTO contas_receber VALUES("5345","8","545","1","1","40.6","0","40.6","2017-08-24","2017-08-13","","1","1");
INSERT INTO contas_receber VALUES("5371","129","560","1","1","457.33","0","457.33","2017-08-24","2017-09-25","","1","1");
INSERT INTO contas_receber VALUES("5372","129","560","2","1","457.33","0","457.33","2017-08-24","2017-10-10","","1","1");
INSERT INTO contas_receber VALUES("5373","129","560","3","1","457.34","0","457.34","2017-08-24","2017-10-25","","1","1");
INSERT INTO contas_receber VALUES("5374","33","548","1","1","464.67","0","464.67","2017-08-24","2017-09-24","","1","1");
INSERT INTO contas_receber VALUES("5375","33","548","3","1","464.66","0","464.66","2017-08-24","2017-11-24","","1","1");
INSERT INTO contas_receber VALUES("5376","33","548","2","1","464.67","0","464.67","2017-08-24","2017-10-24","","1","1");
INSERT INTO contas_receber VALUES("5377","211","549","2","1","411.83","0","411.83","2017-08-24","2017-10-10","","1","1");
INSERT INTO contas_receber VALUES("5378","211","549","3","1","411.84","0","411.84","2017-08-24","2017-10-25","","1","1");
INSERT INTO contas_receber VALUES("5379","211","549","1","1","411.83","0","411.83","2017-08-24","2017-09-25","","1","1");
INSERT INTO contas_receber VALUES("5380","210","541","1","1","174.8","0","174.8","2017-08-24","2017-09-18","","1","1");
INSERT INTO contas_receber VALUES("5381","210","541","2","1","174.8","0","174.8","2017-08-24","2017-10-18","","1","1");
INSERT INTO contas_receber VALUES("5382","59","537","1","1","263.63","0","263.63","2017-08-24","2017-09-18","","1","1");
INSERT INTO contas_receber VALUES("5383","59","537","2","1","263.63","0","263.63","2017-08-24","2017-10-03","","1","1");
INSERT INTO contas_receber VALUES("5384","59","537","3","1","263.64","0","263.64","2017-08-24","2017-10-18","","1","1");
INSERT INTO contas_receber VALUES("5385","4","546","1","1","1120.47","0","1120.47","2017-08-24","2017-09-22","","1","1");
INSERT INTO contas_receber VALUES("5386","4","546","3","1","1120.46","0","1120.46","2017-08-24","2017-10-22","","1","1");
INSERT INTO contas_receber VALUES("5387","4","546","2","1","1120.47","0","1120.47","2017-08-24","2017-10-07","","1","1");
INSERT INTO contas_receber VALUES("5388","54","550","1","1","196.23","0","196.23","2017-08-24","2017-08-18","","1","1");
INSERT INTO contas_receber VALUES("5389","112","551","1","1","48.08","0","48.08","2017-08-24","2017-08-18","","1","1");
INSERT INTO contas_receber VALUES("5390","3","557","1","1","41.72","0","41.72","2017-08-24","2017-08-19","","1","1");
INSERT INTO contas_receber VALUES("5391","213","561","1","1","70.6","0","70.6","2017-08-24","2017-08-20","","1","1");
INSERT INTO contas_receber VALUES("5392","216","564","1","1","64.8","0","64.8","2017-08-24","2017-08-25","","1","1");
INSERT INTO contas_receber VALUES("5422","31","565","1","1","339.07","0","339.07","2017-08-25","2017-09-28","","1","1");
INSERT INTO contas_receber VALUES("5423","31","565","2","1","339.07","0","339.07","2017-08-25","2017-10-13","","1","1");
INSERT INTO contas_receber VALUES("5424","31","565","3","1","339.06","0","339.06","2017-08-25","2017-10-28","","1","1");
INSERT INTO contas_receber VALUES("5425","212","554","1","1","558.27","558.27","0","2017-08-25","2017-09-25","","0","0");
INSERT INTO contas_receber VALUES("5426","212","554","2","1","558.27","558.27","0","2017-08-25","2017-10-10","","0","0");
INSERT INTO contas_receber VALUES("5427","212","554","3","1","558.26","558.26","0","2017-08-25","2017-10-25","","0","0");
INSERT INTO contas_receber VALUES("5428","49","553","1","1","612.45","0","612.45","2017-08-25","2017-10-25","","1","1");
INSERT INTO contas_receber VALUES("5429","49","553","2","1","612.45","0","612.45","2017-08-25","2017-11-25","","1","1");
INSERT INTO contas_receber VALUES("5430","49","553","3","1","612.45","0","612.45","2017-08-25","2017-12-25","","1","1");
INSERT INTO contas_receber VALUES("5434","98","547","1","1","865.17","865.17","0","2017-08-25","2017-09-25","","0","0");
INSERT INTO contas_receber VALUES("5435","98","547","2","1","865.17","865.17","0","2017-08-25","2017-10-25","","0","0");
INSERT INTO contas_receber VALUES("5436","98","547","3","1","865.16","865.16","0","2017-08-25","2017-11-25","","0","0");
INSERT INTO contas_receber VALUES("5440","35","559","1","1","110.93","0","110.93","2017-08-25","2017-09-25","","1","1");
INSERT INTO contas_receber VALUES("5441","35","559","2","1","110.93","0","110.93","2017-08-25","2017-10-25","","1","1");
INSERT INTO contas_receber VALUES("5442","35","559","3","1","110.94","0","110.94","2017-08-25","2017-11-25","","1","1");
INSERT INTO contas_receber VALUES("5475","68","552","1","1","1274.25","0","1274.25","2017-08-28","2017-08-18","","1","1");
INSERT INTO contas_receber VALUES("5476","68","552","2","1","1274.25","0","1274.25","2017-08-28","2017-09-05","","1","1");
INSERT INTO contas_receber VALUES("5477","30","555","1","1","690.63","0","690.63","2017-08-28","2017-09-28","","1","1");
INSERT INTO contas_receber VALUES("5478","30","555","2","1","690.63","0","690.63","2017-08-28","2017-10-09","","1","1");
INSERT INTO contas_receber VALUES("5479","30","555","4","1","690.61","0","690.61","2017-08-28","2017-10-30","","1","1");
INSERT INTO contas_receber VALUES("5480","30","555","3","1","690.63","0","690.63","2017-08-28","2017-10-18","","1","1");
INSERT INTO contas_receber VALUES("5484","84","558","1","1","783.23","783.23","0","2017-08-28","2017-09-29","","0","0");
INSERT INTO contas_receber VALUES("5485","84","558","2","1","783.23","783.23","0","2017-08-28","2017-10-14","","0","0");
INSERT INTO contas_receber VALUES("5486","84","558","3","1","783.24","783.24","0","2017-08-28","2017-10-29","","0","0");
INSERT INTO contas_receber VALUES("5525","3","577","1","1","197.77","0","197.77","2017-08-31","2017-08-27","","1","1");
INSERT INTO contas_receber VALUES("5526","106","574","1","1","395.27","395.27","0","2017-08-31","2017-10-01","","0","0");
INSERT INTO contas_receber VALUES("5527","106","574","2","1","395.27","395.27","0","2017-08-31","2017-10-16","","0","0");
INSERT INTO contas_receber VALUES("5528","106","574","3","1","395.26","395.26","0","2017-08-31","2017-11-01","","0","0");
INSERT INTO contas_receber VALUES("5529","217","567","1","1","788.05","0","788.05","2017-08-31","2017-08-25","","1","1");
INSERT INTO contas_receber VALUES("5530","217","567","2","1","788.05","0","788.05","2017-08-31","2017-10-01","","1","1");
INSERT INTO contas_receber VALUES("5531","176","566","1","1","405.3","0","405.3","2017-08-31","2017-09-30","","1","1");
INSERT INTO contas_receber VALUES("5532","176","566","2","1","405.3","0","405.3","2017-08-31","2017-10-15","","1","1");
INSERT INTO contas_receber VALUES("5533","176","566","3","1","405.3","0","405.3","2017-08-31","2017-10-30","","1","1");
INSERT INTO contas_receber VALUES("5534","215","563","1","1","493.77","493.77","0","2017-08-31","2017-09-30","","0","0");
INSERT INTO contas_receber VALUES("5535","215","563","3","1","493.76","493.76","0","2017-08-31","2017-10-30","","0","0");
INSERT INTO contas_receber VALUES("5536","215","563","2","1","493.77","493.77","0","2017-08-31","2017-10-15","","0","0");
INSERT INTO contas_receber VALUES("5537","159","575","1","1","114.6","0","114.6","2017-08-31","2017-08-27","","1","1");
INSERT INTO contas_receber VALUES("5538","218","579","1","1","2004.7","0","2004.7","2017-08-31","2017-08-29","","1","1");
INSERT INTO contas_receber VALUES("5555","23","570","1","1","564.73","0","564.73","2017-09-04","2017-10-01","","1","1");
INSERT INTO contas_receber VALUES("5556","23","570","2","1","564.73","0","564.73","2017-09-04","2017-10-16","","1","1");
INSERT INTO contas_receber VALUES("5557","23","570","3","1","564.74","0","564.74","2017-09-04","2017-11-01","","1","1");
INSERT INTO contas_receber VALUES("5558","19","572","1","1","351.1","0","351.1","2017-09-04","2017-10-05","","1","1");
INSERT INTO contas_receber VALUES("5559","19","572","2","1","351.1","0","351.1","2017-09-04","2017-11-05","","1","1");
INSERT INTO contas_receber VALUES("5574","216","589","1","1","31.04","0","31.04","2017-09-04","2017-09-06","","1","1");
INSERT INTO contas_receber VALUES("5579","83","590","1","1","191","191","0","2017-09-05","2017-09-08","","0","0");
INSERT INTO contas_receber VALUES("5581","83","591","1","1","191","191","0","2017-09-05","2017-09-07","","0","0");
INSERT INTO contas_receber VALUES("5582","37","573","1","1","478.19","0","478.19","2017-09-06","2017-10-05","","1","1");
INSERT INTO contas_receber VALUES("5583","37","573","2","1","478.19","0","478.19","2017-09-06","2017-10-20","","1","1");
INSERT INTO contas_receber VALUES("5584","37","573","3","1","478.18","0","478.18","2017-09-06","2017-11-05","","1","1");
INSERT INTO contas_receber VALUES("5614","31","596","1","1","217.35","217.35","0","2017-09-06","2017-09-09","","0","0");
INSERT INTO contas_receber VALUES("5615","31","596","2","1","217.35","217.35","0","2017-09-06","2017-10-10","","0","0");
INSERT INTO contas_receber VALUES("5646","8","571","1","1","408","0","408","2017-09-08","2017-10-04","","1","1");
INSERT INTO contas_receber VALUES("5647","8","571","2","1","408","0","408","2017-09-08","2017-10-19","","1","1");
INSERT INTO contas_receber VALUES("5648","8","571","3","1","408","0","408","2017-09-08","2017-11-04","","1","1");
INSERT INTO contas_receber VALUES("5649","220","582","1","1","1515.83","0","1515.83","2017-09-08","2017-10-11","","1","1");
INSERT INTO contas_receber VALUES("5650","220","582","3","1","1515.84","0","1515.84","2017-09-08","2017-11-11","","1","1");
INSERT INTO contas_receber VALUES("5651","220","582","2","1","1515.83","0","1515.83","2017-09-08","2017-10-26","","1","1");
INSERT INTO contas_receber VALUES("5652","31","586","1","1","228.26","0","228.26","2017-09-08","2017-10-06","","1","1");
INSERT INTO contas_receber VALUES("5653","31","586","2","1","228.26","0","228.26","2017-09-08","2017-10-21","","1","1");
INSERT INTO contas_receber VALUES("5654","31","586","3","1","228.26","0","228.26","2017-09-08","2017-11-06","","1","1");
INSERT INTO contas_receber VALUES("5661","22","576","1","1","413.93","413.93","0","2017-09-08","2017-10-06","","0","0");
INSERT INTO contas_receber VALUES("5662","22","576","2","1","413.93","413.93","0","2017-09-08","2017-10-21","","0","0");
INSERT INTO contas_receber VALUES("5663","22","576","3","1","413.94","413.94","0","2017-09-08","2017-11-06","","0","0");
INSERT INTO contas_receber VALUES("5664","4","578","1","1","1016","0","1016","2017-09-08","2017-10-06","","1","1");
INSERT INTO contas_receber VALUES("5665","4","578","2","1","1016","0","1016","2017-09-08","2017-10-21","","1","1");
INSERT INTO contas_receber VALUES("5666","4","578","3","1","1016","0","1016","2017-09-08","2017-11-06","","1","1");
INSERT INTO contas_receber VALUES("5667","219","580","1","1","399.77","0","399.77","2017-09-08","2017-10-10","","1","1");
INSERT INTO contas_receber VALUES("5668","219","580","2","1","399.77","0","399.77","2017-09-08","2017-10-24","","1","1");
INSERT INTO contas_receber VALUES("5669","219","580","3","1","399.76","0","399.76","2017-09-08","2017-10-31","","1","1");
INSERT INTO contas_receber VALUES("5670","43","581","1","1","265.99","0","265.99","2017-09-08","2017-10-06","","1","1");
INSERT INTO contas_receber VALUES("5671","43","581","2","1","265.99","0","265.99","2017-09-08","2017-11-06","","1","1");
INSERT INTO contas_receber VALUES("5672","3","585","1","1","24.92","0","24.92","2017-09-08","2017-09-02","","1","1");
INSERT INTO contas_receber VALUES("5673","31","588","1","1","285","0","285","2017-09-08","2017-10-08","","1","1");
INSERT INTO contas_receber VALUES("5674","31","588","2","1","285","0","285","2017-09-08","2017-10-23","","1","1");
INSERT INTO contas_receber VALUES("5675","31","588","3","1","285","0","285","2017-09-08","2017-11-08","","1","1");
INSERT INTO contas_receber VALUES("5680","70","602","1","1","576.9","576.9","0","2017-09-08","2017-09-10","","0","0");
INSERT INTO contas_receber VALUES("5681","70","602","2","1","576.9","576.9","0","2017-09-08","2017-10-11","","0","0");
INSERT INTO contas_receber VALUES("5764","83","599","1","1","207.97","0","207.97","2017-09-12","2017-10-12","","1","1");
INSERT INTO contas_receber VALUES("5765","224","601","1","1","83.9","0","83.9","2017-09-12","2017-09-11","","1","1");
INSERT INTO contas_receber VALUES("5766","3","604","1","1","56.48","56.48","0","2017-09-12","2017-09-11","","0","0");
INSERT INTO contas_receber VALUES("5767","184","606","1","1","53","53","0","2017-09-12","2017-09-11","","0","0");
INSERT INTO contas_receber VALUES("5806","44","583","1","1","660.43","0","660.43","2017-09-13","2017-10-11","","1","1");
INSERT INTO contas_receber VALUES("5807","44","583","2","1","660.43","0","660.43","2017-09-13","2017-10-26","","1","1");
INSERT INTO contas_receber VALUES("5808","44","583","3","1","660.44","0","660.44","2017-09-13","2017-11-11","","1","1");
INSERT INTO contas_receber VALUES("5809","221","584","1","1","1580.17","0","1580.17","2017-09-13","2017-10-13","","1","1");
INSERT INTO contas_receber VALUES("5810","221","584","3","1","1580.16","0","1580.16","2017-09-13","2017-11-13","","1","1");
INSERT INTO contas_receber VALUES("5811","221","584","2","1","1580.17","0","1580.17","2017-09-13","2017-10-28","","1","1");
INSERT INTO contas_receber VALUES("5838","128","595","1","1","359.17","0","359.17","2017-09-14","2017-10-15","","1","1");
INSERT INTO contas_receber VALUES("5839","128","595","2","1","359.17","0","359.17","2017-09-14","2017-10-30","","1","1");
INSERT INTO contas_receber VALUES("5840","128","595","3","1","359.16","0","359.16","2017-09-14","2017-11-15","","1","1");
INSERT INTO contas_receber VALUES("5841","31","597","1","1","217.35","0","217.35","2017-09-14","2017-10-14","","1","1");
INSERT INTO contas_receber VALUES("5842","31","597","2","1","217.35","0","217.35","2017-09-14","2017-11-14","","1","1");
INSERT INTO contas_receber VALUES("5843","31","614","1","1","83.9","0","83.9","2017-09-14","2017-10-30","","1","1");
INSERT INTO contas_receber VALUES("5844","60","587","1","1","518.45","0","518.45","2017-09-14","2017-10-14","","1","1");
INSERT INTO contas_receber VALUES("5845","60","587","2","1","518.45","0","518.45","2017-09-14","2017-10-29","","1","1");
INSERT INTO contas_receber VALUES("5846","60","587","3","1","518.46","0","518.46","2017-09-14","2017-11-14","","1","1");
INSERT INTO contas_receber VALUES("5850","222","594","1","1","2249.35","2249.35","0","2017-09-14","2017-10-02","","0","0");
INSERT INTO contas_receber VALUES("5851","27","605","1","1","28.36","0","28.36","2017-09-14","2017-09-11","","1","1");
INSERT INTO contas_receber VALUES("5852","175","607","1","1","148.78","0","148.78","2017-09-14","2017-09-14","","1","1");
INSERT INTO contas_receber VALUES("5853","225","608","1","1","56.72","0","56.72","2017-09-14","2017-09-13","","1","1");
INSERT INTO contas_receber VALUES("5854","180","524","2","1","390.85","390.85","0","2017-09-14","2017-09-06","","0","1");
INSERT INTO contas_receber VALUES("5855","180","524","1","1","390.85","390.85","0","2017-09-14","2017-08-06","","0","1");
INSERT INTO contas_receber VALUES("5856","180","524","3","1","390.85","390.85","0","2017-09-14","2017-10-07","","0","1");
INSERT INTO contas_receber VALUES("5880","188","440","1","1","240","0","240","2017-09-15","2017-06-29","","1","1");
INSERT INTO contas_receber VALUES("5985","3","632","1","1","189.04","189.04","0","2017-09-19","2017-09-21","","0","0");
INSERT INTO contas_receber VALUES("5998","70","603","1","1","1168.9","0","1168.9","2017-09-19","2017-09-10","","1","1");
INSERT INTO contas_receber VALUES("5999","30","592","1","1","759.88","0","759.88","2017-09-19","2017-10-18","","1","1");
INSERT INTO contas_receber VALUES("6000","30","592","2","1","759.88","0","759.88","2017-09-19","2017-10-30","","1","1");
INSERT INTO contas_receber VALUES("6001","30","592","3","1","759.88","0","759.88","2017-09-19","2017-11-08","","1","1");
INSERT INTO contas_receber VALUES("6002","30","592","4","1","759.86","0","759.86","2017-09-19","2017-11-18","","1","1");
INSERT INTO contas_receber VALUES("6003","161","600","1","1","676.72","0","676.72","2017-09-19","2017-10-19","","1","1");
INSERT INTO contas_receber VALUES("6004","161","600","2","1","676.73","0","676.73","2017-09-19","2017-11-03","","1","1");
INSERT INTO contas_receber VALUES("6005","68","612","1","1","923.75","0","923.75","2017-09-19","2017-09-15","","1","1");
INSERT INTO contas_receber VALUES("6006","68","612","2","1","923.75","0","923.75","2017-09-19","2017-09-25","","1","1");
INSERT INTO contas_receber VALUES("6007","25","611","2","1","370","0","370","2017-09-19","2017-11-05","","1","1");
INSERT INTO contas_receber VALUES("6008","25","611","3","1","370","0","370","2017-09-19","2017-11-20","","1","1");
INSERT INTO contas_receber VALUES("6009","25","611","4","1","370","0","370","2017-09-19","2017-12-05","","1","1");
INSERT INTO contas_receber VALUES("6010","25","611","5","1","370","0","370","2017-09-19","2017-12-20","","1","1");
INSERT INTO contas_receber VALUES("6011","25","611","1","1","370","0","370","2017-09-19","2017-10-21","","1","1");
INSERT INTO contas_receber VALUES("6012","220","628","1","1","1272.57","0","1272.57","2017-09-19","2017-10-21","","1","1");
INSERT INTO contas_receber VALUES("6013","220","628","2","1","1272.57","0","1272.57","2017-09-19","2017-11-05","","1","1");
INSERT INTO contas_receber VALUES("6014","220","628","3","1","1272.56","0","1272.56","2017-09-19","2017-11-21","","1","1");
INSERT INTO contas_receber VALUES("6031","231","638","1","1","205.38","205.38","0","2017-09-20","2017-09-22","","0","0");
INSERT INTO contas_receber VALUES("6032","231","638","2","1","205.38","205.38","0","2017-09-20","2017-10-23","","0","0");
INSERT INTO contas_receber VALUES("6044","28","593","1","1","270.68","0","270.68","2017-09-20","2017-09-08","","1","1");
INSERT INTO contas_receber VALUES("6045","223","598","1","1","399.8","0","399.8","2017-09-20","2017-10-18","","1","1");
INSERT INTO contas_receber VALUES("6046","223","598","2","1","399.8","0","399.8","2017-09-20","2017-11-02","","1","1");
INSERT INTO contas_receber VALUES("6047","223","598","3","1","399.8","0","399.8","2017-09-20","2017-11-18","","1","1");
INSERT INTO contas_receber VALUES("6048","127","464","1","1","228.4","0","228.4","2017-09-20","2017-09-25","","1","1");
INSERT INTO contas_receber VALUES("6049","127","464","2","1","228.4","0","228.4","2017-09-20","2017-10-25","","1","1");
INSERT INTO contas_receber VALUES("6050","226","610","1","1","35.88","0","35.88","2017-09-20","2017-09-15","","1","1");
INSERT INTO contas_receber VALUES("6051","228","613","1","1","73","0","73","2017-09-20","2017-09-15","","1","1");
INSERT INTO contas_receber VALUES("6093","206","630","1","1","70.9","0","70.9","2017-09-25","2017-09-21","","1","1");
INSERT INTO contas_receber VALUES("6094","27","631","1","1","78.01","0","78.01","2017-09-25","2017-09-21","","1","1");
INSERT INTO contas_receber VALUES("6095","3","623","1","1","100","0","100","2017-09-25","2017-09-17","","1","1");
INSERT INTO contas_receber VALUES("6096","233","643","1","1","85.5","0","85.5","2017-09-25","2017-09-24","","1","1");
INSERT INTO contas_receber VALUES("6135","25","609","1","1","1237.96","0","1237.96","2017-09-25","2017-10-22","","1","1");
INSERT INTO contas_receber VALUES("6136","25","609","2","1","1237.96","0","1237.96","2017-09-25","2017-11-06","","1","1");
INSERT INTO contas_receber VALUES("6137","25","609","4","1","1237.96","0","1237.96","2017-09-25","2017-12-06","","1","1");
INSERT INTO contas_receber VALUES("6138","25","609","3","1","1237.96","0","1237.96","2017-09-25","2017-11-21","","1","1");
INSERT INTO contas_receber VALUES("6139","25","609","6","1","623.75","0","623.75","2017-09-25","2017-10-31","","1","1");
INSERT INTO contas_receber VALUES("6140","25","609","5","1","1237.96","0","1237.96","2017-09-25","2017-12-21","","1","1");
INSERT INTO contas_receber VALUES("6141","156","627","1","1","339.55","0","339.55","2017-09-26","2017-10-28","","1","1");
INSERT INTO contas_receber VALUES("6142","156","627","2","1","339.55","0","339.55","2017-09-26","2017-11-28","","1","1");
INSERT INTO contas_receber VALUES("6143","31","635","1","1","276.93","0","276.93","2017-09-26","2017-10-28","","1","1");
INSERT INTO contas_receber VALUES("6144","31","635","2","1","276.93","0","276.93","2017-09-26","2017-11-28","","1","1");
INSERT INTO contas_receber VALUES("6145","220","616","1","1","1002","0","1002","2017-09-26","2017-10-26","","1","1");
INSERT INTO contas_receber VALUES("6146","220","616","3","1","1002","0","1002","2017-09-26","2017-11-26","","1","1");
INSERT INTO contas_receber VALUES("6147","220","616","2","1","1002","0","1002","2017-09-26","2017-11-10","","1","1");
INSERT INTO contas_receber VALUES("6148","212","615","1","1","801.8","0","801.8","2017-09-26","2017-10-22","","1","1");
INSERT INTO contas_receber VALUES("6149","212","615","2","1","801.8","0","801.8","2017-09-26","2017-11-06","","1","1");
INSERT INTO contas_receber VALUES("6150","212","615","3","1","801.81","0","801.81","2017-09-26","2017-11-22","","1","1");
INSERT INTO contas_receber VALUES("6177","4","618","1","1","1119.67","0","1119.67","2017-09-27","2017-10-27","","1","1");
INSERT INTO contas_receber VALUES("6178","4","618","2","1","1119.67","0","1119.67","2017-09-27","2017-11-11","","1","1");
INSERT INTO contas_receber VALUES("6179","4","618","3","1","1119.66","0","1119.66","2017-09-27","2017-11-27","","1","1");
INSERT INTO contas_receber VALUES("6180","91","619","1","1","1206.15","0","1206.15","2017-09-27","2017-10-13","","1","1");
INSERT INTO contas_receber VALUES("6207","31","654","1","1","228.75","228.75","0","2017-09-27","2017-09-28","","0","0");
INSERT INTO contas_receber VALUES("6208","31","654","2","1","228.75","228.75","0","2017-09-27","2017-10-29","","0","0");
INSERT INTO contas_receber VALUES("6300","232","641","1","1","1089.39","1089.39","0","2017-09-28","2017-09-25","","0","0");
INSERT INTO contas_receber VALUES("6306","9","661","1","1","829.4","829.4","0","2017-09-28","2017-09-30","","0","0");
INSERT INTO contas_receber VALUES("6307","9","661","2","1","829.4","829.4","0","2017-09-28","2017-10-31","","0","0");
INSERT INTO contas_receber VALUES("6308","9","661","3","1","829.4","829.4","0","2017-09-28","2017-12-01","","0","0");
INSERT INTO contas_receber VALUES("6329","84","640","2","1","543.67","0","543.67","2017-09-28","2017-11-12","","1","1");
INSERT INTO contas_receber VALUES("6330","84","640","3","1","543.66","0","543.66","2017-09-28","2017-11-28","","1","1");
INSERT INTO contas_receber VALUES("6331","84","640","1","1","543.67","0","543.67","2017-09-28","2017-10-28","","1","1");
INSERT INTO contas_receber VALUES("6332","21","658","1","1","380.5","0","380.5","2017-09-28","2017-10-28","","1","1");
INSERT INTO contas_receber VALUES("6333","21","658","2","1","380.5","0","380.5","2017-09-28","2017-11-12","","1","1");
INSERT INTO contas_receber VALUES("6334","21","658","3","1","380.5","0","380.5","2017-09-28","2017-11-28","","1","1");
INSERT INTO contas_receber VALUES("6367","230","622","1","1","1381.9","0","1381.9","2017-09-29","2017-10-28","","1","1");
INSERT INTO contas_receber VALUES("6368","230","622","2","1","1381.9","0","1381.9","2017-09-29","2017-11-28","","1","1");
INSERT INTO contas_receber VALUES("6369","180","620","1","1","392.3","0","392.3","2017-09-29","2017-10-27","","1","1");
INSERT INTO contas_receber VALUES("6370","180","620","2","1","392.3","0","392.3","2017-09-29","2017-11-11","","1","1");
INSERT INTO contas_receber VALUES("6371","180","620","3","1","392.3","0","392.3","2017-09-29","2017-11-27","","1","1");
INSERT INTO contas_receber VALUES("6374","237","660","1","1","114.52","0","114.52","2017-09-30","2017-10-01","","1","1");
INSERT INTO contas_receber VALUES("6385","71","621","1","1","397.4","397.4","0","2017-10-02","2017-10-28","","0","0");
INSERT INTO contas_receber VALUES("6386","71","621","2","1","397.4","397.4","0","2017-10-02","2017-11-12","","0","0");
INSERT INTO contas_receber VALUES("6387","71","621","3","1","397.4","397.4","0","2017-10-02","2017-11-28","","0","0");
INSERT INTO contas_receber VALUES("6388","22","624","1","1","587.99","0","587.99","2017-10-02","2017-11-02","","1","1");
INSERT INTO contas_receber VALUES("6389","22","624","2","1","587.99","0","587.99","2017-10-02","2017-11-17","","1","1");
INSERT INTO contas_receber VALUES("6390","22","624","3","1","588","0","588","2017-10-02","2017-12-02","","1","1");
INSERT INTO contas_receber VALUES("6391","34","625","1","1","849.85","0","849.85","2017-10-02","2017-10-16","","1","1");
INSERT INTO contas_receber VALUES("6392","34","625","2","1","849.85","0","849.85","2017-10-02","2017-10-16","","1","1");
INSERT INTO contas_receber VALUES("6414","29","649","1","1","649.8","0","649.8","2017-10-03","2017-10-18","","1","1");
INSERT INTO contas_receber VALUES("6420","135","672","1","1","439.52","439.52","0","2017-10-03","2017-10-04","","0","0");
INSERT INTO contas_receber VALUES("6421","135","672","2","1","439.52","439.52","0","2017-10-03","2017-11-04","","0","0");
INSERT INTO contas_receber VALUES("6422","135","672","3","1","439.52","439.52","0","2017-10-03","2017-12-05","","0","0");
INSERT INTO contas_receber VALUES("6435","21","659","2","1","1429.2","0","1429.2","2017-10-04","2017-11-03","","1","1");
INSERT INTO contas_receber VALUES("6436","21","659","1","1","1429.2","0","1429.2","2017-10-04","2017-10-24","","1","1");
INSERT INTO contas_receber VALUES("6437","21","659","3","1","1429.2","0","1429.2","2017-10-04","2017-11-13","","1","1");
INSERT INTO contas_receber VALUES("6438","21","659","5","1","1429.2","0","1429.2","2017-10-04","2017-12-03","","1","1");
INSERT INTO contas_receber VALUES("6439","21","659","4","1","1429.2","0","1429.2","2017-10-04","2017-11-23","","1","1");
INSERT INTO contas_receber VALUES("6441","166","365","1","1","234.7","234.7","0","2017-10-04","2017-05-17","","0","0");
INSERT INTO contas_receber VALUES("6442","238","668","1","1","164.95","0","164.95","2017-10-04","2017-10-04","","1","1");
INSERT INTO contas_receber VALUES("6443","23","636","1","1","451.17","0","451.17","2017-10-04","2017-11-05","","1","1");
INSERT INTO contas_receber VALUES("6444","23","636","2","1","451.17","0","451.17","2017-10-04","2017-11-20","","1","1");
INSERT INTO contas_receber VALUES("6445","23","636","3","1","451.16","0","451.16","2017-10-04","2017-12-05","","1","1");
INSERT INTO contas_receber VALUES("6446","229","617","1","1","507.55","0","507.55","2017-10-04","2017-11-05","","1","1");
INSERT INTO contas_receber VALUES("6447","229","617","2","1","507.55","0","507.55","2017-10-04","2017-11-20","","1","1");
INSERT INTO contas_receber VALUES("6448","229","617","3","1","507.55","0","507.55","2017-10-04","2017-12-05","","1","1");
INSERT INTO contas_receber VALUES("6449","229","617","4","1","507.55","0","507.55","2017-10-04","2017-12-20","","1","1");
INSERT INTO contas_receber VALUES("6452","3","634","1","1","118.14","118.14","0","2017-10-04","2017-09-21","","0","0");
INSERT INTO contas_receber VALUES("6453","72","629","1","1","321.21","0","321.21","2017-10-04","2017-09-20","","1","1");
INSERT INTO contas_receber VALUES("6454","228","645","1","1","31.5","0","31.5","2017-10-04","2017-09-27","","1","1");
INSERT INTO contas_receber VALUES("6455","78","663","1","1","102","0","102","2017-10-04","2017-09-30","","1","1");
INSERT INTO contas_receber VALUES("6456","54","670","1","1","66.34","0","66.34","2017-10-04","2017-10-05","","1","1");
INSERT INTO contas_receber VALUES("6457","3","671","1","1","13","0","13","2017-10-04","2017-10-05","","1","1");
INSERT INTO contas_receber VALUES("6480","101","639","1","1","960.38","0","960.38","2017-10-05","2017-11-06","","1","1");
INSERT INTO contas_receber VALUES("6481","101","639","2","1","960.38","0","960.38","2017-10-05","2017-11-21","","1","1");
INSERT INTO contas_receber VALUES("6482","101","639","3","1","960.39","0","960.39","2017-10-05","2017-12-06","","1","1");
INSERT INTO contas_receber VALUES("6483","31","662","1","1","251.8","0","251.8","2017-10-05","2017-11-04","","1","1");
INSERT INTO contas_receber VALUES("6484","31","662","2","1","251.8","0","251.8","2017-10-05","2017-11-19","","1","1");
INSERT INTO contas_receber VALUES("6485","31","662","3","1","251.8","0","251.8","2017-10-05","2017-12-04","","1","1");
INSERT INTO contas_receber VALUES("6486","235","648","1","1","619.57","0","619.57","2017-10-05","2017-11-06","","1","1");
INSERT INTO contas_receber VALUES("6487","235","648","2","1","619.57","0","619.57","2017-10-05","2017-11-21","","1","1");
INSERT INTO contas_receber VALUES("6488","235","648","3","1","619.56","0","619.56","2017-10-05","2017-12-06","","1","1");
INSERT INTO contas_receber VALUES("6506","78","680","1","1","339.97","339.97","0","2017-10-05","2017-10-07","","0","0");
INSERT INTO contas_receber VALUES("6523","19","651","1","1","294.9","0","294.9","2017-10-06","2017-11-06","","1","1");
INSERT INTO contas_receber VALUES("6524","19","651","2","1","294.9","0","294.9","2017-10-06","2017-12-06","","1","1");
INSERT INTO contas_receber VALUES("6525","234","646","1","1","831.1","0","831.1","2017-10-06","2017-11-06","","1","1");
INSERT INTO contas_receber VALUES("6526","234","646","2","1","831.1","0","831.1","2017-10-06","2017-11-21","","1","1");
INSERT INTO contas_receber VALUES("6527","33","678","1","1","457.33","0","457.33","2017-10-06","2017-11-09","","1","1");
INSERT INTO contas_receber VALUES("6528","33","678","3","1","457.34","0","457.34","2017-10-06","2018-01-09","","1","1");
INSERT INTO contas_receber VALUES("6529","33","678","2","1","457.33","0","457.33","2017-10-06","2017-12-09","","1","1");
INSERT INTO contas_receber VALUES("6538","4","647","1","1","1275.33","0","1275.33","2017-10-06","2017-11-09","","1","1");
INSERT INTO contas_receber VALUES("6539","4","647","2","1","1275.33","0","1275.33","2017-10-06","2017-11-24","","1","1");
INSERT INTO contas_receber VALUES("6540","4","647","3","1","1275.34","0","1275.34","2017-10-06","2017-12-09","","1","1");
INSERT INTO contas_receber VALUES("6550","21","626","1","1","1429.2","0","1429.2","2017-10-06","2017-10-31","","1","1");
INSERT INTO contas_receber VALUES("6551","21","626","2","1","1429.2","0","1429.2","2017-10-06","2017-11-10","","1","1");
INSERT INTO contas_receber VALUES("6552","21","626","4","1","1429.2","0","1429.2","2017-10-06","2017-11-30","","1","1");
INSERT INTO contas_receber VALUES("6553","21","626","3","1","1429.2","0","1429.2","2017-10-06","2017-11-20","","1","1");
INSERT INTO contas_receber VALUES("6554","21","626","5","1","1429.2","0","1429.2","2017-10-06","2017-12-11","","1","1");
INSERT INTO contas_receber VALUES("6572","242","686","1","1","7390","7390","0","2017-10-09","2017-10-11","","0","0");
INSERT INTO contas_receber VALUES("6573","242","686","2","1","7390","7390","0","2017-10-09","2017-11-11","","0","0");
INSERT INTO contas_receber VALUES("6574","242","686","3","1","7390","7390","0","2017-10-09","2017-12-12","","0","0");
INSERT INTO contas_receber VALUES("6586","32","675","1","1","382","0","382","2017-10-10","2017-11-11","","1","1");
INSERT INTO contas_receber VALUES("6587","160","676","1","1","205.1","0","205.1","2017-10-10","2017-11-11","","1","1");
INSERT INTO contas_receber VALUES("6588","160","676","2","1","205.1","0","205.1","2017-10-10","2017-12-11","","1","1");
INSERT INTO contas_receber VALUES("6589","239","673","1","1","439.52","0","439.52","2017-10-10","2017-11-11","","1","1");
INSERT INTO contas_receber VALUES("6590","239","673","3","1","439.52","0","439.52","2017-10-10","2017-12-11","","1","1");
INSERT INTO contas_receber VALUES("6591","239","673","2","1","439.52","0","439.52","2017-10-10","2017-11-27","","1","1");
INSERT INTO contas_receber VALUES("6592","62","653","1","1","695.87","0","695.87","2017-10-10","2017-11-13","","1","1");
INSERT INTO contas_receber VALUES("6593","62","653","2","1","695.87","0","695.87","2017-10-10","2017-11-28","","1","1");
INSERT INTO contas_receber VALUES("6594","62","653","3","1","695.87","0","695.87","2017-10-10","2017-12-13","","1","1");
INSERT INTO contas_receber VALUES("6595","59","655","1","1","434.93","0","434.93","2017-10-11","2017-11-11","","1","1");
INSERT INTO contas_receber VALUES("6596","59","655","2","1","434.93","0","434.93","2017-10-11","2017-11-26","","1","1");
INSERT INTO contas_receber VALUES("6597","59","655","3","1","434.94","0","434.94","2017-10-11","2017-12-11","","1","1");
INSERT INTO contas_receber VALUES("6612","42","652","1","1","1112.67","0","1112.67","2017-10-11","2017-11-16","","1","1");
INSERT INTO contas_receber VALUES("6613","42","652","2","1","1112.67","0","1112.67","2017-10-11","2017-12-01","","1","1");
INSERT INTO contas_receber VALUES("6614","42","652","3","1","1112.66","0","1112.66","2017-10-11","2017-12-16","","1","1");
INSERT INTO contas_receber VALUES("6687","9","503","1","1","829.4","829.4","0","2017-10-16","2017-11-16","","0","0");
INSERT INTO contas_receber VALUES("6688","9","503","2","1","829.4","829.4","0","2017-10-16","2017-12-01","","0","0");
INSERT INTO contas_receber VALUES("6689","9","503","3","1","829.4","829.4","0","2017-10-16","2017-12-16","","0","0");
INSERT INTO contas_receber VALUES("6690","46","689","1","1","128.34","0","128.34","2017-10-16","2017-11-16","","1","1");
INSERT INTO contas_receber VALUES("6691","186","665","1","1","374.3","0","374.3","2017-10-16","2017-11-16","","1","1");
INSERT INTO contas_receber VALUES("6692","186","665","2","1","374.3","0","374.3","2017-10-16","2017-12-16","","1","1");
INSERT INTO contas_receber VALUES("6693","31","685","1","1","320.1","0","320.1","2017-10-16","2017-11-16","","1","1");
INSERT INTO contas_receber VALUES("6694","31","685","2","1","320.1","0","320.1","2017-10-16","2017-12-16","","1","1");
INSERT INTO contas_receber VALUES("6695","220","664","1","1","1034.77","0","1034.77","2017-10-16","2017-11-16","","1","1");
INSERT INTO contas_receber VALUES("6696","220","664","2","1","1034.77","0","1034.77","2017-10-16","2017-12-01","","1","1");
INSERT INTO contas_receber VALUES("6697","220","664","3","1","1034.76","0","1034.76","2017-10-16","2017-12-16","","1","1");
INSERT INTO contas_receber VALUES("6749","86","669","1","1","405.83","0","405.83","2017-10-17","2017-11-17","","1","1");
INSERT INTO contas_receber VALUES("6750","86","669","2","1","405.83","0","405.83","2017-10-17","2017-12-17","","1","1");
INSERT INTO contas_receber VALUES("6751","86","669","3","1","405.84","0","405.84","2017-10-17","2018-01-17","","1","1");
INSERT INTO contas_receber VALUES("6752","125","666","1","1","595.17","0","595.17","2017-10-17","2017-11-18","","1","1");
INSERT INTO contas_receber VALUES("6753","125","666","2","1","595.17","0","595.17","2017-10-17","2017-12-03","","1","1");
INSERT INTO contas_receber VALUES("6754","125","666","3","1","595.16","0","595.16","2017-10-17","2017-12-18","","1","1");
INSERT INTO contas_receber VALUES("6801","240","674","1","1","1304","0","1304","2017-10-18","2017-10-31","","1","1");
INSERT INTO contas_receber VALUES("6802","192","683","1","1","735.2","0","735.2","2017-10-18","2017-11-18","","1","1");
INSERT INTO contas_receber VALUES("6803","192","683","2","1","735.2","0","735.2","2017-10-18","2017-12-03","","1","1");
INSERT INTO contas_receber VALUES("6804","192","683","3","1","735.2","0","735.2","2017-10-18","2017-12-18","","1","1");
INSERT INTO contas_receber VALUES("6807","24","682","1","1","1350.87","0","1350.87","2017-10-18","2017-11-03","","1","1");
INSERT INTO contas_receber VALUES("6808","24","682","2","1","1350.87","0","1350.87","2017-10-18","2017-11-03","","1","1");
INSERT INTO contas_receber VALUES("6811","245","708","1","1","102","0","102","2017-10-18","2017-10-19","","1","1");
INSERT INTO contas_receber VALUES("6820","83","650","2","1","177.84","177.84","0","2017-10-18","2017-12-03","","0","0");
INSERT INTO contas_receber VALUES("6821","83","650","1","1","177.85","177.85","0","2017-10-18","2017-11-03","","0","0");
INSERT INTO contas_receber VALUES("6836","154","687","1","1","149.8","0","149.8","2017-10-19","2017-10-14","","1","1");
INSERT INTO contas_receber VALUES("6837","154","687","2","1","149.8","0","149.8","2017-10-19","2017-11-19","","1","1");
INSERT INTO contas_receber VALUES("6838","43","694","1","1","226.17","0","226.17","2017-10-19","2017-11-19","","1","1");
INSERT INTO contas_receber VALUES("6839","43","694","2","1","226.17","0","226.17","2017-10-19","2017-12-04","","1","1");
INSERT INTO contas_receber VALUES("6840","43","694","3","1","226.16","0","226.16","2017-10-19","2017-12-19","","1","1");
INSERT INTO contas_receber VALUES("6841","47","681","1","1","605.05","0","605.05","2017-10-19","2017-11-19","","1","1");
INSERT INTO contas_receber VALUES("6842","47","681","2","1","605.05","0","605.05","2017-10-19","2017-12-04","","1","1");
INSERT INTO contas_receber VALUES("6843","47","681","3","1","605.05","0","605.05","2017-10-19","2017-12-19","","1","1");
INSERT INTO contas_receber VALUES("6844","84","657","1","1","562.92","0","562.92","2017-10-19","2017-11-06","","1","1");
INSERT INTO contas_receber VALUES("6845","84","657","2","1","562.92","0","562.92","2017-10-19","2017-11-21","","1","1");
INSERT INTO contas_receber VALUES("6846","84","657","3","1","562.91","0","562.91","2017-10-19","2017-12-06","","1","1");
INSERT INTO contas_receber VALUES("6847","98","697","1","1","1620","0","1620","2017-10-19","2017-10-18","","1","1");
INSERT INTO contas_receber VALUES("6893","191","717","1","1","1116.1","1116.1","0","2017-10-19","2017-10-22","","0","1");
INSERT INTO contas_receber VALUES("6894","191","717","2","1","1116.1","1116.1","0","2017-10-19","2017-11-22","","0","1");
INSERT INTO contas_receber VALUES("6895","191","717","3","1","1116.1","1116.1","0","2017-10-19","2017-12-23","","0","1");
INSERT INTO contas_receber VALUES("6905","220","677","1","1","1719.9","0","1719.9","2017-10-20","2017-11-23","","1","1");
INSERT INTO contas_receber VALUES("6906","220","677","2","1","1719.9","0","1719.9","2017-10-20","2017-12-08","","1","1");
INSERT INTO contas_receber VALUES("6907","220","677","3","1","1719.9","0","1719.9","2017-10-20","2017-12-23","","1","1");
INSERT INTO contas_receber VALUES("6908","244","707","1","1","760","0","760","2017-10-20","2017-11-07","","1","1");
INSERT INTO contas_receber VALUES("6921","46","711","1","1","253.81","0","253.81","2017-10-23","2017-11-23","","1","1");
INSERT INTO contas_receber VALUES("6922","4","688","1","1","987","0","987","2017-10-23","2017-11-23","","1","1");
INSERT INTO contas_receber VALUES("6923","4","688","2","1","987","0","987","2017-10-23","2017-12-08","","1","1");
INSERT INTO contas_receber VALUES("6924","4","688","3","1","987","0","987","2017-10-23","2017-12-23","","1","1");
INSERT INTO contas_receber VALUES("6927","246","720","1","1","107","0","107","2017-10-23","2017-11-13","","1","1");
INSERT INTO contas_receber VALUES("6945","33","690","1","1","391.4","391.4","0","2017-10-23","2017-11-24","","0","0");
INSERT INTO contas_receber VALUES("6946","33","690","2","1","391.4","391.4","0","2017-10-23","2017-12-24","","0","0");
INSERT INTO contas_receber VALUES("6947","33","690","3","1","391.4","391.4","0","2017-10-23","2018-01-24","","0","0");
INSERT INTO contas_receber VALUES("6951","247","722","1","1","381.07","381.07","0","2017-10-23","2017-10-24","","0","0");
INSERT INTO contas_receber VALUES("6952","247","722","2","1","381.07","381.07","0","2017-10-23","2017-11-24","","0","0");
INSERT INTO contas_receber VALUES("6953","247","722","3","1","381.06","381.06","0","2017-10-23","2017-12-25","","0","0");
INSERT INTO contas_receber VALUES("6970","83","709","1","1","212.31","0","212.31","2017-10-24","2017-11-24","","1","1");
INSERT INTO contas_receber VALUES("6988","60","716","1","1","607.13","0","607.13","2017-10-24","2017-11-24","","1","1");
INSERT INTO contas_receber VALUES("6989","60","716","2","1","607.13","0","607.13","2017-10-24","2017-12-08","","1","1");
INSERT INTO contas_receber VALUES("6990","60","716","3","1","607.14","0","607.14","2017-10-24","2017-12-24","","1","1");
INSERT INTO contas_receber VALUES("6991","16","693","1","1","219.8","0","219.8","2017-10-24","2017-11-24","","1","1");
INSERT INTO contas_receber VALUES("6992","16","693","2","1","219.8","0","219.8","2017-10-24","2017-12-08","","1","1");
INSERT INTO contas_receber VALUES("6993","16","693","3","1","219.8","0","219.8","2017-10-24","2017-12-24","","1","1");
INSERT INTO contas_receber VALUES("7002","28","713","1","1","360.13","0","360.13","2017-10-24","2017-10-22","","1","1");
INSERT INTO contas_receber VALUES("7003","243","692","1","1","1016","0","1016","2017-10-25","2017-10-14","","1","1");
INSERT INTO contas_receber VALUES("7004","243","692","3","0","508.25","0","508.25","2017-10-25","2017-12-10","","1","1");
INSERT INTO contas_receber VALUES("7005","243","692","2","1","508.05","0","508.05","2017-10-25","2017-11-25","","1","1");
INSERT INTO contas_receber VALUES("7006","19","704","1","1","228.83","0","228.83","2017-10-25","2017-11-25","","1","1");
INSERT INTO contas_receber VALUES("7007","19","704","2","1","228.83","0","228.83","2017-10-25","2017-12-10","","1","1");
INSERT INTO contas_receber VALUES("7008","19","704","3","1","228.84","0","228.84","2017-10-25","2017-12-25","","1","1");
INSERT INTO contas_receber VALUES("7009","174","705","1","1","1246","0","1246","2017-10-25","2017-10-22","","1","1");
INSERT INTO contas_receber VALUES("7044","44","701","1","1","748.43","0","748.43","2017-10-26","2017-11-26","","1","1");
INSERT INTO contas_receber VALUES("7045","44","701","2","1","748.43","0","748.43","2017-10-26","2017-12-11","","1","1");
INSERT INTO contas_receber VALUES("7046","44","701","3","1","748.44","0","748.44","2017-10-26","2017-12-26","","1","1");
INSERT INTO contas_receber VALUES("7047","129","698","1","1","618.83","0","618.83","2017-10-26","2017-11-26","","1","1");
INSERT INTO contas_receber VALUES("7048","129","698","2","1","618.83","0","618.83","2017-10-26","2017-12-11","","1","1");
INSERT INTO contas_receber VALUES("7049","129","698","3","1","618.84","0","618.84","2017-10-26","2017-12-26","","1","1");
INSERT INTO contas_receber VALUES("7058","98","691","2","1","982","0","982","2017-10-26","2017-12-26","","1","1");
INSERT INTO contas_receber VALUES("7059","98","691","1","1","982","0","982","2017-10-26","2017-11-26","","1","1");
INSERT INTO contas_receber VALUES("7060","98","691","3","1","982","0","982","2017-10-26","2018-01-26","","1","1");
INSERT INTO contas_receber VALUES("7061","35","684","1","1","76.4","0","76.4","2017-10-26","2017-10-08","","1","1");
INSERT INTO contas_receber VALUES("7062","3","714","1","1","60.24","0","60.24","2017-10-26","2017-10-22","","1","1");
INSERT INTO contas_receber VALUES("7063","3","695","1","1","75","0","75","2017-10-26","2017-10-15","","1","1");
INSERT INTO contas_receber VALUES("7070","241","679","1","1","347.5","347.5","0","2017-10-27","2017-11-27","","0","0");
INSERT INTO contas_receber VALUES("7071","241","679","2","1","347.5","347.5","0","2017-10-27","2017-12-27","","0","0");
INSERT INTO contas_receber VALUES("7072","7","703","1","1","134.87","0","134.87","2017-10-27","2017-11-27","","1","1");
INSERT INTO contas_receber VALUES("7073","7","703","2","1","134.87","0","134.87","2017-10-27","2017-12-12","","1","1");
INSERT INTO contas_receber VALUES("7074","7","703","3","1","134.86","0","134.86","2017-10-27","2017-12-27","","1","1");
INSERT INTO contas_receber VALUES("7075","140","710","1","1","304.25","0","304.25","2017-10-27","2017-11-27","","1","1");
INSERT INTO contas_receber VALUES("7076","140","710","2","1","304.25","0","304.25","2017-10-27","2017-12-27","","1","1");
INSERT INTO contas_receber VALUES("7077","195","715","1","1","239.9","0","239.9","2017-10-27","2017-11-27","","1","1");
INSERT INTO contas_receber VALUES("7087","31","712","2","1","266.9","266.9","0","2017-10-27","2017-12-12","","0","0");
INSERT INTO contas_receber VALUES("7088","31","712","3","1","266.9","266.9","0","2017-10-27","2017-12-27","","0","0");
INSERT INTO contas_receber VALUES("7089","31","712","1","1","266.9","266.9","0","2017-10-27","2017-11-27","","0","0");
INSERT INTO contas_receber VALUES("7090","161","696","1","1","609.46","0","609.46","2017-10-27","2017-11-27","","1","1");
INSERT INTO contas_receber VALUES("7091","161","696","2","1","609.46","0","609.46","2017-10-27","2017-12-12","","1","1");
INSERT INTO contas_receber VALUES("7094","216","644","1","1","64.8","0","64.8","2017-10-30","2017-09-24","","1","1");
INSERT INTO contas_receber VALUES("7121","202","706","1","1","941","0","941","2017-10-31","2017-11-10","","1","1");
INSERT INTO contas_receber VALUES("7122","202","706","2","1","941","0","941","2017-10-31","2017-11-10","","1","1");
INSERT INTO contas_receber VALUES("7123","220","702","2","1","1799.17","0","1799.17","2017-10-31","2017-12-15","","1","1");
INSERT INTO contas_receber VALUES("7124","220","702","3","1","1799.16","0","1799.16","2017-10-31","2017-12-30","","1","1");
INSERT INTO contas_receber VALUES("7125","220","702","1","1","1799.17","0","1799.17","2017-10-31","2017-11-30","","1","1");
INSERT INTO contas_receber VALUES("7126","96","637","1","1","284.6","0","284.6","2017-10-31","2017-09-25","","1","1");
INSERT INTO contas_receber VALUES("7167","25","699","1","1","740.62","0","740.62","2017-11-01","2017-12-01","","1","1");
INSERT INTO contas_receber VALUES("7168","25","699","2","1","740.62","0","740.62","2017-11-01","2017-12-16","","1","1");
INSERT INTO contas_receber VALUES("7169","25","699","4","1","740.62","0","740.62","2017-11-01","2018-01-15","","1","1");
INSERT INTO contas_receber VALUES("7170","25","699","3","1","740.62","0","740.62","2017-11-01","2018-01-01","","1","1");
INSERT INTO contas_receber VALUES("7171","25","699","5","1","740.62","0","740.62","2017-11-01","2018-02-01","","1","1");
INSERT INTO contas_receber VALUES("7172","191","718","1","1","1206.9","0","1206.9","2017-11-01","2017-12-03","","1","1");
INSERT INTO contas_receber VALUES("7173","191","718","2","1","1206.9","0","1206.9","2017-11-01","2018-01-03","","1","1");
INSERT INTO contas_receber VALUES("7174","191","718","3","1","1206.9","0","1206.9","2017-11-01","2018-02-03","","1","1");
INSERT INTO contas_receber VALUES("7203","248","725","1","1","403.2","0","403.2","2017-11-03","2017-12-03","","1","1");
INSERT INTO contas_receber VALUES("7204","5","724","1","1","367.97","0","367.97","2017-11-03","2017-12-03","","1","1");
INSERT INTO contas_receber VALUES("7205","5","724","2","1","367.97","0","367.97","2017-11-03","2017-12-18","","1","1");
INSERT INTO contas_receber VALUES("7206","5","724","3","1","367.96","0","367.96","2017-11-03","2018-01-03","","1","1");
INSERT INTO contas_receber VALUES("7207","67","721","1","1","373.73","0","373.73","2017-11-03","2017-12-03","","1","1");
INSERT INTO contas_receber VALUES("7208","67","721","2","1","373.73","0","373.73","2017-11-03","2017-12-18","","1","1");
INSERT INTO contas_receber VALUES("7209","67","721","3","1","373.74","0","373.74","2017-11-03","2018-01-03","","1","1");
INSERT INTO contas_receber VALUES("7210","73","723","1","1","1212.9","0","1212.9","2017-11-03","2017-10-27","","1","1");
INSERT INTO contas_receber VALUES("7216","245","733","1","1","62.59","0","62.59","2017-11-06","2017-11-01","","1","1");
INSERT INTO contas_receber VALUES("7223","31","731","1","1","355.75","0","355.75","2017-11-06","2017-12-06","","1","1");
INSERT INTO contas_receber VALUES("7224","31","731","2","1","355.75","0","355.75","2017-11-06","2017-12-21","","1","1");
INSERT INTO contas_receber VALUES("7225","31","731","3","1","355.76","0","355.76","2017-11-06","2018-01-06","","1","1");
INSERT INTO contas_receber VALUES("7234","250","745","1","1","58.32","0","58.32","2017-11-06","2017-11-08","","1","1");
INSERT INTO contas_receber VALUES("7240","251","747","1","1","2013.27","2013.27","0","2017-11-06","2017-11-07","","0","0");
INSERT INTO contas_receber VALUES("7241","251","747","2","1","2013.27","2013.27","0","2017-11-06","2017-12-08","","0","0");
INSERT INTO contas_receber VALUES("7242","251","747","3","1","2013.26","2013.26","0","2017-11-06","2018-01-08","","0","0");
INSERT INTO contas_receber VALUES("7243","33","726","1","1","442.27","0","442.27","2017-11-06","2017-12-07","","1","1");
INSERT INTO contas_receber VALUES("7244","33","726","2","1","442.27","0","442.27","2017-11-06","2018-01-07","","1","1");
INSERT INTO contas_receber VALUES("7245","33","726","3","1","442.26","0","442.26","2017-11-06","2018-02-07","","1","1");
INSERT INTO contas_receber VALUES("7260","172","730","1","1","70","0","70","2017-11-07","2017-12-07","","1","1");
INSERT INTO contas_receber VALUES("7261","30","728","1","1","636.67","0","636.67","2017-11-07","2017-12-07","","1","1");
INSERT INTO contas_receber VALUES("7262","30","728","2","1","636.67","0","636.67","2017-11-07","2017-12-22","","1","1");
INSERT INTO contas_receber VALUES("7263","30","728","3","1","636.67","0","636.67","2017-11-07","2018-01-06","","1","1");
INSERT INTO contas_receber VALUES("7264","30","728","4","1","636.69","0","636.69","2017-11-07","2018-01-21","","1","1");
INSERT INTO contas_receber VALUES("7265","180","727","1","1","432.93","0","432.93","2017-11-07","2017-12-07","","1","1");
INSERT INTO contas_receber VALUES("7266","180","727","2","1","432.93","0","432.93","2017-11-07","2017-12-22","","1","1");
INSERT INTO contas_receber VALUES("7267","180","727","3","1","432.94","0","432.94","2017-11-07","2018-01-07","","1","1");
INSERT INTO contas_receber VALUES("7268","84","741","1","1","430.63","0","430.63","2017-11-08","2017-12-08","","1","1");
INSERT INTO contas_receber VALUES("7269","84","741","2","1","430.63","0","430.63","2017-11-08","2017-12-23","","1","1");
INSERT INTO contas_receber VALUES("7270","84","741","3","1","430.64","0","430.64","2017-11-08","2018-01-08","","1","1");
INSERT INTO contas_receber VALUES("7271","10","735","1","1","928","0","928","2017-11-08","2017-11-23","","1","1");
INSERT INTO contas_receber VALUES("7287","31","751","1","1","152.2","152.2","0","2017-11-08","2017-11-09","","0","0");
INSERT INTO contas_receber VALUES("7288","31","751","1","1","152.2","152.2","0","2017-11-08","2017-11-09","","0","0");
INSERT INTO contas_receber VALUES("7297","113","729","1","1","441","0","441","2017-11-09","2017-12-09","","1","1");
INSERT INTO contas_receber VALUES("7298","113","729","2","1","441","0","441","2017-11-09","2017-12-24","","1","1");
INSERT INTO contas_receber VALUES("7299","113","729","3","1","441","0","441","2017-11-09","2018-01-09","","1","1");
INSERT INTO contas_receber VALUES("7300","4","732","1","1","980.67","0","980.67","2017-11-09","2017-12-09","","1","1");
INSERT INTO contas_receber VALUES("7301","4","732","2","1","980.67","0","980.67","2017-11-09","2017-12-24","","1","1");
INSERT INTO contas_receber VALUES("7302","4","732","3","1","980.66","0","980.66","2017-11-09","2018-01-09","","1","1");
INSERT INTO contas_receber VALUES("7303","249","734","1","1","506","0","506","2017-11-09","2017-12-09","","1","1");
INSERT INTO contas_receber VALUES("7304","249","734","2","1","506","0","506","2017-11-09","2017-12-24","","1","1");
INSERT INTO contas_receber VALUES("7305","249","734","3","1","506","0","506","2017-11-09","2018-01-09","","1","1");
INSERT INTO contas_receber VALUES("7308","3","739","1","1","10.62","0","10.62","2017-11-09","2017-11-03","","1","1");
INSERT INTO contas_receber VALUES("7327","23","737","1","1","600.8","0","600.8","2017-11-10","2017-12-10","","1","1");
INSERT INTO contas_receber VALUES("7328","23","737","2","1","600.8","0","600.8","2017-11-10","2017-12-25","","1","1");
INSERT INTO contas_receber VALUES("7329","23","737","3","1","600.8","0","600.8","2017-11-10","2018-01-10","","1","1");
INSERT INTO contas_receber VALUES("7342","31","750","1","1","152.2","0","152.2","2017-11-10","2017-11-10","","1","1");
INSERT INTO contas_receber VALUES("7366","202","748","1","1","364","0","364","2017-11-13","2017-12-13","","1","1");
INSERT INTO contas_receber VALUES("7367","202","748","2","1","364","0","364","2017-11-13","2018-01-13","","1","1");
INSERT INTO contas_receber VALUES("7368","33","752","1","1","2397.4","0","2397.4","2017-11-13","2017-11-14","","1","1");
INSERT INTO contas_receber VALUES("7380","253","760","1","1","636.1","0","636.1","2017-11-14","2017-11-15","","1","1");
INSERT INTO contas_receber VALUES("7381","25","749","1","1","446.88","0","446.88","2017-11-14","2017-12-14","","1","1");
INSERT INTO contas_receber VALUES("7382","25","749","2","1","446.88","0","446.88","2017-11-14","2017-12-29","","1","1");
INSERT INTO contas_receber VALUES("7383","25","749","3","1","446.89","0","446.89","2017-11-14","2018-01-14","","1","1");
INSERT INTO contas_receber VALUES("7385","83","746","1","0","159.48","0","159.48","2017-11-14","2017-12-14","","1","1");
INSERT INTO contas_receber VALUES("7412","193","642","1","1","63.05","0","63.05","2017-11-14","2017-11-12","","1","1");
INSERT INTO contas_receber VALUES("7413","206","736","1","1","106.35","0","106.35","2017-11-14","2017-11-02","","1","1");
INSERT INTO contas_receber VALUES("7414","43","738","1","1","291.27","0","291.27","2017-11-14","2017-12-10","","1","1");
INSERT INTO contas_receber VALUES("7415","43","738","2","1","291.27","0","291.27","2017-11-14","2017-12-25","","1","1");
INSERT INTO contas_receber VALUES("7416","43","738","3","1","291.26","0","291.26","2017-11-14","2018-01-10","","1","1");
INSERT INTO contas_receber VALUES("7453","31","756","1","1","238.93","0","238.93","2017-11-16","2017-12-17","","1","1");
INSERT INTO contas_receber VALUES("7454","31","756","2","1","238.93","0","238.93","2017-11-16","2018-01-02","","1","1");
INSERT INTO contas_receber VALUES("7455","31","756","3","1","238.94","0","238.94","2017-11-16","2018-01-17","","1","1");
INSERT INTO contas_receber VALUES("7474","8","744","1","1","408","0","408","2017-11-17","2017-12-17","","1","1");
INSERT INTO contas_receber VALUES("7475","8","744","2","1","408","0","408","2017-11-17","2018-01-02","","1","1");
INSERT INTO contas_receber VALUES("7476","8","744","3","1","408","0","408","2017-11-17","2018-01-17","","1","1");
INSERT INTO contas_receber VALUES("7477","220","753","1","1","3253.33","0","3253.33","2017-11-17","2017-12-17","","1","1");
INSERT INTO contas_receber VALUES("7478","220","753","2","1","3253.33","0","3253.33","2017-11-17","2018-01-02","","1","1");
INSERT INTO contas_receber VALUES("7479","220","753","3","1","3253.34","0","3253.34","2017-11-17","2018-01-17","","1","1");
INSERT INTO contas_receber VALUES("7518","46","762","2","1","249.5","0","249.5","2017-11-20","2018-01-20","","1","1");
INSERT INTO contas_receber VALUES("7519","46","762","1","1","249.5","0","249.5","2017-11-20","2017-12-20","","1","1");
INSERT INTO contas_receber VALUES("7520","252","757","1","1","523","0","523","2017-11-20","2017-12-17","","1","1");
INSERT INTO contas_receber VALUES("7521","252","757","3","1","523","0","523","2017-11-20","2018-01-21","","1","1");
INSERT INTO contas_receber VALUES("7522","252","757","2","1","523","0","523","2017-11-20","2018-01-06","","1","1");
INSERT INTO contas_receber VALUES("7523","41","759","1","1","697.08","0","697.08","2017-11-20","2017-12-22","","1","1");
INSERT INTO contas_receber VALUES("7524","41","759","2","1","697.08","0","697.08","2017-11-20","2018-01-07","","1","1");
INSERT INTO contas_receber VALUES("7525","41","759","3","1","697.08","0","697.08","2017-11-20","2018-01-22","","1","1");
INSERT INTO contas_receber VALUES("7526","41","759","4","1","697.08","0","697.08","2017-11-20","2018-02-07","","1","1");
INSERT INTO contas_receber VALUES("7527","41","759","5","1","697.08","0","697.08","2017-11-20","2018-03-22","","1","1");
INSERT INTO contas_receber VALUES("7528","69","761","1","1","530.9","0","530.9","2017-11-20","2017-12-07","","1","1");
INSERT INTO contas_receber VALUES("7529","69","761","2","1","530.9","0","530.9","2017-11-20","2017-12-07","","1","1");
INSERT INTO contas_receber VALUES("7546","22","765","1","1","1401.14","0","1401.14","2017-11-21","2017-12-23","","1","1");
INSERT INTO contas_receber VALUES("7547","22","765","2","1","1401.14","0","1401.14","2017-11-21","2017-12-07","","1","1");
INSERT INTO contas_receber VALUES("7548","22","765","3","1","1401.14","0","1401.14","2017-11-21","2018-01-23","","1","1");
INSERT INTO contas_receber VALUES("7555","98","719","1","1","1583","0","1583","2017-11-21","2017-12-01","","1","1");
INSERT INTO contas_receber VALUES("7595","255","766","1","1","1516.55","0","1516.55","2017-11-22","2017-11-24","","1","1");
INSERT INTO contas_receber VALUES("7628","180","767","1","1","122.4","0","122.4","2017-11-23","2017-12-24","","1","1");
INSERT INTO contas_receber VALUES("7629","43","769","1","1","287.2","0","287.2","2017-11-23","2017-12-24","","1","1");
INSERT INTO contas_receber VALUES("7630","43","769","2","1","287.2","0","287.2","2017-11-23","2018-01-24","","1","1");
INSERT INTO contas_receber VALUES("7631","31","779","1","1","274.5","0","274.5","2017-11-23","2017-12-27","","1","1");
INSERT INTO contas_receber VALUES("7632","31","779","2","1","274.5","0","274.5","2017-11-23","2018-01-27","","1","1");
INSERT INTO contas_receber VALUES("7633","174","771","1","1","315.85","0","315.85","2017-11-23","2017-12-27","","1","1");
INSERT INTO contas_receber VALUES("7634","174","771","2","1","315.85","0","315.85","2017-11-23","2018-01-27","","1","1");
INSERT INTO contas_receber VALUES("7659","256","772","1","1","250.05","0","250.05","2017-11-24","2017-12-28","","1","1");
INSERT INTO contas_receber VALUES("7660","256","772","2","1","250.05","0","250.05","2017-11-24","2018-01-28","","1","1");
INSERT INTO contas_receber VALUES("7661","60","768","1","1","622","0","622","2017-11-24","2017-12-28","","1","1");
INSERT INTO contas_receber VALUES("7662","60","768","2","1","622","0","622","2017-11-24","2018-01-13","","1","1");
INSERT INTO contas_receber VALUES("7663","60","768","3","1","622","0","622","2017-11-24","2018-01-28","","1","1");
INSERT INTO contas_receber VALUES("7664","101","770","1","1","840.83","0","840.83","2017-11-24","2017-12-28","","1","1");
INSERT INTO contas_receber VALUES("7665","101","770","2","1","840.83","0","840.83","2017-11-24","2018-01-13","","1","1");
INSERT INTO contas_receber VALUES("7666","101","770","3","1","840.84","0","840.84","2017-11-24","2018-01-28","","1","1");
INSERT INTO contas_receber VALUES("7687","21","776","1","1","1599.8","0","1599.8","2017-11-27","2017-12-20","","1","1");
INSERT INTO contas_receber VALUES("7688","21","776","5","1","1599.8","0","1599.8","2017-11-27","2018-02-01","","1","1");
INSERT INTO contas_receber VALUES("7689","21","776","2","1","1599.8","0","1599.8","2017-11-27","2018-01-01","","1","1");
INSERT INTO contas_receber VALUES("7690","21","776","3","1","1599.8","0","1599.8","2017-11-27","2018-01-11","","1","1");
INSERT INTO contas_receber VALUES("7691","21","776","4","1","1599.8","0","1599.8","2017-11-27","2018-01-21","","1","1");
INSERT INTO contas_receber VALUES("7701","257","774","1","1","85.64","0","85.64","2017-11-27","2017-11-23","","1","1");
INSERT INTO contas_receber VALUES("7704","3","754","1","1","65.48","0","65.48","2017-11-27","2017-11-11","","1","1");
INSERT INTO contas_receber VALUES("7705","3","789","1","1","45.55","0","45.55","2017-11-27","2017-11-29","","1","1");
INSERT INTO contas_receber VALUES("7706","260","783","1","1","148.27","0","148.27","2017-11-27","2017-11-29","","1","1");
INSERT INTO contas_receber VALUES("7709","4","781","1","1","905.33","0","905.33","2017-11-28","2018-01-04","","1","1");
INSERT INTO contas_receber VALUES("7710","4","781","2","1","905.33","0","905.33","2017-11-28","2018-01-16","","1","1");
INSERT INTO contas_receber VALUES("7711","4","781","3","1","905.34","0","905.34","2017-11-28","2018-02-01","","1","1");
INSERT INTO contas_receber VALUES("7712","254","763","1","1","270","0","270","2017-11-28","2017-11-16","","1","1");
INSERT INTO contas_receber VALUES("7721","83","793","1","1","154.24","0","154.24","2017-11-29","2018-01-05","","1","1");
INSERT INTO contas_receber VALUES("7722","47","785","1","1","678.61","0","678.61","2017-11-29","2018-01-04","","1","1");
INSERT INTO contas_receber VALUES("7723","47","785","2","1","678.61","0","678.61","2017-11-29","2018-01-19","","1","1");
INSERT INTO contas_receber VALUES("7724","47","785","3","1","678.6","0","678.6","2017-11-29","2018-02-04","","1","1");
INSERT INTO contas_receber VALUES("7725","261","788","1","1","334.75","0","334.75","2017-11-29","2018-01-04","","1","1");
INSERT INTO contas_receber VALUES("7726","261","788","2","1","334.75","0","334.75","2017-11-29","2018-02-04","","1","1");
INSERT INTO contas_receber VALUES("7729","154","791","1","1","161.25","0","161.25","2017-11-29","2017-12-04","","1","1");
INSERT INTO contas_receber VALUES("7730","154","791","2","1","161.25","0","161.25","2017-11-29","2018-01-04","","1","1");
INSERT INTO contas_receber VALUES("7731","42","782","1","1","743.33","0","743.33","2017-11-29","2018-01-05","","1","1");
INSERT INTO contas_receber VALUES("7732","42","782","2","1","743.33","0","743.33","2017-11-29","2018-01-20","","1","1");
INSERT INTO contas_receber VALUES("7733","42","782","3","1","743.34","0","743.34","2017-11-29","2018-02-05","","1","1");
INSERT INTO contas_receber VALUES("7734","65","784","2","1","744.53","0","744.53","2017-11-29","2018-01-20","","1","1");
INSERT INTO contas_receber VALUES("7735","65","784","1","1","744.53","0","744.53","2017-11-29","2018-01-05","","1","1");
INSERT INTO contas_receber VALUES("7736","65","784","3","1","744.54","0","744.54","2017-11-29","2018-02-05","","1","1");
INSERT INTO contas_receber VALUES("7737","30","786","1","1","569.05","0","569.05","2017-11-29","2018-01-06","","1","1");
INSERT INTO contas_receber VALUES("7738","30","786","2","1","569.05","0","569.05","2017-11-29","2018-01-16","","1","1");
INSERT INTO contas_receber VALUES("7739","30","786","3","1","569.05","0","569.05","2017-11-29","2018-01-26","","1","1");
INSERT INTO contas_receber VALUES("7740","30","786","4","1","569.05","0","569.05","2017-11-29","2018-02-06","","1","1");
INSERT INTO contas_receber VALUES("7741","44","764","2","1","921.05","921.05","0","2017-11-29","2018-01-09","","0","0");
INSERT INTO contas_receber VALUES("7742","44","764","1","1","921.05","921.05","0","2017-11-29","2017-12-24","","0","0");
INSERT INTO contas_receber VALUES("7743","44","764","3","1","921.05","921.05","0","2017-11-29","2018-01-24","","0","0");
INSERT INTO contas_receber VALUES("7744","9","773","1","1","505.9","505.9","0","2017-11-29","2017-12-30","","0","0");
INSERT INTO contas_receber VALUES("7745","9","773","2","1","505.9","505.9","0","2017-11-29","2018-01-14","","0","0");
INSERT INTO contas_receber VALUES("7746","9","773","3","1","505.9","505.9","0","2017-11-29","2018-01-30","","0","0");
INSERT INTO contas_receber VALUES("7756","258","775","1","1","41.82","0","41.82","2017-11-29","2017-11-23","","1","1");
INSERT INTO contas_receber VALUES("7757","259","777","1","1","301.17","0","301.17","2017-11-29","2017-11-24","","1","1");
INSERT INTO contas_receber VALUES("7758","190","758","1","1","80.01","0","80.01","2017-11-29","2017-11-12","","1","1");
INSERT INTO contas_receber VALUES("7759","239","743","1","1","407.93","0","407.93","2017-11-29","2017-12-13","","1","1");
INSERT INTO contas_receber VALUES("7760","239","743","2","1","407.93","0","407.93","2017-11-29","2017-12-28","","1","1");
INSERT INTO contas_receber VALUES("7761","239","743","3","1","407.94","0","407.94","2017-11-29","2018-01-13","","1","1");
INSERT INTO contas_receber VALUES("7768","184","790","1","1","85.12","0","85.12","2017-11-29","2017-11-30","","1","1");
INSERT INTO contas_receber VALUES("7769","24","787","1","1","946.6","0","946.6","2017-11-30","2017-12-22","","1","1");
INSERT INTO contas_receber VALUES("7770","24","787","2","1","946.6","0","946.6","2017-11-30","2017-12-22","","1","1");
INSERT INTO contas_receber VALUES("7787","74","780","2","1","1434.93","0","1434.93","2017-12-01","2018-02-08","","1","1");
INSERT INTO contas_receber VALUES("7788","74","780","1","1","1434.93","0","1434.93","2017-12-01","2018-01-08","","1","1");
INSERT INTO contas_receber VALUES("7789","74","780","3","1","1434.94","0","1434.94","2017-12-01","2018-03-08","","1","1");
INSERT INTO contas_receber VALUES("7804","267","804","1","1","200.03","0","200.03","2017-12-04","2017-12-06","","1","1");
INSERT INTO contas_receber VALUES("7823","264","794","1","1","385.4","0","385.4","2017-12-05","2017-11-30","","1","1");
INSERT INTO contas_receber VALUES("7824","31","795","1","1","241.1","0","241.1","2017-12-05","2018-01-06","","1","1");
INSERT INTO contas_receber VALUES("7825","31","795","2","1","241.1","0","241.1","2017-12-05","2018-02-06","","1","1");
INSERT INTO contas_receber VALUES("7826","5","799","1","1","392.07","0","392.07","2017-12-05","2018-01-07","","1","1");
INSERT INTO contas_receber VALUES("7827","5","799","2","1","392.07","0","392.07","2017-12-05","2018-01-22","","1","1");
INSERT INTO contas_receber VALUES("7828","5","799","3","1","392.06","0","392.06","2017-12-05","2018-02-07","","1","1");
INSERT INTO contas_receber VALUES("7829","4","797","1","1","1016.67","1016.67","0","2017-12-05","2018-01-08","","0","0");
INSERT INTO contas_receber VALUES("7830","4","797","2","1","1016.67","1016.67","0","2017-12-05","2018-01-23","","0","0");
INSERT INTO contas_receber VALUES("7831","4","797","3","1","1016.66","1016.66","0","2017-12-05","2018-02-08","","0","0");
INSERT INTO contas_receber VALUES("7834","36","803","2","1","1166.83","0","1166.83","2017-12-05","2018-01-27","","1","1");
INSERT INTO contas_receber VALUES("7835","36","803","1","1","1166.83","0","1166.83","2017-12-05","2018-01-12","","1","1");
INSERT INTO contas_receber VALUES("7836","36","803","3","1","1166.84","0","1166.84","2017-12-05","2018-02-12","","1","1");
INSERT INTO contas_receber VALUES("7837","70","796","1","1","615.8","0","615.8","2017-12-05","2017-12-18","","1","1");
INSERT INTO contas_receber VALUES("7838","70","796","2","1","615.8","0","615.8","2017-12-05","2017-12-18","","1","1");
INSERT INTO contas_receber VALUES("7873","185","802","1","1","52.89","0","52.89","2017-12-06","2017-12-06","","1","1");
INSERT INTO contas_receber VALUES("7874","265","801","1","1","603.6","0","603.6","2017-12-06","2017-12-21","","1","1");
INSERT INTO contas_receber VALUES("7875","266","805","1","1","487","0","487","2017-12-06","2018-01-12","","1","1");
INSERT INTO contas_receber VALUES("7876","19","807","1","1","334.85","0","334.85","2017-12-06","2018-01-12","","1","1");
INSERT INTO contas_receber VALUES("7877","19","807","2","1","334.85","0","334.85","2017-12-06","2018-02-12","","1","1");
INSERT INTO contas_receber VALUES("7878","211","812","1","1","411.23","0","411.23","2017-12-07","2018-01-11","","1","1");
INSERT INTO contas_receber VALUES("7879","211","812","2","1","411.23","0","411.23","2017-12-07","2018-01-26","","1","1");
INSERT INTO contas_receber VALUES("7880","211","812","3","1","411.24","0","411.24","2017-12-07","2018-02-11","","1","1");
INSERT INTO contas_receber VALUES("7881","46","810","1","1","263.75","0","263.75","2017-12-07","2018-01-11","","1","1");
INSERT INTO contas_receber VALUES("7890","245","742","1","1","96.33","0","96.33","2017-12-07","2017-11-10","","1","1");
INSERT INTO contas_receber VALUES("7891","262","792","1","1","95.5","0","95.5","2017-12-07","2017-12-01","","1","1");
INSERT INTO contas_receber VALUES("7892","193","740","1","1","57.3","0","57.3","2017-12-07","2017-11-03","","1","1");
INSERT INTO contas_receber VALUES("7893","224","755","1","1","124","0","124","2017-12-07","2017-11-11","","1","1");
INSERT INTO contas_receber VALUES("7894","260","798","1","1","85","0","85","2017-12-07","2017-12-02","","1","1");
INSERT INTO contas_receber VALUES("7895","3","800","1","1","131.6","0","131.6","2017-12-07","2017-12-03","","1","1");
INSERT INTO contas_receber VALUES("7897","268","806","1","1","37.37","37.37","0","2017-12-07","2017-12-06","","0","0");
INSERT INTO contas_receber VALUES("7898","83","809","1","1","38.42","0","38.42","2017-12-07","2017-12-07","","1","1");
INSERT INTO contas_receber VALUES("7933","174","808","1","1","610","0","610","2017-12-13","2018-01-13","","1","1");
INSERT INTO contas_receber VALUES("7934","174","808","2","1","610","0","610","2017-12-13","2018-02-13","","1","1");
INSERT INTO contas_receber VALUES("7941","202","811","2","1","736","0","736","2017-12-14","2017-12-27","","1","1");
INSERT INTO contas_receber VALUES("7942","202","811","1","1","736","0","736","2017-12-14","2017-12-27","","1","1");
INSERT INTO contas_receber VALUES("7943","84","816","2","1","943.35","0","943.35","2017-12-14","2018-01-30","","1","1");
INSERT INTO contas_receber VALUES("7944","84","816","3","1","943.35","0","943.35","2017-12-14","2018-02-15","","1","1");
INSERT INTO contas_receber VALUES("7945","84","816","1","1","943.35","0","943.35","2017-12-14","2018-01-15","","1","1");
INSERT INTO contas_receber VALUES("7946","270","814","1","1","722.45","0","722.45","2017-12-14","2017-12-21","","1","1");
INSERT INTO contas_receber VALUES("7947","270","814","2","1","722.45","0","722.45","2017-12-14","2017-12-21","","1","1");
INSERT INTO contas_receber VALUES("7954","220","822","1","1","1449.33","0","1449.33","2017-12-15","2018-01-19","","1","1");
INSERT INTO contas_receber VALUES("7955","220","822","3","1","1449.34","0","1449.34","2017-12-15","2018-02-19","","1","1");
INSERT INTO contas_receber VALUES("7956","220","822","2","1","1449.33","0","1449.33","2017-12-15","2018-02-03","","1","1");
INSERT INTO contas_receber VALUES("7957","31","825","1","1","228.24","0","228.24","2017-12-15","2018-01-15","","1","1");
INSERT INTO contas_receber VALUES("7958","31","825","2","1","228.23","0","228.23","2017-12-15","2018-02-15","","1","1");
INSERT INTO contas_receber VALUES("7959","272","823","1","1","113.6","0","113.6","2017-12-15","2018-01-15","","1","1");
INSERT INTO contas_receber VALUES("7960","272","823","2","1","113.6","0","113.6","2017-12-15","2018-02-15","","1","1");
INSERT INTO contas_receber VALUES("7961","68","820","2","1","1359.9","0","1359.9","2017-12-18","2017-12-21","","1","1");
INSERT INTO contas_receber VALUES("7962","68","820","1","1","1359.9","0","1359.9","2017-12-18","2017-12-15","","1","1");
INSERT INTO contas_receber VALUES("7966","31","827","1","1","158.5","158.5","0","2017-12-20","2017-12-21","","0","0");
INSERT INTO contas_receber VALUES("7967","36","818","1","1","666.4","0","666.4","2017-12-21","2018-02-22","","1","1");
INSERT INTO contas_receber VALUES("7968","271","819","1","1","127","0","127","2017-12-21","2017-12-13","","1","1");
INSERT INTO contas_receber VALUES("7969","264","826","1","1","295.5","0","295.5","2017-12-21","2017-12-21","","1","1");
INSERT INTO contas_receber VALUES("7979","31","829","1","1","915","915","0","2018-01-02","2018-01-03","","0","0");
INSERT INTO contas_receber VALUES("8030","31","835","1","1","610","0","610","2018-01-08","2018-02-05","","1","1");
INSERT INTO contas_receber VALUES("8031","31","835","2","1","610","0","610","2018-01-08","2018-02-20","","1","1");
INSERT INTO contas_receber VALUES("8032","31","835","3","1","610","0","610","2018-01-08","2018-03-05","","1","1");
INSERT INTO contas_receber VALUES("8033","275","833","1","1","70.4","0","70.4","2018-01-08","2018-01-06","","1","1");
INSERT INTO contas_receber VALUES("8034","4","828","1","1","1095.67","0","1095.67","2018-01-08","2018-01-08","","1","1");
INSERT INTO contas_receber VALUES("8035","4","828","3","1","1095.66","0","1095.66","2018-01-08","2018-03-08","","1","1");
INSERT INTO contas_receber VALUES("8036","4","828","2","1","1095.67","0","1095.67","2018-01-08","2018-02-23","","1","1");
INSERT INTO contas_receber VALUES("8049","8","838","3","1","476","0","476","2018-01-09","2018-03-09","","1","1");
INSERT INTO contas_receber VALUES("8050","8","838","2","1","476","0","476","2018-01-09","2018-02-24","","1","1");
INSERT INTO contas_receber VALUES("8051","8","838","1","1","476","0","476","2018-01-09","2018-02-09","","1","1");
INSERT INTO contas_receber VALUES("8052","202","830","1","1","591.2","0","591.2","2018-01-09","2018-01-16","","1","1");
INSERT INTO contas_receber VALUES("8053","202","830","2","1","591.2","0","591.2","2018-01-09","2018-01-16","","1","1");
INSERT INTO contas_receber VALUES("8054","266","831","1","1","70","0","70","2018-01-09","2018-01-05","","1","1");
INSERT INTO contas_receber VALUES("8055","266","831","2","1","222.2","0","222.2","2018-01-09","2018-02-05","","1","1");
INSERT INTO contas_receber VALUES("8056","274","832","1","1","188.11","0","188.11","2018-01-09","2018-01-05","","1","1");
INSERT INTO contas_receber VALUES("8057","3","821","1","1","141.07","0","141.07","2018-01-09","2017-12-15","","1","1");
INSERT INTO contas_receber VALUES("8058","195","834","1","1","196.5","0","196.5","2018-01-09","2018-02-05","","1","1");
INSERT INTO contas_receber VALUES("8071","276","836","2","1","54.08","0","54.08","2018-01-10","2018-02-05","","1","1");
INSERT INTO contas_receber VALUES("8072","276","836","1","1","70","0","70","2018-01-10","2018-01-07","","1","1");
INSERT INTO contas_receber VALUES("8079","70","839","1","1","613.66","613.66","0","2018-01-10","2018-01-22","","0","0");
INSERT INTO contas_receber VALUES("8080","70","839","2","1","613.66","613.66","0","2018-01-10","2018-01-22","","0","0");
INSERT INTO contas_receber VALUES("8089","279","843","1","1","1233","0","1233","2018-01-10","2018-01-15","","1","1");
INSERT INTO contas_receber VALUES("8105","278","842","1","1","395","0","395","2018-01-11","2018-02-11","","1","1");
INSERT INTO contas_receber VALUES("8106","278","842","2","1","395","0","395","2018-01-11","2018-02-26","","1","1");
INSERT INTO contas_receber VALUES("8107","278","842","3","1","395","0","395","2018-01-11","2018-03-11","","1","1");
INSERT INTO contas_receber VALUES("8108","192","841","2","1","556.7","0","556.7","2018-01-11","2018-02-27","","1","1");
INSERT INTO contas_receber VALUES("8109","192","841","3","1","556.7","0","556.7","2018-01-11","2018-03-12","","1","1");
INSERT INTO contas_receber VALUES("8110","192","841","1","1","556.7","0","556.7","2018-01-11","2018-02-12","","1","1");
INSERT INTO contas_receber VALUES("8138","277","837","1","1","539.1","0","539.1","2018-01-12","2018-01-08","","1","1");
INSERT INTO contas_receber VALUES("8143","220","844","3","1","1566.8","0","1566.8","2018-01-15","2018-03-15","","1","1");
INSERT INTO contas_receber VALUES("8144","220","844","2","1","1566.8","0","1566.8","2018-01-15","2018-03-02","","1","1");
INSERT INTO contas_receber VALUES("8145","220","844","1","1","1566.8","0","1566.8","2018-01-15","2018-02-15","","1","1");
INSERT INTO contas_receber VALUES("8160","212","845","1","1","847.5","847.5","0","2018-01-15","2018-02-16","","0","0");
INSERT INTO contas_receber VALUES("8161","212","845","2","1","847.5","847.5","0","2018-01-15","2018-03-03","","0","0");
INSERT INTO contas_receber VALUES("8162","212","845","3","1","847.49","847.49","0","2018-01-15","2018-03-16","","0","0");
INSERT INTO contas_receber VALUES("8169","32","846","1","1","83.51","0","83.51","2018-01-15","2018-02-12","","1","1");
INSERT INTO contas_receber VALUES("8219","5","847","1","1","300.83","0","300.83","2018-01-16","2018-02-16","","1","1");
INSERT INTO contas_receber VALUES("8220","5","847","2","1","300.83","0","300.83","2018-01-16","2018-03-03","","1","1");
INSERT INTO contas_receber VALUES("8221","5","847","3","1","300.84","0","300.84","2018-01-16","2018-03-16","","1","1");
INSERT INTO contas_receber VALUES("8222","25","848","1","1","581","0","581","2018-01-17","2018-02-17","","1","1");
INSERT INTO contas_receber VALUES("8223","25","848","3","1","581","0","581","2018-01-17","2018-03-17","","1","1");
INSERT INTO contas_receber VALUES("8224","25","848","2","1","581","0","581","2018-01-17","2018-03-04","","1","1");
INSERT INTO contas_receber VALUES("8225","25","848","3","1","581","581","0","2018-01-17","2018-03-17","","0","0");
INSERT INTO contas_receber VALUES("8226","172","851","1","1","117.3","0","117.3","2018-01-17","2018-02-17","","1","1");
INSERT INTO contas_receber VALUES("8242","62","854","1","1","241.2","241.2","0","2018-01-17","2018-02-19","","0","0");
INSERT INTO contas_receber VALUES("8243","62","854","2","1","241.2","241.2","0","2018-01-17","2018-03-19","","0","0");
INSERT INTO contas_receber VALUES("8264","28","840","1","1","426.15","0","426.15","2018-01-17","2018-01-11","","1","1");
INSERT INTO contas_receber VALUES("8265","19","856","1","1","301.65","0","301.65","2018-01-18","2018-02-19","","1","1");
INSERT INTO contas_receber VALUES("8266","19","856","2","1","301.65","0","301.65","2018-01-18","2018-03-19","","1","1");
INSERT INTO contas_receber VALUES("8298","52","778","1","1","2825","2825","0","2018-01-19","2017-11-24","","0","0");
INSERT INTO contas_receber VALUES("8299","52","778","2","1","2825","2825","0","2018-01-19","2017-12-25","","0","0");
INSERT INTO contas_receber VALUES("8320","220","852","1","1","1654.83","0","1654.83","2018-01-22","2018-02-19","","1","1");
INSERT INTO contas_receber VALUES("8321","220","852","2","1","1654.83","0","1654.83","2018-01-22","2018-03-06","","1","1");
INSERT INTO contas_receber VALUES("8322","220","852","3","1","1654.84","0","1654.84","2018-01-22","2018-03-19","","1","1");
INSERT INTO contas_receber VALUES("8329","283","862","1","1","72","0","72","2018-01-22","2018-01-19","","1","1");
INSERT INTO contas_receber VALUES("8330","281","850","1","1","20","0","20","2018-01-22","2018-01-17","","1","1");
INSERT INTO contas_receber VALUES("8331","280","849","1","1","601.2","0","601.2","2018-01-22","2018-01-17","","1","1");
INSERT INTO contas_receber VALUES("8336","31","853","1","1","714.23","0","714.23","2018-01-23","2018-02-22","","1","1");
INSERT INTO contas_receber VALUES("8337","31","853","2","1","714.23","0","714.23","2018-01-23","2018-03-09","","1","1");
INSERT INTO contas_receber VALUES("8338","31","853","3","1","714.24","0","714.24","2018-01-23","2018-03-22","","1","1");
INSERT INTO contas_receber VALUES("8339","31","863","1","1","201.3","0","201.3","2018-01-23","2018-03-15","","1","1");
INSERT INTO contas_receber VALUES("8340","31","868","1","1","162.1","0","162.1","2018-01-23","2018-02-23","","1","1");
INSERT INTO contas_receber VALUES("8343","220","861","1","1","347.7","347.7","0","2018-01-23","2018-02-23","","0","0");
INSERT INTO contas_receber VALUES("8344","220","864","1","1","352.23","0","352.23","2018-01-23","2018-02-23","","1","1");
INSERT INTO contas_receber VALUES("8345","220","873","1","1","52.1","0","52.1","2018-01-23","2018-02-23","","1","1");
INSERT INTO contas_receber VALUES("8346","282","860","2","1","205.4","0","205.4","2018-01-23","2018-03-22","","1","1");
INSERT INTO contas_receber VALUES("8347","282","860","1","1","205.4","0","205.4","2018-01-23","2018-02-22","","1","1");
INSERT INTO contas_receber VALUES("8348","264","866","1","1","173","0","173","2018-01-23","2018-01-23","","1","1");
INSERT INTO contas_receber VALUES("8349","245","815","1","1","38.2","0","38.2","2018-01-23","2017-12-09","","1","1");
INSERT INTO contas_receber VALUES("8388","243","855","1","1","635.14","0","635.14","2018-01-24","2018-02-23","","1","1");
INSERT INTO contas_receber VALUES("8389","243","855","2","1","635.14","0","635.14","2018-01-24","2018-03-10","","1","1");
INSERT INTO contas_receber VALUES("8390","243","855","3","1","635.14","0","635.14","2018-01-24","2018-03-23","","1","1");
INSERT INTO contas_receber VALUES("8391","47","857","1","1","846.87","0","846.87","2018-01-24","2018-02-23","","1","1");
INSERT INTO contas_receber VALUES("8392","47","857","2","1","846.87","0","846.87","2018-01-24","2018-03-10","","1","1");
INSERT INTO contas_receber VALUES("8393","47","857","3","1","846.86","0","846.86","2018-01-24","2018-03-23","","1","1");
INSERT INTO contas_receber VALUES("8394","161","858","1","1","497.3","0","497.3","2018-01-24","2018-02-24","","1","1");
INSERT INTO contas_receber VALUES("8395","161","858","2","1","497.3","0","497.3","2018-01-24","2018-03-11","","1","1");
INSERT INTO contas_receber VALUES("8396","161","858","3","1","497.3","0","497.3","2018-01-24","2018-03-24","","1","1");
INSERT INTO contas_receber VALUES("8407","221","865","1","1","1046.33","0","1046.33","2018-01-25","2018-02-24","","1","1");
INSERT INTO contas_receber VALUES("8408","221","865","3","1","1046.34","0","1046.34","2018-01-25","2018-03-24","","1","1");
INSERT INTO contas_receber VALUES("8409","221","865","2","1","1046.33","0","1046.33","2018-01-25","2018-03-12","","1","1");
INSERT INTO contas_receber VALUES("8410","98","869","2","1","676.67","0","676.67","2018-01-25","2018-03-25","","1","1");
INSERT INTO contas_receber VALUES("8411","98","869","1","1","676.67","0","676.67","2018-01-25","2018-02-25","","1","1");
INSERT INTO contas_receber VALUES("8412","98","869","3","1","676.66","0","676.66","2018-01-25","2018-04-25","","1","1");
INSERT INTO contas_receber VALUES("8424","269","813","1","1","75.5","0","75.5","2018-01-25","2017-12-07","","1","1");
INSERT INTO contas_receber VALUES("8433","94","870","1","1","245.7","0","245.7","2018-01-26","2018-02-26","","1","1");
INSERT INTO contas_receber VALUES("8434","94","870","2","1","245.7","0","245.7","2018-01-26","2018-03-26","","1","1");
INSERT INTO contas_receber VALUES("8435","79","867","1","1","514.13","0","514.13","2018-01-26","2018-02-26","","1","1");
INSERT INTO contas_receber VALUES("8436","79","867","2","1","514.13","0","514.13","2018-01-26","2018-03-13","","1","1");
INSERT INTO contas_receber VALUES("8437","79","867","3","1","514.13","0","514.13","2018-01-26","2018-03-26","","1","1");
INSERT INTO contas_receber VALUES("8438","79","867","4","1","514.11","0","514.11","2018-01-26","2018-04-07","","1","1");
INSERT INTO contas_receber VALUES("8445","115","859","2","1","445.46","445.46","0","2018-01-26","2018-03-12","","0","0");
INSERT INTO contas_receber VALUES("8446","115","859","3","1","445.47","445.47","0","2018-01-26","2018-03-24","","0","0");
INSERT INTO contas_receber VALUES("8447","115","859","1","1","445.46","445.46","0","2018-01-26","2018-02-24","","0","0");
INSERT INTO contas_receber VALUES("8452","115","884","1","1","220","220","0","2018-01-26","2018-01-27","","0","0");
INSERT INTO contas_receber VALUES("8453","115","884","2","1","220","220","0","2018-01-26","2018-02-27","","0","0");
INSERT INTO contas_receber VALUES("8504","129","874","1","1","457.33","0","457.33","2018-01-29","2018-03-01","","1","1");
INSERT INTO contas_receber VALUES("8505","129","874","3","1","457.34","0","457.34","2018-01-29","2018-04-01","","1","1");
INSERT INTO contas_receber VALUES("8506","129","874","2","1","457.33","0","457.33","2018-01-29","2018-03-16","","1","1");
INSERT INTO contas_receber VALUES("8507","220","877","1","1","1270.73","0","1270.73","2018-01-29","2018-03-02","","1","1");
INSERT INTO contas_receber VALUES("8508","220","877","3","1","1270.74","0","1270.74","2018-01-29","2018-04-02","","1","1");
INSERT INTO contas_receber VALUES("8509","220","877","2","1","1270.73","0","1270.73","2018-01-29","2018-03-13","","1","1");
INSERT INTO contas_receber VALUES("8512","27","817","1","1","131.95","0","131.95","2018-01-29","2017-12-10","","1","1");
INSERT INTO contas_receber VALUES("8513","238","872","1","1","164.95","0","164.95","2018-01-29","2018-01-24","","1","1");
INSERT INTO contas_receber VALUES("8544","31","876","1","1","305","0","305","2018-01-29","2018-03-01","","1","1");
INSERT INTO contas_receber VALUES("8545","31","876","2","1","305","0","305","2018-01-29","2018-03-16","","1","1");
INSERT INTO contas_receber VALUES("8546","31","876","3","1","305","0","305","2018-01-29","2018-04-01","","1","1");
INSERT INTO contas_receber VALUES("8547","31","876","4","1","305","0","305","2018-01-29","2018-04-16","","1","1");
INSERT INTO contas_receber VALUES("8554","202","880","1","1","335.82","0","335.82","2018-01-30","2018-02-12","","1","1");
INSERT INTO contas_receber VALUES("8555","202","880","2","1","335.82","0","335.82","2018-01-30","2018-02-12","","1","1");
INSERT INTO contas_receber VALUES("8556","202","880","3","1","720.76","0","720.76","2018-01-30","2018-02-12","","1","1");
INSERT INTO contas_receber VALUES("8567","284","879","1","1","491.4","491.4","0","2018-01-30","2018-03-02","","0","0");
INSERT INTO contas_receber VALUES("8568","284","879","2","1","491.4","491.4","0","2018-01-30","2018-03-19","","0","0");
INSERT INTO contas_receber VALUES("8595","229","875","1","1","401.87","401.87","0","2018-01-31","2018-03-02","","0","0");
INSERT INTO contas_receber VALUES("8596","229","875","2","1","401.87","401.87","0","2018-01-31","2018-03-18","","0","0");
INSERT INTO contas_receber VALUES("8597","229","875","3","1","401.86","401.86","0","2018-01-31","2018-04-02","","0","0");
INSERT INTO contas_receber VALUES("8598","44","878","1","1","726.43","0","726.43","2018-01-31","2018-03-02","","1","1");
INSERT INTO contas_receber VALUES("8599","44","878","2","1","726.43","0","726.43","2018-01-31","2018-03-18","","1","1");
INSERT INTO contas_receber VALUES("8600","44","878","3","1","726.44","0","726.44","2018-01-31","2018-04-02","","1","1");
INSERT INTO contas_receber VALUES("8610","285","893","1","1","116.1","116.1","0","2018-01-31","2018-02-01","","0","0");
INSERT INTO contas_receber VALUES("8620","42","894","3","1","1131.3","1131.3","0","2018-01-31","2018-04-03","","0","0");
INSERT INTO contas_receber VALUES("8621","42","894","2","1","1131.3","1131.3","0","2018-01-31","2018-03-03","","0","0");
INSERT INTO contas_receber VALUES("8622","42","894","1","1","1131.3","1131.3","0","2018-01-31","2018-01-31","","0","0");
INSERT INTO contas_receber VALUES("8629","42","895","2","1","1131.3","1131.3","0","2018-01-31","2018-03-03","","0","0");
INSERT INTO contas_receber VALUES("8630","42","895","1","1","1131.3","1131.3","0","2018-01-31","2018-01-31","","0","0");
INSERT INTO contas_receber VALUES("8631","42","895","3","1","1131.3","1131.3","0","2018-01-31","2018-04-03","","0","0");
INSERT INTO contas_receber VALUES("8647","35","871","1","1","147.15","0","147.15","2018-02-01","2018-03-02","","1","1");
INSERT INTO contas_receber VALUES("8648","35","871","2","1","147.15","0","147.15","2018-02-01","2018-03-30","","1","1");
INSERT INTO contas_receber VALUES("8681","220","885","1","1","146.67","0","146.67","2018-02-01","2018-03-02","","1","1");
INSERT INTO contas_receber VALUES("8682","220","885","2","1","146.67","0","146.67","2018-02-01","2018-03-18","","1","1");
INSERT INTO contas_receber VALUES("8683","220","885","3","1","146.66","0","146.66","2018-02-01","2018-04-02","","1","1");
INSERT INTO contas_receber VALUES("8684","220","892","1","1","231.5","0","231.5","2018-02-01","2018-03-02","","1","1");
INSERT INTO contas_receber VALUES("8685","220","892","3","1","231.5","0","231.5","2018-02-01","2018-04-02","","1","1");
INSERT INTO contas_receber VALUES("8686","220","892","2","1","231.5","0","231.5","2018-02-01","2018-03-18","","1","1");
INSERT INTO contas_receber VALUES("8687","31","881","2","1","411.78","0","411.78","2018-02-01","2018-03-16","","1","1");
INSERT INTO contas_receber VALUES("8688","31","881","3","1","411.78","0","411.78","2018-02-01","2018-04-01","","1","1");
INSERT INTO contas_receber VALUES("8689","31","881","1","1","411.78","0","411.78","2018-02-01","2018-03-01","","1","1");
INSERT INTO contas_receber VALUES("8690","31","881","4","1","305.21","0","305.21","2018-02-01","2018-05-16","","1","1");
INSERT INTO contas_receber VALUES("8691","147","882","1","1","2184","0","2184","2018-02-01","2018-02-25","","1","1");
INSERT INTO contas_receber VALUES("8692","96","883","1","1","154","0","154","2018-02-01","2018-01-28","","1","1");
INSERT INTO contas_receber VALUES("8694","28","888","1","1","253.51","0","253.51","2018-02-01","2018-01-31","","1","1");
INSERT INTO contas_receber VALUES("8695","89","899","1","1","49.18","0","49.18","2018-02-01","2018-02-03","","1","1");
INSERT INTO contas_receber VALUES("8716","174","891","2","1","634.5","0","634.5","2018-02-02","2018-04-02","","1","1");
INSERT INTO contas_receber VALUES("8717","174","891","1","1","634.5","0","634.5","2018-02-02","2018-03-02","","1","1");
INSERT INTO contas_receber VALUES("8720","23","886","2","1","469.5","0","469.5","2018-02-03","2018-03-20","","1","1");
INSERT INTO contas_receber VALUES("8721","23","886","1","1","469.5","0","469.5","2018-02-03","2018-03-05","","1","1");
INSERT INTO contas_receber VALUES("8722","23","886","3","1","469.5","0","469.5","2018-02-03","2018-04-05","","1","1");
INSERT INTO contas_receber VALUES("8723","98","889","1","1","957.83","0","957.83","2018-02-05","2018-03-06","","1","1");
INSERT INTO contas_receber VALUES("8724","98","889","2","1","957.83","0","957.83","2018-02-05","2018-04-06","","1","1");
INSERT INTO contas_receber VALUES("8725","98","889","3","1","957.84","0","957.84","2018-02-05","2018-05-06","","1","1");
INSERT INTO contas_receber VALUES("8726","101","887","2","1","1523.05","0","1523.05","2018-02-05","2018-03-22","","1","1");
INSERT INTO contas_receber VALUES("8727","101","887","3","1","1523.04","0","1523.04","2018-02-05","2018-04-07","","1","1");
INSERT INTO contas_receber VALUES("8728","101","887","1","1","1523.05","0","1523.05","2018-02-05","2018-03-07","","1","1");
INSERT INTO contas_receber VALUES("8770","4","890","1","1","424.33","0","424.33","2018-02-06","2018-03-06","","1","1");
INSERT INTO contas_receber VALUES("8771","4","890","2","1","424.33","0","424.33","2018-02-06","2018-03-21","","1","1");
INSERT INTO contas_receber VALUES("8772","4","890","3","1","424.34","0","424.34","2018-02-06","2018-04-06","","1","1");
INSERT INTO contas_receber VALUES("8791","3","897","1","1","85.77","0","85.77","2018-02-06","2018-02-02","","1","1");
INSERT INTO contas_receber VALUES("8792","54","901","1","1","184.72","0","184.72","2018-02-06","2018-02-05","","1","1");
INSERT INTO contas_receber VALUES("8796","42","896","2","1","1131.3","0","1131.3","2018-02-07","2018-03-23","","1","1");
INSERT INTO contas_receber VALUES("8797","42","896","1","1","1131.3","0","1131.3","2018-02-07","2018-03-08","","1","1");
INSERT INTO contas_receber VALUES("8798","42","896","3","1","1131.3","0","1131.3","2018-02-07","2018-04-08","","1","1");
INSERT INTO contas_receber VALUES("8823","292","913","2","1","4928","4928","0","2018-02-07","2018-03-11","","0","0");
INSERT INTO contas_receber VALUES("8824","292","913","3","1","4928","4928","0","2018-02-07","2018-04-11","","0","0");
INSERT INTO contas_receber VALUES("8825","292","913","1","1","4928","4928","0","2018-02-07","2018-02-08","","0","0");
INSERT INTO contas_receber VALUES("8826","71","902","2","1","387.73","0","387.73","2018-02-08","2018-03-23","","1","1");
INSERT INTO contas_receber VALUES("8827","71","902","3","1","387.74","0","387.74","2018-02-08","2018-04-08","","1","1");
INSERT INTO contas_receber VALUES("8828","71","902","1","1","387.73","0","387.73","2018-02-08","2018-03-08","","1","1");
INSERT INTO contas_receber VALUES("8829","33","900","2","1","1000.95","0","1000.95","2018-02-08","2018-02-23","","1","1");
INSERT INTO contas_receber VALUES("8830","33","900","1","1","1000.95","0","1000.95","2018-02-08","2018-02-23","","1","1");
INSERT INTO contas_receber VALUES("8882","21","898","1","1","1764.7","0","1764.7","2018-02-14","2018-03-06","","1","1");
INSERT INTO contas_receber VALUES("8883","21","898","4","1","1764.7","0","1764.7","2018-02-14","2018-04-06","","1","1");
INSERT INTO contas_receber VALUES("8884","21","898","5","1","1764.7","0","1764.7","2018-02-14","2018-04-16","","1","1");
INSERT INTO contas_receber VALUES("8885","21","898","2","1","1764.7","0","1764.7","2018-02-14","2018-03-16","","1","1");
INSERT INTO contas_receber VALUES("8886","21","898","3","1","1764.7","0","1764.7","2018-02-14","2018-03-26","","1","1");
INSERT INTO contas_receber VALUES("8888","255","903","1","1","1704.07","0","1704.07","2018-02-14","2018-02-26","","1","1");
INSERT INTO contas_receber VALUES("8915","182","904","1","1","1047.76","0","1047.76","2018-02-15","2018-02-11","","1","1");
INSERT INTO contas_receber VALUES("8916","4","906","1","1","1362.67","0","1362.67","2018-02-15","2018-03-18","","1","1");
INSERT INTO contas_receber VALUES("8917","4","906","3","1","1362.66","0","1362.66","2018-02-15","2018-04-17","","1","1");
INSERT INTO contas_receber VALUES("8918","4","906","2","1","1362.67","0","1362.67","2018-02-15","2018-04-02","","1","1");
INSERT INTO contas_receber VALUES("8951","264","910","1","1","326","0","326","2018-02-16","2018-02-09","","1","1");
INSERT INTO contas_receber VALUES("8952","46","921","1","1","143.05","0","143.05","2018-02-16","2018-03-18","","1","1");
INSERT INTO contas_receber VALUES("8953","291","905","2","1","226.5","0","226.5","2018-02-16","2018-02-28","","1","1");
INSERT INTO contas_receber VALUES("8954","291","905","1","1","300","0","300","2018-02-16","2018-02-10","","1","1");
INSERT INTO contas_receber VALUES("8989","60","907","1","1","522.83","0","522.83","2018-02-19","2018-03-18","","1","1");
INSERT INTO contas_receber VALUES("8990","60","907","2","1","522.83","0","522.83","2018-02-19","2018-04-02","","1","1");
INSERT INTO contas_receber VALUES("8991","60","907","3","1","522.84","0","522.84","2018-02-19","2018-04-17","","1","1");
INSERT INTO contas_receber VALUES("8992","19","918","1","1","263.75","0","263.75","2018-02-19","2018-03-19","","1","1");
INSERT INTO contas_receber VALUES("8993","19","918","2","1","263.75","0","263.75","2018-02-19","2018-04-19","","1","1");
INSERT INTO contas_receber VALUES("8994","174","909","1","1","270.6","0","270.6","2018-02-19","2018-03-19","","1","1");
INSERT INTO contas_receber VALUES("8995","98","908","1","1","1324.5","0","1324.5","2018-02-19","2018-03-02","","1","1");
INSERT INTO contas_receber VALUES("8999","212","912","3","1","788.9","0","788.9","2018-02-19","2018-04-20","","1","1");
INSERT INTO contas_receber VALUES("9000","212","912","1","1","788.9","0","788.9","2018-02-19","2018-03-21","","1","1");
INSERT INTO contas_receber VALUES("9001","212","912","2","1","788.9","0","788.9","2018-02-19","2018-04-05","","1","1");
INSERT INTO contas_receber VALUES("9002","220","919","1","1","2289.77","0","2289.77","2018-02-19","2018-03-21","","1","1");
INSERT INTO contas_receber VALUES("9003","220","919","2","1","2289.77","0","2289.77","2018-02-19","2018-04-05","","1","1");
INSERT INTO contas_receber VALUES("9004","220","919","3","1","2289.76","0","2289.76","2018-02-19","2018-04-21","","1","1");
INSERT INTO contas_receber VALUES("9007","43","911","1","1","278.55","0","278.55","2018-02-19","2018-03-20","","1","1");
INSERT INTO contas_receber VALUES("9008","43","911","2","1","278.55","0","278.55","2018-02-19","2018-04-20","","1","1");
INSERT INTO contas_receber VALUES("9012","294","917","1","1","424.94","0","424.94","2018-02-19","2018-03-20","","1","1");
INSERT INTO contas_receber VALUES("9013","294","917","2","1","424.94","0","424.94","2018-02-19","2018-04-04","","1","1");
INSERT INTO contas_receber VALUES("9014","294","917","3","1","424.93","0","424.93","2018-02-19","2018-04-20","","1","1");
INSERT INTO contas_receber VALUES("9015","31","916","1","1","558.64","0","558.64","2018-02-19","2018-03-20","","1","1");
INSERT INTO contas_receber VALUES("9016","31","916","2","1","558.64","0","558.64","2018-02-19","2018-04-04","","1","1");
INSERT INTO contas_receber VALUES("9017","31","916","3","1","558.64","0","558.64","2018-02-19","2018-04-20","","1","1");
INSERT INTO contas_receber VALUES("9020","83","924","2","1","303.99","0","303.99","2018-02-20","2018-04-20","","1","1");
INSERT INTO contas_receber VALUES("9021","83","924","1","1","303.99","0","303.99","2018-02-20","2018-03-20","","1","1");
INSERT INTO contas_receber VALUES("9069","220","936","1","1","308","0","308","2018-02-22","2018-03-25","","1","1");
INSERT INTO contas_receber VALUES("9070","295","920","1","1","407.33","0","407.33","2018-02-22","2018-03-21","","1","1");
INSERT INTO contas_receber VALUES("9071","295","920","2","1","407.33","0","407.33","2018-02-22","2018-04-05","","1","1");
INSERT INTO contas_receber VALUES("9072","295","920","3","1","407.34","0","407.34","2018-02-22","2018-04-21","","1","1");
INSERT INTO contas_receber VALUES("9075","296","922","1","1","196.7","0","196.7","2018-02-22","2018-03-21","","1","1");
INSERT INTO contas_receber VALUES("9076","296","922","2","1","196.7","0","196.7","2018-02-22","2018-04-21","","1","1");
INSERT INTO contas_receber VALUES("9077","179","925","1","1","610.72","0","610.72","2018-02-22","2018-03-22","","1","1");
INSERT INTO contas_receber VALUES("9078","179","925","2","1","610.72","0","610.72","2018-02-22","2018-04-06","","1","1");
INSERT INTO contas_receber VALUES("9079","179","925","3","1","610.71","0","610.71","2018-02-22","2018-04-22","","1","1");
INSERT INTO contas_receber VALUES("9117","3","915","1","1","32.86","0","32.86","2018-02-23","2018-02-10","","1","1");
INSERT INTO contas_receber VALUES("9118","3","941","1","1","71.1","0","71.1","2018-02-23","2018-02-23","","1","1");
INSERT INTO contas_receber VALUES("9155","24","930","1","1","747.75","0","747.75","2018-02-27","2018-03-12","","1","1");
INSERT INTO contas_receber VALUES("9156","24","930","2","1","747.75","0","747.75","2018-02-27","2018-03-13","","1","1");
INSERT INTO contas_receber VALUES("9157","297","928","1","1","802.4","0","802.4","2018-02-27","2018-03-27","","1","1");
INSERT INTO contas_receber VALUES("9158","297","928","2","1","802.4","0","802.4","2018-02-27","2018-04-05","","1","1");
INSERT INTO contas_receber VALUES("9159","25","923","1","1","2050.93","0","2050.93","2018-02-27","2018-03-26","","1","1");
INSERT INTO contas_receber VALUES("9160","25","923","2","1","2050.93","0","2050.93","2018-02-27","2018-04-10","","1","1");
INSERT INTO contas_receber VALUES("9161","25","923","3","1","2050.93","0","2050.93","2018-02-27","2018-04-26","","1","1");
INSERT INTO contas_receber VALUES("9162","25","923","4","1","2050.94","0","2050.94","2018-02-27","2018-05-11","","1","1");
INSERT INTO contas_receber VALUES("9184","263","926","1","1","1438.5","0","1438.5","2018-02-27","2018-03-13","","1","1");
INSERT INTO contas_receber VALUES("9187","7","932","1","1","177.6","0","177.6","2018-02-27","2018-04-02","","1","1");
INSERT INTO contas_receber VALUES("9188","7","932","2","1","177.6","0","177.6","2018-02-27","2018-05-02","","1","1");
INSERT INTO contas_receber VALUES("9211","253","944","1","1","701.34","701.34","0","2018-02-27","2018-03-12","","0","0");
INSERT INTO contas_receber VALUES("9212","253","944","2","1","127.01","127.01","0","2018-02-27","2018-03-20","","0","0");
INSERT INTO contas_receber VALUES("9275","46","949","1","1","241.05","241.05","0","2018-02-28","2018-04-02","","0","0");
INSERT INTO contas_receber VALUES("9276","154","948","2","1","105.03","0","105.03","2018-02-28","2018-04-02","","1","1");
INSERT INTO contas_receber VALUES("9277","154","948","1","1","105.03","0","105.03","2018-02-28","2018-02-25","","1","1");
INSERT INTO contas_receber VALUES("9286","25","929","1","1","315","0","315","2018-03-01","2018-04-02","","1","1");
INSERT INTO contas_receber VALUES("9287","25","929","2","1","315","0","315","2018-03-01","2018-04-17","","1","1");
INSERT INTO contas_receber VALUES("9288","25","929","3","1","315","0","315","2018-03-01","2018-05-02","","1","1");
INSERT INTO contas_receber VALUES("9289","9","937","1","1","968.17","0","968.17","2018-03-01","2018-04-05","","1","1");
INSERT INTO contas_receber VALUES("9290","9","937","2","1","968.17","0","968.17","2018-03-01","2018-04-20","","1","1");
INSERT INTO contas_receber VALUES("9291","9","937","3","1","968.16","0","968.16","2018-03-01","2018-05-05","","1","1");
INSERT INTO contas_receber VALUES("9292","98","934","1","1","1624","0","1624","2018-03-01","2018-03-19","","1","1");
INSERT INTO contas_receber VALUES("9293","4","940","1","1","1325","0","1325","2018-03-01","2018-04-05","","1","1");
INSERT INTO contas_receber VALUES("9294","4","940","2","1","1325","0","1325","2018-03-01","2018-04-20","","1","1");
INSERT INTO contas_receber VALUES("9295","4","940","3","1","1325","0","1325","2018-03-01","2018-05-05","","1","1");
INSERT INTO contas_receber VALUES("9296","17","935","1","1","492.43","0","492.43","2018-03-01","2018-04-02","","1","1");
INSERT INTO contas_receber VALUES("9297","17","935","2","1","492.43","0","492.43","2018-03-01","2018-04-17","","1","1");
INSERT INTO contas_receber VALUES("9298","17","935","3","1","492.44","0","492.44","2018-03-01","2018-05-02","","1","1");
INSERT INTO contas_receber VALUES("9299","31","945","4","1","171.7","0","171.7","2018-03-01","2018-05-10","","1","1");
INSERT INTO contas_receber VALUES("9300","31","945","2","1","537.73","0","537.73","2018-03-01","2018-04-20","","1","1");
INSERT INTO contas_receber VALUES("9301","31","945","1","1","537.73","0","537.73","2018-03-01","2018-04-05","","1","1");
INSERT INTO contas_receber VALUES("9302","31","945","3","1","537.74","0","537.74","2018-03-01","2018-05-05","","1","1");
INSERT INTO contas_receber VALUES("9309","59","942","3","1","216.56","0","216.56","2018-03-01","2018-05-06","","1","1");
INSERT INTO contas_receber VALUES("9310","59","942","1","1","216.57","0","216.57","2018-03-01","2018-04-06","","1","1");
INSERT INTO contas_receber VALUES("9311","59","942","2","1","216.57","0","216.57","2018-03-01","2018-04-21","","1","1");
INSERT INTO contas_receber VALUES("9312","299","939","1","1","335.6","0","335.6","2018-03-01","2018-04-02","","1","1");
INSERT INTO contas_receber VALUES("9325","174","946","1","1","618.05","0","618.05","2018-03-02","2018-04-06","","1","1");
INSERT INTO contas_receber VALUES("9326","174","946","2","1","618.05","0","618.05","2018-03-02","2018-05-06","","1","1");
INSERT INTO contas_receber VALUES("9327","174","946","3","1","530","0","530","2018-03-02","2018-04-21","","1","1");
INSERT INTO contas_receber VALUES("9401","87","954","1","1","440.7","0","440.7","2018-03-05","2018-04-07","","1","1");
INSERT INTO contas_receber VALUES("9402","87","954","2","1","440.7","0","440.7","2018-03-05","2018-05-07","","1","1");
INSERT INTO contas_receber VALUES("9409","22","943","1","1","681.12","0","681.12","2018-03-06","2018-04-06","","1","1");
INSERT INTO contas_receber VALUES("9410","22","943","2","1","681.12","0","681.12","2018-03-06","2018-04-21","","1","1");
INSERT INTO contas_receber VALUES("9411","22","943","3","1","681.11","0","681.11","2018-03-06","2018-05-06","","1","1");
INSERT INTO contas_receber VALUES("9418","178","958","1","1","144","0","144","2018-03-06","2018-04-06","","1","1");
INSERT INTO contas_receber VALUES("9422","31","966","3","1","257.4","0","257.4","2018-03-06","2018-05-08","","1","1");
INSERT INTO contas_receber VALUES("9423","31","966","2","1","257.4","0","257.4","2018-03-06","2018-04-23","","1","1");
INSERT INTO contas_receber VALUES("9424","31","966","1","1","257.4","0","257.4","2018-03-06","2018-04-08","","1","1");
INSERT INTO contas_receber VALUES("9425","31","969","2","1","305","0","305","2018-03-06","2018-04-23","","1","1");
INSERT INTO contas_receber VALUES("9426","31","969","1","1","305","0","305","2018-03-06","2018-04-08","","1","0");
INSERT INTO contas_receber VALUES("9427","31","969","3","1","305","305","0","2018-03-06","2018-05-08","","0","0");
INSERT INTO contas_receber VALUES("9488","3","950","1","1","176.41","0","176.41","2018-03-07","2018-02-25","","1","1");
INSERT INTO contas_receber VALUES("9491","223","947","1","1","408","0","408","2018-03-08","2018-04-08","","1","1");
INSERT INTO contas_receber VALUES("9492","223","947","3","1","408","0","408","2018-03-08","2018-05-08","","1","1");
INSERT INTO contas_receber VALUES("9493","223","947","2","1","408","0","408","2018-03-08","2018-04-22","","1","1");
INSERT INTO contas_receber VALUES("9494","180","953","1","1","374.7","0","374.7","2018-03-08","2018-04-07","","1","1");
INSERT INTO contas_receber VALUES("9495","180","953","2","1","72","0","72","2018-03-08","2018-04-22","","1","1");
INSERT INTO contas_receber VALUES("9496","180","953","3","1","374.7","0","374.7","2018-03-08","2018-05-07","","1","1");
INSERT INTO contas_receber VALUES("9499","302","957","1","1","354.6","0","354.6","2018-03-09","2018-03-19","","1","1");
INSERT INTO contas_receber VALUES("9508","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9509","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9510","30","956","1","1","1182.52","0","1182.52","2018-03-12","2018-04-08","","1","1");
INSERT INTO contas_receber VALUES("9511","30","956","2","1","1182.52","0","1182.52","2018-03-12","2018-04-23","","1","1");
INSERT INTO contas_receber VALUES("9512","30","956","4","1","1182.5","0","1182.5","2018-03-12","2018-05-23","","1","1");
INSERT INTO contas_receber VALUES("9513","30","956","3","1","1182.52","0","1182.52","2018-03-12","2018-05-08","","1","1");
INSERT INTO contas_receber VALUES("9514","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9515","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9518","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9519","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9521","84","959","1","1","587.14","0","587.14","2018-03-12","2018-04-07","","1","1");
INSERT INTO contas_receber VALUES("9522","84","959","2","1","587.14","0","587.14","2018-03-12","2018-04-23","","1","1");
INSERT INTO contas_receber VALUES("9523","84","959","3","1","587.15","0","587.15","2018-03-12","2018-05-07","","1","1");
INSERT INTO contas_receber VALUES("9524","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9525","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9526","43","962","1","1","203.04","0","203.04","2018-03-12","2018-04-07","","1","1");
INSERT INTO contas_receber VALUES("9527","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9528","43","962","2","1","203.04","0","203.04","2018-03-12","2018-05-07","","1","1");
INSERT INTO contas_receber VALUES("9529","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9530","5","955","2","1","404.87","0","404.87","2018-03-12","2018-04-22","","1","1");
INSERT INTO contas_receber VALUES("9531","5","955","1","1","404.87","0","404.87","2018-03-12","2018-04-08","","1","1");
INSERT INTO contas_receber VALUES("9532","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9533","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9534","5","955","3","1","404.86","0","404.86","2018-03-12","2018-05-08","","1","1");
INSERT INTO contas_receber VALUES("9535","219","960","1","1","423.18","0","423.18","2018-03-12","2018-04-09","","1","1");
INSERT INTO contas_receber VALUES("9536","219","960","2","1","423.18","0","423.18","2018-03-12","2018-04-24","","1","1");
INSERT INTO contas_receber VALUES("9537","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9538","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9539","219","960","3","1","423.19","0","423.19","2018-03-12","2018-05-09","","1","1");
INSERT INTO contas_receber VALUES("9540","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9542","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9543","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9545","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9547","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9548","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9550","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9551","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9553","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9554","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9556","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9557","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9559","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9560","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9561","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9562","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9569","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9570","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9574","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9575","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9579","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9580","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9584","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9585","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9586","87","985","2","1","495.3","495.3","0","2018-03-12","2018-04-13","","0","0");
INSERT INTO contas_receber VALUES("9587","87","985","3","1","495.3","495.3","0","2018-03-12","2018-05-14","","0","0");
INSERT INTO contas_receber VALUES("9588","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9589","87","985","1","1","495.3","495.3","0","2018-03-12","2018-03-13","","0","0");
INSERT INTO contas_receber VALUES("9590","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9592","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9593","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9595","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9596","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9598","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9599","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9601","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9602","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9604","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9605","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9606","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9607","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9609","3","976","1","1","246.55","0","246.55","2018-03-12","2018-03-11","","1","1");
INSERT INTO contas_receber VALUES("9610","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9611","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9612","3","983","1","1","94.46","0","94.46","2018-03-12","2018-03-14","","1","1");
INSERT INTO contas_receber VALUES("9613","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9614","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9616","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9617","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9619","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9620","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9622","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9623","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9624","190","971","1","1","20","0","20","2018-03-12","2018-03-07","","1","1");
INSERT INTO contas_receber VALUES("9625","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9626","0","0","0","0","0","0","0","2018-03-12","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9630","0","0","0","0","0","0","0","2018-03-13","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9631","0","0","0","0","0","0","0","2018-03-13","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9635","0","0","0","0","0","0","0","2018-03-13","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9636","0","0","0","0","0","0","0","2018-03-13","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9639","0","0","0","0","0","0","0","2018-03-13","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9641","0","0","0","0","0","0","0","2018-03-13","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9642","0","0","0","0","0","0","0","2018-03-13","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9643","0","0","0","0","0","0","0","2018-03-13","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9645","0","0","0","0","0","0","0","2018-03-13","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9646","0","0","0","0","0","0","0","2018-03-13","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9649","0","0","0","0","0","0","0","2018-03-13","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9650","0","0","0","0","0","0","0","2018-03-13","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9652","0","0","0","0","0","0","0","2018-03-13","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9653","0","0","0","0","0","0","0","2018-03-13","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9655","0","0","0","0","0","0","0","2018-03-13","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9656","0","0","0","0","0","0","0","2018-03-13","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9658","0","0","0","0","0","0","0","2018-03-13","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9659","0","0","0","0","0","0","0","2018-03-13","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9660","0","0","0","0","0","0","0","2018-03-13","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9662","0","0","0","0","0","0","0","2018-03-13","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9664","0","0","0","0","0","0","0","2018-03-13","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9665","0","0","0","0","0","0","0","2018-03-13","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9669","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9670","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9671","211","964","1","1","553.4","0","553.4","2018-03-14","2018-04-12","","1","1");
INSERT INTO contas_receber VALUES("9672","211","964","2","1","553.4","0","553.4","2018-03-14","2018-04-27","","1","1");
INSERT INTO contas_receber VALUES("9673","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9674","211","964","3","1","553.4","0","553.4","2018-03-14","2018-05-12","","1","1");
INSERT INTO contas_receber VALUES("9675","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9676","186","968","1","1","294.03","0","294.03","2018-03-14","2018-04-14","","1","1");
INSERT INTO contas_receber VALUES("9677","186","968","2","1","294.03","0","294.03","2018-03-14","2018-04-29","","1","1");
INSERT INTO contas_receber VALUES("9678","186","968","3","1","294.04","0","294.04","2018-03-14","2018-05-14","","1","1");
INSERT INTO contas_receber VALUES("9679","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9680","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9681","62","963","1","1","423.94","0","423.94","2018-03-14","2018-04-14","","1","1");
INSERT INTO contas_receber VALUES("9682","62","963","2","1","423.94","0","423.94","2018-03-14","2018-04-29","","1","1");
INSERT INTO contas_receber VALUES("9683","62","963","3","1","423.94","0","423.94","2018-03-14","2018-05-14","","1","1");
INSERT INTO contas_receber VALUES("9684","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9685","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9686","256","961","1","1","365.83","0","365.83","2018-03-14","2018-04-09","","1","1");
INSERT INTO contas_receber VALUES("9687","256","961","2","1","365.83","0","365.83","2018-03-14","2018-04-23","","1","1");
INSERT INTO contas_receber VALUES("9688","256","961","3","1","365.84","0","365.84","2018-03-14","2018-05-09","","1","1");
INSERT INTO contas_receber VALUES("9689","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9690","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9691","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9692","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9695","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9696","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9697","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9698","40","984","1","1","220","0","220","2018-03-14","2018-03-14","","1","1");
INSERT INTO contas_receber VALUES("9699","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9703","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9704","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9710","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9711","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9716","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9717","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9719","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9720","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9721","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9722","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9725","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9727","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9730","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9731","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9734","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9735","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9737","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9738","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9739","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9741","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9743","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9744","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9746","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9748","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9751","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9752","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9755","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9756","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9757","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9758","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9761","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9762","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9764","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9765","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9767","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9768","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9769","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9771","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9773","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9774","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9775","306","993","1","1","70.74","0","70.74","2018-03-14","2018-03-16","","1","1");
INSERT INTO contas_receber VALUES("9776","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9777","0","0","0","0","0","0","0","2018-03-14","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9779","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9780","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9782","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9783","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9785","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9786","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9790","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9791","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9795","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9796","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9800","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9801","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9805","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9806","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9809","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9810","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9816","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9817","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9820","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9824","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9828","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9829","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9832","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9834","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9838","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9839","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9841","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9842","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9843","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9845","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9846","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9847","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9849","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9851","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9853","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9854","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9858","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9859","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9863","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9864","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9867","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9868","0","0","0","0","0","0","0","2018-03-15","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9870","203","970","3","1","472.88","0","472.88","2018-03-16","2018-03-29","","1","1");
INSERT INTO contas_receber VALUES("9871","0","0","0","0","0","0","0","2018-03-16","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9872","203","970","1","1","906.06","0","906.06","2018-03-16","2018-03-29","","1","1");
INSERT INTO contas_receber VALUES("9873","203","970","2","1","906.06","0","906.06","2018-03-16","2018-03-29","","1","1");
INSERT INTO contas_receber VALUES("9874","4","967","1","1","1298","0","1298","2018-03-16","2018-04-15","","1","1");
INSERT INTO contas_receber VALUES("9875","4","967","2","1","1298","0","1298","2018-03-16","2018-04-30","","1","1");
INSERT INTO contas_receber VALUES("9876","4","967","3","1","1298","0","1298","2018-03-16","2018-05-15","","1","1");
INSERT INTO contas_receber VALUES("9877","0","0","0","0","0","0","0","2018-03-16","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9879","0","0","0","0","0","0","0","2018-03-16","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9880","0","0","0","0","0","0","0","2018-03-16","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9883","0","0","0","0","0","0","0","2018-03-16","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9886","0","0","0","0","0","0","0","2018-03-16","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9889","0","0","0","0","0","0","0","2018-03-16","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9890","291","997","2","1","305.35","305.35","0","2018-03-16","2018-04-17","","0","0");
INSERT INTO contas_receber VALUES("9891","291","997","1","1","305.35","305.35","0","2018-03-16","2018-03-17","","0","0");
INSERT INTO contas_receber VALUES("9892","0","0","0","0","0","0","0","2018-03-16","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9895","0","0","0","0","0","0","0","2018-03-16","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9896","0","0","0","0","0","0","0","2018-03-16","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9900","0","0","0","0","0","0","0","2018-03-16","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9904","0","0","0","0","0","0","0","2018-03-16","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9907","0","0","0","0","0","0","0","2018-03-16","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9909","0","0","0","0","0","0","0","2018-03-16","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9912","0","0","0","0","0","0","0","2018-03-16","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9918","0","0","0","0","0","0","0","2018-03-16","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9923","0","0","0","0","0","0","0","2018-03-16","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9925","0","0","0","0","0","0","0","2018-03-16","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9930","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9931","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9933","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9934","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9935","66","999","1","1","161.1","161.1","0","2018-03-19","2018-03-20","","0","0");
INSERT INTO contas_receber VALUES("9936","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9937","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9938","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9939","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9941","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9943","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9945","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9946","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9948","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9949","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9951","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9952","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9954","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9955","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9956","127","965","1","1","261.5","0","261.5","2018-03-19","2018-04-15","","1","1");
INSERT INTO contas_receber VALUES("9957","127","965","2","1","261.5","0","261.5","2018-03-19","2018-04-30","","1","1");
INSERT INTO contas_receber VALUES("9958","127","965","3","1","261.5","0","261.5","2018-03-19","2018-05-15","","1","1");
INSERT INTO contas_receber VALUES("9959","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9960","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9961","212","977","2","1","679.6","0","679.6","2018-03-19","2018-05-04","","1","1");
INSERT INTO contas_receber VALUES("9962","212","977","3","1","679.6","679.6","0","2018-03-19","2018-05-19","","0","0");
INSERT INTO contas_receber VALUES("9963","212","977","4","1","213.6","213.6","0","2018-03-19","2018-05-24","","0","0");
INSERT INTO contas_receber VALUES("9964","212","977","1","1","679.6","0","679.6","2018-03-19","2018-04-19","","1","0");
INSERT INTO contas_receber VALUES("9965","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9966","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9969","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9970","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9972","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9973","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9977","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9978","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9979","293","914","1","1","69.01","0","69.01","2018-03-19","2018-02-10","","1","1");
INSERT INTO contas_receber VALUES("9980","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9981","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9983","300","951","1","1","82","0","82","2018-03-19","2018-02-26","","1","1");
INSERT INTO contas_receber VALUES("9984","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9985","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9987","29","931","1","1","550","0","550","2018-03-19","2018-02-17","","1","1");
INSERT INTO contas_receber VALUES("9988","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9989","94","938","1","1","229.58","0","229.58","2018-03-19","2018-02-21","","1","1");
INSERT INTO contas_receber VALUES("9990","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9991","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9992","298","933","1","1","80.76","0","80.76","2018-03-19","2018-02-17","","1","1");
INSERT INTO contas_receber VALUES("9993","112","988","1","1","88.81","0","88.81","2018-03-19","2018-03-15","","1","1");
INSERT INTO contas_receber VALUES("9994","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("9995","301","952","1","1","134.5","0","134.5","2018-03-19","2018-02-28","","1","1");
INSERT INTO contas_receber VALUES("9996","0","0","0","0","0","0","0","2018-03-19","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10000","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10001","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10005","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10006","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10010","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10011","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10012","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10013","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10014","220","972","3","1","1231.66","0","1231.66","2018-03-20","2018-05-16","","1","1");
INSERT INTO contas_receber VALUES("10015","220","972","1","1","1231.67","0","1231.67","2018-03-20","2018-04-16","","1","1");
INSERT INTO contas_receber VALUES("10016","220","972","2","1","1231.67","0","1231.67","2018-03-20","2018-05-01","","1","1");
INSERT INTO contas_receber VALUES("10017","128","974","1","1","314","0","314","2018-03-20","2018-04-16","","1","1");
INSERT INTO contas_receber VALUES("10018","128","974","2","1","314","0","314","2018-03-20","2018-05-16","","1","1");
INSERT INTO contas_receber VALUES("10019","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10020","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10021","31","981","1","1","352.75","0","352.75","2018-03-20","2018-04-23","","1","1");
INSERT INTO contas_receber VALUES("10022","31","981","2","1","352.75","0","352.75","2018-03-20","2018-05-23","","1","1");
INSERT INTO contas_receber VALUES("10023","31","981","3","1","97.26","0","97.26","2018-03-20","2018-05-07","","1","1");
INSERT INTO contas_receber VALUES("10024","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10025","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10026","33","982","1","1","1763.96","0","1763.96","2018-03-20","2018-03-15","","1","1");
INSERT INTO contas_receber VALUES("10027","33","982","2","1","433.84","0","433.84","2018-03-20","2018-03-27","","1","1");
INSERT INTO contas_receber VALUES("10028","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10029","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10030","160","990","1","1","200.13","0","200.13","2018-03-20","2018-04-20","","1","1");
INSERT INTO contas_receber VALUES("10031","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10032","160","990","2","1","200.12","0","200.12","2018-03-20","2018-05-20","","1","1");
INSERT INTO contas_receber VALUES("10033","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10037","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10038","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10042","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10043","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10047","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10048","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10052","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10053","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10055","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10056","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10058","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10059","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10060","3","1004","1","1","36","36","0","2018-03-20","2018-03-21","","0","1");
INSERT INTO contas_receber VALUES("10061","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10062","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10063","3","989","1","1","80","0","80","2018-03-20","2018-03-16","","1","1");
INSERT INTO contas_receber VALUES("10064","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10065","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10069","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10070","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10071","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10074","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10079","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10080","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10083","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10084","0","0","0","0","0","0","0","2018-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10089","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10090","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10093","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10094","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10096","113","975","1","1","400.75","0","400.75","2018-03-21","2018-04-16","","1","1");
INSERT INTO contas_receber VALUES("10097","113","975","2","1","400.75","0","400.75","2018-03-21","2018-05-01","","1","1");
INSERT INTO contas_receber VALUES("10098","113","975","3","1","400.75","0","400.75","2018-03-21","2018-05-16","","1","1");
INSERT INTO contas_receber VALUES("10099","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10100","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10101","86","978","1","1","312.33","0","312.33","2018-03-21","2018-04-21","","1","1");
INSERT INTO contas_receber VALUES("10102","86","978","2","1","312.33","0","312.33","2018-03-21","2018-05-21","","1","1");
INSERT INTO contas_receber VALUES("10103","86","978","3","1","312.34","0","312.34","2018-03-21","2018-06-21","","1","1");
INSERT INTO contas_receber VALUES("10104","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10105","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10106","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10107","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10108","76","979","1","1","574.53","0","574.53","2018-03-21","2018-04-21","","1","1");
INSERT INTO contas_receber VALUES("10109","76","979","2","1","574.53","0","574.53","2018-03-21","2018-05-06","","1","1");
INSERT INTO contas_receber VALUES("10110","76","979","3","1","574.54","0","574.54","2018-03-21","2018-05-21","","1","1");
INSERT INTO contas_receber VALUES("10112","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10114","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10117","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10118","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10121","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10122","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10124","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10125","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10126","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10128","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10132","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10133","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10137","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10138","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10139","307","1000","1","1","160.82","0","160.82","2018-03-21","2018-03-21","","1","1");
INSERT INTO contas_receber VALUES("10140","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10141","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10144","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10145","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10150","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10151","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10155","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10156","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10158","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10159","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10160","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10163","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10166","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10167","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10168","43","1009","2","1","171.2","171.2","0","2018-03-21","2018-04-22","","0","0");
INSERT INTO contas_receber VALUES("10169","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10170","0","0","0","0","0","0","0","2018-03-21","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10171","43","1009","1","1","171.2","171.2","0","2018-03-21","2018-03-22","","0","0");
INSERT INTO contas_receber VALUES("10172","292","995","1","1","768","0","768","2018-03-22","2018-04-26","","1","1");
INSERT INTO contas_receber VALUES("10173","292","995","2","1","768","0","768","2018-03-22","2018-05-11","","1","1");
INSERT INTO contas_receber VALUES("10174","292","995","3","1","768","0","768","2018-03-22","2018-05-26","","1","1");
INSERT INTO contas_receber VALUES("10175","0","0","0","0","0","0","0","2018-03-22","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10176","140","980","1","1","316.25","0","316.25","2018-03-22","2018-04-22","","1","1");
INSERT INTO contas_receber VALUES("10177","140","980","2","1","316.25","0","316.25","2018-03-22","2018-05-07","","1","1");
INSERT INTO contas_receber VALUES("10178","0","0","0","0","0","0","0","2018-03-22","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10179","106","973","3","1","325.54","0","325.54","2018-03-22","2018-05-20","","1","1");
INSERT INTO contas_receber VALUES("10180","0","0","0","0","0","0","0","2018-03-22","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10181","106","973","2","1","325.53","0","325.53","2018-03-22","2018-05-05","","1","1");
INSERT INTO contas_receber VALUES("10182","106","973","1","1","325.53","0","325.53","2018-03-22","2018-04-20","","1","1");
INSERT INTO contas_receber VALUES("10184","0","0","0","0","0","0","0","2018-03-22","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10188","0","0","0","0","0","0","0","2018-03-22","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10189","0","0","0","0","0","0","0","2018-03-22","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10195","0","0","0","0","0","0","0","2018-03-22","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10197","0","0","0","0","0","0","0","2018-03-22","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10200","0","0","0","0","0","0","0","2018-03-22","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10201","303","987","2","1","495.3","0","495.3","2018-03-23","2018-05-07","","1","1");
INSERT INTO contas_receber VALUES("10202","303","987","1","1","495.3","0","495.3","2018-03-23","2018-04-22","","1","1");
INSERT INTO contas_receber VALUES("10203","303","987","3","1","495.3","0","495.3","2018-03-23","2018-05-22","","1","1");
INSERT INTO contas_receber VALUES("10204","0","0","0","0","0","0","0","2018-03-23","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10205","0","0","0","0","0","0","0","2018-03-23","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10206","24","991","1","1","586.33","0","586.33","2018-03-23","2018-04-04","","1","1");
INSERT INTO contas_receber VALUES("10207","24","991","2","1","586.32","0","586.32","2018-03-23","2018-04-04","","1","1");
INSERT INTO contas_receber VALUES("10208","0","0","0","0","0","0","0","2018-03-23","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10209","0","0","0","0","0","0","0","2018-03-23","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10212","0","0","0","0","0","0","0","2018-03-23","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10213","0","0","0","0","0","0","0","2018-03-23","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10214","0","0","0","0","0","0","0","2018-03-23","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10216","0","0","0","0","0","0","0","2018-03-23","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10219","0","0","0","0","0","0","0","2018-03-23","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10220","0","0","0","0","0","0","0","2018-03-23","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10222","0","0","0","0","0","0","0","2018-03-23","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10223","0","0","0","0","0","0","0","2018-03-23","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10225","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10226","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10228","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10229","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10230","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10232","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10235","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10236","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10241","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10242","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10243","308","1005","1","1","804.3","0","804.3","2018-03-26","2018-04-29","","1","1");
INSERT INTO contas_receber VALUES("10244","308","1005","2","1","804.3","0","804.3","2018-03-26","2018-05-14","","1","1");
INSERT INTO contas_receber VALUES("10245","308","1005","3","1","804.3","0","804.3","2018-03-26","2018-05-29","","1","1");
INSERT INTO contas_receber VALUES("10246","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10247","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10250","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10251","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10259","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10260","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10261","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10262","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10265","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10266","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10271","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10272","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10276","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10277","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10280","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10281","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10284","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10285","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10287","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10288","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10291","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10292","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10296","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10297","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10302","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10303","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10307","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10308","0","0","0","0","0","0","0","2018-03-26","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10310","0","0","0","0","0","0","0","2018-03-27","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10311","0","0","0","0","0","0","0","2018-03-27","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10313","0","0","0","0","0","0","0","2018-03-27","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10314","0","0","0","0","0","0","0","2018-03-27","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10315","44","996","1","1","717.04","0","717.04","2018-03-27","2018-04-27","","1","1");
INSERT INTO contas_receber VALUES("10316","44","996","2","1","717.04","0","717.04","2018-03-27","2018-05-12","","1","1");
INSERT INTO contas_receber VALUES("10317","44","996","3","1","717.04","0","717.04","2018-03-27","2018-05-27","","1","1");
INSERT INTO contas_receber VALUES("10318","44","996","4","1","158.1","0","158.1","2018-03-27","2018-05-30","","1","1");
INSERT INTO contas_receber VALUES("10319","0","0","0","0","0","0","0","2018-03-27","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10320","0","0","0","0","0","0","0","2018-03-27","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10321","291","998","1","1","305.35","0","305.35","2018-03-27","2018-04-27","","1","1");
INSERT INTO contas_receber VALUES("10322","291","998","2","1","305.35","0","305.35","2018-03-27","2018-05-27","","1","1");
INSERT INTO contas_receber VALUES("10323","0","0","0","0","0","0","0","2018-03-27","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10324","0","0","0","0","0","0","0","2018-03-27","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10328","0","0","0","0","0","0","0","2018-03-27","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10329","0","0","0","0","0","0","0","2018-03-27","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10331","0","0","0","0","0","0","0","2018-03-27","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10334","0","0","0","0","0","0","0","2018-03-27","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10336","0","0","0","0","0","0","0","2018-03-27","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10337","0","0","0","0","0","0","0","2018-03-27","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10339","0","0","0","0","0","0","0","2018-03-27","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10340","0","0","0","0","0","0","0","2018-03-27","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10344","0","0","0","0","0","0","0","2018-03-27","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10345","0","0","0","0","0","0","0","2018-03-27","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10346","0","0","0","0","0","0","0","2018-03-27","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10348","0","0","0","0","0","0","0","2018-03-27","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10352","0","0","0","0","0","0","0","2018-03-27","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10353","0","0","0","0","0","0","0","2018-03-27","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10356","0","0","0","0","0","0","0","2018-03-27","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10358","0","0","0","0","0","0","0","2018-03-27","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10359","166","1001","1","1","161.1","0","161.1","2018-03-27","2018-03-21","","1","1");
INSERT INTO contas_receber VALUES("10360","0","0","0","0","0","0","0","2018-03-27","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10361","0","0","0","0","0","0","0","2018-03-27","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10362","31","1007","1","1","282.13","0","282.13","2018-03-28","2018-05-02","","1","1");
INSERT INTO contas_receber VALUES("10363","31","1007","2","1","282.13","0","282.13","2018-03-28","2018-05-17","","1","1");
INSERT INTO contas_receber VALUES("10364","31","1007","3","1","282.14","0","282.14","2018-03-28","2018-06-02","","1","1");
INSERT INTO contas_receber VALUES("10365","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10366","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10370","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10371","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10374","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10376","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10379","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10381","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10385","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10386","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10389","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10391","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10395","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10396","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10399","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10400","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10403","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10404","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10407","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10409","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10411","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10414","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10417","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10418","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10421","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10422","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10424","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10425","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10427","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10428","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10429","151","1025","1","1","97.11","97.11","0","2018-03-28","2018-03-30","","0","0");
INSERT INTO contas_receber VALUES("10430","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10431","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10432","28","986","1","1","288.7","0","288.7","2018-03-28","2018-03-14","","1","1");
INSERT INTO contas_receber VALUES("10433","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10434","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10435","236","656","1","1","248.3","248.3","0","2018-03-28","2017-09-29","","0","1");
INSERT INTO contas_receber VALUES("10436","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10437","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10438","305","992","1","1","116.8","0","116.8","2018-03-28","2018-03-16","","1","1");
INSERT INTO contas_receber VALUES("10439","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10440","0","0","0","0","0","0","0","2018-03-28","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10444","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10445","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10446","313","1026","2","1","1059.13","1059.13","0","2018-03-29","2018-04-30","","0","0");
INSERT INTO contas_receber VALUES("10447","313","1026","1","1","1059.13","1059.13","0","2018-03-29","2018-03-30","","0","0");
INSERT INTO contas_receber VALUES("10448","313","1026","3","1","1059.14","1059.14","0","2018-03-29","2018-05-31","","0","0");
INSERT INTO contas_receber VALUES("10449","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10450","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10451","74","994","2","1","2242.47","0","2242.47","2018-03-29","2018-05-28","","1","1");
INSERT INTO contas_receber VALUES("10452","74","994","1","1","2242.47","0","2242.47","2018-03-29","2018-04-28","","1","1");
INSERT INTO contas_receber VALUES("10453","74","994","3","1","2242.47","0","2242.47","2018-03-29","2018-06-12","","1","1");
INSERT INTO contas_receber VALUES("10454","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10455","74","994","4","1","2242.49","0","2242.49","2018-03-29","2018-06-28","","1","1");
INSERT INTO contas_receber VALUES("10456","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10457","70","1002","1","1","703.25","0","703.25","2018-03-29","2018-04-13","","1","1");
INSERT INTO contas_receber VALUES("10458","70","1002","2","1","703.25","0","703.25","2018-03-29","2018-04-13","","1","1");
INSERT INTO contas_receber VALUES("10459","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10460","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10461","161","1003","1","1","429.55","0","429.55","2018-03-29","2018-04-29","","1","1");
INSERT INTO contas_receber VALUES("10462","161","1003","2","1","429.55","0","429.55","2018-03-29","2018-05-14","","1","1");
INSERT INTO contas_receber VALUES("10463","161","1003","3","1","429.55","0","429.55","2018-03-29","2018-05-29","","1","1");
INSERT INTO contas_receber VALUES("10464","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10465","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10466","264","1006","1","1","420.6","0","420.6","2018-03-29","2018-03-24","","1","1");
INSERT INTO contas_receber VALUES("10467","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10468","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10469","33","1020","1","1","232.6","0","232.6","2018-03-29","2018-03-29","","1","1");
INSERT INTO contas_receber VALUES("10470","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10471","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10475","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10476","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10479","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10481","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10484","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10485","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10488","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10489","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10492","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10493","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10496","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10497","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10500","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10501","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10504","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10505","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10508","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10509","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10511","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10512","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10514","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10515","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10517","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10518","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10520","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10521","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10523","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10524","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10525","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10527","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10529","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10530","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10532","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10533","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10535","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10536","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10538","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10539","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10543","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10544","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10548","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10549","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10553","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10554","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10558","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10559","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10562","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10563","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10567","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10569","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10573","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10574","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10578","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10579","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10581","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10582","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10584","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10585","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10586","314","1030","1","1","87.9","0","87.9","2018-03-29","2018-03-31","","1","1");
INSERT INTO contas_receber VALUES("10587","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10588","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10592","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10593","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10597","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10598","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10602","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10603","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10604","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10606","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10610","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10611","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10612","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10614","0","0","0","0","0","0","0","2018-03-29","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("10626","284","1033","1","1","359.6","359.6","0","2018-04-02","2018-04-05","","0","0");
INSERT INTO contas_receber VALUES("10627","284","1033","3","1","359.6","359.6","0","2018-04-02","2018-06-06","","0","0");
INSERT INTO contas_receber VALUES("10628","284","1033","2","1","359.6","359.6","0","2018-04-02","2018-05-06","","0","0");
INSERT INTO contas_receber VALUES("10651","25","1022","1","1","399","0","399","2018-04-03","2018-05-03","","1","1");
INSERT INTO contas_receber VALUES("10652","25","1022","2","1","399","0","399","2018-04-03","2018-05-18","","1","1");
INSERT INTO contas_receber VALUES("10653","25","1022","3","1","399","0","399","2018-04-03","2018-06-03","","1","1");
INSERT INTO contas_receber VALUES("10654","309","1010","2","1","171.2","0","171.2","2018-04-03","2018-06-02","","1","1");
INSERT INTO contas_receber VALUES("10655","309","1010","1","1","171.2","0","171.2","2018-04-03","2018-05-02","","1","1");
INSERT INTO contas_receber VALUES("10656","309","1010","3","1","118.4","0","118.4","2018-04-03","2018-05-17","","1","1");
INSERT INTO contas_receber VALUES("10689","174","1013","1","1","686.1","0","686.1","2018-04-04","2018-06-03","","1","1");
INSERT INTO contas_receber VALUES("10690","174","1013","2","1","686.1","0","686.1","2018-04-04","2018-05-03","","1","1");
INSERT INTO contas_receber VALUES("10691","174","1013","3","0","143.6","0","143.6","2018-04-04","2018-05-18","","1","1");
INSERT INTO contas_receber VALUES("10702","3","1012","1","1","174.38","0","174.38","2018-04-04","2018-03-25","","1","1");
INSERT INTO contas_receber VALUES("10707","310","1014","1","1","1216.8","0","1216.8","2018-04-04","2018-04-16","","1","1");
INSERT INTO contas_receber VALUES("10708","180","1019","1","1","485.03","0","485.03","2018-04-04","2018-05-09","","1","1");
INSERT INTO contas_receber VALUES("10709","180","1019","2","1","485.03","0","485.03","2018-04-04","2018-05-24","","1","1");
INSERT INTO contas_receber VALUES("10710","180","1019","3","1","485.04","0","485.04","2018-04-04","2018-06-09","","1","1");
INSERT INTO contas_receber VALUES("10711","46","1027","1","1","222.02","0","222.02","2018-04-04","2018-05-06","","1","1");
INSERT INTO contas_receber VALUES("10712","46","1027","2","1","222.02","0","222.02","2018-04-04","2018-06-06","","1","1");
INSERT INTO contas_receber VALUES("10716","31","1023","2","1","517.43","0","517.43","2018-04-04","2018-05-19","","1","1");
INSERT INTO contas_receber VALUES("10717","31","1023","1","1","517.43","0","517.43","2018-04-04","2018-05-04","","1","1");
INSERT INTO contas_receber VALUES("10718","31","1023","3","1","517.44","0","517.44","2018-04-04","2018-06-04","","1","1");
INSERT INTO contas_receber VALUES("10719","31","1023","4","1","457.5","0","457.5","2018-04-04","2018-06-19","","1","1");
INSERT INTO contas_receber VALUES("10766","220","1021","1","1","3021.33","0","3021.33","2018-04-06","2018-05-06","","1","1");
INSERT INTO contas_receber VALUES("10767","220","1021","2","1","3021.33","0","3021.33","2018-04-06","2018-05-21","","1","1");
INSERT INTO contas_receber VALUES("10768","220","1021","3","1","3021.34","0","3021.34","2018-04-06","2018-06-06","","1","1");
INSERT INTO contas_receber VALUES("10785","220","1054","1","1","406","0","406","2018-04-06","2018-05-16","","1","1");
INSERT INTO contas_receber VALUES("10786","47","1015","1","1","543.6","0","543.6","2018-04-09","2018-05-05","","1","1");
INSERT INTO contas_receber VALUES("10787","47","1015","2","1","543.6","0","543.6","2018-04-09","2018-05-20","","1","1");
INSERT INTO contas_receber VALUES("10788","47","1015","3","1","543.6","0","543.6","2018-04-09","2018-06-05","","1","1");
INSERT INTO contas_receber VALUES("10789","311","1018","2","1","398.89","0","398.89","2018-04-09","2018-05-21","","1","1");
INSERT INTO contas_receber VALUES("10790","311","1018","3","1","398.9","0","398.9","2018-04-09","2018-06-06","","1","1");
INSERT INTO contas_receber VALUES("10791","311","1018","1","1","398.89","0","398.89","2018-04-09","2018-05-06","","1","1");
INSERT INTO contas_receber VALUES("10792","312","1024","1","1","209.75","0","209.75","2018-04-09","2018-05-11","","1","1");
INSERT INTO contas_receber VALUES("10793","312","1024","2","1","209.75","0","209.75","2018-04-09","2018-05-11","","1","1");
INSERT INTO contas_receber VALUES("10807","255","1032","1","1","1675.61","0","1675.61","2018-04-09","2018-04-27","","1","1");
INSERT INTO contas_receber VALUES("10832","36","1011","3","1","410.66","0","410.66","2018-04-09","2018-06-03","","1","1");
INSERT INTO contas_receber VALUES("10833","36","1011","2","1","410.66","0","410.66","2018-04-09","2018-05-18","","1","1");
INSERT INTO contas_receber VALUES("10834","36","1011","1","1","410.66","0","410.66","2018-04-09","2018-05-05","","1","1");
INSERT INTO contas_receber VALUES("10835","36","1011","4","1","568.02","0","568.02","2018-04-09","2018-06-13","","1","1");
INSERT INTO contas_receber VALUES("10845","83","1039","2","1","221.28","0","221.28","2018-04-10","2018-06-10","","1","1");
INSERT INTO contas_receber VALUES("10846","83","1039","1","1","221.28","0","221.28","2018-04-10","2018-05-10","","1","1");
INSERT INTO contas_receber VALUES("10847","60","1008","3","1","431.2","0","431.2","2018-04-10","2018-06-02","","1","1");
INSERT INTO contas_receber VALUES("10848","60","1008","4","1","54.28","0","54.28","2018-04-10","2018-06-02","","1","1");
INSERT INTO contas_receber VALUES("10849","60","1008","1","1","431.2","0","431.2","2018-04-10","2018-05-02","","1","1");
INSERT INTO contas_receber VALUES("10850","60","1008","2","1","431.2","0","431.2","2018-04-10","2018-05-17","","1","1");
INSERT INTO contas_receber VALUES("10886","94","1035","1","1","344.92","0","344.92","2018-04-10","2018-05-25","","1","1");
INSERT INTO contas_receber VALUES("10891","146","1016","1","1","521.17","0","521.17","2018-04-11","2018-05-06","","1","1");
INSERT INTO contas_receber VALUES("10892","146","1016","2","1","521.17","0","521.17","2018-04-11","2018-05-21","","1","1");
INSERT INTO contas_receber VALUES("10893","146","1016","3","1","521.16","0","521.16","2018-04-11","2018-06-06","","1","1");
INSERT INTO contas_receber VALUES("10894","315","1031","1","1","428.73","0","428.73","2018-04-11","2018-05-13","","1","1");
INSERT INTO contas_receber VALUES("10895","315","1031","2","1","428.73","0","428.73","2018-04-11","2018-05-28","","1","1");
INSERT INTO contas_receber VALUES("10896","315","1031","3","1","428.74","0","428.74","2018-04-11","2018-06-13","","1","1");
INSERT INTO contas_receber VALUES("10897","174","1061","1","1","144","0","144","2018-04-11","2018-05-10","","1","1");
INSERT INTO contas_receber VALUES("10922","292","1057","1","1","828","0","828","2018-04-12","2018-05-13","","1","1");
INSERT INTO contas_receber VALUES("10923","292","1057","2","1","828","0","828","2018-04-12","2018-05-28","","1","1");
INSERT INTO contas_receber VALUES("10924","292","1057","3","1","828","0","828","2018-04-12","2018-06-13","","1","1");
INSERT INTO contas_receber VALUES("10925","19","1044","1","1","299.45","0","299.45","2018-04-12","2018-05-13","","1","1");
INSERT INTO contas_receber VALUES("10926","19","1044","2","1","299.45","0","299.45","2018-04-12","2018-06-13","","1","1");
INSERT INTO contas_receber VALUES("10929","316","1038","1","1","1499.97","0","1499.97","2018-04-12","2018-05-03","","1","1");
INSERT INTO contas_receber VALUES("10930","179","1043","1","1","352.8","0","352.8","2018-04-12","2018-05-17","","1","1");
INSERT INTO contas_receber VALUES("10931","179","1043","3","1","352.8","0","352.8","2018-04-12","2018-06-17","","1","1");
INSERT INTO contas_receber VALUES("10932","179","1043","2","1","352.8","0","352.8","2018-04-12","2018-06-01","","1","1");
INSERT INTO contas_receber VALUES("11005","91","1040","1","1","752.98","0","752.98","2018-04-13","2018-04-30","","1","1");
INSERT INTO contas_receber VALUES("11006","91","1040","2","1","752.97","0","752.97","2018-04-13","2018-04-30","","1","1");
INSERT INTO contas_receber VALUES("11015","3","1041","1","1","112.91","0","112.91","2018-04-13","2018-04-07","","1","1");
INSERT INTO contas_receber VALUES("11058","4","1034","2","1","1176.67","0","1176.67","2018-04-16","2018-05-31","","1","1");
INSERT INTO contas_receber VALUES("11059","4","1034","3","1","1176.66","0","1176.66","2018-04-16","2018-06-16","","1","1");
INSERT INTO contas_receber VALUES("11060","4","1034","1","1","1176.67","0","1176.67","2018-04-16","2018-05-16","","1","1");
INSERT INTO contas_receber VALUES("11061","8","1036","1","1","476","0","476","2018-04-16","2018-05-16","","1","1");
INSERT INTO contas_receber VALUES("11062","8","1036","2","1","476","0","476","2018-04-16","2018-05-31","","1","1");
INSERT INTO contas_receber VALUES("11063","8","1036","3","1","476","0","476","2018-04-16","2018-06-16","","1","1");
INSERT INTO contas_receber VALUES("11064","60","1046","1","1","523","0","523","2018-04-16","2018-05-16","","1","1");
INSERT INTO contas_receber VALUES("11065","60","1046","2","1","523","0","523","2018-04-16","2018-05-31","","1","1");
INSERT INTO contas_receber VALUES("11066","60","1046","3","1","523","0","523","2018-04-16","2018-06-16","","1","1");
INSERT INTO contas_receber VALUES("11067","241","1029","1","1","537.05","0","537.05","2018-04-16","2018-05-17","","1","1");
INSERT INTO contas_receber VALUES("11068","241","1029","2","1","537.05","0","537.05","2018-04-16","2018-06-01","","1","1");
INSERT INTO contas_receber VALUES("11069","241","1029","3","1","537.05","0","537.05","2018-04-16","2018-06-17","","1","1");
INSERT INTO contas_receber VALUES("11102","187","1037","1","1","403.3","0","403.3","2018-04-18","2018-05-17","","1","1");
INSERT INTO contas_receber VALUES("11103","187","1037","2","1","403.3","0","403.3","2018-04-18","2018-06-01","","1","1");
INSERT INTO contas_receber VALUES("11104","187","1037","3","1","403.3","0","403.3","2018-04-18","2018-06-17","","1","1");
INSERT INTO contas_receber VALUES("11105","317","1042","1","1","1635.6","0","1635.6","2018-04-18","2018-05-02","","1","1");
INSERT INTO contas_receber VALUES("11106","263","1047","2","1","687.87","0","687.87","2018-04-18","2018-04-30","","1","1");
INSERT INTO contas_receber VALUES("11107","263","1047","1","1","687.88","0","687.88","2018-04-18","2018-04-30","","1","1");
INSERT INTO contas_receber VALUES("11108","42","1045","1","1","743.33","0","743.33","2018-04-18","2018-05-18","","1","1");
INSERT INTO contas_receber VALUES("11109","42","1045","3","1","743.34","0","743.34","2018-04-18","2018-06-18","","1","1");
INSERT INTO contas_receber VALUES("11110","42","1045","2","1","743.33","0","743.33","2018-04-18","2018-06-02","","1","1");
INSERT INTO contas_receber VALUES("11111","284","1068","2","1","557.4","0","557.4","2018-04-18","2018-06-03","","1","1");
INSERT INTO contas_receber VALUES("11112","284","1068","1","1","557.4","0","557.4","2018-04-18","2018-05-19","","1","1");
INSERT INTO contas_receber VALUES("11113","284","1068","3","1","557.4","0","557.4","2018-04-18","2018-06-19","","1","1");
INSERT INTO contas_receber VALUES("11134","31","1060","1","1","345.53","345.53","0","2018-04-19","2018-04-13","","0","1");
INSERT INTO contas_receber VALUES("11135","31","1060","2","1","345.54","345.54","0","2018-04-19","2018-05-14","","0","1");
INSERT INTO contas_receber VALUES("11167","7","1048","1","1","152.6","0","152.6","2018-04-20","2018-06-04","","1","1");
INSERT INTO contas_receber VALUES("11168","243","1050","1","1","885.73","0","885.73","2018-04-20","2018-05-23","","1","1");
INSERT INTO contas_receber VALUES("11169","243","1050","2","1","885.73","0","885.73","2018-04-20","2018-06-07","","1","1");
INSERT INTO contas_receber VALUES("11170","243","1050","3","1","885.74","0","885.74","2018-04-20","2018-06-23","","1","1");
INSERT INTO contas_receber VALUES("11171","318","1051","1","1","222.7","0","222.7","2018-04-20","2018-05-24","","1","1");
INSERT INTO contas_receber VALUES("11172","318","1051","2","1","222.7","0","222.7","2018-04-20","2018-06-24","","1","1");
INSERT INTO contas_receber VALUES("11173","212","1052","1","1","919.97","0","919.97","2018-04-20","2018-05-24","","1","1");
INSERT INTO contas_receber VALUES("11174","212","1052","2","1","919.97","0","919.97","2018-04-20","2018-06-08","","1","1");
INSERT INTO contas_receber VALUES("11175","212","1052","3","1","919.98","0","919.98","2018-04-20","2018-06-24","","1","1");
INSERT INTO contas_receber VALUES("11176","31","1085","2","1","363.07","0","363.07","2018-04-20","2018-06-26","","1","1");
INSERT INTO contas_receber VALUES("11177","31","1085","1","1","328","0","328","2018-04-20","2018-05-26","","1","1");
INSERT INTO contas_receber VALUES("11178","20","1053","1","1","348.69","0","348.69","2018-04-20","2018-05-26","","1","1");
INSERT INTO contas_receber VALUES("11179","20","1053","2","1","348.69","0","348.69","2018-04-20","2018-06-11","","1","1");
INSERT INTO contas_receber VALUES("11180","20","1053","3","1","348.7","0","348.7","2018-04-20","2018-06-26","","1","1");
INSERT INTO contas_receber VALUES("11181","292","1079","1","1","396","0","396","2018-04-20","2018-05-23","","1","1");
INSERT INTO contas_receber VALUES("11182","292","1079","2","1","396","0","396","2018-04-20","2018-06-02","","1","1");
INSERT INTO contas_receber VALUES("11183","292","1079","3","1","396","0","396","2018-04-20","2018-06-23","","1","1");
INSERT INTO contas_receber VALUES("11188","174","1088","1","1","424.88","424.88","0","2018-04-20","2018-04-21","","0","0");
INSERT INTO contas_receber VALUES("11189","174","1088","2","1","424.88","424.88","0","2018-04-20","2018-05-22","","0","0");
INSERT INTO contas_receber VALUES("11190","174","1088","3","1","424.88","424.88","0","2018-04-20","2018-06-22","","0","0");
INSERT INTO contas_receber VALUES("11191","174","1088","4","1","424.86","424.86","0","2018-04-20","2018-07-23","","0","0");
INSERT INTO contas_receber VALUES("11292","220","1074","1","1","1502.7","0","1502.7","2018-04-23","2018-05-26","","1","1");
INSERT INTO contas_receber VALUES("11293","220","1074","2","1","1502.7","0","1502.7","2018-04-23","2018-06-10","","1","1");
INSERT INTO contas_receber VALUES("11294","220","1074","4","1","139.8","0","139.8","2018-04-23","2018-05-30","","1","1");
INSERT INTO contas_receber VALUES("11295","220","1074","3","1","1502.7","0","1502.7","2018-04-23","2018-06-26","","1","1");
INSERT INTO contas_receber VALUES("11296","98","1049","1","1","966","0","966","2018-04-24","2018-05-23","","1","1");
INSERT INTO contas_receber VALUES("11297","98","1049","2","1","966","0","966","2018-04-24","2018-06-07","","1","1");
INSERT INTO contas_receber VALUES("11298","98","1049","3","1","966","0","966","2018-04-24","2018-06-23","","1","1");
INSERT INTO contas_receber VALUES("11299","261","1055","1","1","267.8","0","267.8","2018-04-24","2018-05-25","","1","1");
INSERT INTO contas_receber VALUES("11300","261","1055","2","1","267.8","0","267.8","2018-04-24","2018-06-09","","1","1");
INSERT INTO contas_receber VALUES("11301","261","1055","3","1","267.8","0","267.8","2018-04-24","2018-06-25","","1","1");
INSERT INTO contas_receber VALUES("11302","33","1075","1","1","1792.4","0","1792.4","2018-04-24","2018-04-30","","1","1");
INSERT INTO contas_receber VALUES("11367","322","1062","1","1","382","0","382","2018-04-25","2018-05-26","","1","1");
INSERT INTO contas_receber VALUES("11368","322","1062","2","1","382","0","382","2018-04-25","2018-06-11","","1","1");
INSERT INTO contas_receber VALUES("11369","322","1062","3","1","382","0","382","2018-04-25","2018-06-26","","1","1");
INSERT INTO contas_receber VALUES("11370","5","1058","1","1","366.2","0","366.2","2018-04-25","2018-05-25","","1","1");
INSERT INTO contas_receber VALUES("11371","5","1058","3","1","366.2","0","366.2","2018-04-25","2018-06-25","","1","1");
INSERT INTO contas_receber VALUES("11372","5","1058","2","1","366.2","0","366.2","2018-04-25","2018-06-09","","1","1");
INSERT INTO contas_receber VALUES("11373","43","1066","1","1","218.13","0","218.13","2018-04-25","2018-05-26","","1","1");
INSERT INTO contas_receber VALUES("11374","43","1066","3","1","218.14","0","218.14","2018-04-25","2018-06-26","","1","1");
INSERT INTO contas_receber VALUES("11375","43","1066","2","1","218.13","0","218.13","2018-04-25","2018-06-10","","1","1");
INSERT INTO contas_receber VALUES("11376","46","1080","1","1","306.72","0","306.72","2018-04-25","2018-05-25","","1","1");
INSERT INTO contas_receber VALUES("11377","162","1069","1","1","399.83","0","399.83","2018-04-25","2018-05-30","","1","1");
INSERT INTO contas_receber VALUES("11378","162","1069","3","1","399.84","0","399.84","2018-04-25","2018-06-30","","1","1");
INSERT INTO contas_receber VALUES("11379","162","1069","2","1","399.83","0","399.83","2018-04-25","2018-06-14","","1","1");
INSERT INTO contas_receber VALUES("11380","320","1070","1","1","1160","0","1160","2018-04-25","2018-05-11","","1","1");
INSERT INTO contas_receber VALUES("11383","325","1102","1","1","200.07","0","200.07","2018-04-25","2018-04-27","","1","1");
INSERT INTO contas_receber VALUES("11406","67","1056","1","1","279.63","279.63","0","2018-04-26","2018-05-25","","0","1");
INSERT INTO contas_receber VALUES("11407","67","1056","2","1","279.63","279.63","0","2018-04-26","2018-06-09","","0","1");
INSERT INTO contas_receber VALUES("11408","67","1056","3","1","279.64","279.64","0","2018-04-26","2018-06-25","","0","1");
INSERT INTO contas_receber VALUES("11409","252","1059","1","1","584","0","584","2018-04-26","2018-05-26","","1","1");
INSERT INTO contas_receber VALUES("11410","252","1059","2","1","584","0","584","2018-04-26","2018-06-10","","1","1");
INSERT INTO contas_receber VALUES("11411","252","1059","3","1","584","0","584","2018-04-26","2018-06-26","","1","1");
INSERT INTO contas_receber VALUES("11412","28","1063","1","1","60.79","0","60.79","2018-04-26","2018-04-14","","1","1");
INSERT INTO contas_receber VALUES("11413","28","1083","1","1","294.3","0","294.3","2018-04-26","2018-04-20","","1","1");
INSERT INTO contas_receber VALUES("11434","67","1104","2","1","299.63","0","299.63","2018-04-26","2018-06-09","","1","1");
INSERT INTO contas_receber VALUES("11435","67","1104","1","1","299.63","0","299.63","2018-04-26","2018-05-25","","1","1");
INSERT INTO contas_receber VALUES("11436","67","1104","3","1","299.63","0","299.63","2018-04-26","2018-06-25","","1","1");
INSERT INTO contas_receber VALUES("11437","67","1104","4","1","224.21","0","224.21","2018-04-26","2018-05-30","","1","1");
INSERT INTO contas_receber VALUES("11472","199","1073","1","1","359.39","0","359.39","2018-04-27","2018-06-10","","1","1");
INSERT INTO contas_receber VALUES("11473","199","1073","3","1","359.38","0","359.38","2018-04-27","2018-08-10","","1","1");
INSERT INTO contas_receber VALUES("11474","199","1073","2","1","359.39","0","359.39","2018-04-27","2018-07-10","","1","1");
INSERT INTO contas_receber VALUES("11483","33","1101","1","1","1464","1464","0","2018-04-27","2018-04-27","","0","1");
INSERT INTO contas_receber VALUES("11486","8","1094","1","1","249","0","249","2018-04-27","2018-05-30","","1","1");
INSERT INTO contas_receber VALUES("11487","31","1095","1","1","305","0","305","2018-04-27","2018-05-30","","1","1");
INSERT INTO contas_receber VALUES("11488","31","1095","2","1","305","0","305","2018-04-27","2018-06-14","","1","1");
INSERT INTO contas_receber VALUES("11489","31","1095","3","1","305","0","305","2018-04-27","2018-06-30","","1","1");
INSERT INTO contas_receber VALUES("11501","313","1107","2","1","871.33","871.33","0","2018-04-27","2018-05-31","","0","0");
INSERT INTO contas_receber VALUES("11502","313","1107","1","1","871.33","871.33","0","2018-04-27","2018-04-30","","0","0");
INSERT INTO contas_receber VALUES("11503","313","1107","3","1","871.34","871.34","0","2018-04-27","2018-07-01","","0","0");
INSERT INTO contas_receber VALUES("11513","292","1096","1","1","552","0","552","2018-04-27","2018-05-30","","1","1");
INSERT INTO contas_receber VALUES("11514","292","1096","2","1","552","0","552","2018-04-27","2018-06-14","","1","1");
INSERT INTO contas_receber VALUES("11515","292","1096","3","1","552","0","552","2018-04-27","2018-06-30","","1","1");
INSERT INTO contas_receber VALUES("11516","206","1028","1","1","200.4","0","200.4","2018-04-28","2018-03-31","","1","1");
INSERT INTO contas_receber VALUES("11537","4","1065","1","1","1224.67","0","1224.67","2018-04-30","2018-06-02","","1","1");
INSERT INTO contas_receber VALUES("11538","4","1065","2","1","1224.67","0","1224.67","2018-04-30","2018-06-17","","1","1");
INSERT INTO contas_receber VALUES("11539","4","1065","3","0","1224.66","0","1224.66","2018-04-30","2018-07-02","","1","1");
INSERT INTO contas_receber VALUES("11544","234","1089","1","1","450.14","0","450.14","2018-04-30","2018-05-30","","1","1");
INSERT INTO contas_receber VALUES("11545","234","1089","4","1","450.13","0","450.13","2018-04-30","2018-07-15","","1","1");
INSERT INTO contas_receber VALUES("11546","234","1089","2","1","450.14","0","450.14","2018-04-30","2018-06-14","","1","1");
INSERT INTO contas_receber VALUES("11547","234","1089","3","1","450.14","0","450.14","2018-04-30","2018-06-30","","1","1");
INSERT INTO contas_receber VALUES("11548","41","1067","1","1","728.14","0","728.14","2018-05-02","2018-06-04","","1","1");
INSERT INTO contas_receber VALUES("11549","41","1067","4","1","728.14","0","728.14","2018-05-02","2018-07-17","","1","1");
INSERT INTO contas_receber VALUES("11550","41","1067","3","1","728.14","0","728.14","2018-05-02","2018-07-04","","1","1");
INSERT INTO contas_receber VALUES("11551","41","1067","5","1","728.14","0","728.14","2018-05-02","2018-08-04","","1","1");
INSERT INTO contas_receber VALUES("11552","41","1067","2","1","728.14","0","728.14","2018-05-02","2018-06-17","","1","1");
INSERT INTO contas_receber VALUES("11553","220","1078","2","1","1862.5","0","1862.5","2018-05-02","2018-06-10","","1","1");
INSERT INTO contas_receber VALUES("11554","220","1078","1","1","1862.5","0","1862.5","2018-05-02","2018-05-26","","1","1");
INSERT INTO contas_receber VALUES("11555","220","1078","3","1","1862.5","0","1862.5","2018-05-02","2018-06-26","","1","1");
INSERT INTO contas_receber VALUES("11556","176","1112","1","1","664.5","0","664.5","2018-05-02","2018-06-02","","1","1");
INSERT INTO contas_receber VALUES("11557","176","1112","2","1","664.5","0","664.5","2018-05-02","2018-07-02","","1","1");
INSERT INTO contas_receber VALUES("11566","3","1072","1","1","49.61","0","49.61","2018-05-02","2018-04-15","","1","1");
INSERT INTO contas_receber VALUES("11567","3","1081","1","1","70","0","70","2018-05-02","2018-04-20","","1","1");
INSERT INTO contas_receber VALUES("11574","122","1082","1","1","406.88","0","406.88","2018-05-02","2018-06-03","","1","1");
INSERT INTO contas_receber VALUES("11575","122","1082","2","1","406.87","0","406.87","2018-05-02","2018-07-03","","1","1");
INSERT INTO contas_receber VALUES("11580","202","1116","1","1","1081.9","1081.9","0","2018-05-02","2018-05-05","","0","1");
INSERT INTO contas_receber VALUES("11581","202","1116","2","1","1081.9","1081.9","0","2018-05-02","2018-06-05","","0","1");
INSERT INTO contas_receber VALUES("11632","324","1092","1","1","340.65","0","340.65","2018-05-04","2018-06-08","","1","1");
INSERT INTO contas_receber VALUES("11633","324","1092","2","1","340.65","0","340.65","2018-05-04","2018-07-08","","1","1");
INSERT INTO contas_receber VALUES("11634","284","1103","1","1","676.8","0","676.8","2018-05-04","2018-06-07","","1","1");
INSERT INTO contas_receber VALUES("11635","284","1103","2","1","676.8","0","676.8","2018-05-04","2018-07-07","","1","1");
INSERT INTO contas_receber VALUES("11636","292","1097","2","1","552","0","552","2018-05-04","2018-06-23","","1","1");
INSERT INTO contas_receber VALUES("11637","292","1097","1","1","552","0","552","2018-05-04","2018-06-08","","1","1");
INSERT INTO contas_receber VALUES("11638","292","1097","3","1","552","0","552","2018-05-04","2018-07-08","","1","1");
INSERT INTO contas_receber VALUES("11643","47","1076","1","1","471.03","0","471.03","2018-05-07","2018-06-02","","1","1");
INSERT INTO contas_receber VALUES("11644","47","1076","2","1","471.03","0","471.03","2018-05-07","2018-06-17","","1","1");
INSERT INTO contas_receber VALUES("11645","47","1076","3","1","471.04","0","471.04","2018-05-07","2018-07-02","","1","1");
INSERT INTO contas_receber VALUES("11646","192","1077","1","1","1225","0","1225","2018-05-07","2018-05-30","","1","1");
INSERT INTO contas_receber VALUES("11647","323","1086","1","1","372.79","0","372.79","2018-05-07","2018-06-02","","1","1");
INSERT INTO contas_receber VALUES("11648","323","1086","2","1","372.79","0","372.79","2018-05-07","2018-06-17","","1","1");
INSERT INTO contas_receber VALUES("11649","323","1086","3","1","372.79","0","372.79","2018-05-07","2018-07-02","","1","1");
INSERT INTO contas_receber VALUES("11650","303","1084","1","1","585.33","0","585.33","2018-05-07","2018-06-02","","1","1");
INSERT INTO contas_receber VALUES("11651","303","1084","2","1","585.33","0","585.33","2018-05-07","2018-06-17","","1","1");
INSERT INTO contas_receber VALUES("11652","303","1084","3","1","585.33","0","585.33","2018-05-07","2018-07-02","","1","1");
INSERT INTO contas_receber VALUES("11653","303","1084","4","1","213.61","0","213.61","2018-05-07","2018-06-25","","1","1");
INSERT INTO contas_receber VALUES("11688","84","1091","1","1","830.95","0","830.95","2018-05-08","2018-06-08","","1","1");
INSERT INTO contas_receber VALUES("11689","84","1091","2","1","830.95","0","830.95","2018-05-08","2018-06-23","","1","1");
INSERT INTO contas_receber VALUES("11690","84","1091","3","1","830.95","0","830.95","2018-05-08","2018-07-08","","1","1");
INSERT INTO contas_receber VALUES("11691","206","1109","1","1","306.25","0","306.25","2018-05-08","2018-06-03","","1","1");
INSERT INTO contas_receber VALUES("11692","328","1125","1","1","221.17","0","221.17","2018-05-08","2018-06-04","","1","1");
INSERT INTO contas_receber VALUES("11693","23","1087","1","1","1041.63","0","1041.63","2018-05-08","2018-06-03","","1","1");
INSERT INTO contas_receber VALUES("11694","23","1087","2","1","1041.63","0","1041.63","2018-05-08","2018-06-18","","1","1");
INSERT INTO contas_receber VALUES("11695","23","1087","3","1","1041.64","0","1041.64","2018-05-08","2018-07-03","","1","1");
INSERT INTO contas_receber VALUES("11728","331","1134","1","1","1253.17","1253.17","0","2018-05-09","2018-05-12","","0","0");
INSERT INTO contas_receber VALUES("11729","331","1134","2","1","1253.17","1253.17","0","2018-05-09","2018-06-12","","0","0");
INSERT INTO contas_receber VALUES("11730","331","1134","3","1","1253.16","1253.16","0","2018-05-09","2018-07-13","","0","0");
INSERT INTO contas_receber VALUES("11745","309","1120","1","1","236.4","0","236.4","2018-05-09","2018-06-09","","1","1");
INSERT INTO contas_receber VALUES("11746","309","1120","2","1","236.4","0","236.4","2018-05-09","2018-07-09","","1","1");
INSERT INTO contas_receber VALUES("11761","32","1115","1","1","129.58","0","129.58","2018-05-09","2018-05-04","","1","1");
INSERT INTO contas_receber VALUES("11765","3","1114","1","1","42.29","0","42.29","2018-05-09","2018-05-04","","1","1");
INSERT INTO contas_receber VALUES("11785","332","1138","1","1","1048.43","1048.43","0","2018-05-09","2018-05-12","","0","0");
INSERT INTO contas_receber VALUES("11786","332","1138","2","1","1048.43","1048.43","0","2018-05-09","2018-06-12","","0","0");
INSERT INTO contas_receber VALUES("11787","332","1138","3","1","1048.44","1048.44","0","2018-05-09","2018-07-13","","0","0");
INSERT INTO contas_receber VALUES("11839","86","1093","2","1","434","0","434","2018-05-11","2018-06-26","","1","1");
INSERT INTO contas_receber VALUES("11840","86","1093","1","1","434","0","434","2018-05-11","2018-06-11","","1","1");
INSERT INTO contas_receber VALUES("11841","86","1093","3","1","434","0","434","2018-05-11","2018-07-11","","1","1");
INSERT INTO contas_receber VALUES("11842","21","1090","1","1","2025.8","0","2025.8","2018-05-11","2018-05-28","","1","1");
INSERT INTO contas_receber VALUES("11843","21","1090","2","1","2025.8","0","2025.8","2018-05-11","2018-06-17","","1","1");
INSERT INTO contas_receber VALUES("11844","21","1090","3","1","2025.8","0","2025.8","2018-05-11","2018-07-07","","1","1");
INSERT INTO contas_receber VALUES("11845","21","1090","4","1","2025.8","0","2025.8","2018-05-11","2018-07-22","","1","1");
INSERT INTO contas_receber VALUES("11846","21","1090","5","1","2025.8","0","2025.8","2018-05-11","2018-08-06","","1","1");
INSERT INTO contas_receber VALUES("11863","22","1098","1","1","911.25","0","911.25","2018-05-15","2018-06-11","","1","1");
INSERT INTO contas_receber VALUES("11864","22","1098","3","1","911.25","0","911.25","2018-05-15","2018-07-11","","1","1");
INSERT INTO contas_receber VALUES("11865","22","1098","2","1","911.25","0","911.25","2018-05-15","2018-06-26","","1","1");
INSERT INTO contas_receber VALUES("11866","292","1133","2","1","400.9","0","400.9","2018-05-15","2018-06-29","","1","1");
INSERT INTO contas_receber VALUES("11867","292","1133","1","1","400.9","0","400.9","2018-05-15","2018-06-14","","1","1");
INSERT INTO contas_receber VALUES("11868","292","1133","3","1","400.9","0","400.9","2018-05-15","2018-07-14","","1","1");
INSERT INTO contas_receber VALUES("11869","195","1121","1","1","219.5","0","219.5","2018-05-15","2018-06-17","","1","1");
INSERT INTO contas_receber VALUES("11870","179","1122","2","1","311.67","0","311.67","2018-05-15","2018-07-02","","1","1");
INSERT INTO contas_receber VALUES("11871","179","1122","1","1","311.67","0","311.67","2018-05-15","2018-06-17","","1","1");
INSERT INTO contas_receber VALUES("11872","179","1122","3","1","311.66","0","311.66","2018-05-15","2018-07-17","","1","1");
INSERT INTO contas_receber VALUES("11873","31","1119","1","1","480.4","0","480.4","2018-05-15","2018-06-16","","1","1");
INSERT INTO contas_receber VALUES("11874","31","1119","2","1","480.4","0","480.4","2018-05-15","2018-07-01","","1","1");
INSERT INTO contas_receber VALUES("11875","31","1119","3","1","480.4","0","480.4","2018-05-15","2018-07-16","","1","1");
INSERT INTO contas_receber VALUES("11926","3","1136","1","1","230.32","0","230.32","2018-05-16","2018-05-12","","1","1");
INSERT INTO contas_receber VALUES("11943","291","1111","2","1","389.5","0","389.5","2018-05-16","2018-07-17","","1","1");
INSERT INTO contas_receber VALUES("11944","291","1111","1","1","389.5","0","389.5","2018-05-16","2018-06-17","","1","1");
INSERT INTO contas_receber VALUES("11948","33","1106","2","1","967.2","0","967.2","2018-05-16","2018-05-21","","1","1");
INSERT INTO contas_receber VALUES("11949","33","1106","1","1","483.6","0","483.6","2018-05-16","2018-05-21","","1","1");
INSERT INTO contas_receber VALUES("11950","33","1106","3","1","201.2","0","201.2","2018-05-16","2018-05-21","","1","1");
INSERT INTO contas_receber VALUES("11966","292","1156","1","1","2384","2384","0","2018-05-17","2018-05-19","","0","0");
INSERT INTO contas_receber VALUES("11967","292","1156","3","1","2384","2384","0","2018-05-17","2018-07-20","","0","0");
INSERT INTO contas_receber VALUES("11968","292","1156","2","1","2384","2384","0","2018-05-17","2018-06-19","","0","0");
INSERT INTO contas_receber VALUES("11969","200","1118","1","1","639.4","0","639.4","2018-05-17","2018-06-18","","1","1");
INSERT INTO contas_receber VALUES("11970","200","1118","2","1","639.4","0","639.4","2018-05-17","2018-07-03","","1","1");
INSERT INTO contas_receber VALUES("11971","200","1118","3","1","639.39","0","639.39","2018-05-17","2018-07-18","","1","1");
INSERT INTO contas_receber VALUES("11975","308","1143","1","1","1352.97","1352.97","0","2018-05-17","2018-05-18","","0","0");
INSERT INTO contas_receber VALUES("11976","308","1143","2","1","1352.97","1352.97","0","2018-05-17","2018-06-18","","0","0");
INSERT INTO contas_receber VALUES("11977","308","1143","3","1","1352.96","1352.96","0","2018-05-17","2018-07-19","","0","0");
INSERT INTO contas_receber VALUES("12043","108","1127","1","1","858.83","0","858.83","2018-05-18","2018-06-21","","1","1");
INSERT INTO contas_receber VALUES("12044","108","1127","2","1","858.83","0","858.83","2018-05-18","2018-07-06","","1","1");
INSERT INTO contas_receber VALUES("12045","108","1127","3","1","858.84","0","858.84","2018-05-18","2018-07-21","","1","1");
INSERT INTO contas_receber VALUES("12060","96","1137","1","1","77","0","77","2018-05-18","2018-05-12","","1","1");
INSERT INTO contas_receber VALUES("12061","96","1154","1","1","121","0","121","2018-05-18","2018-06-16","","1","1");
INSERT INTO contas_receber VALUES("12092","70","1110","2","1","601.35","0","601.35","2018-05-18","2018-05-25","","1","1");
INSERT INTO contas_receber VALUES("12093","70","1110","1","1","601.35","0","601.35","2018-05-18","2018-05-25","","1","1");
INSERT INTO contas_receber VALUES("12098","24","1099","1","1","644.38","0","644.38","2018-05-18","2018-05-28","","1","1");
INSERT INTO contas_receber VALUES("12099","24","1099","2","1","644.37","0","644.37","2018-05-18","2018-05-28","","1","1");
INSERT INTO contas_receber VALUES("12100","202","1117","1","1","1055.65","0","1055.65","2018-05-18","2018-05-29","","1","1");
INSERT INTO contas_receber VALUES("12101","202","1117","2","1","1055.65","0","1055.65","2018-05-18","2018-05-29","","1","1");
INSERT INTO contas_receber VALUES("12102","19","1113","2","1","349.95","0","349.95","2018-05-18","2018-07-17","","1","1");
INSERT INTO contas_receber VALUES("12103","19","1113","1","1","349.95","0","349.95","2018-05-18","2018-06-17","","1","1");
INSERT INTO contas_receber VALUES("12104","49","1108","1","1","378.53","0","378.53","2018-05-18","2018-06-14","","1","1");
INSERT INTO contas_receber VALUES("12105","49","1108","2","1","378.53","0","378.53","2018-05-18","2018-07-14","","1","1");
INSERT INTO contas_receber VALUES("12106","49","1108","3","1","378.54","0","378.54","2018-05-18","2018-08-14","","1","1");
INSERT INTO contas_receber VALUES("12118","29","1170","1","1","645.87","645.87","0","2018-05-21","2018-05-22","","0","0");
INSERT INTO contas_receber VALUES("12119","29","1170","2","1","645.87","645.87","0","2018-05-21","2018-06-22","","0","0");
INSERT INTO contas_receber VALUES("12120","29","1170","3","1","645.86","645.86","0","2018-05-21","2018-07-23","","0","0");
INSERT INTO contas_receber VALUES("12121","324","1139","1","1","404.4","0","404.4","2018-05-21","2018-06-22","","1","1");
INSERT INTO contas_receber VALUES("12122","324","1139","2","1","404.4","0","404.4","2018-05-21","2018-07-07","","1","1");
INSERT INTO contas_receber VALUES("12123","324","1139","3","1","404.4","0","404.4","2018-05-21","2018-07-22","","1","1");
INSERT INTO contas_receber VALUES("12130","326","1124","1","1","779.97","0","779.97","2018-05-22","2018-06-21","","1","1");
INSERT INTO contas_receber VALUES("12131","326","1124","2","1","779.97","0","779.97","2018-05-22","2018-07-21","","1","1");
INSERT INTO contas_receber VALUES("12132","326","1124","3","1","779.96","0","779.96","2018-05-22","2018-08-21","","1","1");
INSERT INTO contas_receber VALUES("12133","4","1100","1","1","1189.67","0","1189.67","2018-05-22","2018-06-14","","1","1");
INSERT INTO contas_receber VALUES("12134","4","1100","2","1","1189.67","0","1189.67","2018-05-22","2018-06-29","","1","1");
INSERT INTO contas_receber VALUES("12135","4","1100","3","1","1189.66","0","1189.66","2018-05-22","2018-07-14","","1","1");
INSERT INTO contas_receber VALUES("12136","174","1151","1","1","423","0","423","2018-05-22","2018-06-22","","1","1");
INSERT INTO contas_receber VALUES("12137","174","1151","3","0","423","0","423","2018-05-22","2018-07-22","","1","1");
INSERT INTO contas_receber VALUES("12138","174","1151","2","1","423","0","423","2018-05-22","2018-07-07","","1","1");
INSERT INTO contas_receber VALUES("12145","260","1017","1","1","81.01","0","81.01","2018-05-22","2018-03-28","","1","1");
INSERT INTO contas_receber VALUES("12176","238","1064","1","1","167.8","0","167.8","2018-05-22","2018-04-14","","1","1");
INSERT INTO contas_receber VALUES("12210","338","1180","1","1","1725.63","1725.63","0","2018-05-23","2018-05-24","","0","0");
INSERT INTO contas_receber VALUES("12211","338","1180","2","1","1725.63","1725.63","0","2018-05-23","2018-06-24","","0","0");
INSERT INTO contas_receber VALUES("12212","338","1180","3","1","1725.64","1725.64","0","2018-05-23","2018-07-25","","0","0");
INSERT INTO contas_receber VALUES("12231","220","1177","2","1","326","0","326","2018-05-25","2018-07-23","","1","1");
INSERT INTO contas_receber VALUES("12232","220","1177","1","1","326","0","326","2018-05-25","2018-06-23","","1","1");
INSERT INTO contas_receber VALUES("12247","335","1145","1","1","217.5","0","217.5","2018-05-28","2018-05-17","","1","1");
INSERT INTO contas_receber VALUES("12254","330","1128","1","1","2000","0","2000","2018-05-28","2018-05-30","","1","1");
INSERT INTO contas_receber VALUES("12255","330","1128","2","1","2000","0","2000","2018-05-28","2018-05-30","","1","1");
INSERT INTO contas_receber VALUES("12256","330","1128","3","1","4727.5","0","4727.5","2018-05-28","2018-07-10","","1","1");
INSERT INTO contas_receber VALUES("12269","3","1153","1","1","80.8","0","80.8","2018-05-29","2018-05-18","","1","1");
INSERT INTO contas_receber VALUES("12270","3","1186","1","1","82.8","0","82.8","2018-05-29","2018-05-31","","1","1");
INSERT INTO contas_receber VALUES("12271","245","1185","1","1","276.46","276.46","0","2018-05-29","2018-05-31","","0","1");
INSERT INTO contas_receber VALUES("12272","69","1132","1","1","556.3","0","556.3","2018-05-30","2018-06-07","","1","1");
INSERT INTO contas_receber VALUES("12273","69","1132","2","1","556.3","0","556.3","2018-05-30","2018-06-07","","1","1");
INSERT INTO contas_receber VALUES("12274","220","1148","1","1","3385.09","0","3385.09","2018-05-30","2018-06-28","","1","1");
INSERT INTO contas_receber VALUES("12275","220","1148","2","1","3385.09","0","3385.09","2018-05-30","2018-07-13","","1","1");
INSERT INTO contas_receber VALUES("12276","220","1148","3","1","3385.09","0","3385.09","2018-05-30","2018-07-28","","1","1");
INSERT INTO contas_receber VALUES("12277","337","1168","1","1","377.3","0","377.3","2018-05-30","2018-08-01","","1","1");
INSERT INTO contas_receber VALUES("12278","31","1163","1","1","418.77","0","418.77","2018-05-30","2018-06-23","","1","1");
INSERT INTO contas_receber VALUES("12279","31","1163","2","1","418.77","0","418.77","2018-05-30","2018-07-08","","1","1");
INSERT INTO contas_receber VALUES("12280","31","1163","3","1","418.76","0","418.76","2018-05-30","2018-07-23","","1","1");
INSERT INTO contas_receber VALUES("12281","156","1141","1","1","405.6","0","405.6","2018-05-30","2018-06-25","","1","1");
INSERT INTO contas_receber VALUES("12282","156","1141","3","1","405.6","0","405.6","2018-05-30","2018-07-25","","1","1");
INSERT INTO contas_receber VALUES("12283","156","1141","2","1","405.6","0","405.6","2018-05-30","2018-07-10","","1","1");
INSERT INTO contas_receber VALUES("12302","212","1131","1","1","704.1","0","704.1","2018-06-01","2018-06-24","","1","1");
INSERT INTO contas_receber VALUES("12303","212","1131","2","1","704.1","0","704.1","2018-06-01","2018-07-09","","1","1");
INSERT INTO contas_receber VALUES("12304","212","1131","3","1","704.1","0","704.1","2018-06-01","2018-07-24","","1","1");
INSERT INTO contas_receber VALUES("12305","212","1131","4","1","389","0","389","2018-06-01","2018-07-30","","1","1");
INSERT INTO contas_receber VALUES("12306","340","1189","1","1","187.92","0","187.92","2018-06-01","2018-07-01","","1","1");
INSERT INTO contas_receber VALUES("12307","340","1189","2","1","187.92","0","187.92","2018-06-01","2018-08-01","","1","1");
INSERT INTO contas_receber VALUES("12308","113","1155","1","1","399","0","399","2018-06-01","2018-07-07","","1","1");
INSERT INTO contas_receber VALUES("12309","113","1155","3","1","399","0","399","2018-06-01","2018-08-01","","1","1");
INSERT INTO contas_receber VALUES("12310","113","1155","2","1","399","0","399","2018-06-01","2018-07-16","","1","1");
INSERT INTO contas_receber VALUES("12323","253","1150","1","1","714.47","0","714.47","2018-06-01","2018-06-11","","1","1");
INSERT INTO contas_receber VALUES("12326","292","1164","1","1","901","0","901","2018-06-01","2018-07-01","","1","1");
INSERT INTO contas_receber VALUES("12327","292","1164","2","1","901","0","901","2018-06-01","2018-07-16","","1","1");
INSERT INTO contas_receber VALUES("12328","292","1164","3","1","901","0","901","2018-06-01","2018-08-01","","1","1");
INSERT INTO contas_receber VALUES("12352","25","1126","1","1","1454.03","0","1454.03","2018-06-05","2018-06-22","","1","1");
INSERT INTO contas_receber VALUES("12353","25","1126","2","1","1454.03","0","1454.03","2018-06-05","2018-07-07","","1","1");
INSERT INTO contas_receber VALUES("12354","25","1126","4","1","871.51","0","871.51","2018-06-05","2018-08-02","","1","1");
INSERT INTO contas_receber VALUES("12355","25","1126","3","1","1454.03","0","1454.03","2018-06-05","2018-07-22","","1","1");
INSERT INTO contas_receber VALUES("12360","47","1129","2","1","595.5","0","595.5","2018-06-05","2018-07-08","","1","1");
INSERT INTO contas_receber VALUES("12361","47","1129","1","1","595.5","0","595.5","2018-06-05","2018-06-23","","1","1");
INSERT INTO contas_receber VALUES("12362","47","1129","3","1","595.5","0","595.5","2018-06-05","2018-07-23","","1","1");
INSERT INTO contas_receber VALUES("12363","161","1130","1","1","688.03","0","688.03","2018-06-05","2018-06-25","","1","1");
INSERT INTO contas_receber VALUES("12364","161","1130","3","1","688.04","0","688.04","2018-06-05","2018-07-09","","1","1");
INSERT INTO contas_receber VALUES("12365","161","1130","2","1","688.03","0","688.03","2018-06-05","2018-07-02","","1","1");
INSERT INTO contas_receber VALUES("12366","3","1195","1","1","122.15","0","122.15","2018-06-05","2018-06-08","","1","1");
INSERT INTO contas_receber VALUES("12368","28","1146","1","1","174.13","0","174.13","2018-06-05","2018-05-18","","1","1");
INSERT INTO contas_receber VALUES("12369","22","1160","1","1","390","0","390","2018-06-06","2018-06-22","","1","1");
INSERT INTO contas_receber VALUES("12370","22","1160","2","1","390","0","390","2018-06-06","2018-07-07","","1","1");
INSERT INTO contas_receber VALUES("12371","22","1160","3","1","390","0","390","2018-06-06","2018-07-22","","1","1");
INSERT INTO contas_receber VALUES("12372","30","1147","1","1","486.23","0","486.23","2018-06-06","2018-06-29","","1","1");
INSERT INTO contas_receber VALUES("12373","30","1147","3","1","486.24","0","486.24","2018-06-06","2018-07-29","","1","1");
INSERT INTO contas_receber VALUES("12374","30","1147","2","1","486.23","0","486.23","2018-06-06","2018-07-14","","1","1");
INSERT INTO contas_receber VALUES("12375","44","1144","1","1","724.42","0","724.42","2018-06-06","2018-06-29","","1","1");
INSERT INTO contas_receber VALUES("12376","44","1144","2","1","724.42","0","724.42","2018-06-06","2018-07-14","","1","1");
INSERT INTO contas_receber VALUES("12377","44","1144","3","1","724.41","0","724.41","2018-06-06","2018-07-29","","1","1");
INSERT INTO contas_receber VALUES("12411","344","1203","1","1","1352.97","1352.97","0","2018-06-07","2018-06-08","","0","1");
INSERT INTO contas_receber VALUES("12412","344","1203","2","1","1352.97","1352.97","0","2018-06-07","2018-07-09","","0","1");
INSERT INTO contas_receber VALUES("12413","344","1203","3","1","1352.96","1352.96","0","2018-06-07","2018-08-09","","0","1");
INSERT INTO contas_receber VALUES("12414","344","1204","1","1","1352.97","0","1352.97","2018-06-07","2018-07-06","","1","1");
INSERT INTO contas_receber VALUES("12415","344","1204","2","1","1352.97","0","1352.97","2018-06-07","2018-07-21","","1","1");
INSERT INTO contas_receber VALUES("12416","344","1204","3","1","1352.96","0","1352.96","2018-06-07","2018-08-06","","1","1");
INSERT INTO contas_receber VALUES("12417","59","1159","1","1","424.8","0","424.8","2018-06-07","2018-07-05","","1","1");
INSERT INTO contas_receber VALUES("12418","59","1159","2","1","424.8","0","424.8","2018-06-07","2018-07-20","","1","1");
INSERT INTO contas_receber VALUES("12419","59","1159","3","1","424.8","0","424.8","2018-06-07","2018-08-05","","1","1");
INSERT INTO contas_receber VALUES("12420","292","1165","1","1","901","0","901","2018-06-07","2018-07-05","","1","1");
INSERT INTO contas_receber VALUES("12421","292","1165","3","1","901","0","901","2018-06-07","2018-08-05","","1","1");
INSERT INTO contas_receber VALUES("12422","292","1165","2","1","901","0","901","2018-06-07","2018-07-20","","1","1");
INSERT INTO contas_receber VALUES("12457","112","1209","1","1","36.81","36.81","0","2018-06-07","2018-06-08","","0","1");
INSERT INTO contas_receber VALUES("12458","112","1149","1","1","92.76","0","92.76","2018-06-07","2018-05-18","","1","1");
INSERT INTO contas_receber VALUES("12465","238","1176","1","1","276.75","0","276.75","2018-06-07","2018-05-25","","1","1");
INSERT INTO contas_receber VALUES("12482","336","1157","3","1","445.4","0","445.4","2018-06-11","2018-08-08","","1","1");
INSERT INTO contas_receber VALUES("12483","336","1157","1","1","445.4","0","445.4","2018-06-11","2018-07-08","","1","1");
INSERT INTO contas_receber VALUES("12484","336","1157","2","1","445.4","0","445.4","2018-06-11","2018-07-23","","1","1");
INSERT INTO contas_receber VALUES("12503","347","1215","1","1","1124","1124","0","2018-06-11","2018-06-13","","0","1");
INSERT INTO contas_receber VALUES("12518","179","1188","1","1","378.6","0","378.6","2018-06-11","2018-07-14","","1","1");
INSERT INTO contas_receber VALUES("12519","179","1188","2","1","378.6","0","378.6","2018-06-11","2018-08-14","","1","1");
INSERT INTO contas_receber VALUES("12537","83","1174","1","1","188.94","0","188.94","2018-06-12","2018-07-11","","1","1");
INSERT INTO contas_receber VALUES("12538","83","1174","2","1","188.93","0","188.93","2018-06-12","2018-08-11","","1","1");
INSERT INTO contas_receber VALUES("12539","322","1181","1","1","412.8","0","412.8","2018-06-12","2018-07-13","","1","1");
INSERT INTO contas_receber VALUES("12540","322","1181","2","1","412.8","0","412.8","2018-06-12","2018-07-28","","1","1");
INSERT INTO contas_receber VALUES("12541","322","1181","3","1","412.8","0","412.8","2018-06-12","2018-08-13","","1","1");
INSERT INTO contas_receber VALUES("12542","333","1140","2","1","620.15","0","620.15","2018-06-12","2018-07-14","","1","1");
INSERT INTO contas_receber VALUES("12543","333","1140","1","1","620.15","0","620.15","2018-06-12","2018-06-29","","1","1");
INSERT INTO contas_receber VALUES("12548","220","1182","1","1","475.04","0","475.04","2018-06-12","2018-07-13","","1","1");
INSERT INTO contas_receber VALUES("12549","220","1182","3","1","475.05","0","475.05","2018-06-12","2018-08-13","","1","1");
INSERT INTO contas_receber VALUES("12550","220","1182","2","1","475.04","0","475.04","2018-06-12","2018-07-28","","1","1");
INSERT INTO contas_receber VALUES("12551","5","1175","1","1","403","0","403","2018-06-12","2018-07-13","","1","1");
INSERT INTO contas_receber VALUES("12552","5","1175","2","1","403","0","403","2018-06-12","2018-07-29","","1","1");
INSERT INTO contas_receber VALUES("12553","5","1175","3","1","402.99","0","402.99","2018-06-12","2018-08-13","","1","1");
INSERT INTO contas_receber VALUES("12554","60","1172","1","1","731.6","0","731.6","2018-06-12","2018-07-13","","1","1");
INSERT INTO contas_receber VALUES("12555","60","1172","2","1","731.6","0","731.6","2018-06-12","2018-07-28","","1","1");
INSERT INTO contas_receber VALUES("12556","60","1172","3","1","731.6","0","731.6","2018-06-12","2018-08-13","","1","1");
INSERT INTO contas_receber VALUES("12557","316","1179","1","1","837.02","0","837.02","2018-06-12","2018-07-09","","1","1");
INSERT INTO contas_receber VALUES("12558","316","1179","2","1","837.03","0","837.03","2018-06-12","2018-07-16","","1","1");
INSERT INTO contas_receber VALUES("12565","343","1198","1","1","154.2","0","154.2","2018-06-12","2018-07-15","","1","1");
INSERT INTO contas_receber VALUES("12570","31","1205","1","1","302.46","0","302.46","2018-06-13","2018-07-15","","1","1");
INSERT INTO contas_receber VALUES("12571","31","1205","2","1","302.46","0","302.46","2018-06-13","2018-07-30","","1","1");
INSERT INTO contas_receber VALUES("12572","31","1205","3","1","302.48","0","302.48","2018-06-13","2018-08-15","","1","1");
INSERT INTO contas_receber VALUES("12573","31","1205","4","1","416.2","0","416.2","2018-06-13","2018-08-25","","1","1");
INSERT INTO contas_receber VALUES("12602","201","667","1","1","296.8","0","296.8","2018-06-13","2017-10-07","","1","1");
INSERT INTO contas_receber VALUES("12604","201","1225","1","1","130.2","130.2","0","2018-06-13","2018-06-14","","0","0");
INSERT INTO contas_receber VALUES("12615","62","1187","1","1","343.29","0","343.29","2018-06-14","2018-07-14","","1","1");
INSERT INTO contas_receber VALUES("12616","62","1187","2","1","343.29","0","343.29","2018-06-14","2018-07-29","","1","1");
INSERT INTO contas_receber VALUES("12617","62","1187","3","1","343.29","0","343.29","2018-06-14","2018-08-14","","1","1");
INSERT INTO contas_receber VALUES("12618","9","1162","1","1","797.17","0","797.17","2018-06-14","2018-07-11","","1","1");
INSERT INTO contas_receber VALUES("12619","9","1162","2","1","797.17","0","797.17","2018-06-14","2018-07-26","","1","1");
INSERT INTO contas_receber VALUES("12620","9","1162","3","1","797.16","0","797.16","2018-06-14","2018-08-11","","1","1");
INSERT INTO contas_receber VALUES("12621","129","1171","1","1","908","0","908","2018-06-14","2018-07-12","","1","1");
INSERT INTO contas_receber VALUES("12622","129","1171","3","1","908","0","908","2018-06-14","2018-08-12","","1","1");
INSERT INTO contas_receber VALUES("12623","129","1171","2","1","908","0","908","2018-06-14","2018-07-27","","1","1");
INSERT INTO contas_receber VALUES("12654","19","1190","1","1","336.81","0","336.81","2018-06-14","2018-07-14","","1","1");
INSERT INTO contas_receber VALUES("12655","19","1190","2","1","336.81","0","336.81","2018-06-14","2018-08-14","","1","1");
INSERT INTO contas_receber VALUES("12702","195","1194","1","1","200.2","0","200.2","2018-06-15","2018-07-20","","1","1");
INSERT INTO contas_receber VALUES("12706","243","1233","1","1","455.05","455.05","0","2018-06-15","2018-06-16","","0","0");
INSERT INTO contas_receber VALUES("12707","243","1233","2","1","455.05","455.05","0","2018-06-15","2018-07-17","","0","0");
INSERT INTO contas_receber VALUES("12708","243","1233","3","1","455.04","455.04","0","2018-06-15","2018-08-17","","0","0");
INSERT INTO contas_receber VALUES("12709","351","1228","1","1","236.16","0","236.16","2018-06-15","2018-06-16","","1","1");
INSERT INTO contas_receber VALUES("12710","339","1184","1","1","326","0","326","2018-06-15","2018-07-11","","1","1");
INSERT INTO contas_receber VALUES("12719","140","1183","1","1","400.2","0","400.2","2018-06-18","2018-07-14","","1","1");
INSERT INTO contas_receber VALUES("12720","140","1183","2","1","400.2","0","400.2","2018-06-18","2018-08-14","","1","1");
INSERT INTO contas_receber VALUES("12721","342","1197","1","1","350","0","350","2018-06-18","2018-06-07","","1","1");
INSERT INTO contas_receber VALUES("12722","342","1197","2","1","350","0","350","2018-06-18","2018-07-15","","1","1");
INSERT INTO contas_receber VALUES("12723","71","1193","1","1","395.33","0","395.33","2018-06-18","2018-07-15","","1","1");
INSERT INTO contas_receber VALUES("12724","71","1193","2","1","395.33","0","395.33","2018-06-18","2018-07-30","","1","1");
INSERT INTO contas_receber VALUES("12725","71","1193","3","1","395.34","0","395.34","2018-06-18","2018-08-15","","1","1");
INSERT INTO contas_receber VALUES("12734","323","1201","1","1","439.73","0","439.73","2018-06-18","2018-07-18","","1","1");
INSERT INTO contas_receber VALUES("12735","323","1201","2","1","439.73","0","439.73","2018-06-18","2018-08-02","","1","1");
INSERT INTO contas_receber VALUES("12736","323","1201","3","1","439.74","0","439.74","2018-06-18","2018-08-18","","1","1");
INSERT INTO contas_receber VALUES("12737","102","1196","1","1","105.16","105.16","0","2018-06-18","2018-07-18","","0","1");
INSERT INTO contas_receber VALUES("12776","3","1230","1","1","149.85","0","149.85","2018-06-20","2018-06-16","","1","1");
INSERT INTO contas_receber VALUES("12795","220","1200","1","1","2142.31","0","2142.31","2018-06-20","2018-07-18","","1","1");
INSERT INTO contas_receber VALUES("12796","220","1200","2","1","2142.31","0","2142.31","2018-06-20","2018-08-02","","1","1");
INSERT INTO contas_receber VALUES("12797","220","1200","3","1","2142.31","0","2142.31","2018-06-20","2018-08-18","","1","1");
INSERT INTO contas_receber VALUES("12798","220","1200","4","1","290.87","0","290.87","2018-06-20","2018-09-02","","1","1");
INSERT INTO contas_receber VALUES("12805","31","1223","2","1","303.34","0","303.34","2018-06-20","2018-08-02","","1","1");
INSERT INTO contas_receber VALUES("12806","31","1223","1","1","303.34","0","303.34","2018-06-20","2018-07-20","","1","1");
INSERT INTO contas_receber VALUES("12807","31","1223","3","1","303.35","0","303.35","2018-06-20","2018-08-20","","1","1");
INSERT INTO contas_receber VALUES("12871","292","1166","1","1","901","0","901","2018-06-21","2018-07-12","","1","1");
INSERT INTO contas_receber VALUES("12872","292","1166","2","1","901","0","901","2018-06-21","2018-07-27","","1","1");
INSERT INTO contas_receber VALUES("12873","292","1166","3","1","901","0","901","2018-06-21","2018-08-12","","1","1");
INSERT INTO contas_receber VALUES("12874","292","1229","1","1","297","0","297","2018-06-21","2018-07-20","","1","1");
INSERT INTO contas_receber VALUES("12875","292","1229","2","1","297","0","297","2018-06-21","2018-08-04","","1","1");
INSERT INTO contas_receber VALUES("12876","292","1229","3","1","297","0","297","2018-06-21","2018-08-20","","1","1");
INSERT INTO contas_receber VALUES("12883","84","1202","1","1","566.43","0","566.43","2018-06-21","2018-07-18","","1","1");
INSERT INTO contas_receber VALUES("12884","84","1202","2","1","566.43","0","566.43","2018-06-21","2018-08-02","","1","1");
INSERT INTO contas_receber VALUES("12885","84","1202","3","1","566.44","0","566.44","2018-06-21","2018-08-18","","1","1");
INSERT INTO contas_receber VALUES("12886","346","1213","1","1","1409.4","0","1409.4","2018-06-21","2018-06-10","","1","1");
INSERT INTO contas_receber VALUES("12887","255","1211","1","1","1546.3","0","1546.3","2018-06-21","2018-07-15","","1","1");
INSERT INTO contas_receber VALUES("12894","32","1135","1","1","259.75","0","259.75","2018-06-21","2018-05-11","","1","1");
INSERT INTO contas_receber VALUES("12895","32","1231","1","1","111.3","0","111.3","2018-06-21","2018-06-16","","1","1");
INSERT INTO contas_receber VALUES("12902","4","1158","2","1","1111.33","0","1111.33","2018-06-21","2018-07-23","","1","1");
INSERT INTO contas_receber VALUES("12903","4","1158","1","1","1111.33","0","1111.33","2018-06-21","2018-07-08","","1","1");
INSERT INTO contas_receber VALUES("12904","4","1158","3","1","1111.34","0","1111.34","2018-06-21","2018-08-08","","1","1");
INSERT INTO contas_receber VALUES("12913","205","1207","1","1","578.8","0","578.8","2018-06-22","2018-07-20","","1","1");
INSERT INTO contas_receber VALUES("12914","205","1207","2","1","578.8","0","578.8","2018-06-22","2018-08-04","","1","1");
INSERT INTO contas_receber VALUES("12915","205","1207","3","1","578.8","0","578.8","2018-06-22","2018-08-20","","1","1");
INSERT INTO contas_receber VALUES("12916","17","1217","1","1","755.17","0","755.17","2018-06-22","2018-07-25","","1","1");
INSERT INTO contas_receber VALUES("12917","17","1217","3","1","755.16","0","755.16","2018-06-22","2018-08-25","","1","1");
INSERT INTO contas_receber VALUES("12918","17","1217","2","1","755.17","0","755.17","2018-06-22","2018-08-09","","1","1");
INSERT INTO contas_receber VALUES("12919","101","1105","1","1","2106.08","0","2106.08","2018-06-22","2018-08-06","","1","1");
INSERT INTO contas_receber VALUES("12920","101","1105","2","1","2106.08","0","2106.08","2018-06-22","2018-07-02","","1","1");
INSERT INTO contas_receber VALUES("12921","101","1105","3","1","2106.09","0","2106.09","2018-06-22","2018-07-16","","1","1");
INSERT INTO contas_receber VALUES("12925","234","1220","1","1","414.53","0","414.53","2018-06-25","2018-07-26","","1","1");
INSERT INTO contas_receber VALUES("12926","234","1220","2","1","414.53","0","414.53","2018-06-25","2018-08-10","","1","1");
INSERT INTO contas_receber VALUES("12927","234","1220","3","1","414.54","0","414.54","2018-06-25","2018-08-26","","1","1");
INSERT INTO contas_receber VALUES("12928","215","1216","1","1","426.4","0","426.4","2018-06-25","2018-07-25","","1","1");
INSERT INTO contas_receber VALUES("12929","215","1216","3","1","426.4","0","426.4","2018-06-25","2018-08-25","","1","1");
INSERT INTO contas_receber VALUES("12930","215","1216","2","1","426.4","0","426.4","2018-06-25","2018-08-09","","1","1");
INSERT INTO contas_receber VALUES("12931","345","1210","1","1","430.7","0","430.7","2018-06-25","2018-07-21","","1","1");
INSERT INTO contas_receber VALUES("12932","345","1210","2","1","430.7","0","430.7","2018-06-25","2018-08-05","","1","1");
INSERT INTO contas_receber VALUES("12933","345","1210","3","1","430.7","0","430.7","2018-06-25","2018-08-21","","1","1");
INSERT INTO contas_receber VALUES("12956","355","1253","1","1","623.85","623.85","0","2018-06-25","2018-06-29","","0","0");
INSERT INTO contas_receber VALUES("12957","355","1253","2","1","623.85","623.85","0","2018-06-25","2018-07-30","","0","0");
INSERT INTO contas_receber VALUES("12962","7","1208","1","1","124.5","0","124.5","2018-06-26","2018-07-25","","1","1");
INSERT INTO contas_receber VALUES("12963","7","1208","2","1","124.5","0","124.5","2018-06-26","2018-08-25","","1","1");
INSERT INTO contas_receber VALUES("12964","347","1227","1","1","562","0","562","2018-06-26","2018-07-10","","1","1");
INSERT INTO contas_receber VALUES("12965","347","1227","2","1","562","0","562","2018-06-26","2018-07-10","","1","1");
INSERT INTO contas_receber VALUES("12966","309","1218","1","1","288.2","0","288.2","2018-06-26","2018-07-25","","1","1");
INSERT INTO contas_receber VALUES("12967","309","1218","2","1","288.2","0","288.2","2018-06-26","2018-08-09","","1","1");
INSERT INTO contas_receber VALUES("12968","309","1218","3","1","288.2","0","288.2","2018-06-26","2018-08-25","","1","1");
INSERT INTO contas_receber VALUES("12969","309","1218","4","1","122","0","122","2018-06-26","2018-08-30","","1","1");
INSERT INTO contas_receber VALUES("12970","353","1238","1","1","88.8","0","88.8","2018-06-26","2018-06-22","","1","1");
INSERT INTO contas_receber VALUES("12971","352","1235","1","1","496.8","0","496.8","2018-06-26","2018-08-03","","1","1");
INSERT INTO contas_receber VALUES("12972","4","1206","1","1","1273.33","0","1273.33","2018-06-26","2018-07-22","","1","1");
INSERT INTO contas_receber VALUES("12973","4","1206","2","1","1273.33","0","1273.33","2018-06-26","2018-08-06","","1","1");
INSERT INTO contas_receber VALUES("12974","4","1206","3","1","1273.34","0","1273.34","2018-06-26","2018-08-22","","1","1");
INSERT INTO contas_receber VALUES("12987","46","1247","1","1","223.92","0","223.92","2018-06-27","2018-07-29","","1","1");
INSERT INTO contas_receber VALUES("12988","46","1247","2","1","223.92","0","223.92","2018-06-27","2018-08-29","","1","1");
INSERT INTO contas_receber VALUES("12989","212","1239","1","1","915.77","0","915.77","2018-06-28","2018-08-03","","1","1");
INSERT INTO contas_receber VALUES("12990","212","1239","2","1","915.77","0","915.77","2018-06-28","2018-08-18","","1","1");
INSERT INTO contas_receber VALUES("12991","212","1239","3","1","915.76","0","915.76","2018-06-28","2018-09-03","","1","1");
INSERT INTO contas_receber VALUES("12992","68","1214","1","1","1358.8","0","1358.8","2018-06-28","2018-07-11","","1","1");
INSERT INTO contas_receber VALUES("12993","68","1214","2","1","1358.8","0","1358.8","2018-06-28","2018-07-11","","1","1");
INSERT INTO contas_receber VALUES("12994","68","1214","3","1","1358.8","0","1358.8","2018-06-28","2018-07-11","","1","1");
INSERT INTO contas_receber VALUES("13013","211","1222","1","1","404.17","0","404.17","2018-06-29","2018-08-02","","1","1");
INSERT INTO contas_receber VALUES("13014","211","1222","2","1","404.17","0","404.17","2018-06-29","2018-08-17","","1","1");
INSERT INTO contas_receber VALUES("13015","211","1222","3","1","404.16","0","404.16","2018-06-29","2018-09-02","","1","1");
INSERT INTO contas_receber VALUES("13018","3","1241","1","1","136.78","0","136.78","2018-06-29","2018-06-22","","1","1");
INSERT INTO contas_receber VALUES("13019","67","1237","1","1","346.6","346.6","0","2018-06-29","2018-06-21","","0","1");
INSERT INTO contas_receber VALUES("13020","67","1237","2","1","346.6","346.6","0","2018-06-29","2018-07-22","","0","1");
INSERT INTO contas_receber VALUES("13021","67","1237","3","1","346.6","346.6","0","2018-06-29","2018-08-22","","0","1");
INSERT INTO contas_receber VALUES("13044","31","1252","1","1","813.33","0","813.33","2018-06-29","2018-07-30","","1","1");
INSERT INTO contas_receber VALUES("13045","31","1252","2","1","813.33","0","813.33","2018-06-29","2018-08-14","","1","1");
INSERT INTO contas_receber VALUES("13046","31","1252","3","1","813.34","0","813.34","2018-06-29","2018-08-30","","1","1");
INSERT INTO contas_receber VALUES("13049","70","1243","1","1","891.65","0","891.65","2018-07-02","2018-07-20","","1","1");
INSERT INTO contas_receber VALUES("13050","70","1243","2","1","891.65","0","891.65","2018-07-02","2018-07-20","","1","1");
INSERT INTO contas_receber VALUES("13066","28","1251","1","0","507.39","0","507.39","2018-07-03","2018-06-29","","1","1");
INSERT INTO contas_receber VALUES("13067","28","1251","2","1","507.42","0","507.42","2018-07-03","2018-07-29","","1","1");
INSERT INTO contas_receber VALUES("13068","67","1259","1","1","414.4","0","414.4","2018-07-03","2018-08-03","","1","1");
INSERT INTO contas_receber VALUES("13069","67","1259","2","1","414.4","0","414.4","2018-07-03","2018-09-03","","1","1");
INSERT INTO contas_receber VALUES("13070","67","1259","3","0","211","0","211","2018-07-03","2018-08-18","","1","1");
INSERT INTO contas_receber VALUES("13071","30","1219","1","1","825.32","0","825.32","2018-07-03","2018-07-28","","1","1");
INSERT INTO contas_receber VALUES("13072","30","1219","2","1","825.32","0","825.32","2018-07-03","2018-08-07","","1","1");
INSERT INTO contas_receber VALUES("13073","30","1219","3","1","825.32","0","825.32","2018-07-03","2018-08-17","","1","1");
INSERT INTO contas_receber VALUES("13074","30","1219","4","1","825.32","0","825.32","2018-07-03","2018-08-27","","1","1");
INSERT INTO contas_receber VALUES("13075","30","1219","5","1","825.33","0","825.33","2018-07-03","2018-09-11","","1","1");
INSERT INTO contas_receber VALUES("13079","122","1267","1","1","446.9","446.9","0","2018-07-03","2018-07-04","","0","0");
INSERT INTO contas_receber VALUES("13080","122","1267","2","1","446.9","446.9","0","2018-07-03","2018-08-04","","0","0");
INSERT INTO contas_receber VALUES("13081","122","1267","3","1","446.9","446.9","0","2018-07-03","2018-09-04","","0","0");
INSERT INTO contas_receber VALUES("13085","122","1268","1","1","338.73","338.73","0","2018-07-03","2018-07-04","","0","0");
INSERT INTO contas_receber VALUES("13086","122","1268","2","1","338.73","338.73","0","2018-07-03","2018-08-04","","0","0");
INSERT INTO contas_receber VALUES("13087","122","1268","3","1","338.74","338.74","0","2018-07-03","2018-09-04","","0","0");
INSERT INTO contas_receber VALUES("13122","349","1226","1","1","461.37","0","461.37","2018-07-04","2018-07-30","","1","1");
INSERT INTO contas_receber VALUES("13123","349","1226","2","1","461.37","0","461.37","2018-07-04","2018-08-06","","1","1");
INSERT INTO contas_receber VALUES("13124","349","1226","3","1","461.37","0","461.37","2018-07-04","2018-08-13","","1","1");
INSERT INTO contas_receber VALUES("13125","349","1226","4","1","461.35","0","461.35","2018-07-04","2018-09-20","","1","1");
INSERT INTO contas_receber VALUES("13126","344","1221","1","1","1122.6","0","1122.6","2018-07-04","2018-07-29","","1","1");
INSERT INTO contas_receber VALUES("13127","344","1221","2","1","1122.6","0","1122.6","2018-07-04","2018-08-13","","1","1");
INSERT INTO contas_receber VALUES("13128","344","1221","3","1","1122.6","0","1122.6","2018-07-04","2018-08-29","","1","1");
INSERT INTO contas_receber VALUES("13137","62","1263","1","1","206.4","0","206.4","2018-07-04","2018-08-06","","1","1");
INSERT INTO contas_receber VALUES("13148","359","1274","1","1","229.5","229.5","0","2018-07-04","2018-07-05","","0","0");
INSERT INTO contas_receber VALUES("13155","202","1236","1","1","679.45","0","679.45","2018-07-05","2018-07-20","","1","1");
INSERT INTO contas_receber VALUES("13156","202","1236","2","1","679.45","0","679.45","2018-07-05","2018-07-20","","1","1");
INSERT INTO contas_receber VALUES("13157","310","1244","1","1","736.67","0","736.67","2018-07-05","2018-08-04","","1","1");
INSERT INTO contas_receber VALUES("13158","310","1244","2","1","736.67","0","736.67","2018-07-05","2018-08-19","","1","1");
INSERT INTO contas_receber VALUES("13159","310","1244","3","1","736.66","0","736.66","2018-07-05","2018-09-04","","1","1");
INSERT INTO contas_receber VALUES("13160","31","1265","1","1","263.32","0","263.32","2018-07-05","2018-08-06","","1","1");
INSERT INTO contas_receber VALUES("13161","31","1265","2","1","263.33","0","263.33","2018-07-05","2018-09-06","","1","1");
INSERT INTO contas_receber VALUES("13162","224","1262","1","1","237.6","0","237.6","2018-07-05","2018-08-06","","1","1");
INSERT INTO contas_receber VALUES("13177","361","1277","1","1","89.18","0","89.18","2018-07-06","2018-07-08","","1","1");
INSERT INTO contas_receber VALUES("13180","220","1255","1","1","1418.93","0","1418.93","2018-07-09","2018-08-09","","1","1");
INSERT INTO contas_receber VALUES("13181","220","1255","2","1","1418.93","0","1418.93","2018-07-09","2018-08-24","","1","1");
INSERT INTO contas_receber VALUES("13182","220","1255","3","1","1418.94","0","1418.94","2018-07-09","2018-09-09","","1","1");
INSERT INTO contas_receber VALUES("13191","3","1258","1","1","135.73","0","135.73","2018-07-09","2018-07-01","","1","1");
INSERT INTO contas_receber VALUES("13192","42","1232","1","1","3900.06","0","3900.06","2018-07-09","2018-06-19","","1","1");
INSERT INTO contas_receber VALUES("13193","354","1248","1","1","253.31","0","253.31","2018-07-10","2018-08-05","","1","1");
INSERT INTO contas_receber VALUES("13194","354","1248","2","1","253.31","0","253.31","2018-07-10","2018-08-20","","1","1");
INSERT INTO contas_receber VALUES("13195","354","1248","3","1","253.3","0","253.3","2018-07-10","2018-09-05","","1","1");
INSERT INTO contas_receber VALUES("13196","8","1246","1","1","543.17","0","543.17","2018-07-10","2018-08-06","","1","1");
INSERT INTO contas_receber VALUES("13197","8","1246","2","1","543.17","0","543.17","2018-07-10","2018-08-21","","1","1");
INSERT INTO contas_receber VALUES("13198","8","1246","3","1","543.16","0","543.16","2018-07-10","2018-09-06","","1","1");
INSERT INTO contas_receber VALUES("13199","21","1245","1","1","1432.72","0","1432.72","2018-07-10","2018-08-09","","1","1");
INSERT INTO contas_receber VALUES("13200","21","1245","2","1","1432.72","0","1432.72","2018-07-10","2018-08-19","","1","1");
INSERT INTO contas_receber VALUES("13201","21","1245","3","1","1432.72","0","1432.72","2018-07-10","2018-08-29","","1","1");
INSERT INTO contas_receber VALUES("13202","21","1245","4","1","1432.72","0","1432.72","2018-07-10","2018-09-08","","1","1");
INSERT INTO contas_receber VALUES("13203","21","1245","5","1","1432.72","0","1432.72","2018-07-10","2018-09-18","","1","1");
INSERT INTO contas_receber VALUES("13212","98","1250","1","1","1360.83","0","1360.83","2018-07-11","2018-08-10","","1","1");
INSERT INTO contas_receber VALUES("13213","98","1250","3","1","1360.84","0","1360.84","2018-07-11","2018-10-10","","1","1");
INSERT INTO contas_receber VALUES("13214","98","1250","2","1","1360.83","0","1360.83","2018-07-11","2018-09-10","","1","1");
INSERT INTO contas_receber VALUES("13215","4","1249","1","1","1225.33","0","1225.33","2018-07-11","2018-08-11","","1","1");
INSERT INTO contas_receber VALUES("13216","4","1249","2","1","1225.33","0","1225.33","2018-07-11","2018-08-26","","1","1");
INSERT INTO contas_receber VALUES("13217","4","1249","3","1","1225.34","0","1225.34","2018-07-11","2018-09-11","","1","1");
INSERT INTO contas_receber VALUES("13218","341","1192","1","1","396","0","396","2018-07-11","2018-06-06","","1","1");
INSERT INTO contas_receber VALUES("13219","275","1191","1","1","73.22","0","73.22","2018-07-11","2018-06-03","","1","1");
INSERT INTO contas_receber VALUES("13220","112","1212","1","1","111.46","0","111.46","2018-07-11","2018-06-09","","1","1");
INSERT INTO contas_receber VALUES("13221","60","1224","1","1","441","0","441","2018-07-11","2018-08-05","","1","1");
INSERT INTO contas_receber VALUES("13222","13","1240","1","1","296","0","296","2018-07-11","2018-06-22","","1","1");
INSERT INTO contas_receber VALUES("13223","32","1242","1","1","166.8","0","166.8","2018-07-11","2018-06-22","","1","1");
INSERT INTO contas_receber VALUES("13224","3","1279","1","1","457.61","0","457.61","2018-07-11","2018-07-14","","1","1");
INSERT INTO contas_receber VALUES("13226","362","1281","1","1","158.66","158.66","0","2018-07-11","2018-07-12","","0","0");
INSERT INTO contas_receber VALUES("13256","23","1152","1","1","1389","0","1389","2018-07-12","2018-07-11","","1","1");
INSERT INTO contas_receber VALUES("13263","355","1254","1","1","623.85","0","623.85","2018-07-12","2018-08-12","","1","1");
INSERT INTO contas_receber VALUES("13264","355","1254","2","1","623.85","0","623.85","2018-07-12","2018-08-27","","1","1");
INSERT INTO contas_receber VALUES("13265","5","1256","1","1","386.5","0","386.5","2018-07-12","2018-08-09","","1","1");
INSERT INTO contas_receber VALUES("13266","5","1256","2","1","386.5","0","386.5","2018-07-12","2018-09-09","","1","1");
INSERT INTO contas_receber VALUES("13267","346","1261","1","1","2053.8","0","2053.8","2018-07-12","2018-07-03","","1","1");
INSERT INTO contas_receber VALUES("13268","356","1264","1","1","754","0","754","2018-07-12","2018-08-13","","1","1");
INSERT INTO contas_receber VALUES("13299","243","1269","1","1","599.8","0","599.8","2018-07-13","2018-08-13","","1","1");
INSERT INTO contas_receber VALUES("13300","243","1269","3","1","599.8","0","599.8","2018-07-13","2018-09-13","","1","1");
INSERT INTO contas_receber VALUES("13301","243","1269","2","1","599.8","0","599.8","2018-07-13","2018-08-28","","1","1");
INSERT INTO contas_receber VALUES("13302","315","1270","1","1","412.2","0","412.2","2018-07-13","2018-08-16","","1","1");
INSERT INTO contas_receber VALUES("13303","315","1270","2","1","412.2","0","412.2","2018-07-13","2018-08-31","","1","1");
INSERT INTO contas_receber VALUES("13304","315","1270","3","1","412.2","0","412.2","2018-07-13","2018-09-16","","1","1");
INSERT INTO contas_receber VALUES("13305","201","1278","1","1","326.55","0","326.55","2018-07-13","2018-07-08","","1","1");
INSERT INTO contas_receber VALUES("13312","36","1178","1","1","490.77","0","490.77","2018-07-13","2018-07-13","","1","1");
INSERT INTO contas_receber VALUES("13313","36","1178","2","1","490.77","0","490.77","2018-07-13","2018-07-28","","1","1");
INSERT INTO contas_receber VALUES("13314","36","1178","3","1","490.76","0","490.76","2018-07-13","2018-08-13","","1","1");
INSERT INTO contas_receber VALUES("13315","17","1257","1","1","835.08","0","835.08","2018-07-13","2018-08-12","","1","1");
INSERT INTO contas_receber VALUES("13316","17","1257","2","1","835.08","0","835.08","2018-07-13","2018-08-27","","1","1");
INSERT INTO contas_receber VALUES("13317","17","1257","3","1","835.09","0","835.09","2018-07-13","2018-09-12","","1","1");
INSERT INTO contas_receber VALUES("13330","303","1266","1","1","1113.97","0","1113.97","2018-07-16","2018-08-16","","1","1");
INSERT INTO contas_receber VALUES("13331","303","1266","2","1","1113.97","0","1113.97","2018-07-16","2018-08-31","","1","1");
INSERT INTO contas_receber VALUES("13332","303","1266","3","1","1113.96","0","1113.96","2018-07-16","2018-09-16","","1","1");
INSERT INTO contas_receber VALUES("13333","284","1273","2","1","705.15","0","705.15","2018-07-16","2018-08-31","","1","1");
INSERT INTO contas_receber VALUES("13334","284","1273","1","1","705.15","0","705.15","2018-07-16","2018-08-16","","1","1");
INSERT INTO contas_receber VALUES("13335","284","1273","3","1","705.15","0","705.15","2018-07-16","2018-09-16","","1","1");
INSERT INTO contas_receber VALUES("13336","357","1271","1","1","225.1","0","225.1","2018-07-16","2018-08-16","","1","1");
INSERT INTO contas_receber VALUES("13337","357","1271","2","1","225.1","0","225.1","2018-07-16","2018-09-16","","1","1");
INSERT INTO contas_receber VALUES("13356","54","1294","1","1","53.77","0","53.77","2018-07-17","2018-07-19","","1","1");
INSERT INTO contas_receber VALUES("13382","24","1275","1","1","692.25","0","692.25","2018-07-18","2018-07-30","","1","1");
INSERT INTO contas_receber VALUES("13383","24","1275","2","1","692.25","0","692.25","2018-07-18","2018-07-30","","1","1");
INSERT INTO contas_receber VALUES("13384","263","1276","1","1","783.55","0","783.55","2018-07-18","2018-08-02","","1","1");
INSERT INTO contas_receber VALUES("13385","263","1276","2","1","783.55","0","783.55","2018-07-18","2018-08-02","","1","1");
INSERT INTO contas_receber VALUES("13386","291","1260","1","1","407.3","0","407.3","2018-07-18","2018-08-18","","1","1");
INSERT INTO contas_receber VALUES("13387","291","1260","2","1","407.3","0","407.3","2018-07-18","2018-09-18","","1","1");
INSERT INTO contas_receber VALUES("13404","32","1282","1","1","61.19","0","61.19","2018-07-18","2018-07-13","","1","1");
INSERT INTO contas_receber VALUES("13405","3","1283","1","1","73.75","0","73.75","2018-07-18","2018-07-14","","1","1");
INSERT INTO contas_receber VALUES("13406","31","1280","1","1","384.07","0","384.07","2018-07-18","2018-08-18","","1","1");
INSERT INTO contas_receber VALUES("13407","31","1280","2","1","384.07","0","384.07","2018-07-18","2018-09-02","","1","1");
INSERT INTO contas_receber VALUES("13408","31","1280","3","1","384.07","0","384.07","2018-07-18","2018-09-18","","1","1");
INSERT INTO contas_receber VALUES("13409","31","1280","4","1","384.05","0","384.05","2018-07-18","2018-09-25","","1","1");
INSERT INTO contas_receber VALUES("13410","327","1123","1","1","232","0","232","2018-07-18","2018-05-06","","1","1");
INSERT INTO contas_receber VALUES("13416","234","1290","1","1","454.83","0","454.83","2018-07-19","2018-08-20","","1","1");
INSERT INTO contas_receber VALUES("13417","234","1290","2","1","454.83","0","454.83","2018-07-19","2018-09-20","","1","1");
INSERT INTO contas_receber VALUES("13418","234","1290","3","1","454.84","454.84","0","2018-07-19","2018-10-20","","0","1");
INSERT INTO contas_receber VALUES("13419","337","1289","1","1","377","0","377","2018-07-19","2018-08-20","","1","1");
INSERT INTO contas_receber VALUES("13420","337","1289","2","1","377","0","377","2018-07-19","2018-09-20","","1","1");
INSERT INTO contas_receber VALUES("13421","33","1285","1","1","1545.4","0","1545.4","2018-07-19","2018-07-13","","1","1");
INSERT INTO contas_receber VALUES("13438","23","1287","1","1","518.63","0","518.63","2018-07-19","2018-08-23","","1","1");
INSERT INTO contas_receber VALUES("13439","23","1287","3","1","518.64","0","518.64","2018-07-19","2018-09-23","","1","1");
INSERT INTO contas_receber VALUES("13440","23","1287","2","1","518.63","0","518.63","2018-07-19","2018-09-07","","1","1");
INSERT INTO contas_receber VALUES("13441","84","1284","1","1","570.33","0","570.33","2018-07-19","2018-08-20","","1","1");
INSERT INTO contas_receber VALUES("13442","84","1284","2","1","570.33","0","570.33","2018-07-19","2018-09-04","","1","1");
INSERT INTO contas_receber VALUES("13443","84","1284","3","1","570.34","0","570.34","2018-07-19","2018-09-20","","1","1");
INSERT INTO contas_receber VALUES("13450","4","1288","1","1","1266.67","0","1266.67","2018-07-19","2018-08-23","","1","1");
INSERT INTO contas_receber VALUES("13451","4","1288","2","1","1266.67","0","1266.67","2018-07-19","2018-09-07","","1","1");
INSERT INTO contas_receber VALUES("13452","4","1288","3","1","1266.66","0","1266.66","2018-07-19","2018-09-23","","1","1");
INSERT INTO contas_receber VALUES("13453","21","1298","1","1","501.67","0","501.67","2018-07-19","2018-08-20","","1","1");
INSERT INTO contas_receber VALUES("13454","21","1298","2","1","501.67","0","501.67","2018-07-19","2018-09-04","","1","1");
INSERT INTO contas_receber VALUES("13455","21","1298","3","1","501.66","0","501.66","2018-07-19","2018-09-20","","1","1");
INSERT INTO contas_receber VALUES("13456","224","1304","1","1","262.8","0","262.8","2018-07-19","2018-07-20","","1","1");
INSERT INTO contas_receber VALUES("13459","367","1306","1","1","95.65","0","95.65","2018-07-20","2018-07-21","","1","1");
INSERT INTO contas_receber VALUES("13463","83","1307","1","1","205.87","205.87","0","2018-07-20","2018-07-21","","0","1");
INSERT INTO contas_receber VALUES("13464","83","1307","2","1","205.87","205.87","0","2018-07-20","2018-08-21","","0","1");
INSERT INTO contas_receber VALUES("13465","83","1307","3","1","205.88","205.88","0","2018-07-20","2018-09-21","","0","1");
INSERT INTO contas_receber VALUES("13472","364","1295","1","1","289.4","0","289.4","2018-07-20","2018-08-20","","1","1");
INSERT INTO contas_receber VALUES("13488","192","1291","1","1","852.7","852.7","0","2018-07-23","2018-07-15","","0","1");
INSERT INTO contas_receber VALUES("13489","192","1291","3","1","852.7","852.7","0","2018-07-23","2018-09-15","","0","1");
INSERT INTO contas_receber VALUES("13490","192","1291","2","1","852.7","852.7","0","2018-07-23","2018-08-15","","0","1");
INSERT INTO contas_receber VALUES("13491","161","1286","1","1","672.04","0","672.04","2018-07-23","2018-08-20","","1","1");
INSERT INTO contas_receber VALUES("13492","161","1286","2","1","672.04","0","672.04","2018-07-23","2018-09-04","","1","1");
INSERT INTO contas_receber VALUES("13493","161","1286","4","1","672.04","0","672.04","2018-07-23","2018-10-04","","1","1");
INSERT INTO contas_receber VALUES("13494","161","1286","5","1","672.04","0","672.04","2018-07-23","2018-10-19","","1","1");
INSERT INTO contas_receber VALUES("13495","161","1286","3","1","672.04","0","672.04","2018-07-23","2018-09-19","","1","1");
INSERT INTO contas_receber VALUES("13496","192","1309","1","1","852.7","0","852.7","2018-07-23","2018-08-24","","1","1");
INSERT INTO contas_receber VALUES("13497","192","1309","2","1","852.7","0","852.7","2018-07-23","2018-09-08","","1","1");
INSERT INTO contas_receber VALUES("13498","192","1309","3","1","852.7","0","852.7","2018-07-23","2018-09-24","","1","1");
INSERT INTO contas_receber VALUES("13499","365","1293","1","1","358","0","358","2018-07-23","2018-07-20","","1","1");
INSERT INTO contas_receber VALUES("13500","31","1301","1","1","219.96","0","219.96","2018-07-23","2018-08-23","","1","1");
INSERT INTO contas_receber VALUES("13507","46","1300","1","1","136.94","0","136.94","2018-07-24","2018-08-20","","1","1");
INSERT INTO contas_receber VALUES("13508","179","1302","1","1","319.2","0","319.2","2018-07-24","2018-08-24","","1","1");
INSERT INTO contas_receber VALUES("13509","179","1302","2","1","319.2","0","319.2","2018-07-24","2018-09-08","","1","1");
INSERT INTO contas_receber VALUES("13510","179","1302","3","1","319.2","0","319.2","2018-07-24","2018-09-24","","1","1");
INSERT INTO contas_receber VALUES("13520","35","1173","1","1","384.5","0","384.5","2018-07-24","2018-07-25","","1","1");
INSERT INTO contas_receber VALUES("13521","86","1297","1","1","319.5","0","319.5","2018-07-25","2018-08-27","","1","1");
INSERT INTO contas_receber VALUES("13522","86","1297","2","1","319.5","0","319.5","2018-07-25","2018-09-27","","1","1");
INSERT INTO contas_receber VALUES("13523","363","1292","1","1","1818.9","0","1818.9","2018-07-25","2018-08-27","","1","1");
INSERT INTO contas_receber VALUES("13524","363","1292","2","1","1818.9","0","1818.9","2018-07-25","2018-09-27","","1","1");
INSERT INTO contas_receber VALUES("13525","363","1292","3","1","1818.9","0","1818.9","2018-07-25","2018-10-13","","1","1");
INSERT INTO contas_receber VALUES("13526","363","1292","4","1","1818.9","0","1818.9","2018-07-25","2018-10-27","","1","1");
INSERT INTO contas_receber VALUES("13544","118","1313","1","1","727.73","727.73","0","2018-07-25","2018-07-27","","0","0");
INSERT INTO contas_receber VALUES("13545","118","1313","3","1","727.74","727.74","0","2018-07-25","2018-09-27","","0","0");
INSERT INTO contas_receber VALUES("13546","118","1313","2","1","727.73","727.73","0","2018-07-25","2018-08-27","","0","0");
INSERT INTO contas_receber VALUES("13547","264","1299","1","1","352.95","0","352.95","2018-07-26","2018-07-22","","1","1");
INSERT INTO contas_receber VALUES("13548","199","1234","2","1","301.6","0","301.6","2018-07-26","2018-09-27","","1","1");
INSERT INTO contas_receber VALUES("13549","199","1234","3","1","301.59","0","301.59","2018-07-26","2018-10-27","","1","1");
INSERT INTO contas_receber VALUES("13550","199","1234","1","1","301.6","0","301.6","2018-07-26","2018-08-27","","1","1");
INSERT INTO contas_receber VALUES("13551","220","1303","1","1","2545.53","0","2545.53","2018-07-26","2018-08-31","","1","1");
INSERT INTO contas_receber VALUES("13552","220","1303","2","1","2545.53","0","2545.53","2018-07-26","2018-09-16","","1","1");
INSERT INTO contas_receber VALUES("13553","220","1303","3","1","2545.54","0","2545.54","2018-07-26","2018-09-30","","1","1");
INSERT INTO contas_receber VALUES("13554","292","1167","2","1","901","0","901","2018-07-27","2018-07-29","","1","1");
INSERT INTO contas_receber VALUES("13555","292","1167","3","1","901","0","901","2018-07-27","2018-08-13","","1","1");
INSERT INTO contas_receber VALUES("13556","292","1167","1","1","901","0","901","2018-07-27","2018-08-29","","1","1");
INSERT INTO contas_receber VALUES("13559","292","1314","1","1","2069","2069","0","2018-07-27","2018-07-29","","0","1");
INSERT INTO contas_receber VALUES("13560","292","1314","2","1","2069","2069","0","2018-07-27","2018-08-29","","0","1");
INSERT INTO contas_receber VALUES("13561","292","1314","3","1","2069","2069","0","2018-07-27","2018-09-29","","0","1");
INSERT INTO contas_receber VALUES("13574","25","1296","1","1","2179.57","0","2179.57","2018-07-27","2018-08-27","","1","1");
INSERT INTO contas_receber VALUES("13575","25","1296","2","1","2179.57","0","2179.57","2018-07-27","2018-09-11","","1","1");
INSERT INTO contas_receber VALUES("13576","25","1296","3","1","2179.56","0","2179.56","2018-07-27","2018-09-27","","1","1");
INSERT INTO contas_receber VALUES("13589","176","1310","1","1","438.21","0","438.21","2018-07-30","2018-09-01","","1","1");
INSERT INTO contas_receber VALUES("13590","176","1310","2","1","438.21","0","438.21","2018-07-30","2018-09-16","","1","1");
INSERT INTO contas_receber VALUES("13591","176","1310","3","1","438.2","0","438.2","2018-07-30","2018-10-01","","1","1");
INSERT INTO contas_receber VALUES("13602","366","1305","1","1","47.91","0","47.91","2018-07-30","2018-07-21","","1","1");
INSERT INTO contas_receber VALUES("13603","44","1312","1","1","852.55","0","852.55","2018-07-31","2018-09-01","","1","1");
INSERT INTO contas_receber VALUES("13604","44","1312","2","1","852.55","0","852.55","2018-07-31","2018-09-16","","1","1");
INSERT INTO contas_receber VALUES("13605","44","1312","3","1","852.56","0","852.56","2018-07-31","2018-10-01","","1","1");
INSERT INTO contas_receber VALUES("13606","31","1320","2","1","213.66","0","213.66","2018-07-31","2018-10-01","","1","1");
INSERT INTO contas_receber VALUES("13607","31","1320","1","1","213.66","0","213.66","2018-07-31","2018-09-01","","1","1");
INSERT INTO contas_receber VALUES("13608","83","1321","1","1","205.87","0","205.87","2018-07-31","2018-08-27","","1","1");
INSERT INTO contas_receber VALUES("13609","83","1321","2","1","205.87","0","205.87","2018-07-31","2018-09-27","","1","1");
INSERT INTO contas_receber VALUES("13610","83","1321","3","1","205.88","0","205.88","2018-07-31","2018-10-27","","1","1");
INSERT INTO contas_receber VALUES("13613","3","1318","1","1","118.52","0","118.52","2018-07-31","2018-07-29","","1","1");
INSERT INTO contas_receber VALUES("13614","3","1322","1","1","72.38","0","72.38","2018-07-31","2018-08-02","","1","1");
INSERT INTO contas_receber VALUES("13615","35","1311","1","1","161.31","0","161.31","2018-07-31","2018-08-30","","1","1");
INSERT INTO contas_receber VALUES("13630","292","1315","1","1","978","0","978","2018-08-01","2018-09-03","","1","1");
INSERT INTO contas_receber VALUES("13631","292","1315","2","1","978","0","978","2018-08-01","2018-09-18","","1","1");
INSERT INTO contas_receber VALUES("13632","292","1315","5","1","978","0","978","2018-08-01","2018-09-24","","1","1");
INSERT INTO contas_receber VALUES("13633","292","1315","3","1","978","0","978","2018-08-01","2018-10-03","","1","1");
INSERT INTO contas_receber VALUES("13634","292","1315","6","1","978","0","978","2018-08-01","2018-10-09","","1","1");
INSERT INTO contas_receber VALUES("13635","292","1315","4","1","978","0","978","2018-08-01","2018-09-09","","1","1");
INSERT INTO contas_receber VALUES("13636","358","1272","1","1","1200","0","1200","2018-08-01","2018-08-01","","1","1");
INSERT INTO contas_receber VALUES("13637","358","1272","2","1","236.4","0","236.4","2018-08-01","2018-09-02","","1","1");
INSERT INTO contas_receber VALUES("13676","223","1316","1","1","482.73","0","482.73","2018-08-02","2018-09-03","","1","1");
INSERT INTO contas_receber VALUES("13677","223","1316","2","1","482.73","0","482.73","2018-08-02","2018-09-18","","1","1");
INSERT INTO contas_receber VALUES("13678","223","1316","3","1","482.74","0","482.74","2018-08-02","2018-10-03","","1","1");
INSERT INTO contas_receber VALUES("13693","3","1329","1","1","19.71","0","19.71","2018-08-02","2018-08-03","","1","1");
INSERT INTO contas_receber VALUES("13694","155","1323","1","1","770","0","770","2018-08-03","2018-09-07","","1","1");
INSERT INTO contas_receber VALUES("13695","155","1323","2","1","770","0","770","2018-08-03","2018-10-07","","1","1");
INSERT INTO contas_receber VALUES("13696","155","1323","3","1","770","0","770","2018-08-03","2018-11-07","","1","1");
INSERT INTO contas_receber VALUES("13718","220","1324","1","1","3957.21","0","3957.21","2018-08-06","2018-09-06","","1","1");
INSERT INTO contas_receber VALUES("13719","220","1324","2","1","3957.21","0","3957.21","2018-08-06","2018-09-21","","1","1");
INSERT INTO contas_receber VALUES("13720","220","1324","4","1","439.67","0","439.67","2018-08-06","2018-10-30","","1","1");
INSERT INTO contas_receber VALUES("13721","220","1324","3","1","3957.21","0","3957.21","2018-08-06","2018-10-06","","1","1");
INSERT INTO contas_receber VALUES("13759","31","1332","1","1","392.22","0","392.22","2018-08-07","2018-09-08","","1","1");
INSERT INTO contas_receber VALUES("13760","31","1332","3","1","392.21","0","392.21","2018-08-07","2018-10-08","","1","1");
INSERT INTO contas_receber VALUES("13761","31","1332","2","1","392.22","0","392.22","2018-08-07","2018-09-23","","1","1");
INSERT INTO contas_receber VALUES("13762","4","1328","1","1","1275","0","1275","2018-08-07","2018-09-08","","1","1");
INSERT INTO contas_receber VALUES("13763","4","1328","2","1","1275","0","1275","2018-08-07","2018-09-23","","1","1");
INSERT INTO contas_receber VALUES("13764","4","1328","3","1","1275","0","1275","2018-08-07","2018-10-08","","1","1");
INSERT INTO contas_receber VALUES("13765","19","1326","1","1","353.88","0","353.88","2018-08-07","2018-09-08","","1","1");
INSERT INTO contas_receber VALUES("13766","19","1326","2","1","353.87","0","353.87","2018-08-07","2018-10-08","","1","1");
INSERT INTO contas_receber VALUES("13773","160","1169","1","1","237.13","0","237.13","2018-08-07","2018-07-06","","1","1");
INSERT INTO contas_receber VALUES("13774","160","1169","3","1","237.14","0","237.14","2018-08-07","2018-09-06","","1","1");
INSERT INTO contas_receber VALUES("13775","160","1169","2","1","237.13","0","237.13","2018-08-07","2018-08-06","","1","1");
INSERT INTO contas_receber VALUES("13818","343","1334","1","1","91.27","0","91.27","2018-08-08","2018-08-09","","1","1");
INSERT INTO contas_receber VALUES("13819","193","1071","1","1","78.62","0","78.62","2018-08-08","2018-04-14","","1","1");
INSERT INTO contas_receber VALUES("13828","7","1336","2","1","156.94","0","156.94","2018-08-08","2018-09-25","","1","1");
INSERT INTO contas_receber VALUES("13829","7","1336","1","1","156.94","0","156.94","2018-08-08","2018-09-10","","1","1");
INSERT INTO contas_receber VALUES("13830","7","1336","3","1","156.94","0","156.94","2018-08-08","2018-10-10","","1","1");
INSERT INTO contas_receber VALUES("13831","152","1330","1","1","598.97","0","598.97","2018-08-09","2018-09-09","","1","1");
INSERT INTO contas_receber VALUES("13832","152","1330","3","1","598.96","0","598.96","2018-08-09","2018-10-09","","1","1");
INSERT INTO contas_receber VALUES("13833","152","1330","2","1","598.97","0","598.97","2018-08-09","2018-09-24","","1","1");
INSERT INTO contas_receber VALUES("13834","30","1335","1","1","1102.63","0","1102.63","2018-08-09","2018-09-10","","1","1");
INSERT INTO contas_receber VALUES("13835","30","1335","2","1","1102.63","0","1102.63","2018-08-09","2018-09-25","","1","1");
INSERT INTO contas_receber VALUES("13836","30","1335","3","1","1102.64","0","1102.64","2018-08-09","2018-10-10","","1","1");
INSERT INTO contas_receber VALUES("13837","150","1331","1","1","46.1","0","46.1","2018-08-09","2018-08-05","","1","1");
INSERT INTO contas_receber VALUES("13838","368","1325","1","1","53.78","0","53.78","2018-08-09","2018-08-03","","1","1");
INSERT INTO contas_receber VALUES("13839","369","1327","1","1","403.4","403.4","0","2018-08-09","2018-09-09","","0","0");
INSERT INTO contas_receber VALUES("13840","369","1327","3","1","403.4","403.4","0","2018-08-09","2018-10-09","","0","0");
INSERT INTO contas_receber VALUES("13841","369","1327","2","1","403.4","403.4","0","2018-08-09","2018-09-24","","0","0");
INSERT INTO contas_receber VALUES("13842","175","1333","1","1","201.43","0","201.43","2018-08-09","2018-08-08","","1","1");
INSERT INTO contas_receber VALUES("13843","32","1317","1","1","200.48","0","200.48","2018-08-09","2018-07-29","","1","1");
INSERT INTO contas_receber VALUES("13844","59","1308","1","1","305.57","0","305.57","2018-08-09","2018-09-02","","1","1");
INSERT INTO contas_receber VALUES("13845","59","1308","2","1","305.57","0","305.57","2018-08-09","2018-09-17","","1","1");
INSERT INTO contas_receber VALUES("13846","59","1308","3","1","305.56","0","305.56","2018-08-09","2018-10-02","","1","1");
INSERT INTO contas_receber VALUES("13848","334","1142","1","1","179.1","179.1","0","2018-08-09","2018-05-13","","0","0");
INSERT INTO contas_receber VALUES("13899","212","1338","3","1","728.85","0","728.85","2018-08-10","2018-10-10","","1","1");
INSERT INTO contas_receber VALUES("13900","212","1338","2","1","728.85","0","728.85","2018-08-10","2018-09-25","","1","1");
INSERT INTO contas_receber VALUES("13901","212","1338","1","1","728.85","0","728.85","2018-08-10","2018-09-10","","1","1");
INSERT INTO contas_receber VALUES("13902","140","1343","1","1","330.57","0","330.57","2018-08-10","2018-09-13","","1","1");
INSERT INTO contas_receber VALUES("13903","140","1343","2","1","330.57","0","330.57","2018-08-10","2018-09-28","","1","1");
INSERT INTO contas_receber VALUES("13904","140","1343","3","1","330.56","0","330.56","2018-08-10","2018-10-13","","1","1");
INSERT INTO contas_receber VALUES("13911","371","1345","1","1","37.76","0","37.76","2018-08-10","2018-08-11","","1","1");
INSERT INTO contas_receber VALUES("13917","372","1354","1","1","325.03","325.03","0","2018-08-10","2018-08-12","","0","0");
INSERT INTO contas_receber VALUES("13918","372","1354","2","1","325.03","325.03","0","2018-08-10","2018-09-12","","0","0");
INSERT INTO contas_receber VALUES("13919","372","1354","3","1","325.04","325.04","0","2018-08-10","2018-10-13","","0","0");
INSERT INTO contas_receber VALUES("13931","372","1356","1","1","252.17","252.17","0","2018-08-10","2018-08-12","","0","0");
INSERT INTO contas_receber VALUES("13932","372","1356","2","1","252.17","252.17","0","2018-08-10","2018-09-12","","0","0");
INSERT INTO contas_receber VALUES("13933","372","1356","3","1","252.16","252.16","0","2018-08-10","2018-10-13","","0","0");
INSERT INTO contas_receber VALUES("13942","370","1342","1","1","505.65","0","505.65","2018-08-13","2018-09-14","","1","1");
INSERT INTO contas_receber VALUES("13943","370","1342","2","1","505.65","0","505.65","2018-08-13","2018-09-29","","1","1");
INSERT INTO contas_receber VALUES("13944","370","1342","3","1","505.65","0","505.65","2018-08-13","2018-10-14","","1","1");
INSERT INTO contas_receber VALUES("13945","202","1340","1","1","354.71","0","354.71","2018-08-13","2018-08-22","","1","1");
INSERT INTO contas_receber VALUES("13946","202","1340","2","1","354.71","0","354.71","2018-08-13","2018-08-22","","1","1");
INSERT INTO contas_receber VALUES("13947","69","1339","1","1","593.65","0","593.65","2018-08-13","2018-08-28","","1","1");
INSERT INTO contas_receber VALUES("13948","69","1339","2","1","593.65","0","593.65","2018-08-13","2018-08-28","","1","1");
INSERT INTO contas_receber VALUES("13949","234","1349","1","1","440.5","0","440.5","2018-08-13","2018-09-14","","1","1");
INSERT INTO contas_receber VALUES("13950","234","1349","3","1","440.5","0","440.5","2018-08-13","2018-10-14","","1","1");
INSERT INTO contas_receber VALUES("13951","234","1349","2","1","440.5","0","440.5","2018-08-13","2018-09-29","","1","1");
INSERT INTO contas_receber VALUES("13952","234","1349","4","1","440.5","440.5","0","2018-08-13","2018-10-29","","0","1");
INSERT INTO contas_receber VALUES("13953","129","1341","1","1","502.67","0","502.67","2018-08-13","2018-09-08","","1","1");
INSERT INTO contas_receber VALUES("13954","129","1341","2","0","502.66","0","502.66","2018-08-13","2018-09-24","","1","1");
INSERT INTO contas_receber VALUES("13955","129","1341","3","1","502.67","0","502.67","2018-08-13","2018-10-08","","1","1");
INSERT INTO contas_receber VALUES("13980","373","1360","1","1","315.87","0","315.87","2018-08-13","2018-08-15","","1","1");
INSERT INTO contas_receber VALUES("14003","22","1346","1","1","1162.9","0","1162.9","2018-08-14","2018-09-15","","1","1");
INSERT INTO contas_receber VALUES("14004","22","1346","2","1","1162.9","0","1162.9","2018-08-14","2018-09-30","","1","1");
INSERT INTO contas_receber VALUES("14005","22","1346","3","1","1162.9","0","1162.9","2018-08-14","2018-10-15","","1","1");
INSERT INTO contas_receber VALUES("14006","3","1363","1","1","147.43","0","147.43","2018-08-14","2018-08-15","","1","1");
INSERT INTO contas_receber VALUES("14015","220","1364","1","1","3500.4","3500.4","0","2018-08-14","2018-08-16","","0","1");
INSERT INTO contas_receber VALUES("14016","220","1364","2","1","3500.4","3500.4","0","2018-08-14","2018-09-16","","0","1");
INSERT INTO contas_receber VALUES("14017","220","1364","3","1","3500.4","3500.4","0","2018-08-14","2018-10-17","","0","1");
INSERT INTO contas_receber VALUES("14028","31","1353","1","1","413.53","0","413.53","2018-08-14","2018-09-17","","1","1");
INSERT INTO contas_receber VALUES("14029","31","1353","2","1","413.53","0","413.53","2018-08-14","2018-10-02","","1","1");
INSERT INTO contas_receber VALUES("14030","31","1353","3","1","413.54","0","413.54","2018-08-14","2018-10-17","","1","1");
INSERT INTO contas_receber VALUES("14031","31","1353","4","1","503","0","503","2018-08-14","2018-11-01","","1","1");
INSERT INTO contas_receber VALUES("14099","323","1373","2","1","340.81","340.81","0","2018-08-16","2018-09-20","","0","0");
INSERT INTO contas_receber VALUES("14100","323","1373","1","1","340.81","340.81","0","2018-08-16","2018-08-20","","0","0");
INSERT INTO contas_receber VALUES("14101","323","1373","3","1","340.8","340.8","0","2018-08-16","2018-10-21","","0","0");
INSERT INTO contas_receber VALUES("14107","376","1376","3","1","1037.39","1037.39","0","2018-08-16","2018-10-19","","0","0");
INSERT INTO contas_receber VALUES("14108","376","1376","1","1","1037.38","1037.38","0","2018-08-16","2018-08-18","","0","0");
INSERT INTO contas_receber VALUES("14109","376","1376","2","1","1037.38","1037.38","0","2018-08-16","2018-09-18","","0","0");
INSERT INTO contas_receber VALUES("14110","113","1347","1","1","399","0","399","2018-08-16","2018-09-16","","1","1");
INSERT INTO contas_receber VALUES("14111","113","1347","2","1","399","0","399","2018-08-16","2018-10-01","","1","1");
INSERT INTO contas_receber VALUES("14112","113","1347","3","1","399","0","399","2018-08-16","2018-10-16","","1","1");
INSERT INTO contas_receber VALUES("14113","5","1348","1","1","257.45","0","257.45","2018-08-16","2018-09-15","","1","1");
INSERT INTO contas_receber VALUES("14114","5","1348","2","1","257.45","0","257.45","2018-08-16","2018-09-30","","1","1");
INSERT INTO contas_receber VALUES("14115","5","1348","3","1","257.45","0","257.45","2018-08-16","2018-10-15","","1","1");
INSERT INTO contas_receber VALUES("14125","84","1350","1","1","580","0","580","2018-08-17","2018-09-16","","1","1");
INSERT INTO contas_receber VALUES("14126","84","1350","3","1","580","0","580","2018-08-17","2018-10-16","","1","1");
INSERT INTO contas_receber VALUES("14127","84","1350","2","1","580","0","580","2018-08-17","2018-10-01","","1","1");
INSERT INTO contas_receber VALUES("14128","310","1352","1","1","752.17","0","752.17","2018-08-17","2018-09-17","","1","1");
INSERT INTO contas_receber VALUES("14129","310","1352","3","1","752.16","0","752.16","2018-08-17","2018-10-17","","1","1");
INSERT INTO contas_receber VALUES("14130","310","1352","2","1","752.17","0","752.17","2018-08-17","2018-10-02","","1","1");
INSERT INTO contas_receber VALUES("14131","243","1355","2","1","450.04","0","450.04","2018-08-17","2018-10-05","","1","1");
INSERT INTO contas_receber VALUES("14132","243","1355","1","1","450.04","0","450.04","2018-08-17","2018-09-20","","1","1");
INSERT INTO contas_receber VALUES("14133","243","1355","3","1","450.04","0","450.04","2018-08-17","2018-10-20","","1","1");
INSERT INTO contas_receber VALUES("14154","36","1381","1","1","592.43","592.43","0","2018-08-17","2018-08-19","","0","1");
INSERT INTO contas_receber VALUES("14155","36","1381","2","1","592.43","592.43","0","2018-08-17","2018-09-19","","0","1");
INSERT INTO contas_receber VALUES("14156","36","1381","3","1","592.44","592.44","0","2018-08-17","2018-10-20","","0","1");
INSERT INTO contas_receber VALUES("14171","25","1358","1","1","608.42","0","608.42","2018-08-20","2018-09-21","","1","1");
INSERT INTO contas_receber VALUES("14172","25","1358","2","1","608.42","0","608.42","2018-08-20","2018-10-06","","1","1");
INSERT INTO contas_receber VALUES("14173","25","1358","3","1","608.41","0","608.41","2018-08-20","2018-10-21","","1","1");
INSERT INTO contas_receber VALUES("14177","62","1357","1","1","653.4","0","653.4","2018-08-20","2018-09-20","","1","1");
INSERT INTO contas_receber VALUES("14178","62","1357","2","1","653.4","0","653.4","2018-08-20","2018-10-05","","1","1");
INSERT INTO contas_receber VALUES("14179","62","1357","3","1","653.39","0","653.39","2018-08-20","2018-10-20","","1","1");
INSERT INTO contas_receber VALUES("14184","60","1361","1","1","793.96","0","793.96","2018-08-20","2018-09-21","","1","1");
INSERT INTO contas_receber VALUES("14185","60","1361","2","1","793.96","0","793.96","2018-08-20","2018-10-06","","1","1");
INSERT INTO contas_receber VALUES("14186","60","1361","4","1","94.8","0","94.8","2018-08-20","2018-10-25","","1","1");
INSERT INTO contas_receber VALUES("14187","60","1361","3","1","793.98","0","793.98","2018-08-20","2018-10-21","","1","1");
INSERT INTO contas_receber VALUES("14253","46","1374","1","1","224.04","0","224.04","2018-08-21","2018-09-20","","1","1");
INSERT INTO contas_receber VALUES("14254","28","1344","1","1","382.41","0","382.41","2018-08-21","2018-08-11","","1","1");
INSERT INTO contas_receber VALUES("14261","260","1351","1","1","106.62","0","106.62","2018-08-21","2018-08-11","","1","1");
INSERT INTO contas_receber VALUES("14262","193","1359","1","1","365.2","0","365.2","2018-08-21","2018-08-16","","1","1");
INSERT INTO contas_receber VALUES("14263","325","1362","1","1","149.53","0","149.53","2018-08-21","2018-08-15","","1","1");
INSERT INTO contas_receber VALUES("14264","378","1377","1","1","76.34","0","76.34","2018-08-21","2018-08-20","","1","1");
INSERT INTO contas_receber VALUES("14265","379","1380","1","1","165.4","0","165.4","2018-08-21","2018-08-19","","1","1");
INSERT INTO contas_receber VALUES("14266","375","1375","1","1","154.4","0","154.4","2018-08-21","2018-08-18","","1","1");
INSERT INTO contas_receber VALUES("14267","220","1365","1","1","3656.8","0","3656.8","2018-08-22","2018-09-22","","1","1");
INSERT INTO contas_receber VALUES("14268","220","1365","2","1","3656.8","0","3656.8","2018-08-22","2018-10-07","","1","1");
INSERT INTO contas_receber VALUES("14269","220","1365","3","1","3656.8","0","3656.8","2018-08-22","2018-10-22","","1","1");
INSERT INTO contas_receber VALUES("14270","6","1385","1","1","308.07","0","308.07","2018-08-22","2018-09-20","","1","1");
INSERT INTO contas_receber VALUES("14271","6","1385","2","1","308.07","0","308.07","2018-08-22","2018-09-27","","1","1");
INSERT INTO contas_receber VALUES("14272","6","1385","3","1","308.07","0","308.07","2018-08-22","2018-10-05","","1","1");
INSERT INTO contas_receber VALUES("14273","6","1385","4","1","308.07","0","308.07","2018-08-22","2018-10-12","","1","1");
INSERT INTO contas_receber VALUES("14274","6","1385","6","1","308.05","0","308.05","2018-08-22","2018-10-26","","1","1");
INSERT INTO contas_receber VALUES("14275","6","1385","5","1","308.07","0","308.07","2018-08-22","2018-10-19","","1","1");
INSERT INTO contas_receber VALUES("14276","31","1368","1","1","377","0","377","2018-08-22","2018-09-22","","1","1");
INSERT INTO contas_receber VALUES("14293","3","1392","1","1","24.76","0","24.76","2018-08-22","2018-08-23","","1","1");
INSERT INTO contas_receber VALUES("14294","383","1393","1","1","58.3","0","58.3","2018-08-22","2018-08-23","","1","1");
INSERT INTO contas_receber VALUES("14296","28","1394","1","1","68.04","0","68.04","2018-08-22","2018-08-23","","1","1");
INSERT INTO contas_receber VALUES("14309","108","1337","1","1","646.33","0","646.33","2018-08-23","2018-09-23","","1","1");
INSERT INTO contas_receber VALUES("14310","108","1337","2","1","646.33","0","646.33","2018-08-23","2018-10-08","","1","1");
INSERT INTO contas_receber VALUES("14311","108","1337","3","1","646.34","0","646.34","2018-08-23","2018-10-23","","1","1");
INSERT INTO contas_receber VALUES("14312","68","1366","1","1","1095","0","1095","2018-08-23","2018-09-05","","1","1");
INSERT INTO contas_receber VALUES("14313","68","1366","2","1","1095","0","1095","2018-08-23","2018-09-05","","1","1");
INSERT INTO contas_receber VALUES("14355","4","1367","1","1","1293","0","1293","2018-08-24","2018-09-24","","1","1");
INSERT INTO contas_receber VALUES("14356","4","1367","2","1","1293","0","1293","2018-08-24","2018-10-09","","1","1");
INSERT INTO contas_receber VALUES("14357","4","1367","3","1","1293","0","1293","2018-08-24","2018-10-24","","1","1");
INSERT INTO contas_receber VALUES("14358","221","1370","1","1","763.4","0","763.4","2018-08-24","2018-09-28","","1","1");
INSERT INTO contas_receber VALUES("14359","221","1370","3","1","763.4","0","763.4","2018-08-24","2018-10-30","","1","1");
INSERT INTO contas_receber VALUES("14360","221","1370","2","1","763.4","0","763.4","2018-08-24","2018-10-14","","1","1");
INSERT INTO contas_receber VALUES("14373","380","1383","1","1","503","0","503","2018-08-24","2018-10-01","","1","1");
INSERT INTO contas_receber VALUES("14374","380","1383","2","1","503","0","503","2018-08-24","2018-10-16","","1","1");
INSERT INTO contas_receber VALUES("14375","380","1383","3","1","503","0","503","2018-08-24","2018-11-01","","1","1");
INSERT INTO contas_receber VALUES("14382","17","1371","2","1","1213.03","0","1213.03","2018-08-27","2018-10-12","","1","1");
INSERT INTO contas_receber VALUES("14383","17","1371","3","1","1213.04","0","1213.04","2018-08-27","2018-10-27","","1","1");
INSERT INTO contas_receber VALUES("14384","17","1371","1","1","1213.03","0","1213.03","2018-08-27","2018-09-27","","1","1");
INSERT INTO contas_receber VALUES("14385","41","1372","1","1","929.83","0","929.83","2018-08-27","2018-09-27","","1","1");
INSERT INTO contas_receber VALUES("14386","41","1372","2","1","929.83","0","929.83","2018-08-27","2018-10-13","","1","1");
INSERT INTO contas_receber VALUES("14387","41","1372","3","1","929.84","0","929.84","2018-08-27","2018-10-29","","1","1");
INSERT INTO contas_receber VALUES("14418","40","1398","1","1","230","0","230","2018-08-27","2018-08-25","","1","1");
INSERT INTO contas_receber VALUES("14449","23","1379","1","1","425.93","0","425.93","2018-08-28","2018-09-29","","1","1");
INSERT INTO contas_receber VALUES("14450","23","1379","2","1","425.93","0","425.93","2018-08-28","2018-10-14","","1","1");
INSERT INTO contas_receber VALUES("14451","23","1379","4","1","535","0","535","2018-08-28","2018-09-30","","1","1");
INSERT INTO contas_receber VALUES("14452","23","1379","6","1","535","0","535","2018-08-28","2018-10-30","","1","1");
INSERT INTO contas_receber VALUES("14453","23","1379","5","1","535","0","535","2018-08-28","2018-10-15","","1","1");
INSERT INTO contas_receber VALUES("14454","23","1379","3","1","425.94","0","425.94","2018-08-28","2018-10-29","","1","1");
INSERT INTO contas_receber VALUES("14455","36","1382","1","1","592.43","0","592.43","2018-08-28","2018-09-30","","1","1");
INSERT INTO contas_receber VALUES("14456","36","1382","3","1","592.44","0","592.44","2018-08-28","2018-10-30","","1","1");
INSERT INTO contas_receber VALUES("14457","36","1382","2","1","592.43","0","592.43","2018-08-28","2018-10-15","","1","1");
INSERT INTO contas_receber VALUES("14458","101","1386","1","1","2183.48","0","2183.48","2018-08-28","2018-10-01","","1","1");
INSERT INTO contas_receber VALUES("14459","101","1386","2","1","2183.48","0","2183.48","2018-08-28","2018-10-16","","1","1");
INSERT INTO contas_receber VALUES("14460","101","1386","3","1","2183.49","0","2183.49","2018-08-28","2018-11-01","","1","1");
INSERT INTO contas_receber VALUES("14461","292","1388","1","1","1734","0","1734","2018-08-28","2018-09-28","","1","1");
INSERT INTO contas_receber VALUES("14462","292","1388","2","1","1734","0","1734","2018-08-28","2018-10-14","","1","1");
INSERT INTO contas_receber VALUES("14463","292","1388","3","1","1734","0","1734","2018-08-28","2018-10-28","","1","1");
INSERT INTO contas_receber VALUES("14472","381","1387","1","1","541.83","0","541.83","2018-08-29","2018-09-28","","1","1");
INSERT INTO contas_receber VALUES("14473","381","1387","2","1","541.83","0","541.83","2018-08-29","2018-10-14","","1","1");
INSERT INTO contas_receber VALUES("14474","381","1387","3","1","541.84","0","541.84","2018-08-29","2018-10-28","","1","1");
INSERT INTO contas_receber VALUES("14475","31","1395","1","1","405.29","0","405.29","2018-08-29","2018-09-29","","1","1");
INSERT INTO contas_receber VALUES("14476","31","1395","2","1","405.29","0","405.29","2018-08-29","2018-10-15","","1","1");
INSERT INTO contas_receber VALUES("14477","31","1395","3","1","405.28","0","405.28","2018-08-29","2018-10-29","","1","1");
INSERT INTO contas_receber VALUES("14484","172","1401","1","1","92.2","0","92.2","2018-08-29","2018-09-29","","1","1");
INSERT INTO contas_receber VALUES("14492","35","1414","1","1","73.78","0","73.78","2018-08-30","2018-08-31","","1","1");
INSERT INTO contas_receber VALUES("14498","387","1416","1","1","141.03","141.03","0","2018-08-30","2018-09-10","","0","0");
INSERT INTO contas_receber VALUES("14536","131","1422","1","1","206.5","206.5","0","2018-08-31","2018-09-01","","0","0");
INSERT INTO contas_receber VALUES("14538","166","1423","1","1","206.5","206.5","0","2018-08-31","2018-09-01","","0","0");
INSERT INTO contas_receber VALUES("14549","4","1389","1","1","1258.5","0","1258.5","2018-09-03","2018-10-03","","1","1");
INSERT INTO contas_receber VALUES("14550","4","1389","2","1","1258.5","0","1258.5","2018-09-03","2018-10-18","","1","1");
INSERT INTO contas_receber VALUES("14551","4","1389","3","1","1258.5","0","1258.5","2018-09-03","2018-11-03","","1","1");
INSERT INTO contas_receber VALUES("14552","384","1396","1","1","599.5","0","599.5","2018-09-03","2018-10-03","","1","1");
INSERT INTO contas_receber VALUES("14553","384","1396","2","1","599.5","0","599.5","2018-09-03","2018-10-18","","1","1");
INSERT INTO contas_receber VALUES("14554","384","1396","3","1","599.5","0","599.5","2018-09-03","2018-11-03","","1","1");
INSERT INTO contas_receber VALUES("14559","202","1425","1","1","744.75","744.75","0","2018-09-03","2018-09-05","","0","0");
INSERT INTO contas_receber VALUES("14560","202","1425","2","1","744.75","744.75","0","2018-09-03","2018-10-06","","0","0");
INSERT INTO contas_receber VALUES("14567","382","1390","1","1","3059.45","0","3059.45","2018-09-03","2018-10-04","","1","1");
INSERT INTO contas_receber VALUES("14568","382","1390","2","1","3059.45","0","3059.45","2018-09-03","2018-10-19","","1","1");
INSERT INTO contas_receber VALUES("14569","382","1390","3","1","3059.45","0","3059.45","2018-09-03","2018-11-04","","1","1");
INSERT INTO contas_receber VALUES("14580","385","1397","1","1","358.67","0","358.67","2018-09-04","2018-10-05","","1","1");
INSERT INTO contas_receber VALUES("14581","385","1397","3","1","358.67","0","358.67","2018-09-04","2018-11-05","","1","1");
INSERT INTO contas_receber VALUES("14582","385","1397","2","1","358.67","0","358.67","2018-09-04","2018-10-20","","1","1");
INSERT INTO contas_receber VALUES("14583","385","1397","4","1","358.69","0","358.69","2018-09-04","2018-11-20","","1","1");
INSERT INTO contas_receber VALUES("14584","314","1408","1","1","127.73","0","127.73","2018-09-04","2018-09-17","","1","1");
INSERT INTO contas_receber VALUES("14593","256","1399","1","1","420.07","420.07","0","2018-09-05","2018-10-06","","0","1");
INSERT INTO contas_receber VALUES("14594","256","1399","2","1","420.07","420.07","0","2018-09-05","2018-10-21","","0","1");
INSERT INTO contas_receber VALUES("14595","256","1399","3","1","420.06","420.06","0","2018-09-05","2018-11-06","","0","1");
INSERT INTO contas_receber VALUES("14596","128","1402","1","1","386.83","0","386.83","2018-09-05","2018-10-06","","1","1");
INSERT INTO contas_receber VALUES("14597","128","1402","3","1","386.84","0","386.84","2018-09-05","2018-11-06","","1","1");
INSERT INTO contas_receber VALUES("14598","128","1402","2","1","386.83","0","386.83","2018-09-05","2018-10-21","","1","1");
INSERT INTO contas_receber VALUES("14601","380","1405","3","1","1173.66","0","1173.66","2018-09-05","2018-11-06","","1","1");
INSERT INTO contas_receber VALUES("14602","380","1405","1","1","1173.67","0","1173.67","2018-09-05","2018-10-06","","1","1");
INSERT INTO contas_receber VALUES("14603","380","1405","2","1","1173.67","0","1173.67","2018-09-05","2018-10-21","","1","1");
INSERT INTO contas_receber VALUES("14625","391","1434","1","1","726.67","726.67","0","2018-09-05","2018-09-06","","0","0");
INSERT INTO contas_receber VALUES("14626","391","1434","2","1","726.67","726.67","0","2018-09-05","2018-10-07","","0","0");
INSERT INTO contas_receber VALUES("14627","391","1434","3","1","726.66","726.66","0","2018-09-05","2018-11-07","","0","0");
INSERT INTO contas_receber VALUES("14630","3","1412","1","1","109.06","0","109.06","2018-09-05","2018-09-02","","1","1");
INSERT INTO contas_receber VALUES("14631","3","1435","1","1","51.03","0","51.03","2018-09-05","2018-09-07","","1","1");
INSERT INTO contas_receber VALUES("14638","31","1431","1","1","322.7","0","322.7","2018-09-05","2018-10-05","","1","1");
INSERT INTO contas_receber VALUES("14639","390","1420","1","1","396","0","396","2018-09-05","2018-10-03","","1","1");
INSERT INTO contas_receber VALUES("14640","390","1420","2","1","396","0","396","2018-09-05","2018-10-31","","1","1");
INSERT INTO contas_receber VALUES("14651","220","1432","3","1","677.34","0","677.34","2018-09-06","2018-11-06","","1","1");
INSERT INTO contas_receber VALUES("14652","220","1432","1","1","677.33","0","677.33","2018-09-06","2018-10-06","","1","1");
INSERT INTO contas_receber VALUES("14653","220","1432","2","1","677.33","0","677.33","2018-09-06","2018-10-21","","1","1");
INSERT INTO contas_receber VALUES("14654","386","1400","3","1","494","0","494","2018-09-06","2018-11-06","","1","1");
INSERT INTO contas_receber VALUES("14655","386","1400","2","1","494","0","494","2018-09-06","2018-10-21","","1","1");
INSERT INTO contas_receber VALUES("14656","386","1400","1","1","494","0","494","2018-09-06","2018-10-06","","1","1");
INSERT INTO contas_receber VALUES("14657","94","1404","1","1","489.05","0","489.05","2018-09-06","2018-10-05","","1","1");
INSERT INTO contas_receber VALUES("14658","94","1404","2","1","489.05","0","489.05","2018-09-06","2018-11-05","","1","1");
INSERT INTO contas_receber VALUES("14672","21","1391","1","1","1903.2","0","1903.2","2018-09-10","2018-09-24","","1","1");
INSERT INTO contas_receber VALUES("14673","21","1391","2","1","1903.2","0","1903.2","2018-09-10","2018-10-04","","1","1");
INSERT INTO contas_receber VALUES("14674","21","1391","3","1","1903.2","0","1903.2","2018-09-10","2018-10-14","","1","1");
INSERT INTO contas_receber VALUES("14675","21","1391","4","1","1903.2","0","1903.2","2018-09-10","2018-10-24","","1","1");
INSERT INTO contas_receber VALUES("14676","21","1391","5","1","1903.2","0","1903.2","2018-09-10","2018-11-04","","1","1");
INSERT INTO contas_receber VALUES("14677","389","1418","1","1","397.67","0","397.67","2018-09-10","2018-10-10","","1","1");
INSERT INTO contas_receber VALUES("14678","389","1418","2","1","397.67","0","397.67","2018-09-10","2018-10-25","","1","1");
INSERT INTO contas_receber VALUES("14679","389","1418","3","1","397.66","0","397.66","2018-09-10","2018-11-10","","1","1");
INSERT INTO contas_receber VALUES("14684","392","1440","1","1","50.56","50.56","0","2018-09-10","2018-09-11","","0","0");
INSERT INTO contas_receber VALUES("14711","28","1410","1","1","69.9","0","69.9","2018-09-11","2018-08-31","","1","1");
INSERT INTO contas_receber VALUES("14727","220","1406","1","1","3717.27","0","3717.27","2018-09-12","2018-10-12","","1","1");
INSERT INTO contas_receber VALUES("14728","220","1406","2","1","3717.27","0","3717.27","2018-09-12","2018-10-27","","1","1");
INSERT INTO contas_receber VALUES("14729","220","1406","3","1","3717.26","0","3717.26","2018-09-12","2018-11-12","","1","1");
INSERT INTO contas_receber VALUES("14730","31","1429","1","1","322.7","0","322.7","2018-09-12","2018-10-12","","1","1");
INSERT INTO contas_receber VALUES("14731","31","1429","2","1","322.7","0","322.7","2018-09-12","2018-11-12","","1","1");
INSERT INTO contas_receber VALUES("14756","31","1441","1","1","352.1","0","352.1","2018-09-13","2018-10-13","","1","1");
INSERT INTO contas_receber VALUES("14757","31","1441","2","1","352.1","0","352.1","2018-09-13","2018-11-13","","1","1");
INSERT INTO contas_receber VALUES("14758","263","1419","1","1","864.25","0","864.25","2018-09-13","2018-09-24","","1","1");
INSERT INTO contas_receber VALUES("14759","263","1419","2","1","864.25","0","864.25","2018-09-13","2018-09-24","","1","1");
INSERT INTO contas_receber VALUES("14760","16","1421","1","1","1432.67","0","1432.67","2018-09-13","2018-10-14","","1","1");
INSERT INTO contas_receber VALUES("14761","16","1421","2","1","1432.67","0","1432.67","2018-09-13","2018-10-29","","1","1");
INSERT INTO contas_receber VALUES("14762","16","1421","3","1","1432.66","0","1432.66","2018-09-13","2018-11-14","","1","1");
INSERT INTO contas_receber VALUES("14763","19","1424","1","1","360.86","0","360.86","2018-09-13","2018-10-14","","1","1");
INSERT INTO contas_receber VALUES("14764","19","1424","2","1","360.86","0","360.86","2018-09-13","2018-11-14","","1","1");
INSERT INTO contas_receber VALUES("14823","203","1426","1","1","744.75","0","744.75","2018-09-14","2018-10-01","","1","1");
INSERT INTO contas_receber VALUES("14824","203","1426","2","1","744.75","0","744.75","2018-09-14","2018-10-01","","1","1");
INSERT INTO contas_receber VALUES("14849","4","1428","1","1","1217.67","0","1217.67","2018-09-17","2018-10-18","","1","1");
INSERT INTO contas_receber VALUES("14850","4","1428","2","1","1217.67","0","1217.67","2018-09-17","2018-11-02","","1","1");
INSERT INTO contas_receber VALUES("14851","4","1428","3","1","1217.66","0","1217.66","2018-09-17","2018-11-18","","1","1");
INSERT INTO contas_receber VALUES("14852","131","1427","1","1","268.9","0","268.9","2018-09-17","2018-10-17","","1","1");
INSERT INTO contas_receber VALUES("14892","373","1458","2","1","485.9","485.9","0","2018-09-17","2018-10-22","","0","0");
INSERT INTO contas_receber VALUES("14893","373","1458","1","1","485.9","485.9","0","2018-09-17","2018-09-21","","0","0");
INSERT INTO contas_receber VALUES("14894","373","1458","3","1","485.91","485.91","0","2018-09-17","2018-11-22","","0","0");
INSERT INTO contas_receber VALUES("14896","393","1460","1","1","46.12","46.12","0","2018-09-17","2018-09-18","","0","0");
INSERT INTO contas_receber VALUES("14897","47","1433","1","1","600.87","0","600.87","2018-09-18","2018-10-19","","1","1");
INSERT INTO contas_receber VALUES("14898","47","1433","2","1","600.87","0","600.87","2018-09-18","2018-11-03","","1","1");
INSERT INTO contas_receber VALUES("14899","47","1433","3","1","600.86","0","600.86","2018-09-18","2018-11-19","","1","1");
INSERT INTO contas_receber VALUES("14900","74","1436","2","1","2415.83","0","2415.83","2018-09-18","2018-11-20","","1","1");
INSERT INTO contas_receber VALUES("14901","74","1436","1","1","2415.83","0","2415.83","2018-09-18","2018-10-20","","1","1");
INSERT INTO contas_receber VALUES("14902","74","1436","3","1","2415.84","0","2415.84","2018-09-18","2018-12-20","","1","1");
INSERT INTO contas_receber VALUES("14903","373","1439","1","1","290.07","0","290.07","2018-09-18","2018-10-19","","1","1");
INSERT INTO contas_receber VALUES("14904","373","1439","2","1","290.07","0","290.07","2018-09-18","2018-11-19","","1","1");
INSERT INTO contas_receber VALUES("14905","316","1378","1","1","946.8","0","946.8","2018-09-18","2018-09-30","","1","1");
INSERT INTO contas_receber VALUES("14906","316","1378","2","1","946.8","0","946.8","2018-09-18","2018-10-15","","1","1");
INSERT INTO contas_receber VALUES("14907","316","1378","3","1","946.8","0","946.8","2018-09-18","2018-10-30","","1","1");
INSERT INTO contas_receber VALUES("14912","32","1462","1","1","111.5","0","111.5","2018-09-18","2018-09-19","","1","1");
INSERT INTO contas_receber VALUES("14913","32","1413","1","1","52.18","0","52.18","2018-09-18","2018-09-01","","1","1");
INSERT INTO contas_receber VALUES("14924","264","1445","1","1","184.2","0","184.2","2018-09-18","2018-09-14","","1","1");
INSERT INTO contas_receber VALUES("14994","44","1446","1","1","930.51","0","930.51","2018-09-20","2018-10-20","","1","1");
INSERT INTO contas_receber VALUES("14995","44","1446","3","1","930.52","0","930.52","2018-09-20","2018-11-20","","1","1");
INSERT INTO contas_receber VALUES("14996","44","1446","2","1","930.51","0","930.51","2018-09-20","2018-11-04","","1","1");
INSERT INTO contas_receber VALUES("14997","234","1447","1","1","537.95","537.95","0","2018-09-20","2018-10-21","","0","1");
INSERT INTO contas_receber VALUES("14998","234","1447","3","1","537.95","537.95","0","2018-09-20","2018-11-21","","0","1");
INSERT INTO contas_receber VALUES("14999","234","1447","2","1","537.95","537.95","0","2018-09-20","2018-11-05","","0","1");
INSERT INTO contas_receber VALUES("15000","234","1447","5","1","537.96","537.96","0","2018-09-20","2018-12-21","","0","1");
INSERT INTO contas_receber VALUES("15001","234","1447","4","1","537.95","537.95","0","2018-09-20","2018-12-06","","0","1");
INSERT INTO contas_receber VALUES("15002","84","1444","1","1","761.21","0","761.21","2018-09-20","2018-10-24","","1","1");
INSERT INTO contas_receber VALUES("15003","84","1444","3","1","761.22","0","761.22","2018-09-20","2018-11-24","","1","1");
INSERT INTO contas_receber VALUES("15004","84","1444","2","1","761.21","0","761.21","2018-09-20","2018-11-08","","1","1");
INSERT INTO contas_receber VALUES("15013","357","1438","1","1","401.12","0","401.12","2018-09-20","2018-10-20","","1","1");
INSERT INTO contas_receber VALUES("15014","357","1438","2","1","401.12","0","401.12","2018-09-20","2018-11-04","","1","1");
INSERT INTO contas_receber VALUES("15015","357","1438","3","1","401.11","0","401.11","2018-09-20","2018-11-20","","1","1");
INSERT INTO contas_receber VALUES("15039","28","1443","1","1","127.98","0","127.98","2018-09-20","2018-09-14","","1","1");
INSERT INTO contas_receber VALUES("15040","141","1430","1","1","398.33","0","398.33","2018-09-20","2018-10-18","","1","1");
INSERT INTO contas_receber VALUES("15041","141","1430","2","1","398.33","0","398.33","2018-09-20","2018-11-02","","1","1");
INSERT INTO contas_receber VALUES("15042","141","1430","3","1","398.34","0","398.34","2018-09-20","2018-11-18","","1","1");
INSERT INTO contas_receber VALUES("15044","3","1437","1","1","249.42","0","249.42","2018-09-20","2018-09-08","","1","1");
INSERT INTO contas_receber VALUES("15045","329","1449","1","1","264.3","0","264.3","2018-09-21","2018-10-24","","1","1");
INSERT INTO contas_receber VALUES("15046","329","1449","2","1","264.3","0","264.3","2018-09-21","2018-11-08","","1","1");
INSERT INTO contas_receber VALUES("15047","329","1449","3","1","264.3","0","264.3","2018-09-21","2018-11-24","","1","1");
INSERT INTO contas_receber VALUES("15048","91","1451","1","1","507.08","0","507.08","2018-09-21","2018-10-24","","1","1");
INSERT INTO contas_receber VALUES("15049","91","1451","3","1","507.09","0","507.09","2018-09-21","2018-11-24","","1","1");
INSERT INTO contas_receber VALUES("15050","91","1451","2","1","507.08","0","507.08","2018-09-21","2018-11-08","","1","1");
INSERT INTO contas_receber VALUES("15051","212","1448","1","1","727.12","0","727.12","2018-09-21","2018-10-25","","1","1");
INSERT INTO contas_receber VALUES("15052","212","1448","2","1","727.12","0","727.12","2018-09-21","2018-11-09","","1","1");
INSERT INTO contas_receber VALUES("15053","212","1448","3","1","727.11","0","727.11","2018-09-21","2018-11-25","","1","1");
INSERT INTO contas_receber VALUES("15054","4","1454","1","1","1192.83","0","1192.83","2018-09-21","2018-10-25","","1","1");
INSERT INTO contas_receber VALUES("15055","4","1454","2","1","1192.83","0","1192.83","2018-09-21","2018-11-09","","1","1");
INSERT INTO contas_receber VALUES("15056","4","1454","3","1","1192.84","0","1192.84","2018-09-21","2018-11-25","","1","1");
INSERT INTO contas_receber VALUES("15063","248","1411","1","1","43.05","0","43.05","2018-09-21","2018-08-31","","1","1");
INSERT INTO contas_receber VALUES("15064","374","1369","1","1","144.6","0","144.6","2018-09-21","2018-08-16","","1","1");
INSERT INTO contas_receber VALUES("15065","54","1384","1","1","142.11","0","142.11","2018-09-21","2018-08-22","","1","1");
INSERT INTO contas_receber VALUES("15066","255","1403","1","1","1744.86","0","1744.86","2018-09-21","2018-08-30","","1","1");
INSERT INTO contas_receber VALUES("15067","387","1409","1","1","148.45","0","148.45","2018-09-21","2018-09-10","","1","1");
INSERT INTO contas_receber VALUES("15068","388","1415","1","1","79.3","0","79.3","2018-09-21","2018-09-01","","1","1");
INSERT INTO contas_receber VALUES("15089","282","1452","1","1","402.07","0","402.07","2018-09-24","2018-10-26","","1","1");
INSERT INTO contas_receber VALUES("15090","282","1452","2","1","402.07","0","402.07","2018-09-24","2018-11-10","","1","1");
INSERT INTO contas_receber VALUES("15091","282","1452","3","1","402.06","0","402.06","2018-09-24","2018-11-26","","1","1");
INSERT INTO contas_receber VALUES("15102","253","1466","1","1","967.67","0","967.67","2018-09-24","2018-10-08","","1","1");
INSERT INTO contas_receber VALUES("15103","253","1466","2","1","239.22","0","239.22","2018-09-24","2018-10-08","","1","1");
INSERT INTO contas_receber VALUES("15122","192","1456","1","1","770.15","0","770.15","2018-09-25","2018-10-27","","1","1");
INSERT INTO contas_receber VALUES("15123","192","1456","2","1","770.15","0","770.15","2018-09-25","2018-10-27","","1","1");
INSERT INTO contas_receber VALUES("15124","65","1455","1","1","662.67","0","662.67","2018-09-25","2018-10-27","","1","1");
INSERT INTO contas_receber VALUES("15125","65","1455","3","1","662.66","0","662.66","2018-09-25","2018-11-27","","1","1");
INSERT INTO contas_receber VALUES("15126","65","1455","2","1","662.67","0","662.67","2018-09-25","2018-11-11","","1","1");
INSERT INTO contas_receber VALUES("15127","252","1457","1","1","529.83","0","529.83","2018-09-25","2018-10-27","","1","1");
INSERT INTO contas_receber VALUES("15128","252","1457","3","1","529.84","0","529.84","2018-09-25","2018-11-27","","1","1");
INSERT INTO contas_receber VALUES("15129","252","1457","2","1","529.83","0","529.83","2018-09-25","2018-11-11","","1","1");
INSERT INTO contas_receber VALUES("15130","195","1450","1","1","317.2","0","317.2","2018-09-25","2018-10-27","","1","1");
INSERT INTO contas_receber VALUES("15131","244","1464","1","1","485.9","0","485.9","2018-09-25","2018-10-27","","1","1");
INSERT INTO contas_receber VALUES("15132","244","1464","2","1","485.9","0","485.9","2018-09-25","2018-11-11","","1","1");
INSERT INTO contas_receber VALUES("15133","244","1464","3","1","485.91","0","485.91","2018-09-25","2018-11-27","","1","1");
INSERT INTO contas_receber VALUES("15134","322","1461","1","1","387.13","0","387.13","2018-09-25","2018-10-27","","1","1");
INSERT INTO contas_receber VALUES("15135","322","1461","2","1","387.13","0","387.13","2018-09-25","2018-11-11","","1","1");
INSERT INTO contas_receber VALUES("15136","322","1461","3","1","387.14","0","387.14","2018-09-25","2018-11-27","","1","1");
INSERT INTO contas_receber VALUES("15137","380","1463","1","1","771.2","0","771.2","2018-09-25","2018-10-27","","1","1");
INSERT INTO contas_receber VALUES("15138","380","1463","3","1","771.2","0","771.2","2018-09-25","2018-11-27","","1","1");
INSERT INTO contas_receber VALUES("15139","380","1463","2","1","771.2","0","771.2","2018-09-25","2018-11-11","","1","1");
INSERT INTO contas_receber VALUES("15140","179","1465","1","1","318.3","0","318.3","2018-09-25","2018-10-28","","1","1");
INSERT INTO contas_receber VALUES("15141","179","1465","2","1","318.3","0","318.3","2018-09-25","2018-11-12","","1","1");
INSERT INTO contas_receber VALUES("15142","179","1465","3","1","318.3","0","318.3","2018-09-25","2018-11-28","","1","1");
INSERT INTO contas_receber VALUES("15157","28","1477","1","1","97.42","0","97.42","2018-09-25","2018-09-24","","1","1");
INSERT INTO contas_receber VALUES("15188","35","1478","1","1","74.22","0","74.22","2018-09-26","2018-09-24","","1","1");
INSERT INTO contas_receber VALUES("15189","32","1488","1","1","27.1","0","27.1","2018-09-26","2018-09-28","","1","1");
INSERT INTO contas_receber VALUES("15190","193","1468","1","1","213.28","0","213.28","2018-09-26","2018-09-23","","1","1");
INSERT INTO contas_receber VALUES("15192","112","1459","1","1","125.14","0","125.14","2018-09-26","2018-09-20","","1","1");
INSERT INTO contas_receber VALUES("15195","60","1469","3","1","758","0","758","2018-09-27","2018-11-28","","1","1");
INSERT INTO contas_receber VALUES("15196","60","1469","1","1","758","0","758","2018-09-27","2018-10-28","","1","1");
INSERT INTO contas_receber VALUES("15197","60","1469","2","1","758","0","758","2018-09-27","2018-11-12","","1","1");
INSERT INTO contas_receber VALUES("15198","46","1480","1","1","288.95","0","288.95","2018-09-27","2018-10-28","","1","1");
INSERT INTO contas_receber VALUES("15199","31","1474","1","1","393.94","0","393.94","2018-09-27","2018-10-28","","1","1");
INSERT INTO contas_receber VALUES("15200","31","1474","2","1","393.94","0","393.94","2018-09-27","2018-11-28","","1","1");
INSERT INTO contas_receber VALUES("15201","24","1407","1","1","694.17","0","694.17","2018-09-27","2018-10-11","","1","1");
INSERT INTO contas_receber VALUES("15202","24","1407","2","1","694.18","0","694.18","2018-09-27","2018-10-11","","1","1");
INSERT INTO contas_receber VALUES("15203","25","1471","2","1","367.5","0","367.5","2018-09-27","2018-11-12","","1","1");
INSERT INTO contas_receber VALUES("15204","25","1471","1","1","367.5","0","367.5","2018-09-27","2018-10-28","","1","1");
INSERT INTO contas_receber VALUES("15205","25","1471","3","1","367.5","0","367.5","2018-09-27","2018-11-28","","1","1");
INSERT INTO contas_receber VALUES("15206","315","1467","1","1","564.33","0","564.33","2018-09-27","2018-11-01","","1","1");
INSERT INTO contas_receber VALUES("15207","315","1467","2","1","564.33","0","564.33","2018-09-27","2018-11-16","","1","1");
INSERT INTO contas_receber VALUES("15208","315","1467","3","1","564.34","0","564.34","2018-09-27","2018-12-01","","1","1");
INSERT INTO contas_receber VALUES("15209","67","1470","1","1","407.8","0","407.8","2018-09-27","2018-11-01","","1","1");
INSERT INTO contas_receber VALUES("15210","67","1470","3","1","407.8","0","407.8","2018-09-27","2018-12-01","","1","1");
INSERT INTO contas_receber VALUES("15211","67","1470","2","1","407.8","0","407.8","2018-09-27","2018-11-16","","1","1");
INSERT INTO contas_receber VALUES("15212","33","1473","1","1","2146.1","0","2146.1","2018-09-27","2018-09-23","","1","1");
INSERT INTO contas_receber VALUES("15213","37","1453","1","1","832.89","0","832.89","2018-09-27","2018-10-11","","1","1");
INSERT INTO contas_receber VALUES("15214","37","1453","2","1","832.89","0","832.89","2018-09-27","2018-10-11","","1","1");
INSERT INTO contas_receber VALUES("15249","201","1319","1","1","540.1","540.1","0","2018-09-28","2018-10-28","","0","1");
INSERT INTO contas_receber VALUES("15250","201","1319","2","1","540.1","540.1","0","2018-09-28","2018-11-28","","0","1");
INSERT INTO contas_receber VALUES("15263","220","1491","1","1","597.1","0","597.1","2018-09-28","2018-10-28","","1","1");
INSERT INTO contas_receber VALUES("15264","220","1491","2","1","597.1","0","597.1","2018-09-28","2018-11-12","","1","1");
INSERT INTO contas_receber VALUES("15265","220","1491","3","1","597.1","0","597.1","2018-09-28","2018-11-28","","1","1");
INSERT INTO contas_receber VALUES("15310","220","1472","1","1","3674.91","3674.91","0","2018-10-02","2018-11-03","","0","0");
INSERT INTO contas_receber VALUES("15311","220","1472","2","1","3674.91","3674.91","0","2018-10-02","2018-11-18","","0","0");
INSERT INTO contas_receber VALUES("15312","220","1472","3","1","3674.91","3674.91","0","2018-10-02","2018-12-03","","0","0");
INSERT INTO contas_receber VALUES("15313","220","1472","4","1","963.31","963.31","0","2018-10-02","2018-12-18","","0","0");
INSERT INTO contas_receber VALUES("15318","220","1500","1","1","3674.91","0","3674.91","2018-10-02","2018-11-03","","1","1");
INSERT INTO contas_receber VALUES("15319","220","1500","2","1","3674.91","0","3674.91","2018-10-02","2018-11-18","","1","1");
INSERT INTO contas_receber VALUES("15320","220","1500","3","1","3674.91","0","3674.91","2018-10-02","2018-12-03","","1","1");
INSERT INTO contas_receber VALUES("15321","220","1500","4","1","964.27","0","964.27","2018-10-02","2018-12-18","","1","1");
INSERT INTO contas_receber VALUES("15328","186","1475","1","1","388.13","0","388.13","2018-10-03","2018-11-02","","1","1");
INSERT INTO contas_receber VALUES("15329","186","1475","2","1","388.13","0","388.13","2018-10-03","2018-11-17","","1","1");
INSERT INTO contas_receber VALUES("15330","186","1475","3","1","388.14","0","388.14","2018-10-03","2018-12-02","","1","1");
INSERT INTO contas_receber VALUES("15331","76","1442","1","1","406.27","0","406.27","2018-10-03","2018-11-03","","1","1");
INSERT INTO contas_receber VALUES("15332","76","1442","2","1","406.27","0","406.27","2018-10-03","2018-11-18","","1","1");
INSERT INTO contas_receber VALUES("15333","76","1442","3","1","406.26","0","406.26","2018-10-03","2018-12-03","","1","1");
INSERT INTO contas_receber VALUES("15334","23","1476","2","1","484.63","0","484.63","2018-10-03","2018-11-17","","1","1");
INSERT INTO contas_receber VALUES("15335","23","1476","1","1","484.63","0","484.63","2018-10-03","2018-11-02","","1","1");
INSERT INTO contas_receber VALUES("15336","23","1476","3","1","484.64","0","484.64","2018-10-03","2018-12-02","","1","1");
INSERT INTO contas_receber VALUES("15337","25","1479","1","1","2080.98","0","2080.98","2018-10-03","2018-11-04","","1","1");
INSERT INTO contas_receber VALUES("15338","25","1479","2","1","2080.98","0","2080.98","2018-10-03","2018-11-19","","1","1");
INSERT INTO contas_receber VALUES("15339","25","1479","3","1","2080.99","0","2080.99","2018-10-03","2018-12-04","","1","1");
INSERT INTO contas_receber VALUES("15345","384","1503","2","1","316.67","316.67","0","2018-10-03","2018-11-04","","0","0");
INSERT INTO contas_receber VALUES("15346","384","1503","1","1","316.67","316.67","0","2018-10-03","2018-10-04","","0","0");
INSERT INTO contas_receber VALUES("15347","384","1503","3","1","316.66","316.66","0","2018-10-03","2018-12-05","","0","0");
INSERT INTO contas_receber VALUES("15363","292","1492","1","1","1106.8","0","1106.8","2018-10-04","2018-11-05","","1","1");
INSERT INTO contas_receber VALUES("15364","292","1492","2","1","1106.8","0","1106.8","2018-10-04","2018-11-20","","1","1");
INSERT INTO contas_receber VALUES("15365","292","1492","3","1","1106.8","0","1106.8","2018-10-04","2018-12-05","","1","1");
INSERT INTO contas_receber VALUES("15366","397","1505","1","1","495","0","495","2018-10-04","2018-11-05","","1","1");
INSERT INTO contas_receber VALUES("15367","84","1501","1","1","784.58","0","784.58","2018-10-04","2018-11-05","","1","1");
INSERT INTO contas_receber VALUES("15368","84","1501","3","1","784.59","0","784.59","2018-10-04","2018-12-05","","1","1");
INSERT INTO contas_receber VALUES("15369","84","1501","4","1","424.45","0","424.45","2018-10-04","2018-12-14","","1","1");
INSERT INTO contas_receber VALUES("15370","84","1501","2","1","784.58","0","784.58","2018-10-04","2018-11-20","","1","1");
INSERT INTO contas_receber VALUES("15385","30","1506","1","1","889.69","889.69","0","2018-10-04","2018-10-07","","0","0");
INSERT INTO contas_receber VALUES("15386","30","1506","3","1","889.69","889.69","0","2018-10-04","2018-12-08","","0","0");
INSERT INTO contas_receber VALUES("15387","30","1506","2","1","889.69","889.69","0","2018-10-04","2018-11-07","","0","0");
INSERT INTO contas_receber VALUES("15388","30","1506","4","1","889.68","889.68","0","2018-10-04","2019-01-08","","0","0");
INSERT INTO contas_receber VALUES("15414","354","1481","1","1","279.86","0","279.86","2018-10-05","2018-11-04","","1","1");
INSERT INTO contas_receber VALUES("15415","354","1481","2","1","279.86","0","279.86","2018-10-05","2018-12-04","","1","1");
INSERT INTO contas_receber VALUES("15416","354","1481","3","1","30.52","0","30.52","2018-10-05","2018-11-14","","1","1");
INSERT INTO contas_receber VALUES("15417","42","1482","1","1","743.33","0","743.33","2018-10-05","2018-11-04","","1","1");
INSERT INTO contas_receber VALUES("15418","42","1482","2","1","743.33","0","743.33","2018-10-05","2018-11-19","","1","1");
INSERT INTO contas_receber VALUES("15419","42","1482","3","1","743.34","0","743.34","2018-10-05","2018-12-04","","1","1");
INSERT INTO contas_receber VALUES("15446","303","1483","1","1","812.23","0","812.23","2018-10-08","2018-11-05","","1","1");
INSERT INTO contas_receber VALUES("15447","303","1483","2","1","812.23","0","812.23","2018-10-08","2018-11-20","","1","1");
INSERT INTO contas_receber VALUES("15448","303","1483","3","1","812.24","0","812.24","2018-10-08","2018-12-05","","1","1");
INSERT INTO contas_receber VALUES("15449","98","1486","1","1","783.33","0","783.33","2018-10-08","2018-11-05","","1","1");
INSERT INTO contas_receber VALUES("15450","98","1486","3","1","783.34","0","783.34","2018-10-08","2019-01-05","","1","1");
INSERT INTO contas_receber VALUES("15451","98","1486","2","1","783.33","0","783.33","2018-10-08","2018-12-05","","1","1");
INSERT INTO contas_receber VALUES("15479","302","1515","1","1","347.7","347.7","0","2018-10-09","2018-10-10","","0","0");
INSERT INTO contas_receber VALUES("15480","68","1490","1","1","169.2","0","169.2","2018-10-09","2018-10-22","","1","1");
INSERT INTO contas_receber VALUES("15481","169","1493","1","1","83.1","0","83.1","2018-10-09","2018-11-09","","1","1");
INSERT INTO contas_receber VALUES("15482","12","1499","1","1","373.03","0","373.03","2018-10-09","2018-11-11","","1","1");
INSERT INTO contas_receber VALUES("15483","12","1499","2","1","373.03","0","373.03","2018-10-09","2018-11-26","","1","1");
INSERT INTO contas_receber VALUES("15484","12","1499","3","1","373.04","0","373.04","2018-10-09","2018-12-11","","1","1");
INSERT INTO contas_receber VALUES("15485","394","1484","1","1","417.33","0","417.33","2018-10-09","2018-11-05","","1","1");
INSERT INTO contas_receber VALUES("15486","394","1484","2","1","417.33","0","417.33","2018-10-09","2018-11-20","","1","1");
INSERT INTO contas_receber VALUES("15487","394","1484","3","1","417.34","0","417.34","2018-10-09","2018-12-05","","1","1");
INSERT INTO contas_receber VALUES("15558","4","1489","1","1","1192.83","0","1192.83","2018-10-10","2018-11-08","","1","1");
INSERT INTO contas_receber VALUES("15559","4","1489","3","1","1192.84","0","1192.84","2018-10-10","2018-12-08","","1","1");
INSERT INTO contas_receber VALUES("15560","4","1489","2","1","1192.83","0","1192.83","2018-10-10","2018-11-23","","1","1");
INSERT INTO contas_receber VALUES("15561","396","1494","2","1","926.55","0","926.55","2018-10-10","2018-10-25","","1","1");
INSERT INTO contas_receber VALUES("15562","396","1494","1","1","926.55","0","926.55","2018-10-10","2018-10-25","","1","1");
INSERT INTO contas_receber VALUES("15597","9","1498","1","1","1469.05","0","1469.05","2018-10-11","2018-11-11","","1","1");
INSERT INTO contas_receber VALUES("15598","9","1498","2","1","1469.05","0","1469.05","2018-10-11","2018-11-26","","1","1");
INSERT INTO contas_receber VALUES("15599","9","1498","3","1","1469.04","0","1469.04","2018-10-11","2018-12-11","","1","1");
INSERT INTO contas_receber VALUES("15600","31","1507","1","1","352.1","0","352.1","2018-10-11","2018-11-11","","1","1");
INSERT INTO contas_receber VALUES("15601","31","1507","2","1","352.1","0","352.1","2018-10-11","2018-12-11","","1","1");
INSERT INTO contas_receber VALUES("15602","380","1509","1","1","922.33","0","922.33","2018-10-11","2018-11-15","","1","1");
INSERT INTO contas_receber VALUES("15603","380","1509","2","1","922.33","0","922.33","2018-10-11","2018-11-30","","1","1");
INSERT INTO contas_receber VALUES("15604","380","1509","3","1","922.34","0","922.34","2018-10-11","2018-12-15","","1","1");
INSERT INTO contas_receber VALUES("15652","345","1508","1","1","496.48","0","496.48","2018-10-15","2018-11-15","","1","1");
INSERT INTO contas_receber VALUES("15653","345","1508","2","1","496.48","0","496.48","2018-10-15","2018-11-30","","1","1");
INSERT INTO contas_receber VALUES("15654","345","1508","3","1","496.49","0","496.49","2018-10-15","2018-12-15","","1","1");
INSERT INTO contas_receber VALUES("15655","47","1510","1","1","565.6","0","565.6","2018-10-15","2018-11-16","","1","1");
INSERT INTO contas_receber VALUES("15656","47","1510","2","1","565.6","0","565.6","2018-10-15","2018-12-01","","1","1");
INSERT INTO contas_receber VALUES("15657","47","1510","3","1","565.6","0","565.6","2018-10-15","2018-12-16","","1","1");
INSERT INTO contas_receber VALUES("15658","205","1513","1","1","429.1","0","429.1","2018-10-15","2018-11-17","","1","1");
INSERT INTO contas_receber VALUES("15659","205","1513","2","1","429.1","0","429.1","2018-10-15","2018-12-02","","1","1");
INSERT INTO contas_receber VALUES("15660","205","1513","3","1","429.1","0","429.1","2018-10-15","2018-12-17","","1","1");
INSERT INTO contas_receber VALUES("15664","129","1514","1","1","575.87","0","575.87","2018-10-15","2018-11-17","","1","1");
INSERT INTO contas_receber VALUES("15665","129","1514","2","1","575.87","0","575.87","2018-10-15","2018-12-02","","1","1");
INSERT INTO contas_receber VALUES("15666","129","1514","3","1","575.86","0","575.86","2018-10-15","2018-12-17","","1","1");
INSERT INTO contas_receber VALUES("15667","30","1511","1","1","847.35","0","847.35","2018-10-15","2018-11-18","","1","1");
INSERT INTO contas_receber VALUES("15668","30","1511","3","1","847.35","0","847.35","2018-10-15","2018-12-08","","1","1");
INSERT INTO contas_receber VALUES("15669","30","1511","2","1","847.35","0","847.35","2018-10-15","2018-11-28","","1","1");
INSERT INTO contas_receber VALUES("15670","30","1511","5","1","847.35","0","847.35","2018-10-15","2018-12-28","","1","1");
INSERT INTO contas_receber VALUES("15671","30","1511","4","1","847.35","0","847.35","2018-10-15","2018-12-18","","1","1");
INSERT INTO contas_receber VALUES("15706","3","1517","1","1","33.12","0","33.12","2018-10-15","2018-10-11","","1","1");
INSERT INTO contas_receber VALUES("15707","113","1496","1","1","430.5","0","430.5","2018-10-16","2018-11-10","","1","1");
INSERT INTO contas_receber VALUES("15708","113","1496","3","1","430.5","0","430.5","2018-10-16","2018-12-10","","1","1");
INSERT INTO contas_receber VALUES("15709","113","1496","2","1","430.5","0","430.5","2018-10-16","2018-11-25","","1","1");
INSERT INTO contas_receber VALUES("15710","8","1512","1","1","530","0","530","2018-10-16","2018-11-18","","1","1");
INSERT INTO contas_receber VALUES("15711","8","1512","2","1","530","0","530","2018-10-16","2018-12-03","","1","1");
INSERT INTO contas_receber VALUES("15712","8","1512","3","1","529.99","0","529.99","2018-10-16","2018-12-18","","1","1");
INSERT INTO contas_receber VALUES("15713","4","1519","2","1","1234.67","0","1234.67","2018-10-16","2018-12-03","","1","1");
INSERT INTO contas_receber VALUES("15714","4","1519","1","1","1234.67","0","1234.67","2018-10-16","2018-11-18","","1","1");
INSERT INTO contas_receber VALUES("15715","4","1519","3","1","1234.66","0","1234.66","2018-10-16","2018-12-18","","1","1");
INSERT INTO contas_receber VALUES("15719","25","1518","3","1","385","0","385","2018-10-16","2018-12-18","","1","1");
INSERT INTO contas_receber VALUES("15720","25","1518","1","1","385","0","385","2018-10-16","2018-11-18","","1","1");
INSERT INTO contas_receber VALUES("15721","25","1518","2","1","385","0","385","2018-10-16","2018-12-03","","1","1");
INSERT INTO contas_receber VALUES("15750","70","1520","1","1","763.4","0","763.4","2018-10-17","2018-10-30","","1","1");
INSERT INTO contas_receber VALUES("15751","70","1520","2","1","763.4","0","763.4","2018-10-17","2018-10-30","","1","1");
INSERT INTO contas_receber VALUES("15804","22","1523","1","1","530.34","0","530.34","2018-10-18","2018-11-19","","1","1");
INSERT INTO contas_receber VALUES("15805","22","1523","2","1","530.34","0","530.34","2018-10-18","2018-12-04","","1","1");
INSERT INTO contas_receber VALUES("15806","22","1523","3","1","530.35","0","530.35","2018-10-18","2018-12-19","","1","1");
INSERT INTO contas_receber VALUES("15807","229","1521","4","1","1402.23","0","1402.23","2018-10-18","2019-01-04","","1","1");
INSERT INTO contas_receber VALUES("15808","229","1521","2","1","1402.25","0","1402.25","2018-10-18","2018-12-04","","1","1");
INSERT INTO contas_receber VALUES("15809","229","1521","1","1","1402.25","0","1402.25","2018-10-18","2018-11-19","","1","1");
INSERT INTO contas_receber VALUES("15810","229","1521","3","1","1402.25","0","1402.25","2018-10-18","2018-12-19","","1","1");
INSERT INTO contas_receber VALUES("15828","19","1497","1","1","412.19","0","412.19","2018-10-18","2018-11-10","","1","1");
INSERT INTO contas_receber VALUES("15829","19","1497","2","1","412.19","0","412.19","2018-10-18","2018-12-10","","1","1");
INSERT INTO contas_receber VALUES("15830","395","1487","1","1","1043.33","1043.33","0","2018-10-18","2018-11-05","","0","1");
INSERT INTO contas_receber VALUES("15831","395","1487","2","1","1043.33","1043.33","0","2018-10-18","2018-12-05","","0","1");
INSERT INTO contas_receber VALUES("15832","395","1487","3","1","1043.34","1043.34","0","2018-10-18","2019-01-05","","0","1");
INSERT INTO contas_receber VALUES("15833","28","1485","1","1","123.71","0","123.71","2018-10-18","2018-09-27","","1","1");
INSERT INTO contas_receber VALUES("15834","199","1502","1","1","39.4","0","39.4","2018-10-18","2018-10-05","","1","1");
INSERT INTO contas_receber VALUES("15835","96","1504","1","1","24.76","0","24.76","2018-10-18","2018-10-05","","1","1");
INSERT INTO contas_receber VALUES("15836","32","1516","1","1","249.32","0","249.32","2018-10-18","2018-10-11","","1","1");
INSERT INTO contas_receber VALUES("15841","6","1522","1","1","385.45","0","385.45","2018-10-19","2018-11-22","","1","1");
INSERT INTO contas_receber VALUES("15842","6","1522","2","1","385.45","0","385.45","2018-10-19","2018-12-02","","1","1");
INSERT INTO contas_receber VALUES("15843","6","1522","3","1","385.45","0","385.45","2018-10-19","2018-12-12","","1","1");
INSERT INTO contas_receber VALUES("15844","6","1522","4","1","385.45","0","385.45","2018-10-19","2018-12-22","","1","1");
INSERT INTO contas_receber VALUES("15845","143","1525","1","1","1449.7","0","1449.7","2018-10-19","2018-10-16","","1","1");
INSERT INTO contas_receber VALUES("15846","398","1524","1","1","1286","0","1286","2018-10-19","2018-10-12","","1","1");
INSERT INTO contas_receber VALUES("15847","337","1526","1","1","377","0","377","2018-10-19","2018-11-22","","1","1");
INSERT INTO contas_receber VALUES("15848","337","1526","2","1","377","0","377","2018-10-19","2018-12-22","","1","1");
INSERT INTO contas_receber VALUES("15880","83","1533","1","1","181.28","0","181.28","2018-10-19","2018-11-23","","1","1");
INSERT INTO contas_receber VALUES("15881","83","1533","2","1","181.27","0","181.27","2018-10-19","2018-12-23","","1","1");
INSERT INTO contas_receber VALUES("15908","31","1536","1","1","483.52","0","483.52","2018-10-22","2018-11-23","","1","1");
INSERT INTO contas_receber VALUES("15909","31","1536","2","1","483.52","0","483.52","2018-10-22","2018-12-08","","1","1");
INSERT INTO contas_receber VALUES("15910","31","1536","3","1","483.51","0","483.51","2018-10-22","2018-12-23","","1","1");
INSERT INTO contas_receber VALUES("15911","220","1527","2","1","2625.72","0","2625.72","2018-10-23","2018-12-08","","1","1");
INSERT INTO contas_receber VALUES("15912","220","1527","3","1","2625.72","0","2625.72","2018-10-23","2018-12-23","","1","1");
INSERT INTO contas_receber VALUES("15913","220","1527","1","1","2625.72","0","2625.72","2018-10-23","2018-11-23","","1","1");
INSERT INTO contas_receber VALUES("15914","220","1527","4","1","283.54","0","283.54","2018-10-23","2018-12-15","","1","1");
INSERT INTO contas_receber VALUES("15915","382","1530","1","1","2178.5","0","2178.5","2018-10-23","2018-11-24","","1","1");
INSERT INTO contas_receber VALUES("15916","382","1530","2","1","2178.5","0","2178.5","2018-10-23","2018-12-24","","1","1");
INSERT INTO contas_receber VALUES("15917","382","1530","3","1","2178.5","0","2178.5","2018-10-23","2019-01-24","","1","1");
INSERT INTO contas_receber VALUES("15918","310","1528","1","1","1693.13","0","1693.13","2018-10-23","2018-11-25","","1","1");
INSERT INTO contas_receber VALUES("15919","310","1528","2","1","1693.13","0","1693.13","2018-10-23","2018-12-11","","1","1");
INSERT INTO contas_receber VALUES("15920","310","1528","3","1","1693.14","0","1693.14","2018-10-23","2018-12-25","","1","1");
INSERT INTO contas_receber VALUES("15959","292","1538","1","1","2164","0","2164","2018-10-23","2018-11-26","","1","1");
INSERT INTO contas_receber VALUES("15960","292","1538","2","1","2164","0","2164","2018-10-23","2018-12-11","","1","1");
INSERT INTO contas_receber VALUES("15961","292","1538","3","1","2164","0","2164","2018-10-23","2018-12-26","","1","1");
INSERT INTO contas_receber VALUES("16018","203","1535","1","1","1272.25","1272.25","0","2018-10-25","2018-11-09","","0","1");
INSERT INTO contas_receber VALUES("16019","203","1535","2","1","1272.25","1272.25","0","2018-10-25","2018-11-09","","0","1");
INSERT INTO contas_receber VALUES("16020","192","1534","1","1","1151.4","0","1151.4","2018-10-25","2018-10-19","","1","1");
INSERT INTO contas_receber VALUES("16021","402","1549","1","1","992.3","0","992.3","2018-10-25","2018-11-26","","1","1");
INSERT INTO contas_receber VALUES("16028","203","1560","1","1","1272.33","0","1272.33","2018-10-25","2018-11-09","","1","1");
INSERT INTO contas_receber VALUES("16029","203","1560","2","1","1272.34","0","1272.34","2018-10-25","2018-11-09","","1","1");
INSERT INTO contas_receber VALUES("16030","203","1560","3","1","437.83","0","437.83","2018-10-25","2018-11-09","","1","1");
INSERT INTO contas_receber VALUES("16032","3","1561","1","1","10.82","10.82","0","2018-10-25","2018-10-26","","0","0");
INSERT INTO contas_receber VALUES("16033","3","1532","1","1","10.82","0","10.82","2018-10-25","2018-10-17","","1","1");
INSERT INTO contas_receber VALUES("16038","120","1531","1","1","92.2","0","92.2","2018-10-25","2018-10-17","","1","1");
INSERT INTO contas_receber VALUES("16039","255","1541","1","1","1432.5","0","1432.5","2018-10-26","2018-11-14","","1","1");
INSERT INTO contas_receber VALUES("16040","399","1539","1","1","131.76","0","131.76","2018-10-26","2018-10-20","","1","1");
INSERT INTO contas_receber VALUES("16041","93","1554","1","1","314.35","0","314.35","2018-10-26","2018-11-26","","1","1");
INSERT INTO contas_receber VALUES("16042","93","1554","2","1","314.35","0","314.35","2018-10-26","2018-12-26","","1","1");
INSERT INTO contas_receber VALUES("16043","224","1558","1","1","61.68","0","61.68","2018-10-26","2018-12-26","","1","1");
INSERT INTO contas_receber VALUES("16056","36","1529","1","1","614.07","0","614.07","2018-10-26","2018-11-26","","1","1");
INSERT INTO contas_receber VALUES("16057","36","1529","3","1","614.07","0","614.07","2018-10-26","2018-12-26","","1","1");
INSERT INTO contas_receber VALUES("16058","36","1529","2","1","614.07","0","614.07","2018-10-26","2018-12-11","","1","1");
INSERT INTO contas_receber VALUES("16059","303","1537","1","1","616.66","0","616.66","2018-10-29","2018-11-29","","1","1");
INSERT INTO contas_receber VALUES("16060","303","1537","2","1","616.66","0","616.66","2018-10-29","2018-12-14","","1","1");
INSERT INTO contas_receber VALUES("16061","303","1537","3","1","616.68","0","616.68","2018-10-29","2018-12-29","","1","1");
INSERT INTO contas_receber VALUES("16062","303","1537","4","1","99","0","99","2018-10-29","2018-12-18","","1","1");
INSERT INTO contas_receber VALUES("16063","291","1542","1","1","336.05","0","336.05","2018-10-29","2018-11-29","","1","1");
INSERT INTO contas_receber VALUES("16064","291","1542","2","1","336.05","0","336.05","2018-10-29","2018-12-14","","1","1");
INSERT INTO contas_receber VALUES("16065","291","1542","3","1","336.05","0","336.05","2018-10-29","2018-12-29","","1","1");
INSERT INTO contas_receber VALUES("16066","212","1543","1","1","676.02","0","676.02","2018-10-29","2018-11-30","","1","1");
INSERT INTO contas_receber VALUES("16067","212","1543","2","1","676.02","0","676.02","2018-10-29","2018-12-15","","1","1");
INSERT INTO contas_receber VALUES("16068","212","1543","3","1","676.02","0","676.02","2018-10-29","2018-12-30","","1","1");
INSERT INTO contas_receber VALUES("16071","125","1545","1","1","535.5","0","535.5","2018-10-29","2018-11-30","","1","1");
INSERT INTO contas_receber VALUES("16072","125","1545","2","1","535.5","0","535.5","2018-10-29","2018-12-15","","1","1");
INSERT INTO contas_receber VALUES("16073","125","1545","3","1","535.5","0","535.5","2018-10-29","2018-12-30","","1","1");
INSERT INTO contas_receber VALUES("16090","127","1546","1","1","441.17","0","441.17","2018-10-30","2018-11-30","","1","1");
INSERT INTO contas_receber VALUES("16091","127","1546","2","1","441.17","0","441.17","2018-10-30","2018-12-15","","1","1");
INSERT INTO contas_receber VALUES("16092","127","1546","3","1","441.16","0","441.16","2018-10-30","2018-12-30","","1","1");
INSERT INTO contas_receber VALUES("16093","385","1555","1","1","442.25","0","442.25","2018-10-30","2018-11-30","","1","1");
INSERT INTO contas_receber VALUES("16094","385","1555","2","1","442.25","0","442.25","2018-10-30","2018-12-15","","1","1");
INSERT INTO contas_receber VALUES("16095","385","1555","3","1","442.25","0","442.25","2018-10-30","2018-12-30","","1","1");
INSERT INTO contas_receber VALUES("16096","385","1555","4","1","442.25","0","442.25","2018-10-30","2019-01-15","","1","1");
INSERT INTO contas_receber VALUES("16097","380","1551","1","1","1240.96","0","1240.96","2018-10-30","2018-12-01","","1","1");
INSERT INTO contas_receber VALUES("16098","380","1551","2","1","1240.96","0","1240.96","2018-10-30","2018-12-16","","1","1");
INSERT INTO contas_receber VALUES("16099","380","1551","3","1","1240.96","0","1240.96","2018-10-30","2019-01-01","","1","1");
INSERT INTO contas_receber VALUES("16100","59","1552","1","1","396.9","0","396.9","2018-10-30","2018-12-01","","1","1");
INSERT INTO contas_receber VALUES("16101","59","1552","2","1","396.9","0","396.9","2018-10-30","2018-12-16","","1","1");
INSERT INTO contas_receber VALUES("16102","59","1552","3","1","396.9","0","396.9","2018-10-30","2019-01-01","","1","1");
INSERT INTO contas_receber VALUES("16106","308","1567","1","1","880.8","880.8","0","2018-10-30","2018-11-01","","0","0");
INSERT INTO contas_receber VALUES("16107","308","1567","2","1","880.8","880.8","0","2018-10-30","2018-12-02","","0","0");
INSERT INTO contas_receber VALUES("16108","308","1567","3","1","880.8","880.8","0","2018-10-30","2019-01-02","","0","0");
INSERT INTO contas_receber VALUES("16123","19","1553","1","1","338.56","0","338.56","2018-10-30","2018-12-01","","1","1");
INSERT INTO contas_receber VALUES("16124","19","1553","2","1","338.55","0","338.55","2018-10-30","2019-01-01","","1","1");
INSERT INTO contas_receber VALUES("16125","176","1550","1","1","556.5","0","556.5","2018-10-30","2018-12-01","","1","1");
INSERT INTO contas_receber VALUES("16126","176","1550","2","1","556.5","0","556.5","2018-10-30","2019-01-01","","1","1");
INSERT INTO contas_receber VALUES("16127","176","1550","3","1","556.5","0","556.5","2018-10-30","2019-01-16","","1","1");
INSERT INTO contas_receber VALUES("16128","176","1550","4","1","556.5","0","556.5","2018-10-30","2019-01-31","","1","1");
INSERT INTO contas_receber VALUES("16133","32","1544","1","1","162.9","0","162.9","2018-10-30","2018-10-21","","1","1");
INSERT INTO contas_receber VALUES("16134","401","1547","1","1","196","0","196","2018-10-30","2018-10-24","","1","1");
INSERT INTO contas_receber VALUES("16141","326","1548","1","1","428.23","0","428.23","2018-10-31","2018-12-01","","1","1");
INSERT INTO contas_receber VALUES("16142","326","1548","2","1","428.23","0","428.23","2018-10-31","2018-12-16","","1","1");
INSERT INTO contas_receber VALUES("16143","326","1548","3","1","428.24","0","428.24","2018-10-31","2019-01-01","","1","1");
INSERT INTO contas_receber VALUES("16144","403","1557","1","1","122.35","0","122.35","2018-10-31","2018-12-01","","1","1");
INSERT INTO contas_receber VALUES("16145","46","1564","1","1","323.3","0","323.3","2018-10-31","2018-12-01","","1","1");
INSERT INTO contas_receber VALUES("16146","292","1563","1","1","450.67","0","450.67","2018-10-31","2018-12-01","","1","1");
INSERT INTO contas_receber VALUES("16147","292","1563","2","1","450.67","0","450.67","2018-10-31","2018-12-16","","1","1");
INSERT INTO contas_receber VALUES("16148","292","1563","3","1","450.66","0","450.66","2018-10-31","2019-01-01","","1","1");
INSERT INTO contas_receber VALUES("16161","12","1556","1","1","367.4","0","367.4","2018-11-01","2018-12-01","","1","1");
INSERT INTO contas_receber VALUES("16162","4","1559","1","1","1148","0","1148","2018-11-01","2018-12-05","","1","1");
INSERT INTO contas_receber VALUES("16163","4","1559","2","1","1148","0","1148","2018-11-01","2018-12-20","","1","1");
INSERT INTO contas_receber VALUES("16164","4","1559","3","1","1148","0","1148","2018-11-01","2019-01-05","","1","1");
INSERT INTO contas_receber VALUES("16165","68","1562","1","1","1622.5","0","1622.5","2018-11-01","2018-11-20","","1","1");
INSERT INTO contas_receber VALUES("16166","68","1562","2","1","1622.5","0","1622.5","2018-11-01","2018-11-20","","1","1");
INSERT INTO contas_receber VALUES("16179","344","1575","1","1","880.8","0","880.8","2018-11-01","2018-12-06","","1","1");
INSERT INTO contas_receber VALUES("16180","344","1575","2","1","880.8","0","880.8","2018-11-01","2018-12-21","","1","1");
INSERT INTO contas_receber VALUES("16181","344","1575","3","1","880.8","0","880.8","2018-11-01","2019-01-06","","1","1");
INSERT INTO contas_receber VALUES("16190","404","1566","1","1","438","0","438","2018-11-05","2018-10-31","","1","1");
INSERT INTO contas_receber VALUES("16207","47","1565","1","1","552.32","0","552.32","2018-11-06","2018-12-06","","1","1");
INSERT INTO contas_receber VALUES("16208","47","1565","3","1","552.32","0","552.32","2018-11-06","2019-01-06","","1","1");
INSERT INTO contas_receber VALUES("16209","47","1565","2","1","552.32","0","552.32","2018-11-06","2018-12-21","","1","1");
INSERT INTO contas_receber VALUES("16210","337","1570","1","1","251.33","0","251.33","2018-11-06","2018-12-07","","1","1");
INSERT INTO contas_receber VALUES("16211","337","1570","3","1","251.34","0","251.34","2018-11-06","2019-01-07","","1","1");
INSERT INTO contas_receber VALUES("16212","337","1570","2","1","251.33","0","251.33","2018-11-06","2018-12-22","","1","1");
INSERT INTO contas_receber VALUES("16213","211","1569","1","1","757.57","0","757.57","2018-11-06","2018-12-07","","1","1");
INSERT INTO contas_receber VALUES("16214","211","1569","2","1","757.57","0","757.57","2018-11-06","2018-12-22","","1","1");
INSERT INTO contas_receber VALUES("16215","211","1569","3","1","757.56","0","757.56","2018-11-06","2019-01-07","","1","1");
INSERT INTO contas_receber VALUES("16216","381","1572","1","1","761.7","0","761.7","2018-11-06","2018-12-07","","1","1");
INSERT INTO contas_receber VALUES("16217","381","1572","3","1","761.7","0","761.7","2018-11-06","2019-01-07","","1","1");
INSERT INTO contas_receber VALUES("16218","381","1572","2","1","761.7","0","761.7","2018-11-06","2018-12-21","","1","1");
INSERT INTO contas_receber VALUES("16219","3","1582","1","1","198","0","198","2018-11-06","2018-11-07","","1","1");
INSERT INTO contas_receber VALUES("16238","263","1571","1","1","566.88","0","566.88","2018-11-07","2018-11-19","","1","1");
INSERT INTO contas_receber VALUES("16239","263","1571","2","1","566.88","0","566.88","2018-11-07","2018-11-19","","1","1");
INSERT INTO contas_receber VALUES("16240","220","1573","1","1","2574.33","0","2574.33","2018-11-08","2018-12-09","","1","1");
INSERT INTO contas_receber VALUES("16241","220","1573","3","1","2574.34","0","2574.34","2018-11-08","2019-01-09","","1","1");
INSERT INTO contas_receber VALUES("16242","220","1573","2","1","2574.33","0","2574.33","2018-11-08","2018-12-24","","1","1");
INSERT INTO contas_receber VALUES("16243","31","1583","1","1","537.25","0","537.25","2018-11-08","2018-12-08","","1","1");
INSERT INTO contas_receber VALUES("16244","31","1583","2","1","537.25","0","537.25","2018-11-08","2018-12-24","","1","1");
INSERT INTO contas_receber VALUES("16245","31","1583","3","1","537.25","0","537.25","2018-11-08","2019-01-08","","1","1");
INSERT INTO contas_receber VALUES("16246","44","1574","1","1","652.33","0","652.33","2018-11-08","2018-12-07","","1","1");
INSERT INTO contas_receber VALUES("16247","44","1574","2","1","652.33","0","652.33","2018-11-08","2018-12-22","","1","1");
INSERT INTO contas_receber VALUES("16248","44","1574","3","1","652.34","0","652.34","2018-11-08","2019-01-07","","1","1");
INSERT INTO contas_receber VALUES("16261","407","1581","1","1","435.5","0","435.5","2018-11-08","2018-12-08","","1","1");
INSERT INTO contas_receber VALUES("16262","162","1576","2","1","577.4","0","577.4","2018-11-08","2018-12-24","","1","1");
INSERT INTO contas_receber VALUES("16263","162","1576","3","1","577.4","0","577.4","2018-11-08","2019-01-09","","1","1");
INSERT INTO contas_receber VALUES("16264","162","1576","1","1","577.4","0","577.4","2018-11-08","2018-12-09","","1","1");
INSERT INTO contas_receber VALUES("16317","60","1578","1","1","548","0","548","2018-11-09","2018-12-09","","1","1");
INSERT INTO contas_receber VALUES("16318","60","1578","2","1","548","0","548","2018-11-09","2018-12-24","","1","1");
INSERT INTO contas_receber VALUES("16319","60","1578","3","1","548","0","548","2018-11-09","2019-01-09","","1","1");
INSERT INTO contas_receber VALUES("16324","380","1584","1","1","2571.33","0","2571.33","2018-11-12","2018-12-10","","1","1");
INSERT INTO contas_receber VALUES("16325","380","1584","2","1","2571.33","0","2571.33","2018-11-12","2018-12-26","","1","1");
INSERT INTO contas_receber VALUES("16326","380","1584","3","1","2571.34","0","2571.34","2018-11-12","2019-01-10","","1","1");
INSERT INTO contas_receber VALUES("16327","382","1589","1","1","990.5","0","990.5","2018-11-12","2018-12-13","","1","1");
INSERT INTO contas_receber VALUES("16328","382","1589","2","1","990.5","0","990.5","2018-11-12","2018-12-28","","1","1");
INSERT INTO contas_receber VALUES("16329","382","1589","3","1","990.5","0","990.5","2018-11-12","2019-01-13","","1","1");
INSERT INTO contas_receber VALUES("16333","31","1593","1","1","302.86","0","302.86","2018-11-12","2018-12-12","","1","1");
INSERT INTO contas_receber VALUES("16335","400","1595","1","1","190.2","190.2","0","2018-11-12","2018-11-13","","0","0");
INSERT INTO contas_receber VALUES("16336","400","1540","1","1","1061","0","1061","2018-11-12","2018-11-19","","1","1");
INSERT INTO contas_receber VALUES("16348","405","1598","1","1","98","98","0","2018-11-12","2018-11-13","","0","0");
INSERT INTO contas_receber VALUES("16357","278","1579","1","1","593.33","0","593.33","2018-11-13","2018-12-09","","1","1");
INSERT INTO contas_receber VALUES("16358","278","1579","2","1","593.33","0","593.33","2018-11-13","2018-12-24","","1","1");
INSERT INTO contas_receber VALUES("16359","278","1579","3","1","593.34","0","593.34","2018-11-13","2019-01-09","","1","1");
INSERT INTO contas_receber VALUES("16360","247","1590","1","1","789.3","0","789.3","2018-11-13","2018-11-29","","1","1");
INSERT INTO contas_receber VALUES("16361","247","1590","2","1","789.3","0","789.3","2018-11-13","2018-11-29","","1","1");
INSERT INTO contas_receber VALUES("16368","31","1597","1","1","226.2","0","226.2","2018-11-13","2018-12-14","","1","1");
INSERT INTO contas_receber VALUES("16369","31","1597","2","1","226.2","0","226.2","2018-11-13","2019-01-14","","1","1");
INSERT INTO contas_receber VALUES("16382","354","1596","1","1","282.07","0","282.07","2018-11-14","2018-12-14","","1","1");
INSERT INTO contas_receber VALUES("16383","354","1596","3","1","282.06","0","282.06","2018-11-14","2019-01-14","","1","1");
INSERT INTO contas_receber VALUES("16384","354","1596","2","1","282.07","0","282.07","2018-11-14","2018-12-29","","1","1");
INSERT INTO contas_receber VALUES("16385","252","1600","1","1","581.17","0","581.17","2018-11-14","2018-12-16","","1","1");
INSERT INTO contas_receber VALUES("16386","252","1600","2","1","581.17","0","581.17","2018-11-14","2018-12-31","","1","1");
INSERT INTO contas_receber VALUES("16387","252","1600","3","1","581.16","0","581.16","2018-11-14","2019-01-16","","1","1");
INSERT INTO contas_receber VALUES("16403","129","1601","1","1","502.67","0","502.67","2018-11-16","2018-12-16","","1","1");
INSERT INTO contas_receber VALUES("16404","129","1601","2","1","502.67","0","502.67","2018-11-16","2018-12-31","","1","1");
INSERT INTO contas_receber VALUES("16405","129","1601","3","1","502.66","0","502.66","2018-11-16","2019-01-16","","1","1");
INSERT INTO contas_receber VALUES("16406","369","1602","1","1","398.37","0","398.37","2018-11-16","2018-12-16","","1","1");
INSERT INTO contas_receber VALUES("16407","369","1602","3","1","398.36","0","398.36","2018-11-16","2019-01-16","","1","1");
INSERT INTO contas_receber VALUES("16408","369","1602","2","1","398.37","0","398.37","2018-11-16","2018-12-31","","1","1");
INSERT INTO contas_receber VALUES("16409","329","1603","1","1","226.75","0","226.75","2018-11-16","2018-12-16","","1","1");
INSERT INTO contas_receber VALUES("16410","329","1603","2","1","226.75","0","226.75","2018-11-16","2019-01-16","","1","1");
INSERT INTO contas_receber VALUES("16414","411","1606","1","1","1308.78","1308.78","0","2018-11-16","2018-11-17","","0","0");
INSERT INTO contas_receber VALUES("16415","411","1606","2","1","1308.78","1308.78","0","2018-11-16","2018-12-18","","0","0");
INSERT INTO contas_receber VALUES("16416","411","1606","3","1","1308.79","1308.79","0","2018-11-16","2019-01-18","","0","0");
INSERT INTO contas_receber VALUES("16417","4","1605","1","1","1105.17","0","1105.17","2018-11-16","2018-12-19","","1","1");
INSERT INTO contas_receber VALUES("16418","4","1605","2","1","1105.17","0","1105.17","2018-11-16","2019-01-03","","1","1");
INSERT INTO contas_receber VALUES("16419","4","1605","3","1","1105.16","0","1105.16","2018-11-16","2019-01-19","","1","1");
INSERT INTO contas_receber VALUES("16423","3","1587","1","1","9.92","0","9.92","2018-11-16","2018-11-09","","1","1");
INSERT INTO contas_receber VALUES("16426","32","1585","1","1","255.93","0","255.93","2018-11-16","2018-11-09","","1","1");
INSERT INTO contas_receber VALUES("16428","407","1609","1","1","544.5","544.5","0","2018-11-16","2018-11-17","","0","0");
INSERT INTO contas_receber VALUES("16432","59","1610","1","1","416.8","416.8","0","2018-11-16","2018-11-17","","0","0");
INSERT INTO contas_receber VALUES("16433","59","1610","2","1","416.8","416.8","0","2018-11-16","2018-12-18","","0","0");
INSERT INTO contas_receber VALUES("16434","59","1610","3","1","416.8","416.8","0","2018-11-16","2019-01-18","","0","0");
INSERT INTO contas_receber VALUES("16465","84","1611","1","1","735.52","0","735.52","2018-11-20","2018-12-20","","1","1");
INSERT INTO contas_receber VALUES("16466","84","1611","2","1","735.52","0","735.52","2018-11-20","2019-01-04","","1","1");
INSERT INTO contas_receber VALUES("16467","84","1611","3","1","735.52","0","735.52","2018-11-20","2019-01-20","","1","1");
INSERT INTO contas_receber VALUES("16468","405","1577","1","1","124.41","0","124.41","2018-11-20","2018-11-07","","1","1");
INSERT INTO contas_receber VALUES("16469","96","1568","1","1","207.05","0","207.05","2018-11-20","2018-11-01","","1","1");
INSERT INTO contas_receber VALUES("16472","244","1495","1","1","32.49","0","32.49","2018-11-20","2018-09-30","","1","1");
INSERT INTO contas_receber VALUES("16473","244","1615","1","1","362","362","0","2018-11-20","2018-11-22","","0","1");
INSERT INTO contas_receber VALUES("16476","212","1588","1","1","406","0","406","2018-11-20","2018-12-13","","1","1");
INSERT INTO contas_receber VALUES("16477","212","1588","2","1","406","0","406","2018-11-20","2018-12-28","","1","1");
INSERT INTO contas_receber VALUES("16478","212","1588","3","1","406","0","406","2018-11-20","2019-01-13","","1","1");
INSERT INTO contas_receber VALUES("16479","161","1591","1","1","834.93","0","834.93","2018-11-20","2018-12-14","","1","1");
INSERT INTO contas_receber VALUES("16480","161","1591","2","1","834.93","0","834.93","2018-11-20","2018-12-29","","1","1");
INSERT INTO contas_receber VALUES("16481","161","1591","3","1","834.94","0","834.94","2018-11-20","2019-01-14","","1","1");
INSERT INTO contas_receber VALUES("16482","401","1599","1","1","98","0","98","2018-11-20","2018-11-14","","1","1");
INSERT INTO contas_receber VALUES("16483","3","1607","1","1","236.92","0","236.92","2018-11-20","2018-11-18","","1","1");
INSERT INTO contas_receber VALUES("16484","32","1608","1","1","38.93","0","38.93","2018-11-20","2018-11-18","","1","1");
INSERT INTO contas_receber VALUES("16485","410","1604","1","1","147","0","147","2018-11-20","2018-11-16","","1","1");
INSERT INTO contas_receber VALUES("16486","25","1612","1","1","1381.32","0","1381.32","2018-11-21","2018-12-22","","1","1");
INSERT INTO contas_receber VALUES("16487","25","1612","2","1","1381.32","0","1381.32","2018-11-21","2019-01-06","","1","1");
INSERT INTO contas_receber VALUES("16488","25","1612","4","1","1381.32","0","1381.32","2018-11-21","2019-02-06","","1","1");
INSERT INTO contas_receber VALUES("16489","25","1612","3","1","1381.32","0","1381.32","2018-11-21","2019-01-22","","1","1");
INSERT INTO contas_receber VALUES("16490","25","1612","5","1","1381.31","0","1381.31","2018-11-21","2019-02-22","","1","1");
INSERT INTO contas_receber VALUES("16501","260","1613","1","1","246.05","0","246.05","2018-11-21","2018-11-23","","1","1");
INSERT INTO contas_receber VALUES("16519","406","1580","1","1","61.46","0","61.46","2018-11-22","2018-11-07","","1","1");
INSERT INTO contas_receber VALUES("16520","35","1594","1","1","120.08","0","120.08","2018-11-22","2018-12-21","","1","1");
INSERT INTO contas_receber VALUES("16521","35","1594","2","1","120.07","0","120.07","2018-11-22","2019-01-21","","1","1");
INSERT INTO contas_receber VALUES("16528","303","1614","1","1","743.9","0","743.9","2018-11-22","2018-12-22","","1","1");
INSERT INTO contas_receber VALUES("16529","303","1614","2","1","743.9","0","743.9","2018-11-22","2019-01-22","","1","1");
INSERT INTO contas_receber VALUES("16530","303","1614","3","1","743.9","0","743.9","2018-11-22","2019-02-22","","1","1");
INSERT INTO contas_receber VALUES("16533","19","1618","1","1","336.72","0","336.72","2018-11-22","2018-12-22","","1","1");
INSERT INTO contas_receber VALUES("16534","19","1618","2","1","336.73","0","336.73","2018-11-22","2019-01-22","","1","1");
INSERT INTO contas_receber VALUES("16535","244","1616","1","1","362","0","362","2018-11-22","2018-12-23","","1","1");
INSERT INTO contas_receber VALUES("16536","243","1617","1","1","408.9","0","408.9","2018-11-22","2018-12-22","","1","1");
INSERT INTO contas_receber VALUES("16537","243","1617","3","1","408.9","0","408.9","2018-11-22","2019-01-22","","1","1");
INSERT INTO contas_receber VALUES("16538","243","1617","2","1","408.9","0","408.9","2018-11-22","2019-01-06","","1","1");
INSERT INTO contas_receber VALUES("16547","409","1592","1","1","38.1","0","38.1","2018-11-23","2018-11-11","","1","1");
INSERT INTO contas_receber VALUES("16554","24","1619","1","1","843.75","0","843.75","2018-11-23","2018-12-10","","1","1");
INSERT INTO contas_receber VALUES("16555","24","1619","2","1","843.75","0","843.75","2018-11-23","2018-12-10","","1","1");
INSERT INTO contas_receber VALUES("16560","31","1621","1","1","417.78","0","417.78","2018-11-23","2018-12-26","","1","1");
INSERT INTO contas_receber VALUES("16561","31","1621","2","1","417.78","0","417.78","2018-11-23","2019-01-12","","1","1");
INSERT INTO contas_receber VALUES("16562","31","1621","4","1","138","0","138","2018-11-23","2019-01-19","","1","1");
INSERT INTO contas_receber VALUES("16563","31","1621","3","1","417.79","0","417.79","2018-11-23","2019-01-26","","1","1");
INSERT INTO contas_receber VALUES("16604","237","824","1","1","82.74","0","82.74","2018-11-26","2017-12-16","","1","1");
INSERT INTO contas_receber VALUES("16611","28","1620","1","1","287.46","0","287.46","2018-11-26","2018-12-26","","1","1");
INSERT INTO contas_receber VALUES("16612","28","1620","2","1","287.46","0","287.46","2018-11-26","2019-01-26","","1","1");
INSERT INTO contas_receber VALUES("16626","320","1629","1","1","1070","1070","0","2018-11-26","2018-11-27","","0","0");
INSERT INTO contas_receber VALUES("16627","320","1629","2","1","1070","1070","0","2018-11-26","2018-12-28","","0","0");
INSERT INTO contas_receber VALUES("16628","320","1629","3","1","1070","1070","0","2018-11-26","2019-01-28","","0","0");
INSERT INTO contas_receber VALUES("16629","320","1629","5","1","1070","1070","0","2018-11-26","2019-03-31","","0","0");
INSERT INTO contas_receber VALUES("16630","320","1629","4","1","1070","1070","0","2018-11-26","2019-02-28","","0","0");
INSERT INTO contas_receber VALUES("16641","47","1624","1","1","404.13","0","404.13","2018-11-27","2018-12-27","","1","1");
INSERT INTO contas_receber VALUES("16642","47","1624","3","1","404.14","0","404.14","2018-11-27","2019-01-27","","1","1");
INSERT INTO contas_receber VALUES("16643","47","1624","2","1","404.13","0","404.13","2018-11-27","2019-01-11","","1","1");
INSERT INTO contas_receber VALUES("16644","203","1623","1","1","1128","0","1128","2018-11-27","2018-12-12","","1","1");
INSERT INTO contas_receber VALUES("16645","203","1623","2","1","1128","0","1128","2018-11-27","2018-12-12","","1","1");
INSERT INTO contas_receber VALUES("16646","180","1622","1","1","587.23","0","587.23","2018-11-27","2018-12-26","","1","1");
INSERT INTO contas_receber VALUES("16647","180","1622","2","1","587.23","0","587.23","2018-11-27","2019-01-26","","1","1");
INSERT INTO contas_receber VALUES("16648","180","1622","3","1","587.24","0","587.24","2018-11-27","2019-02-26","","1","1");
INSERT INTO contas_receber VALUES("16649","393","1626","1","1","29.06","0","29.06","2018-11-27","2018-11-28","","1","1");
INSERT INTO contas_receber VALUES("16650","3","1627","1","1","51","0","51","2018-11-27","2018-11-29","","1","1");
INSERT INTO contas_receber VALUES("16651","32","1628","1","1","50","0","50","2018-11-27","2018-11-28","","1","1");
INSERT INTO contas_receber VALUES("16656","360","1631","1","1","557.5","557.5","0","2018-11-28","2018-11-29","","0","0");
INSERT INTO contas_receber VALUES("16657","360","1631","2","1","557.5","557.5","0","2018-11-28","2018-12-30","","0","0");
INSERT INTO contas_receber VALUES("16658","360","1631","3","1","557.5","557.5","0","2018-11-28","2019-01-30","","0","0");
INSERT INTO contas_receber VALUES("16659","360","1631","4","1","557.5","557.5","0","2018-11-28","2019-03-02","","0","0");
INSERT INTO contas_receber VALUES("16660","221","1625","1","1","500","0","500","2018-11-28","2018-12-28","","1","1");
INSERT INTO contas_receber VALUES("16661","221","1625","3","1","500","0","500","2018-11-28","2019-01-28","","1","1");
INSERT INTO contas_receber VALUES("16662","221","1625","2","1","500","0","500","2018-11-28","2019-01-12","","1","1");
INSERT INTO contas_receber VALUES("16663","23","1630","1","1","1070","0","1070","2018-11-28","2018-12-29","","1","1");
INSERT INTO contas_receber VALUES("16664","23","1630","2","1","1070","0","1070","2018-11-28","2019-01-14","","1","1");
INSERT INTO contas_receber VALUES("16665","23","1630","3","1","1070","0","1070","2018-11-28","2019-01-29","","1","1");
INSERT INTO contas_receber VALUES("16666","23","1630","4","1","1070","0","1070","2018-11-28","2019-02-15","","1","1");
INSERT INTO contas_receber VALUES("16667","23","1630","5","1","1070","0","1070","2018-11-28","2019-03-01","","1","1");
INSERT INTO contas_receber VALUES("16692","31","1635","1","1","267.07","267.07","0","2018-11-29","2018-12-01","","0","1");
INSERT INTO contas_receber VALUES("16693","31","1635","2","1","267.08","267.08","0","2018-11-29","2019-01-01","","0","1");
INSERT INTO contas_receber VALUES("16694","31","1633","1","1","339.5","0","339.5","2018-11-29","2018-12-28","","1","1");
INSERT INTO contas_receber VALUES("16695","31","1633","2","1","339.5","0","339.5","2018-11-29","2019-01-12","","1","1");
INSERT INTO contas_receber VALUES("16696","31","1633","3","1","339.5","0","339.5","2018-11-29","2019-02-28","","1","1");
INSERT INTO contas_receber VALUES("16697","413","1632","1","1","594.5","0","594.5","2018-11-29","2018-12-28","","1","1");
INSERT INTO contas_receber VALUES("16698","413","1632","4","1","594.5","0","594.5","2018-11-29","2019-02-13","","1","1");
INSERT INTO contas_receber VALUES("16699","413","1632","2","1","594.5","0","594.5","2018-11-29","2019-01-14","","1","1");
INSERT INTO contas_receber VALUES("16700","413","1632","3","1","594.5","0","594.5","2018-11-29","2019-01-28","","1","1");
INSERT INTO contas_receber VALUES("16703","3","1636","1","1","43.08","0","43.08","2018-11-30","2018-12-02","","1","1");
INSERT INTO contas_receber VALUES("16704","31","1637","1","1","267.07","0","267.07","2018-11-30","2018-12-30","","1","1");
INSERT INTO contas_receber VALUES("16705","31","1637","2","1","267.08","0","267.08","2018-11-30","2019-01-30","","1","1");
INSERT INTO contas_receber VALUES("16710","98","1638","1","1","977.5","977.5","0","2018-11-30","2018-12-01","","0","0");
INSERT INTO contas_receber VALUES("16711","98","1638","2","1","977.5","977.5","0","2018-11-30","2019-01-01","","0","0");
INSERT INTO contas_receber VALUES("16712","98","1638","3","1","977.5","977.5","0","2018-11-30","2019-02-01","","0","0");
INSERT INTO contas_receber VALUES("16713","98","1638","4","1","977.5","977.5","0","2018-11-30","2019-03-04","","0","0");
INSERT INTO contas_receber VALUES("16715","238","1634","1","1","406.95","0","406.95","2018-11-30","2018-12-02","","1","1");
INSERT INTO contas_receber VALUES("16758","3","1641","1","1","20.34","0","20.34","2018-12-03","2018-12-04","","1","1");
INSERT INTO contas_receber VALUES("16762","326","1642","1","1","428.23","428.23","0","2018-12-04","2018-12-05","","0","0");
INSERT INTO contas_receber VALUES("16763","326","1642","2","1","428.23","428.23","0","2018-12-04","2019-01-05","","0","0");
INSERT INTO contas_receber VALUES("16764","326","1642","3","1","428.24","428.24","0","2018-12-04","2019-02-05","","0","0");
INSERT INTO contas_receber VALUES("16773","4","1639","1","1","1285.5","0","1285.5","2018-12-04","2019-01-04","","1","1");
INSERT INTO contas_receber VALUES("16774","4","1639","2","1","1285.5","0","1285.5","2018-12-04","2019-01-19","","1","1");
INSERT INTO contas_receber VALUES("16775","4","1639","3","1","1285.5","0","1285.5","2018-12-04","2019-02-04","","1","1");
INSERT INTO contas_receber VALUES("16776","98","1640","1","1","607.25","0","607.25","2018-12-04","2019-01-04","","1","1");
INSERT INTO contas_receber VALUES("16777","98","1640","2","1","607.25","0","607.25","2018-12-04","2019-01-19","","1","1");
INSERT INTO contas_receber VALUES("16778","98","1640","3","1","607.25","0","607.25","2018-12-04","2019-02-04","","1","1");
INSERT INTO contas_receber VALUES("16793","113","1645","1","1","294","0","294","2018-12-05","2019-01-05","","1","1");
INSERT INTO contas_receber VALUES("16794","113","1645","2","1","294","0","294","2018-12-05","2019-01-20","","1","1");
INSERT INTO contas_receber VALUES("16795","113","1645","3","1","294","0","294","2018-12-05","2019-02-05","","1","1");
INSERT INTO contas_receber VALUES("16810","303","1648","1","1","711.37","0","711.37","2018-12-06","2019-01-06","","1","1");
INSERT INTO contas_receber VALUES("16811","303","1648","2","1","711.37","0","711.37","2018-12-06","2019-01-21","","1","1");
INSERT INTO contas_receber VALUES("16812","303","1648","3","1","711.36","0","711.36","2018-12-06","2019-02-06","","1","1");
INSERT INTO contas_receber VALUES("16813","329","1649","1","1","268.33","0","268.33","2018-12-06","2019-01-06","","1","1");
INSERT INTO contas_receber VALUES("16814","329","1649","2","1","268.33","0","268.33","2018-12-06","2019-01-21","","1","1");
INSERT INTO contas_receber VALUES("16815","329","1649","3","1","268.34","0","268.34","2018-12-06","2019-02-06","","1","1");
INSERT INTO contas_receber VALUES("16816","179","1647","1","1","275.02","0","275.02","2018-12-06","2019-01-05","","1","1");
INSERT INTO contas_receber VALUES("16817","179","1647","2","1","275.02","0","275.02","2018-12-06","2019-01-20","","1","1");
INSERT INTO contas_receber VALUES("16818","179","1647","3","1","275.01","0","275.01","2018-12-06","2019-02-05","","1","1");
INSERT INTO contas_receber VALUES("16819","414","1643","1","1","167.6","0","167.6","2018-12-06","2019-01-03","","1","1");
INSERT INTO contas_receber VALUES("16820","414","1643","2","1","167.6","0","167.6","2018-12-06","2019-01-20","","1","1");
INSERT INTO contas_receber VALUES("16821","31","1644","1","1","430.35","0","430.35","2018-12-06","2019-01-05","","1","1");
INSERT INTO contas_receber VALUES("16822","31","1644","2","1","430.35","0","430.35","2018-12-06","2019-01-20","","1","1");
INSERT INTO contas_receber VALUES("16823","31","1644","3","1","430.36","0","430.36","2018-12-06","2019-02-05","","1","1");
INSERT INTO contas_receber VALUES("16824","3","1646","1","1","34","0","34","2018-12-06","2018-12-06","","1","1");
INSERT INTO contas_receber VALUES("16833","59","1651","1","1","297.17","0","297.17","2018-12-07","2019-02-15","","1","1");
INSERT INTO contas_receber VALUES("16834","59","1651","2","1","297.17","0","297.17","2018-12-07","2019-03-02","","1","1");
INSERT INTO contas_receber VALUES("16835","59","1651","3","1","297.16","0","297.16","2018-12-07","2019-03-15","","1","1");
INSERT INTO contas_receber VALUES("16854","415","1652","1","1","580.13","0","580.13","2018-12-10","2019-01-10","","1","1");
INSERT INTO contas_receber VALUES("16855","415","1652","2","1","580.13","0","580.13","2018-12-10","2019-01-25","","1","1");
INSERT INTO contas_receber VALUES("16856","415","1652","3","1","580.14","0","580.14","2018-12-10","2019-02-10","","1","1");
INSERT INTO contas_receber VALUES("16857","329","1650","1","1","158","0","158","2018-12-10","2019-01-15","","1","1");
INSERT INTO contas_receber VALUES("16884","345","1653","1","1","495.52","0","495.52","2018-12-12","2019-01-12","","1","1");
INSERT INTO contas_receber VALUES("16885","345","1653","3","1","495.51","0","495.51","2018-12-12","2019-02-12","","1","1");
INSERT INTO contas_receber VALUES("16886","345","1653","2","1","495.52","0","495.52","2018-12-12","2019-01-27","","1","1");
INSERT INTO contas_receber VALUES("16887","416","1654","1","1","731.33","0","731.33","2018-12-12","2019-01-12","","1","1");
INSERT INTO contas_receber VALUES("16888","416","1654","3","1","731.34","0","731.34","2018-12-12","2019-02-12","","1","1");
INSERT INTO contas_receber VALUES("16889","416","1654","2","1","731.33","0","731.33","2018-12-12","2019-01-27","","1","1");
INSERT INTO contas_receber VALUES("16892","418","1657","1","1","322","0","322","2018-12-13","2019-01-13","","1","1");
INSERT INTO contas_receber VALUES("16893","323","1656","2","1","421.47","0","421.47","2018-12-13","2019-01-21","","1","1");
INSERT INTO contas_receber VALUES("16894","323","1656","1","1","421.48","0","421.48","2018-12-13","2019-01-14","","1","1");
INSERT INTO contas_receber VALUES("16900","46","1658","1","1","154.7","0","154.7","2018-12-13","2019-01-13","","1","1");
INSERT INTO contas_receber VALUES("16907","3","1660","1","1","79.1","0","79.1","2018-12-13","2018-12-14","","1","1");
INSERT INTO contas_receber VALUES("16908","31","1659","1","1","804.4","0","804.4","2018-12-14","2019-01-14","","1","1");
INSERT INTO contas_receber VALUES("16909","31","1659","2","1","804.4","0","804.4","2018-12-14","2019-02-14","","1","1");
INSERT INTO contas_receber VALUES("16910","31","1659","3","1","804.4","0","804.4","2018-12-14","2019-03-14","","1","1");
INSERT INTO contas_receber VALUES("16923","3","1662","1","1","36.12","0","36.12","2018-12-17","2018-12-18","","1","1");
INSERT INTO contas_receber VALUES("16930","25","1661","1","1","373","0","373","2018-12-18","2019-01-18","","1","1");
INSERT INTO contas_receber VALUES("16931","25","1661","3","1","373","0","373","2018-12-18","2019-02-18","","1","1");
INSERT INTO contas_receber VALUES("16932","25","1661","2","1","373","0","373","2018-12-18","2019-02-02","","1","1");
INSERT INTO contas_receber VALUES("16939","4","1663","1","1","1306.17","0","1306.17","2018-12-19","2019-01-19","","1","1");
INSERT INTO contas_receber VALUES("16940","4","1663","2","1","1306.17","0","1306.17","2018-12-19","2019-02-03","","1","1");
INSERT INTO contas_receber VALUES("16941","4","1663","3","1","1306.16","0","1306.16","2018-12-19","2019-02-19","","1","1");
INSERT INTO contas_receber VALUES("16962","83","1667","1","1","737","737","0","2018-12-24","2018-12-26","","0","1");
INSERT INTO contas_receber VALUES("16963","83","1667","2","1","737","737","0","2018-12-24","2019-01-26","","0","1");
INSERT INTO contas_receber VALUES("16964","83","1667","4","1","737","737","0","2018-12-24","2019-03-29","","0","1");
INSERT INTO contas_receber VALUES("16965","83","1667","3","1","737","737","0","2018-12-24","2019-02-26","","0","1");
INSERT INTO contas_receber VALUES("17048","212","1664","1","1","707.63","0","707.63","2019-01-08","2019-02-08","","1","1");
INSERT INTO contas_receber VALUES("17049","212","1664","2","1","707.63","0","707.63","2019-01-08","2019-02-23","","1","1");
INSERT INTO contas_receber VALUES("17050","212","1664","3","1","707.64","0","707.64","2019-01-08","2019-03-08","","1","1");
INSERT INTO contas_receber VALUES("17051","263","1665","1","1","949.22","0","949.22","2019-01-08","2019-01-23","","1","1");
INSERT INTO contas_receber VALUES("17052","263","1665","2","1","949.22","0","949.22","2019-01-08","2019-01-23","","1","1");
INSERT INTO contas_receber VALUES("17053","33","1666","1","1","627.88","0","627.88","2019-01-08","2019-01-23","","1","1");
INSERT INTO contas_receber VALUES("17054","33","1666","2","1","1255.56","0","1255.56","2019-01-08","2019-01-23","","1","1");
INSERT INTO contas_receber VALUES("17099","422","1689","1","1","337.4","337.4","0","2019-01-09","2019-01-10","","0","0");
INSERT INTO contas_receber VALUES("17100","422","1689","2","1","337.4","337.4","0","2019-01-09","2019-02-10","","0","0");
INSERT INTO contas_receber VALUES("17101","79","1668","1","1","665.38","0","665.38","2019-01-09","2019-02-09","","1","1");
INSERT INTO contas_receber VALUES("17102","79","1668","2","1","665.38","0","665.38","2019-01-09","2019-02-24","","1","1");
INSERT INTO contas_receber VALUES("17103","79","1668","3","1","665.38","0","665.38","2019-01-09","2019-03-11","","1","1");
INSERT INTO contas_receber VALUES("17104","79","1668","4","1","665.36","0","665.36","2019-01-09","2019-03-26","","1","1");
INSERT INTO contas_receber VALUES("17105","19","1669","1","1","247.5","0","247.5","2019-01-09","2019-02-10","","1","1");
INSERT INTO contas_receber VALUES("17106","19","1669","2","1","247.5","0","247.5","2019-01-09","2019-02-25","","1","1");
INSERT INTO contas_receber VALUES("17107","19","1669","3","1","247.5","0","247.5","2019-01-09","2019-03-10","","1","1");
INSERT INTO contas_receber VALUES("17108","421","1677","1","1","179","0","179","2019-01-09","2019-01-09","","1","1");
INSERT INTO contas_receber VALUES("17120","424","1692","1","1","61","61","0","2019-01-10","2019-01-11","","0","0");
INSERT INTO contas_receber VALUES("17130","4","1672","1","1","1289.67","0","1289.67","2019-01-11","2019-02-11","","1","1");
INSERT INTO contas_receber VALUES("17131","4","1672","2","1","1289.67","0","1289.67","2019-01-11","2019-02-26","","1","1");
INSERT INTO contas_receber VALUES("17132","4","1672","3","1","1289.66","0","1289.66","2019-01-11","2019-03-11","","1","1");
INSERT INTO contas_receber VALUES("17133","84","1674","1","1","865.61","0","865.61","2019-01-11","2019-02-14","","1","1");
INSERT INTO contas_receber VALUES("17134","84","1674","2","1","865.61","0","865.61","2019-01-11","2019-03-01","","1","1");
INSERT INTO contas_receber VALUES("17135","84","1674","3","1","865.62","0","865.62","2019-01-11","2019-03-14","","1","1");
INSERT INTO contas_receber VALUES("17136","44","1678","1","1","470.6","0","470.6","2019-01-11","2019-02-14","","1","1");
INSERT INTO contas_receber VALUES("17137","44","1678","2","1","470.6","0","470.6","2019-01-11","2019-03-01","","1","1");
INSERT INTO contas_receber VALUES("17138","44","1678","3","1","470.6","0","470.6","2019-01-11","2019-03-14","","1","1");
INSERT INTO contas_receber VALUES("17139","296","1679","1","1","315","315","0","2019-01-11","2019-02-14","","0","1");
INSERT INTO contas_receber VALUES("17140","296","1679","2","1","315","315","0","2019-01-11","2019-03-14","","0","1");
INSERT INTO contas_receber VALUES("17146","360","1695","1","1","867.53","867.53","0","2019-01-11","2019-01-13","","0","0");
INSERT INTO contas_receber VALUES("17147","360","1695","2","1","867.53","867.53","0","2019-01-11","2019-02-13","","0","0");
INSERT INTO contas_receber VALUES("17148","360","1695","3","1","867.54","867.54","0","2019-01-11","2019-03-16","","0","0");
INSERT INTO contas_receber VALUES("17175","296","1698","1","1","315","315","0","2019-01-11","2019-02-14","","0","1");
INSERT INTO contas_receber VALUES("17176","296","1698","2","1","315","315","0","2019-01-11","2019-03-14","","0","1");
INSERT INTO contas_receber VALUES("17177","296","1698","3","1","78.2","78.2","0","2019-01-11","2019-03-01","","0","1");
INSERT INTO contas_receber VALUES("17184","296","1699","1","1","315","0","315","2019-01-11","2019-02-14","","1","1");
INSERT INTO contas_receber VALUES("17185","296","1699","2","1","315","0","315","2019-01-11","2019-03-14","","1","1");
INSERT INTO contas_receber VALUES("17186","296","1699","3","1","78.2","0","78.2","2019-01-11","2019-03-01","","1","1");
INSERT INTO contas_receber VALUES("17210","426","1702","1","1","315.18","315.18","0","2019-01-11","2019-01-12","","0","0");
INSERT INTO contas_receber VALUES("17233","419","1675","1","1","820.03","0","820.03","2019-01-14","2019-02-15","","1","1");
INSERT INTO contas_receber VALUES("17234","419","1675","3","1","820.04","0","820.04","2019-01-14","2019-03-15","","1","1");
INSERT INTO contas_receber VALUES("17235","419","1675","2","1","820.03","0","820.03","2019-01-14","2019-03-02","","1","1");
INSERT INTO contas_receber VALUES("17240","98","1680","1","1","533.33","0","533.33","2019-01-14","2019-02-15","","1","1");
INSERT INTO contas_receber VALUES("17241","98","1680","2","1","533.33","0","533.33","2019-01-14","2019-03-15","","1","1");
INSERT INTO contas_receber VALUES("17242","98","1680","3","1","533.33","0","533.33","2019-01-14","2019-04-15","","1","1");
INSERT INTO contas_receber VALUES("17243","98","1680","4","1","494.81","0","494.81","2019-01-14","2019-03-30","","1","1");
INSERT INTO contas_receber VALUES("17250","420","1676","1","1","50.16","0","50.16","2019-01-14","2019-01-09","","1","1");
INSERT INTO contas_receber VALUES("17251","103","1670","1","1","302.91","0","302.91","2019-01-14","2019-02-10","","1","1");
INSERT INTO contas_receber VALUES("17252","103","1670","2","1","302.91","0","302.91","2019-01-14","2019-02-25","","1","1");
INSERT INTO contas_receber VALUES("17253","103","1670","3","1","302.91","0","302.91","2019-01-14","2019-03-12","","1","1");
INSERT INTO contas_receber VALUES("17254","103","1670","4","1","302.93","0","302.93","2019-01-14","2019-03-27","","1","1");
INSERT INTO contas_receber VALUES("17255","70","1671","1","1","603.25","0","603.25","2019-01-14","2019-01-24","","1","1");
INSERT INTO contas_receber VALUES("17256","70","1671","2","1","603.25","0","603.25","2019-01-14","2019-01-24","","1","1");
INSERT INTO contas_receber VALUES("17299","31","1682","1","1","415.32","0","415.32","2019-01-14","2019-02-15","","1","1");
INSERT INTO contas_receber VALUES("17300","31","1682","2","1","415.32","0","415.32","2019-01-14","2019-03-02","","1","1");
INSERT INTO contas_receber VALUES("17301","31","1682","3","1","415.32","0","415.32","2019-01-14","2019-03-15","","1","1");
INSERT INTO contas_receber VALUES("17308","315","1688","2","1","413.68","413.68","0","2019-01-15","2019-03-02","","0","0");
INSERT INTO contas_receber VALUES("17309","315","1688","1","1","413.68","413.68","0","2019-01-15","2019-02-15","","0","0");
INSERT INTO contas_receber VALUES("17310","315","1688","3","1","413.69","413.69","0","2019-01-15","2019-03-15","","0","0");
INSERT INTO contas_receber VALUES("17311","67","1685","1","1","407.9","0","407.9","2019-01-15","2019-02-15","","1","1");
INSERT INTO contas_receber VALUES("17312","67","1685","2","1","407.9","0","407.9","2019-01-15","2019-03-02","","1","1");
INSERT INTO contas_receber VALUES("17313","67","1685","3","1","407.9","0","407.9","2019-01-15","2019-03-15","","1","1");
INSERT INTO contas_receber VALUES("17314","192","1681","1","1","1741.2","0","1741.2","2019-01-15","2019-01-09","","1","1");
INSERT INTO contas_receber VALUES("17315","60","1684","1","1","608.93","0","608.93","2019-01-15","2019-02-15","","1","1");
INSERT INTO contas_receber VALUES("17316","60","1684","2","1","608.93","0","608.93","2019-01-15","2019-03-02","","1","1");
INSERT INTO contas_receber VALUES("17317","60","1684","3","1","608.94","0","608.94","2019-01-15","2019-03-15","","1","1");
INSERT INTO contas_receber VALUES("17338","428","1713","1","1","315.18","0","315.18","2019-01-16","2019-01-21","","1","1");
INSERT INTO contas_receber VALUES("17370","220","1687","1","1","4054.47","0","4054.47","2019-01-17","2019-02-18","","1","1");
INSERT INTO contas_receber VALUES("17371","220","1687","2","1","4054.47","0","4054.47","2019-01-17","2019-03-05","","1","1");
INSERT INTO contas_receber VALUES("17372","220","1687","3","1","4054.46","0","4054.46","2019-01-17","2019-03-18","","1","1");
INSERT INTO contas_receber VALUES("17373","380","1690","1","1","628.67","0","628.67","2019-01-17","2019-02-18","","1","1");
INSERT INTO contas_receber VALUES("17374","380","1690","2","1","628.67","0","628.67","2019-01-17","2019-03-05","","1","1");
INSERT INTO contas_receber VALUES("17375","380","1690","3","1","628.66","0","628.66","2019-01-17","2019-03-18","","1","1");
INSERT INTO contas_receber VALUES("17376","329","1683","1","1","247.25","0","247.25","2019-01-17","2019-02-16","","1","1");
INSERT INTO contas_receber VALUES("17377","329","1683","2","1","247.25","0","247.25","2019-01-17","2019-03-16","","1","1");
INSERT INTO contas_receber VALUES("17378","423","1691","1","1","231.97","0","231.97","2019-01-17","2019-01-12","","1","1");
INSERT INTO contas_receber VALUES("17387","3","1712","1","1","472.66","0","472.66","2019-01-17","2019-01-18","","1","1");
INSERT INTO contas_receber VALUES("17418","255","1694","1","1","1386.1","0","1386.1","2019-01-17","2019-02-05","","1","1");
INSERT INTO contas_receber VALUES("17419","261","1693","1","1","544.98","0","544.98","2019-01-17","2019-02-21","","1","1");
INSERT INTO contas_receber VALUES("17420","261","1693","3","1","544.97","0","544.97","2019-01-17","2019-03-21","","1","1");
INSERT INTO contas_receber VALUES("17421","261","1693","2","1","544.98","0","544.98","2019-01-17","2019-03-08","","1","1");
INSERT INTO contas_receber VALUES("17422","211","1697","1","1","402.13","0","402.13","2019-01-17","2019-02-21","","1","1");
INSERT INTO contas_receber VALUES("17423","211","1697","2","1","402.13","0","402.13","2019-01-17","2019-03-08","","1","1");
INSERT INTO contas_receber VALUES("17424","211","1697","3","1","402.14","0","402.14","2019-01-17","2019-03-21","","1","1");
INSERT INTO contas_receber VALUES("17449","42","1696","1","1","743.8","0","743.8","2019-01-18","2019-02-23","","1","1");
INSERT INTO contas_receber VALUES("17450","42","1696","2","1","743.8","0","743.8","2019-01-18","2019-03-11","","1","1");
INSERT INTO contas_receber VALUES("17451","42","1696","3","1","743.8","0","743.8","2019-01-18","2019-03-26","","1","1");
INSERT INTO contas_receber VALUES("17452","42","1696","4","1","743.8","0","743.8","2019-01-18","2019-04-11","","1","1");
INSERT INTO contas_receber VALUES("17453","310","1704","2","1","1313.33","0","1313.33","2019-01-18","2019-03-10","","1","1");
INSERT INTO contas_receber VALUES("17454","310","1704","1","1","1313.33","0","1313.33","2019-01-18","2019-02-23","","1","1");
INSERT INTO contas_receber VALUES("17455","310","1704","3","1","1313.34","0","1313.34","2019-01-18","2019-03-23","","1","1");
INSERT INTO contas_receber VALUES("17484","30","1701","1","1","646.23","0","646.23","2019-01-21","2019-02-22","","1","1");
INSERT INTO contas_receber VALUES("17485","30","1701","2","1","646.23","0","646.23","2019-01-21","2019-03-09","","1","1");
INSERT INTO contas_receber VALUES("17486","30","1701","3","1","646.23","0","646.23","2019-01-21","2019-03-24","","1","1");
INSERT INTO contas_receber VALUES("17487","30","1701","4","1","646.21","0","646.21","2019-01-21","2019-04-09","","1","1");
INSERT INTO contas_receber VALUES("17497","22","1705","1","1","1231.75","0","1231.75","2019-01-21","2019-02-22","","1","1");
INSERT INTO contas_receber VALUES("17498","22","1705","2","1","1231.75","0","1231.75","2019-01-21","2019-03-09","","1","1");
INSERT INTO contas_receber VALUES("17499","22","1705","3","1","1231.75","0","1231.75","2019-01-21","2019-03-22","","1","1");
INSERT INTO contas_receber VALUES("17500","303","1709","1","1","360.78","0","360.78","2019-01-21","2019-02-22","","1","1");
INSERT INTO contas_receber VALUES("17501","303","1709","2","1","360.78","0","360.78","2019-01-21","2019-03-09","","1","1");
INSERT INTO contas_receber VALUES("17502","303","1709","3","1","360.79","0","360.79","2019-01-21","2019-03-23","","1","1");
INSERT INTO contas_receber VALUES("17503","427","1710","1","1","53.46","0","53.46","2019-01-21","2019-01-17","","1","1");
INSERT INTO contas_receber VALUES("17508","17","1708","1","1","862.53","862.53","0","2019-01-22","2019-03-01","","0","1");
INSERT INTO contas_receber VALUES("17509","17","1708","2","1","862.53","862.53","0","2019-01-22","2019-03-11","","0","1");
INSERT INTO contas_receber VALUES("17510","17","1708","3","1","862.54","862.54","0","2019-01-22","2019-04-01","","0","1");
INSERT INTO contas_receber VALUES("17515","31","1727","1","1","714.53","0","714.53","2019-01-22","2019-02-23","","1","1");
INSERT INTO contas_receber VALUES("17516","31","1727","3","1","714.54","0","714.54","2019-01-22","2019-03-23","","1","1");
INSERT INTO contas_receber VALUES("17517","31","1727","2","1","714.53","0","714.53","2019-01-22","2019-03-10","","1","1");
INSERT INTO contas_receber VALUES("17525","430","1731","1","1","361.62","361.62","0","2019-01-23","2019-01-26","","0","0");
INSERT INTO contas_receber VALUES("17528","3","1734","1","1","87.85","0","87.85","2019-01-23","2019-01-24","","1","1");
INSERT INTO contas_receber VALUES("17530","32","1735","1","1","206.29","206.29","0","2019-01-23","2019-01-24","","0","1");
INSERT INTO contas_receber VALUES("17540","431","1737","1","1","272.3","272.3","0","2019-01-23","2019-01-25","","0","0");
INSERT INTO contas_receber VALUES("17541","71","1707","1","1","405.7","0","405.7","2019-01-24","2019-02-25","","1","1");
INSERT INTO contas_receber VALUES("17542","71","1707","2","1","405.7","0","405.7","2019-01-24","2019-03-12","","1","1");
INSERT INTO contas_receber VALUES("17543","71","1707","3","1","405.7","0","405.7","2019-01-24","2019-03-25","","1","1");
INSERT INTO contas_receber VALUES("17544","94","1718","1","1","271.44","0","271.44","2019-01-24","2019-02-23","","1","1");
INSERT INTO contas_receber VALUES("17545","94","1718","2","1","271.44","0","271.44","2019-01-24","2019-03-23","","1","1");
INSERT INTO contas_receber VALUES("17583","425","1700","1","1","797.49","797.49","0","2019-01-25","2019-01-17","","0","0");
INSERT INTO contas_receber VALUES("17584","425","1700","2","1","797.49","797.49","0","2019-01-25","2019-02-17","","0","0");
INSERT INTO contas_receber VALUES("17585","425","1700","3","1","797.48","797.48","0","2019-01-25","2019-03-20","","0","0");
INSERT INTO contas_receber VALUES("17592","252","1703","1","1","660.83","0","660.83","2019-01-25","2019-02-24","","1","1");
INSERT INTO contas_receber VALUES("17593","252","1703","2","1","660.83","0","660.83","2019-01-25","2019-03-11","","1","1");
INSERT INTO contas_receber VALUES("17594","252","1703","3","1","660.84","0","660.84","2019-01-25","2019-03-24","","1","1");
INSERT INTO contas_receber VALUES("17601","429","1714","1","1","353.44","0","353.44","2019-01-25","2019-03-01","","1","1");
INSERT INTO contas_receber VALUES("17602","429","1714","2","1","353.44","0","353.44","2019-01-25","2019-03-16","","1","1");
INSERT INTO contas_receber VALUES("17603","429","1714","3","1","353.45","0","353.45","2019-01-25","2019-04-01","","1","1");
INSERT INTO contas_receber VALUES("17605","32","1736","1","1","206.29","0","206.29","2019-01-25","2019-01-25","","1","1");
INSERT INTO contas_receber VALUES("17612","24","1706","1","1","789.2","0","789.2","2019-01-28","2019-02-11","","1","1");
INSERT INTO contas_receber VALUES("17613","24","1706","2","1","789.2","0","789.2","2019-01-28","2019-02-11","","1","1");
INSERT INTO contas_receber VALUES("17614","149","1686","1","1","401.28","0","401.28","2019-01-28","2019-02-25","","1","1");
INSERT INTO contas_receber VALUES("17615","149","1686","2","1","401.28","0","401.28","2019-01-28","2019-03-12","","1","1");
INSERT INTO contas_receber VALUES("17616","149","1686","3","1","401.29","0","401.29","2019-01-28","2019-03-25","","1","1");
INSERT INTO contas_receber VALUES("17617","6","1728","1","1","358.6","0","358.6","2019-01-28","2019-03-01","","1","1");
INSERT INTO contas_receber VALUES("17618","6","1728","2","1","358.6","0","358.6","2019-01-28","2019-03-11","","1","1");
INSERT INTO contas_receber VALUES("17619","6","1728","3","1","358.6","0","358.6","2019-01-28","2019-03-21","","1","1");
INSERT INTO contas_receber VALUES("17620","6","1728","4","1","358.6","0","358.6","2019-01-28","2019-04-01","","1","1");
INSERT INTO contas_receber VALUES("17621","6","1728","5","1","358.6","0","358.6","2019-01-28","2019-04-11","","1","1");
INSERT INTO contas_receber VALUES("17622","357","1711","1","1","405.28","0","405.28","2019-01-28","2019-03-02","","1","1");
INSERT INTO contas_receber VALUES("17623","357","1711","2","1","405.28","0","405.28","2019-01-28","2019-03-17","","1","1");
INSERT INTO contas_receber VALUES("17624","357","1711","3","1","405.29","0","405.29","2019-01-28","2019-04-02","","1","1");
INSERT INTO contas_receber VALUES("17625","4","1715","1","1","1263.17","0","1263.17","2019-01-28","2019-03-02","","1","1");
INSERT INTO contas_receber VALUES("17626","4","1715","3","1","1263.16","0","1263.16","2019-01-28","2019-04-02","","1","1");
INSERT INTO contas_receber VALUES("17627","4","1715","2","1","1263.17","0","1263.17","2019-01-28","2019-03-17","","1","1");
INSERT INTO contas_receber VALUES("17646","190","1732","1","1","320.4","0","320.4","2019-01-29","2019-01-27","","1","1");
INSERT INTO contas_receber VALUES("17647","430","1733","1","1","361.62","0","361.62","2019-01-29","2019-03-01","","1","1");
INSERT INTO contas_receber VALUES("17648","425","1745","1","1","797.49","0","797.49","2019-01-29","2019-02-21","","1","1");
INSERT INTO contas_receber VALUES("17649","425","1745","2","1","797.49","0","797.49","2019-01-29","2019-02-28","","1","1");
INSERT INTO contas_receber VALUES("17650","425","1745","3","1","797.48","0","797.48","2019-01-29","2019-03-07","","1","1");
INSERT INTO contas_receber VALUES("17661","333","1722","1","1","1212.5","0","1212.5","2019-01-30","2019-03-10","","1","1");
INSERT INTO contas_receber VALUES("17662","64","1721","1","1","411.43","0","411.43","2019-01-30","2019-03-02","","1","1");
INSERT INTO contas_receber VALUES("17663","64","1721","2","1","411.43","0","411.43","2019-01-30","2019-03-17","","1","1");
INSERT INTO contas_receber VALUES("17664","64","1721","3","1","411.44","0","411.44","2019-01-30","2019-04-02","","1","1");
INSERT INTO contas_receber VALUES("17686","426","1755","1","1","343.2","343.2","0","2019-01-30","2019-01-31","","0","0");
INSERT INTO contas_receber VALUES("17689","69","1729","1","1","864.05","0","864.05","2019-01-31","2019-02-15","","1","1");
INSERT INTO contas_receber VALUES("17690","69","1729","2","1","864.05","0","864.05","2019-01-31","2019-02-15","","1","1");
INSERT INTO contas_receber VALUES("17691","31","1740","1","1","437.07","0","437.07","2019-01-31","2019-03-02","","1","1");
INSERT INTO contas_receber VALUES("17692","31","1740","2","1","437.07","0","437.07","2019-01-31","2019-03-17","","1","1");
INSERT INTO contas_receber VALUES("17693","31","1740","3","1","437.06","0","437.06","2019-01-31","2019-04-02","","1","1");
INSERT INTO contas_receber VALUES("17694","47","1720","1","1","656.47","0","656.47","2019-01-31","2019-03-02","","1","1");
INSERT INTO contas_receber VALUES("17695","47","1720","2","1","656.47","0","656.47","2019-01-31","2019-03-17","","1","1");
INSERT INTO contas_receber VALUES("17696","47","1720","3","1","656.46","0","656.46","2019-01-31","2019-04-02","","1","1");
INSERT INTO contas_receber VALUES("17697","174","1748","1","1","493.6","493.6","0","2019-01-31","2019-02-01","","0","1");
INSERT INTO contas_receber VALUES("17698","432","1738","1","1","718.5","0","718.5","2019-01-31","2019-02-18","","1","1");
INSERT INTO contas_receber VALUES("17699","433","1739","1","1","824.57","0","824.57","2019-01-31","2019-02-18","","1","1");
INSERT INTO contas_receber VALUES("17700","169","1730","1","1","243.6","0","243.6","2019-01-31","2019-03-04","","1","1");
INSERT INTO contas_receber VALUES("17701","434","1741","1","1","565.46","0","565.46","2019-01-31","2019-02-15","","1","1");
INSERT INTO contas_receber VALUES("17708","435","1746","1","1","307.5","0","307.5","2019-01-31","2019-01-30","","1","1");
INSERT INTO contas_receber VALUES("17721","140","1743","1","1","421.7","0","421.7","2019-02-01","2019-03-04","","1","1");
INSERT INTO contas_receber VALUES("17722","381","1744","1","1","570.9","0","570.9","2019-02-01","2019-03-04","","1","1");
INSERT INTO contas_receber VALUES("17723","381","1744","2","1","570.9","0","570.9","2019-02-01","2019-03-19","","1","1");
INSERT INTO contas_receber VALUES("17724","381","1744","3","1","570.9","0","570.9","2019-02-01","2019-04-04","","1","1");
INSERT INTO contas_receber VALUES("17725","16","1742","1","1","1627.67","0","1627.67","2019-02-01","2019-03-06","","1","1");
INSERT INTO contas_receber VALUES("17726","16","1742","2","1","1627.67","0","1627.67","2019-02-01","2019-03-21","","1","1");
INSERT INTO contas_receber VALUES("17727","16","1742","3","1","1627.66","0","1627.66","2019-02-01","2019-04-06","","1","1");
INSERT INTO contas_receber VALUES("17728","380","1753","2","1","975.13","0","975.13","2019-02-01","2019-03-19","","1","1");
INSERT INTO contas_receber VALUES("17729","380","1753","1","1","975.13","0","975.13","2019-02-01","2019-03-04","","1","1");
INSERT INTO contas_receber VALUES("17730","380","1753","3","1","975.14","0","975.14","2019-02-01","2019-04-04","","1","1");
INSERT INTO contas_receber VALUES("17731","212","1747","1","1","425.9","0","425.9","2019-02-01","2019-03-05","","1","1");
INSERT INTO contas_receber VALUES("17732","212","1747","2","1","425.9","0","425.9","2019-02-01","2019-03-20","","1","1");
INSERT INTO contas_receber VALUES("17733","212","1747","3","1","425.9","0","425.9","2019-02-01","2019-04-05","","1","1");
INSERT INTO contas_receber VALUES("17734","21","1719","2","1","1544.92","0","1544.92","2019-02-01","2019-02-23","","1","1");
INSERT INTO contas_receber VALUES("17735","21","1719","1","1","1544.92","0","1544.92","2019-02-01","2019-02-12","","1","1");
INSERT INTO contas_receber VALUES("17736","21","1719","3","1","1544.92","0","1544.92","2019-02-01","2019-03-05","","1","1");
INSERT INTO contas_receber VALUES("17737","21","1719","4","1","1544.92","0","1544.92","2019-02-01","2019-03-15","","1","1");
INSERT INTO contas_receber VALUES("17738","21","1719","5","1","1544.92","0","1544.92","2019-02-01","2019-03-25","","1","1");
INSERT INTO contas_receber VALUES("17739","322","1726","1","1","428.77","0","428.77","2019-02-01","2019-03-02","","1","1");
INSERT INTO contas_receber VALUES("17740","322","1726","2","1","428.77","0","428.77","2019-02-01","2019-03-17","","1","1");
INSERT INTO contas_receber VALUES("17741","322","1726","3","1","428.76","0","428.76","2019-02-01","2019-04-02","","1","1");
INSERT INTO contas_receber VALUES("17742","3","1750","1","1","82.03","0","82.03","2019-02-01","2019-01-31","","1","1");
INSERT INTO contas_receber VALUES("17743","190","1751","1","1","214.86","0","214.86","2019-02-01","2019-01-31","","1","1");
INSERT INTO contas_receber VALUES("17744","54","1752","1","1","60.23","0","60.23","2019-02-01","2019-02-01","","1","1");
INSERT INTO contas_receber VALUES("17745","72","1756","1","1","343.2","0","343.2","2019-02-01","2019-03-04","","1","1");
INSERT INTO contas_receber VALUES("17811","422","1749","2","1","408.58","0","408.58","2019-02-05","2019-03-20","","1","1");
INSERT INTO contas_receber VALUES("17812","422","1749","1","1","408.58","0","408.58","2019-02-05","2019-03-05","","1","1");
INSERT INTO contas_receber VALUES("17813","422","1749","3","1","408.59","0","408.59","2019-02-05","2019-04-05","","1","1");
INSERT INTO contas_receber VALUES("17818","31","1757","1","1","284.69","0","284.69","2019-02-05","2019-03-05","","1","1");
INSERT INTO contas_receber VALUES("17819","31","1757","4","1","345.93","0","345.93","2019-02-05","2019-04-10","","1","1");
INSERT INTO contas_receber VALUES("17820","31","1757","3","1","284.69","0","284.69","2019-02-05","2019-04-05","","1","1");
INSERT INTO contas_receber VALUES("17821","31","1757","2","1","284.69","0","284.69","2019-02-05","2019-03-20","","1","1");
INSERT INTO contas_receber VALUES("17836","245","1763","1","1","126.47","0","126.47","2019-02-06","2019-03-07","","1","1");
INSERT INTO contas_receber VALUES("17837","245","1763","3","1","126.48","0","126.48","2019-02-06","2019-04-05","","1","1");
INSERT INTO contas_receber VALUES("17838","245","1763","2","1","126.47","0","126.47","2019-02-06","2019-03-22","","1","1");
INSERT INTO contas_receber VALUES("17848","382","1767","2","1","1445.17","1445.17","0","2019-02-06","2019-03-10","","0","0");
INSERT INTO contas_receber VALUES("17849","382","1767","1","1","1445.17","1445.17","0","2019-02-06","2019-02-07","","0","0");
INSERT INTO contas_receber VALUES("17850","382","1767","3","1","1445.16","1445.16","0","2019-02-06","2019-04-10","","0","0");
INSERT INTO contas_receber VALUES("17857","220","1754","1","1","2529.1","0","2529.1","2019-02-07","2019-03-08","","1","1");
INSERT INTO contas_receber VALUES("17858","220","1754","2","1","2529.1","0","2529.1","2019-02-07","2019-03-23","","1","1");
INSERT INTO contas_receber VALUES("17859","220","1754","4","1","2529.1","0","2529.1","2019-02-07","2019-04-22","","1","1");
INSERT INTO contas_receber VALUES("17860","220","1754","5","1","2529.1","0","2529.1","2019-02-07","2019-05-07","","1","1");
INSERT INTO contas_receber VALUES("17861","220","1754","3","1","2529.1","0","2529.1","2019-02-07","2019-04-07","","1","1");
INSERT INTO contas_receber VALUES("17862","3","1765","1","1","129.22","0","129.22","2019-02-07","2019-02-10","","1","1");
INSERT INTO contas_receber VALUES("17885","4","1758","1","1","1298","0","1298","2019-02-08","2019-03-09","","1","1");
INSERT INTO contas_receber VALUES("17886","4","1758","3","1","1298","0","1298","2019-02-08","2019-04-09","","1","1");
INSERT INTO contas_receber VALUES("17887","4","1758","2","1","1298","0","1298","2019-02-08","2019-03-24","","1","1");
INSERT INTO contas_receber VALUES("17888","161","1759","1","1","662.05","0","662.05","2019-02-08","2019-03-11","","1","1");
INSERT INTO contas_receber VALUES("17889","161","1759","2","1","662.05","0","662.05","2019-02-08","2019-03-26","","1","1");
INSERT INTO contas_receber VALUES("17890","161","1759","3","1","662.05","0","662.05","2019-02-08","2019-04-08","","1","1");
INSERT INTO contas_receber VALUES("17891","337","1760","1","1","402.13","0","402.13","2019-02-08","2019-03-11","","1","1");
INSERT INTO contas_receber VALUES("17892","337","1760","2","1","402.13","0","402.13","2019-02-08","2019-03-26","","1","1");
INSERT INTO contas_receber VALUES("17893","337","1760","3","1","402.14","0","402.14","2019-02-08","2019-04-08","","1","1");
INSERT INTO contas_receber VALUES("17903","8","1766","1","1","653.33","0","653.33","2019-02-11","2019-03-14","","1","1");
INSERT INTO contas_receber VALUES("17904","8","1766","2","1","653.33","0","653.33","2019-02-11","2019-03-29","","1","1");
INSERT INTO contas_receber VALUES("17905","8","1766","3","1","653.34","0","653.34","2019-02-11","2019-04-12","","1","1");
INSERT INTO contas_receber VALUES("17906","241","1762","1","1","244.93","0","244.93","2019-02-11","2019-03-14","","1","1");
INSERT INTO contas_receber VALUES("17907","241","1762","2","1","244.93","0","244.93","2019-02-11","2019-03-29","","1","1");
INSERT INTO contas_receber VALUES("17908","241","1762","3","1","244.94","0","244.94","2019-02-11","2019-04-12","","1","1");
INSERT INTO contas_receber VALUES("17909","291","1764","1","1","396.58","0","396.58","2019-02-11","2019-03-14","","1","1");
INSERT INTO contas_receber VALUES("17910","291","1764","2","1","396.58","0","396.58","2019-02-11","2019-03-29","","1","1");
INSERT INTO contas_receber VALUES("17911","291","1764","3","1","396.59","0","396.59","2019-02-11","2019-04-12","","1","1");
INSERT INTO contas_receber VALUES("17922","23","1768","1","1","623.3","0","623.3","2019-02-11","2019-03-14","","1","1");
INSERT INTO contas_receber VALUES("17923","23","1768","2","1","623.3","0","623.3","2019-02-11","2019-03-29","","1","1");
INSERT INTO contas_receber VALUES("17924","23","1768","3","1","623.3","0","623.3","2019-02-11","2019-04-12","","1","1");
INSERT INTO contas_receber VALUES("17925","220","1771","1","1","349","0","349","2019-02-11","2019-03-14","","1","1");
INSERT INTO contas_receber VALUES("17938","62","1761","1","1","725.69","0","725.69","2019-02-12","2019-03-15","","1","1");
INSERT INTO contas_receber VALUES("17939","62","1761","2","1","725.69","0","725.69","2019-02-12","2019-03-30","","1","1");
INSERT INTO contas_receber VALUES("17940","62","1761","3","1","725.69","0","725.69","2019-02-12","2019-04-13","","1","1");
INSERT INTO contas_receber VALUES("17951","436","1769","1","1","462.93","0","462.93","2019-02-12","2019-03-14","","1","1");
INSERT INTO contas_receber VALUES("17952","436","1769","2","1","462.93","0","462.93","2019-02-12","2019-03-29","","1","1");
INSERT INTO contas_receber VALUES("17953","436","1769","3","1","462.94","0","462.94","2019-02-12","2019-04-12","","1","1");
INSERT INTO contas_receber VALUES("17954","44","1770","1","1","609.69","0","609.69","2019-02-12","2019-03-15","","1","1");
INSERT INTO contas_receber VALUES("17955","44","1770","2","1","609.69","0","609.69","2019-02-12","2019-03-30","","1","1");
INSERT INTO contas_receber VALUES("17956","44","1770","3","1","609.7","0","609.7","2019-02-12","2019-04-12","","1","1");
INSERT INTO contas_receber VALUES("17967","380","1772","1","1","1061.67","0","1061.67","2019-02-13","2019-03-15","","1","1");
INSERT INTO contas_receber VALUES("17968","380","1772","2","1","1061.67","0","1061.67","2019-02-13","2019-03-30","","1","1");
INSERT INTO contas_receber VALUES("17969","380","1772","3","1","1061.66","0","1061.66","2019-02-13","2019-04-12","","1","1");
INSERT INTO contas_receber VALUES("17970","84","1774","1","1","725.6","0","725.6","2019-02-13","2019-03-16","","1","1");
INSERT INTO contas_receber VALUES("17971","84","1774","2","1","725.6","0","725.6","2019-02-13","2019-03-31","","1","1");
INSERT INTO contas_receber VALUES("17972","84","1774","3","1","725.61","0","725.61","2019-02-13","2019-04-13","","1","1");
INSERT INTO contas_receber VALUES("17994","187","1782","1","1","839.67","839.67","0","2019-02-13","2019-02-16","","0","0");
INSERT INTO contas_receber VALUES("17995","187","1782","2","1","839.67","839.67","0","2019-02-13","2019-03-19","","0","0");
INSERT INTO contas_receber VALUES("17996","187","1782","3","1","839.66","839.66","0","2019-02-13","2019-04-19","","0","0");
INSERT INTO contas_receber VALUES("18003","3","1784","1","1","0","0","0","2019-02-13","2019-02-14","","1","1");
INSERT INTO contas_receber VALUES("18016","31","1777","1","1","343.73","0","343.73","2019-02-13","2019-03-16","","1","1");
INSERT INTO contas_receber VALUES("18017","31","1777","2","1","343.73","0","343.73","2019-02-13","2019-03-31","","1","1");
INSERT INTO contas_receber VALUES("18018","31","1777","3","1","343.74","0","343.74","2019-02-13","2019-04-14","","1","1");
INSERT INTO contas_receber VALUES("18019","303","1776","1","1","978.07","0","978.07","2019-02-13","2019-03-16","","1","1");
INSERT INTO contas_receber VALUES("18020","303","1776","3","1","978.06","0","978.06","2019-02-13","2019-04-14","","1","1");
INSERT INTO contas_receber VALUES("18021","303","1776","2","1","978.07","0","978.07","2019-02-13","2019-03-31","","1","1");
INSERT INTO contas_receber VALUES("18038","112","1773","1","1","145.54","0","145.54","2019-02-14","2019-02-09","","1","1");
INSERT INTO contas_receber VALUES("18039","28","1779","1","1","154.64","0","154.64","2019-02-14","2019-02-14","","1","1");
INSERT INTO contas_receber VALUES("18040","84","1785","1","1","233.1","0","233.1","2019-02-14","2019-04-06","","1","1");
INSERT INTO contas_receber VALUES("18041","329","1781","1","1","285","0","285","2019-02-14","2019-03-17","","1","1");
INSERT INTO contas_receber VALUES("18042","329","1781","2","1","285","0","285","2019-02-14","2019-04-15","","1","1");
INSERT INTO contas_receber VALUES("18043","179","1780","1","1","251.33","0","251.33","2019-02-14","2019-03-17","","1","1");
INSERT INTO contas_receber VALUES("18044","179","1780","3","1","251.34","0","251.34","2019-02-14","2019-04-16","","1","1");
INSERT INTO contas_receber VALUES("18045","179","1780","2","1","251.33","0","251.33","2019-02-14","2019-04-01","","1","1");
INSERT INTO contas_receber VALUES("18046","187","1783","1","1","893.67","0","893.67","2019-02-14","2019-03-17","","1","1");
INSERT INTO contas_receber VALUES("18047","187","1783","3","1","893.66","0","893.66","2019-02-14","2019-04-15","","1","1");
INSERT INTO contas_receber VALUES("18048","187","1783","2","1","893.67","0","893.67","2019-02-14","2019-04-01","","1","1");
INSERT INTO contas_receber VALUES("18051","126","1778","1","1","134.68","0","134.68","2019-02-14","2019-02-14","","1","1");
INSERT INTO contas_receber VALUES("18054","46","1789","1","1","345","0","345","2019-02-15","2019-03-21","","1","1");
INSERT INTO contas_receber VALUES("18063","25","1792","1","1","4307.63","4307.63","0","2019-02-15","2019-02-16","","0","1");
INSERT INTO contas_receber VALUES("18081","129","1788","1","1","685","0","685","2019-02-18","2019-03-21","","1","1");
INSERT INTO contas_receber VALUES("18082","129","1788","2","1","685","0","685","2019-02-18","2019-04-05","","1","1");
INSERT INTO contas_receber VALUES("18083","129","1788","3","1","685","0","685","2019-02-18","2019-04-21","","1","1");
INSERT INTO contas_receber VALUES("18116","19","1794","1","1","326.77","0","326.77","2019-02-18","2019-03-21","","1","1");
INSERT INTO contas_receber VALUES("18117","19","1794","2","1","326.77","0","326.77","2019-02-18","2019-04-05","","1","1");
INSERT INTO contas_receber VALUES("18118","19","1794","3","1","326.77","0","326.77","2019-02-18","2019-04-19","","1","1");
INSERT INTO contas_receber VALUES("18139","31","1795","1","1","285.25","0","285.25","2019-02-19","2019-03-21","","1","1");
INSERT INTO contas_receber VALUES("18140","31","1795","2","1","285.25","0","285.25","2019-02-19","2019-04-05","","1","1");
INSERT INTO contas_receber VALUES("18141","31","1795","3","1","285.25","0","285.25","2019-02-19","2019-04-19","","1","1");
INSERT INTO contas_receber VALUES("18142","113","1787","1","1","400.75","0","400.75","2019-02-19","2019-03-22","","1","1");
INSERT INTO contas_receber VALUES("18143","113","1787","2","1","400.75","0","400.75","2019-02-19","2019-04-06","","1","1");
INSERT INTO contas_receber VALUES("18144","113","1787","3","1","400.75","0","400.75","2019-02-19","2019-04-20","","1","1");
INSERT INTO contas_receber VALUES("18145","323","1791","1","1","405.82","0","405.82","2019-02-19","2019-03-22","","1","1");
INSERT INTO contas_receber VALUES("18146","323","1791","2","1","405.82","0","405.82","2019-02-19","2019-04-06","","1","1");
INSERT INTO contas_receber VALUES("18147","323","1791","3","1","405.81","0","405.81","2019-02-19","2019-04-20","","1","1");
INSERT INTO contas_receber VALUES("18168","438","1775","1","1","893.8","0","893.8","2019-02-19","2019-02-28","","1","1");
INSERT INTO contas_receber VALUES("18169","438","1775","2","1","893.8","0","893.8","2019-02-19","2019-03-04","","1","1");
INSERT INTO contas_receber VALUES("18170","438","1775","3","1","893.8","0","893.8","2019-02-19","2019-03-06","","1","1");
INSERT INTO contas_receber VALUES("18171","375","1790","1","1","193","0","193","2019-02-19","2019-02-16","","1","1");
INSERT INTO contas_receber VALUES("18195","12","1802","1","1","503.4","503.4","0","2019-02-20","2019-02-21","","0","0");
INSERT INTO contas_receber VALUES("18200","3","1804","1","1","107.76","0","107.76","2019-02-20","2019-02-21","","1","1");
INSERT INTO contas_receber VALUES("18207","4","1797","1","1","1214.17","0","1214.17","2019-02-20","2019-03-21","","1","1");
INSERT INTO contas_receber VALUES("18208","4","1797","2","1","1214.17","0","1214.17","2019-02-20","2019-04-05","","1","1");
INSERT INTO contas_receber VALUES("18209","4","1797","3","1","1214.16","0","1214.16","2019-02-20","2019-04-20","","1","1");
INSERT INTO contas_receber VALUES("18236","220","1796","1","1","3439.1","0","3439.1","2019-02-21","2019-03-24","","1","1");
INSERT INTO contas_receber VALUES("18237","220","1796","4","1","3439.1","0","3439.1","2019-02-21","2019-05-09","","1","1");
INSERT INTO contas_receber VALUES("18238","220","1796","3","1","3439.1","0","3439.1","2019-02-21","2019-04-24","","1","1");
INSERT INTO contas_receber VALUES("18239","220","1796","2","1","3439.1","0","3439.1","2019-02-21","2019-04-09","","1","1");
INSERT INTO contas_receber VALUES("18240","185","1808","1","1","120","0","120","2019-02-21","2019-02-22","","1","1");
INSERT INTO contas_receber VALUES("18259","299","1801","1","1","427.5","0","427.5","2019-02-25","2019-03-25","","1","1");
INSERT INTO contas_receber VALUES("18290","12","1803","1","1","503.4","0","503.4","2019-02-25","2019-03-27","","1","1");
INSERT INTO contas_receber VALUES("18299","101","1798","1","1","715.78","0","715.78","2019-02-25","2019-03-27","","1","1");
INSERT INTO contas_receber VALUES("18300","101","1798","2","1","715.78","0","715.78","2019-02-25","2019-04-07","","1","1");
INSERT INTO contas_receber VALUES("18301","101","1798","3","1","715.79","0","715.79","2019-02-25","2019-04-27","","1","1");
INSERT INTO contas_receber VALUES("18302","186","1799","1","1","475.87","0","475.87","2019-02-25","2019-03-28","","1","1");
INSERT INTO contas_receber VALUES("18303","186","1799","2","1","475.87","0","475.87","2019-02-25","2019-04-08","","1","1");
INSERT INTO contas_receber VALUES("18304","186","1799","3","1","475.86","0","475.86","2019-02-25","2019-04-26","","1","1");
INSERT INTO contas_receber VALUES("18305","25","1793","1","1","2075.7","0","2075.7","2019-02-25","2019-03-27","","1","1");
INSERT INTO contas_receber VALUES("18306","25","1793","3","1","2075.71","0","2075.71","2019-02-25","2019-04-25","","1","1");
INSERT INTO contas_receber VALUES("18307","25","1793","2","1","2075.7","0","2075.7","2019-02-25","2019-04-07","","1","1");
INSERT INTO contas_receber VALUES("18308","190","1805","1","1","36.18","0","36.18","2019-02-25","2019-02-22","","1","1");
INSERT INTO contas_receber VALUES("18321","316","1800","1","1","405.14","0","405.14","2019-02-26","2019-03-27","","1","1");
INSERT INTO contas_receber VALUES("18322","316","1800","2","1","405.14","0","405.14","2019-02-26","2019-04-02","","1","1");
INSERT INTO contas_receber VALUES("18323","316","1800","3","1","405.15","0","405.15","2019-02-26","2019-04-17","","1","1");
INSERT INTO contas_receber VALUES("18324","212","1806","1","1","782.53","0","782.53","2019-02-26","2019-03-28","","1","1");
INSERT INTO contas_receber VALUES("18325","212","1806","2","1","782.53","0","782.53","2019-02-26","2019-04-13","","1","1");
INSERT INTO contas_receber VALUES("18326","212","1806","3","1","782.54","0","782.54","2019-02-26","2019-04-26","","1","1");
INSERT INTO contas_receber VALUES("18327","212","1806","4","1","476.6","0","476.6","2019-02-26","2019-05-10","","1","1");
INSERT INTO contas_receber VALUES("18328","339","1810","1","1","226.2","0","226.2","2019-02-26","2019-03-27","","1","1");
INSERT INTO contas_receber VALUES("18329","440","1809","1","1","432.77","0","432.77","2019-02-26","2019-03-29","","1","1");
INSERT INTO contas_receber VALUES("18330","440","1809","2","1","432.77","0","432.77","2019-02-26","2019-04-13","","1","1");
INSERT INTO contas_receber VALUES("18331","440","1809","3","1","432.76","0","432.76","2019-02-26","2019-04-27","","1","1");
INSERT INTO contas_receber VALUES("18338","394","1811","1","1","404.33","0","404.33","2019-02-27","2019-03-29","","1","1");
INSERT INTO contas_receber VALUES("18339","394","1811","2","1","404.33","0","404.33","2019-02-27","2019-04-13","","1","1");
INSERT INTO contas_receber VALUES("18340","394","1811","3","1","404.34","0","404.34","2019-02-27","2019-04-27","","1","1");
INSERT INTO contas_receber VALUES("18341","33","1816","1","1","794.95","0","794.95","2019-02-27","2019-03-11","","1","1");
INSERT INTO contas_receber VALUES("18342","33","1816","2","1","794.95","0","794.95","2019-02-27","2019-03-11","","1","1");
INSERT INTO contas_receber VALUES("18343","441","1821","1","1","25.64","0","25.64","2019-02-27","2019-02-28","","1","1");
INSERT INTO contas_receber VALUES("18347","442","1822","1","1","605.83","605.83","0","2019-02-27","2019-02-28","","0","0");
INSERT INTO contas_receber VALUES("18348","442","1822","3","0","605.84","605.84","0","2019-02-27","2019-05-01","","0","0");
INSERT INTO contas_receber VALUES("18349","442","1822","2","1","605.83","605.83","0","2019-02-27","2019-03-31","","0","0");
INSERT INTO contas_receber VALUES("18360","439","1820","1","1","105.2","0","105.2","2019-02-27","2019-02-28","","1","1");
INSERT INTO contas_receber VALUES("18362","175","1813","1","1","105.39","0","105.39","2019-02-27","2019-02-28","","1","1");
INSERT INTO contas_receber VALUES("18363","147","1823","1","1","180","180","0","2019-02-27","2019-03-01","","0","1");
INSERT INTO contas_receber VALUES("18371","24","1814","1","1","648","0","648","2019-02-28","2019-03-15","","1","1");
INSERT INTO contas_receber VALUES("18372","24","1814","2","1","648","0","648","2019-02-28","2019-03-15","","1","1");
INSERT INTO contas_receber VALUES("18373","60","1815","1","1","602.47","0","602.47","2019-02-28","2019-04-01","","1","1");
INSERT INTO contas_receber VALUES("18374","60","1815","3","1","602.46","0","602.46","2019-02-28","2019-05-01","","1","1");
INSERT INTO contas_receber VALUES("18375","60","1815","2","1","602.47","0","602.47","2019-02-28","2019-04-16","","1","1");
INSERT INTO contas_receber VALUES("18376","354","1807","1","1","414.44","0","414.44","2019-02-28","2019-04-01","","1","1");
INSERT INTO contas_receber VALUES("18377","354","1807","2","1","414.44","0","414.44","2019-02-28","2019-04-16","","1","1");
INSERT INTO contas_receber VALUES("18378","354","1807","3","1","414.45","0","414.45","2019-02-28","2019-05-01","","1","1");
INSERT INTO contas_receber VALUES("18391","46","1818","1","1","312.47","0","312.47","2019-02-28","2019-03-28","","1","1");
INSERT INTO contas_receber VALUES("18392","133","1819","1","1","435.5","0","435.5","2019-02-28","2019-04-01","","1","1");
INSERT INTO contas_receber VALUES("18393","71","1817","1","1","407.72","0","407.72","2019-02-28","2019-04-01","","1","1");
INSERT INTO contas_receber VALUES("18394","71","1817","3","1","407.71","0","407.71","2019-02-28","2019-05-01","","1","1");
INSERT INTO contas_receber VALUES("18395","71","1817","2","1","407.72","0","407.72","2019-02-28","2019-04-16","","1","1");
INSERT INTO contas_receber VALUES("18396","112","1831","1","1","64.64","0","64.64","2019-02-28","2019-03-01","","1","1");
INSERT INTO contas_receber VALUES("18416","443","1825","1","1","295.7","0","295.7","2019-03-01","2019-04-01","","1","1");
INSERT INTO contas_receber VALUES("18417","443","1825","2","1","295.7","0","295.7","2019-03-01","2019-05-01","","1","1");
INSERT INTO contas_receber VALUES("18418","224","1827","1","1","113.61","0","113.61","2019-03-01","2019-04-01","","1","1");
INSERT INTO contas_receber VALUES("18446","60","1834","1","1","446.55","0","446.55","2019-03-01","2019-05-10","","1","1");
INSERT INTO contas_receber VALUES("18461","445","1830","2","1","414.67","414.67","0","2019-03-06","2019-04-02","","0","1");
INSERT INTO contas_receber VALUES("18462","445","1830","1","1","414.67","414.67","0","2019-03-06","2019-03-02","","0","1");
INSERT INTO contas_receber VALUES("18463","445","1830","3","1","414.66","414.66","0","2019-03-06","2019-05-03","","0","1");
INSERT INTO contas_receber VALUES("18467","445","1836","1","1","414.67","0","414.67","2019-03-06","2019-04-06","","1","1");
INSERT INTO contas_receber VALUES("18468","445","1836","2","1","414.67","0","414.67","2019-03-06","2019-04-21","","1","1");
INSERT INTO contas_receber VALUES("18469","445","1836","3","1","414.66","0","414.66","2019-03-06","2019-05-06","","1","1");
INSERT INTO contas_receber VALUES("18473","329","1832","1","1","293.13","0","293.13","2019-03-06","2019-04-06","","1","1");
INSERT INTO contas_receber VALUES("18474","329","1832","3","1","109.41","0","109.41","2019-03-06","2019-04-21","","1","1");
INSERT INTO contas_receber VALUES("18475","329","1832","2","1","293.13","0","293.13","2019-03-06","2019-05-06","","1","1");
INSERT INTO contas_receber VALUES("18476","42","1833","1","1","743.77","0","743.77","2019-03-06","2019-04-07","","1","1");
INSERT INTO contas_receber VALUES("18477","42","1833","2","1","743.77","0","743.77","2019-03-06","2019-04-22","","1","1");
INSERT INTO contas_receber VALUES("18478","42","1833","3","1","743.76","0","743.76","2019-03-06","2019-05-07","","1","1");
INSERT INTO contas_receber VALUES("18480","98","1837","1","1","821","821","0","2019-03-06","2019-03-07","","0","0");
INSERT INTO contas_receber VALUES("18531","70","1786","1","1","797.2","0","797.2","2019-03-07","2019-03-22","","1","1");
INSERT INTO contas_receber VALUES("18532","70","1786","2","1","797.2","0","797.2","2019-03-07","2019-03-22","","1","1");
INSERT INTO contas_receber VALUES("18535","46","1840","1","1","269.62","0","269.62","2019-03-07","2019-04-07","","1","1");
INSERT INTO contas_receber VALUES("18551","446","1847","1","1","92.6","92.6","0","2019-03-08","2019-03-10","","0","0");
INSERT INTO contas_receber VALUES("18552","86","1838","1","1","348.67","0","348.67","2019-03-08","2019-04-08","","1","1");
INSERT INTO contas_receber VALUES("18553","86","1838","2","1","348.67","0","348.67","2019-03-08","2019-04-23","","1","1");
INSERT INTO contas_receber VALUES("18554","86","1838","3","1","348.66","0","348.66","2019-03-08","2019-05-08","","1","1");
INSERT INTO contas_receber VALUES("18555","243","1842","1","1","595.47","0","595.47","2019-03-08","2019-04-12","","1","1");
INSERT INTO contas_receber VALUES("18556","243","1842","3","1","595.48","0","595.48","2019-03-08","2019-05-12","","1","1");
INSERT INTO contas_receber VALUES("18557","243","1842","2","1","595.47","0","595.47","2019-03-08","2019-04-27","","1","1");
INSERT INTO contas_receber VALUES("18558","398","1843","1","1","1384","0","1384","2019-03-08","2019-03-08","","1","1");
INSERT INTO contas_receber VALUES("18559","175","1839","1","1","105.12","0","105.12","2019-03-08","2019-03-08","","1","1");
INSERT INTO contas_receber VALUES("18560","380","1835","1","1","1106.5","0","1106.5","2019-03-08","2019-04-07","","1","1");
INSERT INTO contas_receber VALUES("18561","380","1835","2","1","1106.5","0","1106.5","2019-03-08","2019-04-22","","1","1");
INSERT INTO contas_receber VALUES("18562","380","1835","3","1","1106.5","0","1106.5","2019-03-08","2019-05-07","","1","1");
INSERT INTO contas_receber VALUES("18563","3","1826","1","1","226.45","0","226.45","2019-03-08","2019-03-02","","1","1");
INSERT INTO contas_receber VALUES("18564","40","1828","1","1","225","0","225","2019-03-08","2019-03-02","","1","1");
INSERT INTO contas_receber VALUES("18565","444","1829","1","1","2339.28","0","2339.28","2019-03-08","2019-03-02","","1","1");
INSERT INTO contas_receber VALUES("18566","183","1845","1","0","260","0","260","2019-03-08","2019-03-09","","1","1");
INSERT INTO contas_receber VALUES("18570","370","1846","1","1","818.1","818.1","0","2019-03-08","2019-03-10","","0","0");
INSERT INTO contas_receber VALUES("18571","370","1846","2","1","818.1","818.1","0","2019-03-08","2019-04-10","","0","0");
INSERT INTO contas_receber VALUES("18572","370","1846","3","1","818.1","818.1","0","2019-03-08","2019-05-11","","0","0");
INSERT INTO contas_receber VALUES("18610","180","1844","2","1","418.19","0","418.19","2019-03-11","2019-04-26","","1","1");
INSERT INTO contas_receber VALUES("18611","180","1844","1","1","418.19","0","418.19","2019-03-11","2019-04-11","","1","1");
INSERT INTO contas_receber VALUES("18612","180","1844","3","1","418.2","0","418.2","2019-03-11","2019-05-11","","1","1");
INSERT INTO contas_receber VALUES("18613","31","1849","1","1","419.17","0","419.17","2019-03-11","2019-04-11","","1","1");
INSERT INTO contas_receber VALUES("18614","31","1849","2","1","419.17","0","419.17","2019-03-11","2019-04-26","","1","1");
INSERT INTO contas_receber VALUES("18615","31","1849","3","1","419.16","0","419.16","2019-03-11","2019-05-11","","1","1");
INSERT INTO contas_receber VALUES("18633","308","1856","1","1","583.75","583.75","0","2019-03-12","2019-03-14","","0","1");
INSERT INTO contas_receber VALUES("18634","308","1856","2","1","583.75","583.75","0","2019-03-12","2019-04-14","","0","1");
INSERT INTO contas_receber VALUES("18635","308","1856","3","1","583.75","583.75","0","2019-03-12","2019-05-15","","0","1");
INSERT INTO contas_receber VALUES("18647","308","1859","2","1","572.6","572.6","0","2019-03-12","2019-04-13","","0","0");
INSERT INTO contas_receber VALUES("18648","308","1859","1","1","572.6","572.6","0","2019-03-12","2019-03-13","","0","0");
INSERT INTO contas_receber VALUES("18649","308","1859","3","1","572.6","572.6","0","2019-03-12","2019-05-14","","0","0");
INSERT INTO contas_receber VALUES("18650","9","1848","1","1","1640.76","0","1640.76","2019-03-12","2019-04-12","","1","1");
INSERT INTO contas_receber VALUES("18651","9","1848","2","1","1640.76","0","1640.76","2019-03-12","2019-05-12","","1","1");
INSERT INTO contas_receber VALUES("18652","9","1848","3","1","1640.76","0","1640.76","2019-03-12","2019-06-12","","1","1");
INSERT INTO contas_receber VALUES("18653","59","1824","1","1","462.2","0","462.2","2019-03-12","2019-04-13","","1","1");
INSERT INTO contas_receber VALUES("18654","59","1824","3","1","462.2","0","462.2","2019-03-12","2019-05-13","","1","1");
INSERT INTO contas_receber VALUES("18655","59","1824","2","1","462.2","0","462.2","2019-03-12","2019-04-28","","1","1");
INSERT INTO contas_receber VALUES("18657","3","1855","1","1","291.09","0","291.09","2019-03-12","2019-03-15","","1","1");
INSERT INTO contas_receber VALUES("18658","354","1857","2","1","435.5","0","435.5","2019-03-13","2019-05-13","","1","1");
INSERT INTO contas_receber VALUES("18659","354","1857","1","1","435.5","0","435.5","2019-03-13","2019-04-13","","1","1");
INSERT INTO contas_receber VALUES("18660","74","1851","1","1","1187.67","0","1187.67","2019-03-13","2019-04-16","","1","1");
INSERT INTO contas_receber VALUES("18661","74","1851","3","1","1187.66","0","1187.66","2019-03-13","2019-05-16","","1","1");
INSERT INTO contas_receber VALUES("18662","74","1851","2","1","1187.67","0","1187.67","2019-03-13","2019-05-01","","1","1");
INSERT INTO contas_receber VALUES("18692","447","1862","1","1","627.58","627.58","0","2019-03-14","2019-03-15","","0","0");
INSERT INTO contas_receber VALUES("18693","447","1862","2","1","627.58","627.58","0","2019-03-14","2019-04-15","","0","0");
INSERT INTO contas_receber VALUES("18694","447","1862","3","1","627.58","627.58","0","2019-03-14","2019-05-16","","0","0");
INSERT INTO contas_receber VALUES("18695","447","1862","4","1","627.56","627.56","0","2019-03-14","2019-06-16","","0","0");
INSERT INTO contas_receber VALUES("18700","198","1863","1","1","628.5","628.5","0","2019-03-14","2019-03-15","","0","0");
INSERT INTO contas_receber VALUES("18701","198","1863","2","1","628.5","628.5","0","2019-03-14","2019-04-15","","0","0");
INSERT INTO contas_receber VALUES("18702","198","1863","3","1","628.5","628.5","0","2019-03-14","2019-05-16","","0","0");
INSERT INTO contas_receber VALUES("18703","198","1863","4","1","628.5","628.5","0","2019-03-14","2019-06-16","","0","0");
INSERT INTO contas_receber VALUES("18712","4","1853","1","1","1263.67","0","1263.67","2019-03-14","2019-04-18","","1","1");
INSERT INTO contas_receber VALUES("18713","4","1853","2","1","1263.67","0","1263.67","2019-03-14","2019-05-03","","1","1");
INSERT INTO contas_receber VALUES("18714","4","1853","3","1","1263.66","0","1263.66","2019-03-14","2019-05-18","","1","1");
INSERT INTO contas_receber VALUES("18738","344","1866","1","1","572.6","0","572.6","2019-03-14","2019-04-14","","1","1");
INSERT INTO contas_receber VALUES("18739","344","1866","2","1","572.6","0","572.6","2019-03-14","2019-04-29","","1","1");
INSERT INTO contas_receber VALUES("18740","344","1866","3","1","572.6","0","572.6","2019-03-14","2019-05-14","","1","1");
INSERT INTO contas_receber VALUES("18741","303","1864","1","1","1005.28","0","1005.28","2019-03-15","2019-04-15","","1","1");
INSERT INTO contas_receber VALUES("18742","303","1864","2","1","1005.28","0","1005.28","2019-03-15","2019-04-30","","1","1");
INSERT INTO contas_receber VALUES("18743","303","1864","3","1","1005.29","0","1005.29","2019-03-15","2019-05-15","","1","1");
INSERT INTO contas_receber VALUES("18744","30","1860","1","1","724.8","0","724.8","2019-03-15","2019-04-15","","1","1");
INSERT INTO contas_receber VALUES("18745","30","1860","5","1","724.8","0","724.8","2019-03-15","2019-05-30","","1","1");
INSERT INTO contas_receber VALUES("18746","30","1860","2","1","724.8","0","724.8","2019-03-15","2019-04-30","","1","1");
INSERT INTO contas_receber VALUES("18747","30","1860","4","1","724.8","0","724.8","2019-03-15","2019-05-20","","1","1");
INSERT INTO contas_receber VALUES("18748","30","1860","3","1","724.8","0","724.8","2019-03-15","2019-05-10","","1","1");
INSERT INTO contas_receber VALUES("18749","31","1861","1","1","128.8","0","128.8","2019-03-15","2019-04-08","","1","1");
INSERT INTO contas_receber VALUES("18750","31","1861","2","1","128.8","0","128.8","2019-03-15","2019-05-02","","1","1");
INSERT INTO contas_receber VALUES("18751","3","1867","1","1","124.99","0","124.99","2019-03-15","2019-03-16","","1","1");
INSERT INTO contas_receber VALUES("18752","33","1850","1","1","217.8","0","217.8","2019-03-15","2019-03-25","","1","1");
INSERT INTO contas_receber VALUES("18753","33","1850","2","1","355","0","355","2019-03-15","2019-03-25","","1","1");
INSERT INTO contas_receber VALUES("18774","184","1854","1","1","75.57","0","75.57","2019-03-18","2019-03-14","","1","1");
INSERT INTO contas_receber VALUES("18775","329","1858","1","1","377","0","377","2019-03-18","2019-04-13","","1","1");
INSERT INTO contas_receber VALUES("18776","329","1858","2","1","377","0","377","2019-03-18","2019-05-13","","1","1");
INSERT INTO contas_receber VALUES("18785","28","1852","1","1","267.85","0","267.85","2019-03-18","2019-04-18","","1","1");
INSERT INTO contas_receber VALUES("18786","28","1852","2","1","267.85","0","267.85","2019-03-18","2019-05-18","","1","1");
INSERT INTO contas_receber VALUES("18793","12","1865","1","1","841.03","0","841.03","2019-03-19","2019-04-18","","1","1");
INSERT INTO contas_receber VALUES("18794","12","1865","3","1","841.04","0","841.04","2019-03-19","2019-05-18","","1","1");
INSERT INTO contas_receber VALUES("18795","12","1865","2","1","841.03","0","841.03","2019-03-19","2019-05-03","","1","1");
INSERT INTO contas_receber VALUES("18796","161","1868","1","1","761.68","0","761.68","2019-03-19","2019-04-19","","1","1");
INSERT INTO contas_receber VALUES("18797","161","1868","2","1","761.68","0","761.68","2019-03-19","2019-05-04","","1","1");
INSERT INTO contas_receber VALUES("18798","161","1868","3","1","761.69","0","761.69","2019-03-19","2019-05-19","","1","1");
INSERT INTO contas_receber VALUES("18823","363","1876","1","1","1179.97","1179.97","0","2019-03-20","2019-03-21","","0","0");
INSERT INTO contas_receber VALUES("18824","363","1876","2","1","1179.97","1179.97","0","2019-03-20","2019-04-21","","0","0");
INSERT INTO contas_receber VALUES("18825","363","1876","3","1","1179.97","1179.97","0","2019-03-20","2019-05-22","","0","0");
INSERT INTO contas_receber VALUES("18826","363","1876","4","1","1179.99","1179.99","0","2019-03-20","2019-06-22","","0","0");
INSERT INTO contas_receber VALUES("18837","0","0","0","0","0","0","0","2019-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("18838","0","0","0","0","0","0","0","2019-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("18840","0","0","0","0","0","0","0","2019-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("18841","0","0","0","0","0","0","0","2019-03-20","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("18842","3","1871","1","1","32.02","0","32.02","2019-03-21","2019-03-21","","1","1");
INSERT INTO contas_receber VALUES("18843","59","1880","1","1","256.5","0","256.5","2019-03-21","2019-04-22","","1","1");
INSERT INTO contas_receber VALUES("18844","203","1874","1","1","1329","0","1329","2019-03-21","2019-04-05","","1","1");
INSERT INTO contas_receber VALUES("18845","203","1874","2","1","1329.01","0","1329.01","2019-03-21","2019-04-05","","1","1");
INSERT INTO contas_receber VALUES("18846","33","1879","2","1","572.8","0","572.8","2019-03-21","2019-04-01","","1","1");
INSERT INTO contas_receber VALUES("18847","33","1879","1","1","572.8","0","572.8","2019-03-21","2019-04-01","","1","1");
INSERT INTO contas_receber VALUES("18885","3","1877","1","1","121.52","0","121.52","2019-03-22","2019-03-22","","1","1");
INSERT INTO contas_receber VALUES("18889","30","1888","1","1","528","528","0","2019-03-22","2019-03-23","","0","0");
INSERT INTO contas_receber VALUES("18890","30","1888","2","1","528","528","0","2019-03-22","2019-04-23","","0","0");
INSERT INTO contas_receber VALUES("18891","30","1888","3","1","528","528","0","2019-03-22","2019-05-24","","0","0");
INSERT INTO contas_receber VALUES("18914","46","1886","1","1","149.54","0","149.54","2019-03-25","2019-04-25","","1","1");
INSERT INTO contas_receber VALUES("18915","292","1881","1","1","2166.5","0","2166.5","2019-03-25","2019-04-26","","1","1");
INSERT INTO contas_receber VALUES("18916","292","1881","3","1","2166.5","0","2166.5","2019-03-25","2019-05-26","","1","1");
INSERT INTO contas_receber VALUES("18917","292","1881","2","1","2166.5","0","2166.5","2019-03-25","2019-05-11","","1","1");
INSERT INTO contas_receber VALUES("18918","212","1883","1","1","773.17","0","773.17","2019-03-25","2019-04-26","","1","1");
INSERT INTO contas_receber VALUES("18919","212","1883","2","1","773.17","0","773.17","2019-03-25","2019-05-11","","1","1");
INSERT INTO contas_receber VALUES("18920","212","1883","3","1","773.17","0","773.17","2019-03-25","2019-05-26","","1","1");
INSERT INTO contas_receber VALUES("18925","0","0","0","0","0","0","0","2019-03-25","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("18926","0","0","0","0","0","0","0","2019-03-25","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("18929","0","0","0","0","0","0","0","2019-03-25","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("18930","0","0","0","0","0","0","0","2019-03-25","0000-00-00","","0","0");
INSERT INTO contas_receber VALUES("18970","329","1890","3","1","357.14","0","357.14","2019-03-26","2019-05-26","","1","1");
INSERT INTO contas_receber VALUES("18971","329","1890","1","1","357.13","0","357.13","2019-03-26","2019-04-26","","1","1");
INSERT INTO contas_receber VALUES("18972","329","1890","2","1","357.13","0","357.13","2019-03-26","2019-05-11","","1","1");
INSERT INTO contas_receber VALUES("18973","260","1878","1","1","121.52","0","121.52","2019-03-26","2019-04-21","","1","1");
INSERT INTO contas_receber VALUES("18974","449","1891","1","1","155.05","0","155.05","2019-03-26","2019-03-24","","1","1");
INSERT INTO contas_receber VALUES("18981","128","1887","2","1","234.5","0","234.5","2019-03-26","2019-05-26","","1","1");
INSERT INTO contas_receber VALUES("18982","128","1887","1","1","234.5","0","234.5","2019-03-26","2019-04-26","","1","1");
INSERT INTO contas_receber VALUES("18989","369","1873","1","1","405.73","0","405.73","2019-03-26","2019-04-27","","1","1");
INSERT INTO contas_receber VALUES("18990","369","1873","3","1","405.74","0","405.74","2019-03-26","2019-05-27","","1","1");
INSERT INTO contas_receber VALUES("18991","369","1873","2","1","405.73","0","405.73","2019-03-26","2019-05-12","","1","1");
INSERT INTO contas_receber VALUES("19032","221","1872","3","1","1062.66","0","1062.66","2019-03-27","2019-05-25","","1","1");
INSERT INTO contas_receber VALUES("19033","221","1872","1","1","1062.67","0","1062.67","2019-03-27","2019-04-25","","1","1");
INSERT INTO contas_receber VALUES("19034","221","1872","2","1","1062.67","0","1062.67","2019-03-27","2019-05-10","","1","1");
INSERT INTO contas_receber VALUES("19035","41","1869","1","1","934.59","0","934.59","2019-03-27","2019-04-20","","1","1");
INSERT INTO contas_receber VALUES("19036","41","1869","3","1","934.59","0","934.59","2019-03-27","2019-06-04","","1","1");
INSERT INTO contas_receber VALUES("19037","41","1869","4","1","934.58","0","934.58","2019-03-27","2019-05-20","","1","1");
INSERT INTO contas_receber VALUES("19038","41","1869","2","1","934.59","0","934.59","2019-03-27","2019-05-20","","1","1");
INSERT INTO contas_receber VALUES("19039","381","1889","2","1","755.13","0","755.13","2019-03-27","2019-05-12","","1","1");
INSERT INTO contas_receber VALUES("19040","381","1889","3","1","755.14","0","755.14","2019-03-27","2019-05-27","","1","1");
INSERT INTO contas_receber VALUES("19041","381","1889","1","1","755.13","0","755.13","2019-03-27","2019-04-27","","1","1");
INSERT INTO contas_receber VALUES("19042","450","1893","1","1","190","0","190","2019-03-27","2019-04-08","","1","1");
INSERT INTO contas_receber VALUES("19045","32","1885","1","1","214.03","0","214.03","2019-03-27","2019-03-24","","1","1");
INSERT INTO contas_receber VALUES("19046","453","1907","1","1","164.33","0","164.33","2019-03-27","2019-03-28","","1","1");
INSERT INTO contas_receber VALUES("19047","28","1884","1","1","41.47","0","41.47","2019-03-27","2019-03-24","","1","1");
INSERT INTO contas_receber VALUES("19048","159","1875","1","1","510.6","0","510.6","2019-03-27","2019-03-21","","1","1");
INSERT INTO contas_receber VALUES("19067","203","1892","1","1","151.56","0","151.56","2019-03-28","2019-04-08","","1","1");
INSERT INTO contas_receber VALUES("19068","448","1870","1","1","172.5","0","172.5","2019-03-28","2019-04-27","","1","1");
INSERT INTO contas_receber VALUES("19087","263","1894","1","1","1746.96","0","1746.96","2019-03-29","2019-04-12","","1","1");
INSERT INTO contas_receber VALUES("19088","263","1894","2","1","1746.96","0","1746.96","2019-03-29","2019-04-12","","1","1");
INSERT INTO contas_receber VALUES("19089","220","1908","1","1","642","0","642","2019-03-29","2019-05-01","","1","1");
INSERT INTO contas_receber VALUES("19090","220","1908","2","1","642","0","642","2019-03-29","2019-05-16","","1","1");
INSERT INTO contas_receber VALUES("19091","220","1908","3","1","642","0","642","2019-03-29","2019-06-01","","1","1");
INSERT INTO contas_receber VALUES("19092","292","1882","3","1","2546.66","0","2546.66","2019-03-29","2019-06-01","","1","1");
INSERT INTO contas_receber VALUES("19093","292","1882","1","1","2546.67","0","2546.67","2019-03-29","2019-05-01","","1","1");
INSERT INTO contas_receber VALUES("19094","292","1882","2","1","2546.67","0","2546.67","2019-03-29","2019-05-16","","1","1");
INSERT INTO contas_receber VALUES("19109","220","1912","1","1","233.5","0","233.5","2019-03-29","2019-05-05","","1","1");
INSERT INTO contas_receber VALUES("19118","94","1913","1","1","330.93","0","330.93","2019-03-29","2019-03-31","","1","1");
INSERT INTO contas_receber VALUES("19119","94","1913","2","1","330.93","0","330.93","2019-03-29","2019-05-01","","1","1");
INSERT INTO contas_receber VALUES("19120","94","1913","3","1","330.94","0","330.94","2019-03-29","2019-06-01","","1","1");
INSERT INTO contas_receber VALUES("19121","94","1913","3","1","330.94","0","330.94","2019-03-29","2019-06-01","","1","1");
INSERT INTO contas_receber VALUES("19122","336","1896","1","1","620.17","0","620.17","2019-04-01","2019-05-01","","1","1");
INSERT INTO contas_receber VALUES("19123","336","1896","3","1","620.16","0","620.16","2019-04-01","2019-06-01","","1","1");
INSERT INTO contas_receber VALUES("19124","336","1896","2","1","620.17","0","620.17","2019-04-01","2019-05-16","","1","1");
INSERT INTO contas_receber VALUES("19125","19","1909","2","1","262.55","0","262.55","2019-04-01","2019-05-16","","1","1");
INSERT INTO contas_receber VALUES("19126","19","1909","1","1","262.55","0","262.55","2019-04-01","2019-05-01","","1","1");
INSERT INTO contas_receber VALUES("19127","19","1909","3","1","262.56","0","262.56","2019-04-01","2019-06-01","","1","1");
INSERT INTO contas_receber VALUES("19130","3","1903","1","1","86.36","0","86.36","2019-04-01","2019-03-29","","1","1");
INSERT INTO contas_receber VALUES("19135","452","1904","1","1","111.34","0","111.34","2019-04-01","2019-03-29","","1","1");
INSERT INTO contas_receber VALUES("19136","32","1906","1","1","332","0","332","2019-04-01","2019-03-29","","1","1");
INSERT INTO contas_receber VALUES("19149","4","1900","1","1","1107.67","0","1107.67","2019-04-02","2019-05-02","","1","1");
INSERT INTO contas_receber VALUES("19150","4","1900","2","1","1107.67","0","1107.67","2019-04-02","2019-05-17","","1","1");
INSERT INTO contas_receber VALUES("19151","4","1900","3","1","1107.66","0","1107.66","2019-04-02","2019-06-02","","1","1");
INSERT INTO contas_receber VALUES("19152","217","1895","1","1","619","0","619","2019-04-02","2019-05-03","","1","1");
INSERT INTO contas_receber VALUES("19153","217","1895","3","1","619","0","619","2019-04-02","2019-06-03","","1","1");
INSERT INTO contas_receber VALUES("19154","217","1895","2","1","619","0","619","2019-04-02","2019-05-18","","1","1");
INSERT INTO contas_receber VALUES("19155","68","1899","1","1","1178.1","0","1178.1","2019-04-02","2019-04-16","","1","1");
INSERT INTO contas_receber VALUES("19156","68","1899","2","1","1178.1","0","1178.1","2019-04-02","2019-04-16","","1","1");
INSERT INTO contas_receber VALUES("19157","84","1901","1","1","746.27","0","746.27","2019-04-02","2019-05-05","","1","1");
INSERT INTO contas_receber VALUES("19158","84","1901","3","1","746.26","0","746.26","2019-04-02","2019-06-05","","1","1");
INSERT INTO contas_receber VALUES("19159","84","1901","2","1","746.27","0","746.27","2019-04-02","2019-05-20","","1","1");
INSERT INTO contas_receber VALUES("19201","46","1918","1","1","83.24","0","83.24","2019-04-03","2019-05-03","","1","1");
INSERT INTO contas_receber VALUES("19226","60","1898","4","1","696.2","0","696.2","2019-04-04","2019-06-19","","1","1");
INSERT INTO contas_receber VALUES("19227","60","1898","2","1","696.2","0","696.2","2019-04-04","2019-05-19","","1","1");
INSERT INTO contas_receber VALUES("19228","60","1898","1","1","696.2","0","696.2","2019-04-04","2019-05-04","","1","1");
INSERT INTO contas_receber VALUES("19229","60","1898","3","1","696.2","0","696.2","2019-04-04","2019-06-04","","1","1");
INSERT INTO contas_receber VALUES("19230","31","1920","1","1","287.6","0","287.6","2019-04-04","2019-05-04","","1","1");
INSERT INTO contas_receber VALUES("19231","31","1920","2","1","287.6","0","287.6","2019-04-04","2019-06-04","","1","1");
INSERT INTO contas_receber VALUES("19232","451","1897","1","1","452.81","0","452.81","2019-04-04","2019-05-05","","1","1");
INSERT INTO contas_receber VALUES("19233","451","1897","2","1","452.81","0","452.81","2019-04-04","2019-05-20","","1","1");
INSERT INTO contas_receber VALUES("19234","451","1897","3","1","452.8","0","452.8","2019-04-04","2019-06-05","","1","1");
INSERT INTO contas_receber VALUES("19257","179","1915","1","1","371.55","0","371.55","2019-04-05","2019-05-09","","1","1");
INSERT INTO contas_receber VALUES("19258","179","1915","2","1","371.55","0","371.55","2019-04-05","2019-06-09","","1","1");
INSERT INTO contas_receber VALUES("19259","220","1902","1","1","2093.77","2093.77","0","2019-04-05","2019-05-08","","0","0");
INSERT INTO contas_receber VALUES("19260","220","1902","2","1","2093.77","2093.77","0","2019-04-05","2019-05-23","","0","0");
INSERT INTO contas_receber VALUES("19261","220","1902","3","1","2093.76","2093.76","0","2019-04-05","2019-06-08","","0","0");
INSERT INTO contas_receber VALUES("19272","212","1905","1","1","408.88","0","408.88","2019-04-08","2019-05-08","","1","1");
INSERT INTO contas_receber VALUES("19273","212","1905","3","1","408.88","0","408.88","2019-04-08","2019-06-08","","1","1");
INSERT INTO contas_receber VALUES("19274","212","1905","2","1","408.88","0","408.88","2019-04-08","2019-05-23","","1","1");
INSERT INTO contas_receber VALUES("19275","212","1905","4","1","598.51","0","598.51","2019-04-08","2019-06-24","","1","1");
INSERT INTO contas_receber VALUES("19276","6","1910","1","1","442.63","0","442.63","2019-04-08","2019-05-23","","1","1");
INSERT INTO contas_receber VALUES("19277","6","1910","2","1","442.63","0","442.63","2019-04-08","2019-06-07","","1","1");
INSERT INTO contas_receber VALUES("19278","6","1910","3","1","442.63","0","442.63","2019-04-08","2019-06-22","","1","1");
INSERT INTO contas_receber VALUES("19279","6","1910","4","1","442.61","0","442.61","2019-04-08","2019-07-02","","1","1");
INSERT INTO contas_receber VALUES("19317","22","1916","1","1","680.85","0","680.85","2019-04-09","2019-05-09","","1","1");
INSERT INTO contas_receber VALUES("19318","22","1916","3","1","680.86","0","680.86","2019-04-09","2019-06-09","","1","1");
INSERT INTO contas_receber VALUES("19319","22","1916","2","1","680.85","0","680.85","2019-04-09","2019-05-24","","1","1");
INSERT INTO contas_receber VALUES("19320","91","1919","1","1","1120.03","0","1120.03","2019-04-09","2019-04-22","","1","1");
INSERT INTO contas_receber VALUES("19321","91","1919","2","1","1120.02","0","1120.02","2019-04-09","2019-04-22","","1","1");
INSERT INTO contas_receber VALUES("19322","9","1917","1","1","310.3","0","310.3","2019-04-09","2019-05-10","","1","1");
INSERT INTO contas_receber VALUES("19323","47","1914","1","1","526.85","0","526.85","2019-04-09","2019-05-08","","1","1");
INSERT INTO contas_receber VALUES("19324","47","1914","3","1","526.85","0","526.85","2019-04-09","2019-06-08","","1","1");
INSERT INTO contas_receber VALUES("19325","47","1914","2","1","526.85","0","526.85","2019-04-09","2019-05-23","","1","1");
INSERT INTO contas_receber VALUES("19326","454","1921","1","1","185","0","185","2019-04-09","2019-04-04","","1","1");
INSERT INTO contas_receber VALUES("19327","3","1926","1","1","266.24","0","266.24","2019-04-09","2019-04-05","","1","1");
INSERT INTO contas_receber VALUES("19328","411","1933","1","1","72.82","0","72.82","2019-04-09","2019-04-08","","1","1");
INSERT INTO contas_receber VALUES("19376","456","1923","1","1","475.93","0","475.93","2019-04-10","2019-05-10","","1","1");
INSERT INTO contas_receber VALUES("19377","456","1923","3","1","475.94","0","475.94","2019-04-10","2019-06-10","","1","1");
INSERT INTO contas_receber VALUES("19378","456","1923","2","1","475.93","0","475.93","2019-04-10","2019-05-25","","1","1");
INSERT INTO contas_receber VALUES("19379","455","1922","3","1","565.2","0","565.2","2019-04-10","2019-06-10","","1","1");
INSERT INTO contas_receber VALUES("19380","455","1922","2","1","565.2","0","565.2","2019-04-10","2019-05-25","","1","1");
INSERT INTO contas_receber VALUES("19381","455","1922","1","1","565.2","0","565.2","2019-04-10","2019-05-10","","1","1");
INSERT INTO contas_receber VALUES("19382","98","1924","1","1","683.67","0","683.67","2019-04-10","2019-05-11","","1","1");
INSERT INTO contas_receber VALUES("19383","98","1924","2","1","683.67","0","683.67","2019-04-10","2019-06-11","","1","1");
INSERT INTO contas_receber VALUES("19384","98","1924","3","1","683.66","0","683.66","2019-04-10","2019-07-11","","1","1");
INSERT INTO contas_receber VALUES("19385","24","1927","1","1","929.38","0","929.38","2019-04-10","2019-04-22","","1","1");
INSERT INTO contas_receber VALUES("19386","24","1927","2","1","929.37","0","929.37","2019-04-10","2019-04-22","","1","1");
INSERT INTO contas_receber VALUES("19387","192","1925","1","1","1427.9","0","1427.9","2019-04-10","2019-04-06","","1","1");
INSERT INTO contas_receber VALUES("19398","96","1944","1","1","180","0","180","2019-04-10","2019-05-09","","1","1");
INSERT INTO contas_receber VALUES("19399","96","1944","2","1","180","0","180","2019-04-10","2019-06-09","","1","1");
INSERT INTO contas_receber VALUES("19409","386","1947","1","1","440","440","0","2019-04-10","2019-04-11","","0","0");
INSERT INTO contas_receber VALUES("19410","386","1947","2","1","440","440","0","2019-04-10","2019-05-12","","0","0");
INSERT INTO contas_receber VALUES("19411","386","1947","3","1","440","440","0","2019-04-10","2019-06-12","","0","0");
INSERT INTO contas_receber VALUES("19414","21","1928","1","1","1453.08","0","1453.08","2019-04-11","2019-05-06","","1","1");
INSERT INTO contas_receber VALUES("19415","21","1928","2","1","1453.08","0","1453.08","2019-04-11","2019-05-27","","1","1");
INSERT INTO contas_receber VALUES("19416","21","1928","3","1","1453.08","0","1453.08","2019-04-11","2019-06-06","","1","1");
INSERT INTO contas_receber VALUES("19417","21","1928","4","1","1453.06","0","1453.06","2019-04-11","2019-06-17","","1","1");
INSERT INTO contas_receber VALUES("19457","25","1929","1","1","1106.59","0","1106.59","2019-04-12","2019-05-15","","1","1");
INSERT INTO contas_receber VALUES("19458","25","1929","2","1","1106.59","0","1106.59","2019-04-12","2019-05-31","","1","1");
INSERT INTO contas_receber VALUES("19459","25","1929","3","1","1106.6","0","1106.6","2019-04-12","2019-06-15","","1","1");
INSERT INTO contas_receber VALUES("19460","418","1930","1","1","322","0","322","2019-04-12","2019-05-15","","1","1");
INSERT INTO contas_receber VALUES("19461","138","1931","2","1","454.1","0","454.1","2019-04-12","2019-05-30","","1","1");
INSERT INTO contas_receber VALUES("19462","138","1931","1","1","454.1","0","454.1","2019-04-12","2019-05-15","","1","1");
INSERT INTO contas_receber VALUES("19463","138","1931","3","1","454.1","0","454.1","2019-04-12","2019-06-15","","1","1");
INSERT INTO contas_receber VALUES("19478","457","1948","1","1","1425.4","0","1425.4","2019-04-15","2019-04-29","","1","1");
INSERT INTO contas_receber VALUES("19489","380","1940","1","1","603.32","0","603.32","2019-04-15","2019-05-16","","1","1");
INSERT INTO contas_receber VALUES("19490","380","1940","4","1","503","0","503","2019-04-15","2019-06-26","","1","1");
INSERT INTO contas_receber VALUES("19491","380","1940","5","1","503.24","0","503.24","2019-04-15","2019-07-05","","1","1");
INSERT INTO contas_receber VALUES("19492","380","1940","2","1","603.32","0","603.32","2019-04-15","2019-06-01","","1","1");
INSERT INTO contas_receber VALUES("19493","380","1940","3","1","603.32","0","603.32","2019-04-15","2019-06-16","","1","1");
INSERT INTO contas_receber VALUES("19494","4","1935","1","1","1240.33","0","1240.33","2019-04-15","2019-05-16","","1","1");
INSERT INTO contas_receber VALUES("19495","4","1935","2","1","1240.33","0","1240.33","2019-04-15","2019-06-01","","1","1");
INSERT INTO contas_receber VALUES("19496","4","1935","3","1","1240.34","0","1240.34","2019-04-15","2019-06-16","","1","1");
INSERT INTO contas_receber VALUES("19497","264","1939","1","1","242.4","0","242.4","2019-04-15","2019-04-13","","1","1");
INSERT INTO contas_receber VALUES("19498","310","1936","1","1","410.5","0","410.5","2019-04-15","2019-05-17","","1","1");
INSERT INTO contas_receber VALUES("19499","310","1936","2","1","410.5","0","410.5","2019-04-15","2019-06-01","","1","1");
INSERT INTO contas_receber VALUES("19500","310","1936","3","1","410.5","0","410.5","2019-04-15","2019-06-17","","1","1");
INSERT INTO contas_receber VALUES("19501","142","1941","1","1","158.88","0","158.88","2019-04-15","2019-04-13","","1","1");
INSERT INTO contas_receber VALUES("19502","3","1953","1","1","10.38","0","10.38","2019-04-15","2019-04-13","","1","1");
INSERT INTO contas_receber VALUES("19503","300","1932","1","1","69.56","69.56","0","2019-04-15","2019-04-07","","0","0");
INSERT INTO contas_receber VALUES("19504","44","1937","1","1","961.22","0","961.22","2019-04-16","2019-05-17","","1","1");
INSERT INTO contas_receber VALUES("19505","44","1937","2","1","961.22","0","961.22","2019-04-16","2019-06-01","","1","1");
INSERT INTO contas_receber VALUES("19506","44","1937","3","1","961.22","0","961.22","2019-04-16","2019-06-17","","1","1");
INSERT INTO contas_receber VALUES("19522","459","1952","1","1","1185.5","0","1185.5","2019-04-16","2019-04-30","","1","1");
INSERT INTO contas_receber VALUES("19564","462","1963","1","1","98.59","0","98.59","2019-04-17","2019-04-18","","1","1");
INSERT INTO contas_receber VALUES("19585","310","1958","1","1","377","0","377","2019-04-17","2019-05-25","","1","1");
INSERT INTO contas_receber VALUES("19586","310","1958","2","1","377","0","377","2019-04-17","2019-06-25","","1","1");
INSERT INTO contas_receber VALUES("19587","229","1938","2","1","915.4","0","915.4","2019-04-17","2019-06-02","","1","1");
INSERT INTO contas_receber VALUES("19588","229","1938","4","1","915.4","0","915.4","2019-04-17","2019-07-03","","1","1");
INSERT INTO contas_receber VALUES("19589","229","1938","3","1","915.4","0","915.4","2019-04-17","2019-06-18","","1","1");
INSERT INTO contas_receber VALUES("19590","229","1938","1","1","915.4","0","915.4","2019-04-17","2019-05-18","","1","1");
INSERT INTO contas_receber VALUES("19591","172","1956","1","1","75.4","0","75.4","2019-04-17","2019-05-18","","1","1");
INSERT INTO contas_receber VALUES("19596","322","1942","3","1","451.9","0","451.9","2019-04-18","2019-06-18","","1","1");
INSERT INTO contas_receber VALUES("19597","322","1942","1","1","451.9","0","451.9","2019-04-18","2019-05-18","","1","1");
INSERT INTO contas_receber VALUES("19598","322","1942","2","1","451.9","0","451.9","2019-04-18","2019-06-02","","1","1");
INSERT INTO contas_receber VALUES("19599","30","1945","2","1","756.02","0","756.02","2019-04-18","2019-06-02","","1","1");
INSERT INTO contas_receber VALUES("19600","30","1945","1","1","756.02","0","756.02","2019-04-18","2019-05-18","","1","1");
INSERT INTO contas_receber VALUES("19601","30","1945","3","1","756.02","0","756.02","2019-04-18","2019-06-18","","1","1");
INSERT INTO contas_receber VALUES("19602","30","1945","4","1","756.04","0","756.04","2019-04-18","2019-07-03","","1","1");
INSERT INTO contas_receber VALUES("19603","458","1950","3","1","398.7","0","398.7","2019-04-18","2019-06-18","","1","1");
INSERT INTO contas_receber VALUES("19604","458","1950","1","1","398.7","0","398.7","2019-04-18","2019-05-18","","1","1");
INSERT INTO contas_receber VALUES("19605","458","1950","2","1","398.7","0","398.7","2019-04-18","2019-06-02","","1","1");
INSERT INTO contas_receber VALUES("19606","255","1949","1","1","1675.8","0","1675.8","2019-04-18","2019-05-02","","1","1");
INSERT INTO contas_receber VALUES("19628","291","1970","1","1","421.85","421.85","0","2019-04-18","2019-04-19","","0","0");
INSERT INTO contas_receber VALUES("19629","291","1970","2","1","421.85","421.85","0","2019-04-18","2019-05-20","","0","0");
INSERT INTO contas_receber VALUES("19630","291","1970","3","1","421.84","421.84","0","2019-04-18","2019-06-20","","0","0");
INSERT INTO contas_receber VALUES("19631","316","1946","3","1","407.74","0","407.74","2019-04-22","2019-06-18","","1","1");
INSERT INTO contas_receber VALUES("19632","316","1946","1","1","407.73","0","407.73","2019-04-22","2019-05-18","","1","1");
INSERT INTO contas_receber VALUES("19633","316","1946","2","1","407.73","0","407.73","2019-04-22","2019-06-02","","1","1");
INSERT INTO contas_receber VALUES("19634","243","1951","1","1","402.19","0","402.19","2019-04-22","2019-05-22","","1","1");
INSERT INTO contas_receber VALUES("19635","243","1951","2","1","402.19","0","402.19","2019-04-22","2019-06-06","","1","1");
INSERT INTO contas_receber VALUES("19636","243","1951","3","1","402.19","0","402.19","2019-04-22","2019-06-22","","1","1");
INSERT INTO contas_receber VALUES("19637","261","1955","1","1","514.8","0","514.8","2019-04-22","2019-05-22","","1","1");
INSERT INTO contas_receber VALUES("19638","261","1955","3","1","514.8","0","514.8","2019-04-22","2019-06-22","","1","1");
INSERT INTO contas_receber VALUES("19639","261","1955","2","1","514.8","0","514.8","2019-04-22","2019-06-06","","1","1");
INSERT INTO contas_receber VALUES("19640","461","1957","1","1","618.45","0","618.45","2019-04-22","2019-05-06","","1","1");
INSERT INTO contas_receber VALUES("19641","461","1957","2","1","618.45","0","618.45","2019-04-22","2019-05-06","","1","1");
INSERT INTO contas_receber VALUES("19642","33","1965","1","1","616.2","0","616.2","2019-04-22","2019-05-03","","1","1");
INSERT INTO contas_receber VALUES("19643","33","1965","2","1","616.2","0","616.2","2019-04-22","2019-05-03","","1","1");
INSERT INTO contas_receber VALUES("19652","463","1967","1","1","105.77","0","105.77","2019-04-22","2019-04-19","","1","1");
INSERT INTO contas_receber VALUES("19653","315","1934","1","1","1425.4","0","1425.4","2019-04-22","2019-04-29","","1","1");
INSERT INTO contas_receber VALUES("19654","460","1954","1","1","237.99","0","237.99","2019-04-22","2019-05-16","","1","1");
INSERT INTO contas_receber VALUES("19655","252","1962","1","1","650.17","0","650.17","2019-04-23","2019-05-23","","1","1");
INSERT INTO contas_receber VALUES("19656","252","1962","2","1","650.17","0","650.17","2019-04-23","2019-06-07","","1","1");
INSERT INTO contas_receber VALUES("19657","252","1962","3","1","650.16","0","650.16","2019-04-23","2019-06-23","","1","1");
INSERT INTO contas_receber VALUES("19658","241","1960","1","1","278.8","0","278.8","2019-04-23","2019-05-23","","1","1");
INSERT INTO contas_receber VALUES("19659","241","1960","2","1","278.8","0","278.8","2019-04-23","2019-06-23","","1","1");
INSERT INTO contas_receber VALUES("19660","212","1961","1","1","954.54","0","954.54","2019-04-23","2019-05-24","","1","1");
INSERT INTO contas_receber VALUES("19661","212","1961","2","1","954.54","0","954.54","2019-04-23","2019-06-08","","1","1");
INSERT INTO contas_receber VALUES("19662","212","1961","3","1","954.54","0","954.54","2019-04-23","2019-06-24","","1","1");
INSERT INTO contas_receber VALUES("19663","455","1964","1","1","768.63","0","768.63","2019-04-23","2019-05-24","","1","1");
INSERT INTO contas_receber VALUES("19664","455","1964","2","1","768.63","0","768.63","2019-04-23","2019-06-08","","1","1");
INSERT INTO contas_receber VALUES("19665","455","1964","3","1","768.63","0","768.63","2019-04-23","2019-06-24","","1","1");
INSERT INTO contas_receber VALUES("19666","455","1964","4","1","768.61","0","768.61","2019-04-23","2019-07-10","","1","1");
INSERT INTO contas_receber VALUES("19751","35","1911","1","1","145.74","0","145.74","2019-04-23","2019-05-10","","1","1");
INSERT INTO contas_receber VALUES("19752","35","1911","2","1","145.74","0","145.74","2019-04-23","2019-06-10","","1","1");
INSERT INTO contas_receber VALUES("19753","323","1959","1","1","580.3","0","580.3","2019-04-24","2019-05-30","","1","1");
INSERT INTO contas_receber VALUES("19754","323","1959","3","1","580.3","0","580.3","2019-04-24","2019-06-21","","1","1");
INSERT INTO contas_receber VALUES("19755","323","1959","2","1","580.3","0","580.3","2019-04-24","2019-06-06","","1","1");
INSERT INTO contas_receber VALUES("19756","435","1966","1","1","521.7","0","521.7","2019-04-24","2019-05-06","","1","1");
INSERT INTO contas_receber VALUES("19765","4","1968","1","1","1191","0","1191","2019-04-25","2019-05-26","","1","1");
INSERT INTO contas_receber VALUES("19766","4","1968","3","1","1191","0","1191","2019-04-25","2019-06-26","","1","1");
INSERT INTO contas_receber VALUES("19767","4","1968","2","1","1191","0","1191","2019-04-25","2019-06-10","","1","1");
INSERT INTO contas_receber VALUES("19768","357","1969","1","1","405.39","0","405.39","2019-04-25","2019-05-26","","1","1");
INSERT INTO contas_receber VALUES("19769","357","1969","2","1","405.39","0","405.39","2019-04-25","2019-06-10","","1","1");
INSERT INTO contas_receber VALUES("19770","357","1969","3","1","405.4","0","405.4","2019-04-25","2019-06-26","","1","1");
INSERT INTO contas_receber VALUES("19771","465","1971","2","1","217.75","0","217.75","2019-04-25","2019-06-26","","1","1");
INSERT INTO contas_receber VALUES("19772","465","1971","1","1","217.75","0","217.75","2019-04-25","2019-05-26","","1","1");
INSERT INTO contas_receber VALUES("19781","31","1977","1","1","458.27","0","458.27","2019-04-26","2019-05-26","","1","1");
INSERT INTO contas_receber VALUES("19782","31","1977","2","1","458.27","0","458.27","2019-04-26","2019-06-10","","1","1");
INSERT INTO contas_receber VALUES("19783","31","1977","3","1","458.26","0","458.26","2019-04-26","2019-06-26","","1","1");
INSERT INTO contas_receber VALUES("19793","408","1586","1","1","200","0","200","2019-04-26","2018-11-09","","1","1");
INSERT INTO contas_receber VALUES("19814","3","1984","1","1","127.18","0","127.18","2019-04-29","2019-04-28","","1","1");
INSERT INTO contas_receber VALUES("19866","156","1992","1","1","445.73","445.73","0","2019-04-29","2019-04-30","","0","0");
INSERT INTO contas_receber VALUES("19867","156","1992","2","1","445.73","445.73","0","2019-04-29","2019-05-31","","0","0");
INSERT INTO contas_receber VALUES("19868","156","1992","3","1","445.74","445.74","0","2019-04-29","2019-07-01","","0","0");
INSERT INTO contas_receber VALUES("19879","220","1976","2","1","3668.29","0","3668.29","2019-04-30","2019-06-14","","1","1");
INSERT INTO contas_receber VALUES("19880","220","1976","3","1","3668.3","0","3668.3","2019-04-30","2019-06-30","","1","1");
INSERT INTO contas_receber VALUES("19881","220","1976","1","1","3668.29","0","3668.29","2019-04-30","2019-05-30","","1","1");
INSERT INTO contas_receber VALUES("19882","455","1981","1","1","372.67","0","372.67","2019-04-30","2019-05-30","","1","1");
INSERT INTO contas_receber VALUES("19883","455","1981","2","1","372.67","0","372.67","2019-04-30","2019-06-10","","1","1");
INSERT INTO contas_receber VALUES("19884","455","1981","3","1","372.66","0","372.66","2019-04-30","2019-06-30","","1","1");
INSERT INTO contas_receber VALUES("19885","203","1978","1","1","1246.27","0","1246.27","2019-04-30","2019-05-10","","1","1");
INSERT INTO contas_receber VALUES("19886","203","1978","2","1","1246.27","0","1246.27","2019-04-30","2019-05-10","","1","1");
INSERT INTO contas_receber VALUES("19887","192","1972","1","1","1002.56","0","1002.56","2019-04-30","2019-05-17","","1","1");
INSERT INTO contas_receber VALUES("19888","192","1972","2","1","2003.44","0","2003.44","2019-04-30","2019-05-17","","1","1");
INSERT INTO contas_receber VALUES("19889","408","1983","1","1","154.4","0","154.4","2019-04-30","2019-04-28","","1","1");
INSERT INTO contas_receber VALUES("19890","304","1989","1","1","34.78","0","34.78","2019-04-30","2019-05-01","","1","1");
INSERT INTO contas_receber VALUES("19928","466","1974","1","1","749.31","0","749.31","2019-05-02","2019-06-02","","1","1");
INSERT INTO contas_receber VALUES("19929","466","1974","2","1","749.31","0","749.31","2019-05-02","2019-06-17","","1","1");
INSERT INTO contas_receber VALUES("19930","466","1974","3","1","749.3","0","749.3","2019-05-02","2019-07-02","","1","1");
INSERT INTO contas_receber VALUES("19931","59","1975","1","1","418.8","0","418.8","2019-05-02","2019-05-30","","1","1");
INSERT INTO contas_receber VALUES("19932","59","1975","2","1","418.8","0","418.8","2019-05-02","2019-06-10","","1","1");
INSERT INTO contas_receber VALUES("19933","59","1975","3","1","418.8","0","418.8","2019-05-02","2019-06-30","","1","1");
INSERT INTO contas_receber VALUES("19943","42","1998","1","1","831.67","831.67","0","2019-05-02","2019-05-03","","0","0");
INSERT INTO contas_receber VALUES("19944","42","1998","2","1","831.67","831.67","0","2019-05-02","2019-06-03","","0","0");
INSERT INTO contas_receber VALUES("19945","42","1998","3","1","831.66","831.66","0","2019-05-02","2019-07-04","","0","0");
INSERT INTO contas_receber VALUES("19967","4","1979","1","1","1288.83","0","1288.83","2019-05-02","2019-06-03","","1","1");
INSERT INTO contas_receber VALUES("19968","4","1979","2","1","1288.83","0","1288.83","2019-05-02","2019-06-18","","1","1");
INSERT INTO contas_receber VALUES("19969","4","1979","3","1","1288.84","0","1288.84","2019-05-02","2019-07-03","","1","1");
INSERT INTO contas_receber VALUES("19970","468","1980","1","1","610.13","0","610.13","2019-05-02","2019-06-02","","1","1");
INSERT INTO contas_receber VALUES("19971","468","1980","2","1","610.12","0","610.12","2019-05-02","2019-06-17","","1","1");
INSERT INTO contas_receber VALUES("20002","469","1982","1","1","421.85","0","421.85","2019-05-03","2019-06-03","","1","1");
INSERT INTO contas_receber VALUES("20003","469","1982","3","1","421.84","0","421.84","2019-05-03","2019-07-03","","1","1");
INSERT INTO contas_receber VALUES("20004","469","1982","2","1","421.85","0","421.85","2019-05-03","2019-05-18","","1","1");
INSERT INTO contas_receber VALUES("20005","129","1985","1","1","754","0","754","2019-05-03","2019-06-06","","1","1");
INSERT INTO contas_receber VALUES("20006","129","1985","3","1","754","0","754","2019-05-03","2019-07-06","","1","1");
INSERT INTO contas_receber VALUES("20007","129","1985","2","1","754","0","754","2019-05-03","2019-06-21","","1","1");
INSERT INTO contas_receber VALUES("20008","186","1986","2","1","297.55","0","297.55","2019-05-03","2019-07-06","","1","1");
INSERT INTO contas_receber VALUES("20009","186","1986","1","1","297.55","0","297.55","2019-05-03","2019-06-06","","1","1");
INSERT INTO contas_receber VALUES("20010","47","1991","1","1","516.31","0","516.31","2019-05-03","2019-06-06","","1","1");
INSERT INTO contas_receber VALUES("20011","47","1991","2","1","516.31","0","516.31","2019-05-03","2019-06-21","","1","1");
INSERT INTO contas_receber VALUES("20012","47","1991","3","1","516.31","0","516.31","2019-05-03","2019-07-06","","1","1");
INSERT INTO contas_receber VALUES("20013","25","1990","3","1","728.43","0","728.43","2019-05-03","2019-07-07","","1","1");
INSERT INTO contas_receber VALUES("20014","25","1990","1","1","728.43","0","728.43","2019-05-03","2019-06-07","","1","1");
INSERT INTO contas_receber VALUES("20015","25","1990","2","1","728.43","0","728.43","2019-05-03","2019-06-22","","1","1");
INSERT INTO contas_receber VALUES("20041","472","2008","1","1","475.96","0","475.96","2019-05-06","2019-05-07","","1","1");
INSERT INTO contas_receber VALUES("20051","35","2010","1","1","53.78","53.78","0","2019-05-06","2019-05-07","","0","0");
INSERT INTO contas_receber VALUES("20063","329","1993","1","1","349.3","0","349.3","2019-05-07","2019-06-07","","1","1");
INSERT INTO contas_receber VALUES("20064","329","1993","2","1","349.3","0","349.3","2019-05-07","2019-06-22","","1","1");
INSERT INTO contas_receber VALUES("20065","329","1993","3","1","349.3","0","349.3","2019-05-07","2019-07-07","","1","1");
INSERT INTO contas_receber VALUES("20066","347","1987","2","1","708.9","0","708.9","2019-05-07","2019-06-25","","1","1");
INSERT INTO contas_receber VALUES("20067","347","1987","1","1","708.9","0","708.9","2019-05-07","2019-06-10","","1","1");
INSERT INTO contas_receber VALUES("20068","84","1996","3","1","590.64","0","590.64","2019-05-07","2019-07-08","","1","1");
INSERT INTO contas_receber VALUES("20069","84","1996","2","1","590.63","0","590.63","2019-05-07","2019-06-23","","1","1");
INSERT INTO contas_receber VALUES("20070","84","1996","1","1","590.63","0","590.63","2019-05-07","2019-06-08","","1","1");
INSERT INTO contas_receber VALUES("20071","76","1997","2","1","398.92","0","398.92","2019-05-07","2019-06-23","","1","1");
INSERT INTO contas_receber VALUES("20072","76","1997","3","1","398.91","0","398.91","2019-05-07","2019-07-08","","1","1");
INSERT INTO contas_receber VALUES("20073","76","1997","1","1","398.92","0","398.92","2019-05-07","2019-06-08","","1","1");
INSERT INTO contas_receber VALUES("20074","413","1999","2","1","790","0","790","2019-05-07","2019-06-25","","1","1");
INSERT INTO contas_receber VALUES("20075","413","1999","3","1","790","0","790","2019-05-07","2019-07-10","","1","1");
INSERT INTO contas_receber VALUES("20076","413","1999","1","1","790","0","790","2019-05-07","2019-06-10","","1","1");
INSERT INTO contas_receber VALUES("20077","5","1988","2","1","441.4","0","441.4","2019-05-07","2019-06-24","","1","1");
INSERT INTO contas_receber VALUES("20078","5","1988","3","1","441.4","0","441.4","2019-05-07","2019-07-09","","1","1");
INSERT INTO contas_receber VALUES("20079","5","1988","1","1","441.4","0","441.4","2019-05-07","2019-06-09","","1","1");
INSERT INTO contas_receber VALUES("20080","220","1995","1","1","223","0","223","2019-05-07","2019-06-10","","1","1");
INSERT INTO contas_receber VALUES("20101","264","2005","1","1","335.3","0","335.3","2019-05-07","2019-05-06","","1","1");
INSERT INTO contas_receber VALUES("20102","31","2007","3","1","253.38","0","253.38","2019-05-07","2019-07-08","","1","1");
INSERT INTO contas_receber VALUES("20103","31","2007","2","1","253.38","0","253.38","2019-05-07","2019-06-23","","1","1");
INSERT INTO contas_receber VALUES("20104","31","2007","1","1","253.38","0","253.38","2019-05-07","2019-06-08","","1","1");
INSERT INTO contas_receber VALUES("20105","255","1994","1","1","2076.5","0","2076.5","2019-05-07","2019-05-23","","1","1");
INSERT INTO contas_receber VALUES("20106","28","2003","1","1","184.25","0","184.25","2019-05-07","2019-05-05","","1","1");
INSERT INTO contas_receber VALUES("20113","98","2011","1","1","700.33","0","700.33","2019-05-08","2019-06-08","","1","1");
INSERT INTO contas_receber VALUES("20114","98","2011","2","1","700.33","0","700.33","2019-05-08","2019-07-08","","1","1");
INSERT INTO contas_receber VALUES("20115","98","2011","3","1","700.34","0","700.34","2019-05-08","2019-08-08","","1","1");
INSERT INTO contas_receber VALUES("20161","28","2019","1","1","262.3","0","262.3","2019-05-09","2019-05-10","","1","1");
INSERT INTO contas_receber VALUES("20177","24","2001","1","1","606.52","0","606.52","2019-05-10","2019-05-24","","1","1");
INSERT INTO contas_receber VALUES("20178","24","2001","2","1","606.53","0","606.53","2019-05-10","2019-05-24","","1","1");
INSERT INTO contas_receber VALUES("20179","70","2009","2","1","970.15","0","970.15","2019-05-10","2019-05-23","","1","1");
INSERT INTO contas_receber VALUES("20180","70","2009","1","1","970.15","0","970.15","2019-05-10","2019-05-23","","1","1");
INSERT INTO contas_receber VALUES("20230","294","2004","1","1","354.64","0","354.64","2019-05-14","2019-06-13","","1","1");
INSERT INTO contas_receber VALUES("20231","294","2004","2","1","354.64","0","354.64","2019-05-14","2019-06-28","","1","1");
INSERT INTO contas_receber VALUES("20232","294","2004","3","1","354.64","0","354.64","2019-05-14","2019-07-13","","1","1");
INSERT INTO contas_receber VALUES("20248","224","2030","1","1","262.3","262.3","0","2019-05-14","2019-05-15","","0","0");
INSERT INTO contas_receber VALUES("20249","224","2030","2","1","262.3","262.3","0","2019-05-14","2019-06-15","","0","0");
INSERT INTO contas_receber VALUES("20250","224","2030","3","1","262.3","262.3","0","2019-05-14","2019-07-16","","0","0");
INSERT INTO contas_receber VALUES("20260","331","2032","1","1","4016.67","4016.67","0","2019-05-15","2019-05-16","","0","0");
INSERT INTO contas_receber VALUES("20261","331","2032","2","1","4016.67","4016.67","0","2019-05-15","2019-06-16","","0","0");
INSERT INTO contas_receber VALUES("20262","331","2032","3","1","4016.66","4016.66","0","2019-05-15","2019-07-17","","0","0");
INSERT INTO contas_receber VALUES("20265","457","2000","1","1","408.92","0","408.92","2019-05-15","2019-06-10","","1","1");
INSERT INTO contas_receber VALUES("20266","457","2000","3","1","408.91","0","408.91","2019-05-15","2019-07-10","","1","1");
INSERT INTO contas_receber VALUES("20267","457","2000","2","1","408.92","0","408.92","2019-05-15","2019-06-25","","1","1");
INSERT INTO contas_receber VALUES("20268","212","2012","1","1","818.9","0","818.9","2019-05-15","2019-06-10","","1","1");
INSERT INTO contas_receber VALUES("20269","212","2012","2","1","818.9","0","818.9","2019-05-15","2019-06-25","","1","1");
INSERT INTO contas_receber VALUES("20270","212","2012","3","1","818.89","0","818.89","2019-05-15","2019-07-10","","1","1");
INSERT INTO contas_receber VALUES("20271","195","2018","1","1","178.31","0","178.31","2019-05-15","2019-06-15","","1","1");
INSERT INTO contas_receber VALUES("20272","195","2018","2","1","178.32","0","178.32","2019-05-15","2019-07-15","","1","1");
INSERT INTO contas_receber VALUES("20273","344","2014","1","1","665.65","0","665.65","2019-05-15","2019-06-16","","1","1");
INSERT INTO contas_receber VALUES("20274","344","2014","3","1","665.65","0","665.65","2019-05-15","2019-07-16","","1","1");
INSERT INTO contas_receber VALUES("20275","344","2014","4","1","665.65","0","665.65","2019-05-15","2019-07-31","","1","1");
INSERT INTO contas_receber VALUES("20276","344","2014","2","1","665.65","0","665.65","2019-05-15","2019-07-01","","1","1");
INSERT INTO contas_receber VALUES("20311","62","2015","1","1","476.95","0","476.95","2019-05-16","2019-06-17","","1","1");
INSERT INTO contas_receber VALUES("20312","62","2015","2","1","476.95","0","476.95","2019-05-16","2019-07-02","","1","1");
INSERT INTO contas_receber VALUES("20313","62","2015","3","1","476.95","0","476.95","2019-05-16","2019-07-17","","1","1");
INSERT INTO contas_receber VALUES("20314","12","2023","1","1","604.8","0","604.8","2019-05-16","2019-06-16","","1","1");
INSERT INTO contas_receber VALUES("20315","347","2025","1","1","216.93","0","216.93","2019-05-16","2019-06-16","","1","1");
INSERT INTO contas_receber VALUES("20316","347","2025","3","1","216.94","0","216.94","2019-05-16","2019-07-16","","1","1");
INSERT INTO contas_receber VALUES("20317","347","2025","2","1","216.93","0","216.93","2019-05-16","2019-07-02","","1","1");
INSERT INTO contas_receber VALUES("20318","381","2024","1","1","704.33","0","704.33","2019-05-16","2019-06-17","","1","1");
INSERT INTO contas_receber VALUES("20319","381","2024","3","1","704.34","0","704.34","2019-05-16","2019-07-17","","1","1");
INSERT INTO contas_receber VALUES("20320","381","2024","2","1","704.33","0","704.33","2019-05-16","2019-07-03","","1","1");
INSERT INTO contas_receber VALUES("20349","292","2013","1","1","4268","0","4268","2019-05-17","2019-06-17","","1","1");
INSERT INTO contas_receber VALUES("20350","292","2013","3","1","4268","0","4268","2019-05-17","2019-07-17","","1","1");
INSERT INTO contas_receber VALUES("20351","292","2013","2","1","4268","0","4268","2019-05-17","2019-07-02","","1","1");
INSERT INTO contas_receber VALUES("20352","227","2031","1","1","262.3","0","262.3","2019-05-17","2019-06-20","","1","1");
INSERT INTO contas_receber VALUES("20353","227","2031","2","1","262.3","0","262.3","2019-05-17","2019-07-06","","1","1");
INSERT INTO contas_receber VALUES("20354","227","2031","3","1","262.3","0","262.3","2019-05-17","2019-07-20","","1","1");
INSERT INTO contas_receber VALUES("20356","439","2042","1","1","42.72","0","42.72","2019-05-17","2019-05-18","","1","1");
INSERT INTO contas_receber VALUES("20357","439","2017","1","1","53.4","0","53.4","2019-05-17","2019-05-10","","1","1");
INSERT INTO contas_receber VALUES("20388","203","2028","1","1","631.5","0","631.5","2019-05-20","2019-05-31","","1","1");
INSERT INTO contas_receber VALUES("20389","203","2028","2","1","631.5","0","631.5","2019-05-20","2019-05-31","","1","1");
INSERT INTO contas_receber VALUES("20390","4","2027","3","1","1119.34","0","1119.34","2019-05-20","2019-07-21","","1","1");
INSERT INTO contas_receber VALUES("20391","4","2027","2","1","1119.33","0","1119.33","2019-05-20","2019-07-07","","1","1");
INSERT INTO contas_receber VALUES("20392","4","2027","1","1","1119.33","0","1119.33","2019-05-20","2019-06-21","","1","1");
INSERT INTO contas_receber VALUES("20403","475","2035","1","1","1132.7","0","1132.7","2019-05-21","2019-06-20","","1","1");
INSERT INTO contas_receber VALUES("20404","475","2035","2","1","1132.7","0","1132.7","2019-05-21","2019-07-20","","1","1");
INSERT INTO contas_receber VALUES("20405","476","2036","1","1","1219.9","0","1219.9","2019-05-21","2019-06-19","","1","1");
INSERT INTO contas_receber VALUES("20412","380","2038","2","1","944.43","0","944.43","2019-05-21","2019-07-08","","1","1");
INSERT INTO contas_receber VALUES("20413","380","2038","1","1","944.43","0","944.43","2019-05-21","2019-06-22","","1","1");
INSERT INTO contas_receber VALUES("20414","380","2038","3","1","944.44","0","944.44","2019-05-21","2019-07-22","","1","1");
INSERT INTO contas_receber VALUES("20415","31","2041","1","1","377.6","0","377.6","2019-05-21","2019-06-21","","1","1");
INSERT INTO contas_receber VALUES("20416","31","2041","2","1","377.6","0","377.6","2019-05-21","2019-07-06","","1","1");
INSERT INTO contas_receber VALUES("20417","31","2041","3","1","377.6","0","377.6","2019-05-21","2019-07-21","","1","1");
INSERT INTO contas_receber VALUES("20457","471","2002","1","1","157.13","0","157.13","2019-05-22","2019-05-05","","1","1");
INSERT INTO contas_receber VALUES("20458","35","2006","1","1","139.81","0","139.81","2019-05-22","2019-06-14","","1","1");
INSERT INTO contas_receber VALUES("20459","35","2006","2","1","139.82","0","139.82","2019-05-22","2019-07-14","","1","1");
INSERT INTO contas_receber VALUES("20460","3","2016","1","1","177.32","0","177.32","2019-05-22","2019-05-10","","1","1");
INSERT INTO contas_receber VALUES("20461","471","2020","1","1","132","0","132","2019-05-22","2019-05-11","","1","1");
INSERT INTO contas_receber VALUES("20463","473","2021","1","1","34.41","0","34.41","2019-05-22","2019-05-11","","1","1");
INSERT INTO contas_receber VALUES("20466","69","2022","1","1","239.15","239.15","0","2019-05-22","2019-05-11","","0","0");
INSERT INTO contas_receber VALUES("20467","69","2022","2","1","239.15","239.15","0","2019-05-22","2019-06-11","","0","0");
INSERT INTO contas_receber VALUES("20468","385","2026","1","1","702.25","0","702.25","2019-05-22","2019-06-20","","1","1");
INSERT INTO contas_receber VALUES("20469","385","2026","2","1","702.25","0","702.25","2019-05-22","2019-07-05","","1","1");
INSERT INTO contas_receber VALUES("20470","385","2026","3","1","702.25","0","702.25","2019-05-22","2019-07-20","","1","1");
INSERT INTO contas_receber VALUES("20471","385","2026","4","1","702.25","0","702.25","2019-05-22","2019-08-05","","1","1");
INSERT INTO contas_receber VALUES("20472","410","2040","1","1","154.64","0","154.64","2019-05-22","2019-05-18","","1","1");
INSERT INTO contas_receber VALUES("20473","474","2029","1","1","159.08","0","159.08","2019-05-22","2019-05-17","","1","1");
INSERT INTO contas_receber VALUES("20474","25","2034","1","1","1184.85","0","1184.85","2019-05-23","2019-06-23","","1","1");
INSERT INTO contas_receber VALUES("20475","25","2034","2","1","1184.85","0","1184.85","2019-05-23","2019-07-09","","1","1");
INSERT INTO contas_receber VALUES("20476","25","2034","3","1","1184.85","0","1184.85","2019-05-23","2019-07-23","","1","1");
INSERT INTO contas_receber VALUES("20477","30","2037","1","1","884.98","0","884.98","2019-05-23","2019-06-23","","1","1");
INSERT INTO contas_receber VALUES("20478","30","2037","4","1","884.96","0","884.96","2019-05-23","2019-08-07","","1","1");
INSERT INTO contas_receber VALUES("20479","30","2037","2","1","884.98","0","884.98","2019-05-23","2019-07-09","","1","1");
INSERT INTO contas_receber VALUES("20480","30","2037","3","1","884.98","0","884.98","2019-05-23","2019-07-23","","1","1");
INSERT INTO contas_receber VALUES("20502","174","2051","1","1","669.63","669.63","0","2019-05-23","2019-05-24","","0","0");
INSERT INTO contas_receber VALUES("20503","174","2051","2","1","669.63","669.63","0","2019-05-23","2019-06-24","","0","0");
INSERT INTO contas_receber VALUES("20504","174","2051","3","1","669.64","669.64","0","2019-05-23","2019-07-25","","0","0");
INSERT INTO contas_receber VALUES("20527","67","2039","1","1","403.17","0","403.17","2019-05-24","2019-06-24","","1","1");
INSERT INTO contas_receber VALUES("20528","67","2039","2","1","403.17","0","403.17","2019-05-24","2019-07-10","","1","1");
INSERT INTO contas_receber VALUES("20529","67","2039","3","1","403.16","0","403.16","2019-05-24","2019-07-24","","1","1");
INSERT INTO contas_receber VALUES("20536","205","2044","3","1","576.5","0","576.5","2019-05-24","2019-07-27","","1","1");
INSERT INTO contas_receber VALUES("20537","205","2044","2","1","576.5","0","576.5","2019-05-24","2019-07-13","","1","1");
INSERT INTO contas_receber VALUES("20538","205","2044","1","1","576.5","0","576.5","2019-05-24","2019-06-27","","1","1");
INSERT INTO contas_receber VALUES("20539","31","2049","1","1","240","0","240","2019-05-24","2019-06-27","","1","1");
INSERT INTO contas_receber VALUES("20561","411","2058","1","1","538.33","538.33","0","2019-05-24","2019-05-25","","0","0");
INSERT INTO contas_receber VALUES("20562","411","2058","2","1","538.33","538.33","0","2019-05-24","2019-06-25","","0","0");
INSERT INTO contas_receber VALUES("20563","411","2058","3","1","538.34","538.34","0","2019-05-24","2019-07-26","","0","0");
INSERT INTO contas_receber VALUES("20584","211","2046","1","1","614.87","0","614.87","2019-05-27","2019-06-28","","1","1");
INSERT INTO contas_receber VALUES("20585","211","2046","2","1","614.87","0","614.87","2019-05-27","2019-07-14","","1","1");
INSERT INTO contas_receber VALUES("20586","211","2046","3","1","614.86","0","614.86","2019-05-27","2019-07-28","","1","1");
INSERT INTO contas_receber VALUES("20593","357","2047","1","1","438.73","0","438.73","2019-05-27","2019-06-28","","1","1");
INSERT INTO contas_receber VALUES("20594","357","2047","2","1","438.73","0","438.73","2019-05-27","2019-07-14","","1","1");
INSERT INTO contas_receber VALUES("20595","357","2047","3","1","438.74","0","438.74","2019-05-27","2019-07-28","","1","1");
INSERT INTO contas_receber VALUES("20596","3","2053","1","1","104.12","0","104.12","2019-05-27","2019-05-26","","1","1");
INSERT INTO contas_receber VALUES("20597","205","2061","1","1","173.5","0","173.5","2019-05-27","2019-07-02","","1","1");
INSERT INTO contas_receber VALUES("20606","19","1973","2","1","226.6","0","226.6","2019-05-27","2019-06-10","","1","1");
INSERT INTO contas_receber VALUES("20607","19","1973","3","1","226.6","0","226.6","2019-05-27","2019-06-26","","1","1");
INSERT INTO contas_receber VALUES("20608","19","1973","1","1","226.6","0","226.6","2019-05-27","2019-05-26","","1","1");
INSERT INTO contas_receber VALUES("20621","478","2065","1","1","217.5","217.5","0","2019-05-27","2019-05-28","","0","0");
INSERT INTO contas_receber VALUES("20622","478","2065","2","1","217.5","217.5","0","2019-05-27","2019-06-28","","0","0");
INSERT INTO contas_receber VALUES("20659","101","2068","1","0","465.33","465.33","0","2019-05-28","2019-05-29","","0","0");
INSERT INTO contas_receber VALUES("20660","101","2068","2","0","465.33","465.33","0","2019-05-28","2019-06-29","","0","0");
INSERT INTO contas_receber VALUES("20661","101","2068","3","0","465.34","465.34","0","2019-05-28","2019-07-30","","0","0");
INSERT INTO contas_receber VALUES("20662","370","2069","1","0","485.17","485.17","0","2019-05-28","2019-05-29","","0","0");
INSERT INTO contas_receber VALUES("20663","370","2069","2","0","485.17","485.17","0","2019-05-28","2019-06-29","","0","0");
INSERT INTO contas_receber VALUES("20664","370","2069","3","0","485.16","485.16","0","2019-05-28","2019-07-30","","0","0");
INSERT INTO contas_receber VALUES("20677","245","2056","1","1","196.81","0","196.81","2019-05-28","2019-06-29","","1","1");
INSERT INTO contas_receber VALUES("20678","245","2056","2","1","196.81","0","196.81","2019-05-28","2019-07-29","","1","1");
INSERT INTO contas_receber VALUES("20679","245","2056","3","1","196.83","0","196.83","2019-05-28","2019-08-29","","1","1");
INSERT INTO contas_receber VALUES("20680","245","2056","4","1","107.56","0","107.56","2019-05-28","2019-07-15","","1","1");
INSERT INTO contas_receber VALUES("20685","143","2048","1","1","1340.37","0","1340.37","2019-05-28","2019-06-29","","1","1");
INSERT INTO contas_receber VALUES("20686","143","2048","2","1","1340.37","0","1340.37","2019-05-28","2019-07-14","","1","1");
INSERT INTO contas_receber VALUES("20687","143","2048","3","1","1340.36","0","1340.36","2019-05-28","2019-07-29","","1","1");
INSERT INTO contas_receber VALUES("20690","23","2050","1","1","570.84","0","570.84","2019-05-29","2019-06-30","","1","1");
INSERT INTO contas_receber VALUES("20691","23","2050","2","1","570.84","0","570.84","2019-05-29","2019-07-10","","1","1");
INSERT INTO contas_receber VALUES("20692","23","2050","3","1","570.84","0","570.84","2019-05-29","2019-07-20","","1","1");
INSERT INTO contas_receber VALUES("20693","23","2050","5","1","570.84","0","570.84","2019-05-29","2019-08-14","","1","1");
INSERT INTO contas_receber VALUES("20694","23","2050","4","1","570.84","0","570.84","2019-05-29","2019-08-01","","1","1");
INSERT INTO contas_receber VALUES("20695","84","2052","1","1","554.06","0","554.06","2019-05-29","2019-06-29","","1","1");
INSERT INTO contas_receber VALUES("20696","84","2052","2","1","554.06","0","554.06","2019-05-29","2019-07-14","","1","1");
INSERT INTO contas_receber VALUES("20697","84","2052","3","1","554.06","0","554.06","2019-05-29","2019-07-29","","1","1");
INSERT INTO contas_receber VALUES("20698","7","2057","1","1","190.67","0","190.67","2019-05-29","2019-06-29","","1","1");
INSERT INTO contas_receber VALUES("20699","7","2057","2","1","190.67","0","190.67","2019-05-29","2019-07-29","","1","1");
INSERT INTO contas_receber VALUES("20700","7","2057","3","1","190.66","0","190.66","2019-05-29","2019-08-29","","1","1");
INSERT INTO contas_receber VALUES("20701","179","2060","1","1","421.08","0","421.08","2019-05-29","2019-06-29","","1","1");
INSERT INTO contas_receber VALUES("20702","179","2060","2","1","421.08","0","421.08","2019-05-29","2019-07-14","","1","1");
INSERT INTO contas_receber VALUES("20703","179","2060","3","1","421.08","0","421.08","2019-05-29","2019-07-29","","1","1");
INSERT INTO contas_receber VALUES("20704","477","2045","1","1","722.5","0","722.5","2019-05-29","2019-05-24","","1","1");
INSERT INTO contas_receber VALUES("20705","28","2054","1","1","173.4","0","173.4","2019-05-29","2019-05-26","","1","1");
INSERT INTO contas_receber VALUES("20712","3","2072","1","1","74.4","0","74.4","2019-05-29","2019-05-30","","1","1");
INSERT INTO contas_receber VALUES("20719","220","2055","1","1","4477.87","0","4477.87","2019-05-30","2019-07-01","","1","1");
INSERT INTO contas_receber VALUES("20720","220","2055","2","1","4477.87","0","4477.87","2019-05-30","2019-07-16","","1","1");
INSERT INTO contas_receber VALUES("20721","220","2055","3","1","4477.86","0","4477.86","2019-05-30","2019-08-01","","1","1");
INSERT INTO contas_receber VALUES("20746","31","2075","1","1","568.2","0","568.2","2019-05-31","2019-06-30","","1","1");
INSERT INTO contas_receber VALUES("20747","31","2075","2","1","568.2","0","568.2","2019-05-31","2019-07-15","","1","1");
INSERT INTO contas_receber VALUES("20748","31","2075","3","1","568.2","0","568.2","2019-05-31","2019-07-30","","1","1");
INSERT INTO contas_receber VALUES("20749","455","2066","1","1","1069.97","0","1069.97","2019-05-31","2019-07-02","","1","1");
INSERT INTO contas_receber VALUES("20750","455","2066","2","1","1069.97","0","1069.97","2019-05-31","2019-07-17","","1","1");
INSERT INTO contas_receber VALUES("20751","455","2066","3","1","1069.96","0","1069.96","2019-05-31","2019-08-02","","1","1");
INSERT INTO contas_receber VALUES("20760","4","2062","1","1","1171.17","0","1171.17","2019-06-03","2019-07-01","","1","1");
INSERT INTO contas_receber VALUES("20761","4","2062","3","1","1171.16","0","1171.16","2019-06-03","2019-08-01","","1","1");
INSERT INTO contas_receber VALUES("20762","4","2062","2","1","1171.17","0","1171.17","2019-06-03","2019-07-16","","1","1");
INSERT INTO contas_receber VALUES("20763","19","2064","3","1","294.13","0","294.13","2019-06-03","2019-08-01","","1","1");
INSERT INTO contas_receber VALUES("20764","19","2064","1","1","294.12","0","294.12","2019-06-03","2019-07-01","","1","1");
INSERT INTO contas_receber VALUES("20765","19","2064","2","1","294.12","0","294.12","2019-06-03","2019-07-16","","1","1");
INSERT INTO contas_receber VALUES("20767","457","2078","1","1","92.45","92.45","0","2019-06-03","2019-06-04","","0","0");
INSERT INTO contas_receber VALUES("20781","457","2080","1","1","707.28","707.28","0","2019-06-03","2019-06-06","","0","0");
INSERT INTO contas_receber VALUES("20782","457","2080","2","1","707.28","707.28","0","2019-06-03","2019-07-07","","0","0");
INSERT INTO contas_receber VALUES("20783","457","2080","3","1","707.29","707.29","0","2019-06-03","2019-08-07","","0","0");
INSERT INTO contas_receber VALUES("20792","83","2083","1","1","737","737","0","2019-06-03","2019-06-04","","0","0");
INSERT INTO contas_receber VALUES("20793","83","2083","2","1","737","737","0","2019-06-03","2019-07-05","","0","0");
INSERT INTO contas_receber VALUES("20794","83","2083","3","1","737","737","0","2019-06-03","2019-08-05","","0","0");
INSERT INTO contas_receber VALUES("20795","83","2083","4","1","737","737","0","2019-06-03","2019-09-05","","0","0");
INSERT INTO contas_receber VALUES("20813","31","2076","1","1","481.5","0","481.5","2019-06-03","2019-07-05","","1","1");
INSERT INTO contas_receber VALUES("20814","31","2076","3","1","481.5","0","481.5","2019-06-03","2019-08-05","","1","1");
INSERT INTO contas_receber VALUES("20815","31","2076","2","1","481.5","0","481.5","2019-06-03","2019-07-20","","1","1");
INSERT INTO contas_receber VALUES("20816","354","2067","1","1","495.4","0","495.4","2019-06-04","2019-07-04","","1","1");
INSERT INTO contas_receber VALUES("20817","354","2067","4","1","73.3","0","73.3","2019-06-04","2019-07-25","","1","1");
INSERT INTO contas_receber VALUES("20818","354","2067","3","1","495.4","0","495.4","2019-06-04","2019-08-04","","1","1");
INSERT INTO contas_receber VALUES("20819","354","2067","2","1","495.4","0","495.4","2019-06-04","2019-07-19","","1","1");
INSERT INTO contas_receber VALUES("20820","153","2070","1","1","556.8","0","556.8","2019-06-04","2019-07-14","","1","1");
INSERT INTO contas_receber VALUES("20833","175","2063","1","1","139.72","0","139.72","2019-06-04","2019-05-29","","1","1");
INSERT INTO contas_receber VALUES("20873","36","2071","3","1","627.6","0","627.6","2019-06-05","2019-08-05","","1","1");
INSERT INTO contas_receber VALUES("20874","36","2071","1","1","627.6","0","627.6","2019-06-05","2019-07-05","","1","1");
INSERT INTO contas_receber VALUES("20875","36","2071","2","1","627.6","0","627.6","2019-06-05","2019-07-20","","1","1");
INSERT INTO contas_receber VALUES("20876","297","2073","1","1","1118.1","0","1118.1","2019-06-05","2019-07-07","","1","1");
INSERT INTO contas_receber VALUES("20877","297","2073","3","1","1118.1","0","1118.1","2019-06-05","2019-08-07","","1","1");
INSERT INTO contas_receber VALUES("20878","297","2073","2","1","1118.1","0","1118.1","2019-06-05","2019-07-22","","1","1");
INSERT INTO contas_receber VALUES("20879","322","2074","2","1","580.1","0","580.1","2019-06-05","2019-07-21","","1","1");
INSERT INTO contas_receber VALUES("20880","322","2074","1","1","580.1","0","580.1","2019-06-05","2019-07-06","","1","1");
INSERT INTO contas_receber VALUES("20881","322","2074","3","1","580.1","0","580.1","2019-06-05","2019-08-06","","1","1");
INSERT INTO contas_receber VALUES("20882","479","2077","1","1","419.1","0","419.1","2019-06-05","2019-06-17","","1","1");
INSERT INTO contas_receber VALUES("20883","31","2086","1","1","226.57","0","226.57","2019-06-05","2019-07-05","","1","1");
INSERT INTO contas_receber VALUES("20884","31","2086","2","1","226.57","0","226.57","2019-06-05","2019-07-20","","1","1");
INSERT INTO contas_receber VALUES("20885","31","2086","3","1","226.56","0","226.56","2019-06-05","2019-08-05","","1","1");
INSERT INTO contas_receber VALUES("20894","212","2095","1","1","638.58","638.58","0","2019-06-06","2019-06-08","","0","1");
INSERT INTO contas_receber VALUES("20895","212","2095","2","1","638.58","638.58","0","2019-06-06","2019-07-09","","0","1");
INSERT INTO contas_receber VALUES("20896","212","2095","3","1","638.57","638.57","0","2019-06-06","2019-08-09","","0","1");
INSERT INTO contas_receber VALUES("20904","482","2097","1","1","23.04","23.04","0","2019-06-06","2019-06-07","","0","0");
INSERT INTO contas_receber VALUES("20905","457","2079","1","1","511.03","0","511.03","2019-06-06","2019-07-07","","1","1");
INSERT INTO contas_receber VALUES("20906","457","2079","3","1","511.04","0","511.04","2019-06-06","2019-08-07","","1","1");
INSERT INTO contas_receber VALUES("20907","457","2079","2","1","511.03","0","511.03","2019-06-06","2019-07-22","","1","1");
INSERT INTO contas_receber VALUES("20908","46","2088","1","1","268.72","0","268.72","2019-06-06","2019-07-06","","1","1");
INSERT INTO contas_receber VALUES("20909","480","2084","1","1","173.69","0","173.69","2019-06-06","2019-07-07","","1","1");
INSERT INTO contas_receber VALUES("20910","480","2084","2","1","173.69","0","173.69","2019-06-06","2019-08-07","","1","1");
INSERT INTO contas_receber VALUES("20911","101","2089","1","1","676.4","0","676.4","2019-06-06","2019-07-10","","1","1");
INSERT INTO contas_receber VALUES("20912","101","2089","2","1","676.4","0","676.4","2019-06-06","2019-07-25","","1","1");
INSERT INTO contas_receber VALUES("20913","101","2089","3","1","676.4","0","676.4","2019-06-06","2019-08-10","","1","1");
INSERT INTO contas_receber VALUES("20914","113","2093","1","1","841.35","0","841.35","2019-06-06","2019-06-17","","1","1");
INSERT INTO contas_receber VALUES("20915","113","2093","2","1","841.35","0","841.35","2019-06-06","2019-07-25","","1","1");
INSERT INTO contas_receber VALUES("20916","481","2091","1","1","395.93","0","395.93","2019-06-06","2019-07-10","","1","1");
INSERT INTO contas_receber VALUES("20917","481","2091","3","1","395.94","0","395.94","2019-06-06","2019-08-10","","1","1");
INSERT INTO contas_receber VALUES("20918","481","2091","2","1","395.93","0","395.93","2019-06-06","2019-07-25","","1","1");
INSERT INTO contas_receber VALUES("20933","353","2090","1","1","192.6","0","192.6","2019-06-06","2019-06-06","","1","1");
INSERT INTO contas_receber VALUES("20940","354","2094","2","1","536.3","0","536.3","2019-06-07","2019-07-25","","1","1");
INSERT INTO contas_receber VALUES("20941","354","2094","1","1","536.3","0","536.3","2019-06-07","2019-07-10","","1","1");
INSERT INTO contas_receber VALUES("20942","354","2094","3","1","536.3","0","536.3","2019-06-07","2019-08-10","","1","1");
INSERT INTO contas_receber VALUES("20946","198","2100","1","1","779.85","779.85","0","2019-06-07","2019-06-08","","0","0");
INSERT INTO contas_receber VALUES("20947","198","2100","2","1","779.85","779.85","0","2019-06-07","2019-07-09","","0","0");
INSERT INTO contas_receber VALUES("20948","198","2100","3","1","779.85","779.85","0","2019-06-07","2019-08-09","","0","0");
INSERT INTO contas_receber VALUES("20951","329","2099","3","1","331.86","0","331.86","2019-06-10","2019-08-11","","1","1");
INSERT INTO contas_receber VALUES("20952","329","2099","2","1","331.87","0","331.87","2019-06-10","2019-07-26","","1","1");
INSERT INTO contas_receber VALUES("20953","329","2099","1","1","331.87","0","331.87","2019-06-10","2019-07-11","","1","1");
INSERT INTO contas_receber VALUES("20954","212","2096","1","1","638.58","0","638.58","2019-06-10","2019-07-11","","1","1");
INSERT INTO contas_receber VALUES("20955","212","2096","2","1","638.58","0","638.58","2019-06-10","2019-07-26","","1","1");
INSERT INTO contas_receber VALUES("20956","212","2096","3","1","638.57","0","638.57","2019-06-10","2019-08-11","","1","1");
INSERT INTO contas_receber VALUES("20957","33","2098","1","1","694.4","0","694.4","2019-06-10","2019-06-21","","1","1");
INSERT INTO contas_receber VALUES("20958","33","2098","2","1","694.4","0","694.4","2019-06-10","2019-06-21","","1","1");
INSERT INTO contas_receber VALUES("20959","94","2087","1","1","205.06","0","205.06","2019-06-10","2019-07-10","","1","1");
INSERT INTO contas_receber VALUES("20960","94","2087","2","1","205.06","0","205.06","2019-06-10","2019-08-10","","1","1");
INSERT INTO contas_receber VALUES("20976","243","2102","1","1","708.3","708.3","0","2019-06-10","2019-06-13","","0","0");
INSERT INTO contas_receber VALUES("20977","243","2102","2","1","708.3","708.3","0","2019-06-10","2019-07-14","","0","0");
INSERT INTO contas_receber VALUES("20978","243","2102","3","1","708.3","708.3","0","2019-06-10","2019-08-14","","0","0");
INSERT INTO contas_receber VALUES("21009","3","2107","1","1","110.92","0","110.92","2019-06-11","2019-06-12","","1","1");
INSERT INTO contas_receber VALUES("21010","32","2108","1","1","68.8","0","68.8","2019-06-11","2019-06-12","","1","1");
INSERT INTO contas_receber VALUES("21015","69","2104","1","1","607.3","0","607.3","2019-06-12","2019-06-24","","1","1");
INSERT INTO contas_receber VALUES("21016","69","2104","2","1","607.31","0","607.31","2019-06-12","2019-06-24","","1","1");
INSERT INTO contas_receber VALUES("21025","23","2105","1","1","395","0","395","2019-06-12","2019-07-12","","1","1");
INSERT INTO contas_receber VALUES("21026","23","2105","4","1","395","0","395","2019-06-12","2019-08-27","","1","1");
INSERT INTO contas_receber VALUES("21027","23","2105","3","1","395","0","395","2019-06-12","2019-08-12","","1","1");
INSERT INTO contas_receber VALUES("21028","23","2105","2","1","395","0","395","2019-06-12","2019-07-27","","1","1");
INSERT INTO contas_receber VALUES("21029","4","2106","2","1","1239.67","0","1239.67","2019-06-12","2019-07-28","","1","1");
INSERT INTO contas_receber VALUES("21030","4","2106","3","1","1239.66","0","1239.66","2019-06-12","2019-08-13","","1","1");
INSERT INTO contas_receber VALUES("21031","4","2106","1","1","1239.67","0","1239.67","2019-06-12","2019-07-13","","1","1");
INSERT INTO contas_receber VALUES("21032","13","2085","1","1","381.7","381.7","0","2019-06-12","2019-06-06","","0","0");
INSERT INTO contas_receber VALUES("21035","35","2059","1","1","99.2","0","99.2","2019-06-12","2019-05-26","","1","1");
INSERT INTO contas_receber VALUES("21046","8","2092","1","1","102.15","0","102.15","2019-06-13","2019-06-07","","1","1");
INSERT INTO contas_receber VALUES("21047","483","2109","1","1","171.5","0","171.5","2019-06-13","2019-06-13","","1","1");
INSERT INTO contas_receber VALUES("21062","102","197","1","1","26","26","0","2019-06-13","2017-02-09","","0","1");
INSERT INTO contas_receber VALUES("21063","172","2110","1","1","82.9","0","82.9","2019-06-13","2019-07-14","","1","1");
INSERT INTO contas_receber VALUES("21067","31","2111","1","1","570.47","0","570.47","2019-06-13","2019-07-13","","1","1");
INSERT INTO contas_receber VALUES("21068","31","2111","2","1","570.47","0","570.47","2019-06-13","2019-07-28","","1","1");
INSERT INTO contas_receber VALUES("21069","31","2111","3","1","570.46","0","570.46","2019-06-13","2019-08-13","","1","1");
INSERT INTO contas_receber VALUES("21087","220","2101","1","1","33.25","0","33.25","2019-06-14","2019-06-09","","1","1");
INSERT INTO contas_receber VALUES("21088","220","2117","1","1","299.95","0","299.95","2019-06-14","2019-07-14","","1","1");
INSERT INTO contas_receber VALUES("21089","220","2117","2","1","299.95","0","299.95","2019-06-14","2019-07-29","","1","1");
INSERT INTO contas_receber VALUES("21090","220","2117","3","1","299.95","0","299.95","2019-06-14","2019-08-14","","1","1");
INSERT INTO contas_receber VALUES("21091","125","2114","2","1","690.42","0","690.42","2019-06-14","2019-07-29","","1","1");
INSERT INTO contas_receber VALUES("21092","125","2114","1","1","690.42","0","690.42","2019-06-14","2019-07-14","","1","1");
INSERT INTO contas_receber VALUES("21093","125","2114","3","1","690.41","0","690.41","2019-06-14","2019-08-14","","1","1");
INSERT INTO contas_receber VALUES("21094","133","2115","1","1","243.85","0","243.85","2019-06-14","2019-07-14","","1","1");
INSERT INTO contas_receber VALUES("21095","47","2116","2","1","648.5","0","648.5","2019-06-14","2019-07-29","","1","1");
INSERT INTO contas_receber VALUES("21096","47","2116","1","1","648.5","0","648.5","2019-06-14","2019-07-14","","1","1");
INSERT INTO contas_receber VALUES("21097","47","2116","3","1","648.51","0","648.51","2019-06-14","2019-08-14","","1","1");
INSERT INTO contas_receber VALUES("21098","193","2113","1","1","73.68","0","73.68","2019-06-14","2019-06-14","","1","1");
INSERT INTO contas_receber VALUES("21102","22","2118","3","1","792.99","0","792.99","2019-06-14","2019-08-14","","1","1");
INSERT INTO contas_receber VALUES("21103","22","2118","1","1","792.98","0","792.98","2019-06-14","2019-07-14","","1","1");
INSERT INTO contas_receber VALUES("21104","22","2118","2","1","792.98","0","792.98","2019-06-14","2019-07-29","","1","1");
INSERT INTO contas_receber VALUES("21105","28","2081","1","1","88.62","0","88.62","2019-06-14","2019-06-05","","1","1");
INSERT INTO contas_receber VALUES("21106","32","2082","1","1","216.33","0","216.33","2019-06-14","2019-06-05","","1","1");
INSERT INTO contas_receber VALUES("21109","35","2112","2","1","142.06","0","142.06","2019-06-14","2019-07-14","","1","1");
INSERT INTO contas_receber VALUES("21110","35","2112","1","1","100","0","100","2019-06-14","2019-06-14","","1","1");
INSERT INTO contas_receber VALUES("21111","243","2103","1","1","708.3","0","708.3","2019-06-14","2019-07-12","","1","1");
INSERT INTO contas_receber VALUES("21112","243","2103","3","1","708.3","0","708.3","2019-06-14","2019-08-12","","1","1");
INSERT INTO contas_receber VALUES("21113","243","2103","2","1","708.3","0","708.3","2019-06-14","2019-07-27","","1","1");
INSERT INTO contas_receber VALUES("21114","96","2119","1","1","73.38","0","73.38","2019-06-14","2019-06-16","","1","1");
INSERT INTO contas_receber VALUES("21115","185","2120","1","1","68.75","0","68.75","2019-06-14","2019-06-16","","1","1");
INSERT INTO contas_receber VALUES("21116","159","2033","1","1","265.92","0","265.92","2019-06-14","2019-05-17","","1","1");
INSERT INTO contas_receber VALUES("21117","44","2043","1","1","517.08","0","517.08","2019-06-14","2019-06-24","","1","1");
INSERT INTO contas_receber VALUES("21118","44","2043","2","1","517.08","0","517.08","2019-06-14","2019-07-10","","1","1");
INSERT INTO contas_receber VALUES("21119","44","2043","3","1","517.09","0","517.09","2019-06-14","2019-07-24","","1","1");
INSERT INTO contas_receber VALUES("21159","62","2125","1","1","241.01","241.01","0","2019-06-18","2019-06-19","","0","0");
INSERT INTO contas_receber VALUES("21160","62","2125","2","1","241.01","241.01","0","2019-06-18","2019-07-20","","0","0");
INSERT INTO contas_receber VALUES("21161","62","2125","3","1","241.02","241.02","0","2019-06-18","2019-08-20","","0","0");
INSERT INTO contas_receber VALUES("21162","49","2124","1","1","402.07","0","402.07","2019-06-18","2019-07-18","","1","1");
INSERT INTO contas_receber VALUES("21163","49","2124","2","1","402.07","0","402.07","2019-06-18","2019-08-02","","1","1");
INSERT INTO contas_receber VALUES("21164","49","2124","3","1","402.06","0","402.06","2019-06-18","2019-08-18","","1","1");
INSERT INTO contas_receber VALUES("21167","31","2121","1","1","253.5","0","253.5","2019-06-18","2019-07-17","","1","1");
INSERT INTO contas_receber VALUES("21168","31","2121","2","1","253.5","0","253.5","2019-06-18","2019-08-17","","1","1");
INSERT INTO contas_receber VALUES("21169","380","2122","1","1","852.63","0","852.63","2019-06-18","2019-07-17","","1","1");
INSERT INTO contas_receber VALUES("21170","380","2122","2","1","852.63","0","852.63","2019-06-18","2019-08-01","","1","1");
INSERT INTO contas_receber VALUES("21171","380","2122","3","1","852.64","0","852.64","2019-06-18","2019-08-17","","1","1");
INSERT INTO contas_receber VALUES("21202","71","2127","1","1","554.17","0","554.17","2019-06-18","2019-07-19","","1","1");
INSERT INTO contas_receber VALUES("21203","71","2127","2","1","554.17","0","554.17","2019-06-18","2019-08-03","","1","1");
INSERT INTO contas_receber VALUES("21204","71","2127","3","1","554.16","0","554.16","2019-06-18","2019-08-19","","1","1");
INSERT INTO contas_receber VALUES("21205","98","2128","1","1","725.67","0","725.67","2019-06-19","2019-07-19","","1","1");
INSERT INTO contas_receber VALUES("21206","98","2128","3","1","725.66","0","725.66","2019-06-19","2019-08-19","","1","1");
INSERT INTO contas_receber VALUES("21207","98","2128","2","1","725.67","0","725.67","2019-06-19","2019-08-03","","1","1");
INSERT INTO contas_receber VALUES("21214","316","2123","1","1","581.1","581.1","0","2019-06-19","2019-06-19","","0","1");
INSERT INTO contas_receber VALUES("21215","316","2123","2","1","581.1","581.1","0","2019-06-19","2019-07-20","","0","1");
INSERT INTO contas_receber VALUES("21216","316","2123","3","1","581.1","581.1","0","2019-06-19","2019-08-20","","0","1");
INSERT INTO contas_receber VALUES("21225","59","2131","1","1","555.67","555.67","0","2019-06-19","2019-06-21","","0","1");
INSERT INTO contas_receber VALUES("21226","59","2131","2","1","555.67","555.67","0","2019-06-19","2019-07-22","","0","1");
INSERT INTO contas_receber VALUES("21227","59","2131","3","1","555.66","555.66","0","2019-06-19","2019-08-22","","0","1");
INSERT INTO contas_receber VALUES("21234","31","2129","3","1","322.66","0","322.66","2019-06-19","2019-08-19","","1","1");
INSERT INTO contas_receber VALUES("21235","31","2129","2","1","322.67","0","322.67","2019-06-19","2019-08-03","","1","1");
INSERT INTO contas_receber VALUES("21236","31","2129","1","1","322.67","0","322.67","2019-06-19","2019-07-19","","1","1");
INSERT INTO contas_receber VALUES("21245","264","2133","1","1","236.4","0","236.4","2019-06-19","2019-06-21","","1","1");
INSERT INTO contas_receber VALUES("21246","316","2130","1","1","581.1","0","581.1","2019-06-19","2019-07-23","","1","1");
INSERT INTO contas_receber VALUES("21247","316","2130","3","1","581.1","0","581.1","2019-06-19","2019-08-13","","1","1");
INSERT INTO contas_receber VALUES("21248","316","2130","2","1","581.1","0","581.1","2019-06-19","2019-08-06","","1","1");
INSERT INTO contas_receber VALUES("21251","59","2132","3","1","521.06","0","521.06","2019-06-21","2019-08-24","","1","1");
INSERT INTO contas_receber VALUES("21252","59","2132","1","1","521.07","0","521.07","2019-06-21","2019-07-24","","1","1");
INSERT INTO contas_receber VALUES("21253","59","2132","2","1","521.07","0","521.07","2019-06-21","2019-08-08","","1","1");
INSERT INTO contas_receber VALUES("21258","418","2135","1","1","221","0","221","2019-06-21","2019-07-19","","1","1");
INSERT INTO contas_receber VALUES("21259","418","2135","2","1","221","0","221","2019-06-21","2019-08-05","","1","1");
INSERT INTO contas_receber VALUES("21266","179","2136","1","1","292.9","0","292.9","2019-06-21","2019-07-21","","1","1");
INSERT INTO contas_receber VALUES("21267","179","2136","2","1","292.9","0","292.9","2019-06-21","2019-08-05","","1","1");
INSERT INTO contas_receber VALUES("21268","179","2136","3","1","292.9","0","292.9","2019-06-21","2019-08-21","","1","1");
INSERT INTO contas_receber VALUES("21269","3","2126","1","1","80.67","0","80.67","2019-06-21","2019-06-20","","1","1");
INSERT INTO contas_receber VALUES("21305","455","2139","2","1","487.82","0","487.82","2019-06-24","2019-08-09","","1","1");
INSERT INTO contas_receber VALUES("21306","455","2139","3","1","487.82","0","487.82","2019-06-24","2019-08-25","","1","1");
INSERT INTO contas_receber VALUES("21307","455","2139","1","1","487.82","0","487.82","2019-06-24","2019-07-25","","1","1");
INSERT INTO contas_receber VALUES("21308","179","2142","2","1","308.23","0","308.23","2019-06-24","2019-08-08","","1","1");
INSERT INTO contas_receber VALUES("21309","179","2142","1","1","308.23","0","308.23","2019-06-24","2019-07-24","","1","1");
INSERT INTO contas_receber VALUES("21310","179","2142","3","1","308.24","0","308.24","2019-06-24","2019-08-24","","1","1");
INSERT INTO contas_receber VALUES("21311","190","2134","1","1","77.32","0","77.32","2019-06-24","2019-06-23","","1","1");
INSERT INTO contas_receber VALUES("21312","484","2137","1","1","68.8","0","68.8","2019-06-24","2019-06-23","","1","1");
INSERT INTO contas_receber VALUES("21313","3","2138","1","1","29.3","0","29.3","2019-06-24","2019-06-26","","1","1");
INSERT INTO contas_receber VALUES("21350","68","2140","1","1","930.9","0","930.9","2019-06-25","2019-07-08","","1","1");
INSERT INTO contas_receber VALUES("21351","68","2140","2","1","930.9","0","930.9","2019-06-25","2019-07-08","","1","1");
INSERT INTO contas_receber VALUES("21374","5","2144","2","1","308.41","0","308.41","2019-06-26","2019-08-10","","1","1");
INSERT INTO contas_receber VALUES("21375","5","2144","1","1","308.41","0","308.41","2019-06-26","2019-07-26","","1","1");
INSERT INTO contas_receber VALUES("21376","5","2144","3","1","308.41","0","308.41","2019-06-26","2019-08-26","","1","1");
INSERT INTO contas_receber VALUES("21377","5","2144","4","1","308.41","0","308.41","2019-06-26","2019-09-10","","1","1");
INSERT INTO contas_receber VALUES("21392","30","2143","1","1","895.38","0","895.38","2019-06-26","2019-07-28","","1","1");
INSERT INTO contas_receber VALUES("21393","30","2143","5","1","895.38","0","895.38","2019-06-26","2019-09-11","","1","1");
INSERT INTO contas_receber VALUES("21394","30","2143","4","1","895.38","0","895.38","2019-06-26","2019-08-27","","1","1");
INSERT INTO contas_receber VALUES("21395","30","2143","3","1","895.38","0","895.38","2019-06-26","2019-08-17","","1","1");
INSERT INTO contas_receber VALUES("21396","30","2143","2","1","895.38","0","895.38","2019-06-26","2019-08-07","","1","1");
INSERT INTO contas_receber VALUES("21397","31","2149","1","1","236.6","0","236.6","2019-06-26","2019-07-26","","1","1");
INSERT INTO contas_receber VALUES("21398","31","2149","2","1","236.6","0","236.6","2019-06-26","2019-08-10","","1","1");
INSERT INTO contas_receber VALUES("21399","31","2149","3","1","236.6","0","236.6","2019-06-26","2019-08-26","","1","1");
INSERT INTO contas_receber VALUES("21400","60","2141","1","1","836.87","0","836.87","2019-06-26","2019-07-25","","1","1");
INSERT INTO contas_receber VALUES("21401","60","2141","3","1","836.86","0","836.86","2019-06-26","2019-08-25","","1","1");
INSERT INTO contas_receber VALUES("21402","60","2141","2","1","836.87","0","836.87","2019-06-26","2019-08-09","","1","1");
INSERT INTO contas_receber VALUES("21456","220","2145","1","1","14025.5","0","14025.5","2019-06-28","2019-06-28","","1","1");
INSERT INTO contas_receber VALUES("21487","487","2160","1","1","9003","9003","0","2019-07-01","2019-07-03","","0","0");
INSERT INTO contas_receber VALUES("21488","4","2146","3","1","1266.66","0","1266.66","2019-07-01","2019-09-02","","1","1");
INSERT INTO contas_receber VALUES("21489","4","2146","1","1","1266.67","0","1266.67","2019-07-01","2019-08-02","","1","1");
INSERT INTO contas_receber VALUES("21490","4","2146","2","1","1266.67","0","1266.67","2019-07-01","2019-08-17","","1","1");
INSERT INTO contas_receber VALUES("21491","413","2148","1","1","1186.93","0","1186.93","2019-07-01","2019-08-01","","1","1");
INSERT INTO contas_receber VALUES("21492","413","2148","2","1","1186.93","0","1186.93","2019-07-01","2019-08-16","","1","1");
INSERT INTO contas_receber VALUES("21493","413","2148","3","1","1186.94","0","1186.94","2019-07-01","2019-09-01","","1","1");
INSERT INTO contas_receber VALUES("21500","112","2150","1","1","74.84","0","74.84","2019-07-01","2019-06-28","","1","1");
INSERT INTO contas_receber VALUES("21503","485","2151","1","1","1288.8","0","1288.8","2019-07-02","2019-07-02","","1","1");
INSERT INTO contas_receber VALUES("21504","84","2147","1","1","649.12","0","649.12","2019-07-02","2019-08-02","","1","1");
INSERT INTO contas_receber VALUES("21505","84","2147","2","1","649.12","0","649.12","2019-07-02","2019-08-17","","1","1");
INSERT INTO contas_receber VALUES("21506","84","2147","3","1","649.11","0","649.11","2019-07-02","2019-09-02","","1","1");
INSERT INTO contas_receber VALUES("21528","31","2161","1","1","405.6","0","405.6","2019-07-02","2019-08-03","","1","1");
INSERT INTO contas_receber VALUES("21529","31","2161","3","1","405.6","0","405.6","2019-07-02","2019-09-03","","1","1");
INSERT INTO contas_receber VALUES("21530","31","2161","2","1","405.6","0","405.6","2019-07-02","2019-08-18","","1","1");
INSERT INTO contas_receber VALUES("21539","296","2153","2","1","336.9","0","336.9","2019-07-03","2019-09-03","","1","1");
INSERT INTO contas_receber VALUES("21540","296","2153","1","1","336.9","0","336.9","2019-07-03","2019-08-03","","1","1");
INSERT INTO contas_receber VALUES("21541","70","2154","2","1","677.19","0","677.19","2019-07-03","2019-07-15","","1","1");
INSERT INTO contas_receber VALUES("21542","70","2154","1","1","677.19","0","677.19","2019-07-03","2019-07-15","","1","1");
INSERT INTO contas_receber VALUES("21543","195","2155","2","1","206.48","0","206.48","2019-07-03","2019-09-02","","1","1");
INSERT INTO contas_receber VALUES("21544","195","2155","1","1","206.47","0","206.47","2019-07-03","2019-08-02","","1","1");
INSERT INTO contas_receber VALUES("21549","323","2152","1","1","627.77","0","627.77","2019-07-03","2019-08-07","","1","1");
INSERT INTO contas_receber VALUES("21550","323","2152","2","1","627.77","0","627.77","2019-07-03","2019-08-13","","1","1");
INSERT INTO contas_receber VALUES("21551","323","2152","3","1","627.76","0","627.76","2019-07-03","2019-08-21","","1","1");
INSERT INTO contas_receber VALUES("21552","44","2156","2","1","953.08","0","953.08","2019-07-03","2019-08-18","","1","1");
INSERT INTO contas_receber VALUES("21553","44","2156","3","1","953.07","0","953.07","2019-07-03","2019-09-03","","1","1");
INSERT INTO contas_receber VALUES("21554","44","2156","1","1","953.08","0","953.08","2019-07-03","2019-08-03","","1","1");
INSERT INTO contas_receber VALUES("21555","264","2164","1","1","315.2","0","315.2","2019-07-03","2019-07-04","","1","1");
INSERT INTO contas_receber VALUES("21562","3","2171","1","1","314.1","0","314.1","2019-07-03","2019-07-05","","1","1");
INSERT INTO contas_receber VALUES("21567","4","2157","1","1","1274.67","0","1274.67","2019-07-04","2019-08-04","","1","1");
INSERT INTO contas_receber VALUES("21568","4","2157","2","1","1274.67","0","1274.67","2019-07-04","2019-08-19","","1","1");
INSERT INTO contas_receber VALUES("21569","4","2157","3","1","1274.66","0","1274.66","2019-07-04","2019-09-04","","1","1");
INSERT INTO contas_receber VALUES("21572","486","2159","1","1","27.52","0","27.52","2019-07-04","2019-06-30","","1","1");
INSERT INTO contas_receber VALUES("21593","33","2165","2","1","615.35","0","615.35","2019-07-04","2019-07-16","","1","1");
INSERT INTO contas_receber VALUES("21594","33","2165","1","1","615.35","0","615.35","2019-07-04","2019-07-16","","1","1");
INSERT INTO contas_receber VALUES("21595","203","2163","1","1","1260.45","0","1260.45","2019-07-04","2019-07-15","","1","1");
INSERT INTO contas_receber VALUES("21596","203","2163","2","1","1260.45","0","1260.45","2019-07-04","2019-07-15","","1","1");
INSERT INTO contas_receber VALUES("21599","324","2174","1","1","1139.17","1139.17","0","2019-07-04","2019-07-06","","0","1");
INSERT INTO contas_receber VALUES("21600","324","2174","2","1","1139.17","1139.17","0","2019-07-04","2019-08-06","","0","1");
INSERT INTO contas_receber VALUES("21601","324","2174","3","1","1139.16","1139.16","0","2019-07-04","2019-09-06","","0","1");
INSERT INTO contas_receber VALUES("21608","199","2158","1","1","781.18","0","781.18","2019-07-05","2019-08-15","","1","1");
INSERT INTO contas_receber VALUES("21609","199","2158","3","1","781.19","0","781.19","2019-07-05","2019-10-15","","1","1");
INSERT INTO contas_receber VALUES("21610","199","2158","2","1","781.18","0","781.18","2019-07-05","2019-09-15","","1","1");
INSERT INTO contas_receber VALUES("21627","449","2162","1","1","149.59","0","149.59","2019-07-08","2019-07-03","","1","1");
INSERT INTO contas_receber VALUES("21634","263","2168","1","1","951.52","0","951.52","2019-07-08","2019-07-17","","1","1");
INSERT INTO contas_receber VALUES("21635","263","2168","2","1","951.52","0","951.52","2019-07-08","2019-07-17","","1","1");
INSERT INTO contas_receber VALUES("21636","263","2168","3","1","162.06","0","162.06","2019-07-08","2019-07-17","","1","1");
INSERT INTO contas_receber VALUES("21637","32","2169","1","1","287.62","0","287.62","2019-07-08","2019-07-05","","1","1");
INSERT INTO contas_receber VALUES("21638","180","2173","3","1","401.8","0","401.8","2019-07-08","2019-09-08","","1","1");
INSERT INTO contas_receber VALUES("21639","180","2173","1","1","401.8","0","401.8","2019-07-08","2019-08-08","","1","1");
INSERT INTO contas_receber VALUES("21640","180","2173","2","1","401.8","0","401.8","2019-07-08","2019-08-23","","1","1");
INSERT INTO contas_receber VALUES("21641","324","2175","3","1","1139.16","0","1139.16","2019-07-08","2019-09-09","","1","1");
INSERT INTO contas_receber VALUES("21642","324","2175","1","1","1139.17","0","1139.17","2019-07-08","2019-08-09","","1","1");
INSERT INTO contas_receber VALUES("21643","324","2175","2","1","1139.17","0","1139.17","2019-07-08","2019-08-24","","1","1");
INSERT INTO contas_receber VALUES("21652","490","2179","1","1","92.1","0","92.1","2019-07-08","2019-07-10","","1","1");
INSERT INTO contas_receber VALUES("21695","292","2183","1","1","2954.5","2954.5","0","2019-07-08","2019-07-10","","0","0");
INSERT INTO contas_receber VALUES("21696","292","2183","4","1","2954.5","2954.5","0","2019-07-08","2019-10-11","","0","0");
INSERT INTO contas_receber VALUES("21697","292","2183","3","1","2954.5","2954.5","0","2019-07-08","2019-09-10","","0","0");
INSERT INTO contas_receber VALUES("21698","292","2183","2","1","2954.5","2954.5","0","2019-07-08","2019-08-10","","0","0");
INSERT INTO contas_receber VALUES("21712","489","2167","1","1","101.35","0","101.35","2019-07-09","2019-07-04","","1","1");
INSERT INTO contas_receber VALUES("21713","345","2178","3","1","440.56","0","440.56","2019-07-09","2019-09-09","","1","1");
INSERT INTO contas_receber VALUES("21714","345","2178","1","1","440.57","0","440.57","2019-07-09","2019-08-09","","1","1");
INSERT INTO contas_receber VALUES("21715","345","2178","2","1","440.57","0","440.57","2019-07-09","2019-08-24","","1","1");
INSERT INTO contas_receber VALUES("21716","344","2177","1","1","684.27","0","684.27","2019-07-09","2019-08-10","","1","1");
INSERT INTO contas_receber VALUES("21717","344","2177","2","1","684.27","0","684.27","2019-07-09","2019-08-25","","1","1");
INSERT INTO contas_receber VALUES("21718","344","2177","3","1","684.26","0","684.26","2019-07-09","2019-09-10","","1","1");
INSERT INTO contas_receber VALUES("21727","28","2185","1","1","264.09","0","264.09","2019-07-10","2019-08-12","","1","1");
INSERT INTO contas_receber VALUES("21756","292","2182","1","1","2378.75","0","2378.75","2019-07-11","2019-08-09","","1","1");
INSERT INTO contas_receber VALUES("21757","292","2182","2","1","2378.75","0","2378.75","2019-07-11","2019-08-23","","1","1");
INSERT INTO contas_receber VALUES("21758","292","2182","4","1","2378.75","0","2378.75","2019-07-11","2019-09-22","","1","1");
INSERT INTO contas_receber VALUES("21759","292","2182","3","1","2378.75","0","2378.75","2019-07-11","2019-09-06","","1","1");
INSERT INTO contas_receber VALUES("21760","488","2166","1","1","109.12","0","109.12","2019-07-11","2019-07-05","","1","1");
INSERT INTO contas_receber VALUES("21761","399","2170","1","1","82.2","0","82.2","2019-07-11","2019-07-05","","1","1");
INSERT INTO contas_receber VALUES("21762","486","2172","1","1","13.76","0","13.76","2019-07-11","2019-07-06","","1","1");
INSERT INTO contas_receber VALUES("21763","491","2181","2","1","607.8","0","607.8","2019-07-11","2019-08-25","","1","1");
INSERT INTO contas_receber VALUES("21764","491","2181","1","1","607.8","0","607.8","2019-07-11","2019-08-10","","1","1");
INSERT INTO contas_receber VALUES("21765","491","2181","3","1","607.8","0","607.8","2019-07-11","2019-09-10","","1","1");
INSERT INTO contas_receber VALUES("21784","439","2184","1","1","98.79","0","98.79","2019-07-11","2019-07-12","","1","1");
INSERT INTO contas_receber VALUES("21788","380","2186","1","1","837.28","837.28","0","2019-07-12","2019-08-12","","0","1");
INSERT INTO contas_receber VALUES("21789","380","2186","2","1","837.28","837.28","0","2019-07-12","2019-08-27","","0","1");
INSERT INTO contas_receber VALUES("21790","380","2186","3","1","837.29","837.29","0","2019-07-12","2019-09-17","","0","1");
INSERT INTO contas_receber VALUES("21791","455","2188","2","1","776.81","0","776.81","2019-07-12","2019-08-27","","1","1");
INSERT INTO contas_receber VALUES("21792","455","2188","1","1","776.81","0","776.81","2019-07-12","2019-08-12","","1","1");
INSERT INTO contas_receber VALUES("21793","455","2188","3","1","776.82","0","776.82","2019-07-12","2019-09-17","","1","1");
INSERT INTO contas_receber VALUES("21794","6","2187","1","1","378.5","0","378.5","2019-07-12","2019-08-12","","1","1");
INSERT INTO contas_receber VALUES("21795","6","2187","5","1","378.5","0","378.5","2019-07-12","2019-09-11","","1","1");
INSERT INTO contas_receber VALUES("21796","6","2187","3","1","378.5","0","378.5","2019-07-12","2019-08-26","","1","1");
INSERT INTO contas_receber VALUES("21797","6","2187","2","1","378.5","0","378.5","2019-07-12","2019-08-19","","1","1");
INSERT INTO contas_receber VALUES("21798","6","2187","4","1","378.5","0","378.5","2019-07-12","2019-09-02","","1","1");
INSERT INTO contas_receber VALUES("21799","380","2192","1","1","837.28","0","837.28","2019-07-12","2019-08-12","","1","1");
INSERT INTO contas_receber VALUES("21800","380","2192","3","1","837.29","0","837.29","2019-07-12","2019-09-17","","1","1");
INSERT INTO contas_receber VALUES("21801","380","2192","4","1","184.5","0","184.5","2019-07-12","2019-09-05","","1","1");
INSERT INTO contas_receber VALUES("21802","380","2192","2","1","837.28","0","837.28","2019-07-12","2019-08-27","","1","1");
INSERT INTO contas_receber VALUES("21818","37","2193","2","1","694.8","694.8","0","2019-07-12","2019-08-15","","0","0");
INSERT INTO contas_receber VALUES("21819","37","2193","1","1","694.8","694.8","0","2019-07-12","2019-07-15","","0","0");
INSERT INTO contas_receber VALUES("21820","37","2193","3","1","694.8","694.8","0","2019-07-12","2019-09-15","","0","0");
INSERT INTO contas_receber VALUES("21839","485","2191","1","1","1204.2","0","1204.2","2019-07-15","2019-07-14","","1","1");
INSERT INTO contas_receber VALUES("21840","31","2190","1","1","1078.1","0","1078.1","2019-07-15","2019-08-15","","1","1");
INSERT INTO contas_receber VALUES("21841","31","2190","2","1","1078.1","0","1078.1","2019-07-15","2019-08-30","","1","1");
INSERT INTO contas_receber VALUES("21842","31","2190","3","1","1078.1","0","1078.1","2019-07-15","2019-09-15","","1","1");
INSERT INTO contas_receber VALUES("21843","160","2189","1","1","279","0","279","2019-07-15","2019-08-16","","1","1");
INSERT INTO contas_receber VALUES("21844","160","2189","2","1","279","0","279","2019-07-15","2019-09-16","","1","1");
INSERT INTO contas_receber VALUES("21852","492","2199","1","1","2061","2061","0","2019-07-15","2019-07-16","","0","0");
INSERT INTO contas_receber VALUES("21857","25","2200","1","1","1667.37","1667.37","0","2019-07-15","2019-07-18","","0","1");
INSERT INTO contas_receber VALUES("21858","25","2200","2","1","1667.37","1667.37","0","2019-07-15","2019-08-18","","0","1");
INSERT INTO contas_receber VALUES("21859","25","2200","3","1","1667.36","1667.36","0","2019-07-15","2019-09-18","","0","1");
INSERT INTO contas_receber VALUES("21873","477","2202","1","1","262.6","262.6","0","2019-07-15","2019-07-16","","0","0");
INSERT INTO contas_receber VALUES("21874","3","2194","1","1","82.48","0","82.48","2019-07-15","2019-07-14","","1","1");
INSERT INTO contas_receber VALUES("21875","32","2197","1","1","46.32","0","46.32","2019-07-15","2019-07-17","","1","1");
INSERT INTO contas_receber VALUES("21922","211","2198","1","1","552.67","0","552.67","2019-07-16","2019-08-17","","1","1");
INSERT INTO contas_receber VALUES("21923","211","2198","2","1","552.67","0","552.67","2019-07-16","2019-09-01","","1","1");
INSERT INTO contas_receber VALUES("21924","211","2198","3","1","552.66","0","552.66","2019-07-16","2019-09-17","","1","1");
INSERT INTO contas_receber VALUES("21925","60","2180","1","1","434.3","0","434.3","2019-07-16","2019-08-16","","1","1");
INSERT INTO contas_receber VALUES("21926","60","2180","2","1","434.3","0","434.3","2019-07-16","2019-08-31","","1","1");
INSERT INTO contas_receber VALUES("21927","60","2180","3","1","434.3","0","434.3","2019-07-16","2019-09-16","","1","1");
INSERT INTO contas_receber VALUES("21928","4","2196","1","1","1234","0","1234","2019-07-16","2019-08-16","","1","1");
INSERT INTO contas_receber VALUES("21929","4","2196","3","1","1234","0","1234","2019-07-16","2019-09-16","","1","1");
INSERT INTO contas_receber VALUES("21930","4","2196","2","1","1234","0","1234","2019-07-16","2019-08-31","","1","1");
INSERT INTO contas_receber VALUES("21955","238","2176","1","1","471","0","471","2019-07-17","2019-07-11","","1","1");
INSERT INTO contas_receber VALUES("21956","37","2195","2","1","581.27","0","581.27","2019-07-17","2019-08-31","","1","1");
INSERT INTO contas_receber VALUES("21957","37","2195","3","1","581.26","0","581.26","2019-07-17","2019-09-16","","1","1");
INSERT INTO contas_receber VALUES("21958","37","2195","1","1","581.27","0","581.27","2019-07-17","2019-08-16","","1","1");
INSERT INTO contas_receber VALUES("21959","187","2203","1","1","876.33","0","876.33","2019-07-17","2019-08-17","","1","1");
INSERT INTO contas_receber VALUES("21960","187","2203","2","1","876.33","0","876.33","2019-07-17","2019-09-01","","1","1");
INSERT INTO contas_receber VALUES("21961","187","2203","3","1","876.34","0","876.34","2019-07-17","2019-09-17","","1","1");
INSERT INTO contas_receber VALUES("21962","324","2207","3","1","667.16","0","667.16","2019-07-17","2019-09-17","","1","1");
INSERT INTO contas_receber VALUES("21963","324","2207","1","1","667.17","0","667.17","2019-07-17","2019-08-17","","1","1");
INSERT INTO contas_receber VALUES("21964","324","2207","2","1","667.17","0","667.17","2019-07-17","2019-09-01","","1","1");
INSERT INTO contas_receber VALUES("21965","493","2204","1","1","316","0","316","2019-07-18","2019-08-18","","1","1");
INSERT INTO contas_receber VALUES("21966","493","2204","2","1","316","0","316","2019-07-18","2019-09-18","","1","1");
INSERT INTO contas_receber VALUES("21967","494","2205","1","1","1612.5","0","1612.5","2019-07-18","2019-09-02","","1","1");
INSERT INTO contas_receber VALUES("21978","25","2201","1","1","1638.4","0","1638.4","2019-07-18","2019-08-18","","1","1");
INSERT INTO contas_receber VALUES("21979","25","2201","2","1","1638.4","0","1638.4","2019-07-18","2019-09-02","","1","1");
INSERT INTO contas_receber VALUES("21980","25","2201","3","1","1638.4","0","1638.4","2019-07-18","2019-09-19","","1","1");
INSERT INTO contas_receber VALUES("21981","25","2201","4","1","199.5","0","199.5","2019-07-18","2019-08-25","","1","1");
INSERT INTO contas_receber VALUES("22000","19","2208","1","1","282.25","0","282.25","2019-07-19","2019-08-19","","1","1");
INSERT INTO contas_receber VALUES("22001","19","2208","2","1","282.25","0","282.25","2019-07-19","2019-09-03","","1","1");
INSERT INTO contas_receber VALUES("22002","19","2208","3","1","282.25","0","282.25","2019-07-19","2019-09-19","","1","1");
INSERT INTO contas_receber VALUES("22035","21","2206","1","1","1827.06","0","1827.06","2019-07-22","2019-08-23","","1","1");
INSERT INTO contas_receber VALUES("22036","21","2206","5","1","1827.06","0","1827.06","2019-07-22","2019-10-07","","1","1");
INSERT INTO contas_receber VALUES("22037","21","2206","4","1","1827.06","0","1827.06","2019-07-22","2019-09-22","","1","1");
INSERT INTO contas_receber VALUES("22038","21","2206","3","1","1827.06","0","1827.06","2019-07-22","2019-09-12","","1","1");
INSERT INTO contas_receber VALUES("22039","21","2206","2","1","1827.06","0","1827.06","2019-07-22","2019-09-02","","1","1");
INSERT INTO contas_receber VALUES("22040","495","2210","1","1","1791.1","0","1791.1","2019-07-22","2019-08-02","","1","1");
INSERT INTO contas_receber VALUES("22041","264","2209","1","1","346.74","0","346.74","2019-07-22","2019-07-20","","1","1");
INSERT INTO contas_receber VALUES("22061","369","2211","2","1","590.5","0","590.5","2019-07-23","2019-09-07","","1","1");
INSERT INTO contas_receber VALUES("22062","369","2211","1","1","590.5","0","590.5","2019-07-23","2019-08-23","","1","1");
INSERT INTO contas_receber VALUES("22063","369","2211","3","1","590.5","0","590.5","2019-07-23","2019-09-23","","1","1");
INSERT INTO contas_receber VALUES("22064","31","2215","3","1","253.5","0","253.5","2019-07-23","2019-09-23","","1","1");
INSERT INTO contas_receber VALUES("22065","31","2215","1","1","253.5","0","253.5","2019-07-23","2019-08-23","","1","1");
INSERT INTO contas_receber VALUES("22066","31","2215","2","1","253.5","0","253.5","2019-07-23","2019-09-07","","1","1");
INSERT INTO contas_receber VALUES("22067","278","2213","3","1","725.34","0","725.34","2019-07-23","2019-10-23","","1","1");
INSERT INTO contas_receber VALUES("22068","278","2213","1","1","725.33","0","725.33","2019-07-23","2019-08-23","","1","1");
INSERT INTO contas_receber VALUES("22069","278","2213","2","1","725.33","0","725.33","2019-07-23","2019-09-23","","1","1");
INSERT INTO contas_receber VALUES("22070","9","2212","2","1","1231.16","0","1231.16","2019-07-23","2019-09-23","","1","1");
INSERT INTO contas_receber VALUES("22071","9","2212","3","1","1231.16","0","1231.16","2019-07-23","2019-10-23","","1","1");
INSERT INTO contas_receber VALUES("22072","9","2212","1","1","1231.16","0","1231.16","2019-07-23","2019-08-23","","1","1");
INSERT INTO contas_receber VALUES("22097","31","2219","1","1","202.8","0","202.8","2019-07-23","2019-08-24","","1","1");
INSERT INTO contas_receber VALUES("22098","31","2219","2","1","202.8","0","202.8","2019-07-23","2019-09-08","","1","1");
INSERT INTO contas_receber VALUES("22099","31","2219","3","1","202.8","0","202.8","2019-07-23","2019-09-24","","1","1");
INSERT INTO contas_receber VALUES("22100","494","2216","1","1","968","0","968","2019-07-24","2019-09-07","","1","1");
INSERT INTO contas_receber VALUES("22101","161","2214","3","1","1043.59","0","1043.59","2019-07-24","2019-09-09","","1","1");
INSERT INTO contas_receber VALUES("22102","161","2214","2","1","1043.58","0","1043.58","2019-07-24","2019-08-30","","1","1");
INSERT INTO contas_receber VALUES("22103","161","2214","1","1","1043.58","0","1043.58","2019-07-24","2019-08-23","","1","1");
INSERT INTO contas_receber VALUES("22104","324","2218","1","1","888.67","0","888.67","2019-07-24","2019-08-25","","1","1");
INSERT INTO contas_receber VALUES("22105","324","2218","3","1","888.66","0","888.66","2019-07-24","2019-09-25","","1","1");
INSERT INTO contas_receber VALUES("22106","324","2218","2","1","888.67","0","888.67","2019-07-24","2019-09-09","","1","1");
INSERT INTO contas_receber VALUES("22147","47","2225","1","1","599.75","599.75","0","2019-07-24","2019-07-26","","0","1");
INSERT INTO contas_receber VALUES("22148","47","2225","2","1","599.75","599.75","0","2019-07-24","2019-08-26","","0","1");
INSERT INTO contas_receber VALUES("22149","47","2225","3","1","599.76","599.76","0","2019-07-24","2019-09-26","","0","1");
INSERT INTO contas_receber VALUES("22175","220","2228","1","1","4333.8","4333.8","0","2019-07-24","2019-07-27","","0","0");
INSERT INTO contas_receber VALUES("22176","220","2228","2","1","4333.8","4333.8","0","2019-07-24","2019-08-27","","0","0");
INSERT INTO contas_receber VALUES("22177","220","2228","3","1","4333.8","4333.8","0","2019-07-24","2019-09-27","","0","0");
INSERT INTO contas_receber VALUES("22192","381","2220","1","1","1969.9","0","1969.9","2019-07-25","2019-08-05","","1","1");
INSERT INTO contas_receber VALUES("22196","329","2224","1","1","334.9","0","334.9","2019-07-25","2019-08-26","","1","1");
INSERT INTO contas_receber VALUES("22197","329","2224","2","1","334.9","0","334.9","2019-07-25","2019-09-10","","1","1");
INSERT INTO contas_receber VALUES("22198","329","2224","3","1","334.9","0","334.9","2019-07-25","2019-09-26","","1","1");
INSERT INTO contas_receber VALUES("22205","496","2221","3","1","1120.33","0","1120.33","2019-07-26","2019-09-26","","1","1");
INSERT INTO contas_receber VALUES("22206","496","2221","1","1","1120.33","0","1120.33","2019-07-26","2019-08-26","","1","1");
INSERT INTO contas_receber VALUES("22207","496","2221","4","1","1120.31","0","1120.31","2019-07-26","2019-10-11","","1","1");
INSERT INTO contas_receber VALUES("22208","496","2221","2","1","1120.33","0","1120.33","2019-07-26","2019-09-10","","1","1");
INSERT INTO contas_receber VALUES("22209","449","2222","1","1","157.5","0","157.5","2019-07-26","2019-07-26","","1","1");
INSERT INTO contas_receber VALUES("22230","485","2231","1","1","1197.5","0","1197.5","2019-07-29","2019-07-27","","1","1");
INSERT INTO contas_receber VALUES("22231","98","2223","3","1","800","0","800","2019-07-29","2019-10-29","","1","1");
INSERT INTO contas_receber VALUES("22232","98","2223","1","1","800","0","800","2019-07-29","2019-08-29","","1","1");
INSERT INTO contas_receber VALUES("22233","98","2223","2","1","800","0","800","2019-07-29","2019-09-29","","1","1");
INSERT INTO contas_receber VALUES("22250","3","2239","1","1","12.24","0","12.24","2019-07-30","2019-07-31","","1","1");
INSERT INTO contas_receber VALUES("22251","32","2240","1","1","196.87","0","196.87","2019-07-30","2019-07-31","","1","1");
INSERT INTO contas_receber VALUES("22252","38","2236","1","1","23.04","0","23.04","2019-07-30","2019-08-01","","1","1");
INSERT INTO contas_receber VALUES("22327","192","2217","1","1","1257","0","1257","2019-08-01","2019-08-12","","1","1");
INSERT INTO contas_receber VALUES("22328","192","2217","2","1","1257","0","1257","2019-08-01","2019-08-12","","1","1");
INSERT INTO contas_receber VALUES("22329","4","2230","3","1","1278","0","1278","2019-08-01","2019-10-01","","1","1");
INSERT INTO contas_receber VALUES("22330","4","2230","2","1","1278","0","1278","2019-08-01","2019-09-16","","1","1");
INSERT INTO contas_receber VALUES("22331","4","2230","1","1","1278","0","1278","2019-08-01","2019-09-01","","1","1");
INSERT INTO contas_receber VALUES("22332","324","2241","1","1","638.33","0","638.33","2019-08-01","2019-09-02","","1","1");
INSERT INTO contas_receber VALUES("22333","324","2241","3","1","638.32","0","638.32","2019-08-01","2019-10-02","","1","1");
INSERT INTO contas_receber VALUES("22334","324","2241","2","1","638.33","0","638.33","2019-08-01","2019-09-17","","1","1");
INSERT INTO contas_receber VALUES("22335","23","2233","1","1","394.94","0","394.94","2019-08-01","2019-09-02","","1","1");
INSERT INTO contas_receber VALUES("22336","23","2233","4","1","394.94","0","394.94","2019-08-01","2019-10-02","","1","1");
INSERT INTO contas_receber VALUES("22337","23","2233","2","1","394.94","0","394.94","2019-08-01","2019-09-12","","1","1");
INSERT INTO contas_receber VALUES("22338","23","2233","3","1","394.94","0","394.94","2019-08-01","2019-09-22","","1","1");
INSERT INTO contas_receber VALUES("22339","23","2233","5","1","394.94","0","394.94","2019-08-01","2019-10-12","","1","1");
INSERT INTO contas_receber VALUES("22340","459","2237","1","1","509.2","0","509.2","2019-08-01","2019-09-02","","1","1");
INSERT INTO contas_receber VALUES("22356","476","2227","1","1","1023.5","0","1023.5","2019-08-01","2019-08-29","","1","1");
INSERT INTO contas_receber VALUES("22357","476","2227","2","1","1023.5","0","1023.5","2019-08-01","2019-09-13","","1","1");
INSERT INTO contas_receber VALUES("22358","476","2227","3","1","1023.5","0","1023.5","2019-08-01","2019-09-29","","1","1");
INSERT INTO contas_receber VALUES("22359","47","2226","3","1","599.76","0","599.76","2019-08-01","2019-09-29","","1","1");
INSERT INTO contas_receber VALUES("22360","47","2226","1","1","599.75","0","599.75","2019-08-01","2019-08-29","","1","1");
INSERT INTO contas_receber VALUES("22361","47","2226","2","1","599.75","0","599.75","2019-08-01","2019-09-13","","1","1");
INSERT INTO contas_receber VALUES("22362","498","2229","1","1","12901.5","0","12901.5","2019-08-01","2019-07-28","","1","1");
INSERT INTO contas_receber VALUES("22363","270","2232","1","1","522.6","0","522.6","2019-08-01","2019-07-28","","1","1");
INSERT INTO contas_receber VALUES("22376","31","2246","1","1","529.3","0","529.3","2019-08-02","2019-09-02","","1","1");
INSERT INTO contas_receber VALUES("22377","31","2246","2","1","529.3","0","529.3","2019-08-02","2019-09-17","","1","1");
INSERT INTO contas_receber VALUES("22378","31","2246","3","1","529.3","0","529.3","2019-08-02","2019-10-02","","1","1");
INSERT INTO contas_receber VALUES("22379","46","2245","1","1","224.02","0","224.02","2019-08-02","2019-09-02","","1","1");
INSERT INTO contas_receber VALUES("22380","46","2245","2","1","224.03","0","224.03","2019-08-02","2019-10-02","","1","1");
INSERT INTO contas_receber VALUES("22397","31","2255","1","1","206","0","206","2019-08-02","2019-09-29","","1","1");
INSERT INTO contas_receber VALUES("22410","84","2234","1","1","849.65","0","849.65","2019-08-05","2019-09-05","","1","1");
INSERT INTO contas_receber VALUES("22411","84","2234","3","1","849.65","0","849.65","2019-08-05","2019-10-05","","1","1");
INSERT INTO contas_receber VALUES("22412","84","2234","2","1","849.65","0","849.65","2019-08-05","2019-09-20","","1","1");
INSERT INTO contas_receber VALUES("22413","303","2238","1","1","685.8","0","685.8","2019-08-05","2019-09-05","","1","1");
INSERT INTO contas_receber VALUES("22414","303","2238","3","1","685.8","0","685.8","2019-08-05","2019-10-05","","1","1");
INSERT INTO contas_receber VALUES("22415","303","2238","2","1","685.8","0","685.8","2019-08-05","2019-09-20","","1","1");
INSERT INTO contas_receber VALUES("22426","33","2257","1","1","982.6","0","982.6","2019-08-06","2019-08-04","","1","1");
INSERT INTO contas_receber VALUES("22427","33","2257","2","1","982.6","0","982.6","2019-08-06","2019-09-04","","1","1");
INSERT INTO contas_receber VALUES("22428","19","2247","2","1","411.98","0","411.98","2019-08-06","2019-09-23","","1","1");
INSERT INTO contas_receber VALUES("22429","19","2247","1","1","411.98","0","411.98","2019-08-06","2019-09-07","","1","1");
INSERT INTO contas_receber VALUES("22430","19","2247","3","1","411.98","0","411.98","2019-08-06","2019-10-07","","1","1");
INSERT INTO contas_receber VALUES("22431","25","2244","1","1","701.47","0","701.47","2019-08-06","2019-09-07","","1","1");
INSERT INTO contas_receber VALUES("22432","25","2244","2","1","701.47","0","701.47","2019-08-06","2019-09-23","","1","1");
INSERT INTO contas_receber VALUES("22433","25","2244","3","1","701.47","0","701.47","2019-08-06","2019-10-07","","1","1");
INSERT INTO contas_receber VALUES("22434","380","2253","2","1","1398.33","0","1398.33","2019-08-06","2019-09-23","","1","1");
INSERT INTO contas_receber VALUES("22435","380","2253","1","1","1398.33","0","1398.33","2019-08-06","2019-09-07","","1","1");
INSERT INTO contas_receber VALUES("22436","380","2253","3","1","1398.34","0","1398.34","2019-08-06","2019-10-07","","1","1");
INSERT INTO contas_receber VALUES("22437","497","2251","1","1","189.6","0","189.6","2019-08-06","2019-09-07","","1","1");
INSERT INTO contas_receber VALUES("22438","497","2251","2","1","189.6","0","189.6","2019-08-06","2019-10-07","","1","1");
INSERT INTO contas_receber VALUES("22469","24","2249","1","1","956.9","0","956.9","2019-08-07","2019-08-20","","1","1");
INSERT INTO contas_receber VALUES("22470","24","2249","2","1","956.9","0","956.9","2019-08-07","2019-08-20","","1","1");
INSERT INTO contas_receber VALUES("22471","500","2252","1","1","343","0","343","2019-08-07","2019-09-08","","1","1");
INSERT INTO contas_receber VALUES("22472","500","2252","2","1","343","0","343","2019-08-07","2019-10-08","","1","1");
INSERT INTO contas_receber VALUES("22475","252","2258","1","1","670.33","0","670.33","2019-08-07","2019-09-09","","1","1");
INSERT INTO contas_receber VALUES("22476","252","2258","3","1","670.34","0","670.34","2019-08-07","2019-10-09","","1","1");
INSERT INTO contas_receber VALUES("22477","252","2258","2","1","670.33","0","670.33","2019-08-07","2019-09-24","","1","1");
INSERT INTO contas_receber VALUES("22484","368","2250","1","1","68.32","0","68.32","2019-08-07","2019-08-03","","1","1");
INSERT INTO contas_receber VALUES("22485","159","2242","1","1","358.4","0","358.4","2019-08-07","2019-08-02","","1","1");
INSERT INTO contas_receber VALUES("22486","499","2235","1","1","122.32","0","122.32","2019-08-07","2019-07-31","","1","1");
INSERT INTO contas_receber VALUES("22487","70","2243","1","1","655.55","0","655.55","2019-08-07","2019-08-19","","1","1");
INSERT INTO contas_receber VALUES("22488","70","2243","2","1","655.55","0","655.55","2019-08-07","2019-08-19","","1","1");
INSERT INTO contas_receber VALUES("22491","35","2254","1","1","125.19","0","125.19","2019-08-07","2019-09-05","","1","1");
INSERT INTO contas_receber VALUES("22492","35","2254","2","1","125.19","0","125.19","2019-08-07","2019-10-05","","1","1");
INSERT INTO contas_receber VALUES("22493","3","2261","1","1","274.24","0","274.24","2019-08-07","2019-08-08","","1","1");
INSERT INTO contas_receber VALUES("22511","503","2271","1","1","23.37","23.37","0","2019-08-08","2019-08-09","","0","0");
INSERT INTO contas_receber VALUES("22512","469","2248","1","1","456.3","0","456.3","2019-08-08","2019-09-09","","1","1");
INSERT INTO contas_receber VALUES("22513","469","2248","2","1","456.3","0","456.3","2019-08-08","2019-09-24","","1","1");
INSERT INTO contas_receber VALUES("22514","469","2248","3","1","456.3","0","456.3","2019-08-08","2019-10-09","","1","1");
INSERT INTO contas_receber VALUES("22515","379","2259","1","1","228.48","0","228.48","2019-08-08","2019-09-09","","1","1");
INSERT INTO contas_receber VALUES("22534","140","2264","1","1","472.4","0","472.4","2019-08-08","2019-09-24","","1","1");
INSERT INTO contas_receber VALUES("22537","22","2263","1","1","540.25","0","540.25","2019-08-08","2019-09-09","","1","1");
INSERT INTO contas_receber VALUES("22538","22","2263","3","1","540.25","0","540.25","2019-08-08","2019-10-09","","1","1");
INSERT INTO contas_receber VALUES("22539","22","2263","2","1","540.25","0","540.25","2019-08-08","2019-09-24","","1","1");
INSERT INTO contas_receber VALUES("22551","203","2260","1","1","1584.68","0","1584.68","2019-08-09","2019-08-20","","1","1");
INSERT INTO contas_receber VALUES("22552","203","2260","2","1","1584.68","0","1584.68","2019-08-09","2019-08-20","","1","1");
INSERT INTO contas_receber VALUES("22553","203","2260","3","1","108.14","0","108.14","2019-08-09","2019-08-20","","1","1");
INSERT INTO contas_receber VALUES("22554","324","2270","2","1","802.13","0","802.13","2019-08-09","2019-09-24","","1","1");
INSERT INTO contas_receber VALUES("22555","324","2270","1","1","802.13","0","802.13","2019-08-09","2019-09-09","","1","1");
INSERT INTO contas_receber VALUES("22556","324","2270","3","1","802.14","0","802.14","2019-08-09","2019-10-09","","1","1");
INSERT INTO contas_receber VALUES("22559","449","2275","1","1","149.59","0","149.59","2019-08-09","2019-08-11","","1","1");
INSERT INTO contas_receber VALUES("22578","501","2266","1","1","496.5","0","496.5","2019-08-09","2019-08-10","","1","1");
INSERT INTO contas_receber VALUES("22587","161","2277","1","1","363.95","363.95","0","2019-08-09","2019-08-10","","0","0");
INSERT INTO contas_receber VALUES("22588","161","2277","2","1","363.95","363.95","0","2019-08-09","2019-09-10","","0","0");
INSERT INTO contas_receber VALUES("22589","260","2256","1","1","47.08","0","47.08","2019-08-09","2019-08-04","","1","1");
INSERT INTO contas_receber VALUES("22596","212","2265","1","1","610.83","0","610.83","2019-08-12","2019-09-12","","1","1");
INSERT INTO contas_receber VALUES("22597","212","2265","2","1","610.83","0","610.83","2019-08-12","2019-09-27","","1","1");
INSERT INTO contas_receber VALUES("22598","212","2265","3","1","610.83","0","610.83","2019-08-12","2019-10-12","","1","1");
INSERT INTO contas_receber VALUES("22613","502","2268","1","1","441.33","0","441.33","2019-08-12","2019-09-12","","1","1");
INSERT INTO contas_receber VALUES("22614","502","2268","2","1","441.33","0","441.33","2019-08-12","2019-09-27","","1","1");
INSERT INTO contas_receber VALUES("22615","502","2268","3","1","441.34","0","441.34","2019-08-12","2019-10-12","","1","1");
INSERT INTO contas_receber VALUES("22616","494","2267","1","1","2404.5","0","2404.5","2019-08-12","2019-09-27","","1","1");
INSERT INTO contas_receber VALUES("22617","68","2269","1","1","1220.42","0","1220.42","2019-08-12","2019-08-23","","1","1");
INSERT INTO contas_receber VALUES("22618","68","2269","2","1","1220.43","0","1220.43","2019-08-12","2019-08-23","","1","1");
INSERT INTO contas_receber VALUES("22639","8","2262","1","1","431","0","431","2019-08-13","2019-09-09","","1","1");
INSERT INTO contas_receber VALUES("22640","8","2262","2","1","431","0","431","2019-08-13","2019-09-24","","1","1");
INSERT INTO contas_receber VALUES("22641","8","2262","3","1","431","0","431","2019-08-13","2019-10-09","","1","1");
INSERT INTO contas_receber VALUES("22642","31","2276","2","1","612.29","0","612.29","2019-08-13","2019-09-28","","1","1");
INSERT INTO contas_receber VALUES("22643","31","2276","1","1","612.29","0","612.29","2019-08-13","2019-09-13","","1","1");
INSERT INTO contas_receber VALUES("22644","31","2276","3","1","612.28","0","612.28","2019-08-13","2019-10-13","","1","1");
INSERT INTO contas_receber VALUES("22660","4","2272","3","1","1264.84","0","1264.84","2019-08-13","2019-10-14","","1","1");
INSERT INTO contas_receber VALUES("22661","4","2272","2","1","1264.83","0","1264.83","2019-08-13","2019-09-29","","1","1");
INSERT INTO contas_receber VALUES("22662","4","2272","1","1","1264.83","0","1264.83","2019-08-13","2019-09-14","","1","1");
INSERT INTO contas_receber VALUES("22682","3","2284","1","1","399.97","0","399.97","2019-08-13","2019-08-15","","1","1");
INSERT INTO contas_receber VALUES("22683","74","2274","2","1","1291.13","0","1291.13","2019-08-14","2019-09-30","","1","1");
INSERT INTO contas_receber VALUES("22684","74","2274","1","1","1291.13","0","1291.13","2019-08-14","2019-09-15","","1","1");
INSERT INTO contas_receber VALUES("22685","74","2274","3","1","1291.14","0","1291.14","2019-08-14","2019-10-15","","1","1");
INSERT INTO contas_receber VALUES("22708","179","2288","1","1","346.1","0","346.1","2019-08-14","2019-09-16","","1","1");
INSERT INTO contas_receber VALUES("22737","60","2278","1","1","1121.6","0","1121.6","2019-08-16","2019-09-16","","1","1");
INSERT INTO contas_receber VALUES("22738","60","2278","2","1","1121.6","0","1121.6","2019-08-16","2019-10-01","","1","1");
INSERT INTO contas_receber VALUES("22739","60","2278","3","1","1121.6","0","1121.6","2019-08-16","2019-10-16","","1","1");
INSERT INTO contas_receber VALUES("22740","448","2279","1","1","189.6","189.6","0","2019-08-16","2019-09-16","","0","1");
INSERT INTO contas_receber VALUES("22741","329","2282","2","1","343.7","0","343.7","2019-08-16","2019-10-01","","1","1");
INSERT INTO contas_receber VALUES("22742","329","2282","1","1","343.7","0","343.7","2019-08-16","2019-09-16","","1","1");
INSERT INTO contas_receber VALUES("22743","329","2282","3","1","343.7","0","343.7","2019-08-16","2019-10-16","","1","1");
INSERT INTO contas_receber VALUES("22762","456","2286","1","1","326.45","0","326.45","2019-08-16","2019-09-16","","1","1");
INSERT INTO contas_receber VALUES("22763","456","2286","2","1","326.45","0","326.45","2019-08-16","2019-10-16","","1","1");
INSERT INTO contas_receber VALUES("22764","156","2285","2","1","253.17","0","253.17","2019-08-16","2019-10-04","","1","1");
INSERT INTO contas_receber VALUES("22765","156","2285","1","1","253.17","0","253.17","2019-08-16","2019-09-19","","1","1");
INSERT INTO contas_receber VALUES("22766","156","2285","3","1","253.16","0","253.16","2019-08-16","2019-10-19","","1","1");
INSERT INTO contas_receber VALUES("22767","485","2283","1","1","1622.5","0","1622.5","2019-08-16","2019-08-17","","1","1");
INSERT INTO contas_receber VALUES("22768","347","2281","1","1","686","0","686","2019-08-19","2019-09-16","","1","1");
INSERT INTO contas_receber VALUES("22769","347","2281","3","1","686","0","686","2019-08-19","2019-10-16","","1","1");
INSERT INTO contas_receber VALUES("22770","347","2281","2","1","686","0","686","2019-08-19","2019-10-01","","1","1");
INSERT INTO contas_receber VALUES("22771","357","2289","2","1","874.17","0","874.17","2019-08-19","2019-10-20","","1","1");
INSERT INTO contas_receber VALUES("22772","357","2289","1","1","874.17","0","874.17","2019-08-19","2019-09-20","","1","1");
INSERT INTO contas_receber VALUES("22773","357","2289","3","1","874.16","0","874.16","2019-08-19","2019-11-20","","1","1");
INSERT INTO contas_receber VALUES("22774","481","2291","1","1","405","0","405","2019-08-19","2019-09-20","","1","1");
INSERT INTO contas_receber VALUES("22775","481","2291","2","1","405","0","405","2019-08-19","2019-10-05","","1","1");
INSERT INTO contas_receber VALUES("22776","481","2291","3","1","405","0","405","2019-08-19","2019-10-20","","1","1");
INSERT INTO contas_receber VALUES("22777","31","2294","1","1","265.5","0","265.5","2019-08-19","2019-09-19","","1","1");
INSERT INTO contas_receber VALUES("22778","31","2294","2","1","265.5","0","265.5","2019-08-19","2019-10-19","","1","1");
INSERT INTO contas_receber VALUES("22829","311","2292","1","1","411.11","411.11","0","2019-08-19","2019-09-21","","0","1");
INSERT INTO contas_receber VALUES("22830","311","2292","2","1","411.11","411.11","0","2019-08-19","2019-10-06","","0","1");
INSERT INTO contas_receber VALUES("22831","311","2292","3","1","411.1","411.1","0","2019-08-19","2019-10-21","","0","1");
INSERT INTO contas_receber VALUES("22887","4","2297","1","1","1292.83","0","1292.83","2019-08-21","2019-09-21","","1","1");
INSERT INTO contas_receber VALUES("22888","4","2297","2","1","1292.83","0","1292.83","2019-08-21","2019-10-06","","1","1");
INSERT INTO contas_receber VALUES("22889","4","2297","3","1","1292.84","0","1292.84","2019-08-21","2019-10-21","","1","1");
INSERT INTO contas_receber VALUES("22890","413","2301","2","1","787.75","0","787.75","2019-08-21","2019-10-07","","1","1");
INSERT INTO contas_receber VALUES("22891","413","2301","3","1","787.75","0","787.75","2019-08-21","2019-10-22","","1","1");
INSERT INTO contas_receber VALUES("22892","413","2301","1","1","787.75","0","787.75","2019-08-21","2019-09-22","","1","1");
INSERT INTO contas_receber VALUES("22893","413","2301","4","1","787.75","0","787.75","2019-08-21","2019-11-01","","1","1");
INSERT INTO contas_receber VALUES("22894","354","2299","3","1","534.62","0","534.62","2019-08-21","2019-10-23","","1","1");
INSERT INTO contas_receber VALUES("22895","354","2299","1","1","534.61","0","534.61","2019-08-21","2019-09-23","","1","1");
INSERT INTO contas_receber VALUES("22896","354","2299","2","1","534.61","0","534.61","2019-08-21","2019-10-08","","1","1");
INSERT INTO contas_receber VALUES("22897","422","2296","2","1","415.7","0","415.7","2019-08-21","2019-10-07","","1","1");
INSERT INTO contas_receber VALUES("22898","422","2296","1","1","415.7","0","415.7","2019-08-21","2019-09-22","","1","1");
INSERT INTO contas_receber VALUES("22899","422","2296","3","1","415.7","0","415.7","2019-08-21","2019-10-22","","1","1");
INSERT INTO contas_receber VALUES("22900","322","2293","2","1","496.4","0","496.4","2019-08-21","2019-10-07","","1","1");
INSERT INTO contas_receber VALUES("22901","322","2293","1","1","496.4","0","496.4","2019-08-21","2019-09-22","","1","1");
INSERT INTO contas_receber VALUES("22902","322","2293","3","1","496.4","0","496.4","2019-08-21","2019-10-22","","1","1");
INSERT INTO contas_receber VALUES("22903","46","2302","2","1","231.87","0","231.87","2019-08-21","2019-10-23","","1","1");
INSERT INTO contas_receber VALUES("22904","46","2302","1","1","231.88","0","231.88","2019-08-21","2019-09-23","","1","1");
INSERT INTO contas_receber VALUES("22905","504","2280","1","1","131.25","0","131.25","2019-08-21","2019-08-14","","1","1");
INSERT INTO contas_receber VALUES("22906","260","2290","1","1","164.39","0","164.39","2019-08-21","2019-09-12","","1","1");
INSERT INTO contas_receber VALUES("22907","505","2295","1","1","45.4","0","45.4","2019-08-21","2019-08-18","","1","1");
INSERT INTO contas_receber VALUES("22908","28","2298","1","1","454.09","0","454.09","2019-08-21","2019-09-22","","1","1");
INSERT INTO contas_receber VALUES("22909","28","2298","2","1","454.1","0","454.1","2019-08-21","2019-10-22","","1","1");
INSERT INTO contas_receber VALUES("22983","494","2308","1","1","1243.63","0","1243.63","2019-08-23","2019-10-07","","1","1");
INSERT INTO contas_receber VALUES("22984","494","2308","2","1","1243.62","0","1243.62","2019-08-23","2019-10-12","","1","1");
INSERT INTO contas_receber VALUES("22985","23","2309","4","1","453.9","0","453.9","2019-08-23","2019-10-23","","1","1");
INSERT INTO contas_receber VALUES("22986","23","2309","1","1","453.9","0","453.9","2019-08-23","2019-09-23","","1","1");
INSERT INTO contas_receber VALUES("22987","23","2309","2","1","453.9","0","453.9","2019-08-23","2019-10-03","","1","1");
INSERT INTO contas_receber VALUES("22988","23","2309","3","1","453.9","0","453.9","2019-08-23","2019-10-13","","1","1");
INSERT INTO contas_receber VALUES("22989","263","2305","1","1","757.48","0","757.48","2019-08-23","2019-09-09","","1","1");
INSERT INTO contas_receber VALUES("22990","263","2305","2","1","757.47","0","757.47","2019-08-23","2019-09-09","","1","1");
INSERT INTO contas_receber VALUES("23032","34","2303","1","1","1048.47","0","1048.47","2019-08-26","2019-09-28","","1","1");
INSERT INTO contas_receber VALUES("23033","34","2303","2","1","1048.47","0","1048.47","2019-08-26","2019-10-13","","1","1");
INSERT INTO contas_receber VALUES("23034","34","2303","3","1","1048.46","0","1048.46","2019-08-26","2019-10-28","","1","1");
INSERT INTO contas_receber VALUES("23051","3","2310","1","1","277.3","0","277.3","2019-08-26","2019-08-23","","1","1");
INSERT INTO contas_receber VALUES("23059","311","2324","2","1","411.11","0","411.11","2019-08-26","2019-10-06","","1","1");
INSERT INTO contas_receber VALUES("23060","311","2324","3","1","411.1","0","411.1","2019-08-26","2019-10-21","","1","1");
INSERT INTO contas_receber VALUES("23061","311","2324","1","1","411.11","0","411.11","2019-08-26","2019-09-21","","1","1");
INSERT INTO contas_receber VALUES("23062","128","2300","1","1","400.83","0","400.83","2019-08-26","2019-09-23","","1","1");
INSERT INTO contas_receber VALUES("23063","128","2300","2","1","400.83","0","400.83","2019-08-26","2019-10-07","","1","1");
INSERT INTO contas_receber VALUES("23064","128","2300","3","1","400.84","0","400.84","2019-08-26","2019-10-23","","1","1");
INSERT INTO contas_receber VALUES("23065","439","2321","1","1","153","0","153","2019-08-26","2019-08-26","","1","1");
INSERT INTO contas_receber VALUES("23066","483","2312","1","1","387","0","387","2019-08-26","2019-08-24","","1","1");
INSERT INTO contas_receber VALUES("23067","485","2317","1","1","1540.4","0","1540.4","2019-08-26","2019-08-25","","1","1");
INSERT INTO contas_receber VALUES("23068","35","2273","1","1","148.8","0","148.8","2019-08-26","2019-09-09","","1","1");
INSERT INTO contas_receber VALUES("23181","142","2313","2","1","229.89","0","229.89","2019-08-28","2019-10-29","","1","1");
INSERT INTO contas_receber VALUES("23182","142","2313","1","1","229.89","0","229.89","2019-08-28","2019-09-29","","1","1");
INSERT INTO contas_receber VALUES("23207","498","2304","1","1","16786.8","0","16786.8","2019-08-29","2019-08-24","","1","1");
INSERT INTO contas_receber VALUES("23211","62","2307","2","1","668.29","0","668.29","2019-08-29","2019-10-29","","1","1");
INSERT INTO contas_receber VALUES("23212","62","2307","3","1","668.28","0","668.28","2019-08-29","2019-11-29","","1","1");
INSERT INTO contas_receber VALUES("23213","62","2307","1","1","668.29","0","668.29","2019-08-29","2019-09-29","","1","1");
INSERT INTO contas_receber VALUES("23262","496","2311","3","1","1114.25","0","1114.25","2019-08-29","2019-10-28","","1","1");
INSERT INTO contas_receber VALUES("23263","496","2311","1","1","1114.25","0","1114.25","2019-08-29","2019-09-28","","1","1");
INSERT INTO contas_receber VALUES("23264","496","2311","4","1","1114.25","0","1114.25","2019-08-29","2019-11-12","","1","1");
INSERT INTO contas_receber VALUES("23265","496","2311","2","1","1114.25","0","1114.25","2019-08-29","2019-10-13","","1","1");
INSERT INTO contas_receber VALUES("23266","380","2319","4","1","829","0","829","2019-08-29","2019-11-14","","1","1");
INSERT INTO contas_receber VALUES("23267","380","2319","1","1","1172.86","0","1172.86","2019-08-29","2019-09-29","","1","1");
INSERT INTO contas_receber VALUES("23268","380","2319","3","1","1172.88","0","1172.88","2019-08-29","2019-10-29","","1","1");
INSERT INTO contas_receber VALUES("23269","380","2319","2","1","1172.86","0","1172.86","2019-08-29","2019-10-14","","1","1");
INSERT INTO contas_receber VALUES("23270","19","2314","1","1","407.98","0","407.98","2019-08-30","2019-09-29","","1","1");
INSERT INTO contas_receber VALUES("23271","19","2314","2","1","407.98","0","407.98","2019-08-30","2019-10-14","","1","1");
INSERT INTO contas_receber VALUES("23272","19","2314","3","1","407.99","0","407.99","2019-08-30","2019-10-29","","1","1");
INSERT INTO contas_receber VALUES("23273","30","2315","1","1","753.45","0","753.45","2019-08-30","2019-09-29","","1","1");
INSERT INTO contas_receber VALUES("23274","30","2315","2","1","753.45","0","753.45","2019-08-30","2019-10-14","","1","1");
INSERT INTO contas_receber VALUES("23275","30","2315","3","1","753.45","0","753.45","2019-08-30","2019-10-29","","1","1");
INSERT INTO contas_receber VALUES("23276","30","2315","4","1","753.45","0","753.45","2019-08-30","2019-11-13","","1","1");
INSERT INTO contas_receber VALUES("23289","31","2322","2","1","520.92","0","520.92","2019-08-30","2019-10-14","","1","1");
INSERT INTO contas_receber VALUES("23290","31","2322","1","1","520.92","0","520.92","2019-08-30","2019-09-29","","1","1");
INSERT INTO contas_receber VALUES("23291","31","2322","3","1","520.91","0","520.91","2019-08-30","2019-11-29","","1","1");
INSERT INTO contas_receber VALUES("23298","457","2320","2","1","536.92","0","536.92","2019-09-02","2019-10-15","","1","1");
INSERT INTO contas_receber VALUES("23299","457","2320","3","1","536.91","0","536.91","2019-09-02","2019-10-30","","1","1");
INSERT INTO contas_receber VALUES("23300","457","2320","1","1","536.92","0","536.92","2019-09-02","2019-09-30","","1","1");
INSERT INTO contas_receber VALUES("23301","60","2318","2","1","713.77","0","713.77","2019-09-02","2019-10-15","","1","1");
INSERT INTO contas_receber VALUES("23302","60","2318","1","1","713.77","0","713.77","2019-09-02","2019-09-30","","1","1");
INSERT INTO contas_receber VALUES("23303","60","2318","3","1","713.78","0","713.78","2019-09-02","2019-10-30","","1","1");
INSERT INTO contas_receber VALUES("23304","450","2331","1","1","355.88","0","355.88","2019-09-02","2019-08-29","","1","1");
INSERT INTO contas_receber VALUES("23305","324","2339","2","1","1279.17","0","1279.17","2019-09-02","2019-10-18","","1","1");
INSERT INTO contas_receber VALUES("23306","324","2339","1","1","1279.17","0","1279.17","2019-09-02","2019-10-03","","1","1");
INSERT INTO contas_receber VALUES("23307","324","2339","3","1","1279.16","0","1279.16","2019-09-02","2019-11-03","","1","1");
INSERT INTO contas_receber VALUES("23316","243","2329","1","1","575.97","0","575.97","2019-09-02","2019-10-03","","1","1");
INSERT INTO contas_receber VALUES("23317","243","2329","3","1","575.96","0","575.96","2019-09-02","2019-11-03","","1","1");
INSERT INTO contas_receber VALUES("23318","243","2329","2","1","575.97","0","575.97","2019-09-02","2019-10-18","","1","1");
INSERT INTO contas_receber VALUES("23319","509","2330","1","1","1545.2","0","1545.2","2019-09-02","2019-08-29","","1","1");
INSERT INTO contas_receber VALUES("23320","22","2306","1","1","310.85","0","310.85","2019-09-02","2019-09-26","","1","1");
INSERT INTO contas_receber VALUES("23321","22","2306","2","1","310.85","0","310.85","2019-09-02","2019-10-11","","1","1");
INSERT INTO contas_receber VALUES("23322","22","2306","3","1","310.85","0","310.85","2019-09-02","2019-10-26","","1","1");
INSERT INTO contas_receber VALUES("23323","506","2316","3","1","404.66","0","404.66","2019-09-02","2019-10-29","","1","1");
INSERT INTO contas_receber VALUES("23324","506","2316","1","1","404.66","0","404.66","2019-09-02","2019-09-29","","1","1");
INSERT INTO contas_receber VALUES("23325","506","2316","2","1","404.66","0","404.66","2019-09-02","2019-10-14","","1","1");
INSERT INTO contas_receber VALUES("23326","3","2323","1","1","409.42","0","409.42","2019-09-02","2019-08-30","","1","1");
INSERT INTO contas_receber VALUES("23327","507","2325","1","1","220.33","0","220.33","2019-09-02","2019-08-28","","1","1");
INSERT INTO contas_receber VALUES("23328","508","2326","1","1","39.68","0","39.68","2019-09-02","2019-08-28","","1","1");
INSERT INTO contas_receber VALUES("23329","510","2332","1","1","226.32","0","226.32","2019-09-02","2019-09-01","","1","1");
INSERT INTO contas_receber VALUES("23330","32","2340","1","1","65","0","65","2019-09-02","2019-08-31","","1","1");
INSERT INTO contas_receber VALUES("23331","512","2341","1","1","23","0","23","2019-09-02","2019-08-31","","1","1");
INSERT INTO contas_receber VALUES("23352","4","2327","1","1","1237.17","0","1237.17","2019-09-04","2019-10-04","","1","1");
INSERT INTO contas_receber VALUES("23353","4","2327","2","1","1237.17","0","1237.17","2019-09-04","2019-10-19","","1","1");
INSERT INTO contas_receber VALUES("23354","4","2327","3","1","1237.16","0","1237.16","2019-09-04","2019-11-04","","1","1");
INSERT INTO contas_receber VALUES("23357","329","2336","1","1","340.83","0","340.83","2019-09-04","2019-10-04","","1","1");
INSERT INTO contas_receber VALUES("23358","329","2336","4","1","257.5","0","257.5","2019-09-04","2019-11-14","","1","1");
INSERT INTO contas_receber VALUES("23359","329","2336","3","1","340.84","0","340.84","2019-09-04","2019-11-04","","1","1");
INSERT INTO contas_receber VALUES("23360","329","2336","2","1","340.83","0","340.83","2019-09-04","2019-10-19","","1","1");
INSERT INTO contas_receber VALUES("23365","20","2333","1","1","394.65","0","394.65","2019-09-04","2019-10-05","","1","1");
INSERT INTO contas_receber VALUES("23366","20","2333","3","1","394.65","0","394.65","2019-09-04","2019-11-05","","1","1");
INSERT INTO contas_receber VALUES("23367","20","2333","2","1","394.65","0","394.65","2019-09-04","2019-10-20","","1","1");
INSERT INTO contas_receber VALUES("23372","221","2328","2","1","1086.27","0","1086.27","2019-09-04","2019-10-19","","1","1");
INSERT INTO contas_receber VALUES("23373","221","2328","1","1","1086.27","0","1086.27","2019-09-04","2019-10-04","","1","1");
INSERT INTO contas_receber VALUES("23374","221","2328","3","1","1086.26","0","1086.26","2019-09-04","2019-11-04","","1","1");
INSERT INTO contas_receber VALUES("23375","3","2352","1","1","31.48","0","31.48","2019-09-04","2019-09-06","","1","1");
INSERT INTO contas_receber VALUES("23391","511","2335","1","1","1753.8","0","1753.8","2019-09-05","2019-08-30","","1","1");
INSERT INTO contas_receber VALUES("23392","25","2334","2","1","1026.02","0","1026.02","2019-09-05","2019-10-20","","1","1");
INSERT INTO contas_receber VALUES("23393","25","2334","1","1","1026.02","0","1026.02","2019-09-05","2019-09-05","","1","1");
INSERT INTO contas_receber VALUES("23394","25","2334","3","1","1026.01","0","1026.01","2019-09-05","2019-11-05","","1","1");
INSERT INTO contas_receber VALUES("23415","494","2350","1","1","2120","0","2120","2019-09-05","2019-10-21","","1","1");
INSERT INTO contas_receber VALUES("23416","498","2357","1","1","47.26","0","47.26","2019-09-05","2019-09-07","","1","1");
INSERT INTO contas_receber VALUES("23417","419","2337","1","1","491.33","0","491.33","2019-09-06","2019-10-06","","1","1");
INSERT INTO contas_receber VALUES("23418","419","2337","2","1","491.33","0","491.33","2019-09-06","2019-10-21","","1","1");
INSERT INTO contas_receber VALUES("23419","419","2337","3","1","491.34","0","491.34","2019-09-06","2019-11-06","","1","1");
INSERT INTO contas_receber VALUES("23420","86","2338","1","1","400.33","0","400.33","2019-09-06","2019-10-06","","1","1");
INSERT INTO contas_receber VALUES("23421","86","2338","2","1","400.33","0","400.33","2019-09-06","2019-10-21","","1","1");
INSERT INTO contas_receber VALUES("23422","86","2338","3","1","400.34","0","400.34","2019-09-06","2019-11-06","","1","1");
INSERT INTO contas_receber VALUES("23423","385","2342","1","1","472.33","0","472.33","2019-09-06","2019-10-06","","1","1");
INSERT INTO contas_receber VALUES("23424","385","2342","3","1","472.34","0","472.34","2019-09-06","2019-11-06","","1","1");
INSERT INTO contas_receber VALUES("23425","385","2342","2","1","472.33","0","472.33","2019-09-06","2019-10-21","","1","1");
INSERT INTO contas_receber VALUES("23426","94","2345","2","1","387.66","0","387.66","2019-09-06","2019-10-21","","1","1");
INSERT INTO contas_receber VALUES("23427","94","2345","3","1","387.66","0","387.66","2019-09-06","2019-11-06","","1","1");
INSERT INTO contas_receber VALUES("23428","94","2345","4","1","387.68","0","387.68","2019-09-06","2019-11-21","","1","1");
INSERT INTO contas_receber VALUES("23429","94","2345","1","1","387.66","0","387.66","2019-09-06","2019-10-06","","1","1");
INSERT INTO contas_receber VALUES("23430","270","2349","1","1","382.5","0","382.5","2019-09-06","2019-09-05","","1","1");
INSERT INTO contas_receber VALUES("23445","21","2344","1","1","882.7","0","882.7","2019-09-09","2019-10-06","","1","1");
INSERT INTO contas_receber VALUES("23446","21","2344","2","1","882.7","0","882.7","2019-09-09","2019-10-16","","1","1");
INSERT INTO contas_receber VALUES("23447","21","2344","3","1","882.7","0","882.7","2019-09-09","2019-10-26","","1","1");
INSERT INTO contas_receber VALUES("23448","21","2344","4","1","882.7","0","882.7","2019-09-09","2019-11-06","","1","1");
INSERT INTO contas_receber VALUES("23449","65","2343","1","1","684.67","0","684.67","2019-09-09","2019-10-06","","1","1");
INSERT INTO contas_receber VALUES("23450","65","2343","3","1","684.66","0","684.66","2019-09-09","2019-11-06","","1","1");
INSERT INTO contas_receber VALUES("23451","65","2343","2","1","684.67","0","684.67","2019-09-09","2019-10-21","","1","1");
INSERT INTO contas_receber VALUES("23452","31","2355","2","1","432.59","0","432.59","2019-09-09","2019-10-09","","1","1");
INSERT INTO contas_receber VALUES("23453","31","2355","1","1","432.59","0","432.59","2019-09-09","2019-09-24","","1","1");
INSERT INTO contas_receber VALUES("23454","31","2355","3","1","432.59","0","432.59","2019-09-09","2019-10-24","","1","1");
INSERT INTO contas_receber VALUES("23455","31","2355","4","1","432.58","0","432.58","2019-09-09","2019-11-09","","1","1");
INSERT INTO contas_receber VALUES("23501","455","2366","1","1","2596.67","2596.67","0","2019-09-10","2019-09-11","","0","0");
INSERT INTO contas_receber VALUES("23502","455","2366","2","1","2596.67","2596.67","0","2019-09-10","2019-10-12","","0","0");
INSERT INTO contas_receber VALUES("23503","455","2366","3","1","2596.66","2596.66","0","2019-09-10","2019-11-12","","0","0");
INSERT INTO contas_receber VALUES("23512","316","2347","1","1","418.04","0","418.04","2019-09-11","2019-10-09","","1","1");
INSERT INTO contas_receber VALUES("23513","316","2347","2","1","418.04","0","418.04","2019-09-11","2019-10-16","","1","1");
INSERT INTO contas_receber VALUES("23514","316","2347","3","1","418.04","0","418.04","2019-09-11","2019-10-30","","1","1");
INSERT INTO contas_receber VALUES("23518","292","2368","1","1","5259.17","5259.17","0","2019-09-11","2019-09-13","","0","0");
INSERT INTO contas_receber VALUES("23519","292","2368","2","1","5259.17","5259.17","0","2019-09-11","2019-10-14","","0","0");
INSERT INTO contas_receber VALUES("23520","292","2368","3","1","5259.16","5259.16","0","2019-09-11","2019-11-14","","0","0");
INSERT INTO contas_receber VALUES("23521","70","2361","1","1","599.55","0","599.55","2019-09-11","2019-09-25","","1","1");
INSERT INTO contas_receber VALUES("23522","70","2361","2","1","599.55","0","599.55","2019-09-11","2019-09-25","","1","1");
INSERT INTO contas_receber VALUES("23527","489","2346","1","1","101.35","0","101.35","2019-09-11","2019-09-04","","1","1");
INSERT INTO contas_receber VALUES("23528","4","2348","1","1","1295.67","0","1295.67","2019-09-11","2019-10-09","","1","1");
INSERT INTO contas_receber VALUES("23529","4","2348","3","1","1295.66","0","1295.66","2019-09-11","2019-11-09","","1","1");
INSERT INTO contas_receber VALUES("23530","4","2348","2","1","1295.67","0","1295.67","2019-09-11","2019-10-24","","1","1");
INSERT INTO contas_receber VALUES("23531","504","2351","1","1","175","0","175","2019-09-11","2019-09-07","","1","1");
INSERT INTO contas_receber VALUES("23532","59","2353","1","1","544.27","0","544.27","2019-09-11","2019-10-10","","1","1");
INSERT INTO contas_receber VALUES("23533","59","2353","2","1","544.27","0","544.27","2019-09-11","2019-10-25","","1","1");
INSERT INTO contas_receber VALUES("23534","59","2353","3","1","544.26","0","544.26","2019-09-11","2019-11-10","","1","1");
INSERT INTO contas_receber VALUES("23536","190","2356","1","1","85.61","0","85.61","2019-09-11","2019-09-07","","1","1");
INSERT INTO contas_receber VALUES("23537","380","2362","1","1","336.45","0","336.45","2019-09-11","2019-10-12","","1","1");
INSERT INTO contas_receber VALUES("23538","380","2362","2","1","336.45","0","336.45","2019-09-11","2019-10-27","","1","1");
INSERT INTO contas_receber VALUES("23539","380","2362","3","1","336.44","0","336.44","2019-09-11","2019-11-12","","1","1");
INSERT INTO contas_receber VALUES("23540","3","2365","1","1","99.2","0","99.2","2019-09-11","2019-09-12","","1","1");
INSERT INTO contas_receber VALUES("23561","212","2359","2","1","607","0","607","2019-09-12","2019-10-27","","1","1");
INSERT INTO contas_receber VALUES("23562","212","2359","1","1","607","0","607","2019-09-12","2019-10-12","","1","1");
INSERT INTO contas_receber VALUES("23563","212","2359","3","1","607","0","607","2019-09-12","2019-11-12","","1","1");
INSERT INTO contas_receber VALUES("23564","455","2363","2","1","770.15","0","770.15","2019-09-12","2019-11-01","","1","1");
INSERT INTO contas_receber VALUES("23565","455","2363","1","1","770.15","0","770.15","2019-09-12","2019-10-12","","1","1");
INSERT INTO contas_receber VALUES("23566","455","2363","3","1","770.14","0","770.14","2019-09-12","2019-11-21","","1","1");
INSERT INTO contas_receber VALUES("23567","67","2364","2","1","496.93","496.93","0","2019-09-12","2019-10-28","","0","0");
INSERT INTO contas_receber VALUES("23568","67","2364","1","1","496.93","496.93","0","2019-09-12","2019-10-13","","0","0");
INSERT INTO contas_receber VALUES("23569","67","2364","3","1","496.94","496.94","0","2019-09-12","2019-11-13","","0","0");
INSERT INTO contas_receber VALUES("23570","368","2354","1","1","148.8","0","148.8","2019-09-12","2019-09-07","","1","1");
INSERT INTO contas_receber VALUES("23573","3","2373","1","1","110.76","0","110.76","2019-09-13","2019-09-14","","1","1");
INSERT INTO contas_receber VALUES("23580","25","2358","1","1","661.87","0","661.87","2019-09-13","2019-10-13","","1","1");
INSERT INTO contas_receber VALUES("23581","25","2358","2","1","661.87","0","661.87","2019-09-13","2019-10-28","","1","1");
INSERT INTO contas_receber VALUES("23582","25","2358","3","1","661.86","0","661.86","2019-09-13","2019-11-13","","1","1");
INSERT INTO contas_receber VALUES("23583","381","2369","1","1","1636.5","0","1636.5","2019-09-13","2019-09-26","","1","1");
INSERT INTO contas_receber VALUES("23603","62","2370","1","1","375.1","0","375.1","2019-09-16","2019-10-17","","1","1");
INSERT INTO contas_receber VALUES("23604","62","2370","3","1","375.52","0","375.52","2019-09-16","2019-11-17","","1","1");
INSERT INTO contas_receber VALUES("23605","62","2370","2","1","493","0","493","2019-09-16","2019-11-01","","1","1");
INSERT INTO contas_receber VALUES("23612","513","2367","1","1","60.84","0","60.84","2019-09-16","2019-09-13","","1","1");
INSERT INTO contas_receber VALUES("23613","514","2371","1","1","208","0","208","2019-09-16","2019-10-16","","1","1");
INSERT INTO contas_receber VALUES("23614","439","2379","1","1","169.74","0","169.74","2019-09-16","2019-09-18","","1","1");
INSERT INTO contas_receber VALUES("23639","485","2376","1","1","1962.4","0","1962.4","2019-09-16","2019-09-16","","1","1");
INSERT INTO contas_receber VALUES("23640","310","2374","3","1","998","0","998","2019-09-16","2019-11-17","","1","1");
INSERT INTO contas_receber VALUES("23641","310","2374","2","1","998","0","998","2019-09-16","2019-11-01","","1","1");
INSERT INTO contas_receber VALUES("23642","310","2374","1","1","998","0","998","2019-09-16","2019-10-17","","1","1");
INSERT INTO contas_receber VALUES("23652","485","2384","1","1","875.5","875.5","0","2019-09-17","2019-09-18","","0","0");
INSERT INTO contas_receber VALUES("23664","5","2380","1","1","410.03","0","410.03","2019-09-17","2019-10-17","","1","1");
INSERT INTO contas_receber VALUES("23665","5","2380","2","1","410.03","0","410.03","2019-09-17","2019-11-01","","1","1");
INSERT INTO contas_receber VALUES("23666","5","2380","3","1","410.04","0","410.04","2019-09-17","2019-11-17","","1","1");
INSERT INTO contas_receber VALUES("23674","3","2388","1","1","134.45","134.45","0","2019-09-17","2019-09-18","","0","0");
INSERT INTO contas_receber VALUES("23679","229","2382","1","1","790.1","0","790.1","2019-09-17","2019-10-18","","1","1");
INSERT INTO contas_receber VALUES("23680","229","2382","3","1","790.1","0","790.1","2019-09-17","2019-12-18","","1","1");
INSERT INTO contas_receber VALUES("23681","229","2382","2","1","790.1","0","790.1","2019-09-17","2019-11-18","","1","1");
INSERT INTO contas_receber VALUES("23684","402","2378","1","1","386.6","0","386.6","2019-09-18","2019-10-18","","1","1");
INSERT INTO contas_receber VALUES("23685","161","2381","1","1","925.45","0","925.45","2019-09-18","2019-10-13","","1","1");
INSERT INTO contas_receber VALUES("23686","161","2381","2","1","925.45","0","925.45","2019-09-18","2019-11-03","","1","1");
INSERT INTO contas_receber VALUES("23687","435","2377","1","1","1203.2","0","1203.2","2019-09-18","2019-09-30","","1","1");
INSERT INTO contas_receber VALUES("23714","3","2393","1","1","134.45","0","134.45","2019-09-18","2019-09-19","","1","1");
INSERT INTO contas_receber VALUES("23715","255","2383","1","1","1221.79","0","1221.79","2019-09-18","2019-10-04","","1","1");
INSERT INTO contas_receber VALUES("23717","427","2394","1","1","191.28","191.28","0","2019-09-18","2019-09-19","","0","0");
INSERT INTO contas_receber VALUES("23732","35","2372","1","1","124","0","124","2019-09-19","2019-10-17","","1","1");
INSERT INTO contas_receber VALUES("23733","336","2391","1","1","400.17","0","400.17","2019-09-19","2019-10-19","","1","1");
INSERT INTO contas_receber VALUES("23734","336","2391","3","1","400.16","0","400.16","2019-09-19","2019-11-19","","1","1");
INSERT INTO contas_receber VALUES("23735","336","2391","2","1","400.17","0","400.17","2019-09-19","2019-11-03","","1","1");
INSERT INTO contas_receber VALUES("23736","84","2386","1","1","1008.93","0","1008.93","2019-09-19","2019-10-20","","1","1");
INSERT INTO contas_receber VALUES("23737","84","2386","3","1","1008.93","0","1008.93","2019-09-19","2019-11-20","","1","1");
INSERT INTO contas_receber VALUES("23738","84","2386","4","1","186.23","0","186.23","2019-09-19","2019-10-28","","1","1");
INSERT INTO contas_receber VALUES("23739","84","2386","2","1","1008.93","0","1008.93","2019-09-19","2019-11-04","","1","1");
INSERT INTO contas_receber VALUES("23782","33","2375","1","1","676.3","0","676.3","2019-09-19","2019-10-03","","1","1");
INSERT INTO contas_receber VALUES("23783","33","2375","2","1","676.3","0","676.3","2019-09-19","2019-10-03","","1","1");
INSERT INTO contas_receber VALUES("23812","499","2397","1","1","171","0","171","2019-09-20","2019-09-21","","1","1");
INSERT INTO contas_receber VALUES("23813","515","2392","1","1","896.63","0","896.63","2019-09-20","2019-10-20","","1","1");
INSERT INTO contas_receber VALUES("23814","515","2392","3","1","896.63","0","896.63","2019-09-20","2019-11-20","","1","1");
INSERT INTO contas_receber VALUES("23815","515","2392","4","1","896.61","0","896.61","2019-09-20","2019-12-05","","1","1");
INSERT INTO contas_receber VALUES("23816","515","2392","2","1","896.63","0","896.63","2019-09-20","2019-11-04","","1","1");
INSERT INTO contas_receber VALUES("23873","3","2406","1","1","177.07","0","177.07","2019-09-20","2019-09-21","","1","1");
INSERT INTO contas_receber VALUES("23901","4","2396","1","1","1277.5","0","1277.5","2019-09-23","2019-10-23","","1","1");
INSERT INTO contas_receber VALUES("23902","4","2396","2","1","1277.5","0","1277.5","2019-09-23","2019-11-07","","1","1");
INSERT INTO contas_receber VALUES("23903","4","2396","3","1","1277.5","0","1277.5","2019-09-23","2019-11-23","","1","1");
INSERT INTO contas_receber VALUES("23904","180","2395","1","1","468.21","0","468.21","2019-09-23","2019-10-23","","1","1");
INSERT INTO contas_receber VALUES("23905","180","2395","3","1","468.21","0","468.21","2019-09-23","2019-11-23","","1","1");
INSERT INTO contas_receber VALUES("23906","180","2395","4","1","468.22","0","468.22","2019-09-23","2019-12-06","","1","1");
INSERT INTO contas_receber VALUES("23907","180","2395","2","1","468.21","0","468.21","2019-09-23","2019-11-07","","1","1");
INSERT INTO contas_receber VALUES("23908","23","2398","1","1","541.24","0","541.24","2019-09-23","2019-10-24","","1","1");
INSERT INTO contas_receber VALUES("23909","23","2398","7","1","316","0","316","2019-09-23","2019-11-07","","1","1");
INSERT INTO contas_receber VALUES("23910","23","2398","2","1","541.24","0","541.24","2019-09-23","2019-11-03","","1","1");
INSERT INTO contas_receber VALUES("23911","23","2398","5","1","541.24","0","541.24","2019-09-23","2019-12-03","","1","1");
INSERT INTO contas_receber VALUES("23912","23","2398","4","1","541.24","0","541.24","2019-09-23","2019-11-23","","1","1");
INSERT INTO contas_receber VALUES("23913","23","2398","3","1","541.24","0","541.24","2019-09-23","2019-11-13","","1","1");
INSERT INTO contas_receber VALUES("23914","23","2398","6","1","316","0","316","2019-09-23","2019-10-29","","1","1");
INSERT INTO contas_receber VALUES("23916","423","2410","1","1","97.42","97.42","0","2019-09-23","2019-09-24","","0","0");
INSERT INTO contas_receber VALUES("23921","494","2385","1","1","1428","0","1428","2019-09-23","2019-11-04","","1","1");
INSERT INTO contas_receber VALUES("23924","478","2387","1","1","297.4","0","297.4","2019-09-23","2019-09-21","","1","1");
INSERT INTO contas_receber VALUES("23925","375","2390","1","1","359","0","359","2019-09-23","2019-09-20","","1","1");
INSERT INTO contas_receber VALUES("23926","380","2400","1","1","773.67","0","773.67","2019-09-24","2019-10-24","","1","1");
INSERT INTO contas_receber VALUES("23927","380","2400","2","1","773.67","0","773.67","2019-09-24","2019-11-08","","1","1");
INSERT INTO contas_receber VALUES("23928","380","2400","3","1","773.66","0","773.66","2019-09-24","2019-11-24","","1","1");
INSERT INTO contas_receber VALUES("23929","47","2401","3","1","508.06","0","508.06","2019-09-24","2019-11-24","","1","1");
INSERT INTO contas_receber VALUES("23930","47","2401","1","1","508.07","0","508.07","2019-09-24","2019-10-24","","1","1");
INSERT INTO contas_receber VALUES("23931","47","2401","2","1","508.07","0","508.07","2019-09-24","2019-11-08","","1","1");
INSERT INTO contas_receber VALUES("23942","13","2360","1","1","141.3","0","141.3","2019-09-24","2019-09-11","","1","1");
INSERT INTO contas_receber VALUES("23985","71","2404","2","1","648.33","0","648.33","2019-09-25","2019-11-09","","1","1");
INSERT INTO contas_receber VALUES("23986","71","2404","1","1","648.33","0","648.33","2019-09-25","2019-10-25","","1","1");
INSERT INTO contas_receber VALUES("23987","71","2404","3","1","648.34","0","648.34","2019-09-25","2019-11-25","","1","1");
INSERT INTO contas_receber VALUES("23988","113","2402","3","1","505.3","0","505.3","2019-09-25","2019-10-16","","1","1");
INSERT INTO contas_receber VALUES("23989","113","2402","1","1","505.3","0","505.3","2019-09-25","2019-10-02","","1","1");
INSERT INTO contas_receber VALUES("23990","113","2402","2","1","505.3","0","505.3","2019-09-25","2019-10-09","","1","1");
INSERT INTO contas_receber VALUES("23991","504","2389","1","1","76","0","76","2019-09-25","2019-09-20","","1","1");
INSERT INTO contas_receber VALUES("24001","517","2415","1","1","205.8","0","205.8","2019-09-25","2019-09-26","","1","1");
INSERT INTO contas_receber VALUES("24002","494","2413","1","1","2026.5","0","2026.5","2019-09-25","2019-09-25","","1","1");
INSERT INTO contas_receber VALUES("24010","323","2409","1","1","403.39","403.39","0","2019-09-25","2019-09-28","","0","0");
INSERT INTO contas_receber VALUES("24011","323","2409","2","1","403.39","403.39","0","2019-09-25","2019-10-29","","0","0");
INSERT INTO contas_receber VALUES("24012","323","2409","3","1","403.38","403.38","0","2019-09-25","2019-11-29","","0","0");
INSERT INTO contas_receber VALUES("24013","263","2405","1","1","612.25","0","612.25","2019-09-26","2019-10-09","","1","1");
INSERT INTO contas_receber VALUES("24014","263","2405","2","1","612.25","0","612.25","2019-09-26","2019-10-09","","1","1");
INSERT INTO contas_receber VALUES("24015","423","2423","1","1","97.42","0","97.42","2019-09-26","2019-09-27","","1","1");
INSERT INTO contas_receber VALUES("24024","344","2403","1","1","1567","0","1567","2019-09-26","2019-10-07","","1","1");
INSERT INTO contas_receber VALUES("24025","344","2403","2","1","3135.4","0","3135.4","2019-09-26","2019-10-07","","1","1");
INSERT INTO contas_receber VALUES("24026","91","2407","2","1","562.3","0","562.3","2019-09-26","2019-11-10","","1","1");
INSERT INTO contas_receber VALUES("24027","91","2407","1","1","562.3","0","562.3","2019-09-26","2019-10-26","","1","1");
INSERT INTO contas_receber VALUES("24028","91","2407","3","1","562.3","0","562.3","2019-09-26","2019-11-26","","1","1");
INSERT INTO contas_receber VALUES("24038","520","2426","1","1","203.18","0","203.18","2019-09-27","2019-09-28","","1","1");
INSERT INTO contas_receber VALUES("24039","44","2399","1","1","725.99","0","725.99","2019-09-27","2019-10-26","","1","1");
INSERT INTO contas_receber VALUES("24040","44","2399","2","1","725.99","0","725.99","2019-09-27","2019-11-10","","1","1");
INSERT INTO contas_receber VALUES("24041","44","2399","3","1","726","0","726","2019-09-27","2019-11-26","","1","1");
INSERT INTO contas_receber VALUES("24042","9","2414","1","1","916.4","0","916.4","2019-09-27","2019-10-27","","1","1");
INSERT INTO contas_receber VALUES("24043","9","2414","3","1","916.4","0","916.4","2019-09-27","2019-12-12","","1","1");
INSERT INTO contas_receber VALUES("24044","9","2414","4","1","916.4","0","916.4","2019-09-27","2019-12-27","","1","1");
INSERT INTO contas_receber VALUES("24045","9","2414","2","1","916.4","0","916.4","2019-09-27","2019-11-27","","1","1");
INSERT INTO contas_receber VALUES("24046","518","2416","1","1","1382.8","0","1382.8","2019-09-27","2019-10-11","","1","1");
INSERT INTO contas_receber VALUES("24059","31","2420","1","1","668.42","0","668.42","2019-09-27","2019-10-30","","1","1");
INSERT INTO contas_receber VALUES("24060","31","2420","2","1","668.42","0","668.42","2019-09-27","2019-11-14","","1","1");
INSERT INTO contas_receber VALUES("24061","31","2420","3","1","668.41","0","668.41","2019-09-27","2019-11-30","","1","1");
INSERT INTO contas_receber VALUES("24122","519","2418","3","1","405.6","0","405.6","2019-09-30","2019-12-01","","1","1");
INSERT INTO contas_receber VALUES("24123","519","2418","1","1","405.6","0","405.6","2019-09-30","2019-11-01","","1","1");
INSERT INTO contas_receber VALUES("24124","519","2418","2","1","405.6","0","405.6","2019-09-30","2019-11-16","","1","1");
INSERT INTO contas_receber VALUES("24125","354","2417","1","1","474.03","0","474.03","2019-09-30","2019-10-30","","1","1");
INSERT INTO contas_receber VALUES("24126","354","2417","3","1","474.04","0","